<?php
	require_once('../../authCAS.php');
	require_once('../../config.inc.php');
	require_once 'functions.php';

	$response = array();
	$sharesInDB = array();	// les partages en bdd

	header('Content-type: application/json');

	// On récupère l'uid du propriétaire et on vérifie sa validité
	$uid = $_SESSION['login'];

	// On récupère les paramètres de la demande par l'application
	$params = json_decode(file_get_contents("php://input"));
	$appli = $params->appli;
	$url = $params->url;
	$key = $params->key;

	// Ouverture d'une connexion sur la DB etherhome
	$mysqli = new mysqli($host, $userSQL, $passSQL, $database, $portSQL);
	if ($mysqli->connect_error) stopErreur("Erreur de connexion SQL : (" . $mysqli->connect_errno . ") -> " . $mysqli->connect_error);

	// on vérifie l'existence du partage
	$result = $mysqli->query ("SELECT shareWith, shareType FROM shares WHERE appli='$appli' AND url='$url'");
	if ($result == false)  stopErreur("Erreur requête SQL : (" . $mysqli->errno .") -> " . $mysqli->error);
	// Charger le tableau en encodant en UTF8 chaque champs sinon la fonction json_encode part en vrille :-)
	while ($ligne = $result->fetch_array(MYSQLI_ASSOC)){
		$d['uid'] = $ligne['shareWith'];
		$d['entpersonprofils'] = ($ligne['shareType'] === '1') ? '(groupe)' : '';
		array_push($sharesInDB, $d);
	}

	$result->close();
	$mysqli->close();

	$conn = ldap_connect('localhost');
	if(!$conn){
		die('Erreur de connection à l\'annuaire');
	}

	$bind = ldap_bind($conn);
	if(!$bind){
		die('Erreur d\'authentification');
	}

	// on cherche des utilisateurs (eleve ou enseignant ou responsable ou administratif) par leur nom ou uid
	// ou des groupe
	// dont cn contient le mot renseigné dans le formulaire
	$filter = '(&(|(cn=*'.$key.'*)(uid=*'.$key.'*)) (|(objectClass=ENTGroupe)(ENTPersonProfils=eleve)(ENTPersonProfils=enseignant)(ENTPersonProfils=responsable)(ENTPersonProfils=administratif)))';

	if($conn){
		$ldapsearch = ldap_search($conn, 'o=gouv,c=fr', $filter, array('*'));
		if(!$ldapsearch){
			$response['state'] = 'danger';
			$response['message'] = 'Erreur lors de la recherche';
			return false;
		}

		$data = ldap_get_entries($conn,$ldapsearch);
		if(!empty($data['count']) && $data['count']>0){
			for ($i=0; $i < $data['count']; $i++) {
				$ligne['cn'] = $data[$i]["cn"][0];
				$ligne['uid'] = ($data[$i]["uid"][0] === null) ? $ligne['cn'] : $data[$i]['uid'][0];	// la personne ou le groupe on veut partager le doc
				$ligne['entpersonprofils'] = ($data[$i]["entpersonprofils"][0] === null) ? '(groupe)' : '';
				$ligne['shareType'] = ($data[$i]["entpersonprofils"][0] === null) ? '1' : '0';

				// on supprime les partages smb, les partages déjà existant en base et l'utilisateur connecté
				if(strpos($ligne["cn"], 'smb') === false && $uid !== $ligne['uid']){
					if(array_search($ligne['uid'], array_column($sharesInDB, 'uid'), true) === false){
						$response['state'] = 'success';
						array_push($response, $ligne);
					}
				}
			}
		}
	}

	echo json_encode($response, true);