//--> Partie métier : services destinés à gérer les pads
angular.module('delegations').factory('methodesDelegations', function($http) {
	//--> Définition de la fabrique de services	
	var factory = {}; 

	//--> Vérification de format de l'id de pad
	factory.verifUid = function(padID) {
		// Ne doit contenir que des caractères autorisés pour un uid
		var regexp = /^[A-Za-z0-9\-\.]*$/;
		return !regexp.test(padID);
	}

	//--> Service de listage des pads
	factory.listeDeleg = function(callback) {
		$http.get("modules/delegations/listDeleg.php").success(function(data,status) {
			callback(data);
		}).error(function(data,status) {
			callback({"erreur" : "Erreur ajax lecture liste des délegations : " + status + " (" + data + ")"});
		});
	}

	//--> Ajout d'une délégation
	factory.ajoutDeleg = function(uid, callback) {
		$http.post("modules/delegations/ajDeleg.php", {"uid": uid}).success(function(data, status) {
			callback(data);
		}).error(function(data,status) {
			callback({"state": "danger", "text" : "Erreur ajax ajout délégation : " + status + " (" + data + ")"});
		});
	}

	//--> Suppression d'une délégation
	factory.suppressionDeleg = function(uid, callback) {
		$http.post("modules/delegations/delDeleg.php", {"uid": uid}).success(function(data, status) {
			callback(data);
		}).error(function(data,status) {
			callback({"state": "danger", "text" : "Erreur ajax suppression délégation : " + status + " (" + data + ")"});
		});
	}

	//--> Retourne la fabrique
	return factory;
});
