//--> Partie métier : services destinés à gérer les calcs
angular.module('ethercalc').factory('methodesEthercalc', function($http) {
	//--> Définition de la fabrique de services	
	var factory = {}; 

	//--> Vérification de format de l'id de calc
	factory.verifNomCalc = function(calcID) {
		// Ne doit contenir que des chiffres et lettres
		var regexp = /^[A-Za-z0-9\-\_]*$/;
		return !regexp.test(calcID);
	}

	//--> Service de listage des calcs
	factory.listCalcs = function(callback) {
		$http.get("modules/ethercalc/listCalcs.php").success(function(data,status) {
			callback(data);
		}).error(function(data,status) {
			callback({"erreur" : "Erreur ajax lecture calcs : " + status + " (" + data + ")"});
		});
	}

	//--> Service de création d'un calc dans la base etherhome
	factory.createCalc = function(calcID, callback) {
		var params = {"calcID": calcID};
		$http.post("modules/ethercalc/createCalc.php", params).success(function(data, status) {
			callback(data);
		}).error(function(data,status) {
			callback({"state": "danger", "text" : "Erreur ajax creation calc : " + status + " (" + data + ")"});
		});
	}

	//--> Service de suppression d'un calcs auprès d'ethercalc grâce à son API : https://github.com/audreyt/ethercalc/blob/master/API.md
	// TODO : Pour l'heure cette solution pose problème, il répond status=201 et data=0K mais ne fait rien, la solution de suppression directe dans le fichier JSON 
	//	(/usr/share/eole/nodejs/ethercalc/dump.json) ne donne rien car la feuille de calcul revient tjs au final.....
	factory.deleteCalcDansEthercalc = function(ethercalcAPI, calcID, callback) {
		$http.delete("https://" + ethercalcAPI + "/_/" + calcID).success(function(data, status) {
			callback(data, status);
		}).error(function(data, status) {
			callback({"state": "danger", "text" : "Erreur ajax suppression calcs dans ethercalc : " + status + " (" + data + ")"});
		});
	}

	//--> Service de suppression d'un calc dans la base etherhome
	factory.deleteCalc = function(calcID, callback) {
		var params = {"calcID": calcID};
		$http.post("modules/ethercalc/deleteCalc.php", params).success(function(data, status) {
			callback(data);
		}).error(function(data,status) {
			callback({"state": "danger", "text" : "Erreur ajax suppression calc : " + status + " (" + data + ")"});
		});
	}

	//--> Service de listage des favoris
	factory.listFavorisCalcs = function(callback) {
		$http.get("modules/ethercalc/listFavorisCalcs.php").success(function(data,status) {
			callback(data);
		}).error(function(data,status) {
			callback({"erreur" : "Erreur ajax lecture favoris des calcs : " + status + " (" + data + ")"});
		});
	}

	//--> Ajout d'un favori calc
	factory.addFavorisCalc = function(favoriUrl, callback) {
		var params = {"favoriUrl": favoriUrl};
		$http.post("modules/ethercalc/addFavorisCalc.php", params).success(function(data, status) {
			callback(data);
		}).error(function(data,status) {
			callback({"state": "danger", "text" : "Erreur ajax ajout favoris calcs : " + status + " (" + data + ")"});
		});
	}

	//--> Suppression d'un favori calc
	factory.deleteFavorisCalc = function(id, callback) {
		var params = {"id": id};
		$http.post("modules/ethercalc/deleteFavorisCalc.php", params).success(function(data, status) {
			callback(data);
		}).error(function(data,status) {
			callback({"state": "danger", "text" : "Erreur ajax suppression favoris calcs : " + status + " (" + data + ")"});
		});
	}

	//--> Service de listage des calcs dans ethercalc
	// On n'utilise pas l'API ethercalc (https://github.com/audreyt/ethercalc/blob/master/API.md) qui pose des soucis pour l'instant
	factory.listCalcsDansEthercalc = function(callback) {
		$http.get("modules/ethercalc/listAllCalcs.php").success(function(data, status) {
			callback(data);
		}).error(function(data, status) {
			callback({"erreur" : "Erreur ajax listage de tout les calcs : " + status + " (" + data + ")"});
		});
	}

	//--> Service de modification de l'utilisateur d'un calc dans la base etherhome
	factory.modifieUtilCalc = function(calcID, proprietaire, callback) {
		var params = {"calcID": calcID, "proprietaire": proprietaire};
		$http.post("modules/ethercalc/modifUserAdminCalc.php", params).success(function(data, status) {
			callback(data);
		}).error(function(data,status) {
			callback({"state": "danger", "text" : "Erreur ajax modification utilisateur calc : " + status + " (" + data + ")"});
		});
	}

	// lister les partages
	factory.listShares = function(uid, appli, callback) {
		var params = {'uid': uid, 'appli': appli};

		$http.post('modules/ethercalc/listShares.php', params).success(function(data,status) {
			callback(data);
		}).error(function(data,status) {
			callback({'state': 'danger', 'text': 'Erreur ajax lecture des calcs partagés : ' + status + ' (' + data + ')'});
		});
	}

	// obtenir les partages
	factory.getUsersGroups = function(key, url, appli, callback) {
		var params = {'key': key, 'url': url, 'appli': appli};
		$http.post('communs/shares/getUsersGroups.php', params).success(function(data, status) {
			callback(data);
		}).error(function(data,status) {
			callback({'state': 'danger', 'text' : 'Erreur ajax : ' + status + ' (' + data + ')'});
		});
	}

	// partager un calc
	factory.shareCalc = function(share, appli, shareWith, shareType, callback) {
		var params = {'nom': share.nom, 'url': share.lien, 'appli': appli, 'shareWith': shareWith, 'shareType': shareType};
		$http.post('modules/ethercalc/share.php', params).success(function(data, status) {
			callback(data);
		}).error(function(data,status) {
			callback({'state': 'danger', 'text' : 'Erreur ajax : ' + status + ' (' + data + ')'});
		});
	}

	// supprimer un partage
	// si cancelSahre vaut true, le propriétaire annule le partage
	factory.deleteShare = function(share, cancelShare, callback) {
		var params = {'cancelShare': cancelShare, 'share': share};
		$http.post('communs/shares/deleteShare.php', params).success(function(data, status) {
			callback(data);
		}).error(function(data,status) {
			callback({'state': 'danger', 'text' : 'Erreur ajax suppression calc : ' + status + ' (' + data + ')'});
		});
	}

	//--> Retourne la fabrique
	return factory;
});
