<?php
	// Vérifie l'authentification
	include_once('../../authCAS.php');

	// Configuration etherhome
	require_once('../../config.inc.php');

	//--> Calcul du profil de l'utilsateur
	include_once("../../profile.inc.php");

	// Tableau de sortie de la réponse
	$response = array();

	// On sort en JSON
	header('Content-type: application/json');

	// On récupère l'uid du propriétaire et on vérifie sa validité
	$uid = $_SESSION['login'];

	// Lecture du profil de l'utilisateur
	$profil = getProfil($host, $userSQL, $passSQL, $database, $portSQL, $admin2);

	// On récupère les paramètres de la demande par l'application
	$params = json_decode(file_get_contents("php://input"));
	$padID = $params->padID;
	
	// Vérification format de l'uid et de l'identifiant de pad
	if  (! (preg_match('/^[A-Za-z0-9\-\.]+$/', $uid) && preg_match('/^[A-Za-z0-9\-\_]+$/', $padID))) stopErreur("Erreur de formatage de l'uid ou padID");

	// Ouverture d'une connexion sur la DB etherhome
	$mysqli = new mysqli($host, $userSQL, $passSQL, $database, $portSQL);
	if ($mysqli->connect_error) stopErreur("Erreur de connexion SQL : (" . $mysqli->connect_errno . ") -> " . $mysqli->connect_error);

	// Vérifie si l'entrée existe bien
	// Requête à la base de données
	if (!$profil["admin"]) $query = "SELECT nom FROM elements WHERE uid='" . addslashes($uid) . "' AND nom='" . addslashes($padID) . "' AND appli='etherpad'";
	// Si on est admin, on retire le verrou de vérification du user (permet de supprimer le pad dans l'intf admin)
	else $query = "SELECT nom FROM elements WHERE nom='" . addslashes($padID) . "' AND appli='etherpad'";
	// Execution
	$result = $mysqli->query ($query);
	if ($result == false)  stopErreur("Erreur requête SQL query : (" . $mysqli->errno .") -> " . $mysqli->error);

	// Si trouvé
	if ($result->num_rows)
	{
		// Si jamais il existe un favoris dans la base des favoris et ce quel que soit l'utilisateur
		$query = "DELETE FROM favoris WHERE url=? AND appli='etherpad'";
		$stmt = $mysqli->prepare($query);
		// Chargement des données
		$stmt->bind_param("s", $v1);
		$v1 = "https://" . $etherpadAPI . "/p/" . $padID;
		// Exécute la requête
		if (!$stmt->execute()) stopErreur("Erreur requête SQL execute : (" . $mysqli->errno .") -> " . $mysqli->error);
		// Fermeture de la requête
		$stmt->close();

		// suppression des partages
		$stmt = $mysqli->prepare("DELETE FROM shares WHERE url=? AND appli='etherpad'");
		// Chargement des données
		$stmt->bind_param("s", $v1);
		$v1 = "https://" . $etherpadAPI . "/p/" . $padID;
		// Exécute la requête
		if (!$stmt->execute()) stopErreur("Erreur requête SQL execute : (" . $mysqli->errno .") -> " . $mysqli->error);
		// Fermeture de la requête
		$stmt->close();

		// On supprime le pads dans la base d'appartenance interne d'etherhome
		if (!$profil["admin"]) $query = "DELETE FROM elements WHERE uid='" . addslashes($uid) . "' AND nom='" . addslashes($padID) . "' AND appli='etherpad'";
		// Si on est admin on sécurise un peu moins pour permettre la suppression vian l'interface admin
		else $query = "DELETE FROM elements WHERE nom='" . addslashes($padID) . "' AND appli='etherpad'";
		// Execution
		if (!$mysqli->query ($query)) stopErreur("Erreur requête SQL delete : (" . $mysqli->errno .") -> " . $mysqli->error);
		// Réponse à afficher dans l'application
		$response['state'] = "success";
		$response['text'] = "Pad '" . $padID . "' supprimé avec succès";
	} 
	else 
	{
		// Si on est un user normal, c'est qu'il n'est pas dans notre liste
		if (!$profil["admin"])
		{
			$response['state'] = "warning";
			$response['text'] = "Impossible de supprimer le pad '" . $padID . "'. Il n'existe pas.";
		}
		// Si on est admin, et que l'on provient de l'interface admin, ça peut être un pad sans utilisateur attitré par etherhome
		else
		{
			$response['state'] = "success";
			$response['text'] = "Pad '" . $padID . "' supprimé avec succès";
		}
	}

	// Fermeture du statement
	$result->close();

	// Fermer connexion SQL
	$mysqli->close();

	// On renvoie la réponse au format JSON
	echo json_encode($response, true);

	// Fonction de retour d'erreur
	function stopErreur($message)
	{	
		// Les erreurs SQL seront remontées à l'application via cette réponse JSON : voir au début de la vue : <div class="alert alert-{{msg.state}}" ng-show="msg.text" role="alert">{{msg.text}}</div>'
		$row['state'] = "danger";
		$row['text'] = $message;
		echo json_encode($row, true);
		// On sort ici
		exit;
	}
?>
