//--> Contrôleur de gestion des pads : relatif à la page .......(voir routage)
angular.module('etherpad').controller("etherpadCtrl",function($scope, $window, methodesEtherpad, $location) {
	// Remarque : le controleur est relu à chaque nouvelle arrivée sur le module
	
	$scope.appli = $location.path().split('/')[1];

	//--> Fonction de vérification de saisie du nom du pad, invalidant le bouton de submit ('ng-disabled="testNomPad()"') tant que la saisie ne réponds pas à cette regex
	$scope.testNomPad = function() {
		return methodesEtherpad.verifNomPad($scope.ajout.padID);
	};

	//--> Getter de la liste des pads appartenant à l'utilisateur pour '<tr ng-repeat="pad in listePads">'
	$scope.getListPads = function(){
		// La lecture de la liste des pads étant asynchrone (ajax), il faut spécifier une fonction de retour (callback)
		methodesEtherpad.listPads(function(data) { 
			$scope.listePads = data;
		});
	};

	//--> Récupère la liste de tout les pads dans etherpad (quel que soit l'utilisateur)
	$scope.getListAllPads = function(){
		// La lecture de la liste des pads étant asynchrone (ajax), il faut spécifier une fonction de retour (callback)
		methodesEtherpad.listPadsDansEtherpad(function(data) {
			$scope.listAllPads = data;
		});
	};

	//--> Méthode appelée pour la création d'un pad
	$scope.addPad = function() {
		// Nettoyer l'affichage resultat des traitements précedent :
		$scope.ajPad = {};
		$scope.delPad = {};
		$scope.ajDelFavPad = {};
		// On ne peux fonctionner que si la liste de tout les pads est bien dsponible
		if (angular.isDefined($scope.listAllPads.erreur)) $scope.ajPad = {"state": "danger", "text": "Impossible car liste des pads indisponible."};
		else {
			// Si le champ n'existe pas, on le créé vide
			if (angular.isUndefined($scope.ajout.padID)) $scope.ajout = {"padID" : ""};
			// On va déjà vérifier qu'il n'existe pas dans etherpad si ce n'est pas vide
			var exist = false;
			if ($scope.ajout.padID != "") {
				for (var i=0 ; i<$scope.listAllPads.length ; i++) if ($scope.listAllPads[i].key == $scope.ajout.padID) exist=true;
			}
			// Si il existe, on le signale et on demande si on veut le mettre en favoris
			if (exist) {
				$scope.ajPad = {"state": "warning", "text": "Ce pad existe déjà dans l'application etherpad"};
				questionAjoutFavoris();	
			}
			// Sinon, on demande la création au service de création dans la base etherhome
			else {
				// On va demander au service concerné d'ajouter le pad dans la base etherhome et nous fournir l'id calculé (si padID était vide)
				methodesEtherpad.createPad($scope.ajout.padID, function(data) {
					// Récupère les données
					$scope.ajPad = data;
					// Si le pad existe déjà pour l'utilisateur, on va demander un passage en favoris
					if ($scope.ajPad.state == "warning") questionAjoutFavoris();			
					// Si le resultat est valide, on va tout recharger
					if ($scope.ajPad.state == "success")
					{
						// Et on ouvre le nouveau pad, ce qui va avoir pour effet de le créer
						$window.open('https://' + $scope.conf.etherpadAPI + '/p/' + $scope.ajPad.create, '_blank');
						// ReCharger la liste des pads de l'utilisateur dans etherhome
						$scope.getListPads();
						// ReCharger la liste de tout les pads dans etherpad
						$scope.getListAllPads();
						// Recharger la liste des favoris des pads
						$scope.getListFavorisPads();
						// On retourne à la page de liste
						$scope.newDiv = false;
					}
				});
			}
		}
	};

	//--> Méthode privé permettant de demander si on veut mettre le pad en favoris en cas d'echec ajout (existe déjà dans etherpad) ou appartient à l'utilisateur
	var questionAjoutFavoris = function () {
		// On demande confirmation d'ajout
		if (confirm("Ce pad existe déjà, voulez-vous le mettre en favoris ?")) {
			// Nettoyer l'affichage resultat des traitements précedent :
			$scope.ajPad = {};
			$scope.delPad = {};
			$scope.ajDelFavPad = {};
			// Envoi de la requête de supression : attention, le paramètre est passé avant la fonction de callback
			methodesEtherpad.addFavorisPad('https://' + $scope.conf.etherpadAPI + '/p/' + $scope.ajout.padID, function(data) {
				$scope.ajDelFavPad = data;
				// Recharger la liste des favoris des pads
				$scope.getListFavorisPads();
				// On retourne à la page de liste
				$scope.newDiv = false;
			});
		}
	};

	//--> Fonction appelée par le bouton supprimer un pads : '<button class="btn btn-danger btn-xs" ng-click="deletePad(pad.id);">Supprimer</button>'
	$scope.deletePad = function(padID) {
		// Nettoyer l'affichage resultat des traitements précedent :
		$scope.ajPad = {};
		$scope.delPad = {};
		$scope.ajDelFavPad = {};
		// Suppression sur confirmation
		var r = confirm("Êtes vous sûr de vouloir supprimer ce pad ?");
		if (r) {
			// Envoi de la requête de supression dans l'API etherpad qui va réaliser la suppression réelle du pads
			methodesEtherpad.deletePadDansEtherpad($scope.conf.etherpadAPI, $scope.conf.apikey, padID, function(data) {
				if (data.message == "ok" || data.message === 'padID does not exist') {	//supprimer de la bdd un pad qui n'existe plus dans etherpad
					// Si c'est ok, alors demander d'effacer dans la base de données interne d'etherhome
					methodesEtherpad.deletePad(padID, function(data) {
						$scope.delPad = data;
						// Recharger la liste des pads
						$scope.getListPads();
						// Charger la liste de tout les pads dans etherpad
						$scope.getListAllPads();
						// Recharger la liste des favoris des pads
						$scope.getListFavorisPads();
						// Recharger la liste des partages des calcs
						$scope.getListShares();
					});
				}
				// Si la suppression par l'API Etherpad échoue, on va retourner le message
				else {
					// Cas d'un message d'erreur interne retourné par l'API etherpad
					if (angular.isUndefined(data.state)) $scope.delPad = {"state": "danger", "text" : "Erreur suppression du pad par etherpad (code=" + data.code + " ; message=" + data.message +" ; data=" + data.data + ")"};
					// Cas de l'erreur AJAX pure, traitement du .error(....) on a directement un message formaté
					else $scope.delPad = data;
				}
			});
		}
	};

	//--> Fonction de test pour la saisie d'un nouveau favoris invalidant le bouton submit : <button type="submit" class="btn btn-success" ng-click='addFavoriPads()' ng-disabled="testURLFavoriPads()">Ajouter le favori</button>
	$scope.testURLFavoriPads = function() {
		// Créer la chaine d'expression régulière afin de lui adjoindre l'adresse du serveur
		var domain = "^https:\\/\\/" + $scope.conf.etherpadAPI.replace(/\./g, "\\.").replace(/\//g , "\\/") + "\\/p\\/[A-Za-z0-9\\-\\_]+$";
		var regexp = new RegExp(domain);
		// Test de la chaine saisie avec l'expression régulière
		return !regexp.test($scope.favoriUrl);
	};

	//--> Getter de la liste des favoris des pads pour '<tr ng-repeat="favori in listeFavorisPads">'
	$scope.getListFavorisPads = function() {
		// La lecture de la liste des pads étant asynchrone (ajax), il faut spécifier une fonction de retour (callback)
		methodesEtherpad.listFavorisPads(function(data) { 
			$scope.listeFavorisPads = data;
		});
	};

	//--> Fonction appelée par le bouton ajouter un favoris de pad
	$scope.addFavorisPad = function() {
		// Nettoyer l'affichage resultat des traitements précedent :
		$scope.ajPad = {};
		$scope.delPad = {};
		$scope.ajDelFavPad = {};
		// Envoi de la requête de supression : attention, le paramètre est passé avant la fonction de callback
		methodesEtherpad.addFavorisPad($scope.favoriUrl, function(data) {
			$scope.ajDelFavPad = data;
			// Recharger la liste des favoris des pads
			$scope.getListFavorisPads();
		});
	};

	//--> Fonction appelée par le bouton supprimer d'un favoris de pad
	$scope.deleteFavoriPad = function(id){
		// Nettoyer l'affichage resultat des traitements précedent :
		$scope.ajPad = {};
		$scope.delPad = {};
		$scope.ajDelFavPad = {};
		// Suppression sur confirmation
		var r = confirm("Êtes vous sûr de vouloir supprimer ce favori ?");
		if (r) {
			// Envoi de la requête de supression : attention, le paramètre est passé avant la fonction de callback
			methodesEtherpad.deleteFavorisPad(id, function(data) {
				$scope.ajDelFavPad = data;
				// Recharger la liste des favoris
				$scope.getListFavorisPads();
			});
		}
	};

	//--> Changement de div 
	$scope.toggleNew = function () {
		$scope.newDiv =! $scope.newDiv;
	}

	// lister les partages
	// si uid, on liste les docs partagés par l'utilisateur
	$scope.getListShares = function(uid) {
		$scope.share = {};
		$scope.shareWithOther = false;
		if(typeof uid !== 'undefined'){
			$scope.shareWithOther = true;
			$scope.uid = uid;
		}
		methodesEtherpad.listShares(uid, $scope.appli, function(data) { 
			$scope.listShares = data;
		});
	};

	// lister les utilisateurs et groupes
	// on attend la fin de la frappe pour envoyer la requête au serveur
	var timeout = null;
	var textInput = document.getElementById('shareWith');
	$scope.getUsersGroups = function() {
		clearTimeout(timeout);

		timeout = setTimeout(function () {
			// Nettoyer l'affichage resultat des traitements précedent :
			$scope.usersGroups = {};
			$scope.share = {};

			if(textInput.value !== ''){
				methodesEtherpad.getUsersGroups(textInput.value, $scope.element.lien, $scope.appli, function(data) {
					if (data.state === 'success') {
						$scope.usersGroups = data;
					}
					else {
						$scope.usersGroups = {'state': 'danger', 'message' : 'Pas d\'utilisateur ou de groupe trouvé'};
					}
				});
			}
		}, 1000);
	};

	// partager un pad
	$scope.sharePad = function(share, shareWith, shareType) {
		$scope.share = {};
		// Suppression sur confirmation
		methodesEtherpad.sharePad(share, $scope.appli, shareWith, shareType, function(data) {
			$scope.share = {'state': data.state, 'text': data.text };
			$scope.getUsersGroups();
		});
	};

	// supprimer un partage
	// si cancelSahre vaut true, le propriétaire annule le partage
	$scope.deleteShare = function(share, cancelShare){
		// Nettoyer l'affichage resultat des traitements précedent :
		$scope.ajShare = {};
		$scope.delShare = {};
		$scope.ajDelShare = {};

		var title = (typeof cancelShare !== 'undefined') ? 'annuler' : 'supprimer';
		// Suppression sur confirmation
		var r = confirm('Êtes vous sûr de vouloir ' + title + ' ce partage ?');
		if (r) {
			// Envoi de la requête de supression : attention, le paramètre est passé avant la fonction de callback
			methodesEtherpad.deleteShare(share, cancelShare, function(data) {
				$scope.ajDelShare = data;
				$scope.getListPads();
				// Recharger la liste des partages
				$scope.getListShares($scope.uid);
			});
		}
	};

	//--> Chargement au démarrage du contôleur :
	// Gestion de l'affichage au passage de la souris pour les étapes : le handlerPad est défini dans assets/js/presentation.js
	Zepto("#padID").focusin(Zepto.proxy(handlerPad,Zepto("div.etap-step:first-child")));
	Zepto("div.etap-step").mouseenter(handlerPad);
	Zepto("div.etap-step").mouseleave(function(){Zepto(this).removeClass("active");});

	// Déclaration du formuliaire d'ajout vide
	$scope.ajout = {};
	// div affichée par défaut
	$scope.newDiv = false;

	// Charger la liste des pads de l'utilisateur dans etherhome
	$scope.getListPads();
	// Charger la liste de tout les pads dans etherpad
	$scope.getListAllPads();
	// Charger la liste des favoris des pads
	$scope.getListFavorisPads();
	// Charger la liste des pads partagés
	$scope.getListShares();

});
