<?php
	// Vérifie l'authentification
	include_once('../../authCAS.php');

	// Configuration etherhome
	require_once('../../config.inc.php');

	// Tableau de sortie
	$myArray = array();
	$sharesWith = array();	// les personnes avec qui le scrum est partagé

	// On sort en JSON
	header('Content-type: application/json');

	// On récupère l'uid du propriétaire et on vérifie sa validité
	$uid = $_SESSION['login'];
	if  (!preg_match('/^[A-Za-z0-9\-\.]+$/',$uid)) stopErreur("Erreur de formatage de l'uid");

	// Ouverture d'une connexion sur la DB etherhome
	$mysqli = new mysqli($host, $userSQL, $passSQL, $database, $portSQL);
	if ($mysqli->connect_error) stopErreur("Erreur de connexion SQL : (" . $mysqli->connect_errno . ") -> " . $mysqli->connect_error);

	// Requête à la base de données
	$result = $mysqli->query ("SELECT nom, appli FROM elements WHERE uid='" . addslashes($uid) . "' AND appli='etherpad'");
	if ($result == false)  stopErreur("Erreur requête SQL : (" . $mysqli->errno .") -> " . $mysqli->error);

	// les partages
	$shareWith = $mysqli->query("SELECT id, uid, url, appli, GROUP_CONCAT(shareWith SEPARATOR ', ') AS shareWith FROM shares WHERE uid='" . addslashes($uid) . "' AND appli='etherpad' AND shareType!='2' GROUP BY url");
	while($ligne = $shareWith->fetch_array(MYSQLI_ASSOC)){
		// Récupère le padID dans l'adresse
		$splitted = explode("/",$ligne['url']);
		$ligne['padID'] = $splitted[4];
		array_push($sharesWith, $ligne);
	}

	// Charger le tableau en encodant en UTF8 chaque champs sinon la fonction json_encode part en vrille :-)
	while ($ligne = $result->fetch_array(MYSQLI_ASSOC))
	{
		foreach(array_keys($ligne) as $key) $ligne[$key] = utf8_encode($ligne[$key]);
		$ligne['lien'] = "https://$etherpadAPI/p/" . $ligne["nom"];
		// on cherche les personnes avec qui le doc est partagé
		if ($shareWith->num_rows > 0){
		// Charger le tableau en encodant en UTF8 chaque champs sinon la fonction json_encode part en vrille :-)
			foreach ($sharesWith as $key => $value) {
				if($ligne['appli'] === $value['appli'] && $ligne['lien'] === $value['url']){
					$ligne['shareWith'] = $value['shareWith'];
					$ligne['id'] = $value['id'];	// id du partage
				}
			}
		}
		array_push($myArray, $ligne);
	}

	// Fermeture du statement
	$result->close();

	// Fermer connexion SQL
	$mysqli->close();

	// Retourne la liste en format JSON
	echo json_encode($myArray, true);

	// Fonction de retour d'erreur
	function stopErreur($message)
	{
		// Les erreurs seront remontées à l'application via cette réponse JSON : voir au début de la vue : '<div class="erreur" ng-show="listPads.erreur">{{listPads.erreur}}</div>'
		$row['erreur'] = $message;
		echo json_encode($row, true);
		// On sort ici
		exit;
	}
?>
