<?php
	require_once('../../authCAS.php');
	require_once('../../config.inc.php');

	$response = array();

	header('Content-type: application/json');

	$uid = $_SESSION['login'];

	// On récupère les paramètres de la demande par l'application
	$params = json_decode(file_get_contents("php://input"));
	$shareUrl = $params->url;
	$shareWith = $params->shareWith;
	$shareType = $params->shareType;
	
	// Vérification format de l'uid et de l'identifiant de pad
	if(! (preg_match('/^[A-Za-z0-9\-\.]+$/', $uid) && preg_match("/^https:\/\/$servAdress\/etherpad\/p\/[A-Za-z0-9\-\_]+$/", $shareUrl)) ) stopErreur("Erreur de formatage de l'uid ou de l'adresse");

	// Ouverture d'une connexion sur la DB etherhome
	$mysqli = new mysqli($host, $userSQL, $passSQL, $database, $portSQL);
	if ($mysqli->connect_error) stopErreur("Erreur de connexion SQL : (" . $mysqli->connect_errno . ") -> " . $mysqli->connect_error);

	// Vérifie si l'entrée existe bien
	// Requête à la base de données
	$result = $mysqli->query ("SELECT * FROM shares WHERE uid='" . addslashes($uid) . "' AND shareWith='" . addslashes($shareWith) . "' AND url='" . addslashes($shareUrl) . "' AND appli='etherpad'");
	if ($result == false)  stopErreur("Erreur requête SQL select : (" . $mysqli->errno .") -> " . $mysqli->error);

	if ($result->num_rows == 0){
		// Préparation de la commande d'insertion
		$query = "INSERT INTO shares (uid, shareWith, shareType, url, appli) VALUES(?, ?, ?, ?, 'etherpad');";
		$stmt = $mysqli->prepare($query);
		// Chargement des données
		$stmt->bind_param("ssss", $v1, $v2, $v3, $v4);
		$v1 = $uid;
		$v2 = $shareWith;
		$v3 = $shareType;
		$v4 = $shareUrl;

		if (!$stmt->execute()) stopErreur("Erreur requête SQL select : (" . $mysqli->errno .") -> " . $mysqli->error);
		$stmt->close();

		// Réponse à afficher dans l'application
		$response['state'] = 'success';
		$response['text'] = 'Le pad a été partagé avec succès';
	}
	else{
		$response['state'] = 'warning';
		$response['text'] = 'Erreur, le partage existe déjà';
	}
	$result->close();
	$mysqli->close();

	echo json_encode($response, true);

	// Fonction de retour d'erreur
	function stopErreur($message)
	{	
		// Les erreurs SQL seront remontées à l'application via cette réponse JSON : voir au début de la vue : <div class="alert alert-{{msg.state}}" ng-show="msg.text" role="alert">{{msg.text}}</div>'
		$row['state'] = "danger";
		$row['text'] = $message;
		echo json_encode($row, true);
		// On sort ici
		exit;
	}