<?php
	require_once('../../authCAS.php');
	require_once('../../config.inc.php');
	require_once '../../communs/shares/functions.php';

	$myArray = array();

	header('Content-type: application/json');

	$params = json_decode(file_get_contents("php://input"));

	// On récupère l'uid du propriétaire et on vérifie sa validité
	$uid = $_SESSION['login'];
	if  (!preg_match('/^[A-Za-z0-9\-\.]+$/',$uid)) stopErreur("Erreur de formatage de l'uid");

	// Ouverture d'une connexion sur la DB etherhome
	$mysqli = new mysqli($host, $userSQL, $passSQL, $database, $portSQL);

	if ($mysqli->connect_error) stopErreur("Erreur de connexion SQL : (" . $mysqli->connect_errno . ") -> " . $mysqli->connect_error);

	$result = $mysqli->query ("SELECT * FROM shares WHERE shareWith='" . addslashes($uid) . "' AND uid!='$uid' AND appli='scrumblr' AND shareType!='2'");
	if ($result == false)  stopErreur("Erreur requête SQL : (" . $mysqli->errno .") -> " . $mysqli->error);

	// doc partagé avec l'utilisateur
	if ($result->num_rows){
		// Charger le tableau en encodant en UTF8 chaque champs sinon la fonction json_encode part en vrille :-)
		while ($ligne = $result->fetch_array(MYSQLI_ASSOC)){
			// Récupère le scrumID dans l'adresse
			$splitted = explode("/",$ligne['url']);
			$ligne['scrumID'] = $splitted[4];
			array_push($myArray, $ligne);
		}
	}
	
	// doc partagé avec un groupe
	$result2 = $mysqli->query('SELECT shareWith, shareType FROM shares');
	if ($result2->num_rows){
		while ($ligne = $result2->fetch_array(MYSQLI_ASSOC)){
				if($ligne['shareType'] === '1'){	// si shareWith est un groupe
					$shareWith = getShareWith($uid, $ligne['shareWith']);

					$result3 = $mysqli->query ("SELECT * FROM shares WHERE shareWith='" . addslashes($shareWith) . "' AND uid!='$uid' AND appli='scrumblr' AND shareType='1'");
					while ($ligne = $result3->fetch_array(MYSQLI_ASSOC)){
						if(!getUsersUnshare($uid, $ligne['url'], $mysqli)){		// l'utilisateur fait partir du groupe et n'a pas supprimer le partage
							// Récupère le scrumID dans l'adresse
							$splitted = explode("/",$ligne['url']);
							$ligne['scrumID'] = $splitted[4];

							// on supprime les doublons
							// du style scrumID partagé au groupe profs6 et professeurs et l'utilisateur fait partir des 2 groupes
							if(!in_array($ligne, $myArray))
								array_push($myArray, $ligne);
					}
				}
			}
		}
	}

	// on supprime les doublons dans le tableau final
	// du style scrumID partagé au groupe profs6 et professeurs dont l'utilisateur fait partir
	// et à l'utilisateur
	$data = array();
	foreach ($myArray as $key => $value) {
		if(array_search($value['url'], array_column($data, 'url'), true) === false)
			array_push($data, $value);
	}

	echo json_encode($data, true);

	// Fonction de retour d'erreur
	function stopErreur($message)
	{
		// Les erreurs seront remontées à l'application via cette réponse JSON : voir au début de la vue : '<div class="erreur" ng-show="listPads.erreur!=''">{{listPads.erreur}}</div>'
		$row['erreur'] = $message;
		echo json_encode($row, true);
		// On sort ici
		exit;
	}