//--> Affichage dynamique géré dans les controleurs des modules etherpad et ethercalc en s'appuyant sur Zepto.js
// Fonction pour Zepto
;(function($){
var e = {
    nextAll: function(s) {
        var $els = $(), $el = this.next()
        while( $el.length ) {
            if(typeof s === 'undefined' || $el.is(s)) $els = $els.add($el)
            $el = $el.next()
        }
        return $els
    },
    prevAll: function(s) {
        var $els = $(), $el = this.prev()
        while( $el.length ) {
            if(typeof s === 'undefined' || $el.is(s)) $els = $els.add($el)
            $el = $el.prev()
        }
        return $els
    }
}
$.extend( $.fn, e )
})(Zepto);

// Définition des handlers en relation dans les controleurs des 3 modules etherpad, ethercalc et scrumblr
var handlerPad = function(){ 
	var obj = $(this),divn = obj.nextAll(), divb = obj.prevAll();
	var titlestep=obj.find('div.etap-num').first().text();
	obj.addClass("active").removeClass("complete").removeClass("disabled");
	divn.each(function(index,ele){$(ele).addClass("disabled");$(ele).removeClass("complete");});
	divb.each(function(index,ele){$(ele).addClass("complete");$(ele).removeClass("disabled");});
	$("#imgcible").html('<img src="assets/img/'+titlestep.substr(1).replace(/\s/g, '')+'_pads-orig.png" alt="'+titlestep+'"/>');
}

var handlerCalc = function(){ 
	var obj = $(this),divn = obj.nextAll(), divb = obj.prevAll();
	var titlestep=obj.find('div.etap-num').first().text();
	obj.addClass("active").removeClass("complete").removeClass("disabled");
	divn.each(function(index,ele){$(ele).addClass("disabled");$(ele).removeClass("complete");});
	divb.each(function(index,ele){$(ele).addClass("complete");$(ele).removeClass("disabled");});
	$("#imgcible").html('<img src="assets/img/'+titlestep.substr(1).replace(/\s/g, '')+'_calcs-orig.png" alt="'+titlestep+'"/>');
}

var handlerTab = function(){ 
    var obj = $(this),divn = obj.nextAll(), divb = obj.prevAll();
    var titlestep=obj.find('div.etap-num').first().text();
    obj.addClass("active").removeClass("complete").removeClass("disabled");
    divn.each(function(index,ele){$(ele).addClass("disabled");$(ele).removeClass("complete");});
    divb.each(function(index,ele){$(ele).addClass("complete");$(ele).removeClass("disabled");});
    $("#imgcible").html('<img src="assets/img/'+titlestep.substr(1).replace(/\s/g, '')+'_scrum-orig.png" alt="'+titlestep+'"/>');
}

