//--> Contrôleur de gestion des calcs : relatif à la page ....... (voir routage)
angular.module('ethercalc').controller("ethercalcCtrl",function($scope, $window, methodesEthercalc, $location) {
	// Remarque : le controleur est relu à chaque nouvelle arrivée sur le module
	
	$scope.appli = $location.path().split('/')[1];

	//--> Fonction de vérification de saisie du nom du calc, invalidant le bouton de submit ('ng-disabled="testNomCalc()"') tant que la saisie ne réponds pas à cette regex
	$scope.testNomCalc = function(){
		return methodesEthercalc.verifNomCalc($scope.ajout.calcID);
	};

	//--> Getter de la liste des calcs appartenant à l'utilisateur pour '<tr ng-repeat="calc in listeCalcs">'
	$scope.getListCalcs = function() {
		// La lecture de la liste des calcs étant asynchrone (ajax), il faut spécifier une fonction de retour (callback)
		methodesEthercalc.listCalcs(function(data) {
			$scope.listeCalcs = data;
		});
	};

	//--> Récupère la liste de tout les calcs dans ethercalc (quel que soit l'utilisateur)
	$scope.getListAllCalcs = function(){
		// La lecture de la liste des calcs étant asynchrone (ajax), il faut spécifier une fonction de retour (callback)
		methodesEthercalc.listCalcsDansEthercalc(function(data) {
			$scope.listAllCalcs = data;
		});
	};

	//--> Méthode appelée pour la création d'un calc
	$scope.addCalc = function() {
		// Nettoyer l'affichage resultat des traitements précedent :
		$scope.ajCalc = {};
		$scope.delCalc = {};
		$scope.ajDelFavCalc = {};
		// On ne peux fonctionner que si la liste de tout les calcs est bien dsponible
		if (angular.isDefined($scope.listAllCalcs.erreur)) $scope.ajCalc = {"state": "danger", "text": "Impossible car liste des calcs indisponible."};
		else {
			// Si le champ n'existe pas, on le créé vide
			if (angular.isUndefined($scope.ajout.calcID)) $scope.ajout = {"calcID" : ""};
			// On va déjà vérifier qu'il n'existe pas dans ethercalc si ce n'est pas vide
			var exist = false;
			if ($scope.ajout.calcID != "") {
				for (var i=0 ; i<$scope.listAllCalcs.length ; i++) if ($scope.listAllCalcs[i].key == $scope.ajout.calcID) exist=true;
			}
			// Si il existe, on le signale
			if (exist) { 
				$scope.ajCalc = {"state": "warning", "text": "Ce calc existe déjà dans l'application ethercalc"};
				questionAjoutFavoris();			
			}
			// Sinon, on demande la création au service de création dans la base etherhome
			else {
				// On va demander au service concerné d'ajouter le calc dans la base etherhome et nous fournir l'id calculé (si calcID était vide)
				methodesEthercalc.createCalc($scope.ajout.calcID, function(data) {
					// Récupère les données
					$scope.ajCalc = data;
					// Si le calc existe déjà pour l'utilisateur, on va demander un passage en favoris
					if ($scope.ajCalc.state == "warning") questionAjoutFavoris();			
					// Si le resultat est valide, on va tout recharger
					if ($scope.ajCalc.state == "success") {
						// Et on ouvre le nouveau calc, ce qui va avoir pour effet de le créer
						$window.open('https://' + $scope.conf.ethercalcAPI + '/' + $scope.ajCalc.create, '_blank');
						// ReCharger la liste des calcs de l'utilisateur dans etherhome
						$scope.getListCalcs();
						// ReCharger la liste de tout les calcs dans ethercalc
						$scope.getListAllCalcs();
						// Recharger la liste des favoris des calcs
						$scope.getListFavorisCalcs();
						// On retourne à la page de liste
						$scope.newDiv = false;
					}
				});
			}
		}
	};

	//--> Méthode privé permettant de demander si on veut mettre le calc en favoris en cas d'echec ajout (existe déjà dans ethercalc) ou appartient à l'utilisateur
	var questionAjoutFavoris = function () {
		// On demande confirmation d'ajout
		if (confirm("Ce calc existe déjà, voulez-vous le mettre en favoris ?")) {
			// Nettoyer l'affichage resultat des traitements précedent :
			$scope.ajCalc = {};
			$scope.delCalc = {};
			$scope.ajDelFavCalc = {};
			// Envoi de la requête de supression : attention, le paramètre est passé avant la fonction de callback
			methodesEthercalc.addFavorisCalc('https://' + $scope.conf.ethercalcAPI + '/' + $scope.ajout.calcID, function(data) {
				$scope.ajDelFavCalc = data;
				// Recharger la liste des favoris des calcs
				$scope.getListFavorisCalcs();
				// On retourne à la page de liste
				$scope.newDiv = false;
			});
		}
	};

	//--> Fonction appelée par le bouton supprimer un calcs : '<button class="btn btn-danger btn-xs" ng-click="deleteCalc(calc.nom);">Supprimer</button>'
	$scope.deleteCalc = function(calcID) {
		// Nettoyer l'affichage resultat des traitements précedent :
		$scope.ajCalc = {};
		$scope.delCalc = {};
		$scope.ajDelFavCalc = {};
		// Suppression sur confirmation
		var r = confirm("Êtes vous sûr de vouloir supprimer ce calc ?");
		if (r) {
			// Envoi de la requête de supression dans l'API ethercalc qui va réaliser la suppression réelle du calcs
			methodesEthercalc.deleteCalcDansEthercalc($scope.conf.ethercalcAPI, calcID, function(data, status) {
				if (status == 201) {
					// Si c'est ok, alors demander d'effacer dans la base de données interne d'etherhome
					methodesEthercalc.deleteCalc(calcID, function(data) {
						$scope.delCalc = data;
						// Charger la liste des calcs de l'utilisateur dans etherhome
						$scope.getListCalcs();
						// Charger la liste de tout les calcs dans ethercalc
						$scope.getListAllCalcs();
						// Recharger la liste des favoris des calcs
						$scope.getListFavorisCalcs();
						// Recharger la liste des partages des calcs
						$scope.getListShares();
					});
				}
				// Si la suppression par l'API Ethercalc échoue, on va retourner le message
				else {
					// Cas d'un message d'erreur interne retourné par l'API ethercalc
					if (angular.isUndefined(data.state)) $scope.delCalc = {"state": "danger", "text" : "Erreur suppression du calc par ethercalc (status=" + status + " ; data=" + data + ")"};
					// Cas de l'erreur AJAX pure, traitement du .error(....) on a directement un message formaté
					else $scope.delCalc = data;
				}
			});
		}
	};

	//--> Fonction de test pour la saisie d'un nouveau favoris invalidant le bouton submit : <button type="submit" class="btn btn-success" ng-click='addFavoriCalcs()' ng-disabled="testURLFavoriCalcs()">Ajouter le favori</button>
	$scope.testURLFavoriCalc = function() {
		// Créer la chaine d'expression régulière afin de lui adjoindre l'adresse du serveur
		var domain = "^https:\\/\\/" + $scope.conf.ethercalcAPI.replace(/\./g, "\\.").replace(/\//g , "\\/") + "\\/[A-Za-z0-9\\-\\_]+$";
		var regexp = new RegExp(domain);
		// Test de la chaine saisie avec l'expression régulière
		return !regexp.test($scope.favoriUrl);
	};

	//--> Getter de la liste des favoris des calcs pour '<tr ng-repeat="favori in listeFavorisCalcs">'
	$scope.getListFavorisCalcs = function(){
		// La lecture de la liste des calcs étant asynchrone (ajax), il faut spécifier une fonction de retour (callback)
		methodesEthercalc.listFavorisCalcs(function(data) { 
			$scope.listeFavorisCalcs = data;
		});
	};

	//--> Fonction appelée par le bouton ajouter un favoris de calc
	$scope.addFavoriCalc = function() {
		// Nettoyer l'affichage resultat des traitements précedent :
		$scope.ajCalc = {};
		$scope.delCalc = {};
		$scope.ajDelFavCalc = {};
		// Envoi de la requête de supression : attention, le paramètre est passé avant la fonction de callback
		methodesEthercalc.addFavorisCalc($scope.favoriUrl, function(data) {
			$scope.ajDelFavCalc = data;
			// Recharger la liste des favoris des calcs
			$scope.getListFavorisCalcs();
		});
	};

	//--> Fonction appelée par le bouton supprimer d'un favoris de calc
	$scope.deleteFavoriCalc = function(id) {
		// Nettoyer l'affichage resultat des traitements précedent :
		$scope.ajCalc = {};
		$scope.delCalc = {};
		$scope.ajDelFavCalc = {};
		// Suppression sur confirmation
		var r = confirm("Êtes vous sûr de vouloir supprimer ce favori ?");
		if (r) {
			// Envoi de la requête de supression : attention, le paramètre est passé avant la fonction de callback
			methodesEthercalc.deleteFavorisCalc(id, function(data) {
				$scope.ajDelFavCalc = data;
				// Recharger la liste des favoris
				$scope.getListFavorisCalcs();
			});
		}
	};

	//--> Changement de div 
	$scope.toggleNew = function () {
		$scope.newDiv =! $scope.newDiv;
	}

	// lister les partages
	// si uid, on liste les docs partagés par l'utilisateur
	$scope.getListShares = function(uid) {
		$scope.share = {};
		$scope.shareWithOther = false;
		if(typeof uid !== 'undefined'){
			$scope.shareWithOther = true;
			$scope.uid = uid;
		}
		methodesEthercalc.listShares(uid, $scope.appli, function(data) { 
			$scope.listShares = data;
		});
	};

	// lister les utilisateurs et groupes
	// on attend la fin de la frappe pour envoyer la requête au serveur
	var timeout = null;
	var textInput = document.getElementById('shareWith');
	$scope.getUsersGroups = function() {
		clearTimeout(timeout);

		timeout = setTimeout(function () {
			// Nettoyer l'affichage resultat des traitements précedent :
			$scope.usersGroups = {};
			$scope.share = {};

			if(textInput.value !== ''){
				methodesEthercalc.getUsersGroups(textInput.value, $scope.element.lien, $scope.appli, function(data) {
					if (data.state === 'success') {
						$scope.usersGroups = data;
					}
					else {
						$scope.usersGroups = {'state': 'danger', 'message' : 'Pas d\'utilisateur ou de groupe trouvé'};
					}
				});
			}
		}, 1000);
	};

	// partager un calc
	$scope.shareCalc = function(share, shareWith, shareType) {
		$scope.share = {};
		// Suppression sur confirmation
		methodesEthercalc.shareCalc(share, $scope.appli, shareWith, shareType, function(data) {
			$scope.share = {'state': data.state, 'text': data.text };
			$scope.getUsersGroups();
		});
	};

	// supprimer un partage
	// si cancelSahre vaut true, le propriétaire annule le partage
	$scope.deleteShare = function(share, cancelShare){
		// Nettoyer l'affichage resultat des traitements précedent :
		$scope.ajShare = {};
		$scope.delShare = {};
		$scope.ajDelShare = {};

		var title = (typeof cancelShare !== 'undefined') ? 'annuler' : 'supprimer';
		// Suppression sur confirmation
		var r = confirm('Êtes vous sûr de vouloir ' + title + ' ce partage ?');
		if (r) {
			// Envoi de la requête de supression : attention, le paramètre est passé avant la fonction de callback
			methodesEthercalc.deleteShare(share, cancelShare, function(data) {
				$scope.ajDelShare = data;
				$scope.getListCalcs();
				// Recharger la liste des partages
				$scope.getListShares($scope.uid);
			});
		}
	};

	//--> Chargement au démarrage du contôleur :
	// Uniquement chargé si le module est activé
	if ($scope.conf.ethercalcActif) {
		// Gestion de l'affichage au passage de la souris pour les étapes : le handlerCalc est défini dans assets/js/presentation.js
		Zepto("#calcID").focusin(Zepto.proxy(handlerCalc,Zepto("div.etap-step:first-child")));
		Zepto("div.etap-step").mouseenter(handlerCalc);
		Zepto("div.etap-step").mouseleave(function(){Zepto(this).removeClass("active");});

		// Déclaration du formuliaire d'ajout vide
		$scope.ajout = {};
		// div affichée par défaut
		$scope.newDiv = false;

		// Charger la liste des calcs de l'utilisateur dans etherhome
		$scope.getListCalcs();
		// Charger la liste de tout les calcs dans ethercalc
		$scope.getListAllCalcs();
		// Charger la liste des favoris des calcs
		$scope.getListFavorisCalcs();
		// Charger la liste des calcs partagés
		$scope.getListShares();
	}
});
