<?php
	// Vérifie l'authentification
	include_once('../../authCAS.php');

	// configuration Etherhome
	require_once('../../config.inc.php');

	// On sort du JSON
	header('Content-type: application/json');

	// Tableau de sortie
	$myArray = array();

	// On vérifie les droits d'accès de l'utilisateur avant d'autoriser le script à s'exécuter
	if (!$ethercalcActif)  stopErreur("Vous n'avez pas les droits pour executer ce script");

	// Ouverture d'une connexion sur la DB etherhome
	$mysqliEtherhome = new mysqli($host, $userSQL, $passSQL, $database, $portSQL);
	if ($mysqli->connect_error) stopErreur("Erreur de connexion SQL : (" . $mysqliEtherhome->connect_errno . ") -> " . $mysqliEtherhome->connect_error);

	$ligne = array();

	$resultUser = $mysqliEtherhome->query ("SELECT nom, uid FROM elements WHERE appli='ethercalc'");
	if ($resultUser == false)  stopErreur("Erreur requête SQL home : (" . $mysqliEtherhome->errno .") -> " . $mysqliEtherhome->error);
	while ($ligne = $resultUser->fetch_array(MYSQLI_ASSOC))
	{
		$ligne["key"] = utf8_encode($ligne['nom']);
		$ligne["proprietaire"] = utf8_encode($ligne['uid']);
		array_push($myArray, $ligne);
	}

	$resultUser->close();

	// Fermer connexion SQL
	$mysqliEtherhome->close();

	// Retourne la liste en format JSON
	echo json_encode($myArray,true);

	// Fonction de retour d'erreur
	function stopErreur($message)
	{	
		// Les erreurs seront remontées à l'application via cette réponse JSON : voir au début de la vue : '<div class="erreur" ng-show="listPads.erreur!=''">{{listPads.erreur}}</div>'
		$row['erreur'] = $message;
		echo json_encode($row, true);
		// On sort ici
		exit;
	}

?>
