//--> Partie métier : services destinés à gérer les pads
angular.module('etherpad').factory('methodesEtherpad', function($http) {
	//--> Définition de la fabrique de services	
	var factory = {}; 

	//--> Vérification de format de l'id de pad
	factory.verifNomPad = function(padID) {
		// Ne doit contenir que des chiffres 
		// et lettres et 50 lettres maxi (refs #24162)
		var regexp = /^[A-Za-z0-9\-\_]{0,50}$/;
		return !regexp.test(padID);
	}

	//--> Service de listage des pads
	factory.listPads = function(callback) {
		$http.get("modules/etherpad/listPads.php").success(function(data,status) {
			callback(data);
		}).error(function(data,status) {
			callback({"erreur" : "Erreur ajax lecture liste pads de l'utilisateur : " + status + " (" + data + ")"});
		});
	}

	//--> Service de création d'un pad dans la base etherhome
	factory.createPad = function(padID, callback) {
		var params = {"padID": padID};
		$http.post("modules/etherpad/createPad.php", params).success(function(data, status) {
			callback(data);
		}).error(function(data,status) {
			callback({"state": "danger", "text" : "Erreur ajax creation pad : " + status + " (" + data + ")"});
		});
	}

	//--> Service de suppression d'un pads auprès d'etherpad grâce à son API
	factory.deletePadDansEtherpad = function(etherpadAPI, apikey, padID, callback) {
		$http.get("https://" + etherpadAPI + "/api/1/deletePad?apikey=" + apikey + "&padID=" + padID).success(function(data, status) {
			callback(data);
		}).error(function(data, status) {
			callback({"state": "danger", "text" : "Erreur ajax suppression pads dans etherpad : " + status + " (" + data + ")"});
		});
	}

	//--> Service de suppression d'un pad dans la base etherhome
	factory.deletePad = function(padID, callback) {
		var params = {"padID": padID};
		$http.post("modules/etherpad/deletePad.php", params).success(function(data, status) {
			callback(data);
		}).error(function(data,status) {
			callback({"state": "danger", "text" : "Erreur ajax suppression pad : " + status + " (" + data + ")"});
		});
	}

	//--> Service de suppression d'un pad dans la base etherhome
	factory.deleteOldsPads = function(pads, callback) {
		var params = {'pads': pads};
		$http.post("modules/etherpad/deleteOldsPads.php", params).success(function(data, status) {
			callback(data);
		}).error(function(data,status) {
			callback({"state": "danger", "text" : "Erreur ajax suppression pad : " + status + " (" + data + ")"});
		});
	}

	//--> Service de listage des favoris
	factory.listFavorisPads = function(callback) {
		$http.get("modules/etherpad/listFavorisPads.php").success(function(data,status) {
			callback(data);
		}).error(function(data,status) {
			callback({"erreur" : "Erreur ajax lecture favoris des pads : " + status + " (" + data + ")"});
		});
	}

	//--> Ajout d'un favoris pad
	factory.addFavorisPad = function(favoriUrl, callback) {
		var params = {"favoriUrl": favoriUrl};
		$http.post("modules/etherpad/addFavorisPad.php", params).success(function(data, status) {
			callback(data);
		}).error(function(data,status) {
			callback({"state": "danger", "text" : "Erreur ajax ajout favoris pads : " + status + " (" + data + ")"});
		});
	}

	//--> Suppression d'un favoris pad
	factory.deleteFavorisPad = function(id, callback) {
		var params = {"id": id};
		$http.post("modules/etherpad/deleteFavorisPad.php", params).success(function(data, status) {
			callback(data);
		}).error(function(data,status) {
			callback({"state": "danger", "text" : "Erreur ajax suppression favoris pads : " + status + " (" + data + ")"});
		});
	}

	//--> Service de listage des pads auprès d'etherpad
	// On n'utilise pas l'api (https://etherpad//api/1/listAllPads?apikey=" ) car ici car ça ne fonctionne pas avec etherpad-lite 1.4.7
	factory.listPadsDansEtherpad = function(callback) {
		$http.get("modules/etherpad/listAllPads.php").success(function(data, status) {
			callback(data);
		}).error(function(data, status) {
			callback({"erreur" : "Erreur ajax listage de tous les pads : " + status + " (" + data + ")"});
		});
	}

	//--> Service de listage des viexu pads auprès d'etherpad
	// On n'utilise pas l'api (https://etherpad//api/1/listAllPads?apikey=" ) car ici car ça ne fonctionne pas avec etherpad-lite 1.4.7
	factory.listOldsPadsDansEtherpad = function(dateStart, dateEnd, callback) {
		var params = {"dateStart": dateStart, "dateEnd": dateEnd};
		$http.post("modules/etherpad/listOldsPads.php", params).success(function(data, status) {
			callback(data);
		}).error(function(data, status) {
			callback({"erreur" : "Erreur ajax listage de tous les pads : " + status + " (" + data + ")"});
		});
	}

	//--> Service de modification de l'utilisateur d'un pad dans la base etherhome
	factory.modifieUtilPad = function(padID, proprietaire, callback) {
		var params = {"padID": padID, "proprietaire": proprietaire};
		$http.post("modules/etherpad/modifUserAdminPad.php", params).success(function(data, status) {
			callback(data);
		}).error(function(data,status) {
			callback({"state": "danger", "text" : "Erreur ajax modification utilisateur pad : " + status + " (" + data + ")"});
		});
	}

	// lister les partages
	factory.listShares = function(uid, appli, callback) {
		var params = {'uid': uid, 'appli': appli};

		$http.post('modules/etherpad/listShares.php', params).success(function(data,status) {
			callback(data);
		}).error(function(data,status) {
			callback({'state': 'danger', 'text': 'Erreur ajax lecture des pads partagés : ' + status + ' (' + data + ')'});
		});
	}

	// obtenir les partages
	factory.getUsersGroups = function(key, url, appli, callback) {
		var params = {'key': key, 'url': url, 'appli': appli};
		$http.post('communs/shares/getUsersGroups.php', params).success(function(data, status) {
			callback(data);
		}).error(function(data,status) {
			callback({'state': 'danger', 'text' : 'Erreur ajax : ' + status + ' (' + data + ')'});
		});
	}

	// partager un pad
	factory.sharePad = function(share, appli, shareWith, shareType, callback) {
		var params = {'nom': share.nom, 'url': share.lien, 'appli': appli, 'shareWith': shareWith, 'shareType': shareType};
		$http.post('modules/etherpad/share.php', params).success(function(data, status) {
			callback(data);
		}).error(function(data,status) {
			callback({'state': 'danger', 'text' : 'Erreur ajax : ' + status + ' (' + data + ')'});
		});
	}

	// supprimer un partage
	// si cancelSahre vaut true, le propriétaire annule le partage
	factory.deleteShare = function(share, cancelShare, callback) {
		var params = {'cancelShare': cancelShare, 'share': share};
		$http.post('communs/shares/deleteShare.php', params).success(function(data, status) {
			callback(data);
		}).error(function(data,status) {
			callback({'state': 'danger', 'text' : 'Erreur ajax suppression pad : ' + status + ' (' + data + ')'});
		});
	}

	//--> Retourne la fabrique
	return factory;
});
