<?php
	// Vérifie l'authentification
	include_once('../../authCAS.php');

	// Configuration etherhome
	require_once('../../config.inc.php');

	// Configuration accès db etherpad
	if(!file_exists('../../confSqlEtherpad.inc.php') ) stopErreur("Erreur de lecture confSqlEtherpad.inc.php : non trouvé");
	include_once('../../confSqlEtherpad.inc.php'); 
	if( !isset($hostSQLEtherpad) || !isset($databaseSQLEtherpad) || !isset($userSQLEtherpad) || !isset($passSQLEtherpad) || !isset($portSQLEtherpad) ) stopErreur("Erreur de lecture confSqlEtherpad.inc.php : incomplet");

	// On sort en JSON
	header('Content-type: application/json');

	// Tableau de sortie
	$myArray = array();

	// Ouverture d'une connexion sur la DB etherpad
	$mysqliPad = new mysqli($hostSQLEtherpad, $userSQLEtherpad, $passSQLEtherpad, $databaseSQLEtherpad, $portSQLEtherpad);
	if ($mysqli->connect_error) stopErreur("Erreur de connexion SQL etherpad : (" . $mysqliPad->connect_errno . ") -> " . $mysqliPad->connect_error);

	// Ouverture d'une connexion sur la DB etherhome
	$mysqliEtherhome = new mysqli($host, $userSQL, $passSQL, $database, $portSQL);
	if ($mysqli->connect_error) stopErreur("Erreur de connexion SQL etherhome : (" . $mysqliEtherhome->connect_errno . ") -> " . $mysqliEtherhome->connect_error);

	// Requête à la base de données
	$result = $mysqliPad->query ("SELECT  `key` FROM `store` WHERE `key` LIKE 'pad\\:%'");
	if ($result == false)  stopErreur("Erreur requête SQL pads : (" . $mysqliPad->errno .") -> " . $mysqliPad->error);

	// Charger le tableau en encodant en UTF8 chaque champs sinon la fonction json_encode part en vrille :-)
	while ($ligne = $result->fetch_array(MYSQLI_ASSOC))
	{
		if (preg_match('/^pad:[A-Za-z0-9\-\_]+$/', $ligne["key"]))
		{
			// Encoder en UTF8 et récupérer l'identifiant de pad
			$ligne["key"] = utf8_encode( preg_replace("/^pad:/", "", $ligne["key"]) );
			// Chercher le propriétaire
			$ligne["proprietaire"] = "";
			$resultUser = $mysqliEtherhome->query ("SELECT uid FROM elements WHERE nom='" . addslashes($ligne["key"]) . "' AND appli='etherpad'");
			if ($resultUser == false)  stopErreur("Erreur requête SQL home : (" . $mysqliEtherhome->errno .") -> " . $mysqliEtherhome->error);
			if ($u = $resultUser->fetch_array(MYSQLI_ASSOC)) $ligne["proprietaire"] = utf8_encode ($u["uid"]);
			$resultUser->close();
			// Empiler
			array_push($myArray, $ligne);
		}
	}

	// Fermeture du statement
	$result->close();

	// Fermer connexions SQL
	$mysqliPad->close();
	$mysqliEtherhome->close();

	// Retourne la liste en format JSON
	echo json_encode($myArray,true);

	// Arrêt en cas d'erreur
	function stopErreur($message)
	{
		// Les erreurs seront remontées à l'application via cette réponse JSON : voir au début de la vue : '<div class="erreur" ng-show="listPads.erreur!=''">{{listPads.erreur}}</div>'
		$row['erreur'] = $message;
		echo json_encode($row, true);
		// On sort ici
		exit;
	}

?>
