<?php
	// Vérifie l'authentification
	include_once('../../authCAS.php');

	// configuration Etherhome
	require_once('../../config.inc.php');

	// On sort du JSON
	header('Content-type: application/json');

	// Scrum de sortie
	$myArray = array();

	// On vérifie les droits d'accès de l'utilisateur avant d'autoriser le script à s'exécuter
	if (!$scrumblrActif)  stopErreur("Vous n'avez pas les droits pour executer ce script");

	// Ouverture d'une connexion sur la DB etherhome
	$mysqliEtherhome = new mysqli($host, $userSQL, $passSQL, $database, $portSQL);
	if ($mysqli->connect_error) stopErreur("Erreur de connexion SQL : (" . $mysqliEtherhome->connect_errno . ") -> " . $mysqliEtherhome->connect_error);

	// refs #20681
	// Requête à la base de données
	$result = $mysqliEtherhome->query ("SELECT nom, uid FROM elements WHERE appli='scrumblr'");
	if ($result == false)  stopErreur("Erreur requête SQL : (" . $mysqliEtherhome->errno .") -> " . $mysqliEtherhome->error);

	// Charger le scrum en encodant en UTF8 chaque champs sinon la fonction json_encode part en vrille :-)
	while ($ligne = $result->fetch_array(MYSQLI_ASSOC))
	{
		foreach(array_keys($ligne) as $key) $ligne[$key] = utf8_encode($ligne[$key]);
		$ligne['lien'] = "https://$scrumblrAPI/" . $ligne["nom"];
		array_push($myArray, $ligne);
	}

	// Fermeture du statement
	$result->close();

	// // Fermer connexion SQL
	$mysqliEtherhome->close();

	// Retourne la liste en format JSON
	echo json_encode($myArray,true);

	// Fonction de retour d'erreur
	function stopErreur($message)
	{	
		// Les erreurs seront remontées à l'application via cette réponse JSON : voir au début de la vue : '<div class="erreur" ng-show="listPads.erreur!=''">{{listPads.erreur}}</div>'
		$row['erreur'] = $message;
		echo json_encode($row, true);
		// On sort ici
		exit;
	}

?>
