//--> Partie métier : services destinés à gérer les scrums
angular.module('scrumblr').factory('methodesScrumblr', function($http) {
	//--> Définition de la fabrique de services	
	var factory = {}; 

	//--> Vérification de format de l'id de scrum
	factory.verifNomTab = function(tabID) {
		// Ne doit contenir que des chiffres et lettres
		var regexp = /^[A-Za-z0-9\-\_]*$/;
		return !regexp.test(tabID);
	}

	//--> Service de listage des scrums
	factory.listTabs = function(callback) {
		$http.get("modules/scrumblr/listTabs.php").success(function(data,status) {
			callback(data);
		}).error(function(data,status) {
			callback({"erreur" : "Erreur ajax lecture scrums : " + status + " (" + data + ")"});
		});
	}

	//--> Service de création d'un scrum dans la base etherhome
	factory.createTab = function(tabID, callback) {
		var params = {"tabID": tabID};
		$http.post("modules/scrumblr/createTab.php", params).success(function(data, status) {
			callback(data);
		}).error(function(data,status) {
			callback({"state": "danger", "text" : "Erreur ajax creation scrum : " + status + " (" + data + ")"});
		});
	}

	//--> Service de suppression d'un scrum auprès de scrumblr grâce à son API : https://github.com/audreyt/scrumblr/blob/master/API.md
	// TODO : Pour l'heure cette solution pose problème, il répond status=201 et data=0K mais ne fait rien, la solution de suppression directe dans le fichier JSON 
	//	(/usr/share/eole/nodejs/scrumblr/dump.json) ne donne rien car la feuille de calcul revient tjs au final.....
	factory.deleteTabDansScrumblr = function(scrumblrAPI, tabID, callback) {
		$http.post("https://" + scrumblrAPI + "/" + tabID).success(function(data, status) {
			callback(data, status);
		}).error(function(data, status) {
			callback({"state": "danger", "text" : "Erreur ajax suppression scrums dans scrumblr : " + status + " (" + data + ")"});
		});
	}

	//--> Service de suppression d'un scrum dans la base etherhome
	factory.deleteTab = function(tabID, callback) {
		var params = {"tabID": tabID};
		$http.post("modules/scrumblr/deleteTab.php", params).success(function(data, status) {
			callback(data);
		}).error(function(data,status) {
			callback({"state": "danger", "text" : "Erreur ajax suppression scrum : " + status + " (" + data + ")"});
		});
	}

	//--> Service de listage des favoris
	factory.listFavorisTabs = function(callback) {
		$http.get("modules/scrumblr/listFavorisTabs.php").success(function(data,status) {
			callback(data);
		}).error(function(data,status) {
			callback({"erreur" : "Erreur ajax lecture favoris des scrums : " + status + " (" + data + ")"});
		});
	}

	//--> Ajout d'un favori scrum
	factory.addFavorisTab = function(favoriUrl, callback) {
		var params = {"favoriUrl": favoriUrl};
		$http.post("modules/scrumblr/addFavorisTab.php", params).success(function(data, status) {
			callback(data);
		}).error(function(data,status) {
			callback({"state": "danger", "text" : "Erreur ajax ajout favoris scrums : " + status + " (" + data + ")"});
		});
	}

	//--> Suppression d'un favori scrum
	factory.deleteFavorisTab = function(id, callback) {
		var params = {"id": id};
		$http.post("modules/scrumblr/deleteFavorisTab.php", params).success(function(data, status) {
			callback(data);
		}).error(function(data,status) {
			callback({"state": "danger", "text" : "Erreur ajax suppression favoris scrums : " + status + " (" + data + ")"});
		});
	}

	//--> Service de listage des scrums dans scrumblr
	// On n'utilise pas l'API scrumblr (https://github.com/audreyt/scrumblr/blob/master/API.md) qui pose des soucis pour l'instant
	factory.listTabsDansScrumblr = function(callback) {
		$http.get("modules/scrumblr/listAllTabs.php").success(function(data, status) {
			callback(data);
		}).error(function(data, status) {
			callback({"erreur" : "Erreur ajax listage de tous les scrums : " + status + " (" + data + ")"});
		});
	}

	//--> Service de modification de l'utilisateur d'un scrum dans la base etherhome
	factory.modifieUtilTab = function(tabID, proprietaire, callback) {
		var params = {"tabID": tabID, "proprietaire": proprietaire};
		$http.post("modules/scrumblr/modifUserAdminTab.php", params).success(function(data, status) {
			callback(data);
		}).error(function(data,status) {
			callback({"state": "danger", "text" : "Erreur ajax modification utilisateur scrum : " + status + " (" + data + ")"});
		});
	}

	// lister les partages
	factory.listShares = function(uid, appli, callback) {
		var params = {'uid': uid, 'appli': appli};

		$http.post('modules/scrumblr/listShares.php', params).success(function(data,status) {
			callback(data);
		}).error(function(data,status) {
			callback({'state': 'danger', 'text': 'Erreur ajax lecture des scrums partagés : ' + status + ' (' + data + ')'});
		});
	}

	// obtenir les partages
	factory.getUsersGroups = function(key, url, appli, callback) {
		var params = {'key': key, 'url': url, 'appli': appli};
		$http.post('communs/shares/getUsersGroups.php', params).success(function(data, status) {
			callback(data);
		}).error(function(data,status) {
			callback({'state': 'danger', 'text' : 'Erreur ajax : ' + status + ' (' + data + ')'});
		});
	}

	// partager un scrum
	factory.shareScrum = function(share, appli, shareWith, shareType, callback) {
		var params = {'nom': share.nom, 'url': share.lien, 'appli': appli, 'shareWith': shareWith, 'shareType': shareType};
		$http.post('modules/scrumblr/share.php', params).success(function(data, status) {
			callback(data);
		}).error(function(data,status) {
			callback({'state': 'danger', 'text' : 'Erreur ajax : ' + status + ' (' + data + ')'});
		});
	}

	// supprimer un partage
	// si cancelSahre vaut true, le propriétaire annule le partage
	factory.deleteShare = function(share, cancelShare, callback) {
		var params = {'cancelShare': cancelShare, 'share': share};
		$http.post('communs/shares/deleteShare.php', params).success(function(data, status) {
			callback(data);
		}).error(function(data,status) {
			callback({'state': 'danger', 'text' : 'Erreur ajax suppression scrum : ' + status + ' (' + data + ')'});
		});
	}

	//--> Retourne la fabrique
	return factory;
});
