//--> Contrôleur de gestion des scrums : relatif à la page ....... (voir routage)
angular.module('scrumblr').controller("scrumblrAdminCtrl",function($scope, methodesScrumblr) {
	// Remarque : le controleur est relu à chaque nouvelle arrivée sur le module

	//--> Getter de la liste des scrums pour '<tr ng-repeat="tab in listeAllTabs">'
	$scope.getListAllTabs = function() {
		// Envoi de la requête de la liste de tous les scrums
		methodesScrumblr.listTabsDansScrumblr(function(data) {
			$scope.listAllTabs = data;
		});
	};

	//--> Fonction de vérification de saisie du nom d'utilisateur
	$scope.testUid = function(uid) {
		// si indefinie, on bloque ici
		if (angular.isUndefined(uid)) return true;
		// Ne doit contenir que des chiffres et lettres
		var regexp = /^[A-Za-z0-9\-\.]+$/;
		return !regexp.test(uid);
	};

	//--> Fonction appelée par le bouton supprimer un scrum : '<button class="btn btn-danger btn-xs" ng-click="deleteTab(tab.nom);">Supprimer</button>'
	$scope.deleteTab = function(tabID) {
		// Nettoyer l'affichage resultat des traitements précedent :
		$scope.adminTab = {};
		// Suppression sur confirmation
		var r = confirm("Êtes vous sûr de vouloir supprimer ce scrum ?");
		if (r) {
			// effacer dans la base de données interne d'etherhome
			methodesScrumblr.deleteTab(tabID, function(data) {
				$scope.adminTab = data;
				// Charger la liste de tout les scrums dans scrumblr
				$scope.getListAllTabs();
			});
		}
	};

	//--> Méthode appelée pour changer l'utilisateur d'un scrum
	$scope.userTab = function (tabID, proprietaire) {
		// Envoi de la requête de la liste de tout les scrums
		methodesScrumblr.modifieUtilTab(tabID, proprietaire, function(data) {
			$scope.adminTab = data;
		});
	};

	//--> Chargement au démarrage du contôleur :
	// uniquement chargé si le module est activé et mode admin
	if ($scope.conf.scrumblrActif && $scope.profile.admin) {
		// Lister l'intégralité des scrums dans le fichier JSON de scrumblr
		$scope.getListAllTabs();
	}
});
