/**
 * node-compress-commons
 *
 * Copyright (c) 2014 Chris Talkington, contributors.
 * Licensed under the MIT license.
 * https://github.com/ctalkington/node-compress-commons/blob/master/LICENSE-MIT
 */
module.exports = {
  WORD: 4,
  DWORD: 8,
  EMPTY: new Buffer(0),

  SHORT: 2,
  SHORT_MASK: 0xffff,
  SHORT_SHIFT: 16,
  SHORT_ZERO: new Buffer(Array(2)),
  LONG_ZERO: new Buffer(Array(4)),

  DATA_DESCRIPTOR_MIN_VERSION: 20,
  INITIAL_VERSION: 10,

  METHOD_STORED: 0,
  METHOD_DEFLATED: 8,

  PLATFORM_UNIX: 3,
  PLATFORM_FAT: 0,

  SIG_LFH: 0x04034b50,
  SIG_DD: 0x08074b50,
  SIG_CFH: 0x02014b50,
  SIG_EOCD: 0x06054b50,
  SIG_ZIP64_EOCD: 0x06064B50,
  SIG_ZIP64_EOCD_LOC: 0x07064B50,

  ZIP64_MIN_VERSION: 45,
  ZIP64_MAGIC_SHORT: 0xffff,
  ZIP64_MAGIC: 0xffffffff,

  ZLIB_NO_COMPRESSION: 0,
  ZLIB_BEST_SPEED: 1,
  ZLIB_BEST_COMPRESSION: 9,
  ZLIB_DEFAULT_COMPRESSION: -1,

  MODE_MASK: 0xFFF,
  DEFAULT_FILE_MODE: 0100644, // 644 -rw-r--r-- = S_IFREG | S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH
  DEFAULT_DIR_MODE: 040755, // 755 drwxr-xr-x = S_IFDIR | S_IRWXU | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH

  EXT_FILE_ATTR_DIR: 010173200020, // 755 drwxr-xr-x = (((S_IFDIR | 0755) << 16) | S_DOS_D)
  EXT_FILE_ATTR_FILE: 020151000040, // 644 -rw-r--r-- = (((S_IFREG | 0644) << 16) | S_DOS_A) >>> 0

  // Unix file types
  S_IFIFO: 010000, // named pipe (fifo)
  S_IFCHR: 020000, // character special
  S_IFDIR: 040000, // directory
  S_IFBLK: 060000, // block special
  S_IFREG: 0100000, // regular
  S_IFLNK: 0120000, // symbolic link
  S_IFSOCK: 0140000, // socket

  // DOS file type flags
  S_DOS_A: 040, // Archive
  S_DOS_D: 020, // Directory
  S_DOS_V: 010, // Volume
  S_DOS_S: 04, // System
  S_DOS_H: 02, // Hidden
  S_DOS_R: 01 // Read Only
};