#!/bin/bash

ETH_DIR="/usr/share/eole/nodejs/etherpad/"
LOG_FILE="/var/log/etherpad-install.log"

%if %%getVar('activer_etherpad','non') == "oui"
    if [ ! -f ${ETH_DIR}.depsChecked ]
    then
        echo "Installation des dépendances d'Etherpad, veuillez patienter..."
        cd ${ETH_DIR}
        if [ ! -f ${LOG_FILE} ]
        then
            touch ${LOG_FILE}
        fi

        # Suppression des plugins obsolètes
        rm -rf ${ETH_DIR}node_modules/ep_page_view
        
        # Installation n
        npm i -g n
        
        # Installation node 13.14.0
        n 13.14.0
        
        # Installation des plugins
        npm i ep_align
        npm i ep_author_hover
        npm i ep_colors
        npm i ep_comments_page
        npm i ${ETH_DIR}envole_modules/ep_envole_casuser
        npm i ep_font_size
        npm i ep_headings2
        npm i ep_draw
        npm i ep_print
        npm i ep_set_title_on_pad
	    npm i ep_image_upload
	    npm i ep_embedmedia
	    npm i ep_mathjax
        
        bin/installDeps.sh > ${LOG_FILE}  
        echo "Installation terminée"
        /bin/touch ${ETH_DIR}.depsChecked
    fi
%end if

