-- --------------------------------------------------------
-- Création de la base de donnée
-- --------------------------------------------------------
CREATE DATABASE fluxbb DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci;
use fluxbb;


-- --------------------------------------------------------
-- Réglages mysql
-- --------------------------------------------------------
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET character_set_client = utf8;


-- --------------------------------------------------------
-- Provient d'un export SQL en fresh + templatisation :
-- LC : mysqldump --opt --skip-extended-insert -h localhost -u root -p123456 fluxbb > fluxbb-x.y.z-fresh.sql
-- NE PAS OUBLIER DE TEMPLATISER !!!!
-- --------------------------------------------------------

-- MySQL dump 10.13  Distrib 5.7.18, for Linux (x86_64)
--
-- Host: localhost    Database: fluxbb
-- ------------------------------------------------------
-- Server version	5.7.18-0ubuntu0.16.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `flux_bans`
--

DROP TABLE IF EXISTS `flux_bans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `flux_bans` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(200) DEFAULT NULL,
  `ip` varchar(255) DEFAULT NULL,
  `email` varchar(80) DEFAULT NULL,
  `message` varchar(255) DEFAULT NULL,
  `expire` int(10) unsigned DEFAULT NULL,
  `ban_creator` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `flux_bans_username_idx` (`username`(25))
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `flux_bans`
--

LOCK TABLES `flux_bans` WRITE;
/*!40000 ALTER TABLE `flux_bans` DISABLE KEYS */;
/*!40000 ALTER TABLE `flux_bans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `flux_categories`
--

DROP TABLE IF EXISTS `flux_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `flux_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cat_name` varchar(80) NOT NULL DEFAULT 'New Category',
  `disp_position` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `flux_categories`
--

LOCK TABLES `flux_categories` WRITE;
/*!40000 ALTER TABLE `flux_categories` DISABLE KEYS */;
INSERT INTO `flux_categories` VALUES (1,'Test category',1);
/*!40000 ALTER TABLE `flux_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `flux_censoring`
--

DROP TABLE IF EXISTS `flux_censoring`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `flux_censoring` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `search_for` varchar(60) NOT NULL DEFAULT '',
  `replace_with` varchar(60) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `flux_censoring`
--

LOCK TABLES `flux_censoring` WRITE;
/*!40000 ALTER TABLE `flux_censoring` DISABLE KEYS */;
/*!40000 ALTER TABLE `flux_censoring` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `flux_config`
--

DROP TABLE IF EXISTS `flux_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `flux_config` (
  `conf_name` varchar(255) NOT NULL DEFAULT '',
  `conf_value` text,
  PRIMARY KEY (`conf_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `flux_config`
--

LOCK TABLES `flux_config` WRITE;
/*!40000 ALTER TABLE `flux_config` DISABLE KEYS */;
INSERT INTO `flux_config` VALUES ('o_additional_navlinks','');
INSERT INTO `flux_config` VALUES ('o_admin_email','admin@%%domaine_messagerie_etab');
INSERT INTO `flux_config` VALUES ('o_announcement','0');
INSERT INTO `flux_config` VALUES ('o_announcement_message','Enter your announcement here.');
INSERT INTO `flux_config` VALUES ('o_avatars','1');
INSERT INTO `flux_config` VALUES ('o_avatars_dir','img/avatars');
INSERT INTO `flux_config` VALUES ('o_avatars_height','60');
INSERT INTO `flux_config` VALUES ('o_avatars_size','10240');
INSERT INTO `flux_config` VALUES ('o_avatars_width','60');
INSERT INTO `flux_config` VALUES ('o_base_url','https://%%web_url/fluxbb');
INSERT INTO `flux_config` VALUES ('o_board_desc','<p><span>Unfortunately no one can be told what FluxBB is - you have to see it for yourself.</span></p>');
INSERT INTO `flux_config` VALUES ('o_board_title','Mon forum');
INSERT INTO `flux_config` VALUES ('o_censoring','0');
INSERT INTO `flux_config` VALUES ('o_cur_version','1.5.10');
INSERT INTO `flux_config` VALUES ('o_database_revision','21');
INSERT INTO `flux_config` VALUES ('o_date_format','Y-m-d');
INSERT INTO `flux_config` VALUES ('o_default_dst','0');
INSERT INTO `flux_config` VALUES ('o_default_email_setting','1');
INSERT INTO `flux_config` VALUES ('o_default_lang','French');
INSERT INTO `flux_config` VALUES ('o_default_style','Air');
INSERT INTO `flux_config` VALUES ('o_default_timezone','0');
INSERT INTO `flux_config` VALUES ('o_default_user_group','4');
INSERT INTO `flux_config` VALUES ('o_disp_posts_default','25');
INSERT INTO `flux_config` VALUES ('o_disp_topics_default','30');
INSERT INTO `flux_config` VALUES ('o_feed_ttl','0');
INSERT INTO `flux_config` VALUES ('o_feed_type','2');
INSERT INTO `flux_config` VALUES ('o_forum_subscriptions','1');
INSERT INTO `flux_config` VALUES ('o_gzip','0');
INSERT INTO `flux_config` VALUES ('o_indent_num_spaces','4');
INSERT INTO `flux_config` VALUES ('o_mailing_list','admin@%%domaine_messagerie_etab');
INSERT INTO `flux_config` VALUES ('o_maintenance','0');
INSERT INTO `flux_config` VALUES ('o_maintenance_message','The forums are temporarily down for maintenance. Please try again in a few minutes.<br />\\n<br />\\n/Administrator');
INSERT INTO `flux_config` VALUES ('o_make_links','1');
INSERT INTO `flux_config` VALUES ('o_parser_revision','2');
INSERT INTO `flux_config` VALUES ('o_quickjump','1');
INSERT INTO `flux_config` VALUES ('o_quickpost','1');
INSERT INTO `flux_config` VALUES ('o_quote_depth','3');
INSERT INTO `flux_config` VALUES ('o_redirect_delay','1');
INSERT INTO `flux_config` VALUES ('o_regs_allow','0');
INSERT INTO `flux_config` VALUES ('o_regs_report','0');
INSERT INTO `flux_config` VALUES ('o_regs_verify','0');
INSERT INTO `flux_config` VALUES ('o_report_method','0');
INSERT INTO `flux_config` VALUES ('o_rules','0');
INSERT INTO `flux_config` VALUES ('o_rules_message','Enter your rules here');
INSERT INTO `flux_config` VALUES ('o_searchindex_revision','2');
INSERT INTO `flux_config` VALUES ('o_search_all_forums','1');
INSERT INTO `flux_config` VALUES ('o_show_dot','0');
INSERT INTO `flux_config` VALUES ('o_show_post_count','1');
INSERT INTO `flux_config` VALUES ('o_show_user_info','1');
INSERT INTO `flux_config` VALUES ('o_show_version','0');
INSERT INTO `flux_config` VALUES ('o_signatures','1');
INSERT INTO `flux_config` VALUES ('o_smilies','1');
INSERT INTO `flux_config` VALUES ('o_smilies_sig','1');
INSERT INTO `flux_config` VALUES ('o_smtp_host',NULL);
INSERT INTO `flux_config` VALUES ('o_smtp_pass',NULL);
INSERT INTO `flux_config` VALUES ('o_smtp_ssl','0');
INSERT INTO `flux_config` VALUES ('o_smtp_user',NULL);
INSERT INTO `flux_config` VALUES ('o_timeout_online','300');
INSERT INTO `flux_config` VALUES ('o_timeout_visit','1800');
INSERT INTO `flux_config` VALUES ('o_time_format','H:i:s');
INSERT INTO `flux_config` VALUES ('o_topic_review','15');
INSERT INTO `flux_config` VALUES ('o_topic_subscriptions','1');
INSERT INTO `flux_config` VALUES ('o_topic_views','1');
INSERT INTO `flux_config` VALUES ('o_users_online','1');
INSERT INTO `flux_config` VALUES ('o_webmaster_email','admin@%%domaine_messagerie_etab');
INSERT INTO `flux_config` VALUES ('p_allow_banned_email','1');
INSERT INTO `flux_config` VALUES ('p_allow_dupe_email','0');
INSERT INTO `flux_config` VALUES ('p_force_guest_email','1');
INSERT INTO `flux_config` VALUES ('p_message_all_caps','1');
INSERT INTO `flux_config` VALUES ('p_message_bbcode','1');
INSERT INTO `flux_config` VALUES ('p_message_img_tag','1');
INSERT INTO `flux_config` VALUES ('p_sig_all_caps','1');
INSERT INTO `flux_config` VALUES ('p_sig_bbcode','1');
INSERT INTO `flux_config` VALUES ('p_sig_img_tag','0');
INSERT INTO `flux_config` VALUES ('p_sig_length','400');
INSERT INTO `flux_config` VALUES ('p_sig_lines','4');
INSERT INTO `flux_config` VALUES ('p_subject_all_caps','1');
/*!40000 ALTER TABLE `flux_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `flux_forum_perms`
--

DROP TABLE IF EXISTS `flux_forum_perms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `flux_forum_perms` (
  `group_id` int(10) NOT NULL DEFAULT '0',
  `forum_id` int(10) NOT NULL DEFAULT '0',
  `read_forum` tinyint(1) NOT NULL DEFAULT '1',
  `post_replies` tinyint(1) NOT NULL DEFAULT '1',
  `post_topics` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`group_id`,`forum_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `flux_forum_perms`
--

LOCK TABLES `flux_forum_perms` WRITE;
/*!40000 ALTER TABLE `flux_forum_perms` DISABLE KEYS */;
/*!40000 ALTER TABLE `flux_forum_perms` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `flux_forum_subscriptions`
--

DROP TABLE IF EXISTS `flux_forum_subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `flux_forum_subscriptions` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `forum_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`forum_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `flux_forum_subscriptions`
--

LOCK TABLES `flux_forum_subscriptions` WRITE;
/*!40000 ALTER TABLE `flux_forum_subscriptions` DISABLE KEYS */;
/*!40000 ALTER TABLE `flux_forum_subscriptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `flux_forums`
--

DROP TABLE IF EXISTS `flux_forums`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `flux_forums` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `forum_name` varchar(80) NOT NULL DEFAULT 'New forum',
  `forum_desc` text,
  `redirect_url` varchar(100) DEFAULT NULL,
  `moderators` text,
  `num_topics` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `num_posts` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `last_post` int(10) unsigned DEFAULT NULL,
  `last_post_id` int(10) unsigned DEFAULT NULL,
  `last_poster` varchar(200) DEFAULT NULL,
  `sort_by` tinyint(1) NOT NULL DEFAULT '0',
  `disp_position` int(10) NOT NULL DEFAULT '0',
  `cat_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `flux_forums`
--

LOCK TABLES `flux_forums` WRITE;
/*!40000 ALTER TABLE `flux_forums` DISABLE KEYS */;
INSERT INTO `flux_forums` VALUES (1,'Test forum','This is just a test forum',NULL,NULL,1,1,1314281671,1,'admin',0,1,1);
/*!40000 ALTER TABLE `flux_forums` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `flux_groups`
--

DROP TABLE IF EXISTS `flux_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `flux_groups` (
  `g_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `g_title` varchar(50) NOT NULL DEFAULT '',
  `g_user_title` varchar(50) DEFAULT NULL,
  `g_promote_min_posts` int(10) unsigned NOT NULL DEFAULT '0',
  `g_promote_next_group` int(10) unsigned NOT NULL DEFAULT '0',
  `g_moderator` tinyint(1) NOT NULL DEFAULT '0',
  `g_mod_edit_users` tinyint(1) NOT NULL DEFAULT '0',
  `g_mod_rename_users` tinyint(1) NOT NULL DEFAULT '0',
  `g_mod_change_passwords` tinyint(1) NOT NULL DEFAULT '0',
  `g_mod_ban_users` tinyint(1) NOT NULL DEFAULT '0',
  `g_mod_promote_users` tinyint(1) NOT NULL DEFAULT '0',
  `g_read_board` tinyint(1) NOT NULL DEFAULT '1',
  `g_view_users` tinyint(1) NOT NULL DEFAULT '1',
  `g_post_replies` tinyint(1) NOT NULL DEFAULT '1',
  `g_post_topics` tinyint(1) NOT NULL DEFAULT '1',
  `g_edit_posts` tinyint(1) NOT NULL DEFAULT '1',
  `g_delete_posts` tinyint(1) NOT NULL DEFAULT '1',
  `g_delete_topics` tinyint(1) NOT NULL DEFAULT '1',
  `g_post_links` tinyint(1) NOT NULL DEFAULT '1',
  `g_set_title` tinyint(1) NOT NULL DEFAULT '1',
  `g_search` tinyint(1) NOT NULL DEFAULT '1',
  `g_search_users` tinyint(1) NOT NULL DEFAULT '1',
  `g_send_email` tinyint(1) NOT NULL DEFAULT '1',
  `g_post_flood` smallint(6) NOT NULL DEFAULT '30',
  `g_search_flood` smallint(6) NOT NULL DEFAULT '30',
  `g_email_flood` smallint(6) NOT NULL DEFAULT '60',
  `g_report_flood` smallint(6) NOT NULL DEFAULT '60',
  PRIMARY KEY (`g_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `flux_groups`
--

LOCK TABLES `flux_groups` WRITE;
/*!40000 ALTER TABLE `flux_groups` DISABLE KEYS */;
INSERT INTO `flux_groups` VALUES (1,'Administrators','Administrator',0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0);
INSERT INTO `flux_groups` VALUES (2,'Moderators','Moderator',0,0,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0);
INSERT INTO `flux_groups` VALUES (3,'Guest',NULL,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,1,0,60,30,0,0);
INSERT INTO `flux_groups` VALUES (4,'Member',NULL,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,1,1,1,60,30,60,60);
/*!40000 ALTER TABLE `flux_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `flux_online`
--

DROP TABLE IF EXISTS `flux_online`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `flux_online` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '1',
  `ident` varchar(200) NOT NULL DEFAULT '',
  `logged` int(10) unsigned NOT NULL DEFAULT '0',
  `idle` tinyint(1) NOT NULL DEFAULT '0',
  `last_post` int(10) unsigned DEFAULT NULL,
  `last_search` int(10) unsigned DEFAULT NULL,
  UNIQUE KEY `flux_online_user_id_ident_idx` (`user_id`,`ident`(25)),
  KEY `flux_online_ident_idx` (`ident`(25)),
  KEY `flux_online_logged_idx` (`logged`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `flux_online`
--

LOCK TABLES `flux_online` WRITE;
/*!40000 ALTER TABLE `flux_online` DISABLE KEYS */;
/*!40000 ALTER TABLE `flux_online` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `flux_posts`
--

DROP TABLE IF EXISTS `flux_posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `flux_posts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `poster` varchar(200) NOT NULL DEFAULT '',
  `poster_id` int(10) unsigned NOT NULL DEFAULT '1',
  `poster_ip` varchar(39) DEFAULT NULL,
  `poster_email` varchar(80) DEFAULT NULL,
  `message` mediumtext,
  `hide_smilies` tinyint(1) NOT NULL DEFAULT '0',
  `posted` int(10) unsigned NOT NULL DEFAULT '0',
  `edited` int(10) unsigned DEFAULT NULL,
  `edited_by` varchar(200) DEFAULT NULL,
  `topic_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `flux_posts_topic_id_idx` (`topic_id`),
  KEY `flux_posts_multi_idx` (`poster_id`,`topic_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `flux_posts`
--

LOCK TABLES `flux_posts` WRITE;
/*!40000 ALTER TABLE `flux_posts` DISABLE KEYS */;
INSERT INTO `flux_posts` VALUES (1,'admin',2,'10.0.0.1',NULL,'If you are looking at this (which I guess you are), the install of FluxBB appears to have worked! Now log in and head over to the administration control panel to configure your forum.',0,1314281671,NULL,NULL,1);
/*!40000 ALTER TABLE `flux_posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `flux_reports`
--

DROP TABLE IF EXISTS `flux_reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `flux_reports` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(10) unsigned NOT NULL DEFAULT '0',
  `topic_id` int(10) unsigned NOT NULL DEFAULT '0',
  `forum_id` int(10) unsigned NOT NULL DEFAULT '0',
  `reported_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created` int(10) unsigned NOT NULL DEFAULT '0',
  `message` text,
  `zapped` int(10) unsigned DEFAULT NULL,
  `zapped_by` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `flux_reports_zapped_idx` (`zapped`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `flux_reports`
--

LOCK TABLES `flux_reports` WRITE;
/*!40000 ALTER TABLE `flux_reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `flux_reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `flux_search_cache`
--

DROP TABLE IF EXISTS `flux_search_cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `flux_search_cache` (
  `id` int(10) unsigned NOT NULL DEFAULT '0',
  `ident` varchar(200) NOT NULL DEFAULT '',
  `search_data` mediumtext,
  PRIMARY KEY (`id`),
  KEY `flux_search_cache_ident_idx` (`ident`(8))
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `flux_search_cache`
--

LOCK TABLES `flux_search_cache` WRITE;
/*!40000 ALTER TABLE `flux_search_cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `flux_search_cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `flux_search_matches`
--

DROP TABLE IF EXISTS `flux_search_matches`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `flux_search_matches` (
  `post_id` int(10) unsigned NOT NULL DEFAULT '0',
  `word_id` int(10) unsigned NOT NULL DEFAULT '0',
  `subject_match` tinyint(1) NOT NULL DEFAULT '0',
  KEY `flux_search_matches_word_id_idx` (`word_id`),
  KEY `flux_search_matches_post_id_idx` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `flux_search_matches`
--

LOCK TABLES `flux_search_matches` WRITE;
/*!40000 ALTER TABLE `flux_search_matches` DISABLE KEYS */;
INSERT INTO `flux_search_matches` VALUES (1,1,0);
INSERT INTO `flux_search_matches` VALUES (1,2,0);
INSERT INTO `flux_search_matches` VALUES (1,3,0);
INSERT INTO `flux_search_matches` VALUES (1,4,0);
INSERT INTO `flux_search_matches` VALUES (1,5,0);
INSERT INTO `flux_search_matches` VALUES (1,6,0);
INSERT INTO `flux_search_matches` VALUES (1,7,0);
INSERT INTO `flux_search_matches` VALUES (1,8,0);
INSERT INTO `flux_search_matches` VALUES (1,9,0);
INSERT INTO `flux_search_matches` VALUES (1,10,0);
INSERT INTO `flux_search_matches` VALUES (1,11,0);
INSERT INTO `flux_search_matches` VALUES (1,12,0);
INSERT INTO `flux_search_matches` VALUES (1,13,0);
INSERT INTO `flux_search_matches` VALUES (1,15,1);
INSERT INTO `flux_search_matches` VALUES (1,14,1);
/*!40000 ALTER TABLE `flux_search_matches` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `flux_search_words`
--

DROP TABLE IF EXISTS `flux_search_words`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `flux_search_words` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `word` varchar(20) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`word`),
  KEY `flux_search_words_id_idx` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `flux_search_words`
--

LOCK TABLES `flux_search_words` WRITE;
/*!40000 ALTER TABLE `flux_search_words` DISABLE KEYS */;
INSERT INTO `flux_search_words` VALUES (1,'looking');
INSERT INTO `flux_search_words` VALUES (2,'guess');
INSERT INTO `flux_search_words` VALUES (3,'install');
INSERT INTO `flux_search_words` VALUES (4,'fluxbb');
INSERT INTO `flux_search_words` VALUES (5,'appears');
INSERT INTO `flux_search_words` VALUES (6,'worked');
INSERT INTO `flux_search_words` VALUES (7,'log');
INSERT INTO `flux_search_words` VALUES (8,'head');
INSERT INTO `flux_search_words` VALUES (9,'administration');
INSERT INTO `flux_search_words` VALUES (10,'control');
INSERT INTO `flux_search_words` VALUES (11,'panel');
INSERT INTO `flux_search_words` VALUES (12,'configure');
INSERT INTO `flux_search_words` VALUES (13,'forum');
INSERT INTO `flux_search_words` VALUES (14,'test');
INSERT INTO `flux_search_words` VALUES (15,'post');
/*!40000 ALTER TABLE `flux_search_words` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `flux_topic_subscriptions`
--

DROP TABLE IF EXISTS `flux_topic_subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `flux_topic_subscriptions` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `topic_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`topic_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `flux_topic_subscriptions`
--

LOCK TABLES `flux_topic_subscriptions` WRITE;
/*!40000 ALTER TABLE `flux_topic_subscriptions` DISABLE KEYS */;
/*!40000 ALTER TABLE `flux_topic_subscriptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `flux_topics`
--

DROP TABLE IF EXISTS `flux_topics`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `flux_topics` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `poster` varchar(200) NOT NULL DEFAULT '',
  `subject` varchar(255) NOT NULL DEFAULT '',
  `posted` int(10) unsigned NOT NULL DEFAULT '0',
  `first_post_id` int(10) unsigned NOT NULL DEFAULT '0',
  `last_post` int(10) unsigned NOT NULL DEFAULT '0',
  `last_post_id` int(10) unsigned NOT NULL DEFAULT '0',
  `last_poster` varchar(200) DEFAULT NULL,
  `num_views` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `num_replies` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  `sticky` tinyint(1) NOT NULL DEFAULT '0',
  `moved_to` int(10) unsigned DEFAULT NULL,
  `forum_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `flux_topics_forum_id_idx` (`forum_id`),
  KEY `flux_topics_moved_to_idx` (`moved_to`),
  KEY `flux_topics_last_post_idx` (`last_post`),
  KEY `flux_topics_first_post_id_idx` (`first_post_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `flux_topics`
--

LOCK TABLES `flux_topics` WRITE;
/*!40000 ALTER TABLE `flux_topics` DISABLE KEYS */;
INSERT INTO `flux_topics` VALUES (1,'admin','Test post',1314281671,1,1314281671,1,'admin',0,0,0,0,NULL,1);
/*!40000 ALTER TABLE `flux_topics` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `flux_users`
--

DROP TABLE IF EXISTS `flux_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `flux_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` int(10) unsigned NOT NULL DEFAULT '3',
  `username` varchar(200) NOT NULL DEFAULT '',
  `password` varchar(40) NOT NULL DEFAULT '',
  `email` varchar(80) NOT NULL DEFAULT '',
  `title` varchar(50) DEFAULT NULL,
  `realname` varchar(40) DEFAULT NULL,
  `url` varchar(100) DEFAULT NULL,
  `jabber` varchar(80) DEFAULT NULL,
  `icq` varchar(12) DEFAULT NULL,
  `msn` varchar(80) DEFAULT NULL,
  `aim` varchar(30) DEFAULT NULL,
  `yahoo` varchar(30) DEFAULT NULL,
  `location` varchar(30) DEFAULT NULL,
  `signature` text,
  `disp_topics` tinyint(3) unsigned DEFAULT NULL,
  `disp_posts` tinyint(3) unsigned DEFAULT NULL,
  `email_setting` tinyint(1) NOT NULL DEFAULT '1',
  `notify_with_post` tinyint(1) NOT NULL DEFAULT '0',
  `auto_notify` tinyint(1) NOT NULL DEFAULT '0',
  `show_smilies` tinyint(1) NOT NULL DEFAULT '1',
  `show_img` tinyint(1) NOT NULL DEFAULT '1',
  `show_img_sig` tinyint(1) NOT NULL DEFAULT '1',
  `show_avatars` tinyint(1) NOT NULL DEFAULT '1',
  `show_sig` tinyint(1) NOT NULL DEFAULT '1',
  `timezone` float NOT NULL DEFAULT '0',
  `dst` tinyint(1) NOT NULL DEFAULT '0',
  `time_format` tinyint(1) NOT NULL DEFAULT '0',
  `date_format` tinyint(1) NOT NULL DEFAULT '0',
  `language` varchar(25) NOT NULL DEFAULT 'English',
  `style` varchar(25) NOT NULL DEFAULT 'Air',
  `num_posts` int(10) unsigned NOT NULL DEFAULT '0',
  `last_post` int(10) unsigned DEFAULT NULL,
  `last_search` int(10) unsigned DEFAULT NULL,
  `last_email_sent` int(10) unsigned DEFAULT NULL,
  `last_report_sent` int(10) unsigned DEFAULT NULL,
  `registered` int(10) unsigned NOT NULL DEFAULT '0',
  `registration_ip` varchar(39) NOT NULL DEFAULT '0.0.0.0',
  `last_visit` int(10) unsigned NOT NULL DEFAULT '0',
  `admin_note` varchar(30) DEFAULT NULL,
  `activate_string` varchar(80) DEFAULT NULL,
  `activate_key` varchar(8) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `flux_users_username_idx` (`username`(25)),
  KEY `flux_users_registered_idx` (`registered`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `flux_users`
--

LOCK TABLES `flux_users` WRITE;
/*!40000 ALTER TABLE `flux_users` DISABLE KEYS */;
INSERT INTO `flux_users` VALUES (1,3,'Guest','Guest','Guest',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,0,1,1,1,1,1,0,0,0,0,'French','Air',0,NULL,NULL,NULL,NULL,0,'0.0.0.0',0,NULL,NULL,NULL);
INSERT INTO `flux_users` VALUES (2,1,'admin','d033e22ae3480005660fc2140ae555550c4da997','admin@%%domaine_messagerie_etab',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,0,1,1,1,1,1,0,0,0,0,'French','Air',1,1314281671,NULL,NULL,NULL,1314281671,'10.0.0.1',1314281671,NULL,NULL,NULL);
/*!40000 ALTER TABLE `flux_users` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2017-07-05  9:24:28
