\r fluxbb
SET character_set_client = utf8;

-- ------------------------------------------------------------------------------------------------------------------------------------------
-- Traité uniquement si fluxbb est activé ---------------------------------------------------------------------------------------------------
-- ------------------------------------------------------------------------------------------------------------------------------------------
%if %%is_defined('activer_fluxbb') and %%activer_fluxbb == 'oui'


-- ------------------------------------------------------------------------------------------------------------------------------------------
-- Fixe config Envole -----------------------------------------------------------------------------------------------------------------------
-- ------------------------------------------------------------------------------------------------------------------------------------------
UPDATE `flux_config` SET `conf_value` =  'admin@%%domaine_messagerie_etab' WHERE conf_name = 'o_mailing_list';
UPDATE `flux_config` SET `conf_value` =  'admin@%%domaine_messagerie_etab' WHERE conf_name = 'o_admin_email';
UPDATE `flux_config` SET `conf_value` =  'admin@%%domaine_messagerie_etab' WHERE conf_name = 'o_webmaster_email';
UPDATE `flux_config` SET `conf_value` =  'https://%%web_url/fluxbb' WHERE conf_name = 'o_base_url';


-- ------------------------------------------------------------------------------------------------------------------------------------------
-- Fixe config générale ---------------------------------------------------------------------------------------------------------------------
-- ------------------------------------------------------------------------------------------------------------------------------------------
UPDATE  `fluxbb`.`flux_config` SET  `conf_value` =  '0' WHERE  `flux_config`.`conf_name` =  'o_regs_allow';


-- ------------------------------------------------------------------------------------------------------------------------------------------
-- Procédure et fonction d'ajout de colonne si elle n'existe pas
-- https://stackoverflow.com/questions/972922/add-column-to-mysql-table-if-it-does-not-exist
-- ------------------------------------------------------------------------------------------------------------------------------------------
DELIMITER $$

DROP PROCEDURE IF EXISTS addFieldIfNotExists 
$$
DROP FUNCTION IF EXISTS isFieldExisting 
$$

CREATE FUNCTION isFieldExisting (
    table_name_IN VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_general_ci
    , field_name_IN VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_general_ci
 ) 
RETURNS INT
RETURN (
    SELECT COUNT(COLUMN_NAME) 
    FROM INFORMATION_SCHEMA.columns 
    WHERE TABLE_SCHEMA = DATABASE() 
    AND TABLE_NAME = table_name_IN 
    AND COLUMN_NAME = field_name_IN
)
$$

CREATE PROCEDURE addFieldIfNotExists (
    IN table_name_IN VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_general_ci
    , IN field_name_IN VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_general_ci
    , IN field_definition_IN VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_general_ci
)
BEGIN
    -- http://javajon.blogspot.com/2012/10/mysql-alter-table-add-column-if-not.html
    SET @isFieldThere = isFieldExisting(table_name_IN, field_name_IN);
    IF (@isFieldThere = 0) THEN
        SET @ddl = CONCAT('ALTER TABLE ', table_name_IN);
        SET @ddl = CONCAT(@ddl, ' ', 'ADD COLUMN') ;
        SET @ddl = CONCAT(@ddl, ' ', field_name_IN);
        SET @ddl = CONCAT(@ddl, ' ', field_definition_IN);
        PREPARE stmt FROM @ddl;
        EXECUTE stmt;
        DEALLOCATE PREPARE stmt;
    END IF;
END;
$$
DELIMITER ;


-- ------------------------------------------------------------------------------------------------------------------------------------------
-- UPGRADE 1.4.3 TO 1.5.3 -------------------------------------------------------------------------------------------------------------------
-- ------------------------------------------------------------------------------------------------------------------------------------------
DROP PROCEDURE IF EXISTS 143to153;
DELIMITER |
CREATE PROCEDURE 143to153()
BEGIN
	UPDATE flux_config SET conf_value = '1.5.3' WHERE conf_name = 'o_cur_version';
	UPDATE flux_config SET conf_value = '18' WHERE conf_name = 'o_database_revision';
	UPDATE flux_config SET conf_value = '2' WHERE conf_name = 'o_parser_revision';
	UPDATE flux_config SET conf_value = '2' WHERE conf_name = 'o_searchindex_revision';

	INSERT IGNORE INTO flux_config (conf_name, conf_value) VALUES ('o_feed_ttl', '0');
	DELETE FROM flux_config WHERE conf_name='o_ranks';

	CALL addFieldIfNotExists ('flux_groups', 'g_promote_min_posts', 'INT(10) UNSIGNED NOT NULL DEFAULT \'0\' AFTER g_user_title');
	CALL addFieldIfNotExists ('flux_groups', 'g_promote_next_group', ' INT(10) UNSIGNED NOT NULL DEFAULT \'0\' AFTER g_promote_min_posts');
	CALL addFieldIfNotExists ('flux_groups', 'g_post_links', 'TINYINT(1) NOT NULL DEFAULT \'1\' AFTER g_delete_topics');
	CALL addFieldIfNotExists ('flux_groups', 'g_report_flood', 'SMALLINT(6) NOT NULL DEFAULT \'60\' AFTER g_email_flood');

	CALL addFieldIfNotExists ('flux_users', 'last_report_sent', 'INT(10) UNSIGNED DEFAULT NULL AFTER last_email_sent');

	UPDATE flux_groups SET g_send_email = 0 WHERE g_id = 3;
	UPDATE flux_groups SET g_email_flood = 0, g_report_flood = 0 WHERE g_id IN (1,2,3);

	DROP TABLE IF EXISTS flux_ranks;
END|
DELIMITER ;
 
CALL 143to153();
DROP PROCEDURE 143to153;


-- ------------------------------------------------------------------------------------------------------------------------------------------
-- UPGRADE 1.5.3 TO 1.5.10 ------------------------------------------------------------------------------------------------------------------
-- ------------------------------------------------------------------------------------------------------------------------------------------
DROP PROCEDURE IF EXISTS 153to1510;
DELIMITER |
CREATE PROCEDURE 153to1510()
BEGIN
	CALL addFieldIfNotExists ('flux_groups', 'g_mod_promote_users', 'TINYINT(1) NOT NULL DEFAULT \'0\' AFTER g_mod_ban_users');

	UPDATE flux_config SET conf_value = '1.5.10' WHERE conf_name = 'o_cur_version';
	UPDATE flux_config SET conf_value = '21' WHERE conf_name = 'o_database_revision';	
END|
DELIMITER ;

CALL 153to1510();
DROP PROCEDURE 153to1510;


-- ------------------------------------------------------------------------------------------------------------------------------------------
-- UPGRADE a.b.c TO x.y.z -------------------------------------------------------------------------------------------------------------------
-- ------------------------------------------------------------------------------------------------------------------------------------------
-- TODO : prochaine mise à jour ici


-- ------------------------------------------------------------------------------------------------------------------------------------------
-- Suppression des procédures et fonctions en sortant ---------------------------------------------------------------------------------------
-- ------------------------------------------------------------------------------------------------------------------------------------------
DROP PROCEDURE IF EXISTS addFieldIfNotExists;
DROP FUNCTION IF EXISTS isFieldExisting;


-- ------------------------------------------------------------------------------------------------------------------------------------------
-- FLUXBB = Création admin secondaire -------------------------------------------------------------------------------------------------------
-- ------------------------------------------------------------------------------------------------------------------------------------------
%if %%is_defined('activer_addadmin') and %%activer_addadmin == 'oui'

DROP PROCEDURE IF EXISTS AddAdminFluxbb;
delimiter |
CREATE PROCEDURE AddAdminFluxbb(_adminuser VARCHAR( 32 ))
BEGIN
    DECLARE ad_id INT DEFAULT 0;

    SELECT COUNT(*) INTO ad_id FROM flux_users WHERE username=_adminuser COLLATE utf8_unicode_ci;

    IF ad_id = 0 THEN
        INSERT INTO `flux_users` (`group_id` ,`username` ,`password` ,`email` ,`title` ,`realname` ,`url` ,`jabber` ,`icq` ,`msn` ,`aim` ,`yahoo` ,`location` ,`signature` ,`disp_topics` ,`disp_posts` ,
		`email_setting` ,`notify_with_post` ,`auto_notify` ,`show_smilies` ,`show_img` ,`show_img_sig` ,`show_avatars` ,`show_sig` ,`timezone` ,`dst` ,`time_format` ,`date_format` ,
		`language` ,`style` ,`num_posts` ,`last_post` ,`last_search` ,`last_email_sent` ,`last_report_sent` ,`registered` ,`registration_ip` ,`last_visit` ,`admin_note` ,`activate_string` ,`activate_key`
		)
		VALUES (
		'1', _adminuser, '', '', NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , '1', '0', '0', '1', '1', '1', '1', '1', '0', '0', '0', '0', 'French', 'Air', '0', NULL , NULL , NULL , NULL , '0', '0.0.0.0', '0', NULL , NULL , NULL
		);
    END IF;

    UPDATE flux_users SET group_id = 1 WHERE username = _adminuser COLLATE utf8_unicode_ci;

END|
DELIMITER ;

CALL AddAdminFluxbb('%%uid_addadmin');
%end if


-- ------------------------------------------------------------------------------------------------------------------------------------------
-- Fin du if traitement uniquement si fluxbb est activé -------------------------------------------------------------------------------------
-- ------------------------------------------------------------------------------------------------------------------------------------------
%end if
