<?php
session_start();
define("GEPI_ROOT", "/var/www/html/gepi/");
//test version de php
if (version_compare(PHP_VERSION, '5') < 0) {
    die('GEPI nécessite PHP5 pour fonctionner');
}

// Pour le multisite
if (isset($_GET["rne"])) {
	setcookie('RNE', $_GET["rne"], null, '/');
}

$niveau_arbo = 0;
$prevent_session_init = true; // On bloque l'initialisation automatique de la session.

// Cas particulier du single sign-out CAS
// On doit empêcher le filtrage de $_POST['logoutRequest'], qui contient des
// caractères spéciaux
if (isset($_POST) && array_key_exists('logoutRequest', $_POST)) {
    $logout_request = $_POST['logoutRequest'];
}
// Initialisations files
require_once("./lib/initialisations.inc.php");
include("./lib/initialisationsPropel.inc.php");

$auth_sso = in_array($gepiSettings['auth_sso'], array("lemon", "cas", "lcs"));

# Cette page a pour vocation de gérer les authentification SSO.
# Si l'authentification SSO n'est pas paramétrée, on renvoie tout de suite
# vers la page de login classique.

if (!$auth_sso) {
	session_write_close();
	header("Location:login.php");
	die();
}

// Authentification CAS : la session doit être gérée par phpCAS directement
// Il est donc indispensable de placer toute l'initialisation ici, et
// d'instancier la classe 'Session' sans initialiser la session php, qui
// sera déjà initialisée.
if ($gepiSettings['auth_sso'] == 'cas') {
		include_once('./lib/CAS.php');
		if ($mode_debug) {
		    phpCAS::setDebug($debug_log_file);
    }
		// config_cas.inc.php est le fichier d'informations de connexions au serveur cas
		$path = "./secure/config_cas.inc.php";
		include($path);

		# On défini l'URL de base, pour que phpCAS ne se trompe pas dans la génération
		# de l'adresse de retour vers le service (attention, requiert patchage manuel
		# de phpCAS !!)
		if (isset($gepiBaseUrl)) {
			$url_base = $gepiBaseUrl;
		} else {
			$url_base = Session::https_request() ? 'https' : 'http';
			$url_base .= '://';
			$url_base .= $_SERVER['SERVER_NAME'];
		}

    // La session doit être nommée de la même manière dans Session.class.php
    // sinon ça ne marchera pas...
    session_name("GEPI");

		// Le premier argument est la version du protocole CAS
		// Le dernier argument a été ajouté par patchage manuel de phpCAS.
		settype($cas_port, "integer");
		phpCAS::client(CAS_VERSION_2_0, $cas_host, $cas_port, $cas_root, true, $url_base);
		phpCAS::setLang(PHPCAS_LANG_FRENCH);

		// redirige vers le serveur d'authentification si aucun utilisateur authentifié n'a
		// été trouvé par le client CAS.
		phpCAS::setNoCasServerValidation();

    // On a une demande de logout envoyée par le serveur CAS :
    //   il faut initialiser la session tout de suite, pour pouvoir la détruire complètement
    if (isset($logout_request)) {
      $session_gepi = new Session();
  		// Gestion du single sign-out
      phpCAS::setSingleSignoutCallback(array($session_gepi, 'cas_logout_callback'));
		  phpCAS::handleLogoutRequests(false);
		}
		// Authentification
		phpCAS::forceAuthentication();

    // Initialisation de la session, avec blocage de l'initialisation de la
    // session php ainsi que des tests de timeout et update de logs,
    // car l'authentification CAS n'est pas encore validée côté Gepi !
    $session_gepi = new Session(true);
} else {
  $session_gepi = new Session();
}



# L'instance de Session permettant de gérer directement les authentifications
# SSO, on ne s'embête pas :
$auth = $session_gepi->authenticate();
$PATH="../posh-profil/";
if($session_gepi->statut != "administrateur"){
    header('Location: '.$PATH.'no.php');

}

require_once GEPI_ROOT."lib/initialisationsPropel.inc.php";
require_once GEPI_ROOT.'lib/initialisations.inc.php';
require_once GEPI_ROOT.'lib/LDAPServerScribe.class.php';
require_once GEPI_ROOT.'init_scribe_ng/eleves_fonctions.php';
require_once GEPI_ROOT.'init_scribe_ng/config_init_annuaire.inc.php';
require_once GEPI_ROOT.'lib/header.inc.php';

include_once($PATH."include/envole.php");
include_once($PATH."include/mysql.php");

include_once($PATH.$config["templatedir"]."/html.php");
//include_once($PATH.$config["templatedir"]."/frame.php");

$db1=new ps_db;

$q = "SELECT * FROM admin_gepi WHERE id=1";
$db1->query($q);

$recordset = ( $db1->num_rows() >= 1 ) ? true : false;

if ( isset($_POST['submitted']) AND $_POST['submitted'] == 'true')
{

	$gv = array(0,1);
	$sEleves = ( in_array($_POST['synchroEleves'], $gv)) ? $_POST['synchroEleves'] : 0;
	$sResp = ( in_array($_POST['synchroResp'], $gv)) ? $_POST['synchroResp'] : 0;
	$sProfs = ( in_array($_POST['synchroProfs'], $gv)) ? $_POST['synchroProfs'] : 0;

	if($recordset)
	{
		$q = "UPDATE admin_gepi SET synchro_eleves=".$sEleves.", synchro_resp=".$sResp.", synchro_profs=".$sProfs." WHERE id=1";
	}
	else
	{
		$q = "INSERT INTO  admin_gepi (id, synchro_eleves, synchro_resp, synchro_profs) VALUES (1,".$sEleves.",".$sResp.",".$sProfs.")";
	}

	$db1->query($q);
}


$q = "SELECT * FROM admin_gepi WHERE id=1";
$db1->query($q);


$synchroEleves = 0;
$synchroResp = 0;
$synchroProfs = 0;

$db1->next_record();

$synchroEleves = $db1->f('synchro_eleves');
$synchroResp = $db1->f('synchro_resp');
$synchroProfs = $db1->f('synchro_profs');

?>
<link rel="stylesheet" type="text/css" href="https://sr13-scribet-02.ac-poitiers.fr/posh-profil/styles/default/frame.css" />
<style>
html {
    margin-top: 0px !important;
    height: 100%;
}
body{
    margin: 10px !important;
    overflow: auto !important;
}
#container{
    padding: 0px;
}
h1 {
    font-size: 30px !important;
    background-color: #3498DB;
    color: #FFF;
    padding: 10px !important;
    margin-bottom: 10px !important;
    text-align: center;
	font-style: normal;
	font-variant: small-caps;
	font-weight: normal;
	font-family: Arial !important;
}
h2{
	margin-top: 5px !important;
}
	.menu {
		display: inline-block;
	}

	.submenu {
		display: none;
		position: absolute;
		margin: 0px 0px 0px 0px;
		background-color: #F0F0F0;
		width: 190px;
		padding: 5px;
		border: 1px solid;
		cursor: pointer;
	}

	.submenu > ul{
		list-style-type: none;
	}

	.submenu > ul > li > ul{
		display: none;
		list-style-type: none;
		position: absolute;
		margin: -22px 0px 0px 190px;
		background-color: #F0F0F0;
		width: 150px;
		padding: 5px;
		border: 1px solid;
		cursor: pointer;
	}
</style>
<script type="text/javascript">
	function clicksynchro(){
		document.getElementById("wait").style.display = "block";
		$.ajax({
			url: "gepi-synchro.php",
			success: function(result){
				$("#wait").html("<h1>SYNCHRONISATION TERMINÉE</h1>"+result);
			}
		})

	}
</script>
</head>
<body>
<h1>SYNCHRONISATION GEPI</h1>
<form name='Formulaire' enctype='multipart/form-data' action='#' method='post'>
<input type='hidden' name='submitted' value='true' />
<input id='vlmod' name='vlmod' class='input-rounded-button' type='submit' value='Enregistrer' />
&nbsp;
<input id='vlsyn' name='vlsyn' class='input-rounded-button' type='button' onClick='clicksynchro()' value='Synchroniser' />
<h2>Paramètrage</h2>
<fieldset id="encadrer">
		<p>
		<span id="encadrer_label" style='width:74%; border-bottom: dotted 1px'>
		Synchroniser les élèves et les  classes
		</span>
		<select	id="synchroEleves" name="synchroEleves" size="1" style='width: 25%;'>>
			<option value=0	>non</option>
			<option value=1	<?php if($synchroEleves){echo "selected";}?>>oui</option>
		</select>
		</p>

		<p>
		<span id="encadrer_label" style='width:74%; border-bottom: dotted 1px'>
		Synchroniser les responsables
		</span>
		<select	id="synchroResp" name="synchroResp" size="1" style='width: 25%;'>>
			<option value=0	>non</option>
			<option value=1	<?php if($synchroResp){echo "selected";}?>>oui</option>
		</select>
		</p>
		<p>
		<span id="encadrer_label" style='width:74%; border-bottom: dotted 1px'>
		Synchroniser les enseignants, les équipes et les matières
		</span>
		<select	id="synchroProfs" name="synchroProfs" size="1" style='width: 25%;'>>
			<option value=0	>non</option>
			<option value=1	<?php if($synchroProfs){echo "selected";}?>>oui</option>
		</select>
		</p>
	</fieldset>

<div id='wait'><center><h1>SYNCHRONISATION EN COURS</h1><img src='<?php echo $PATH; ?>/images/wait.gif'></center></div>
<div id='info'><h1>SYNCHRONISATION TERMINÉE</h1></div>

</form>
</body>
