define("dojo/Evented", ["./aspect", "./on"], function(aspect, on){
	// module:
	//		dojo/Evented

 	"use strict";
 	var after = aspect.after;
	function Evented(){
		// summary:
		//		A class that can be used as a mixin or base class,
		//		to add on() and emit() methods to a class
		//		for listening for events and emitting events:
		//
		//		|	define(["dojo/Evented"], function(Evented){
		//		|		var EventedWidget = dojo.declare([Evented, dijit._Widget], {...});
		//		|		widget = new EventedWidget();
		//		|		widget.on("open", function(event){
		//		|		... do something with event
		//		|	 });
		//		|
		//		|	widget.emit("open", {name:"some event", ...});
	}
	Evented.prototype = {
		on: function(type, listener){
			return on.parse(this, type, listener, function(target, type){
				return after(target, 'on' + type, listener, true);
			});
		},
		emit: function(type, event){
			var args = [this];
			args.push.apply(args, arguments);
			return on.emit.apply(on, args);
		}
	};
	return Evented;
});
