<?php
session_start();
define("GEPI_ROOT", "/var/www/html/gepi/");



//test version de php
if (version_compare(PHP_VERSION, '5') < 0) {
    die('GEPI nécessite PHP5 pour fonctionner');
}

// Pour le multisite
if (isset($_GET["rne"])) {
	setcookie('RNE', $_GET["rne"], null, '/');
}

$niveau_arbo = 0;
$prevent_session_init = true; // On bloque l'initialisation automatique de la session.

// Cas particulier du single sign-out CAS
// On doit empêcher le filtrage de $_POST['logoutRequest'], qui contient des
// caractères spéciaux
if (isset($_POST) && array_key_exists('logoutRequest', $_POST)) {
    $logout_request = $_POST['logoutRequest'];
}
// Initialisations files
require_once("./lib/initialisations.inc.php");
include("./lib/initialisationsPropel.inc.php");

$auth_sso = in_array($gepiSettings['auth_sso'], array("lemon", "cas", "lcs"));

if ($auth_sso && isset($logout_request)) {
    $_POST['logoutRequest'] = $logout_request;
}

# Cette page a pour vocation de gérer les authentification SSO.
# Si l'authentification SSO n'est pas paramétrée, on renvoie tout de suite
# vers la page de login classique.

if (!$auth_sso) {
	session_write_close();
	header("Location:login.php");
	die();
}

// Authentification CAS : la session doit être gérée par phpCAS directement
// Il est donc indispensable de placer toute l'initialisation ici, et
// d'instancier la classe 'Session' sans initialiser la session php, qui
// sera déjà initialisée.
if ($gepiSettings['auth_sso'] == 'cas') {
		include_once('./lib/CAS.php');
		if ($mode_debug) {
		    phpCAS::setDebug($debug_log_file);
    }
		// config_cas.inc.php est le fichier d'informations de connexions au serveur cas
		$path = "./secure/config_cas.inc.php";
		include($path);

		# On défini l'URL de base, pour que phpCAS ne se trompe pas dans la génération
		# de l'adresse de retour vers le service (attention, requiert patchage manuel
		# de phpCAS !!)
		if (isset($gepiBaseUrl)) {
			$url_base = $gepiBaseUrl;
		} else {
			$url_base = Session::https_request() ? 'https' : 'http';
			$url_base .= '://';
			$url_base .= $_SERVER['SERVER_NAME'];
		}

    // La session doit être nommée de la même manière dans Session.class.php
    // sinon ça ne marchera pas...
    session_name("GEPI");

		// Le premier argument est la version du protocole CAS
		// Le dernier argument a été ajouté par patchage manuel de phpCAS.
		settype($cas_port, "integer");
		phpCAS::client(CAS_VERSION_2_0, $cas_host, $cas_port, $cas_root, true, $url_base);
		phpCAS::setLang(PHPCAS_LANG_FRENCH);

		// redirige vers le serveur d'authentification si aucun utilisateur authentifié n'a
		// été trouvé par le client CAS.
		phpCAS::setNoCasServerValidation();

    // On a une demande de logout envoyée par le serveur CAS :
    //   il faut initialiser la session tout de suite, pour pouvoir la détruire complètement
    if (isset($logout_request)) {
      $session_gepi = new Session();
  		// Gestion du single sign-out
      phpCAS::setSingleSignoutCallback(array($session_gepi, 'cas_logout_callback'));
		  phpCAS::handleLogoutRequests(false);
		}
		// Authentification
		phpCAS::forceAuthentication();

    // Initialisation de la session, avec blocage de l'initialisation de la
    // session php ainsi que des tests de timeout et update de logs,
    // car l'authentification CAS n'est pas encore validée côté Gepi !
    $session_gepi = new Session(true);
} else {
  $session_gepi = new Session();
}



# L'instance de Session permettant de gérer directement les authentifications
# SSO, on ne s'embête pas :
$auth = $session_gepi->authenticate();



$PATH="../posh-profil/";
if($session_gepi->statut != "administrateur"){
        header('Location: '.$PATH.'no.php');

}

$niveau_arbo = 0;
require_once GEPI_ROOT."lib/initialisationsPropel.inc.php";
require_once GEPI_ROOT.'lib/initialisations.inc.php';
require_once GEPI_ROOT.'lib/LDAPServerScribe.class.php';
require_once GEPI_ROOT.'init_scribe_ng/eleves_fonctions.php';
require_once GEPI_ROOT.'init_scribe_ng/config_init_annuaire.inc.php';
//require_once GEPI_ROOT.'lib/header.inc.php';

include_once($PATH."include/envole.php");
if(file_exists($PATH."include/dbconf.php")) include_once($PATH."include/dbconf.php");
include_once($PATH."include/mysql.php");
include_once($PATH.$config["templatedir"]."/html.php");


include_once('./lib/CAS.php');

function get_all_classes($ldap) {
    $filter = "(type=Classe)";
    error_log("Branche=o=gouv,c=fr"."<br>Filtre=".$filter);
    $sr = ldap_search($ldap->ds, 'o=gouv,c=fr', $filter);
    $classes = array();
    $classes= ldap_get_entries($ldap->ds, $sr);
    if (!array_key_exists(0, $classes)) {
        $classes = false;
        error_log("Aucune classe trouve");
    }
    
    return $classes;
}
    

function synchro_eleves($ldap)
{
	$eleves = $ldap->get_all_eleves();

	echo "<h3> Mise à jour des élèves</h3>";
	/**
	 * Création des élèves
	 */
	$nb_new = 0;
	$nb_mod = 0;
	for($nb = 0; $nb <= $eleves['count']; $nb++)
	{
		$new = false;
		$eleve = EleveQuery::create()
		->filterByLogin($eleves[$nb][$ldap->champ_login][0])
		->findOne();
		if($eleves[$nb][$ldap->champ_login][0] == ""){
			continue;
		}
		if ( is_null($eleve))
		{
			$nouvel_eleve =  new Eleve();
			$nouvel_eleve->setLogin($eleves[$nb][$ldap->champ_login][0]);
			$new = true;
		}
		else
		{
			$nouvel_eleve = $eleve;
		}

		$nouvel_eleve->setNom($eleves[$nb][$ldap->champ_nom][0]);
		$nouvel_eleve->setPrenom($eleves[$nb][$ldap->champ_prenom][0]);
		$nouvel_eleve->setSexe($eleves[$nb]['entpersonsexe'][0]);
		$nouvel_eleve->setNaissance(formater_date_pour_mysql($eleves[$nb]['entpersondatenaissance'][0]));
		$nouvel_eleve->setLieuNaissance('');
		$ele_no_et = (array_key_exists('employeenumber', $eleves[$nb])) ? $eleves[$nb]['employeenumber'][0] : '';
		$nouvel_eleve->setElenoet($ele_no_et);
		$nouvel_eleve->setEreno('');

	    /**
	     * Gestion des régimes
	     */
	    $entRegime = $eleves[$nb]['enteleveregime'][0];

	    $ele_id = (array_key_exists('intid', $eleves[$nb])) ? $eleves[$nb]['intid'][0] : false;
	    // L'ele_id est très important dans Gepi pour le lien eleve/responsable, mais dans Scribe il ne peut pas
	    // etre spécifié manuellement (seulement à l'import depuis Sconet). En conséquence, s'il est absent,
	    // on le remplace par le noet, en espérant qu'il n'y ait pas de conflit ! (en principe non)
	    if (!$ele_id and $ele_no_et != '') $ele_id = $ele_no_et;

	    $nouvel_eleve->setEleid($ele_id);
	    $nouvel_eleve->setNoGep($eleves[$nb]['ine'][0]);
	    $nouvel_eleve->setEmail($eleves[$nb][$ldap->champ_email][0]);

	    // On ne peut créer l'élève que s'il a un ele_id. Sinon, ça ne va pas marcher correctement !
	    if ($ele_id)
	    {
	    /*
	     * Récupération des CLASSES de l'eleve :
	     * Pour chaque eleve, on parcours ses classes, et on ne prend que celles
	     * qui correspondent à la branche de l'établissement courant, et on les stocke
	     */
	    $nb_classes = $eleves[$nb]['enteleveclasses']['count'];

	    // Pour chaque classe trouvée..
	    $classe_from_ldap = array();
	    for ($cpt=0; $cpt<$nb_classes; $cpt++) {
	    	$classe_from_ldap = explode("$", $eleves[$nb]['enteleveclasses'][$cpt]);
	          // $classe_from_ldap[0] contient le DN de l'établissement
	          // $classe_from_ldap[1] contient l'id de la classe
	    	$code_classe = $classe_from_ldap[1];

	          // Si le SIREN de la classe trouvée correspond bien au SIREN de l'établissement courant,
	          // on crée une entrée correspondante dans le tableau des classes disponibles
	          // Sinon c'est une classe d'un autre établissement, on ne doit donc pas en tenir compte
	    	if (strcmp($classe_from_ldap[0], $ldap->get_base_branch()) == 0) {

	            /*
	             * On test si la classe que l'on souhaite ajouter existe déjà
	             * en la cherchant dans la base (
	             */
	            $crit = new Criteria();
	            $crit->add(ClassePeer::CLASSE, $code_classe);
	            $classe_select = ClassePeer::doSelect($crit);
	            $classe_courante = null;
	            // Si elle n'existe pas
	            if (count($classe_select) == 0) {
	                /*
	                * Creation de la classe correspondante
	                */
	                $nouvelle_classe = new Classe();
	                $nouvelle_classe->setNom($code_classe);
	                $nouvelle_classe->save();
	                $classes_inserees++;
	                $classe_courante = $nouvelle_classe;
	                // On crééra les périodes associées a la classe par la suite
	            }
	            else if (count($classe_select) == 1){
	            	$classe_courante = $classe_select[0];
	            }
	            // Si plus d'une classe trouvee, erreur...
	            else {
	            	die ("erreur dans la base : plusieurs classes ont le meme nom.<br>");
	            }
	            if($new)
	            {
	            	$reqSearchPeriode = "SELECT max(num_periode) as nb_periods FROM periodes WHERE id_classe=".$classe_courante->getId();
	            	$t = mysqli_query($GLOBALS['mysqli'],$reqSearchPeriode);
	            	while($o = mysqli_fetch_object($t))
	            	{
	            		$max = $o->nb_periods;
	            	}
	            	for ($i=1; $i<=$max; $i++)
	            	{
	    	        // Comme on n'a pas encore de périodes, on va tricher un peu
	        	    // pour la définition de l'association élève-classe
	            		$nouvelle_assoc_classe_eleve = new JEleveClasse();
	            		$nouvelle_assoc_classe_eleve->setClasse($classe_courante);
	            		$nouvelle_assoc_classe_eleve->setEleve($nouvel_eleve);
	            		// Pour le moment on met 0 dans l'id de periode, car on les créera plus tard.
	            		// On veut simplement garder l'association eleve/classe pour ne pas avoir
	            		// a refaire une connexion au LDAP a l'etape suivante
	            		$nouvelle_assoc_classe_eleve->setPeriode($i);
	            		$nouvelle_assoc_classe_eleve->save();
	            		$nouvel_eleve->addJEleveClasse($nouvelle_assoc_classe_eleve);
	            	}
	            }
	        } //Fin du if classe appartient a l'etablissement courant
	    } //Fin du parcours des classes de l'eleve

	    $nouvel_eleve->save();
	    switch($entRegime)
	    {
	    	case "DEMI-PENSIONNAIRE DANS L'ETABLISSEMENT":
	    	{
	    		$reg = "d/p";
	    		break;
	    	}
	    	case "INTERNE DANS L'ETABLISSEMENT":
	    	{
	    		$reg = "int.";
	    		break;
	    	}
	    	case "EXTERNE LIBRE":
	    	{
	    		$reg = "ext.";
	    		break;
	    	}
	    	default:
	    	{
	    		$reg = "d/p";
	    	}
	    }
	    $reqDelete = mysqli_query($GLOBALS['mysqli'], "DELETE FROM j_eleves_regime WHERE login='".$nouvel_eleve->getLogin());
	    $reqReg = "INSERT INTO j_eleves_regime (login, regime)  VALUES ('".$nouvel_eleve->getLogin()."', '".$reg."')";
	    $a = mysqli_query($GLOBALS["mysqli"], $reqReg);
	    if ($new)
	    {
	    	$nb_new += 1;
	    }else
	    {
	    	$nb_mod += 1;
	    }

	    $compte_utilisateur_eleve = UtilisateurProfessionnelPeer::retrieveByPK($nouvel_eleve->getLogin());
        if ($compte_utilisateur_eleve != null) {
            // Un compte d'accès avec le même identifiant existe déjà. On ne touche à rien.
        }
        else {
	        $new_compte_utilisateur = new UtilisateurProfessionnel();
            $new_compte_utilisateur->setAuthMode('sso');
            $new_compte_utilisateur->setCivilite($eleves[$nb]['personaltitle'][0]);
            $new_compte_utilisateur->setEmail($nouvel_eleve->getEmail());
            $new_compte_utilisateur->setEtat('actif');
            $new_compte_utilisateur->setLogin($nouvel_eleve->getLogin());
            $new_compte_utilisateur->setNom($nouvel_eleve->getNom());
            $new_compte_utilisateur->setPrenom($nouvel_eleve->getPrenom());
            $new_compte_utilisateur->setShowEmail('no');
            $new_compte_utilisateur->setStatut('eleve');
            $new_compte_utilisateur->save();
      	}

	    $eleves_inseres++;
	}
}
if($nb_new > 0)
{
	echo $nb_new." &eacute;l&egrave;ves ajout&eacute;s.<br/>";
}
if($nb_mod > 0)
{
	echo $nb_mod." &eacute;l&egrave;ves ont été mis &agrave; jour.<br/>";
}

echo "Mise à jour nom long classes<br>";
echo "<br/><br/>";
}

function synchro_classes($ldap) {
    $classes=get_all_classes($ldap);
    

    foreach($classes as $classes) {
	    $reqReg = "UPDATE classes SET nom_complet='".addslashes($classes["description"][0])."' WHERE classe='".$classes["cn"][0]."'";
	    $a = mysqli_query($GLOBALS["mysqli"], $reqReg);        
    }
}
    
function synchro_resp($ldap)
{
	$responsables = $ldap->get_all_responsables();
	$nb_responsables = $responsables['count'];

	$reqMenage = 'DELETE FROM responsables2 WHERE 1';
	$m = mysqli_query($GLOBALS['mysqli'], $reqMenage);

	$new = 0;
	$mod = 0;
	$ignore = 0;
	echo "<h3>Mise à jour des responsables légaux</h3>";
	for($nb=0; $nb<$nb_responsables; $nb++) {
		// On créé les responsables en base (avec les classes ORM)
		// Table resp_pers
		$pers_id = array_key_exists('intid', $responsables[$nb]) ? $responsables[$nb]['intid'][0] : '';
		// Le responsable n'est créé que si le champs intid existe dans LDAP
		if ($pers_id == "") $ignore++;
		else
		{
			/**
			 * Traitment de la fiche responsable et son adresse
			 */
			// On teste si le responsable est déjà enregistré, sur la base de son identifiant sconet
			$test_resp = mysqli_num_rows(mysqli_query($GLOBALS["mysqli"], "SELECT * FROM resp_pers WHERE pers_id = '".$pers_id."'"));
			// Si création
			if ($test_resp == 0) {
				$resp = new ResponsableEleve();
				$new++;
				$resp_inseres++;
			// Si modif user existant
			} else {
				$resp = ResponsableElevePeer::retrieveByPK($pers_id);
				$mod++;
			}
			// Traitement de la fiche responsables : code commun création/modification
			$resp->setResponsableEleveId($pers_id);
			$resp->setLogin($responsables[$nb][$ldap->champ_login][0]);
			$resp->setNom($responsables[$nb][$ldap->champ_nom][0]);
			$resp->setPrenom($responsables[$nb][$ldap->champ_prenom][0]);
			$resp->setCivilite($responsables[$nb]['personaltitle'][0]);
			$homephone = array_key_exists('homephone', $responsables[$nb]) ? $responsables[$nb]['homephone'][0] : '';
			$resp->setTelPers($homephone);
			$profphone = array_key_exists('telephonenumber', $responsables[$nb]) ? $responsables[$nb]['telephonenumber'][0] : '';
			$resp->setTelProf($profphone);
			$mobilephone = array_key_exists('mobile', $responsables[$nb]) ? $responsables[$nb]['mobile'][0] : '';
			$resp->setTelPort($mobilephone);
			$respemail = array_key_exists($ldap->champ_email, $responsables[$nb]) ? $responsables[$nb][$ldap->champ_email][0] : '';
			$resp->setMel($respemail);

	      		// Traitement de l'adresse
			$resp_addr = array_key_exists('entpersonadresse', $responsables[$nb]) ? $responsables[$nb]['entpersonadresse'][0] : null;
			$resp_ville = array_key_exists('entpersonville', $responsables[$nb]) ? $responsables[$nb]['entpersonville'][0] : '';
			$resp_cp = array_key_exists('entpersoncodepostal', $responsables[$nb]) ? $responsables[$nb]['entpersoncodepostal'][0] : '';
			$resp_pays = array_key_exists('entpersonpays', $responsables[$nb]) ? $responsables[$nb]['entpersonpays'][0] : '';
			// Si une adresse est spécifiée
			if ($resp_addr) {
				// On vérifie si besoin de créer ou modifier la fiche adresse
				$test_adr = mysqli_num_rows(mysqli_query($GLOBALS["mysqli"], "SELECT * FROM resp_adr WHERE adr_id = '".$pers_id."'"));
				if ($test_adr == 0) $adr = new Adresse();
				else $adr = BaseAdressePeer::retrieveByPK($pers_id);
				// Traitement fiche adresse : code commun création/modification
				$adr->setId($pers_id);
				$adr->setAdr1($resp_addr);
				$adr->setAdr2('');
				$adr->setAdr3('');
				$adr->setAdr4('');
				$adr->setCommune($resp_ville);
				$adr->setCp($resp_cp);
				$adr->setPays($resp_pays);
				$resp->setAdresse($adr);
			}
			// Enregistrement fiche responsable et de l'adresse si spécifiée
			$resp->save();

			// Pour chaque responsable, on cherche le ou les eleves associes
			// attribut de lien : ENTAuxPersRelEleveEleve
			$nb_eleves_a_charge = $responsables[$nb]['entauxpersreleleveeleve']['count'];
			$valid_associations = 0;

			/**
			* Sucrage de la table de liaison eleve <-> resp
			*/
			//pour chaque dn d'eleve
			for ($i=0;$i<$nb_eleves_a_charge;$i++) {
				$eleve_uid = explode(",",$responsables[$nb]['entauxpersreleleveeleve'][$i]);
				$eleve_associe_login = mb_substr($eleve_uid[0], 4);
				$req_eleid = mysqli_query($GLOBALS["mysqli"], "SELECT ele_id FROM eleves WHERE login = '$eleve_associe_login'");

				// On s'assure qu'on a bien un élève correspondant !
				if (mysqli_num_rows($req_eleid) == 1)
				{
					$eleve_associe_ele_id = old_mysql_result($req_eleid, 0);

					/*
					* Il faut ensuite effectuer le lien entre Responsable et Eleve
					*/
					$numero_responsable = 1;
					$req_nb_resp_deja_presents = "SELECT count(*) FROM responsables2 WHERE ele_id = '$eleve_associe_ele_id'";
					$res_nb_resp = mysqli_query($GLOBALS["mysqli"], $req_nb_resp_deja_presents);
					if (((is_object($GLOBALS["mysqli"])) ? mysqli_errno($GLOBALS["mysqli"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)) != 0) {
						error_log("Erreur : ".mysqli_error($GLOBALS["mysqli"]));
						die("Une erreur s'est produite lors la r&eacute;cup&eacute;ration des responsables d&eacute;j&agrave; pr&eacute;sents.");
					}
					$nb_resp = mysqli_fetch_array($res_nb_resp);
					if ($nb_resp[0] > 0) {
						// Si deja 1 ou plusieurs responsables legaux pour cet eleve,on ajoute le nouveau responsable en incrementant son numero
						$numero_responsable += $nb_resp[0];
						if ($numero_responsable > 2) {
							// On affichera un avertissement disant que l'eleve a plus de 2 responsables legaux, et que ce n'est pas normal.
							// gepi les affichera dans la fiche de l'eleve mais ils ne seront pas reconnus parfaitement (recherches impossibles)
							$avertissement_trop_de_responsables = 1;
						}
					}


					// Ajout de la relation entre Responsable et Eleve dans la table "responsables2" pour chaque eleve
					$req_ajout_lien_eleve_resp = "INSERT INTO responsables2 (ele_id, pers_id,resp_legal, pers_contact,acces_sp) VALUES('$eleve_associe_ele_id','".$resp->getResponsableEleveId()."','$numero_responsable','','')";
					mysqli_query($GLOBALS["mysqli"], $req_ajout_lien_eleve_resp);
					if (((is_object($GLOBALS["mysqli"])) ? mysqli_errno($GLOBALS["mysqli"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)) != 0) {
					die("Une erreur s'est produite lors de l'affectation d'un &eacute;l&egrave;ve &agrave; son responsable l&eacute;gal.");
					}
					$valid_associations++;
				}
			}

			if ($nb_eleves_a_charge > 0 && $valid_associations > 0) {
				// On créé maintenant son compte d'accès à Gepi
				// On test si l'uid est deja connu de GEPI
				$compte_utilisateur_resp = UtilisateurProfessionnelPeer::retrieveByPK($resp->getLogin());
				if ($compte_utilisateur_resp != null) {
					// Un compte d'accès avec le même identifiant existe déjà. On ne touche à rien.
					//echo "Un compte existe déjà pour l'identifiant ".$resp->getLogin().".<br/>";
				}
				else {
					$new_compte_utilisateur = new UtilisateurProfessionnel();
					$new_compte_utilisateur->setAuthMode('sso');
					$new_compte_utilisateur->setCivilite($resp->getCivilite());
					$new_compte_utilisateur->setEmail($resp->getMel());
					$new_compte_utilisateur->setEtat('actif');
					$new_compte_utilisateur->setLogin($resp->getLogin());
					$new_compte_utilisateur->setNom($resp->getNom());
					$new_compte_utilisateur->setPrenom($resp->getPrenom());
					$new_compte_utilisateur->setShowEmail('no');
					$new_compte_utilisateur->setStatut('responsable');
					$new_compte_utilisateur->save();
				}
			}
		}
	}

	/**
	 * Affichage final
	 */
	if ($new>0)
	{
		echo "$new responsable";
		if ($new>1) echo "s";
		echo " créés.<br/>";
	}

	if ($mod>0)
	{
		echo "$mod responsable";
		if ($mod>1) echo "s";
		echo " mis à jour.<br/>";
	}

	if ($ignore>0)
	{
		echo "<b> $ignore responsable";
		if ($ignore>0) echo "s";
		echo " pas mis à jour car pas d'identifiant intid dans l'annuaire.</b><br/>";
	}
	echo "<br/><br/>";
}

function synchro_profs($ldap)
{
	$profs = $ldap->get_all_profs();
	$nb_profs = $profs['count'];

	//$tables_to_del = array('groupes','j_groupes_matieres','j_groupes_professeurs', 'j_eleves_groupes','j_groupes_classes');

	/*foreach($tables_to_del as $table)
	{
		mysqli_query($GLOBALS['mysqli'], "TRUNCATE TABLE ".$table);
    }*/
	/*
	* Ajout des profs
	*/

	// Infos nécessaires pour le prof
	$nom_complet = '';
	$uid_as_login = '';
	$mail = '';

	$new = 0;
	$mod = 0;


	echo "<h3>Mise à jour des enseignants</h3>";

	// On parcours tous les profs et on les ajoute
	for($cpt=0; $cpt<$profs['count']; $cpt++) {
		$uid_as_login = $profs[$cpt][$ldap->champ_login][0];
		$nom = $profs[$cpt][$ldap->champ_nom][0];
		$prenom = $profs[$cpt][$ldap->champ_prenom][0];
		$civ = $profs[$cpt]['personaltitle'][0];
		$mail = $profs[$cpt][$ldap->champ_email][0];

	    // On test si l'uid est deja connu de GEPI
		$compte_utilisateur_prof = UtilisateurProfessionnelPeer::retrieveByPK($uid_as_login);
		if ($compte_utilisateur_prof != null) {
	        // Un prof ayant cet UID existe deja : soit c'est le même, on ne touche pas
	        // Soit c'est un prof différent qui a cet uid
			$mod++;
		}
		else
		{
			$new_compte_utilisateur = new UtilisateurProfessionnel();
			$new_compte_utilisateur->setAuthMode('sso');
			$new_compte_utilisateur->setCivilite($civ);
			$new_compte_utilisateur->setEmail($mail);
			$new_compte_utilisateur->setEtat('actif');
			$new_compte_utilisateur->setLogin($uid_as_login);
			$new_compte_utilisateur->setNom($nom);
			$new_compte_utilisateur->setPrenom($prenom);
			$new_compte_utilisateur->setShowEmail('no');
			$new_compte_utilisateur->setStatut('professeur');
			$new_compte_utilisateur->save();
			$new++;

			$matieres = $new_compte_utilisateur->getMatieres();

			foreach($matieres as $matiere)
			{
				$rec_groupe = mysqli_query($GLOBALS["mysqli"], "INSERT INTO groupes SET
					name = '".$matiere->getNomComplet()."',
					description = '".$matiere->getNomComplet()."'");
				$id_groupe = ((is_null($___mysqli_res = mysqli_insert_id($GLOBALS["mysqli"]))) ? false : $___mysqli_res);

				$rec_mat = mysqli_query($GLOBALS["mysqli"], "INSERT INTO j_groupes_matieres SET
					id_matiere = '".$matiere->getMatiere()."',
					id_groupe = '".$id_groupe."'");

				$rec_prof = mysqli_query($GLOBALS["mysqli"], "INSERT INTO j_groupes_professeurs SET
					login = '".$new_compte_utilisateur->getLogin()."',
					id_groupe = '".$id_groupe."'");

	            //Maintenant il faut mettre les élèves
				/*foreach ($students as $student) {
					foreach ($classe_courante->getPeriodeNotes() as $periode) {
						$rec = mysqli_query($GLOBALS["mysqli"], "INSERT INTO j_eleves_groupes SET
							login = '".$student."',
							id_groupe = '".$id_groupe."',
							periode = '".$periode->getNumPeriode()."'");
	                } # Fin boucle périodes
	            } # Fin boucle élèves

	            # Association à la classe
	            $rec = mysqli_query($GLOBALS["mysqli"], "INSERT INTO j_groupes_classes SET
	            	id_groupe = '".$id_groupe."',
	            	id_classe = '".$classe_courante->getId()."'");

	            $nombre_enseignements++;


               */
	        } # Fin boucle matières du prof
        
	    }

	    // Insertion de sa qualité de prof principal si c'est le cas
	    if ($profs[$cpt]['typeadmin'][0] == 2)
	    {
	    	for($cl=0; $cl<$profs[$cpt]['divcod']['count']; $cl++)
	    	{
	    		$crit_classe_courante = new Criteria();
		        $crit_classe_courante->add(ClassePeer::CLASSE, $profs[$cpt]['divcod'][$cl]); // indice contient le nom de la classe (son numero)

		        $classe_courante = ClassePeer::doSelect($crit_classe_courante);
		        $error = false;
		        if ($classe_courante == null) {
		        	$error = true;
		        	echo "Erreur : impossible de recuperer la classe $indice<br/>";
		        }
		        if (count($classe_courante) > 1) {
		        	$error = true;
		        	echo "Erreur : plusieurs classes ayant le nom '$indice' sont pr&eacute;sentes.<br/>";
		        }

		        // Si on trouve la classe, et qu'il y en a bien qu'une seule, on recupere son id technique
		        if (!$error)
		        {
		        	$crit_eleves_de_la_classe = new Criteria();
		        	$crit_eleves_de_la_classe->add(JEleveClassePeer::ID_CLASSE, $classe_courante[0]->getId());
		        	$eleves_de_la_classe = JEleveClassePeer::doSelect($crit_eleves_de_la_classe);
		        	if ($eleves_de_la_classe != null)
		        	{
		        		foreach($eleves_de_la_classe as $eleve)
		        		{
		        			$sql_ajout_rel_prof_princ = "INSERT INTO j_eleves_professeurs VALUES('".$eleve->getLogin()."','$uid_as_login',".$classe_courante[0]->getId().")";
		        			mysqli_query($GLOBALS["mysqli"], $sql_ajout_rel_prof_princ);
		        		}
		        	}
		        }
		    }

		}
	   /* else {
	      echo "Le prof $prenom $nom n'est pas professeur principal<br/>";
	  }*/
	} // fin parcours de tous les profs
	if($new > 0)
	{
		echo $new." professeurs créés.<br/>";
	}
	if($mod > 0)
	{
		echo $mod." professeurs ont été mis à jour.<br/>";
	}
	echo "<br/><br/>";
}


function synchroMatieres($ldap)
{
	 $matieres = $ldap->get_all_matieres();
    $nb_matieres = $matieres['count'];


   /*
    * Ajout des matières
    */

    for($cpt=0; $cpt<$matieres['count']; $cpt++) {

        $code_matiere = $matieres[$cpt]['cn'][0];
        $nom_matiere = $matieres[$cpt]['description'][0];

        // On test si on a déjà cette matière
        $nouvelle_matiere = MatierePeer::retrieveByPK($code_matiere);
        if ($nouvelle_matiere != null) {
            //echo "La matière "
//            .$nouvelle_matiere->getMatiere()." ("
//            .$nouvelle_matiere->getNomComplet()
//            .") existe d&eacute;j&agrave;<br/>";
        }
        else {
            $nouvelle_matiere = new Matiere();
            $nouvelle_matiere->setMatiere($code_matiere);
            $nouvelle_matiere->setNomComplet($nom_matiere);
            $nouvelle_matiere->save();
        }


        // Maintenant on associe les profs à cette matiere
        $nb_profs = $matieres[$cpt]['memberuid']['count'];

        $matiere_profs = $nouvelle_matiere->getProfesseurs();

        if ($nb_profs > 0) {
          	for ($i=0;$i<$nb_profs;$i++){
            	// On vérifie que le prof existe, quand même...
            	$prof = UtilisateurProfessionnelPeer::retrieveByPK($matieres[$cpt]['memberuid'][$i]);

            	// Le prof existe, on créer l'association, si elle n'existe pas encore
            	if ($prof != null) {
		            // L'association n'existe pas, on la créé
                	// Pour ça, on doit déterminer l'ordre
                	if (!$matiere_profs->contains($prof)) {
	                	$assoc = JProfesseursMatieresQuery::create()
	                  			 	->filterByProfesseur($prof)
	                  			 	->orderByOrdreMatieres('desc')
	                  			 	->findOne();

	                	$nouvel_ordre = $assoc == null ? 1 : $assoc->getOrdreMatieres()+1;

		                $new_assoc = new JProfesseursMatieres();
	                	$new_assoc->setProfesseur($prof);
	                	$new_assoc->setMatiere($nouvelle_matiere);
	                	$new_assoc->setOrdreMatieres($nouvel_ordre);
	                	$new_assoc->save();
	              	}
            	}
          	}
        }

    }
}


function synchroEquipes($ldap)
{
	$equipes = $ldap->get_all_equipes();
    $nb_equipes = $equipes['count'];

    $nombre_enseignements = 0;

    # On initialise un tableau avec juste les données nécessaires
    $donnees_equipes = array();

    for($cpt=0; $cpt<$equipes['count']; $cpt++) {
        $code_classe = str_replace('profs-','',$equipes[$cpt]['cn'][0]);
        $donnees_equipes[$code_classe] = array();
        for($i=0;$i<$equipes[$cpt]['memberuid']['count'];$i++) {
          $donnees_equipes[$code_classe][] = $equipes[$cpt]['memberuid'][$i];
        }
    }

    $classes = ClasseQuery::create()
                  ->setFormatter(ModelCriteria::FORMAT_ON_DEMAND)
                  ->find();

    // On boucle sur chaque équipe, ce qui revient à boucler sur les classes
    foreach($classes as $classe_courante) {
        # On a une classe, on poursuit
        if (array_key_exists($classe_courante->getNom(), $donnees_equipes)) {

        	# On initialisation la liste des élèves de la classe

            $students_query = mysqli_query($GLOBALS["mysqli"], "SELECT login FROM j_eleves_classes WHERE
                                        id_classe = '".$classe_courante->getId()."' AND
                                        periode = '1'");

            unset($students);
            $students = array();
            while ($row = mysqli_fetch_object($students_query)) {
 	            $students[] = $row->login;
    	    }


            # On passe tous les profs de l'équipe
            foreach($donnees_equipes[$classe_courante->getNom()] as $login_prof) {

            $prof = UtilisateurProfessionnelPeer::retrieveByPK($login_prof);
            if ($prof) {
                # On a un prof. On créé un enseignement pour chacune des matières qui lui sont associées.
                $matieres = $prof->getMatieres();

              	foreach($matieres as $matiere) {
                	$rec_groupe = mysqli_query($GLOBALS["mysqli"], "INSERT INTO groupes SET
                    								    name = '".$matiere->getNomComplet()."',
                      								    description = '".$matiere->getNomComplet()."'");
                    $id_groupe = ((is_null($___mysqli_res = mysqli_insert_id($GLOBALS["mysqli"]))) ? false : $___mysqli_res);

                    $rec_mat = mysqli_query($GLOBALS["mysqli"], "INSERT INTO j_groupes_matieres SET
                    				    				id_matiere = '".$matiere->getMatiere()."',
                      									id_groupe = '".$id_groupe."'");

                    $rec_prof = mysqli_query($GLOBALS["mysqli"], "INSERT INTO j_groupes_professeurs SET
                      									login = '".$prof->getLogin()."',
                      									id_groupe = '".$id_groupe."'");

                  	# Maintenant il faut mettre les élèves
                    foreach ($students as $student) {

                    	foreach ($classe_courante->getPeriodeNotes() as $periode) {
                    		$rec = mysqli_query($GLOBALS["mysqli"], "INSERT INTO j_eleves_groupes SET
                              	  		login = '".$student."',
                               			id_groupe = '".$id_groupe."',
                              			periode = '".$periode->getNumPeriode()."'");
                    	} # Fin boucle périodes
                  	} # Fin boucle élèves


                  	# Association à la classe
                  	$rec = mysqli_query($GLOBALS["mysqli"], "INSERT INTO j_groupes_classes SET
                               					id_groupe = '".$id_groupe."',
                               					id_classe = '".$classe_courante->getId()."'");

                  	$nombre_enseignements++;

                		#} # Fin test si enseignement existe déjà

		        } # Fin boucle matières du prof


            } # Fin test prof existant
        } # Fin boucle profs


    	}
    }
}

$db1 = new ps_db;
$q = "SELECT * FROM admin_gepi WHERE id=1";
$db1->query($q);
$db1->next_record();

$sEleves = $db1->f('synchro_eleves');
$sResp = $db1->f('synchro_resp');
$sProfs = $db1->f('synchro_profs');


if( $sEleves or $sResp or $sProfs)
{
	$ldap = new LDAPServerScribe();
	$ldap->connect();

	if ($sEleves)
	{
		synchro_eleves($ldap);
		synchro_classes($ldap);
	}

	if ($sResp)
	{
		synchro_resp($ldap);
	}

	if ($sProfs)
	{
		synchro_profs($ldap);
		synchroMatieres($ldap);
		//synchroEquipes($ldap);
	}
}

?>



