/*
	Copyright (c) 2004-2011, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"dijit/popup":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/keys","dojo/_base/lang","dojo/on","./place","./BackgroundIframe","./Viewport","./main"],function(_1,_2,_3,_4,_5,_6,_7,_8,_9,_a,_b,on,_c,_d,_e,_f){function _10(){if(this._popupWrapper){_6.destroy(this._popupWrapper);delete this._popupWrapper;}};var _11=_3(null,{_stack:[],_beginZIndex:1000,_idGen:1,_repositionAll:function(){if(this._firstAroundNode){var _12=this._firstAroundPosition,_13=_7.position(this._firstAroundNode,true),dx=_13.x-_12.x,dy=_13.y-_12.y;if(dx||dy){this._firstAroundPosition=_13;for(var i=0;i<this._stack.length;i++){var _14=this._stack[i].wrapper.style;_14.top=(parseInt(_14.top,10)+dy)+"px";if(_14.right=="auto"){_14.left=(parseInt(_14.left,10)+dx)+"px";}else{_14.right=(parseInt(_14.right,10)-dx)+"px";}}}this._aroundMoveListener=setTimeout(_b.hitch(this,"_repositionAll"),dx||dy?10:50);}},_createWrapper:function(_15){var _16=_15._popupWrapper,_17=_15.domNode;if(!_16){_16=_6.create("div",{"class":"dijitPopup",style:{display:"none"},role:"region","aria-label":_15["aria-label"]||_15.label||_15.name||_15.id},_15.ownerDocumentBody);_16.appendChild(_17);var s=_17.style;s.display="";s.visibility="";s.position="";s.top="0px";_15._popupWrapper=_16;_2.after(_15,"destroy",_10,true);}return _16;},moveOffScreen:function(_18){var _19=this._createWrapper(_18);var ltr=_7.isBodyLtr(_18.ownerDocument),_1a={visibility:"hidden",top:"-9999px",display:""};_1a[ltr?"left":"right"]="-9999px";_1a[ltr?"right":"left"]="auto";_8.set(_19,_1a);return _19;},hide:function(_1b){var _1c=this._createWrapper(_1b);_8.set(_1c,{display:"none",height:"auto",overflow:"visible",border:""});var _1d=_1b.domNode;if("_originalStyle" in _1d){_1d.style.cssText=_1d._originalStyle;}},getTopPopup:function(){var _1e=this._stack;for(var pi=_1e.length-1;pi>0&&_1e[pi].parent===_1e[pi-1].widget;pi--){}return _1e[pi];},open:function(_1f){var _20=this._stack,_21=_1f.popup,_22=_21.domNode,_23=_1f.orient||["below","below-alt","above","above-alt"],ltr=_1f.parent?_1f.parent.isLeftToRight():_7.isBodyLtr(_21.ownerDocument),_24=_1f.around,id=(_1f.around&&_1f.around.id)?(_1f.around.id+"_dropdown"):("popup_"+this._idGen++);while(_20.length&&(!_1f.parent||!_4.isDescendant(_1f.parent.domNode,_20[_20.length-1].widget.domNode))){this.close(_20[_20.length-1].widget);}var _25=this.moveOffScreen(_21);if(_21.startup&&!_21._started){_21.startup();}var _26,_27=_7.position(_22);if("maxHeight" in _1f&&_1f.maxHeight!=-1){_26=_1f.maxHeight||Infinity;}else{var _28=_e.getEffectiveBox(this.ownerDocument),_29=_24?_7.position(_24,false):{y:_1f.y-(_1f.padding||0),h:(_1f.padding||0)*2};_26=Math.floor(Math.max(_29.y,_28.h-(_29.y+_29.h)));}if(_27.h>_26){var cs=_8.getComputedStyle(_22),_2a=cs.borderLeftWidth+" "+cs.borderLeftStyle+" "+cs.borderLeftColor;_8.set(_25,{overflowY:"scroll",height:_26+"px",border:_2a});_22._originalStyle=_22.style.cssText;_22.style.border="none";}_5.set(_25,{id:id,style:{zIndex:this._beginZIndex+_20.length},"class":"dijitPopup "+(_21.baseClass||_21["class"]||"").split(" ")[0]+"Popup",dijitPopupParent:_1f.parent?_1f.parent.id:""});if(_20.length==0&&_24){this._firstAroundNode=_24;this._firstAroundPosition=_7.position(_24,true);this._aroundMoveListener=setTimeout(_b.hitch(this,"_repositionAll"),50);}if(_9("config-bgIframe")&&!_21.bgIframe){_21.bgIframe=new _d(_25);}var _2b=_21.orient?_b.hitch(_21,"orient"):null,_2c=_24?_c.around(_25,_24,_23,ltr,_2b):_c.at(_25,_1f,_23=="R"?["TR","BR","TL","BL"]:["TL","BL","TR","BR"],_1f.padding,_2b);_25.style.visibility="visible";_22.style.visibility="visible";var _2d=[];_2d.push(on(_25,"keydown",_b.hitch(this,function(evt){if(evt.keyCode==_a.ESCAPE&&_1f.onCancel){evt.stopPropagation();evt.preventDefault();_1f.onCancel();}else{if(evt.keyCode==_a.TAB){evt.stopPropagation();evt.preventDefault();var _2e=this.getTopPopup();if(_2e&&_2e.onCancel){_2e.onCancel();}}}})));if(_21.onCancel&&_1f.onCancel){_2d.push(_21.on("cancel",_1f.onCancel));}_2d.push(_21.on(_21.onExecute?"execute":"change",_b.hitch(this,function(){var _2f=this.getTopPopup();if(_2f&&_2f.onExecute){_2f.onExecute();}})));_20.push({widget:_21,wrapper:_25,parent:_1f.parent,onExecute:_1f.onExecute,onCancel:_1f.onCancel,onClose:_1f.onClose,handlers:_2d});if(_21.onOpen){_21.onOpen(_2c);}return _2c;},close:function(_30){var _31=this._stack;while((_30&&_1.some(_31,function(_32){return _32.widget==_30;}))||(!_30&&_31.length)){var top=_31.pop(),_33=top.widget,_34=top.onClose;if(_33.onClose){_33.onClose();}var h;while(h=top.handlers.pop()){h.remove();}if(_33&&_33.domNode){this.hide(_33);}if(_34){_34();}}if(_31.length==0&&this._aroundMoveListener){clearTimeout(this._aroundMoveListener);this._firstAroundNode=this._firstAroundPosition=this._aroundMoveListener=null;}}});return (_f.popup=new _11());});},"dojo/string":function(){define(["./_base/kernel","./_base/lang"],function(_35,_36){var _37={};_36.setObject("dojo.string",_37);_37.rep=function(str,num){if(num<=0||!str){return "";}var buf=[];for(;;){if(num&1){buf.push(str);}if(!(num>>=1)){break;}str+=str;}return buf.join("");};_37.pad=function(_38,_39,ch,end){if(!ch){ch="0";}var out=String(_38),pad=_37.rep(ch,Math.ceil((_39-out.length)/ch.length));return end?out+pad:pad+out;};_37.substitute=function(_3a,map,_3b,_3c){_3c=_3c||_35.global;_3b=_3b?_36.hitch(_3c,_3b):function(v){return v;};return _3a.replace(/\$\{([^\s\:\}]+)(?:\:([^\s\:\}]+))?\}/g,function(_3d,key,_3e){var _3f=_36.getObject(key,false,map);if(_3e){_3f=_36.getObject(_3e,false,_3c).call(_3c,_3f,key);}return _3b(_3f,key).toString();});};_37.trim=String.prototype.trim?_36.trim:function(str){str=str.replace(/^\s+/,"");for(var i=str.length-1;i>=0;i--){if(/\S/.test(str.charAt(i))){str=str.substring(0,i+1);break;}}return str;};return _37;});},"dijit/a11y":function(){define(["dojo/_base/array","dojo/dom","dojo/dom-attr","dojo/dom-style","dojo/_base/lang","dojo/sniff","./main"],function(_40,dom,_41,_42,_43,has,_44){var _45={_isElementShown:function(_46){var s=_42.get(_46);return (s.visibility!="hidden")&&(s.visibility!="collapsed")&&(s.display!="none")&&(_41.get(_46,"type")!="hidden");},hasDefaultTabStop:function(_47){switch(_47.nodeName.toLowerCase()){case "a":return _41.has(_47,"href");case "area":case "button":case "input":case "object":case "select":case "textarea":return true;case "iframe":var _48;try{var _49=_47.contentDocument;if("designMode" in _49&&_49.designMode=="on"){return true;}_48=_49.body;}catch(e1){try{_48=_47.contentWindow.document.body;}catch(e2){return false;}}return _48&&(_48.contentEditable=="true"||(_48.firstChild&&_48.firstChild.contentEditable=="true"));default:return _47.contentEditable=="true";}},isTabNavigable:function(_4a){if(_41.get(_4a,"disabled")){return false;}else{if(_41.has(_4a,"tabIndex")){return _41.get(_4a,"tabIndex")>=0;}else{return _45.hasDefaultTabStop(_4a);}}},_getTabNavigable:function(_4b){var _4c,_4d,_4e,_4f,_50,_51,_52={};function _53(_54){return _54&&_54.tagName.toLowerCase()=="input"&&_54.type&&_54.type.toLowerCase()=="radio"&&_54.name&&_54.name.toLowerCase();};var _55=_45._isElementShown,_56=_45.isTabNavigable;var _57=function(_58){for(var _59=_58.firstChild;_59;_59=_59.nextSibling){if(_59.nodeType!=1||(has("ie")<=9&&_59.scopeName!=="HTML")||!_55(_59)){continue;}if(_56(_59)){var _5a=+_41.get(_59,"tabIndex");if(!_41.has(_59,"tabIndex")||_5a==0){if(!_4c){_4c=_59;}_4d=_59;}else{if(_5a>0){if(!_4e||_5a<_4f){_4f=_5a;_4e=_59;}if(!_50||_5a>=_51){_51=_5a;_50=_59;}}}var rn=_53(_59);if(_41.get(_59,"checked")&&rn){_52[rn]=_59;}}if(_59.nodeName.toUpperCase()!="SELECT"){_57(_59);}}};if(_55(_4b)){_57(_4b);}function rs(_5b){return _52[_53(_5b)]||_5b;};return {first:rs(_4c),last:rs(_4d),lowest:rs(_4e),highest:rs(_50)};},getFirstInTabbingOrder:function(_5c,doc){var _5d=_45._getTabNavigable(dom.byId(_5c,doc));return _5d.lowest?_5d.lowest:_5d.first;},getLastInTabbingOrder:function(_5e,doc){var _5f=_45._getTabNavigable(dom.byId(_5e,doc));return _5f.last?_5f.last:_5f.highest;}};1&&_43.mixin(_44,_45);return _45;});},"dijit/WidgetSet":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/kernel","./registry"],function(_60,_61,_62,_63){var _64=_61("dijit.WidgetSet",null,{constructor:function(){this._hash={};this.length=0;},add:function(_65){if(this._hash[_65.id]){throw new Error("Tried to register widget with id=="+_65.id+" but that id is already registered");}this._hash[_65.id]=_65;this.length++;},remove:function(id){if(this._hash[id]){delete this._hash[id];this.length--;}},forEach:function(_66,_67){_67=_67||_62.global;var i=0,id;for(id in this._hash){_66.call(_67,this._hash[id],i++,this._hash);}return this;},filter:function(_68,_69){_69=_69||_62.global;var res=new _64(),i=0,id;for(id in this._hash){var w=this._hash[id];if(_68.call(_69,w,i++,this._hash)){res.add(w);}}return res;},byId:function(id){return this._hash[id];},byClass:function(cls){var res=new _64(),id,_6a;for(id in this._hash){_6a=this._hash[id];if(_6a.declaredClass==cls){res.add(_6a);}}return res;},toArray:function(){var ar=[];for(var id in this._hash){ar.push(this._hash[id]);}return ar;},map:function(_6b,_6c){return _60.map(this.toArray(),_6b,_6c);},every:function(_6d,_6e){_6e=_6e||_62.global;var x=0,i;for(i in this._hash){if(!_6d.call(_6e,this._hash[i],x++,this._hash)){return false;}}return true;},some:function(_6f,_70){_70=_70||_62.global;var x=0,i;for(i in this._hash){if(_6f.call(_70,this._hash[i],x++,this._hash)){return true;}}return false;}});_60.forEach(["forEach","filter","byClass","map","every","some"],function(_71){_63[_71]=_64.prototype[_71];});return _64;});},"dijit/_base/wai":function(){define(["dojo/dom-attr","dojo/_base/lang","../main","../hccss"],function(_72,_73,_74){var _75={hasWaiRole:function(_76,_77){var _78=this.getWaiRole(_76);return _77?(_78.indexOf(_77)>-1):(_78.length>0);},getWaiRole:function(_79){return _73.trim((_72.get(_79,"role")||"").replace("wairole:",""));},setWaiRole:function(_7a,_7b){_72.set(_7a,"role",_7b);},removeWaiRole:function(_7c,_7d){var _7e=_72.get(_7c,"role");if(!_7e){return;}if(_7d){var t=_73.trim((" "+_7e+" ").replace(" "+_7d+" "," "));_72.set(_7c,"role",t);}else{_7c.removeAttribute("role");}},hasWaiState:function(_7f,_80){return _7f.hasAttribute?_7f.hasAttribute("aria-"+_80):!!_7f.getAttribute("aria-"+_80);},getWaiState:function(_81,_82){return _81.getAttribute("aria-"+_82)||"";},setWaiState:function(_83,_84,_85){_83.setAttribute("aria-"+_84,_85);},removeWaiState:function(_86,_87){_86.removeAttribute("aria-"+_87);}};_73.mixin(_74,_75);return _74;});},"dijit/Viewport":function(){define(["dojo/Evented","dojo/on","dojo/domReady","dojo/sniff","dojo/window"],function(_88,on,_89,has,_8a){var _8b=new _88();var _8c;_89(function(){var _8d=_8a.getBox();_8b._rlh=on(window,"resize",function(){var _8e=_8a.getBox();if(_8d.h==_8e.h&&_8d.w==_8e.w){return;}_8d=_8e;_8b.emit("resize");});if(has("ie")==8){var _8f=screen.deviceXDPI;setInterval(function(){if(screen.deviceXDPI!=_8f){_8f=screen.deviceXDPI;_8b.emit("resize");}},500);}if(has("ios")){on(document,"focusin",function(evt){_8c=evt.target;});on(document,"focusout",function(evt){_8c=null;});}});_8b.getEffectiveBox=function(doc){var box=_8a.getBox(doc);var tag=_8c&&_8c.tagName&&_8c.tagName.toLowerCase();if(has("ios")&&_8c&&!_8c.readOnly&&(tag=="textarea"||(tag=="input"&&/^(color|email|number|password|search|tel|text|url)$/.test(_8c.type)))){box.h*=(orientation==0||orientation==180?0.66:0.4);var _90=_8c.getBoundingClientRect();box.h=Math.max(box.h,_90.top+_90.height);}return box;};return _8b;});},"dojo/hccss":function(){define(["require","./_base/config","./dom-class","./dom-style","./has","./domReady","./_base/window"],function(_91,_92,_93,_94,has,_95,win){has.add("highcontrast",function(){var div=win.doc.createElement("div");div.style.cssText="border: 1px solid; border-color:red green; position: absolute; height: 5px; top: -999px;"+"background-image: url("+(_92.blankGif||_91.toUrl("./resources/blank.gif"))+");";win.body().appendChild(div);var cs=_94.getComputedStyle(div),_96=cs.backgroundImage,hc=(cs.borderTopColor==cs.borderRightColor)||(_96&&(_96=="none"||_96=="url(invalid-url:)"));if(has("ie")<=8){div.outerHTML="";}else{win.body().removeChild(div);}return hc;});_95(function(){if(has("highcontrast")){_93.add(win.body(),"dj_a11y");}});return has;});},"dijit/_WidgetBase":function(){define(["require","dojo/_base/array","dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/ready","dojo/Stateful","dojo/topic","dojo/_base/window","./Destroyable","dojo/has!dojo-bidi?./_BidiMixin","./registry"],function(_97,_98,_99,_9a,_9b,_9c,dom,_9d,_9e,_9f,_a0,_a1,has,_a2,_a3,on,_a4,_a5,_a6,win,_a7,_a8,_a9){has.add("dijit-legacy-requires",!_a2.isAsync);has.add("dojo-bidi",false);if(has("dijit-legacy-requires")){_a4(0,function(){var _aa=["dijit/_base/manager"];_97(_aa);});}var _ab={};function _ac(obj){var ret={};for(var _ad in obj){ret[_ad.toLowerCase()]=true;}return ret;};function _ae(_af){return function(val){_9d[val?"set":"remove"](this.domNode,_af,val);this._set(_af,val);};};var _b0=_9c("dijit._WidgetBase",[_a5,_a7],{id:"",_setIdAttr:"domNode",lang:"",_setLangAttr:_ae("lang"),dir:"",_setDirAttr:_ae("dir"),"class":"",_setClassAttr:{node:"domNode",type:"class"},style:"",title:"",tooltip:"",baseClass:"",srcNodeRef:null,domNode:null,containerNode:null,ownerDocument:null,_setOwnerDocumentAttr:function(val){this._set("ownerDocument",val);},attributeMap:{},_blankGif:_9a.blankGif||_97.toUrl("dojo/resources/blank.gif"),_introspect:function(){var _b1=this.constructor;if(!_b1._setterAttrs){var _b2=_b1.prototype,_b3=_b1._setterAttrs=[],_b4=(_b1._onMap={});for(var _b5 in _b2.attributeMap){_b3.push(_b5);}for(_b5 in _b2){if(/^on/.test(_b5)){_b4[_b5.substring(2).toLowerCase()]=_b5;}if(/^_set[A-Z](.*)Attr$/.test(_b5)){_b5=_b5.charAt(4).toLowerCase()+_b5.substr(5,_b5.length-9);if(!_b2.attributeMap||!(_b5 in _b2.attributeMap)){_b3.push(_b5);}}}}},postscript:function(_b6,_b7){this.create(_b6,_b7);},create:function(_b8,_b9){this._introspect();this.srcNodeRef=dom.byId(_b9);this._connects=[];this._supportingWidgets=[];if(this.srcNodeRef&&(typeof this.srcNodeRef.id=="string")){this.id=this.srcNodeRef.id;}if(_b8){this.params=_b8;_a3.mixin(this,_b8);}this.postMixInProperties();if(!this.id){this.id=_a9.getUniqueId(this.declaredClass.replace(/\./g,"_"));if(this.params){delete this.params.id;}}this.ownerDocument=this.ownerDocument||(this.srcNodeRef?this.srcNodeRef.ownerDocument:document);this.ownerDocumentBody=win.body(this.ownerDocument);_a9.add(this);this.buildRendering();var _ba;if(this.domNode){this._applyAttributes();var _bb=this.srcNodeRef;if(_bb&&_bb.parentNode&&this.domNode!==_bb){_bb.parentNode.replaceChild(this.domNode,_bb);_ba=true;}this.domNode.setAttribute("widgetId",this.id);}this.postCreate();if(_ba){delete this.srcNodeRef;}this._created=true;},_applyAttributes:function(){var _bc={};for(var key in this.params||{}){_bc[key]=this._get(key);}_98.forEach(this.constructor._setterAttrs,function(key){if(!(key in _bc)){var val=this._get(key);if(val){this.set(key,val);}}},this);for(key in _bc){this.set(key,_bc[key]);}},postMixInProperties:function(){},buildRendering:function(){if(!this.domNode){this.domNode=this.srcNodeRef||this.ownerDocument.createElement("div");}if(this.baseClass){var _bd=this.baseClass.split(" ");if(!this.isLeftToRight()){_bd=_bd.concat(_98.map(_bd,function(_be){return _be+"Rtl";}));}_9e.add(this.domNode,_bd);}},postCreate:function(){},startup:function(){if(this._started){return;}this._started=true;_98.forEach(this.getChildren(),function(obj){if(!obj._started&&!obj._destroyed&&_a3.isFunction(obj.startup)){obj.startup();obj._started=true;}});},destroyRecursive:function(_bf){this._beingDestroyed=true;this.destroyDescendants(_bf);this.destroy(_bf);},destroy:function(_c0){this._beingDestroyed=true;this.uninitialize();function _c1(w){if(w.destroyRecursive){w.destroyRecursive(_c0);}else{if(w.destroy){w.destroy(_c0);}}};_98.forEach(this._connects,_a3.hitch(this,"disconnect"));_98.forEach(this._supportingWidgets,_c1);if(this.domNode){_98.forEach(_a9.findWidgets(this.domNode,this.containerNode),_c1);}this.destroyRendering(_c0);_a9.remove(this.id);this._destroyed=true;},destroyRendering:function(_c2){if(this.bgIframe){this.bgIframe.destroy(_c2);delete this.bgIframe;}if(this.domNode){if(_c2){_9d.remove(this.domNode,"widgetId");}else{_9f.destroy(this.domNode);}delete this.domNode;}if(this.srcNodeRef){if(!_c2){_9f.destroy(this.srcNodeRef);}delete this.srcNodeRef;}},destroyDescendants:function(_c3){_98.forEach(this.getChildren(),function(_c4){if(_c4.destroyRecursive){_c4.destroyRecursive(_c3);}});},uninitialize:function(){return false;},_setStyleAttr:function(_c5){var _c6=this.domNode;if(_a3.isObject(_c5)){_a1.set(_c6,_c5);}else{if(_c6.style.cssText){_c6.style.cssText+="; "+_c5;}else{_c6.style.cssText=_c5;}}this._set("style",_c5);},_attrToDom:function(_c7,_c8,_c9){_c9=arguments.length>=3?_c9:this.attributeMap[_c7];_98.forEach(_a3.isArray(_c9)?_c9:[_c9],function(_ca){var _cb=this[_ca.node||_ca||"domNode"];var _cc=_ca.type||"attribute";switch(_cc){case "attribute":if(_a3.isFunction(_c8)){_c8=_a3.hitch(this,_c8);}var _cd=_ca.attribute?_ca.attribute:(/^on[A-Z][a-zA-Z]*$/.test(_c7)?_c7.toLowerCase():_c7);if(_cb.tagName){_9d.set(_cb,_cd,_c8);}else{_cb.set(_cd,_c8);}break;case "innerText":_cb.innerHTML="";_cb.appendChild(this.ownerDocument.createTextNode(_c8));break;case "innerHTML":_cb.innerHTML=_c8;break;case "class":_9e.replace(_cb,_c8,this[_c7]);break;}},this);},get:function(_ce){var _cf=this._getAttrNames(_ce);return this[_cf.g]?this[_cf.g]():this._get(_ce);},set:function(_d0,_d1){if(typeof _d0==="object"){for(var x in _d0){this.set(x,_d0[x]);}return this;}var _d2=this._getAttrNames(_d0),_d3=this[_d2.s];if(_a3.isFunction(_d3)){var _d4=_d3.apply(this,Array.prototype.slice.call(arguments,1));}else{var _d5=this.focusNode&&!_a3.isFunction(this.focusNode)?"focusNode":"domNode",tag=this[_d5]&&this[_d5].tagName,_d6=tag&&(_ab[tag]||(_ab[tag]=_ac(this[_d5]))),map=_d0 in this.attributeMap?this.attributeMap[_d0]:_d2.s in this?this[_d2.s]:((_d6&&_d2.l in _d6&&typeof _d1!="function")||/^aria-|^data-|^role$/.test(_d0))?_d5:null;if(map!=null){this._attrToDom(_d0,_d1,map);}this._set(_d0,_d1);}return _d4||this;},_attrPairNames:{},_getAttrNames:function(_d7){var apn=this._attrPairNames;if(apn[_d7]){return apn[_d7];}var uc=_d7.replace(/^[a-z]|-[a-zA-Z]/g,function(c){return c.charAt(c.length-1).toUpperCase();});return (apn[_d7]={n:_d7+"Node",s:"_set"+uc+"Attr",g:"_get"+uc+"Attr",l:uc.toLowerCase()});},_set:function(_d8,_d9){var _da=this[_d8];this[_d8]=_d9;if(this._created&&_d9!==_da){if(this._watchCallbacks){this._watchCallbacks(_d8,_da,_d9);}this.emit("attrmodified-"+_d8,{detail:{prevValue:_da,newValue:_d9}});}},_get:function(_db){return this[_db];},emit:function(_dc,_dd,_de){_dd=_dd||{};if(_dd.bubbles===undefined){_dd.bubbles=true;}if(_dd.cancelable===undefined){_dd.cancelable=true;}if(!_dd.detail){_dd.detail={};}_dd.detail.widget=this;var ret,_df=this["on"+_dc];if(_df){ret=_df.apply(this,_de?_de:[_dd]);}if(this._started&&!this._beingDestroyed){on.emit(this.domNode,_dc.toLowerCase(),_dd);}return ret;},on:function(_e0,_e1){var _e2=this._onMap(_e0);if(_e2){return _99.after(this,_e2,_e1,true);}return this.own(on(this.domNode,_e0,_e1))[0];},_onMap:function(_e3){var _e4=this.constructor,map=_e4._onMap;if(!map){map=(_e4._onMap={});for(var _e5 in _e4.prototype){if(/^on/.test(_e5)){map[_e5.replace(/^on/,"").toLowerCase()]=_e5;}}}return map[typeof _e3=="string"&&_e3.toLowerCase()];},toString:function(){return "[Widget "+this.declaredClass+", "+(this.id||"NO ID")+"]";},getChildren:function(){return this.containerNode?_a9.findWidgets(this.containerNode):[];},getParent:function(){return _a9.getEnclosingWidget(this.domNode.parentNode);},connect:function(obj,_e6,_e7){return this.own(_9b.connect(obj,_e6,this,_e7))[0];},disconnect:function(_e8){_e8.remove();},subscribe:function(t,_e9){return this.own(_a6.subscribe(t,_a3.hitch(this,_e9)))[0];},unsubscribe:function(_ea){_ea.remove();},isLeftToRight:function(){return this.dir?(this.dir=="ltr"):_a0.isBodyLtr(this.ownerDocument);},isFocusable:function(){return this.focus&&(_a1.get(this.domNode,"display")!="none");},placeAt:function(_eb,_ec){var _ed=!_eb.tagName&&_a9.byId(_eb);if(_ed&&_ed.addChild&&(!_ec||typeof _ec==="number")){_ed.addChild(this,_ec);}else{var ref=_ed?(_ed.containerNode&&!/after|before|replace/.test(_ec||"")?_ed.containerNode:_ed.domNode):dom.byId(_eb,this.ownerDocument);_9f.place(this.domNode,ref,_ec);if(!this._started&&(this.getParent()||{})._started){this.startup();}}return this;},defer:function(fcn,_ee){var _ef=setTimeout(_a3.hitch(this,function(){if(!_ef){return;}_ef=null;if(!this._destroyed){_a3.hitch(this,fcn)();}}),_ee||0);return {remove:function(){if(_ef){clearTimeout(_ef);_ef=null;}return null;}};}});if(has("dojo-bidi")){_b0.extend(_a8);}return _b0;});},"dijit/_base":function(){define(["./main","./a11y","./WidgetSet","./_base/focus","./_base/manager","./_base/place","./_base/popup","./_base/scroll","./_base/sniff","./_base/typematic","./_base/wai","./_base/window"],function(_f0){return _f0._base;});},"dojo/touch":function(){define(["./_base/kernel","./aspect","./dom","./dom-class","./_base/lang","./on","./has","./mouse","./domReady","./_base/window"],function(_f1,_f2,dom,_f3,_f4,on,has,_f5,_f6,win){var _f7=has("touch");var _f8=has("ios")<5;var _f9=navigator.msPointerEnabled;var _fa,_fb,_fc,_fd,_fe,_ff,_100,_101;var _102;function _103(_104,_105,_106){if(_f9&&_106){return function(node,_107){return on(node,_106,_107);};}else{if(_f7){return function(node,_108){var _109=on(node,_105,_108),_10a=on(node,_104,function(evt){if(!_102||(new Date()).getTime()>_102+1000){_108.call(this,evt);}});return {remove:function(){_109.remove();_10a.remove();}};};}else{return function(node,_10b){return on(node,_104,_10b);};}}};function _10c(node){do{if(node.dojoClick){return node.dojoClick;}}while(node=node.parentNode);};function _10d(e,_10e,_10f){_fb=!e.target.disabled&&_10c(e.target);if(_fb){_fc=e.target;_fd=e.touches?e.touches[0].pageX:e.clientX;_fe=e.touches?e.touches[0].pageY:e.clientY;_ff=(typeof _fb=="object"?_fb.x:(typeof _fb=="number"?_fb:0))||4;_100=(typeof _fb=="object"?_fb.y:(typeof _fb=="number"?_fb:0))||4;if(!_fa){_fa=true;win.doc.addEventListener(_10e,function(e){_fb=_fb&&e.target==_fc&&Math.abs((e.touches?e.touches[0].pageX:e.clientX)-_fd)<=_ff&&Math.abs((e.touches?e.touches[0].pageY:e.clientY)-_fe)<=_100;},true);win.doc.addEventListener(_10f,function(e){if(_fb){_101=(new Date()).getTime();var _110=e.target;if(_110.tagName==="LABEL"){_110=dom.byId(_110.getAttribute("for"))||_110;}setTimeout(function(){on.emit(_110,"click",{bubbles:true,cancelable:true,_dojo_click:true});});}},true);function _111(type){win.doc.addEventListener(type,function(e){if(!e._dojo_click&&(new Date()).getTime()<=_101+1000&&!(e.target.tagName=="INPUT"&&_f3.contains(e.target,"dijitOffScreen"))){e.stopPropagation();e.stopImmediatePropagation&&e.stopImmediatePropagation();if(type=="click"&&(e.target.tagName!="INPUT"||e.target.type=="radio"||e.target.type=="checkbox")&&e.target.tagName!="TEXTAREA"&&e.target.tagName!="AUDIO"&&e.target.tagName!="VIDEO"){e.preventDefault();}}},true);};_111("click");_111("mousedown");_111("mouseup");}}};var _112;if(_f7){if(_f9){_f6(function(){win.doc.addEventListener("MSPointerDown",function(evt){_10d(evt,"MSPointerMove","MSPointerUp");},true);});}else{_f6(function(){_112=win.body();win.doc.addEventListener("touchstart",function(evt){_102=(new Date()).getTime();var _113=_112;_112=evt.target;on.emit(_113,"dojotouchout",{relatedTarget:_112,bubbles:true});on.emit(_112,"dojotouchover",{relatedTarget:_113,bubbles:true});_10d(evt,"touchmove","touchend");},true);function _114(evt){var _115=_f4.delegate(evt,{bubbles:true});if(has("ios")>=6){_115.touches=evt.touches;_115.altKey=evt.altKey;_115.changedTouches=evt.changedTouches;_115.ctrlKey=evt.ctrlKey;_115.metaKey=evt.metaKey;_115.shiftKey=evt.shiftKey;_115.targetTouches=evt.targetTouches;}return _115;};on(win.doc,"touchmove",function(evt){_102=(new Date()).getTime();var _116=win.doc.elementFromPoint(evt.pageX-(_f8?0:win.global.pageXOffset),evt.pageY-(_f8?0:win.global.pageYOffset));if(_116){if(_112!==_116){on.emit(_112,"dojotouchout",{relatedTarget:_116,bubbles:true});on.emit(_116,"dojotouchover",{relatedTarget:_112,bubbles:true});_112=_116;}on.emit(_116,"dojotouchmove",_114(evt));}});on(win.doc,"touchend",function(evt){_102=(new Date()).getTime();var node=win.doc.elementFromPoint(evt.pageX-(_f8?0:win.global.pageXOffset),evt.pageY-(_f8?0:win.global.pageYOffset))||win.body();on.emit(node,"dojotouchend",_114(evt));});});}}var _117={press:_103("mousedown","touchstart","MSPointerDown"),move:_103("mousemove","dojotouchmove","MSPointerMove"),release:_103("mouseup","dojotouchend","MSPointerUp"),cancel:_103(_f5.leave,"touchcancel",_f7?"MSPointerCancel":null),over:_103("mouseover","dojotouchover","MSPointerOver"),out:_103("mouseout","dojotouchout","MSPointerOut"),enter:_f5._eventHandler(_103("mouseover","dojotouchover","MSPointerOver")),leave:_f5._eventHandler(_103("mouseout","dojotouchout","MSPointerOut"))};1&&(_f1.touch=_117);return _117;});},"dijit/form/_FormValueMixin":function(){define(["dojo/_base/declare","dojo/dom-attr","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","./_FormWidgetMixin"],function(_118,_119,keys,lang,on,has,_11a){return _118("dijit.form._FormValueMixin",_11a,{readOnly:false,_setReadOnlyAttr:function(_11b){_119.set(this.focusNode,"readOnly",_11b);this._set("readOnly",_11b);},postCreate:function(){this.inherited(arguments);if(this._resetValue===undefined){this._lastValueReported=this._resetValue=this.value;}},_setValueAttr:function(_11c,_11d){this._handleOnChange(_11c,_11d);},_handleOnChange:function(_11e,_11f){this._set("value",_11e);this.inherited(arguments);},undo:function(){this._setValueAttr(this._lastValueReported,false);},reset:function(){this._hasBeenBlurred=false;this._setValueAttr(this._resetValue,true);}});});},"dojo/Stateful":function(){define(["./_base/declare","./_base/lang","./_base/array","./when"],function(_120,lang,_121,when){return _120("dojo.Stateful",null,{_attrPairNames:{},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}return (apn[name]={s:"_"+name+"Setter",g:"_"+name+"Getter"});},postscript:function(_122){if(_122){this.set(_122);}},_get:function(name,_123){return typeof this[_123.g]==="function"?this[_123.g]():this[name];},get:function(name){return this._get(name,this._getAttrNames(name));},set:function(name,_124){if(typeof name==="object"){for(var x in name){if(name.hasOwnProperty(x)&&x!="_watchCallbacks"){this.set(x,name[x]);}}return this;}var _125=this._getAttrNames(name),_126=this._get(name,_125),_127=this[_125.s],_128;if(typeof _127==="function"){_128=_127.apply(this,Array.prototype.slice.call(arguments,1));}else{this[name]=_124;}if(this._watchCallbacks){var self=this;when(_128,function(){self._watchCallbacks(name,_126,_124);});}return this;},_changeAttrValue:function(name,_129){var _12a=this.get(name);this[name]=_129;if(this._watchCallbacks){this._watchCallbacks(name,_12a,_129);}return this;},watch:function(name,_12b){var _12c=this._watchCallbacks;if(!_12c){var self=this;_12c=this._watchCallbacks=function(name,_12d,_12e,_12f){var _130=function(_131){if(_131){_131=_131.slice();for(var i=0,l=_131.length;i<l;i++){_131[i].call(self,name,_12d,_12e);}}};_130(_12c["_"+name]);if(!_12f){_130(_12c["*"]);}};}if(!_12b&&typeof name==="function"){_12b=name;name="*";}else{name="_"+name;}var _132=_12c[name];if(typeof _132!=="object"){_132=_12c[name]=[];}_132.push(_12b);var _133={};_133.unwatch=_133.remove=function(){var _134=_121.indexOf(_132,_12b);if(_134>-1){_132.splice(_134,1);}};return _133;}});});},"dijit/_CssStateMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-class","dojo/has","dojo/_base/lang","dojo/on","dojo/domReady","dojo/touch","dojo/_base/window","./a11yclick","./registry"],function(_135,_136,dom,_137,has,lang,on,_138,_139,win,_13a,_13b){var _13c=_136("dijit._CssStateMixin",[],{hovering:false,active:false,_applyAttributes:function(){this.inherited(arguments);_135.forEach(["disabled","readOnly","checked","selected","focused","state","hovering","active","_opened"],function(attr){this.watch(attr,lang.hitch(this,"_setStateClass"));},this);for(var ap in this.cssStateNodes||{}){this._trackMouseState(this[ap],this.cssStateNodes[ap]);}this._trackMouseState(this.domNode,this.baseClass);this._setStateClass();},_cssMouseEvent:function(_13d){if(!this.disabled){switch(_13d.type){case "mouseover":case "MSPointerOver":this._set("hovering",true);this._set("active",this._mouseDown);break;case "mouseout":case "MSPointerOut":this._set("hovering",false);this._set("active",false);break;case "mousedown":case "touchstart":case "MSPointerDown":case "keydown":this._set("active",true);break;case "mouseup":case "dojotouchend":case "keyup":this._set("active",false);break;}}},_setStateClass:function(){var _13e=this.baseClass.split(" ");function _13f(_140){_13e=_13e.concat(_135.map(_13e,function(c){return c+_140;}),"dijit"+_140);};if(!this.isLeftToRight()){_13f("Rtl");}var _141=this.checked=="mixed"?"Mixed":(this.checked?"Checked":"");if(this.checked){_13f(_141);}if(this.state){_13f(this.state);}if(this.selected){_13f("Selected");}if(this._opened){_13f("Opened");}if(this.disabled){_13f("Disabled");}else{if(this.readOnly){_13f("ReadOnly");}else{if(this.active){_13f("Active");}else{if(this.hovering){_13f("Hover");}}}}if(this.focused){_13f("Focused");}var tn=this.stateNode||this.domNode,_142={};_135.forEach(tn.className.split(" "),function(c){_142[c]=true;});if("_stateClasses" in this){_135.forEach(this._stateClasses,function(c){delete _142[c];});}_135.forEach(_13e,function(c){_142[c]=true;});var _143=[];for(var c in _142){_143.push(c);}tn.className=_143.join(" ");this._stateClasses=_13e;},_subnodeCssMouseEvent:function(node,_144,evt){if(this.disabled||this.readOnly){return;}function _145(_146){_137.toggle(node,_144+"Hover",_146);};function _147(_148){_137.toggle(node,_144+"Active",_148);};function _149(_14a){_137.toggle(node,_144+"Focused",_14a);};switch(evt.type){case "mouseover":case "MSPointerOver":_145(true);break;case "mouseout":case "MSPointerOut":_145(false);_147(false);break;case "mousedown":case "touchstart":case "MSPointerDown":case "keydown":_147(true);break;case "mouseup":case "MSPointerUp":case "dojotouchend":case "keyup":_147(false);break;case "focus":case "focusin":_149(true);break;case "blur":case "focusout":_149(false);break;}},_trackMouseState:function(node,_14b){node._cssState=_14b;}});_138(function(){function _14c(evt,_14d,_14e){if(_14e&&dom.isDescendant(_14e,_14d)){return;}for(var node=_14d;node&&node!=_14e;node=node.parentNode){if(node._cssState){var _14f=_13b.getEnclosingWidget(node);if(_14f){if(node==_14f.domNode){_14f._cssMouseEvent(evt);}else{_14f._subnodeCssMouseEvent(node,node._cssState,evt);}}}}};var body=win.body(),_150;on(body,_139.over,function(evt){_14c(evt,evt.target,evt.relatedTarget);});on(body,_139.out,function(evt){_14c(evt,evt.target,evt.relatedTarget);});on(body,_13a.press,function(evt){_150=evt.target;_14c(evt,_150);});on(body,_13a.release,function(evt){_14c(evt,_150);_150=null;});on(body,"focusin, focusout",function(evt){var node=evt.target;if(node._cssState&&!node.getAttribute("widgetId")){var _151=_13b.getEnclosingWidget(node);if(_151){_151._subnodeCssMouseEvent(node,node._cssState,evt);}}});});return _13c;});},"dijit/_base/manager":function(){define(["dojo/_base/array","dojo/_base/config","dojo/_base/lang","../registry","../main"],function(_152,_153,lang,_154,_155){var _156={};_152.forEach(["byId","getUniqueId","findWidgets","_destroyAll","byNode","getEnclosingWidget"],function(name){_156[name]=_154[name];});lang.mixin(_156,{defaultDuration:_153["defaultDuration"]||200});lang.mixin(_155,_156);return _155;});},"dijit/_base/sniff":function(){define(["dojo/uacss"],function(){});},"dijit/BackgroundIframe":function(){define(["require","./main","dojo/_base/config","dojo/dom-construct","dojo/dom-style","dojo/_base/lang","dojo/on","dojo/sniff"],function(_157,_158,_159,_15a,_15b,lang,on,has){has.add("config-bgIframe",!has("touch"));var _15c=new function(){var _15d=[];this.pop=function(){var _15e;if(_15d.length){_15e=_15d.pop();_15e.style.display="";}else{if(has("ie")<9){var burl=_159["dojoBlankHtmlUrl"]||_157.toUrl("dojo/resources/blank.html")||"javascript:\"\"";var html="<iframe src='"+burl+"' role='presentation'"+" style='position: absolute; left: 0px; top: 0px;"+"z-index: -1; filter:Alpha(Opacity=\"0\");'>";_15e=document.createElement(html);}else{_15e=_15a.create("iframe");_15e.src="javascript:\"\"";_15e.className="dijitBackgroundIframe";_15e.setAttribute("role","presentation");_15b.set(_15e,"opacity",0.1);}_15e.tabIndex=-1;}return _15e;};this.push=function(_15f){_15f.style.display="none";_15d.push(_15f);};}();_158.BackgroundIframe=function(node){if(!node.id){throw new Error("no id");}if(has("config-bgIframe")){var _160=(this.iframe=_15c.pop());node.appendChild(_160);if(has("ie")<7||has("quirks")){this.resize(node);this._conn=on(node,"resize",lang.hitch(this,"resize",node));}else{_15b.set(_160,{width:"100%",height:"100%"});}}};lang.extend(_158.BackgroundIframe,{resize:function(node){if(this.iframe){_15b.set(this.iframe,{width:node.offsetWidth+"px",height:node.offsetHeight+"px"});}},destroy:function(){if(this._conn){this._conn.remove();this._conn=null;}if(this.iframe){_15c.push(this.iframe);delete this.iframe;}}});return _158.BackgroundIframe;});},"dijit/typematic":function(){define(["dojo/_base/array","dojo/_base/connect","dojo/_base/lang","dojo/on","dojo/sniff","./main"],function(_161,_162,lang,on,has,_163){var _164=(_163.typematic={_fireEventAndReload:function(){this._timer=null;this._callback(++this._count,this._node,this._evt);this._currentTimeout=Math.max(this._currentTimeout<0?this._initialDelay:(this._subsequentDelay>1?this._subsequentDelay:Math.round(this._currentTimeout*this._subsequentDelay)),this._minDelay);this._timer=setTimeout(lang.hitch(this,"_fireEventAndReload"),this._currentTimeout);},trigger:function(evt,_165,node,_166,obj,_167,_168,_169){if(obj!=this._obj){this.stop();this._initialDelay=_168||500;this._subsequentDelay=_167||0.9;this._minDelay=_169||10;this._obj=obj;this._node=node;this._currentTimeout=-1;this._count=-1;this._callback=lang.hitch(_165,_166);this._evt={faux:true};for(var attr in evt){if(attr!="layerX"&&attr!="layerY"){var v=evt[attr];if(typeof v!="function"&&typeof v!="undefined"){this._evt[attr]=v;}}}this._fireEventAndReload();}},stop:function(){if(this._timer){clearTimeout(this._timer);this._timer=null;}if(this._obj){this._callback(-1,this._node,this._evt);this._obj=null;}},addKeyListener:function(node,_16a,_16b,_16c,_16d,_16e,_16f){var type="keyCode" in _16a?"keydown":"charCode" in _16a?"keypress":_162._keypress,attr="keyCode" in _16a?"keyCode":"charCode" in _16a?"charCode":"charOrCode";var _170=[on(node,type,lang.hitch(this,function(evt){if(evt[attr]==_16a[attr]&&(_16a.ctrlKey===undefined||_16a.ctrlKey==evt.ctrlKey)&&(_16a.altKey===undefined||_16a.altKey==evt.altKey)&&(_16a.metaKey===undefined||_16a.metaKey==(evt.metaKey||false))&&(_16a.shiftKey===undefined||_16a.shiftKey==evt.shiftKey)){evt.stopPropagation();evt.preventDefault();_164.trigger(evt,_16b,node,_16c,_16a,_16d,_16e,_16f);}else{if(_164._obj==_16a){_164.stop();}}})),on(node,"keyup",lang.hitch(this,function(){if(_164._obj==_16a){_164.stop();}}))];return {remove:function(){_161.forEach(_170,function(h){h.remove();});}};},addMouseListener:function(node,_171,_172,_173,_174,_175){var _176=[on(node,"mousedown",lang.hitch(this,function(evt){evt.preventDefault();_164.trigger(evt,_171,node,_172,node,_173,_174,_175);})),on(node,"mouseup",lang.hitch(this,function(evt){if(this._obj){evt.preventDefault();}_164.stop();})),on(node,"mouseout",lang.hitch(this,function(evt){if(this._obj){evt.preventDefault();}_164.stop();})),on(node,"dblclick",lang.hitch(this,function(evt){evt.preventDefault();if(has("ie")<9){_164.trigger(evt,_171,node,_172,node,_173,_174,_175);setTimeout(lang.hitch(this,_164.stop),50);}}))];return {remove:function(){_161.forEach(_176,function(h){h.remove();});}};},addListener:function(_177,_178,_179,_17a,_17b,_17c,_17d,_17e){var _17f=[this.addKeyListener(_178,_179,_17a,_17b,_17c,_17d,_17e),this.addMouseListener(_177,_17a,_17b,_17c,_17d,_17e)];return {remove:function(){_161.forEach(_17f,function(h){h.remove();});}};}});return _164;});},"dojo/_base/url":function(){define(["./kernel"],function(dojo){var ore=new RegExp("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?$"),ire=new RegExp("^((([^\\[:]+):)?([^@]+)@)?(\\[([^\\]]+)\\]|([^\\[:]*))(:([0-9]+))?$"),_180=function(){var n=null,_181=arguments,uri=[_181[0]];for(var i=1;i<_181.length;i++){if(!_181[i]){continue;}var _182=new _180(_181[i]+""),_183=new _180(uri[0]+"");if(_182.path==""&&!_182.scheme&&!_182.authority&&!_182.query){if(_182.fragment!=n){_183.fragment=_182.fragment;}_182=_183;}else{if(!_182.scheme){_182.scheme=_183.scheme;if(!_182.authority){_182.authority=_183.authority;if(_182.path.charAt(0)!="/"){var path=_183.path.substring(0,_183.path.lastIndexOf("/")+1)+_182.path;var segs=path.split("/");for(var j=0;j<segs.length;j++){if(segs[j]=="."){if(j==segs.length-1){segs[j]="";}else{segs.splice(j,1);j--;}}else{if(j>0&&!(j==1&&segs[0]=="")&&segs[j]==".."&&segs[j-1]!=".."){if(j==(segs.length-1)){segs.splice(j,1);segs[j-1]="";}else{segs.splice(j-1,2);j-=2;}}}}_182.path=segs.join("/");}}}}uri=[];if(_182.scheme){uri.push(_182.scheme,":");}if(_182.authority){uri.push("//",_182.authority);}uri.push(_182.path);if(_182.query){uri.push("?",_182.query);}if(_182.fragment){uri.push("#",_182.fragment);}}this.uri=uri.join("");var r=this.uri.match(ore);this.scheme=r[2]||(r[1]?"":n);this.authority=r[4]||(r[3]?"":n);this.path=r[5];this.query=r[7]||(r[6]?"":n);this.fragment=r[9]||(r[8]?"":n);if(this.authority!=n){r=this.authority.match(ire);this.user=r[3]||n;this.password=r[4]||n;this.host=r[6]||r[7];this.port=r[9]||n;}};_180.prototype.toString=function(){return this.uri;};return dojo._Url=_180;});},"dojo/date/stamp":function(){define(["../_base/lang","../_base/array"],function(lang,_184){var _185={};lang.setObject("dojo.date.stamp",_185);_185.fromISOString=function(_186,_187){if(!_185._isoRegExp){_185._isoRegExp=/^(?:(\d{4})(?:-(\d{2})(?:-(\d{2}))?)?)?(?:T(\d{2}):(\d{2})(?::(\d{2})(.\d+)?)?((?:[+-](\d{2}):(\d{2}))|Z)?)?$/;}var _188=_185._isoRegExp.exec(_186),_189=null;if(_188){_188.shift();if(_188[1]){_188[1]--;}if(_188[6]){_188[6]*=1000;}if(_187){_187=new Date(_187);_184.forEach(_184.map(["FullYear","Month","Date","Hours","Minutes","Seconds","Milliseconds"],function(prop){return _187["get"+prop]();}),function(_18a,_18b){_188[_18b]=_188[_18b]||_18a;});}_189=new Date(_188[0]||1970,_188[1]||0,_188[2]||1,_188[3]||0,_188[4]||0,_188[5]||0,_188[6]||0);if(_188[0]<100){_189.setFullYear(_188[0]||1970);}var _18c=0,_18d=_188[7]&&_188[7].charAt(0);if(_18d!="Z"){_18c=((_188[8]||0)*60)+(Number(_188[9])||0);if(_18d!="-"){_18c*=-1;}}if(_18d){_18c-=_189.getTimezoneOffset();}if(_18c){_189.setTime(_189.getTime()+_18c*60000);}}return _189;};_185.toISOString=function(_18e,_18f){var _190=function(n){return (n<10)?"0"+n:n;};_18f=_18f||{};var _191=[],_192=_18f.zulu?"getUTC":"get",date="";if(_18f.selector!="time"){var year=_18e[_192+"FullYear"]();date=["0000".substr((year+"").length)+year,_190(_18e[_192+"Month"]()+1),_190(_18e[_192+"Date"]())].join("-");}_191.push(date);if(_18f.selector!="date"){var time=[_190(_18e[_192+"Hours"]()),_190(_18e[_192+"Minutes"]()),_190(_18e[_192+"Seconds"]())].join(":");var _193=_18e[_192+"Milliseconds"]();if(_18f.milliseconds){time+="."+(_193<100?"0":"")+_190(_193);}if(_18f.zulu){time+="Z";}else{if(_18f.selector!="time"){var _194=_18e.getTimezoneOffset();var _195=Math.abs(_194);time+=(_194>0?"-":"+")+_190(Math.floor(_195/60))+":"+_190(_195%60);}}_191.push(time);}return _191.join("T");};return _185;});},"dijit/_base/place":function(){define(["dojo/_base/array","dojo/_base/lang","dojo/window","../place","../main"],function(_196,lang,_197,_198,_199){var _19a={};_19a.getViewport=function(){return _197.getBox();};_19a.placeOnScreen=_198.at;_19a.placeOnScreenAroundElement=function(node,_19b,_19c,_19d){var _19e;if(lang.isArray(_19c)){_19e=_19c;}else{_19e=[];for(var key in _19c){_19e.push({aroundCorner:key,corner:_19c[key]});}}return _198.around(node,_19b,_19e,true,_19d);};_19a.placeOnScreenAroundNode=_19a.placeOnScreenAroundElement;_19a.placeOnScreenAroundRectangle=_19a.placeOnScreenAroundElement;_19a.getPopupAroundAlignment=function(_19f,_1a0){var _1a1={};_196.forEach(_19f,function(pos){var ltr=_1a0;switch(pos){case "after":_1a1[_1a0?"BR":"BL"]=_1a0?"BL":"BR";break;case "before":_1a1[_1a0?"BL":"BR"]=_1a0?"BR":"BL";break;case "below-alt":ltr=!ltr;case "below":_1a1[ltr?"BL":"BR"]=ltr?"TL":"TR";_1a1[ltr?"BR":"BL"]=ltr?"TR":"TL";break;case "above-alt":ltr=!ltr;case "above":default:_1a1[ltr?"TL":"TR"]=ltr?"BL":"BR";_1a1[ltr?"TR":"TL"]=ltr?"BR":"BL";break;}});return _1a1;};lang.mixin(_199,_19a);return _199;});},"dijit/registry":function(){define(["dojo/_base/array","dojo/sniff","dojo/_base/window","./main"],function(_1a2,has,win,_1a3){var _1a4={},hash={};var _1a5={length:0,add:function(_1a6){if(hash[_1a6.id]){throw new Error("Tried to register widget with id=="+_1a6.id+" but that id is already registered");}hash[_1a6.id]=_1a6;this.length++;},remove:function(id){if(hash[id]){delete hash[id];this.length--;}},byId:function(id){return typeof id=="string"?hash[id]:id;},byNode:function(node){return hash[node.getAttribute("widgetId")];},toArray:function(){var ar=[];for(var id in hash){ar.push(hash[id]);}return ar;},getUniqueId:function(_1a7){var id;do{id=_1a7+"_"+(_1a7 in _1a4?++_1a4[_1a7]:_1a4[_1a7]=0);}while(hash[id]);return _1a3._scopeName=="dijit"?id:_1a3._scopeName+"_"+id;},findWidgets:function(root,_1a8){var _1a9=[];function _1aa(root){for(var node=root.firstChild;node;node=node.nextSibling){if(node.nodeType==1){var _1ab=node.getAttribute("widgetId");if(_1ab){var _1ac=hash[_1ab];if(_1ac){_1a9.push(_1ac);}}else{if(node!==_1a8){_1aa(node);}}}}};_1aa(root);return _1a9;},_destroyAll:function(){_1a3._curFocus=null;_1a3._prevFocus=null;_1a3._activeStack=[];_1a2.forEach(_1a5.findWidgets(win.body()),function(_1ad){if(!_1ad._destroyed){if(_1ad.destroyRecursive){_1ad.destroyRecursive();}else{if(_1ad.destroy){_1ad.destroy();}}}});},getEnclosingWidget:function(node){while(node){var id=node.nodeType==1&&node.getAttribute("widgetId");if(id){return hash[id];}node=node.parentNode;}return null;},_hash:hash};_1a3.registry=_1a5;return _1a5;});},"dijit/form/_FormWidgetMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/dom-style","dojo/_base/lang","dojo/mouse","dojo/on","dojo/sniff","dojo/window","../a11y"],function(_1ae,_1af,_1b0,_1b1,lang,_1b2,on,has,_1b3,a11y){return _1af("dijit.form._FormWidgetMixin",null,{name:"",alt:"",value:"",type:"text","aria-label":"focusNode",tabIndex:"0",_setTabIndexAttr:"focusNode",disabled:false,intermediateChanges:false,scrollOnFocus:true,_setIdAttr:"focusNode",_setDisabledAttr:function(_1b4){this._set("disabled",_1b4);_1b0.set(this.focusNode,"disabled",_1b4);if(this.valueNode){_1b0.set(this.valueNode,"disabled",_1b4);}this.focusNode.setAttribute("aria-disabled",_1b4?"true":"false");if(_1b4){this._set("hovering",false);this._set("active",false);var _1b5="tabIndex" in this.attributeMap?this.attributeMap.tabIndex:("_setTabIndexAttr" in this)?this._setTabIndexAttr:"focusNode";_1ae.forEach(lang.isArray(_1b5)?_1b5:[_1b5],function(_1b6){var node=this[_1b6];if(has("webkit")||a11y.hasDefaultTabStop(node)){node.setAttribute("tabIndex","-1");}else{node.removeAttribute("tabIndex");}},this);}else{if(this.tabIndex!=""){this.set("tabIndex",this.tabIndex);}}},_onFocus:function(by){if(by=="mouse"&&this.isFocusable()){var _1b7=this.own(on(this.focusNode,"focus",function(){_1b8.remove();_1b7.remove();}))[0];var _1b8=this.own(on(this.ownerDocumentBody,"mouseup, touchend",lang.hitch(this,function(evt){_1b8.remove();_1b7.remove();if(this.focused){if(evt.type=="touchend"){this.defer("focus");}else{this.focus();}}})))[0];}if(this.scrollOnFocus){this.defer(function(){_1b3.scrollIntoView(this.domNode);});}this.inherited(arguments);},isFocusable:function(){return !this.disabled&&this.focusNode&&(_1b1.get(this.domNode,"display")!="none");},focus:function(){if(!this.disabled&&this.focusNode.focus){try{this.focusNode.focus();}catch(e){}}},compare:function(val1,val2){if(typeof val1=="number"&&typeof val2=="number"){return (isNaN(val1)&&isNaN(val2))?0:val1-val2;}else{if(val1>val2){return 1;}else{if(val1<val2){return -1;}else{return 0;}}}},onChange:function(){},_onChangeActive:false,_handleOnChange:function(_1b9,_1ba){if(this._lastValueReported==undefined&&(_1ba===null||!this._onChangeActive)){this._resetValue=this._lastValueReported=_1b9;}this._pendingOnChange=this._pendingOnChange||(typeof _1b9!=typeof this._lastValueReported)||(this.compare(_1b9,this._lastValueReported)!=0);if((this.intermediateChanges||_1ba||_1ba===undefined)&&this._pendingOnChange){this._lastValueReported=_1b9;this._pendingOnChange=false;if(this._onChangeActive){if(this._onChangeHandle){this._onChangeHandle.remove();}this._onChangeHandle=this.defer(function(){this._onChangeHandle=null;this.onChange(_1b9);});}}},create:function(){this.inherited(arguments);this._onChangeActive=true;},destroy:function(){if(this._onChangeHandle){this._onChangeHandle.remove();this.onChange(this._lastValueReported);}this.inherited(arguments);}});});},"dijit/_AttachMixin":function(){define(["require","dojo/_base/array","dojo/_base/connect","dojo/_base/declare","dojo/_base/lang","dojo/mouse","dojo/on","dojo/touch","./_WidgetBase"],function(_1bb,_1bc,_1bd,_1be,lang,_1bf,on,_1c0,_1c1){var _1c2=lang.delegate(_1c0,{"mouseenter":_1bf.enter,"mouseleave":_1bf.leave,"keypress":_1bd._keypress});var _1c3;var _1c4=_1be("dijit._AttachMixin",null,{constructor:function(){this._attachPoints=[];this._attachEvents=[];},buildRendering:function(){this.inherited(arguments);this._attachTemplateNodes(this.domNode);this._beforeFillContent();},_beforeFillContent:function(){},_attachTemplateNodes:function(_1c5){var node=_1c5;while(true){if(node.nodeType==1&&(this._processTemplateNode(node,function(n,p){return n.getAttribute(p);},this._attach)||this.searchContainerNode)&&node.firstChild){node=node.firstChild;}else{if(node==_1c5){return;}while(!node.nextSibling){node=node.parentNode;if(node==_1c5){return;}}node=node.nextSibling;}}},_processTemplateNode:function(_1c6,_1c7,_1c8){var ret=true;var _1c9=this.attachScope||this,_1ca=_1c7(_1c6,"dojoAttachPoint")||_1c7(_1c6,"data-dojo-attach-point");if(_1ca){var _1cb,_1cc=_1ca.split(/\s*,\s*/);while((_1cb=_1cc.shift())){if(lang.isArray(_1c9[_1cb])){_1c9[_1cb].push(_1c6);}else{_1c9[_1cb]=_1c6;}ret=(_1cb!="containerNode");this._attachPoints.push(_1cb);}}var _1cd=_1c7(_1c6,"dojoAttachEvent")||_1c7(_1c6,"data-dojo-attach-event");if(_1cd){var _1ce,_1cf=_1cd.split(/\s*,\s*/);var trim=lang.trim;while((_1ce=_1cf.shift())){if(_1ce){var _1d0=null;if(_1ce.indexOf(":")!=-1){var _1d1=_1ce.split(":");_1ce=trim(_1d1[0]);_1d0=trim(_1d1[1]);}else{_1ce=trim(_1ce);}if(!_1d0){_1d0=_1ce;}this._attachEvents.push(_1c8(_1c6,_1ce,lang.hitch(_1c9,_1d0)));}}}return ret;},_attach:function(node,type,func){type=type.replace(/^on/,"").toLowerCase();if(type=="dijitclick"){type=_1c3||(_1c3=_1bb("./a11yclick"));}else{type=_1c2[type]||type;}return on(node,type,func);},_detachTemplateNodes:function(){var _1d2=this.attachScope||this;_1bc.forEach(this._attachPoints,function(_1d3){delete _1d2[_1d3];});this._attachPoints=[];_1bc.forEach(this._attachEvents,function(_1d4){_1d4.remove();});this._attachEvents=[];},destroyRendering:function(){this._detachTemplateNodes();this.inherited(arguments);}});lang.extend(_1c1,{dojoAttachEvent:"",dojoAttachPoint:""});return _1c4;});},"dojo/uacss":function(){define(["./dom-geometry","./_base/lang","./domReady","./sniff","./_base/window"],function(_1d5,lang,_1d6,has,_1d7){var html=_1d7.doc.documentElement,ie=has("ie"),_1d8=has("opera"),maj=Math.floor,ff=has("ff"),_1d9=_1d5.boxModel.replace(/-/,""),_1da={"dj_quirks":has("quirks"),"dj_opera":_1d8,"dj_khtml":has("khtml"),"dj_webkit":has("webkit"),"dj_safari":has("safari"),"dj_chrome":has("chrome"),"dj_gecko":has("mozilla"),"dj_ios":has("ios"),"dj_android":has("android")};if(ie){_1da["dj_ie"]=true;_1da["dj_ie"+maj(ie)]=true;_1da["dj_iequirks"]=has("quirks");}if(ff){_1da["dj_ff"+maj(ff)]=true;}_1da["dj_"+_1d9]=true;var _1db="";for(var clz in _1da){if(_1da[clz]){_1db+=clz+" ";}}html.className=lang.trim(html.className+" "+_1db);_1d6(function(){if(!_1d5.isBodyLtr()){var _1dc="dj_rtl dijitRtl "+_1db.replace(/ /g,"-rtl ");html.className=lang.trim(html.className+" "+_1dc+"dj_rtl dijitRtl "+_1db.replace(/ /g,"-rtl "));}});return has;});},"dijit/place":function(){define(["dojo/_base/array","dojo/dom-geometry","dojo/dom-style","dojo/_base/kernel","dojo/_base/window","./Viewport","./main"],function(_1dd,_1de,_1df,_1e0,win,_1e1,_1e2){function _1e3(node,_1e4,_1e5,_1e6){var view=_1e1.getEffectiveBox(node.ownerDocument);if(!node.parentNode||String(node.parentNode.tagName).toLowerCase()!="body"){win.body(node.ownerDocument).appendChild(node);}var best=null;_1dd.some(_1e4,function(_1e7){var _1e8=_1e7.corner;var pos=_1e7.pos;var _1e9=0;var _1ea={w:{"L":view.l+view.w-pos.x,"R":pos.x-view.l,"M":view.w}[_1e8.charAt(1)],h:{"T":view.t+view.h-pos.y,"B":pos.y-view.t,"M":view.h}[_1e8.charAt(0)]};var s=node.style;s.left=s.right="auto";if(_1e5){var res=_1e5(node,_1e7.aroundCorner,_1e8,_1ea,_1e6);_1e9=typeof res=="undefined"?0:res;}var _1eb=node.style;var _1ec=_1eb.display;var _1ed=_1eb.visibility;if(_1eb.display=="none"){_1eb.visibility="hidden";_1eb.display="";}var bb=_1de.position(node);_1eb.display=_1ec;_1eb.visibility=_1ed;var _1ee={"L":pos.x,"R":pos.x-bb.w,"M":Math.max(view.l,Math.min(view.l+view.w,pos.x+(bb.w>>1))-bb.w)}[_1e8.charAt(1)],_1ef={"T":pos.y,"B":pos.y-bb.h,"M":Math.max(view.t,Math.min(view.t+view.h,pos.y+(bb.h>>1))-bb.h)}[_1e8.charAt(0)],_1f0=Math.max(view.l,_1ee),_1f1=Math.max(view.t,_1ef),endX=Math.min(view.l+view.w,_1ee+bb.w),endY=Math.min(view.t+view.h,_1ef+bb.h),_1f2=endX-_1f0,_1f3=endY-_1f1;_1e9+=(bb.w-_1f2)+(bb.h-_1f3);if(best==null||_1e9<best.overflow){best={corner:_1e8,aroundCorner:_1e7.aroundCorner,x:_1f0,y:_1f1,w:_1f2,h:_1f3,overflow:_1e9,spaceAvailable:_1ea};}return !_1e9;});if(best.overflow&&_1e5){_1e5(node,best.aroundCorner,best.corner,best.spaceAvailable,_1e6);}var l=_1de.isBodyLtr(node.ownerDocument),top=best.y,side=l?best.x:view.w-best.x-best.w;if(/relative|absolute/.test(_1df.get(win.body(node.ownerDocument),"position"))){top-=_1df.get(win.body(node.ownerDocument),"marginTop");side-=(l?1:-1)*_1df.get(win.body(node.ownerDocument),l?"marginLeft":"marginRight");}var s=node.style;s.top=top+"px";s[l?"left":"right"]=side+"px";s[l?"right":"left"]="auto";return best;};var _1f4={"TL":"BR","TR":"BL","BL":"TR","BR":"TL"};var _1f5={at:function(node,pos,_1f6,_1f7,_1f8){var _1f9=_1dd.map(_1f6,function(_1fa){var c={corner:_1fa,aroundCorner:_1f4[_1fa],pos:{x:pos.x,y:pos.y}};if(_1f7){c.pos.x+=_1fa.charAt(1)=="L"?_1f7.x:-_1f7.x;c.pos.y+=_1fa.charAt(0)=="T"?_1f7.y:-_1f7.y;}return c;});return _1e3(node,_1f9,_1f8);},around:function(node,_1fb,_1fc,_1fd,_1fe){var _1ff;if(typeof _1fb=="string"||"offsetWidth" in _1fb){_1ff=_1de.position(_1fb,true);if(/^(above|below)/.test(_1fc[0])){var _200=_1de.getBorderExtents(_1fb),_201=_1fb.firstChild?_1de.getBorderExtents(_1fb.firstChild):{t:0,l:0,b:0,r:0},_202=_1de.getBorderExtents(node),_203=node.firstChild?_1de.getBorderExtents(node.firstChild):{t:0,l:0,b:0,r:0};_1ff.y+=Math.min(_200.t+_201.t,_202.t+_203.t);_1ff.h-=Math.min(_200.t+_201.t,_202.t+_203.t)+Math.min(_200.b+_201.b,_202.b+_203.b);}}else{_1ff=_1fb;}if(_1fb.parentNode){var _204=_1df.getComputedStyle(_1fb).position=="absolute";var _205=_1fb.parentNode;while(_205&&_205.nodeType==1&&_205.nodeName!="BODY"){var _206=_1de.position(_205,true),pcs=_1df.getComputedStyle(_205);if(/relative|absolute/.test(pcs.position)){_204=false;}if(!_204&&/hidden|auto|scroll/.test(pcs.overflow)){var _207=Math.min(_1ff.y+_1ff.h,_206.y+_206.h);var _208=Math.min(_1ff.x+_1ff.w,_206.x+_206.w);_1ff.x=Math.max(_1ff.x,_206.x);_1ff.y=Math.max(_1ff.y,_206.y);_1ff.h=_207-_1ff.y;_1ff.w=_208-_1ff.x;}if(pcs.position=="absolute"){_204=true;}_205=_205.parentNode;}}var x=_1ff.x,y=_1ff.y,_209="w" in _1ff?_1ff.w:(_1ff.w=_1ff.width),_20a="h" in _1ff?_1ff.h:(_1e0.deprecated("place.around: dijit/place.__Rectangle: { x:"+x+", y:"+y+", height:"+_1ff.height+", width:"+_209+" } has been deprecated.  Please use { x:"+x+", y:"+y+", h:"+_1ff.height+", w:"+_209+" }","","2.0"),_1ff.h=_1ff.height);var _20b=[];function push(_20c,_20d){_20b.push({aroundCorner:_20c,corner:_20d,pos:{x:{"L":x,"R":x+_209,"M":x+(_209>>1)}[_20c.charAt(1)],y:{"T":y,"B":y+_20a,"M":y+(_20a>>1)}[_20c.charAt(0)]}});};_1dd.forEach(_1fc,function(pos){var ltr=_1fd;switch(pos){case "above-centered":push("TM","BM");break;case "below-centered":push("BM","TM");break;case "after-centered":ltr=!ltr;case "before-centered":push(ltr?"ML":"MR",ltr?"MR":"ML");break;case "after":ltr=!ltr;case "before":push(ltr?"TL":"TR",ltr?"TR":"TL");push(ltr?"BL":"BR",ltr?"BR":"BL");break;case "below-alt":ltr=!ltr;case "below":push(ltr?"BL":"BR",ltr?"TL":"TR");push(ltr?"BR":"BL",ltr?"TR":"TL");break;case "above-alt":ltr=!ltr;case "above":push(ltr?"TL":"TR",ltr?"BL":"BR");push(ltr?"TR":"TL",ltr?"BR":"BL");break;default:push(pos.aroundCorner,pos.corner);}});var _20e=_1e3(node,_20b,_1fe,{w:_209,h:_20a});_20e.aroundNodePos=_1ff;return _20e;}};return _1e2.place=_1f5;});},"dojo/promise/all":function(){define(["../_base/array","../Deferred","../when"],function(_20f,_210,when){"use strict";var some=_20f.some;return function all(_211){var _212,_20f;if(_211 instanceof Array){_20f=_211;}else{if(_211&&typeof _211==="object"){_212=_211;}}var _213;var _214=[];if(_212){_20f=[];for(var key in _212){if(Object.hasOwnProperty.call(_212,key)){_214.push(key);_20f.push(_212[key]);}}_213={};}else{if(_20f){_213=[];}}if(!_20f||!_20f.length){return new _210().resolve(_213);}var _215=new _210();_215.promise.always(function(){_213=_214=null;});var _216=_20f.length;some(_20f,function(_217,_218){if(!_212){_214.push(_218);}when(_217,function(_219){if(!_215.isFulfilled()){_213[_214[_218]]=_219;if(--_216===0){_215.resolve(_213);}}},_215.reject);return _215.isFulfilled();});return _215.promise;};});},"dojo/window":function(){define(["./_base/lang","./sniff","./_base/window","./dom","./dom-geometry","./dom-style","./dom-construct"],function(lang,has,_21a,dom,geom,_21b,_21c){has.add("rtl-adjust-position-for-verticalScrollBar",function(win,doc){var body=_21a.body(doc),_21d=_21c.create("div",{style:{overflow:"scroll",overflowX:"visible",direction:"rtl",visibility:"hidden",position:"absolute",left:"0",top:"0",width:"64px",height:"64px"}},body,"last"),div=_21c.create("div",{style:{overflow:"hidden",direction:"ltr"}},_21d,"last"),ret=geom.position(div).x!=0;_21d.removeChild(div);body.removeChild(_21d);return ret;});has.add("position-fixed-support",function(win,doc){var body=_21a.body(doc),_21e=_21c.create("span",{style:{visibility:"hidden",position:"fixed",left:"1px",top:"1px"}},body,"last"),_21f=_21c.create("span",{style:{position:"fixed",left:"0",top:"0"}},_21e,"last"),ret=geom.position(_21f).x!=geom.position(_21e).x;_21e.removeChild(_21f);body.removeChild(_21e);return ret;});var _220={getBox:function(doc){doc=doc||_21a.doc;var _221=(doc.compatMode=="BackCompat")?_21a.body(doc):doc.documentElement,_222=geom.docScroll(doc),w,h;if(has("touch")){var _223=_220.get(doc);w=_223.innerWidth||_221.clientWidth;h=_223.innerHeight||_221.clientHeight;}else{w=_221.clientWidth;h=_221.clientHeight;}return {l:_222.x,t:_222.y,w:w,h:h};},get:function(doc){if(has("ie")&&_220!==document.parentWindow){doc.parentWindow.execScript("document._parentWindow = window;","Javascript");var win=doc._parentWindow;doc._parentWindow=null;return win;}return doc.parentWindow||doc.defaultView;},scrollIntoView:function(node,pos){try{node=dom.byId(node);var doc=node.ownerDocument||_21a.doc,body=_21a.body(doc),html=doc.documentElement||body.parentNode,isIE=has("ie"),isWK=has("webkit");if(node==body||node==html){return;}if(!(has("mozilla")||isIE||isWK||has("opera"))&&("scrollIntoView" in node)){node.scrollIntoView(false);return;}var _224=doc.compatMode=="BackCompat",_225=Math.min(body.clientWidth||html.clientWidth,html.clientWidth||body.clientWidth),_226=Math.min(body.clientHeight||html.clientHeight,html.clientHeight||body.clientHeight),_227=(isWK||_224)?body:html,_228=pos||geom.position(node),el=node.parentNode,_229=function(el){return (isIE<=6||(isIE==7&&_224))?false:(has("position-fixed-support")&&(_21b.get(el,"position").toLowerCase()=="fixed"));};if(_229(node)){return;}while(el){if(el==body){el=_227;}var _22a=geom.position(el),_22b=_229(el),rtl=_21b.getComputedStyle(el).direction.toLowerCase()=="rtl";if(el==_227){_22a.w=_225;_22a.h=_226;if(_227==html&&isIE&&rtl){_22a.x+=_227.offsetWidth-_22a.w;}if(_22a.x<0||!isIE||isIE>=9){_22a.x=0;}if(_22a.y<0||!isIE||isIE>=9){_22a.y=0;}}else{var pb=geom.getPadBorderExtents(el);_22a.w-=pb.w;_22a.h-=pb.h;_22a.x+=pb.l;_22a.y+=pb.t;var _22c=el.clientWidth,_22d=_22a.w-_22c;if(_22c>0&&_22d>0){if(rtl&&has("rtl-adjust-position-for-verticalScrollBar")){_22a.x+=_22d;}_22a.w=_22c;}_22c=el.clientHeight;_22d=_22a.h-_22c;if(_22c>0&&_22d>0){_22a.h=_22c;}}if(_22b){if(_22a.y<0){_22a.h+=_22a.y;_22a.y=0;}if(_22a.x<0){_22a.w+=_22a.x;_22a.x=0;}if(_22a.y+_22a.h>_226){_22a.h=_226-_22a.y;}if(_22a.x+_22a.w>_225){_22a.w=_225-_22a.x;}}var l=_228.x-_22a.x,t=_228.y-_22a.y,r=l+_228.w-_22a.w,bot=t+_228.h-_22a.h;var s,old;if(r*l>0&&(!!el.scrollLeft||el==_227||el.scrollWidth>el.offsetHeight)){s=Math[l<0?"max":"min"](l,r);if(rtl&&((isIE==8&&!_224)||isIE>=9)){s=-s;}old=el.scrollLeft;el.scrollLeft+=s;s=el.scrollLeft-old;_228.x-=s;}if(bot*t>0&&(!!el.scrollTop||el==_227||el.scrollHeight>el.offsetHeight)){s=Math.ceil(Math[t<0?"max":"min"](t,bot));old=el.scrollTop;el.scrollTop+=s;s=el.scrollTop-old;_228.y-=s;}el=(el!=_227)&&!_22b&&el.parentNode;}}catch(error){console.error("scrollIntoView: "+error);node.scrollIntoView(false);}}};1&&lang.setObject("dojo.window",_220);return _220;});},"dijit/form/_FormValueWidget":function(){define(["dojo/_base/declare","dojo/sniff","./_FormWidget","./_FormValueMixin"],function(_22e,has,_22f,_230){return _22e("dijit.form._FormValueWidget",[_22f,_230],{_layoutHackIE7:function(){if(has("ie")==7){var _231=this.domNode;var _232=_231.parentNode;var _233=_231.firstChild||_231;var _234=_233.style.filter;var _235=this;while(_232&&_232.clientHeight==0){(function ping(){var _236=_235.connect(_232,"onscroll",function(){_235.disconnect(_236);_233.style.filter=(new Date()).getMilliseconds();_235.defer(function(){_233.style.filter=_234;});});})();_232=_232.parentNode;}}}});});},"dijit/_OnDijitClickMixin":function(){define(["dojo/on","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/has","./a11yclick"],function(on,_237,keys,_238,has,_239){var ret=_238("dijit._OnDijitClickMixin",null,{connect:function(obj,_23a,_23b){return this.inherited(arguments,[obj,_23a=="ondijitclick"?_239:_23a,_23b]);}});ret.a11yclick=_239;return ret;});},"dijit/a11yclick":function(){define(["dojo/keys","dojo/mouse","dojo/on","dojo/touch"],function(keys,_23c,on,_23d){function _23e(e){if((e.keyCode===keys.ENTER||e.keyCode===keys.SPACE)&&!/input|button|textarea/i.test(e.target.nodeName)){for(var node=e.target;node;node=node.parentNode){if(node.dojoClick){return true;}}}};var _23f;on(document,"keydown",function(e){if(_23e(e)){_23f=e.target;e.preventDefault();}else{_23f=null;}});on(document,"keyup",function(e){if(_23e(e)&&e.target==_23f){_23f=null;on.emit(e.target,"click",{cancelable:true,bubbles:true,ctrlKey:e.ctrlKey,shiftKey:e.shiftKey,metaKey:e.metaKey,altKey:e.altKey,_origType:e.type});}});var _240=function(node,_241){node.dojoClick=true;return on(node,"click",_241);};_240.click=_240;_240.press=function(node,_242){var _243=on(node,_23d.press,function(evt){if(evt.type=="mousedown"&&!_23c.isLeft(evt)){return;}_242(evt);}),_244=on(node,"keydown",function(evt){if(evt.keyCode===keys.ENTER||evt.keyCode===keys.SPACE){_242(evt);}});return {remove:function(){_243.remove();_244.remove();}};};_240.release=function(node,_245){var _246=on(node,_23d.release,function(evt){if(evt.type=="mouseup"&&!_23c.isLeft(evt)){return;}_245(evt);}),_247=on(node,"keyup",function(evt){if(evt.keyCode===keys.ENTER||evt.keyCode===keys.SPACE){_245(evt);}});return {remove:function(){_246.remove();_247.remove();}};};_240.move=_23d.move;return _240;});},"dijit/hccss":function(){define(["dojo/dom-class","dojo/hccss","dojo/domReady","dojo/_base/window"],function(_248,has,_249,win){_249(function(){if(has("highcontrast")){_248.add(win.body(),"dijit_a11y");}});return has;});},"dijit/_TemplatedMixin":function(){define(["dojo/cache","dojo/_base/declare","dojo/dom-construct","dojo/_base/lang","dojo/on","dojo/sniff","dojo/string","./_AttachMixin"],function(_24a,_24b,_24c,lang,on,has,_24d,_24e){var _24f=_24b("dijit._TemplatedMixin",_24e,{templateString:null,templatePath:null,_skipNodeCache:false,searchContainerNode:true,_stringRepl:function(tmpl){var _250=this.declaredClass,_251=this;return _24d.substitute(tmpl,this,function(_252,key){if(key.charAt(0)=="!"){_252=lang.getObject(key.substr(1),false,_251);}if(typeof _252=="undefined"){throw new Error(_250+" template:"+key);}if(_252==null){return "";}return key.charAt(0)=="!"?_252:_252.toString().replace(/"/g,"&quot;");},this);},buildRendering:function(){if(!this._rendered){if(!this.templateString){this.templateString=_24a(this.templatePath,{sanitize:true});}var _253=_24f.getCachedTemplate(this.templateString,this._skipNodeCache,this.ownerDocument);var node;if(lang.isString(_253)){node=_24c.toDom(this._stringRepl(_253),this.ownerDocument);if(node.nodeType!=1){throw new Error("Invalid template: "+_253);}}else{node=_253.cloneNode(true);}this.domNode=node;}this.inherited(arguments);if(!this._rendered){this._fillContent(this.srcNodeRef);}this._rendered=true;},_fillContent:function(_254){var dest=this.containerNode;if(_254&&dest){while(_254.hasChildNodes()){dest.appendChild(_254.firstChild);}}}});_24f._templateCache={};_24f.getCachedTemplate=function(_255,_256,doc){var _257=_24f._templateCache;var key=_255;var _258=_257[key];if(_258){try{if(!_258.ownerDocument||_258.ownerDocument==(doc||document)){return _258;}}catch(e){}_24c.destroy(_258);}_255=_24d.trim(_255);if(_256||_255.match(/\$\{([^\}]+)\}/g)){return (_257[key]=_255);}else{var node=_24c.toDom(_255,doc);if(node.nodeType!=1){throw new Error("Invalid template: "+_255);}return (_257[key]=node);}};if(has("ie")){on(window,"unload",function(){var _259=_24f._templateCache;for(var key in _259){var _25a=_259[key];if(typeof _25a=="object"){_24c.destroy(_25a);}delete _259[key];}});}return _24f;});},"dijit/selection":function(){define(["dojo/_base/array","dojo/dom","dojo/_base/lang","dojo/sniff","dojo/_base/window","dijit/focus"],function(_25b,dom,lang,has,_25c,_25d){var _25e=function(win){var doc=win.document;this.getType=function(){if(doc.getSelection){var _25f="text";var oSel;try{oSel=win.getSelection();}catch(e){}if(oSel&&oSel.rangeCount==1){var _260=oSel.getRangeAt(0);if((_260.startContainer==_260.endContainer)&&((_260.endOffset-_260.startOffset)==1)&&(_260.startContainer.nodeType!=3)){_25f="control";}}return _25f;}else{return doc.selection.type.toLowerCase();}};this.getSelectedText=function(){if(doc.getSelection){var _261=win.getSelection();return _261?_261.toString():"";}else{if(this.getType()=="control"){return null;}return doc.selection.createRange().text;}};this.getSelectedHtml=function(){if(doc.getSelection){var _262=win.getSelection();if(_262&&_262.rangeCount){var i;var html="";for(i=0;i<_262.rangeCount;i++){var frag=_262.getRangeAt(i).cloneContents();var div=doc.createElement("div");div.appendChild(frag);html+=div.innerHTML;}return html;}return null;}else{if(this.getType()=="control"){return null;}return doc.selection.createRange().htmlText;}};this.getSelectedElement=function(){if(this.getType()=="control"){if(doc.getSelection){var _263=win.getSelection();return _263.anchorNode.childNodes[_263.anchorOffset];}else{var _264=doc.selection.createRange();if(_264&&_264.item){return doc.selection.createRange().item(0);}}}return null;};this.getParentElement=function(){if(this.getType()=="control"){var p=this.getSelectedElement();if(p){return p.parentNode;}}else{if(doc.getSelection){var _265=doc.getSelection();if(_265){var node=_265.anchorNode;while(node&&(node.nodeType!=1)){node=node.parentNode;}return node;}}else{var r=doc.selection.createRange();r.collapse(true);return r.parentElement();}}return null;};this.hasAncestorElement=function(_266){return this.getAncestorElement.apply(this,arguments)!=null;};this.getAncestorElement=function(_267){var node=this.getSelectedElement()||this.getParentElement();return this.getParentOfType(node,arguments);};this.isTag=function(node,tags){if(node&&node.tagName){var _268=node.tagName.toLowerCase();for(var i=0;i<tags.length;i++){var _269=String(tags[i]).toLowerCase();if(_268==_269){return _269;}}}return "";};this.getParentOfType=function(node,tags){while(node){if(this.isTag(node,tags).length){return node;}node=node.parentNode;}return null;};this.collapse=function(_26a){if(doc.getSelection){var _26b=win.getSelection();if(_26b.removeAllRanges){if(_26a){_26b.collapseToStart();}else{_26b.collapseToEnd();}}else{_26b.collapse(_26a);}}else{var _26c=doc.selection.createRange();_26c.collapse(_26a);_26c.select();}};this.remove=function(){var sel=doc.selection;if(doc.getSelection){sel=win.getSelection();sel.deleteFromDocument();return sel;}else{if(sel.type.toLowerCase()!="none"){sel.clear();}return sel;}};this.selectElementChildren=function(_26d,_26e){var _26f;_26d=dom.byId(_26d);if(doc.getSelection){var _270=win.getSelection();if(has("opera")){if(_270.rangeCount){_26f=_270.getRangeAt(0);}else{_26f=doc.createRange();}_26f.setStart(_26d,0);_26f.setEnd(_26d,(_26d.nodeType==3)?_26d.length:_26d.childNodes.length);_270.addRange(_26f);}else{_270.selectAllChildren(_26d);}}else{_26f=_26d.ownerDocument.body.createTextRange();_26f.moveToElementText(_26d);if(!_26e){try{_26f.select();}catch(e){}}}};this.selectElement=function(_271,_272){var _273;_271=dom.byId(_271);if(doc.getSelection){var _274=doc.getSelection();_273=doc.createRange();if(_274.removeAllRanges){if(has("opera")){if(_274.getRangeAt(0)){_273=_274.getRangeAt(0);}}_273.selectNode(_271);_274.removeAllRanges();_274.addRange(_273);}}else{try{var tg=_271.tagName?_271.tagName.toLowerCase():"";if(tg==="img"||tg==="table"){_273=_25c.body(doc).createControlRange();}else{_273=_25c.body(doc).createRange();}_273.addElement(_271);if(!_272){_273.select();}}catch(e){this.selectElementChildren(_271,_272);}}};this.inSelection=function(node){if(node){var _275;var _276;if(doc.getSelection){var sel=win.getSelection();if(sel&&sel.rangeCount>0){_276=sel.getRangeAt(0);}if(_276&&_276.compareBoundaryPoints&&doc.createRange){try{_275=doc.createRange();_275.setStart(node,0);if(_276.compareBoundaryPoints(_276.START_TO_END,_275)===1){return true;}}catch(e){}}}else{_276=doc.selection.createRange();try{_275=node.ownerDocument.body.createTextRange();_275.moveToElementText(node);}catch(e2){}if(_276&&_275){if(_276.compareEndPoints("EndToStart",_275)===1){return true;}}}}return false;},this.getBookmark=function(){var bm,rg,tg,sel=doc.selection,cf=_25d.curNode;if(doc.getSelection){sel=win.getSelection();if(sel){if(sel.isCollapsed){tg=cf?cf.tagName:"";if(tg){tg=tg.toLowerCase();if(tg=="textarea"||(tg=="input"&&(!cf.type||cf.type.toLowerCase()=="text"))){sel={start:cf.selectionStart,end:cf.selectionEnd,node:cf,pRange:true};return {isCollapsed:(sel.end<=sel.start),mark:sel};}}bm={isCollapsed:true};if(sel.rangeCount){bm.mark=sel.getRangeAt(0).cloneRange();}}else{rg=sel.getRangeAt(0);bm={isCollapsed:false,mark:rg.cloneRange()};}}}else{if(sel){tg=cf?cf.tagName:"";tg=tg.toLowerCase();if(cf&&tg&&(tg=="button"||tg=="textarea"||tg=="input")){if(sel.type&&sel.type.toLowerCase()=="none"){return {isCollapsed:true,mark:null};}else{rg=sel.createRange();return {isCollapsed:rg.text&&rg.text.length?false:true,mark:{range:rg,pRange:true}};}}bm={};try{rg=sel.createRange();bm.isCollapsed=!(sel.type=="Text"?rg.htmlText.length:rg.length);}catch(e){bm.isCollapsed=true;return bm;}if(sel.type.toUpperCase()=="CONTROL"){if(rg.length){bm.mark=[];var i=0,len=rg.length;while(i<len){bm.mark.push(rg.item(i++));}}else{bm.isCollapsed=true;bm.mark=null;}}else{bm.mark=rg.getBookmark();}}else{console.warn("No idea how to store the current selection for this browser!");}}return bm;};this.moveToBookmark=function(_277){var mark=_277.mark;if(mark){if(doc.getSelection){var sel=win.getSelection();if(sel&&sel.removeAllRanges){if(mark.pRange){var n=mark.node;n.selectionStart=mark.start;n.selectionEnd=mark.end;}else{sel.removeAllRanges();sel.addRange(mark);}}else{console.warn("No idea how to restore selection for this browser!");}}else{if(doc.selection&&mark){var rg;if(mark.pRange){rg=mark.range;}else{if(lang.isArray(mark)){rg=doc.body.createControlRange();_25b.forEach(mark,function(n){rg.addElement(n);});}else{rg=doc.body.createTextRange();rg.moveToBookmark(mark);}}rg.select();}}}};this.isCollapsed=function(){return this.getBookmark().isCollapsed;};};var _278=new _25e(window);_278.SelectionManager=_25e;return _278;});},"dijit/form/_FormWidget":function(){define(["dojo/_base/declare","dojo/sniff","dojo/_base/kernel","dojo/ready","../_Widget","../_CssStateMixin","../_TemplatedMixin","./_FormWidgetMixin"],function(_279,has,_27a,_27b,_27c,_27d,_27e,_27f){if(has("dijit-legacy-requires")){_27b(0,function(){var _280=["dijit/form/_FormValueWidget"];require(_280);});}return _279("dijit.form._FormWidget",[_27c,_27e,_27d,_27f],{setDisabled:function(_281){_27a.deprecated("setDisabled("+_281+") is deprecated. Use set('disabled',"+_281+") instead.","","2.0");this.set("disabled",_281);},setValue:function(_282){_27a.deprecated("dijit.form._FormWidget:setValue("+_282+") is deprecated.  Use set('value',"+_282+") instead.","","2.0");this.set("value",_282);},getValue:function(){_27a.deprecated(this.declaredClass+"::getValue() is deprecated. Use get('value') instead.","","2.0");return this.get("value");},postMixInProperties:function(){this.nameAttrSetting=(this.name&&!has("msapp"))?("name=\""+this.name.replace(/"/g,"&quot;")+"\""):"";this.inherited(arguments);},_setTypeAttr:null});});},"dijit/_base/focus":function(){define(["dojo/_base/array","dojo/dom","dojo/_base/lang","dojo/topic","dojo/_base/window","../focus","../selection","../main"],function(_283,dom,lang,_284,win,_285,_286,_287){var _288={_curFocus:null,_prevFocus:null,isCollapsed:function(){return _287.getBookmark().isCollapsed;},getBookmark:function(){var sel=win.global==window?_286:new _286.SelectionManager(win.global);return sel.getBookmark();},moveToBookmark:function(_289){var sel=win.global==window?_286:new _286.SelectionManager(win.global);return sel.moveToBookmark(_289);},getFocus:function(menu,_28a){var node=!_285.curNode||(menu&&dom.isDescendant(_285.curNode,menu.domNode))?_287._prevFocus:_285.curNode;return {node:node,bookmark:node&&(node==_285.curNode)&&win.withGlobal(_28a||win.global,_287.getBookmark),openedForWindow:_28a};},_activeStack:[],registerIframe:function(_28b){return _285.registerIframe(_28b);},unregisterIframe:function(_28c){_28c&&_28c.remove();},registerWin:function(_28d,_28e){return _285.registerWin(_28d,_28e);},unregisterWin:function(_28f){_28f&&_28f.remove();}};_285.focus=function(_290){if(!_290){return;}var node="node" in _290?_290.node:_290,_291=_290.bookmark,_292=_290.openedForWindow,_293=_291?_291.isCollapsed:false;if(node){var _294=(node.tagName.toLowerCase()=="iframe")?node.contentWindow:node;if(_294&&_294.focus){try{_294.focus();}catch(e){}}_285._onFocusNode(node);}if(_291&&win.withGlobal(_292||win.global,_287.isCollapsed)&&!_293){if(_292){_292.focus();}try{win.withGlobal(_292||win.global,_287.moveToBookmark,null,[_291]);}catch(e2){}}};_285.watch("curNode",function(name,_295,_296){_287._curFocus=_296;_287._prevFocus=_295;if(_296){_284.publish("focusNode",_296);}});_285.watch("activeStack",function(name,_297,_298){_287._activeStack=_298;});_285.on("widget-blur",function(_299,by){_284.publish("widgetBlur",_299,by);});_285.on("widget-focus",function(_29a,by){_284.publish("widgetFocus",_29a,by);});lang.mixin(_287,_288);return _287;});},"dojo/parser":function(){define(["require","./_base/kernel","./_base/lang","./_base/array","./_base/config","./dom","./_base/window","./_base/url","./aspect","./promise/all","./date/stamp","./Deferred","./has","./query","./on","./ready"],function(_29b,dojo,_29c,_29d,_29e,dom,_29f,_2a0,_2a1,all,_2a2,_2a3,has,_2a4,don,_2a5){new Date("X");function _2a6(text){return eval("("+text+")");};var _2a7=0;_2a1.after(_29c,"extend",function(){_2a7++;},true);function _2a8(ctor){var map=ctor._nameCaseMap,_2a9=ctor.prototype;if(!map||map._extendCnt<_2a7){map=ctor._nameCaseMap={};for(var name in _2a9){if(name.charAt(0)==="_"){continue;}map[name.toLowerCase()]=name;}map._extendCnt=_2a7;}return map;};var _2aa={};function _2ab(_2ac,_2ad){var ts=_2ac.join();if(!_2aa[ts]){var _2ae=[];for(var i=0,l=_2ac.length;i<l;i++){var t=_2ac[i];_2ae[_2ae.length]=(_2aa[t]=_2aa[t]||(_29c.getObject(t)||(~t.indexOf("/")&&(_2ad?_2ad(t):_29b(t)))));}var ctor=_2ae.shift();_2aa[ts]=_2ae.length?(ctor.createSubclass?ctor.createSubclass(_2ae):ctor.extend.apply(ctor,_2ae)):ctor;}return _2aa[ts];};var _2af={_clearCache:function(){_2a7++;_2aa={};},_functionFromScript:function(_2b0,_2b1){var _2b2="",_2b3="",_2b4=(_2b0.getAttribute(_2b1+"args")||_2b0.getAttribute("args")),_2b5=_2b0.getAttribute("with");var _2b6=(_2b4||"").split(/\s*,\s*/);if(_2b5&&_2b5.length){_29d.forEach(_2b5.split(/\s*,\s*/),function(part){_2b2+="with("+part+"){";_2b3+="}";});}return new Function(_2b6,_2b2+_2b0.innerHTML+_2b3);},instantiate:function(_2b7,_2b8,_2b9){_2b8=_2b8||{};_2b9=_2b9||{};var _2ba=(_2b9.scope||dojo._scopeName)+"Type",_2bb="data-"+(_2b9.scope||dojo._scopeName)+"-",_2bc=_2bb+"type",_2bd=_2bb+"mixins";var list=[];_29d.forEach(_2b7,function(node){var type=_2ba in _2b8?_2b8[_2ba]:node.getAttribute(_2bc)||node.getAttribute(_2ba);if(type){var _2be=node.getAttribute(_2bd),_2bf=_2be?[type].concat(_2be.split(/\s*,\s*/)):[type];list.push({node:node,types:_2bf});}});return this._instantiate(list,_2b8,_2b9);},_instantiate:function(_2c0,_2c1,_2c2,_2c3){var _2c4=_29d.map(_2c0,function(obj){var ctor=obj.ctor||_2ab(obj.types,_2c2.contextRequire);if(!ctor){throw new Error("Unable to resolve constructor for: '"+obj.types.join()+"'");}return this.construct(ctor,obj.node,_2c1,_2c2,obj.scripts,obj.inherited);},this);function _2c5(_2c6){if(!_2c1._started&&!_2c2.noStart){_29d.forEach(_2c6,function(_2c7){if(typeof _2c7.startup==="function"&&!_2c7._started){_2c7.startup();}});}return _2c6;};if(_2c3){return all(_2c4).then(_2c5);}else{return _2c5(_2c4);}},construct:function(ctor,node,_2c8,_2c9,_2ca,_2cb){var _2cc=ctor&&ctor.prototype;_2c9=_2c9||{};var _2cd={};if(_2c9.defaults){_29c.mixin(_2cd,_2c9.defaults);}if(_2cb){_29c.mixin(_2cd,_2cb);}var _2ce;if(has("dom-attributes-explicit")){_2ce=node.attributes;}else{if(has("dom-attributes-specified-flag")){_2ce=_29d.filter(node.attributes,function(a){return a.specified;});}else{var _2cf=/^input$|^img$/i.test(node.nodeName)?node:node.cloneNode(false),_2d0=_2cf.outerHTML.replace(/=[^\s"']+|="[^"]*"|='[^']*'/g,"").replace(/^\s*<[a-zA-Z0-9]*\s*/,"").replace(/\s*>.*$/,"");_2ce=_29d.map(_2d0.split(/\s+/),function(name){var _2d1=name.toLowerCase();return {name:name,value:(node.nodeName=="LI"&&name=="value")||_2d1=="enctype"?node.getAttribute(_2d1):node.getAttributeNode(_2d1).value};});}}var _2d2=_2c9.scope||dojo._scopeName,_2d3="data-"+_2d2+"-",hash={};if(_2d2!=="dojo"){hash[_2d3+"props"]="data-dojo-props";hash[_2d3+"type"]="data-dojo-type";hash[_2d3+"mixins"]="data-dojo-mixins";hash[_2d2+"type"]="dojoType";hash[_2d3+"id"]="data-dojo-id";}var i=0,item,_2d4=[],_2d5,_2d6;while(item=_2ce[i++]){var name=item.name,_2d7=name.toLowerCase(),_2d8=item.value;switch(hash[_2d7]||_2d7){case "data-dojo-type":case "dojotype":case "data-dojo-mixins":break;case "data-dojo-props":_2d6=_2d8;break;case "data-dojo-id":case "jsid":_2d5=_2d8;break;case "data-dojo-attach-point":case "dojoattachpoint":_2cd.dojoAttachPoint=_2d8;break;case "data-dojo-attach-event":case "dojoattachevent":_2cd.dojoAttachEvent=_2d8;break;case "class":_2cd["class"]=node.className;break;case "style":_2cd["style"]=node.style&&node.style.cssText;break;default:if(!(name in _2cc)){var map=_2a8(ctor);name=map[_2d7]||name;}if(name in _2cc){switch(typeof _2cc[name]){case "string":_2cd[name]=_2d8;break;case "number":_2cd[name]=_2d8.length?Number(_2d8):NaN;break;case "boolean":_2cd[name]=_2d8.toLowerCase()!="false";break;case "function":if(_2d8===""||_2d8.search(/[^\w\.]+/i)!=-1){_2cd[name]=new Function(_2d8);}else{_2cd[name]=_29c.getObject(_2d8,false)||new Function(_2d8);}_2d4.push(name);break;default:var pVal=_2cc[name];_2cd[name]=(pVal&&"length" in pVal)?(_2d8?_2d8.split(/\s*,\s*/):[]):(pVal instanceof Date)?(_2d8==""?new Date(""):_2d8=="now"?new Date():_2a2.fromISOString(_2d8)):(pVal instanceof _2a0)?(dojo.baseUrl+_2d8):_2a6(_2d8);}}else{_2cd[name]=_2d8;}}}for(var j=0;j<_2d4.length;j++){var _2d9=_2d4[j].toLowerCase();node.removeAttribute(_2d9);node[_2d9]=null;}if(_2d6){try{_2d6=_2a6.call(_2c9.propsThis,"{"+_2d6+"}");_29c.mixin(_2cd,_2d6);}catch(e){throw new Error(e.toString()+" in data-dojo-props='"+_2d6+"'");}}_29c.mixin(_2cd,_2c8);if(!_2ca){_2ca=(ctor&&(ctor._noScript||_2cc._noScript)?[]:_2a4("> script[type^='dojo/']",node));}var _2da=[],_2db=[],_2dc=[],ons=[];if(_2ca){for(i=0;i<_2ca.length;i++){var _2dd=_2ca[i];node.removeChild(_2dd);var _2de=(_2dd.getAttribute(_2d3+"event")||_2dd.getAttribute("event")),prop=_2dd.getAttribute(_2d3+"prop"),_2df=_2dd.getAttribute(_2d3+"method"),_2e0=_2dd.getAttribute(_2d3+"advice"),_2e1=_2dd.getAttribute("type"),nf=this._functionFromScript(_2dd,_2d3);if(_2de){if(_2e1=="dojo/connect"){_2da.push({method:_2de,func:nf});}else{if(_2e1=="dojo/on"){ons.push({event:_2de,func:nf});}else{_2cd[_2de]=nf;}}}else{if(_2e1=="dojo/aspect"){_2da.push({method:_2df,advice:_2e0,func:nf});}else{if(_2e1=="dojo/watch"){_2dc.push({prop:prop,func:nf});}else{_2db.push(nf);}}}}}var _2e2=ctor.markupFactory||_2cc.markupFactory;var _2e3=_2e2?_2e2(_2cd,node,ctor):new ctor(_2cd,node);function _2e4(_2e5){if(_2d5){_29c.setObject(_2d5,_2e5);}for(i=0;i<_2da.length;i++){_2a1[_2da[i].advice||"after"](_2e5,_2da[i].method,_29c.hitch(_2e5,_2da[i].func),true);}for(i=0;i<_2db.length;i++){_2db[i].call(_2e5);}for(i=0;i<_2dc.length;i++){_2e5.watch(_2dc[i].prop,_2dc[i].func);}for(i=0;i<ons.length;i++){don(_2e5,ons[i].event,ons[i].func);}return _2e5;};if(_2e3.then){return _2e3.then(_2e4);}else{return _2e4(_2e3);}},scan:function(root,_2e6){var list=[],mids=[],_2e7={};var _2e8=(_2e6.scope||dojo._scopeName)+"Type",_2e9="data-"+(_2e6.scope||dojo._scopeName)+"-",_2ea=_2e9+"type",_2eb=_2e9+"textdir",_2ec=_2e9+"mixins";var node=root.firstChild;var _2ed=_2e6.inherited;if(!_2ed){function _2ee(node,attr){return (node.getAttribute&&node.getAttribute(attr))||(node.parentNode&&_2ee(node.parentNode,attr));};_2ed={dir:_2ee(root,"dir"),lang:_2ee(root,"lang"),textDir:_2ee(root,_2eb)};for(var key in _2ed){if(!_2ed[key]){delete _2ed[key];}}}var _2ef={inherited:_2ed};var _2f0;var _2f1;function _2f2(_2f3){if(!_2f3.inherited){_2f3.inherited={};var node=_2f3.node,_2f4=_2f2(_2f3.parent);var _2f5={dir:node.getAttribute("dir")||_2f4.dir,lang:node.getAttribute("lang")||_2f4.lang,textDir:node.getAttribute(_2eb)||_2f4.textDir};for(var key in _2f5){if(_2f5[key]){_2f3.inherited[key]=_2f5[key];}}}return _2f3.inherited;};while(true){if(!node){if(!_2ef||!_2ef.node){break;}node=_2ef.node.nextSibling;_2f1=false;_2ef=_2ef.parent;_2f0=_2ef.scripts;continue;}if(node.nodeType!=1){node=node.nextSibling;continue;}if(_2f0&&node.nodeName.toLowerCase()=="script"){type=node.getAttribute("type");if(type&&/^dojo\/\w/i.test(type)){_2f0.push(node);}node=node.nextSibling;continue;}if(_2f1){node=node.nextSibling;continue;}var type=node.getAttribute(_2ea)||node.getAttribute(_2e8);var _2f6=node.firstChild;if(!type&&(!_2f6||(_2f6.nodeType==3&&!_2f6.nextSibling))){node=node.nextSibling;continue;}var _2f7;var ctor=null;if(type){var _2f8=node.getAttribute(_2ec),_2f9=_2f8?[type].concat(_2f8.split(/\s*,\s*/)):[type];try{ctor=_2ab(_2f9,_2e6.contextRequire);}catch(e){}if(!ctor){_29d.forEach(_2f9,function(t){if(~t.indexOf("/")&&!_2e7[t]){_2e7[t]=true;mids[mids.length]=t;}});}var _2fa=ctor&&!ctor.prototype._noScript?[]:null;_2f7={types:_2f9,ctor:ctor,parent:_2ef,node:node,scripts:_2fa};_2f7.inherited=_2f2(_2f7);list.push(_2f7);}else{_2f7={node:node,scripts:_2f0,parent:_2ef};}_2f0=_2fa;_2f1=node.stopParser||(ctor&&ctor.prototype.stopParser&&!(_2e6.template));_2ef=_2f7;node=_2f6;}var d=new _2a3();if(mids.length){if(has("dojo-debug-messages")){console.warn("WARNING: Modules being Auto-Required: "+mids.join(", "));}var r=_2e6.contextRequire||_29b;r(mids,function(){d.resolve(_29d.filter(list,function(_2fb){if(!_2fb.ctor){try{_2fb.ctor=_2ab(_2fb.types,_2e6.contextRequire);}catch(e){}}var _2fc=_2fb.parent;while(_2fc&&!_2fc.types){_2fc=_2fc.parent;}var _2fd=_2fb.ctor&&_2fb.ctor.prototype;_2fb.instantiateChildren=!(_2fd&&_2fd.stopParser&&!(_2e6.template));_2fb.instantiate=!_2fc||(_2fc.instantiate&&_2fc.instantiateChildren);return _2fb.instantiate;}));});}else{d.resolve(list);}return d.promise;},_require:function(_2fe,_2ff){var hash=_2a6("{"+_2fe.innerHTML+"}"),vars=[],mids=[],d=new _2a3();var _300=(_2ff&&_2ff.contextRequire)||_29b;for(var name in hash){vars.push(name);mids.push(hash[name]);}_300(mids,function(){for(var i=0;i<vars.length;i++){_29c.setObject(vars[i],arguments[i]);}d.resolve(arguments);});return d.promise;},_scanAmd:function(root,_301){var _302=new _2a3(),_303=_302.promise;_302.resolve(true);var self=this;_2a4("script[type='dojo/require']",root).forEach(function(node){_303=_303.then(function(){return self._require(node,_301);});node.parentNode.removeChild(node);});return _303;},parse:function(_304,_305){var root;if(!_305&&_304&&_304.rootNode){_305=_304;root=_305.rootNode;}else{if(_304&&_29c.isObject(_304)&&!("nodeType" in _304)){_305=_304;}else{root=_304;}}root=root?dom.byId(root):_29f.body();_305=_305||{};var _306=_305.template?{template:true}:{},_307=[],self=this;var p=this._scanAmd(root,_305).then(function(){return self.scan(root,_305);}).then(function(_308){return self._instantiate(_308,_306,_305,true);}).then(function(_309){return _307=_307.concat(_309);}).otherwise(function(e){console.error("dojo/parser::parse() error",e);throw e;});_29c.mixin(_307,p);return _307;}};if(1){dojo.parser=_2af;}if(_29e.parseOnLoad){_2a5(100,_2af,"parse");}return _2af;});},"dijit/layout/_LayoutWidget":function(){define(["dojo/_base/lang","../_Widget","../_Container","../_Contained","../Viewport","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style"],function(lang,_30a,_30b,_30c,_30d,_30e,_30f,_310,_311){return _30e("dijit.layout._LayoutWidget",[_30a,_30b,_30c],{baseClass:"dijitLayoutContainer",isLayoutContainer:true,buildRendering:function(){this.inherited(arguments);_30f.add(this.domNode,"dijitContainer");},startup:function(){if(this._started){return;}this.inherited(arguments);var _312=this.getParent&&this.getParent();if(!(_312&&_312.isLayoutContainer)){this.resize();this.own(_30d.on("resize",lang.hitch(this,"resize")));}},resize:function(_313,_314){var node=this.domNode;if(_313){_310.setMarginBox(node,_313);}var mb=_314||{};lang.mixin(mb,_313||{});if(!("h" in mb)||!("w" in mb)){mb=lang.mixin(_310.getMarginBox(node),mb);}var cs=_311.getComputedStyle(node);var me=_310.getMarginExtents(node,cs);var be=_310.getBorderExtents(node,cs);var bb=(this._borderBox={w:mb.w-(me.w+be.w),h:mb.h-(me.h+be.h)});var pe=_310.getPadExtents(node,cs);this._contentBox={l:_311.toPixelValue(node,cs.paddingLeft),t:_311.toPixelValue(node,cs.paddingTop),w:bb.w-pe.w,h:bb.h-pe.h};this.layout();},layout:function(){},_setupChild:function(_315){var cls=this.baseClass+"-child "+(_315.baseClass?this.baseClass+"-"+_315.baseClass:"");_30f.add(_315.domNode,cls);},addChild:function(_316,_317){this.inherited(arguments);if(this._started){this._setupChild(_316);}},removeChild:function(_318){var cls=this.baseClass+"-child"+(_318.baseClass?" "+this.baseClass+"-"+_318.baseClass:"");_30f.remove(_318.domNode,cls);this.inherited(arguments);}});});},"dijit/_Widget":function(){define(["dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/query","dojo/ready","./registry","./_WidgetBase","./_OnDijitClickMixin","./_FocusMixin","dojo/uacss","./hccss"],function(_319,_31a,_31b,_31c,has,_31d,lang,_31e,_31f,_320,_321,_322,_323){function _324(){};function _325(_326){return function(obj,_327,_328,_329){if(obj&&typeof _327=="string"&&obj[_327]==_324){return obj.on(_327.substring(2).toLowerCase(),lang.hitch(_328,_329));}return _326.apply(_31b,arguments);};};_319.around(_31b,"connect",_325);if(_31d.connect){_319.around(_31d,"connect",_325);}var _32a=_31c("dijit._Widget",[_321,_322,_323],{onClick:_324,onDblClick:_324,onKeyDown:_324,onKeyPress:_324,onKeyUp:_324,onMouseDown:_324,onMouseMove:_324,onMouseOut:_324,onMouseOver:_324,onMouseLeave:_324,onMouseEnter:_324,onMouseUp:_324,constructor:function(_32b){this._toConnect={};for(var name in _32b){if(this[name]===_324){this._toConnect[name.replace(/^on/,"").toLowerCase()]=_32b[name];delete _32b[name];}}},postCreate:function(){this.inherited(arguments);for(var name in this._toConnect){this.on(name,this._toConnect[name]);}delete this._toConnect;},on:function(type,func){if(this[this._onMap(type)]===_324){return _31b.connect(this.domNode,type.toLowerCase(),this,func);}return this.inherited(arguments);},_setFocusedAttr:function(val){this._focused=val;this._set("focused",val);},setAttribute:function(attr,_32c){_31d.deprecated(this.declaredClass+"::setAttribute(attr, value) is deprecated. Use set() instead.","","2.0");this.set(attr,_32c);},attr:function(name,_32d){if(_31a.isDebug){var _32e=arguments.callee._ach||(arguments.callee._ach={}),_32f=(arguments.callee.caller||"unknown caller").toString();if(!_32e[_32f]){_31d.deprecated(this.declaredClass+"::attr() is deprecated. Use get() or set() instead, called from "+_32f,"","2.0");_32e[_32f]=true;}}var args=arguments.length;if(args>=2||typeof name==="object"){return this.set.apply(this,arguments);}else{return this.get(name);}},getDescendants:function(){_31d.deprecated(this.declaredClass+"::getDescendants() is deprecated. Use getChildren() instead.","","2.0");return this.containerNode?_31e("[widgetId]",this.containerNode).map(_320.byNode):[];},_onShow:function(){this.onShow();},onShow:function(){},onHide:function(){},onClose:function(){return true;}});if(has("dijit-legacy-requires")){_31f(0,function(){var _330=["dijit/_base"];require(_330);});}return _32a;});},"dijit/_FocusMixin":function(){define(["./focus","./_WidgetBase","dojo/_base/declare","dojo/_base/lang"],function(_331,_332,_333,lang){lang.extend(_332,{focused:false,onFocus:function(){},onBlur:function(){},_onFocus:function(){this.onFocus();},_onBlur:function(){this.onBlur();}});return _333("dijit._FocusMixin",null,{_focusManager:_331});});},"dijit/focus":function(){define(["dojo/aspect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/Evented","dojo/_base/lang","dojo/on","dojo/domReady","dojo/sniff","dojo/Stateful","dojo/_base/window","dojo/window","./a11y","./registry","./main"],function(_334,_335,dom,_336,_337,_338,lang,on,_339,has,_33a,win,_33b,a11y,_33c,_33d){var _33e;var _33f=_335([_33a,_338],{curNode:null,activeStack:[],constructor:function(){var _340=lang.hitch(this,function(node){if(dom.isDescendant(this.curNode,node)){this.set("curNode",null);}if(dom.isDescendant(this.prevNode,node)){this.set("prevNode",null);}});_334.before(_337,"empty",_340);_334.before(_337,"destroy",_340);},registerIframe:function(_341){return this.registerWin(_341.contentWindow,_341);},registerWin:function(_342,_343){var _344=this,body=_342.document&&_342.document.body;if(body){var mdh=on(_342.document,"mousedown, touchstart",function(evt){_344._justMouseDowned=true;setTimeout(function(){_344._justMouseDowned=false;},0);if(evt&&evt.target&&evt.target.parentNode==null){return;}_344._onTouchNode(_343||evt.target,"mouse");});var fih=on(body,"focusin",function(evt){_33e=(new Date()).getTime();if(!evt.target.tagName){return;}var tag=evt.target.tagName.toLowerCase();if(tag=="#document"||tag=="body"){return;}if(a11y.isTabNavigable(evt.target)){_344._onFocusNode(_343||evt.target);}else{_344._onTouchNode(_343||evt.target);}});var foh=on(body,"focusout",function(evt){if((new Date()).getTime()<_33e+100){return;}_344._onBlurNode(_343||evt.target);});return {remove:function(){mdh.remove();fih.remove();foh.remove();mdh=fih=foh=null;body=null;}};}},_onBlurNode:function(node){if(this._clearFocusTimer){clearTimeout(this._clearFocusTimer);}this._clearFocusTimer=setTimeout(lang.hitch(this,function(){this.set("prevNode",this.curNode);this.set("curNode",null);}),0);if(this._justMouseDowned){return;}if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);}this._clearActiveWidgetsTimer=setTimeout(lang.hitch(this,function(){delete this._clearActiveWidgetsTimer;this._setStack([]);}),0);},_onTouchNode:function(node,by){if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);delete this._clearActiveWidgetsTimer;}var _345=[];try{while(node){var _346=_336.get(node,"dijitPopupParent");if(_346){node=_33c.byId(_346).domNode;}else{if(node.tagName&&node.tagName.toLowerCase()=="body"){if(node===win.body()){break;}node=_33b.get(node.ownerDocument).frameElement;}else{var id=node.getAttribute&&node.getAttribute("widgetId"),_347=id&&_33c.byId(id);if(_347&&!(by=="mouse"&&_347.get("disabled"))){_345.unshift(id);}node=node.parentNode;}}}}catch(e){}this._setStack(_345,by);},_onFocusNode:function(node){if(!node){return;}if(node.nodeType==9){return;}if(this._clearFocusTimer){clearTimeout(this._clearFocusTimer);delete this._clearFocusTimer;}this._onTouchNode(node);if(node==this.curNode){return;}this.set("prevNode",this.curNode);this.set("curNode",node);},_setStack:function(_348,by){var _349=this.activeStack,_34a=_349.length-1,_34b=_348.length-1;if(_348[_34b]==_349[_34a]){return;}this.set("activeStack",_348);var _34c,i;for(i=_34a;i>=0&&_349[i]!=_348[i];i--){_34c=_33c.byId(_349[i]);if(_34c){_34c._hasBeenBlurred=true;_34c.set("focused",false);if(_34c._focusManager==this){_34c._onBlur(by);}this.emit("widget-blur",_34c,by);}}for(i++;i<=_34b;i++){_34c=_33c.byId(_348[i]);if(_34c){_34c.set("focused",true);if(_34c._focusManager==this){_34c._onFocus(by);}this.emit("widget-focus",_34c,by);}}},focus:function(node){if(node){try{node.focus();}catch(e){}}}});var _34d=new _33f();_339(function(){var _34e=_34d.registerWin(_33b.get(document));if(has("ie")){on(window,"unload",function(){if(_34e){_34e.remove();_34e=null;}});}});_33d.focus=function(node){_34d.focus(node);};for(var attr in _34d){if(!/^_/.test(attr)){_33d.focus[attr]=typeof _34d[attr]=="function"?lang.hitch(_34d,attr):_34d[attr];}}_34d.watch(function(attr,_34f,_350){_33d.focus[attr]=_350;});return _34d;});},"dijit/_Contained":function(){define(["dojo/_base/declare","./registry"],function(_351,_352){return _351("dijit._Contained",null,{_getSibling:function(_353){var node=this.domNode;do{node=node[_353+"Sibling"];}while(node&&node.nodeType!=1);return node&&_352.byNode(node);},getPreviousSibling:function(){return this._getSibling("previous");},getNextSibling:function(){return this._getSibling("next");},getIndexInParent:function(){var p=this.getParent();if(!p||!p.getIndexOfChild){return -1;}return p.getIndexOfChild(this);}});});},"dijit/_base/scroll":function(){define(["dojo/window","../main"],function(_354,_355){_355.scrollIntoView=function(node,pos){_354.scrollIntoView(node,pos);};});},"dijit/main":function(){define(["dojo/_base/kernel"],function(dojo){return dojo.dijit;});},"dijit/Destroyable":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/declare"],function(_356,_357,_358){return _358("dijit.Destroyable",null,{destroy:function(_359){this._destroyed=true;},own:function(){_356.forEach(arguments,function(_35a){var _35b="destroyRecursive" in _35a?"destroyRecursive":"destroy" in _35a?"destroy":"remove";var odh=_357.before(this,"destroy",function(_35c){_35a[_35b](_35c);});var hdh=_357.after(_35a,_35b,function(){odh.remove();hdh.remove();},true);},this);return arguments;}});});},"dojo/cache":function(){define(["./_base/kernel","./text"],function(dojo){return dojo.cache;});},"dijit/_base/window":function(){define(["dojo/window","../main"],function(_35d,_35e){_35e.getDocumentWindow=function(doc){return _35d.get(doc);};});},"dijit/_base/typematic":function(){define(["../typematic"],function(){});},"dijit/_base/popup":function(){define(["dojo/dom-class","dojo/_base/window","../popup","../BackgroundIframe"],function(_35f,win,_360){var _361=_360._createWrapper;_360._createWrapper=function(_362){if(!_362.declaredClass){_362={_popupWrapper:(_362.parentNode&&_35f.contains(_362.parentNode,"dijitPopup"))?_362.parentNode:null,domNode:_362,destroy:function(){},ownerDocument:_362.ownerDocument,ownerDocumentBody:win.body(_362.ownerDocument)};}return _361.call(this,_362);};var _363=_360.open;_360.open=function(args){if(args.orient&&typeof args.orient!="string"&&!("length" in args.orient)){var ary=[];for(var key in args.orient){ary.push({aroundCorner:key,corner:args.orient[key]});}args.orient=ary;}return _363.call(this,args);};return _360;});},"dijit/_Container":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-construct","dojo/_base/kernel"],function(_364,_365,_366,_367){return _365("dijit._Container",null,{buildRendering:function(){this.inherited(arguments);if(!this.containerNode){this.containerNode=this.domNode;}},addChild:function(_368,_369){var _36a=this.containerNode;if(_369>0){_36a=_36a.firstChild;while(_369>0){if(_36a.nodeType==1){_369--;}_36a=_36a.nextSibling;}if(_36a){_369="before";}else{_36a=this.containerNode;_369="last";}}_366.place(_368.domNode,_36a,_369);if(this._started&&!_368._started){_368.startup();}},removeChild:function(_36b){if(typeof _36b=="number"){_36b=this.getChildren()[_36b];}if(_36b){var node=_36b.domNode;if(node&&node.parentNode){node.parentNode.removeChild(node);}}},hasChildren:function(){return this.getChildren().length>0;},_getSiblingOfChild:function(_36c,dir){_367.deprecated(this.declaredClass+"::_getSiblingOfChild() is deprecated. Use _KeyNavMixin::_getNext() instead.","","2.0");var _36d=this.getChildren(),idx=_364.indexOf(_36d,_36c);return _36d[idx+dir];},getIndexOfChild:function(_36e){return _364.indexOf(this.getChildren(),_36e);}});});}}});define("dijit/dijit",["./main","./_base","dojo/parser","./_Widget","./_TemplatedMixin","./_Container","./layout/_LayoutWidget","./form/_FormWidget","./form/_FormValueWidget"],function(_36f){return _36f;});