<?php
/*
 *
 */


$step=isset($_POST['step']) ? $_POST['step'] : (isset($_GET['step']) ? $_GET['step'] : NULL);

if(!isset($step)){
		echo "<h2>Etape 4 : Association des groupes aux structures de Sconet</h2>";

		echo "<i>Note : GEPI va apprendre au fur et à mesure des classes mémorisées.
			La reconnaissance automatique, presque inopérante pour les premières classes, devrait s'améliorer pour les suivantes. Soyez tout de même attentifs aux erreurs éventuelles.</i>";

        echo "<p>Cette page permet d'associer les groupes avec les codes Sconet correspondants.<br />\n";
        echo "</p>\n";

        echo "<form enctype='multipart/form-data' action='".$_SERVER['PHP_SELF']."?action=mefgroupes&annee=".$annee."' method='post'>\n";
        echo add_token_field();
        echo "<p>Veuillez fournir le fichier Nomenclature.xml <br />\n";
        echo "<input type=\"file\" size=\"65\" name=\"structures_xml_file\" /><br />\n";
        if ($gepiSettings['unzipped_max_filesize']>=0) {
                echo "<p style=\"font-size:small; color: red;\"><i>REMARQUE&nbsp;:</i> Vous pouvez fournir à Gepi le fichier compressé issu directement de SCONET. (Ex : ExportXML_Nomenclature.zip)</p>";
        }
        echo "<input type='hidden' name='step' value='0' />\n";
        echo "<input type='hidden' name='is_posted' value='yes' />\n";
        echo "<p><input type='submit' value='Valider' /></p>\n";
        echo "</form>\n";
}
else{
        $post_max_size=ini_get('post_max_size');
        $upload_max_filesize=ini_get('upload_max_filesize');
        $max_execution_time=ini_get('max_execution_time');
        $memory_limit=ini_get('memory_limit');
		check_token();
		echo "<h2>Etape 4 : Association des groupes aux structures de Sconet</h2>";

		echo "<i>Note : GEPI va apprendre au fur et à mesure des classes mémorisées.
		La reconnaissance automatique, presque inopérante pour les premières classes, devrait s'améliorer pour les suivantes. Soyez tout de même attentifs aux erreurs éventuelles.</i>";

        if($step==0){
                $structxml_file = isset($_FILES["structures_xml_file"]) ? $_FILES["structures_xml_file"] : NULL;
                if(!is_uploaded_file($structxml_file['tmp_name']) ) {
                        echo "<p style='color:red;'>L'upload d'un fichier a échoué.</p>\n";

                        echo "<p>Les variables du php.ini peuvent peut-être expliquer le problème:<br />\n";
                        echo "post_max_size=$post_max_size<br />\n";
                        echo "upload_max_filesize=$upload_max_filesize<br />\n";
                        echo "</p>\n";

                        // Il ne faut pas aller plus loin...
                        // SITUATION A GERER
                        require("../../lib/footer.inc.php");
                        die();
                }
                else{
                        if(!file_exists($structxml_file['tmp_name'])){
                                echo "<p style='color:red;'>Le fichier aurait été uploadé... mais ne serait pas présent/conservé.</p>\n";

                                echo "<p>Les variables du php.ini peuvent peut-être expliquer le problème:<br />\n";
                                echo "post_max_size=$post_max_size<br />\n";
                                echo "upload_max_filesize=$upload_max_filesize<br />\n";
                                echo "et le volume de ".$structxml_file['name']." serait<br />\n";
                                echo "\$structxml_file['size']=".volume_human($structxml_file['size'])."<br />\n";
                                echo "</p>\n";
                                // Il ne faut pas aller plus loin...
                                // SITUATION A GERER
                                require("../lib/footer.inc.php");
                                die();
                        }
                        echo "<p>Le fichier a été transféré sur le serveur.</p>\n";
                        $source_file=$structxml_file['tmp_name'];
                        $dest_file="../../temp/".$tempdir."/nomenclature.xml";
                        $res_copy=copy("$source_file" , "$dest_file");
                        
                        //===============================================================
                        // ajout prise en compte des fichiers ZIP: Marc Leygnac

                        $unzipped_max_filesize=getSettingValue('unzipped_max_filesize')*1024*1024;
                        // $unzipped_max_filesize = 0    pas de limite de taille pour les fichiers extraits
                        // $unzipped_max_filesize < 0    extraction zip désactivée
                        if($unzipped_max_filesize>=0) {
                                $fichier_emis=$structxml_file['name'];
                                $extension_fichier_emis=strtolower(strrchr($fichier_emis,"."));
                                if (($extension_fichier_emis==".zip")||($structxml_file['type']=="application/zip"))
                                        {
                                        require_once('../../lib/pclzip.lib.php');
                                        $archive = new PclZip($dest_file);

                                        if (($list_file_zip = $archive->listContent()) == 0) {
                                                echo "<p style='color:red;'>Erreur : ".$archive->errorInfo(true)."</p>\n";
                                                require("../../lib/footer.inc.php");
                                                die();
                                        }

                                        if(sizeof($list_file_zip)!=1) {
                                                echo "<p style='color:red;'>Erreur : L'archive contient plus d'un fichier.</p>\n";
                                                require("../../lib/footer.inc.php");
                                                die();
                                        }
                                        if(($list_file_zip[0]['size']>$unzipped_max_filesize)&&($unzipped_max_filesize>0)) {
                                                echo "<p style='color:red;'>Erreur : La taille du fichier extrait (<i>".$list_file_zip[0]['size']." octets</i>) dépasse la limite paramétrée (<i>$unzipped_max_filesize octets</i>).</p>\n";
                                                require("../../lib/footer.inc.php");
                                                die();
                                        }
                                        $res_extract=$archive->extract(PCLZIP_OPT_PATH, "../../temp/".$tempdir."/apb/");
                                        if ($res_extract != 0) {
                                                echo "<p>Le fichier uploadé a été dézippé.</p>\n";
                                                $fichier_extrait=$res_extract[0]['filename'];
                                                unlink("$dest_file"); // Pour Wamp...
                                                $res_copy=rename("$fichier_extrait" , "$dest_file");
                                        }
                                        else {
                                                echo "<p style='color:red'>Echec de l'extraction de l'archive ZIP.</p>\n";
                                                require("../../lib/footer.inc.php");
                                                die();
                                        }
                                }
                        }
                        if(!$res_copy){
                                echo "<p style='color:red;'>La copie du fichier vers le dossier temporaire a échoué.<br />Vérifiez que l'utilisateur ou le groupe apache ou www-data a accès au dossier temp/$tempdir</p>\n";
                                // Il ne faut pas aller plus loin...
                                // SITUATION A GERER
                                require("../../lib/footer.inc.php");
                                die();
                        }
                        //fin  ajout prise en compte des fichiers ZIP
                        //===============================================================

                        if(!$res_copy){
                                echo "<p style='color:red;'>La copie du fichier vers le dossier temporaire a échoué.<br />Vérifiez que l'utilisateur ou le groupe apache ou www-data a accès au dossier temp/$tempdir</p>\n";
                                // Il ne faut pas aller plus loin...
                                // SITUATION A GERER
                                require("../lib/footer.inc.php");
                                die();
                        }
                        else{
                          echo "<p>La copie du fichier vers le dossier temporaire a réussi.</p>\n";
                          echo "<h3>GEPI va essayer d'associer chaque groupe de GEPI à une discipline de Sconet</h3>";
                          $xml = new DomDocument();
                          $xml->load("../../temp/".$tempdir."/nomenclature.xml");
                          // Puisque on a Nomenclature.xml sous la main, on va récupérer les libelles courts des mefs
                          $data_mefs=array();
                          $mefs=$xml->getElementsByTagName('MEF');
                          foreach ($mefs as $mef) {
                            $code_mef = $mef->getAttribute("CODE_MEF");
                            $libelle = $mef->getElementsByTagName("FORMATION")->item(0)->nodeValue;
                            $data_mefs[$code_mef]=$libelle;
                          }

                          foreach (array_keys($data_mefs) as $code) {
                            $libelle=$data_mefs[$code];
                            if (mysqli_num_rows(mysqli_query($GLOBALS["mysqli"], "SELECT libelle_court FROM plugin_archAPB_mef WHERE code_mef ='".$code."'"))>0) {
                              $rec_mef = mysqli_query($GLOBALS["mysqli"], "UPDATE plugin_archAPB_mef SET libelle_court = '".$libelle."'
                                                      WHERE code_mef = '".$code."'");
                            } else {
                              $rec_mef = mysqli_query($GLOBALS["mysqli"], "INSERT INTO plugin_archAPB_mef SET libelle_court = '".$libelle."',
                                                      code_mef = '".$code."'");
                            }
                          }

                           // On va commencer par récupérer les classes
                          //$req=mysql_query("SELECT id, nom_court, id_structure_sconet FROM  `plugin_archAPB_classes` WHERE annee = ".$annee." AND niveau !='' ORDER BY nom_court");
                          $req=mysqli_query($GLOBALS["mysqli"], "SELECT id,nom_court, id_structure_sconet FROM plugin_archAPB_classes WHERE annee=".$annee." AND traitee=0 AND niveau !='' ORDER BY nom_court");
                          $classesatraiter="";
                          while ($classe = mysqli_fetch_object($req)) {
                            if ($classesatraiter=="") {
                              $classesatraiter.=$classe->id;
                            }
                            else {
                              $classesatraiter.=",";
                              $classesatraiter.=$classe->id;
                            }
                          }

                          echo "<form enctype=\"multipart/form-data\" name= \"formulaire\" action=\"".$_SERVER['PHP_SELF']."?action=mefgroupes&annee=".$annee."\" method=\"post\">\n";
                          echo add_token_field();
                          echo "<input type='hidden' name='step' value='1' />\n";
                          echo "<input type='hidden' name='do' value='asso' />\n";
                          echo "<input type='hidden' name='is_posted' value='yes' />\n";
                          echo "<input type='hidden' name='classesid' value='".$classesatraiter."' />\n";
                          echo "<p><input type='submit' value='Commencer' /></p>\n";
                          echo "</form>\n";
//                          echo "<script type='text/javascript'>
//                                setTimeout('document.formulaire.submit();', 5000);
//                                </script>\n";

                        }
                }
        } // Fin du $step=0
        elseif ($step==1) { // début du step 1
          $do=isset($_POST['do']) ? $_POST['do'] : (isset($_GET['do']) ? $_GET['do'] : NULL);
          if (!isset($do)) {
            echo "<p>Aucune action n'est définie - Erreur</p>";
            die();
          }
          $classesid=isset($_POST['classesid']) ? $_POST['classesid'] : (isset($_GET['classesid']) ? $_GET['classesid'] : NULL);
          $classesidfait=isset($_POST['classesidfait']) ? $_POST['classesidfait'] : (isset($_GET['classesidfait']) ? $_GET['classesidfait'] : NULL);
          if ($classesid=="") {
            echo "<p>Fin de l'etape 4<p>";
            echo "<p>L'enregistrement des données s'est fait avec succès pour l'ensemble des classes</p>";
            echo "<p>Vous pouvez passer à l'étape suivante : <a href=\"index.php?action=arch&annee=".$annee.add_token_in_url()."\">Sauvegarder les notes</a> </p>";
             // pour pouvoir sauter à l'étape où on s'était arrêté
            echo "<p>Vous pouvez aussi revenir sur une classe déjà traitée :</p>";
            $classestraitees = array();
            $reqclt=mysqli_query($GLOBALS["mysqli"], "SELECT id,nom_court FROM plugin_archAPB_classes WHERE annee=".$annee." AND traitee=1 AND niveau !='' ORDER BY nom_court");
            while ($cl=mysqli_fetch_object($reqclt)) {
              $classestraitees[]=$cl->id;
            }
            echo "<p> Classes déjà traitées :";
            $classesidtmp=$classestraitees;
            $ik=0;
            foreach ($classestraitees as $clid) {
              $req=mysqli_query($GLOBALS["mysqli"], "SELECT nom_court, id_structure_sconet FROM  `plugin_archAPB_classes` WHERE annee = ".$annee." AND niveau !='' AND id='".$clid."'");
              $classe = mysqli_fetch_object($req);
              $cltmp=$classesidtmp[$ik];
              echo "<a href=\"".$_SERVER['PHP_SELF']."?action=mefgroupes&annee=".$annee."&step=1&do=asso&classesid=".$cltmp.add_token_in_url()."\">".$classe->nom_court."</a> - ";
              unset ($classesidtmp[$ik]);
              $ik++;
            }
            echo "</p>";
            die();
          }
          $classesid=explode(",",$classesid);
          if (!isset($classesid)) {
            echo "<p>Aucune classe à traiter</p>";
            die();
          }

          
          if ($do=="asso") {
            
          //- Association d'une classe aux nomenclatures
          // On va commencer par récupérer les classes
                          $req=mysqli_query($GLOBALS["mysqli"], "SELECT nom_court, id_structure_sconet FROM  `plugin_archAPB_classes` WHERE annee = ".$annee." AND niveau !='' AND id='".$classesid[0]."'");
                          $classes=array();
                          while ($classe = mysqli_fetch_object($req)) {
                            $cl=new classe();
                            $cl->nom_court=$classe->nom_court;
                            $cl->id_structure_sconet=$classe->id_structure_sconet;
                            $cl->id=$classesid[0];
                            $classes[]=$cl;
                          }
                          //print_r($classes);
                          // on récupère les différents MEF des classes
                          $mefs=array();
                          foreach ($classes as $classe) {
//                            $req = "SELECT DISTINCT(elmef.code_mef),id_classe
//                                    FROM plugin_archAPB_eleves_mef elmef,  eleves e, j_eleves_classes jec
//                                    WHERE e.no_gep=elmef.no_gep AND jec.login = e.login AND jec.id_classe = ".$classe->id;
                            $req = mysqli_query($GLOBALS["mysqli"], "SELECT code_mef FROM `plugin_archAPB_mefs_classes` WHERE `id_structure_sconet` = '".$classe->id_structure_sconet."' AND annee = ".$annee);
                            //echo $classe->nom_court." ";
                            $tmpmefs=array();
                            while ($mef = mysqli_fetch_object($req)) {
                              //echo " - ".$mef->code_mef;
                              $tmpmefs[]=$mef->code_mef;
                            }
                            $mefs[$classe->id_structure_sconet]=$tmpmefs;
                          }
                          // Pour chaque classe, on va récupérer dans Nomenclature.xml les différentes disciplines
                          // et dans GEPI les différents groupes de la classe

                          // 1. les matières de sconet
                          $xml = new DomDocument();
                          $xml->load("../../temp/".$tempdir."/nomenclature.xml");
                          $matieres=array();
                          $mats=$xml->getElementsByTagName('MATIERE');
                          foreach ($mats as $matiere) {
                            $code_matiere = $matiere->getAttribute("CODE_MATIERE");
                            $code_gestion = $matiere->getElementsByTagName("CODE_GESTION")->item(0)->nodeValue;
                            $nom_court= $matiere->getElementsByTagName("LIBELLE_COURT")->item(0)->nodeValue;
                            $matieres[$code_matiere]=array( 'code_gestion' => trim($code_gestion),
                                                            'libelle_court' => $nom_court);
                          }
                          //print_r($matieres);
                          // 2. les programmes selon les mefs
                          $programmes = array();
                          $progs=$xml->getElementsByTagName('PROGRAMME');
                          foreach ($progs as $prog) {
                            $code_mef = $prog->getElementsByTagName("CODE_MEF")->item(0)->nodeValue;
                            $code_matiere = $prog->getElementsByTagName("CODE_MATIERE")->item(0)->nodeValue;
                            $code_modalite= $prog->getElementsByTagName("CODE_MODALITE_ELECT")->item(0)->nodeValue;
                            //echo "<p>$code_mef - $code_matiere - $code_modalite ".$matieres[$code_matiere]['libelle_court']."</p>";
                            if ($code_modalite == "N") {
                              $code_modalite = "F";
                            }
                              //echo "memo";
                            $programmes[]=array( 'code_mef' => $code_mef,
                                                 'code_modalite' => $code_modalite,
                                                 'code_matiere'=>$code_matiere);
                          }
                          //print_r($programmes);
                          // 3. les groupes de GEPI par classe
                          //
                          $groupes=array();
                          foreach ($classes as $classe) {
//                            $req = "SELECT DISTINCT(elmef.code_mef),id_classe
//                                    FROM plugin_archAPB_eleves_mef elmef,  eleves e, j_eleves_classes jec
//                                    WHERE e.no_gep=elmef.no_gep AND jec.login = e.login AND jec.id_classe = ".$classe->id;
                            $req = mysqli_query($GLOBALS["mysqli"], "SELECT jgc.id_groupe id_groupe, jgc.priorite priorite, jgm.id_matiere id_matiere, g.name nom_groupe, g.description description
                                                FROM j_groupes_classes jgc, j_groupes_matieres jgm, groupes g
                                                WHERE jgc.id_classe = '".$classe->id."' AND jgm.id_groupe = jgc.id_groupe AND g.id = jgc.id_groupe ORDER BY priorite,id_matiere");
                            //echo "<br/><br/>".$classe->nom_court." ";
                            $tmp=array();
                            while ($gr = mysqli_fetch_object($req)) {
                              $test = mysqli_query($GLOBALS["mysqli"], "select count(distinct(login)) nb from j_eleves_groupes where id_groupe = '".$gr->id_groupe."'");
                              $nombre = mysqli_fetch_object($test);
                              $nombre = $nombre->nb;
                              if ($nombre>0) {
                                $tmp[]=array('id_groupe' => $gr->id_groupe,
                                              'id_matiere' => $gr->id_matiere,
                                              'description' => $gr->description,
                                              'effectif' => $nombre,
                                              'nom' => $gr->nom_groupe);
                              }
                            }
                            $groupes[$classe->id]=$tmp;
                          }
                          //print_r($groupes);
                          //
                          $nom_modalites=array("O"=>"Opt. Oblig./ Spécialité", "F"=>"Opt. Facult.", "S"=>"Tronc commun" );
                          echo "<form enctype='multipart/form-data' action='".$_SERVER['PHP_SELF']."?action=mefgroupes&annee=".$annee."' method='post'>\n";
                          echo add_token_field();
                          foreach ($classes as $classe) {
                            echo "<h2>Classe de ".$classe->nom_court."</h2>";
                            //print_r($mefs[$classe->id_structure_sconet]);
                            echo "<p>Définition de la modalité : S = Suivie (par tous) - O = Option obligatoire (ex : langues, spécialités) - F = Option facultative (ex : danse tahitienne)</p>";
                            echo "<table class=\"centreTable\" summary=\"classes id sconet\">
                                    <tr>
                                          <th>Groupe GEPI (nom-description-matiere (effectif))</th>
                                          <th>Matiere Sconet</th>
                                          <th>Reconnaissance automatique</th>
                                    </tr>\n";

                            foreach ($groupes[$classe->id] as $groupe) {
                              // On va mémoriser les données pour pouvoir les trier
                              $progs=array();
                              foreach ($programmes as $programme) {
                                if (in_array($programme['code_mef'],$mefs[$classe->id_structure_sconet])) {
                                  $progs[$matieres[$programme['code_matiere']]['code_gestion'].$programme['code_matiere'].$programme['code_modalite']]=$programme;
                                }
                              }
                              ksort($progs);
                              //print_r($progs);
                              $success=False;
                              echo "<tr>\n";
                              echo "<td>".$groupe['nom']." - ".$groupe['description']." - ".$groupe['id_matiere']."(".$groupe['effectif'].")</td>\n";
                              echo "<td><select name=\"".$classe->id.",".$classe->nom_court.",".$groupe['id_groupe']."\">\n";
                              echo "<option value = \"000,NON-RECONNU,NON-RECONNU,O\">Non reconnu dans SCONET</option>";
                              // calcul du meilleur candidat
                              // on tente d'abord dans la base de données (déjà archivé pourune autre classe)
                              //$req_ante="SELECT code_gestion_sconet FROM plugin_archAPB_matieres WHERE nom_complet='".

                              $selectionne=-1;
                              $d=3;
                              $i=-1;
                              $mode_selection=0; // 0 pour non trouvé - 1 pour bdd - 2 pour levenshtein
                              $exact=false;
                              $code_bdd="";
                              $req_ante=sql_query("SELECT code_gestion_sconet, modalite FROM plugin_archAPB_matieres WHERE nom_complet='".$groupe['id_matiere']."'");
                              //echo "SELECT code_gestion_sconet FROM plugin_archAPB_matieres WHERE nom_complet='".$groupe['id_matiere']."'";
                              if (mysqli_num_rows($req_ante)>0) {
                                $ante=mysqli_fetch_object($req_ante);
                                $code_bdd=$ante->code_gestion_sconet;
                                $modalite_bdd=$ante->modalite;
                              }
                              foreach ($progs as $programme) {
                                $i++;
                                if (in_array($programme['code_mef'],$mefs[$classe->id_structure_sconet])) {
                                  // on tente d'abord dans la base de données (déjà archivé pour cette classe)
                                  $req_ante_exact=sql_query("SELECT code_gestion_sconet, modalite FROM plugin_archAPB_matieres WHERE id_gepi='".$groupe['id_groupe']."' AND annee=".$annee);
                                  if (mysqli_num_rows($req_ante_exact)>0) {
                                    $ante_exact=mysqli_fetch_object($req_ante_exact);
                                    $code_bdd_exact=$ante_exact->code_gestion_sconet;
                                    $modalite_bdd_exact=$ante_exact->modalite;
                                  
                                    if (($matieres[$programme['code_matiere']]['code_gestion']==$code_bdd_exact) && ($programme['code_modalite']==$modalite_bdd_exact) ) {
                                      $selectionne=$i;
                                      $d=0;
                                      $mode_selection=3;
                                    }                                  }
                                  // on tente d'abord dans la base de données (déjà archivé pourune autre classe)
                                  elseif (($matieres[$programme['code_matiere']]['code_gestion']==$code_bdd) && ($programme['code_modalite']==$modalite_bdd) ) {
                                    $selectionne=$i;
                                    $d=0;
                                    $mode_selection=1;
                                  }

                                  elseif (levenshtein($matieres[$programme['code_matiere']]['code_gestion'],$groupe['id_matiere'])<$d) {
                                    $selectionne=$i;
                                    $d=levenshtein($matieres[$programme['code_matiere']]['code_gestion'],$groupe['id_matiere']);
                                    $mode_selection=2;
                                  }
                                }
                              }
                              if ($d==0) {
                                $exact=true;
                              } else {
                                $exact=false;
                              }
                              echo "selection :".$mode_selection;

                              $i=-1;
                              foreach ($progs as $programme) {
                                $i++;
                                if (in_array($programme['code_mef'],$mefs[$classe->id_structure_sconet])) {
                                  echo "<option value = \"".$programme['code_matiere'].",".$matieres[$programme['code_matiere']]['code_gestion'].",".$matieres[$programme['code_matiere']]['libelle_court'].",".$programme['code_modalite']."\"";
//                                  if ($matieres[$programme['code_matiere']]['code_gestion']==$groupe['id_matiere']) {
//                                    echo "selected";
//                                    $success=True;
//                                  }
                                  if ($i==$selectionne) {
                                    echo "selected";
                                    $success=true;
                                  }
                                  echo ">".$matieres[$programme['code_matiere']]['libelle_court']." - ".$nom_modalites[$programme['code_modalite']]."</option>";
                                }
                              }
                              echo "</select></td>"; //<td><img src='../../images/enabled.png' alt='ok' /></td>";
                              if ($success==true) {
                                if ($mode_selection==2) {
                                  echo "<td><img src='sph_jaune24.png' alt='Peut-être reconnu' />Reconnu partiellement  (vérifier attentivement)</td>";
                                } elseif ($mode_selection==3) {
                                  echo "<td><img src='sph_verte24.png' alt='reconnu' />Reconnu d'après saisie précédente</td>";
                                } elseif ($mode_selection==0) {
                                  echo "<td><img src='sph_rouge24.png' alt='non reconnu' />Non reconnu</td>";
                                } elseif ($mode_selection==1) {
                                  echo "<td><img src='sph_vertjaune24.png' alt='reconnu grace aux choix antérieurs' />Reconnu grâce aux choix dans d'autres classes (vérifier la modalité)</td>";
                                }
                              } else {
                                echo "<td><img src='sph_rouge24.png' alt='non reconnu' />Non reconnu - : cet enseignement ne sera pas remonté vers APB</td>";
                              }
                              echo "</tr>";
                            }
                            echo "</table>";
                          }
//                          $classesid = array();
//                          $reqclt=mysql_query("SELECT id,nom_court FROM plugin_archAPB_classes WHERE annee=".$annee." AND traitee=0 AND niveau !='' ORDER BY nom_court");
//                          while ($cl=mysql_fetch_object($reqclt)) {
//                            $classesid[]=$cl->id;
//                          }
                          $classesatraiter=implode(",",$classesid);

                          echo "<h2>Attention :</h2>";
                          echo "<p>Vérifiez que ces informations sont correctes (modifiez-les si nécessaire) avant de valider.</p>";
                          echo "<p>Les groupes notés comme non mémorisés ne seront pas remontés vers APB.</p>";
                          echo "<input type='hidden' name='step' value='1' />\n";
                          echo "<input type='hidden' name='do' value='memo' />\n";
                          echo "<input type='hidden' name='is_posted' value='yes' />\n";
                          echo "<input type='hidden' name='classesid' value='".$classesatraiter."' />\n";
                          echo "<input type='hidden' name='currentclasse' value='".$classes[0]->nom_court."' />\n";
                          echo "<p><input type='submit' value='Valider' /></p>\n";
                          echo "</form>\n";

                          // pour pouvoir sauter à l'étape où on s'était arrêté
                          echo "<p>Vous pouvez sauter directement à une classe précise (utile si vous avez déjà traité quelques classes avant d'être interrompu) :</p>";
                          echo "<p> Classes restant à traiter :";
                          $classesid = array();
                          $reqclt=mysqli_query($GLOBALS["mysqli"], "SELECT id,nom_court FROM plugin_archAPB_classes WHERE annee=".$annee." AND traitee=0 AND niveau !='' ORDER BY nom_court");
                          while ($cl=mysqli_fetch_object($reqclt)) {
                            $classesid[]=$cl->id;
                          }
                          $classesidtmp=$classesid;
                          $ik=0;
                          foreach ($classesid as $clid) {
                            $req=mysqli_query($GLOBALS["mysqli"], "SELECT nom_court, id_structure_sconet FROM  `plugin_archAPB_classes` WHERE annee = ".$annee." AND niveau !='' AND id='".$clid."'");
                            $classe = mysqli_fetch_object($req);
                            $cltmp=$clid;
                            echo "<a href=\"".$_SERVER['PHP_SELF']."?action=mefgroupes&annee=".$annee."&step=1&do=asso&classesid=".$cltmp.add_token_in_url()."\">".$classe->nom_court."</a> - ";
                            unset ($classesidtmp[$ik]);
                            $ik++;
                          }
                          echo "</p>";
                          $classestraitees = array();
                          $reqclt=mysqli_query($GLOBALS["mysqli"], "SELECT id,nom_court FROM plugin_archAPB_classes WHERE annee=".$annee." AND traitee=1 AND niveau !='' ORDER BY nom_court");
                          while ($cl=mysqli_fetch_object($reqclt)) {
                            $classestraitees[]=$cl->id;
                          }
                          echo "<p> Classes déjà traitées :";
                          $classesidtmp=$classestraitees;
                          $ik=0;
                          foreach ($classestraitees as $clid) {
                            $req=mysqli_query($GLOBALS["mysqli"], "SELECT nom_court, id_structure_sconet FROM  `plugin_archAPB_classes` WHERE annee = ".$annee." AND niveau !='' AND id='".$clid."'");
                            $classe = mysqli_fetch_object($req);
                            $cltmp=$classesidtmp[$ik];
                            echo "<a href=\"".$_SERVER['PHP_SELF']."?action=mefgroupes&annee=".$annee."&step=1&do=asso&classesid=".$cltmp.add_token_in_url()."\">".$classe->nom_court."</a> - ";
                            unset ($classesidtmp[$ik]);
                            $ik++;
                          }
                          echo "</p>";

          } elseif($do=="memo") {
          //- Enregistrement des informations
          $currentclasse=isset($_POST['currentclasse']) ? $_POST['currentclasse'] : (isset($_GET['currentclasse']) ? $_GET['currentclasse'] : NULL);
          $succes=True;
          foreach (array_keys($_POST) as $k) {
            $karr=explode(",",$k);
            if (count($karr)>1) {
              $classe_id=$karr[0];
              $classe_nom=$karr[1];
              $groupe_id=$karr[2];
              if ($_POST[$k]!='-') {
                //echo $_POST[$k]."<br/>";
                $matarr=explode(",",$_POST[$k]);
                $code_matiere=$matarr[0];
                $code_gestion=$matarr[1];
                $libelle_court=$matarr[2];
                $modalite=$matarr[3];
              } else {
                $code_matiere=0;
                $code_gestion=0;
                $libelle_court=0;
                $modalite='Z';
              }
              //echo "SELECT nom_complet FROM plugin_archAPB_matieres WHERE id_gepi='".$groupe_id."'";
              if (mysqli_num_rows(mysqli_query($GLOBALS["mysqli"], "SELECT nom_complet FROM plugin_archAPB_matieres WHERE id_gepi='".$groupe_id."' AND annee=".$annee))>0) {
                $rec_classe = mysqli_query($GLOBALS["mysqli"], "SELECT name, jgp.login login
                                          FROM groupes, j_groupes_professeurs jgp
                                          WHERE id=".$groupe_id." AND jgp.id_groupe=".$groupe_id);
                $obj=mysqli_fetch_object($rec_classe);
                $nom=$obj->name;
                $login=$obj->login;
                $rec_groupe = mysqli_query($GLOBALS["mysqli"], "UPDATE plugin_archAPB_matieres
                                    SET nom_complet = '".$nom."',
                                    code_sconet = '".$code_matiere."',
                                    libelle_sconet = '".$libelle_court."',
                                    code_gestion_sconet = '".$code_gestion."',
                                    annee = ".$annee.",
                                    login_prof = '".$login."',
                                    modalite = '".$modalite."'
                                    WHERE id_gepi = ".$groupe_id." AND annee=".$annee);
                //echo mysql_error();
               //echo "modalite".$modalite;
              } else {
                $rec_classe = mysqli_query($GLOBALS["mysqli"], "SELECT name, jgp.login login
                                          FROM groupes, j_groupes_professeurs jgp
                                          WHERE id=".$groupe_id." AND jgp.id_groupe=".$groupe_id);
                $obj=mysqli_fetch_object($rec_classe);
                $nom=$obj->name;
                $login=$obj->login;
                $rec_groupe = mysqli_query($GLOBALS["mysqli"], "INSERT INTO plugin_archAPB_matieres
                                    SET nom_complet = '".$nom."',
                                    code_sconet = '".$code_matiere."',
                                    libelle_sconet = '".$libelle_court."',
                                    code_gestion_sconet = '".$code_gestion."',
                                    annee = ".$annee.",
                                    login_prof = '".$login."',
                                    modalite = '".$modalite."',
                                    id_gepi = ".$groupe_id);
              }
              //echo "err: ".mysql_error();
              if (!$rec_groupe) {
                echo ((is_object($GLOBALS["mysqli"])) ? mysqli_error($GLOBALS["mysqli"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false));
                echo "<br/>L'enregistrement des données n'a pas pu se faire pour le groupe de ".$nom."-".$libelle_court."de la classe de ".$currentclasse;
                $succes=False;
              }

          }
        }
        $classesid=isset($_POST['classesid']) ? $_POST['classesid'] : (isset($_GET['classesid']) ? $_GET['classesid'] : NULL);
        if (isset($classesid)) {
          if ($succes) {
            // on enregistre que la classe a été traitée
            $qu=mysqli_query($GLOBALS["mysqli"], "UPDATE plugin_archAPB_classes SET traitee=1 WHERE id=".$classe_id." AND annee=".$annee);
            $classesid=explode(",",$classesid);
            //
            unset($classesid[0]);
            $classesid = array();
            $reqclt=mysqli_query($GLOBALS["mysqli"], "SELECT id,nom_court FROM plugin_archAPB_classes WHERE annee=".$annee." AND traitee=0 AND niveau !='' ORDER BY nom_court");
            while ($cl=mysqli_fetch_object($reqclt)) {
              $classesid[]=$cl->id;
            }
            $classesatraiter=implode(",",$classesid);

            echo "<p>L'enregistrement des données s'est fait avec succès pour la classe de ".$currentclasse."</p>";
            echo "<p>Vous pouvez passer à la classe suivante</p>";
            echo "<form enctype=\"multipart/form-data\" name= \"formulaire\" action=\"".$_SERVER['PHP_SELF']."?action=mefgroupes&annee=".$annee."\" method=\"post\">\n";
            echo add_token_field();
            echo "<input type='hidden' name='step' value='1' />\n";
            echo "<input type='hidden' name='do' value='asso' />\n";
            echo "<input type='hidden' name='is_posted' value='yes' />\n";
            echo "<input type='hidden' name='classesid' value='".$classesatraiter."' />\n";
            echo "<p><input type='submit' value='Continuer' /></p>\n";
            echo "</form>\n";
          }
          else {
            echo "<p>Une erreur est survenue : 410</p>";
          }
        }
        else {
          if ($succes) {
            echo "<p>L'enregistrement des données s'est fait avec succès pour cette classe</p>";
            echo "<p>Vous pouvez passer à l'étape suivante : <a href=\"index.php?action=arch&annee=".$annee.add_token_in_url()."\">Sauvegarder les notes</a> </p>";
          }
        }
      }


}
}

?>
