<?php
/*
 *
 */
$debug = false;

echo "<h2>Etape 2 : Association des classes aux structures de Sconet</h2>";

$step=isset($_POST['step']) ? $_POST['step'] : (isset($_GET['step']) ? $_GET['step'] : NULL);

if(!isset($step)){
        echo "<p>Cette page permet d'associer les classes avec les codes Sconet correspondants.<br />\n";
        echo "</p>\n";

        echo "<form enctype='multipart/form-data' action='".$_SERVER['PHP_SELF']."?action=sconetclasses&annee=".$annee."' method='post'>\n";
        echo add_token_field();
        echo "<p>Veuillez fournir le fichier Structures.xml <br />\n";
        echo "<input type=\"file\" size=\"65\" name=\"structures_xml_file\" /><br />\n";
        if ($gepiSettings['unzipped_max_filesize']>=0) {
                echo "<p style=\"font-size:small; color: red;\"><i>REMARQUE&nbsp;:</i> Vous pouvez fournir à Gepi le fichier compressé issu directement de SCONET. (Ex : ExportXML_Structures.zip)</p>";
        }
        echo "<input type='hidden' name='step' value='0' />\n";
        echo "<input type='hidden' name='is_posted' value='yes' />\n";
        echo "<p><input type='submit' value='Valider' /></p>\n";
        echo "</form>\n";
}
else{
        $post_max_size=ini_get('post_max_size');
        $upload_max_filesize=ini_get('upload_max_filesize');
        $max_execution_time=ini_get('max_execution_time');
        $memory_limit=ini_get('memory_limit');
		check_token();
        if($step==0){
                $structxml_file = isset($_FILES["structures_xml_file"]) ? $_FILES["structures_xml_file"] : NULL;
                if(!is_uploaded_file($structxml_file['tmp_name']) ) {
                        echo "<p style='color:red;'>L'upload d'un fichier a échoué.</p>\n";

                        echo "<p>Les variables du php.ini peuvent peut-être expliquer le problème:<br />\n";
                        echo "post_max_size=$post_max_size<br />\n";
                        echo "upload_max_filesize=$upload_max_filesize<br />\n";
                        echo "</p>\n";

                        // Il ne faut pas aller plus loin...
                        // SITUATION A GERER
                        require("../lib/footer.inc.php");
                        die();
                }
                else{
                        if(!file_exists($structxml_file['tmp_name'])){
                                echo "<p style='color:red;'>Le fichier aurait été uploadé... mais ne serait pas présent/conservé.</p>\n";

                                echo "<p>Les variables du php.ini peuvent peut-être expliquer le problème:<br />\n";
                                echo "post_max_size=$post_max_size<br />\n";
                                echo "upload_max_filesize=$upload_max_filesize<br />\n";
                                echo "et le volume de ".$structxml_file['name']." serait<br />\n";
                                echo "\$structxml_file['size']=".volume_human($structxml_file['size'])."<br />\n";
                                echo "</p>\n";
                                // Il ne faut pas aller plus loin...
                                // SITUATION A GERER
                                require("../lib/footer.inc.php");
                                die();
                        }
                        echo "<p>Le fichier a été transféré sur le serveur.</p>\n";
                        $source_file=$structxml_file['tmp_name'];
                        $dest_file="../../temp/".$tempdir."/structures.xml";
                        $res_copy=copy("$source_file" , "$dest_file");
                        
                        //===============================================================
                        // ajout prise en compte des fichiers ZIP: Marc Leygnac

                        $unzipped_max_filesize=getSettingValue('unzipped_max_filesize')*1024*1024;
                        // $unzipped_max_filesize = 0    pas de limite de taille pour les fichiers extraits
                        // $unzipped_max_filesize < 0    extraction zip désactivée
                        if($unzipped_max_filesize>=0) {
                                $fichier_emis=$structxml_file['name'];
                                $extension_fichier_emis=strtolower(strrchr($fichier_emis,"."));
                                if (($extension_fichier_emis==".zip")||($structxml_file['type']=="application/zip"))
                                        {
                                        require_once('../../lib/pclzip.lib.php');
                                        $archive = new PclZip($dest_file);

                                        if (($list_file_zip = $archive->listContent()) == 0) {
                                                echo "<p style='color:red;'>Erreur : ".$archive->errorInfo(true)."</p>\n";
                                                require("../../lib/footer.inc.php");
                                                die();
                                        }

                                        if(sizeof($list_file_zip)!=1) {
                                                echo "<p style='color:red;'>Erreur : L'archive contient plus d'un fichier.</p>\n";
                                                require("../../lib/footer.inc.php");
                                                die();
                                        }
                                        if(($list_file_zip[0]['size']>$unzipped_max_filesize)&&($unzipped_max_filesize>0)) {
                                                echo "<p style='color:red;'>Erreur : La taille du fichier extrait (<i>".$list_file_zip[0]['size']." octets</i>) dépasse la limite paramétrée (<i>$unzipped_max_filesize octets</i>).</p>\n";
                                                require("../../lib/footer.inc.php");
                                                die();
                                        }
                                        $res_extract=$archive->extract(PCLZIP_OPT_PATH, "../../temp/".$tempdir."/apb/");
                                        //echo "unzip dans "."../../temp/apb/".$tempdir;
                                        if ($res_extract != 0) {
                                                echo "<p>Le fichier uploadé a été dézippé.</p>\n";
                                                $fichier_extrait=$res_extract[0]['filename'];                                              
                                                unlink("$dest_file"); // Pour Wamp...
                                                $res_copy=rename("$fichier_extrait" , "$dest_file");
                                                //echo $fichier_extrait." ".$dest_file;
                                        }
                                        else {
                                                echo "<p style='color:red'>Echec de l'extraction de l'archive ZIP.</p>\n";
                                                require("../../lib/footer.inc.php");
                                                die();
                                        }
                                }
                        }
                        if(!$res_copy){
                                echo "<p style='color:red;'>La copie du fichier vers le dossier temporaire a échoué.<br />Vérifiez que l'utilisateur ou le groupe apache ou www-data a accès au dossier temp/$tempdir</p>\n";
                                // Il ne faut pas aller plus loin...
                                // SITUATION A GERER
                                require("../../lib/footer.inc.php");
                                die();
                        }
                        //fin  ajout prise en compte des fichiers ZIP
                        //===============================================================

                        if(!$res_copy){
                                echo "<p style='color:red;'>La copie du fichier vers le dossier temporaire a échoué.<br />Vérifiez que l'utilisateur ou le groupe apache ou www-data a accès au dossier temp/$tempdir</p>\n";
                                // Il ne faut pas aller plus loin...
                                // SITUATION A GERER
                                require("../lib/footer.inc.php");
                                die();
                        }
                        else{
                          echo "<p>La copie du fichier vers le dossier temporaire a réussi.</p>\n";
                          echo "<h3>GEPI va essayer d'associer chaque classe à une structure de Sconet</h3>";
                          // On va commencer par l'analyse des nomenclatures pour les classes
                          $xml = new DomDocument();
                          $xml->load("../../temp/".$tempdir."/structures.xml");
                          $divisions=$xml->getElementsByTagName('DIVISION');
                          $codes_structures=array();
                          $codes_mef=array();
                          foreach ($divisions as $division) {
                            $code_structure = $division->getAttribute("CODE_STRUCTURE");
                            $codes_structures[] = $code_structure;
                            $code_mefnode = $division->getElementsByTagName("CODE_MEF");
                            $code_mef=array();
                            foreach ($code_mefnode as $code_mn) {
                              $code_mef[] = substr(trim($code_mn->nodeValue),0,11);
                            }
                            $codes_mef[$code_structure]=$code_mef;
                            //echo $code_structure."-".$code_mef[0]."<br/>";
                          }
                          if ($debug) {
                            print_r($codes_structures);
                            print_r($codes_mef);
                          }
                          $req= mysqli_query($GLOBALS["mysqli"], "SELECT apb.id id,apb.apb_niveau niveau, c.classe nom_court,
                                  c.nom_complet nom_complet,MAX(p.num_periode) periodes
                                  FROM plugin_archAPB_apb_niveau apb, classes c, periodes p WHERE apb.apb_niveau!='' AND apb.id=c.id AND p.id_classe = apb.id AND apb.annee = ".$annee." GROUP BY apb.id");
                          echo "<form enctype='multipart/form-data' action='".$_SERVER['PHP_SELF']."?action=sconetclasses&annee=".$annee."' method='post'>\n";
                          echo add_token_field();
                          echo "<table class=\"centreTable\" summary=\"classes id sconet\">
                                  <tr>
                                        <th>Classe GEPI</th>
                                        <th>Structure Sconet</th>
                                        <th> </th>
                                  </tr>\n";
                          foreach ($codes_structures as $nom_court) {
                            foreach ($codes_mef[$nom_court] as $mef) {
                                // on sauve le mef dans la base
                                if (mysqli_num_rows(mysqli_query($GLOBALS["mysqli"], "SELECT `code_mef` FROM `plugin_archAPB_mefs_classes` WHERE `id_structure_sconet` = '".$nom_court."'
                                                    AND `code_mef` = '".$mef."'
                                                    AND `annee` = ".$annee))==0) {
                                  $rec = mysqli_query($GLOBALS["mysqli"], "INSERT INTO plugin_archAPB_mefs_classes
                                    SET id_structure_sconet = '".$nom_court."',
                                    code_mef = '".$mef."',
                                    annee = ".$annee);
                                }
                              }
                          }

                          // Tri alphabétique
                          sort($codes_structures);

                          while ($classe = mysqli_fetch_object($req)) {
                            echo "<tr>\n";
                            $classe->nom_court = trim($classe->nom_court);
                            echo "<td>".$classe->nom_court."</td>\n";
                            if (in_array($classe->nom_court,$codes_structures)) {
                              //
                              //echo "SELECT nom_court FROM plugin_archAPB_classes WHERE id=".$classe->id;
                              echo "<td><select name=\"".$classe->nom_court."\">\n";
                              foreach ($codes_structures as $code) {
                                echo "<option ";
                                if ($code==$classe->nom_court) { echo "selected"; }
                                echo ">".$code."</option>";
                              }
                              echo "</select></td><td><img src='../../images/enabled.png' alt='ok' />Reconnue</td>";
                            }
                            else {
                              echo "<td><select name=\"".$classe->nom_court."\">\n";
                              foreach ($codes_structures as $code) {
                                echo "<option ";
                                echo ">".$code."</option>";
                              }
                              echo "</select></td><td><img src='../../images/disabled.png' alt='ok' />Non reconnue</td>";
                            }
                            echo "</tr>";
                          }
                          echo "</table>";
                          echo "<p>Vérifiez que ces informations sont correctes (modifiez-les si nécessaire) avant de valider.</p>";
                          echo "<input type='hidden' name='step' value='1' />\n";
                          echo "<input type='hidden' name='is_posted' value='yes' />\n";
                          echo "<p><input type='submit' value='Valider' /></p>\n";
                          echo "</form>\n";
                          
                        }
                }
        } // Fin du $step=0
        elseif ($step==1) { // début du step 1
		  check_token();
          $req= mysqli_query($GLOBALS["mysqli"], "SELECT apb.id id,apb.apb_niveau niveau, c.classe nom_court, pp.professeur prof,
                                  c.nom_complet nom_complet,MAX(p.num_periode) periodes
                                  FROM plugin_archAPB_apb_niveau apb, classes c, periodes p, j_eleves_professeurs pp WHERE apb.id=pp.id_classe AND apb.apb_niveau!='' AND apb.id=c.id AND p.id_classe = apb.id AND apb.annee = '".$annee."'GROUP BY apb.id");
          //echo "SELECT apb.id id,apb.apb_niveau niveau, c.classe nom_court, pp.professeur prof,
                                  //c.nom_complet nom_complet,MAX(p.num_periode) periodes
                                  //FROM plugin_archAPB_apb_niveau apb, classes c, periodes p, j_eleves_professeurs pp WHERE apb.id=pp.id_classe AND apb.apb_niveau!='' AND apb.id=c.id AND p.id_classe = apb.id GROUP BY apb.id";
          $succes=True;
          //print_r($_POST);
          while ($classe = mysqli_fetch_object($req)) {
            $classe->nom_court = trim($classe->nom_court);
             if (isset($_POST[str_replace (" ","_",$classe->nom_court)])) {
               //echo "SELECT nom_court FROM plugin_archAPB_classes WHERE id=".$classe->id." AND annee=".$annee;
                if (mysqli_num_rows(mysqli_query($GLOBALS["mysqli"], "SELECT nom_court FROM plugin_archAPB_classes WHERE id=".$classe->id." AND annee=".$annee))>0) {
                  
					$sql_classe = "UPDATE plugin_archAPB_classes
                                  SET nom_court = \"".$classe->nom_court."\",
                                  nom_complet = \"".$classe->nom_complet."\",
                                  niveau = \"".$classe->niveau."\",
                                  decoupage = ".$classe->periodes.",
                                  login_pp = \"".$classe->prof."\",
                                  id_structure_sconet = \"".$_POST[str_replace (" ","_",$classe->nom_court)]."\"
                                  WHERE id = ".$classe->id." AND annee = ".$annee;
					$rec_classe = mysqli_query($GLOBALS["mysqli"], $sql_classe);
                  $debug_chaine=$sql_classe."<br/>";
//          echo "UPDATE plugin_archAPB_classes
//                                  SET nom_court = '".$classe->nom_court."',
//                                  nom_complet = '".$classe->nom_complet."',
//                                  niveau = '".$classe->niveau."',
//                                  decoupage = ".$classe->periodes.",
//                                  login_pp = '".$classe->prof."',
//                                  id_structure_sconet = '".$_POST[$classe->nom_court]."'
//                                  WHERE id = ".$classe->id." AND annee = ".$annee;
                } else {
					$sql_classe = "INSERT INTO plugin_archAPB_classes
                                  SET nom_court = \"".$classe->nom_court."\",
                                  nom_complet = \"".$classe->nom_complet."\",
                                  niveau = \"".$classe->niveau."\",
                                  decoupage = ".$classe->periodes.",
                                  annee = ".$annee.",
                                  login_pp = \"".$classe->prof."\",
                                  id_structure_sconet = \"".$_POST[str_replace (" ","_",$classe->nom_court)]."\",
                                  id = ".$classe->id;
					$rec_classe = mysqli_query($GLOBALS["mysqli"], $sql_classe );
					$debug_chaine= $sql_classe."<br />";
                }
                //echo $debug_chaine;
                if (!$rec_classe) {
                  echo "<br/>L'enregistrement des données n'a pas pu se faire pour la classe de ".$classe->nom_court;
				  // echo "<br />".$sql_classe;
                  $succes=False;
                } else {
                  echo "<br/>L'enregistrement des données s'est fait avec succès pour la classe de ".$classe->nom_court;
                }
             }
          }
          if ($succes) {
            echo "<p>Vous pouvez passer à <a href=\"index.php?action=mefeleves&annee=".$annee."\">l'étape suivante : 3. Association des élèves aux MEF de Sconet.</a> </p>";
          }

        }
}
?>
