<?php
/*
 *
 * Copyright 2001, 2012 Thomas Belliard, Laurent Delineau, Edouard Hue, Eric Lebrun
 *
 * This file is part of GEPI.
 *
 * GEPI is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GEPI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the  warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GEPI; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

// Initialisations files
require_once("../lib/initialisations.inc.php");

// Resume session
$resultat_session = $session_gepi->security_check();
if ($resultat_session == 'c') {
    header("Location: ../utilisateurs/mon_compte.php?change_mdp=yes");
    die();
} else if ($resultat_session == '0') {
    header("Location: ../logout.php?auto=1");
    die();
}

if (!checkAccess()) {
    header("Location: ../logout.php?auto=1");
    die();
}



$id_groupe = isset($_POST['id_groupe']) ? $_POST['id_groupe'] : (isset($_GET['id_groupe']) ? $_GET['id_groupe'] : NULL);
$id_classe = isset($_POST['id_classe']) ? $_POST['id_classe'] : (isset($_GET['id_classe']) ? $_GET['id_classe'] : NULL);

$aid_id = isset($_POST['aid_id']) ? $_POST['aid_id'] : (isset($_GET['aid_id']) ? $_GET['aid_id'] : NULL);

$periode_num = isset($_GET['periode_num']) ? $_GET['periode_num'] : 0;

if (!is_numeric($periode_num)) $periode_num = 0;

if (is_numeric($id_groupe) && $id_groupe > 0) {
	$current_group = get_group($id_groupe);
} else {
	$current_group = false;

	if (is_numeric($aid_id) && $aid_id > 0) {
		$current_aid = get_tab_aid($aid_id);
	} else {
		$current_aid=false;
	}
}

if ($current_group) {
	$nom_fic = $current_group["name"] . "-" . $current_group["classlist_string"] . ".csv";
} elseif ($current_aid) {
	$nom_fic = remplace_accents($current_aid["nom_complet"] . "-" . $current_aid["aid_nom"] . "-" . $current_aid["classlist_string"], 'all') . ".csv";
} else {
	//https://127.0.0.1/steph/gepi_git_trunk/saisie/import_class_csv.php?id_groupe=&periode_num=0&champs=3&ligne_entete=y&mode=Id_Note_App
	$classe = old_mysql_result(mysqli_query($GLOBALS["mysqli"], "SELECT classe FROM classes WHERE id = '" . $id_classe . "'"), 0);
	$nom_fic = $classe . ".csv";
}

$now = gmdate('D, d M Y H:i:s') . ' GMT';
header('Content-Type: text/x-csv');
header('Expires: ' . $now);
// lem9 & loic1: IE need specific headers
if (my_ereg('MSIE', $_SERVER['HTTP_USER_AGENT'])) {
    header('Content-Disposition: inline; filename="' . $nom_fic . '"');
    header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
    header('Pragma: public');
} else {
    header('Content-Disposition: attachment; filename="' . $nom_fic . '"');
    header('Pragma: no-cache');
}

include "../lib/periodes.inc.php";
$fd = '';

//$fin_de_ligne="\n";
$fin_de_ligne="\r\n";

if(isset($_GET['ligne_entete'])){
	switch($_GET['mode']){
		case "Id_Note_App":
			$fd.="IDENTIFIANT;NOTE;APPRECIATION$fin_de_ligne";
			break;
		case "Id_App":
			$fd.="IDENTIFIANT;APPRECIATION$fin_de_ligne";
			break;
		case "Nom_Prenom_Id_App":
			$fd.="NOM;PRENOM;IDENTIFIANT;APPRECIATION$fin_de_ligne";
			break;
		case "Nom_Prenom_Id":
			$fd.="NOM;PRENOM;IDENTIFIANT$fin_de_ligne";
			break;
		case "Nom_Prenom_Id_Note_App":
			$fd.="NOM;PRENOM;IDENTIFIANT;NOTE;APPRECIATION$fin_de_ligne";
			break;
	}
}

if ($current_group) {
	foreach($current_group["eleves"][$periode_num]["users"] as $current_eleve) {
		$eleve_login = $current_eleve["login"];
		$eleve_nom = $current_eleve["nom"];
		$eleve_prenom = $current_eleve["prenom"];

		$sql="SELECT note,statut FROM matieres_notes WHERE login='$eleve_login' AND periode='$periode_num' AND id_groupe='$id_groupe'";
		//echo "$sql<br />\n";
		$res_note=mysqli_query($GLOBALS["mysqli"], $sql);
		if(mysqli_num_rows($res_note)){
			$lig_note=mysqli_fetch_object($res_note);
			if($lig_note->statut==''){
				$note=my_ereg_replace("\.",",",$lig_note->note);
			}
			else{
				$note=$lig_note->statut;
			}
		}
		else{
			$note="-";
		}


		$app="-";
		$sql="SELECT appreciation FROM matieres_appreciations WHERE login='$eleve_login' AND periode='$periode_num' AND id_groupe='$id_groupe'";
		$res_appreciation=mysqli_query($GLOBALS["mysqli"], $sql);
		if(mysqli_num_rows($res_appreciation)){
			$lig_appreciation=mysqli_fetch_object($res_appreciation);
			//$app=my_ereg_replace("\n"," ",$lig_appreciation->appreciation);
			$app=my_ereg_replace("\n"," ",my_ereg_replace("\r","",strtr($lig_appreciation->appreciation,";",".")));
			//$app=strtr($lig_appreciation->appreciation,"\n"," ");
			//$app="grr".my_eregi_replace("<br />"," ",my_eregi_replace("<br>"," ",nl2br($lig_appreciation->appreciation)));
		}

		switch($_GET['mode']){
			case "Id_Note_App":
				//$fd.=$eleve_login.";".";"."$fin_de_ligne";
				$fd.=$eleve_login.";".$note.";".$app."$fin_de_ligne";
				break;
			case "Id_App":
				//$fd.=$eleve_login.";"."$fin_de_ligne";
				$fd.=$eleve_login.";".$app."$fin_de_ligne";
				break;
			case "Nom_Prenom_Id_App":
				//$fd.=$eleve_nom.";".$eleve_prenom.";".$eleve_login.";"."$fin_de_ligne";
				$fd.=$eleve_nom.";".$eleve_prenom.";".$eleve_login.";".$app."$fin_de_ligne";
				break;
			case "Nom_Prenom_Id":
				$fd.=$eleve_nom.";".$eleve_prenom.";".$eleve_login."$fin_de_ligne";
				break;
			case "Nom_Prenom_Id_Note_App":
				//$fd.=$eleve_nom.";".$eleve_prenom.";".$eleve_login.";".";"."$fin_de_ligne";
				$fd.=$eleve_nom.";".$eleve_prenom.";".$eleve_login.";".$note.";".$app."$fin_de_ligne";
				break;
		}
	}
}
elseif ($current_aid) {
	/*
	echo "<pre>";
	print_r($current_aid);
	echo "</pre>";
	die();
	*/
	if(isset($current_aid["eleves"][$periode_num]["users"])) {
		foreach($current_aid["eleves"][$periode_num]["users"] as $current_eleve) {
			$eleve_login = $current_eleve["login"];
			$eleve_nom = $current_eleve["nom"];
			$eleve_prenom = $current_eleve["prenom"];

			$note='';
			$app="-";
			$sql="SELECT * FROM aid_appreciations WHERE login='$eleve_login' AND periode='$periode_num' AND id_aid='$aid_id'";
			$res_appreciation=mysqli_query($GLOBALS["mysqli"], $sql);
			if(mysqli_num_rows($res_appreciation)){
				$lig_appreciation=mysqli_fetch_object($res_appreciation);
				//$app=my_ereg_replace("\n"," ",$lig_appreciation->appreciation);
				$app=my_ereg_replace("\n"," ",my_ereg_replace("\r","",strtr($lig_appreciation->appreciation,";",".")));
				//$app=strtr($lig_appreciation->appreciation,"\n"," ");
				//$app="grr".my_eregi_replace("<br />"," ",my_eregi_replace("<br>"," ",nl2br($lig_appreciation->appreciation)));

				if($lig_appreciation->statut=='other') {
					$note='';
				}
				elseif($lig_appreciation->statut!='') {
					$note=$lig_appreciation->statut;
				}
				elseif(!is_null($lig_appreciation->note)){
					$note=strtr($lig_appreciation->note, ".", ",");
				}
			}

			switch($_GET['mode']){
				case "Id_Note_App":
					//$fd.=$eleve_login.";".";"."$fin_de_ligne";
					$fd.=$eleve_login.";".$note.";".$app."$fin_de_ligne";
					break;
				case "Id_App":
					//$fd.=$eleve_login.";"."$fin_de_ligne";
					$fd.=$eleve_login.";".$app."$fin_de_ligne";
					break;
				case "Nom_Prenom_Id_App":
					//$fd.=$eleve_nom.";".$eleve_prenom.";".$eleve_login.";"."$fin_de_ligne";
					$fd.=$eleve_nom.";".$eleve_prenom.";".$eleve_login.";".$app."$fin_de_ligne";
					break;
				case "Nom_Prenom_Id":
					$fd.=$eleve_nom.";".$eleve_prenom.";".$eleve_login."$fin_de_ligne";
					break;
				case "Nom_Prenom_Id_Note_App":
					//$fd.=$eleve_nom.";".$eleve_prenom.";".$eleve_login.";".";"."$fin_de_ligne";
					$fd.=$eleve_nom.";".$eleve_prenom.";".$eleve_login.";".$note.";".$app."$fin_de_ligne";
					break;
			}
		}
	}
} else {
	// Cas où on demande un fichier pour importation d'appréciations du conseil
	$appel_donnees_eleves = mysqli_query($GLOBALS["mysqli"], "SELECT DISTINCT e.*
		FROM eleves e, j_eleves_classes j
		WHERE (
		j.id_classe='".$id_classe."' AND
		j.login = e.login AND
		periode='".$periode_num."'
		) ORDER BY nom, prenom");
	$nombre_lignes = mysqli_num_rows($appel_donnees_eleves);
	$i = 0;
	while($i < $nombre_lignes) {
		$eleve_login = old_mysql_result($appel_donnees_eleves, $i, "login");
		$eleve_nom = old_mysql_result($appel_donnees_eleves, $i, "nom");
		$eleve_prenom = old_mysql_result($appel_donnees_eleves, $i, "prenom");
		$k=1;
		$enr_eleve = 'no';
		if ($_SESSION['statut'] != 'scolarite') {
			$eleve_profsuivi_query = mysqli_query($GLOBALS["mysqli"], "SELECT * FROM  j_eleves_professeurs
								WHERE (
								login='".$eleve_login."' AND
								professeur='".$_SESSION['login']."' AND
								id_classe = '".$id_classe."')");
			$test_suivi = mysqli_num_rows($eleve_profsuivi_query);
		}
		else{
			$test_suivi = 1;
		}
		if ($test_suivi != "0")  {
			switch($_GET['mode']){
				case "Id_Note_App":
					$fd.=$eleve_login.";".";"."$fin_de_ligne";
					break;
				case "Id_App":
					$fd.=$eleve_login.";"."$fin_de_ligne";
					break;
				case "Nom_Prenom_Id_App":
					$fd.=$eleve_nom.";".$eleve_prenom.";".$eleve_login.";"."$fin_de_ligne";
					break;
				case "Nom_Prenom_Id":
					$fd.=$eleve_nom.";".$eleve_prenom.";".$eleve_login."$fin_de_ligne";
					break;
				case "Nom_Prenom_Id_Note_App":
					$fd.=$eleve_nom.";".$eleve_prenom.";".$eleve_login.";".";"."$fin_de_ligne";
					break;
			}
		}
		$i++;
	}
}

//echo $fd;
echo echo_csv_encoded($fd);

?>
