<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<?php
/*
* $Id$
 *
 * Copyright 2001, 2015 Thomas Belliard, Eric Lebrun, Regis Bouguin, Stephane Boireau
 *
 * This file is part of GEPI.
 *
 * GEPI is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GEPI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GEPI; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
* ******************************************** *
* Appelle les sous-modèles                     *
* templates/origine/header_template.php        *
* templates/origine/bandeau_template.php       *
* ******************************************** *
*/

/**
 *
 * @author regis
 */

?>
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="fr" lang="fr">

<head>
<!-- on inclut l'entête -->
	<?php
	  $tbs_bouton_taille = "..";
	  include('../templates/origine/header_template.php');
	?>

  <script type="text/javascript" src="../templates/origine/lib/fonction_change_ordre_menu.js"></script>

	<link rel="stylesheet" type="text/css" href="../templates/origine/css/accueil.css" media="screen" />
	<link rel="stylesheet" type="text/css" href="../templates/origine/css/bandeau.css" media="screen" />
	<link rel="stylesheet" type="text/css" href="../templates/origine/css/gestion.css" media="screen" />

<!-- corrections internet Exploreur -->
	<!--[if lte IE 7]>
		<link title='bandeau' rel='stylesheet' type='text/css' href='../templates/origine/css/accueil_ie.css' media='screen' />
		<link title='bandeau' rel='stylesheet' type='text/css' href='../templates/origine/css/bandeau_ie.css' media='screen' />
	<![endif]-->
	<!--[if lte IE 6]>
		<link title='bandeau' rel='stylesheet' type='text/css' href='../templates/origine/css/accueil_ie6.css' media='screen' />
	<![endif]-->
	<!--[if IE 7]>
		<link title='bandeau' rel='stylesheet' type='text/css' href='../templates/origine/css/accueil_ie7.css' media='screen' />
	<![endif]-->


<!-- Style_screen_ajout.css -->
	<?php
		if (count($Style_CSS)) {
			foreach ($Style_CSS as $value) {
				if ($value!="") {
					echo "<link rel=\"$value[rel]\" type=\"$value[type]\" href=\"$value[fichier]\" media=\"$value[media]\" />\n";
				}
			}
		}
	?>

<!-- Fin des styles -->


</head>


<!-- ************************* -->
<!-- Début du corps de la page -->
<!-- ************************* -->
<body onload="show_message_deconnexion();<?php echo $tbs_charger_observeur;?>">

<!-- on inclut le bandeau -->
	<?php include('../templates/origine/bandeau_template.php');?>

<!-- fin bandeau_template.html      -->

<?php
// onclick=\"return confirm_abandon (this, change, '$messageEnregistrer')\"
// S'il y a des eng
if(count($tab_engagements['indice'])>0) {
	echo "
<p class='bold'>
	<a href=\"../accueil_modules.php\" onclick=\"return confirm_abandon (this, change, '$themessage')\"><img src='../images/icons/back.png' alt='Retour' class='back_link'/> Retour</a> | 
	<a href=\"../mod_engagements/saisie_engagements.php\" onclick=\"return confirm_abandon (this, change, '$themessage')\"> Saisir les engagements des élèves/responsables</a> | 
	<a href=\"../mod_engagements/imprimer_documents.php\" onclick=\"return confirm_abandon (this, change, '$themessage')\"> Imprimer les engagements/convocations/mail</a> | 
	<a href=\"../mod_engagements/extraction_engagements.php\" onclick=\"return confirm_abandon (this, change, '$themessage')\"> Extraction CSV ou message</a>
</p>";
}
?>

  <div id='container'>

  <form action="index_admin.php" id="form1" method="post" class='fieldset_opacite50'>
<?php
	echo add_token_field();
?>
	
	<h2 class="colleHaut">Configuration générale</h2>
	<p class="italic">
	  La désactivation du module Engagements n'entraîne aucune suppression des données. 
	  Lorsque le module est désactivé, les utilisateurs n'ont pas accès au module.
	</p>
	<fieldset class="no_bordure">
	  <legend class="invisible">Activé ou non</legend>
	  <input type="radio" 
			 name="activer" 
			 id='activer_y' 
			 value="y" 
			<?php if (getSettingAOui("active_mod_engagements")) echo " checked='checked'"; ?>
			 onchange='changement();' />
	  <label for='activer_y' style='cursor: pointer;'>
		Activer le module Engagements
	  </label>
	<br />
	  <input type="radio" 
			 name="activer" 
			 id='activer_n' 
			 value="n" 
			<?php if (!getSettingAOui("active_mod_engagements")) echo " checked='checked'"; ?>
			 onchange='changement();' />
	  <label for='activer_n' style='cursor: pointer;'>
		Désactiver le module Engagements
	  </label>
	</fieldset>

	<p class="center">
	  <input type="hidden" name="is_posted" value="1" />
	  <input type="submit" value="Enregistrer" />
	</p>

</form>

<br />

  <form action="index_admin.php" id="form2" method="post" class='fieldset_opacite50'>
<?php
	$gepi_prof_suivi=ucfirst(getSettingValue('gepi_prof_suivi'));
	echo add_token_field();

	$tab_user=array();
	$sql="SELECT DISTINCT login, nom, prenom, statut, etat FROM utilisateurs WHERE statut!='eleve' AND statut!='responsable' ORDER BY nom, prenom;";
	$res_u=mysqli_query($GLOBALS['mysqli'], $sql);
	if(mysqli_num_rows($res_u)>0) {
		while($lig_u=mysqli_fetch_assoc($res_u)) {
			$tab_user[$lig_u['login']]=$lig_u;
		}
	}

	/*
	echo "<pre>";
	print_r($tab_engagements);
	echo "</pre>";
	*/
?>
	<input type="hidden" name="is_posted" value="2" />

	<h2 class="colleHaut">Engagements</h2>

	<p class='bold' style='margin-top:1em;'>Engagements existants&nbsp;:</p>
	<table align='left' class='boireaus boireaus_alt' style='margin-left:1em;'>
		<thead>
			<tr>
				<th style='color:black;' rowspan='2'>Id</th>
				<th style='color:black;' rowspan='2'>Code</th>
				<th style='color:black;' rowspan='2'>Nom</th>
				<th style='color:black;' rowspan='2'>Description</th>
				<th style='color:black;' rowspan='2'>Lié à une classe</th>
				<th style='color:black;' rowspan='2'>Conseil de classe</th>
				<th style='color:black;' colspan='2'>Statuts visés</th>
				<th style='color:black;' colspan='4'>Statuts saisie</th>
				<th style='color:black;' rowspan='2'>Supprimer cet engagement</th>
			</tr>
			<tr>
				<th style='color:black;'>Élève</th>
				<th style='color:black;'>Responsable</th>
				<th style='color:black;'>Scolarité</th>
				<th style='color:black;'>Cpe</th>
				<th style='color:black;'><?php echo $gepi_prof_suivi;?></th>
				<th style='color:black;'>Utilisateurs<br />particuliers</th>
			</tr>
		</thead>
		<tbody>
			<?php
				$cpt_u=0;
				for($loop=0;$loop<count($tab_engagements['indice']);$loop++) {
					$checked_type="";
					if($tab_engagements['indice'][$loop]['type']=="id_classe") {
						$checked_type=" checked";
					}
					$checked_conseil_de_classe="";
					if($tab_engagements['indice'][$loop]['conseil_de_classe']=="yes") {
						$checked_conseil_de_classe=" checked";
					}
					$checked_ConcerneEleve="";
					if($tab_engagements['indice'][$loop]['ConcerneEleve']=="yes") {
						$checked_ConcerneEleve=" checked";
					}
					$checked_ConcerneResponsable="";
					if($tab_engagements['indice'][$loop]['ConcerneResponsable']=="yes") {
						$checked_ConcerneResponsable=" checked";
					}
					$checked_SaisieScol="";
					if($tab_engagements['indice'][$loop]['SaisieScol']=="yes") {
						$checked_SaisieScol=" checked";
					}
					$checked_SaisieCpe="";
					if($tab_engagements['indice'][$loop]['SaisieCpe']=="yes") {
						$checked_SaisieCpe=" checked";
					}
					$checked_SaisiePP="";
					if($tab_engagements['indice'][$loop]['SaisiePP']=="yes") {
						$checked_SaisiePP=" checked";
					}

					echo "
			<tr>
				<td>".$tab_engagements['indice'][$loop]['id']."</td>
				<td>".$tab_engagements['indice'][$loop]['code']."</td>
				<td><input type='text' name='nom[".$tab_engagements['indice'][$loop]['id']."]' value=\"".$tab_engagements['indice'][$loop]['nom']."\" /></td>
				<td><textarea name='description[".$tab_engagements['indice'][$loop]['id']."]'>".$tab_engagements['indice'][$loop]['description']."</textarea></td>
				<td><input type='checkbox' name='type[".$tab_engagements['indice'][$loop]['id']."]' value=\"id_classe\"$checked_type /></td>
				<td><input type='checkbox' name='conseil_de_classe[".$tab_engagements['indice'][$loop]['id']."]' value=\"yes\"$checked_conseil_de_classe /></td>
				<td><input type='checkbox' name='ConcerneEleve[".$tab_engagements['indice'][$loop]['id']."]' value=\"yes\"$checked_ConcerneEleve /></td>
				<td><input type='checkbox' name='ConcerneResponsable[".$tab_engagements['indice'][$loop]['id']."]' value=\"yes\"$checked_ConcerneResponsable /></td>
				<td><input type='checkbox' name='SaisieScol[".$tab_engagements['indice'][$loop]['id']."]' value=\"yes\"$checked_SaisieScol /></td>
				<td><input type='checkbox' name='SaisieCpe[".$tab_engagements['indice'][$loop]['id']."]' value=\"yes\"$checked_SaisieCpe /></td>
				<td><input type='checkbox' name='SaisiePP[".$tab_engagements['indice'][$loop]['id']."]' value=\"yes\"$checked_SaisiePP /></td>
				<td>";
				foreach($tab_engagements['indice'][$loop]['droit_user'] as $current_login) {
					echo "
					<input type='checkbox' name='SaisieLogin_".$tab_engagements['indice'][$loop]['id']."[]' id='SaisieLogin_".$cpt_u."' value=\"".$current_login."\" checked /><label for='SaisieLogin_".$cpt_u."' title=\"Droit de saisie pour $current_login\">".civ_nom_prenom($current_login)."</label><br />";
					$cpt_u++;
				}
				echo "
					<select name='SaisieLogin_".$tab_engagements['indice'][$loop]['id']."[]'>
						<option value=''>---</option>";

					foreach($tab_user as $current_login => $user) {
						$style='';
						if($user['etat']=="inactif") {
							$style=" style='color:grey'";
						}
						echo "
						<option value=\"".$current_login."\" title=\"".$current_login."\"".$style.">".$user['nom']." ".$user['prenom']." (".$user['statut'].")</option>";
					}
					echo "
					</select>

				</td>
				<td><input type='checkbox' name='suppr[]' value=\"".$tab_engagements['indice'][$loop]['id']."\" /></td>
			</tr>";
				}
			?>
		</tbody>
	</table>

	<div style='clear:both;'></div>

	<p class='bold' style='margin-top:1em;'>Ajouter un type d'engagement&nbsp;:</p>
	<table style='margin-left:1em;'>
		<tr>
			<td>Nom&nbsp;:</td>
			<td><input type='text' name='AjoutEngagementNom' value='' /></td>
		</tr>
		<tr>
			<td>Description&nbsp;:</td>
			<td><textarea name='AjoutEngagementDescription'></textarea></td>
		</tr>
		<tr>
			<td>Lié à une classe&nbsp;:</td>
			<td><input type='checkbox' name='AjoutEngagementType' id='AjoutEngagementType' value='id_classe' /><label for='AjoutEngagementType'>Oui</label></td>
		</tr>
		<tr>
			<td>Conseil de classe&nbsp;:<br />
			(<em>assiste au conseil de classe</em>)
			</td>
			<td><input type='checkbox' name='AjoutEngagementConseilClasse' id='AjoutEngagementConseilClasse' value='yes' /><label for='AjoutEngagementConseilClasse'>Oui</label></td>
		</tr>
		<tr>
			<td style='vertical-align:top'>Statuts visés/concernés&nbsp;:</td>
			<td>
				<input type="checkbox" 
				name="AjoutEngagementEle" 
				id='EngagementEle' 
				value="yes" 
				onchange='changement();' />
				<label for='EngagementEle'>Élève</label>
				<br />

				<input type="checkbox" 
				name="AjoutEngagementResp" 
				id='AjoutEngagementResp' 
				value="yes" 
				onchange='changement();' />
				<label for='AjoutEngagementResp'>Responsable</label>
			</td>
		</tr>
		<tr>
			<td style='vertical-align:top'>Statuts effectuant la saisie/désignation&nbsp;:</td>
			<td>
				<input type="checkbox" 
				name="AjoutEngagementSaisieScol" 
				id='EngagementSaisieScol' 
				value="yes" 
				onchange='changement();' />
				<label for='EngagementSaisieScol'>Scolarité</label>
				<br />

				<input type="checkbox" 
				name="AjoutEngagementSaisieCpe" 
				id='EngagementSaisieCpe' 
				value="yes" 
				onchange='changement();' />
				<label for='EngagementSaisieCpe'>Cpe</label>
				<br />

				<input type="checkbox" 
				name="AjoutEngagementSaisiePP" 
				id='EngagementSaisiePP' 
				value="yes" 
				onchange='changement();' />
				<label for='EngagementSaisiePP'><?php echo $gepi_prof_suivi;?></label><br />

				Utilisateurs particuliers&nbsp;: <select name='AjoutEngagementSaisieLogin[]' multiple='y' size='7' style='vertical-align:top;'>
					<option value=''>---</option>
					<?php
					foreach($tab_user as $current_login => $user) {
						$style='';
						if($user['etat']=="inactif") {
							$style=" style='color:grey'";
						}
						echo "
					<option value=\"".$current_login."\" title=\"".$current_login."\"".$style.">".$user['nom']." ".$user['prenom']." (".$user['statut'].")</option>";
					}
					?>
				</select>
			</td>
		</tr>
	</table>

	<p class="center">
	  <input type="submit" value="Ajouter/Valider" />
	</p>

	<p style='text-indent:-4em; margin-left:4em; margin-top:1em;'><em>NOTES&nbsp;:</em></p>
	<ul>
		<li><p>En supprimant un engagement, vous supprimez aussi l'association avec les élèves, responsables éventuellement engagés.</p></li>
		<li><p>Les "codes" des engagements correspondent aux codes des engagements attendus dans l'application Livret Scolaire Lycée (<em>LSL</em>).<br />
		Seuls les engagements officiels du LSL requièrent un tel code.</p></li>
		<li><p>Vous pouvez ajouter des engagements comme "Délégué parent" pour générer les convocations aux conseils de classe qui sont associées.</p></li>
		<li><p>Vous pouvez choisir dans la page de <?php
		if(getSettingAOui('GepiAdminImprBulSettings')) {
			echo "<a href='../bulletin/param_bull_pdf_2016.php#engagements' target='_blank'>Paramétrage des bulletins CLG 2016</a>";
		}
		else {
			echo "<strong>Paramétrage des bulletins CLG 2016</strong>";
		}
		?> quels engagements doivent apparaitre dans le cadre Vie Scolaire du bulletin CLG 2016.</p></li>
		<li><p><strong>Attention&nbsp;:</strong> Si vous passez de 'non Lié à une classe' à 'Lié à une classe' après avoir déclaré des utilisateurs pour cet engagement, vous devrez re-déclarer ces engagements pour ces utilisateurs.<br />
		Il n'est en effet pas possible de deviner pour quelle classe cet engagement doit alors être déclaré.</p></li>
	</ul>
</form>

<!-- ================================================ -->

<?php
	if(count($tab_engagements["indice"])>0) {
		$tab_engagements_pages=get_tab_engagements_pages();
		echo "<form name='' action='".$_SERVER['PHP_SELF']."' method='post'>
	<fieldset class='fieldset_opacite50' style='margin-top:1em;'>
		".add_token_field()."
		<input type='hidden' name='is_posted' value='3' />
		<table class='boireaus boireaus_alt'>
			<thead>
				<tr>
					<th rowspan='2' style='color:black'>Engagement</th>
					<th colspan='2' style='color:black'>Pages ou modules</th>
				</tr>
				<tr>
					<th style='color:black'>Visu.équipe pédago</th>
					<th style='color:black'>Visu.équipe pédago<br />par les élèves/parents</th>
				</tr>
			</thead>
			<tbody>";
		for($loop=0;$loop<count($tab_engagements["indice"]);$loop++) {
			$checked_visu_profs_class="";
			if((isset($tab_engagements_pages['id_type'][$tab_engagements["indice"][$loop]['id']]))&&(in_array("visu_profs_class", $tab_engagements_pages['id_type'][$tab_engagements["indice"][$loop]['id']]['pages']))) {
				$checked_visu_profs_class="checked ";
			}
			$checked_visu_profs_eleve="";
			if((isset($tab_engagements_pages['id_type'][$tab_engagements["indice"][$loop]['id']]))&&(in_array("visu_profs_eleve", $tab_engagements_pages['id_type'][$tab_engagements["indice"][$loop]['id']]['pages']))) {
				$checked_visu_profs_eleve="checked ";
			}
			echo "
				<tr>
					<td>".$tab_engagements["indice"][$loop]['nom']."</td>
					<td><input type='checkbox' name='visu_profs_class[".$tab_engagements["indice"][$loop]['id']."]' value='y' ".$checked_visu_profs_class."/></td>
					<td><input type='checkbox' name='visu_profs_eleve[".$tab_engagements["indice"][$loop]['id']."]' value='y' ".$checked_visu_profs_eleve."/></td>
				</tr>";
		}
		echo "
			</tbody>
		</table>
		<p class='center'>
			<input type='submit' value='Valider' />
		</p>
	</fieldset>
</form>";
	}
?>

<!-- ================================================ -->

<!-- Début du pied -->
	<div id='EmSize' style='visibility:hidden; position:absolute; left:1em; top:1em;'></div>

	<script type='text/javascript'>
		var ele=document.getElementById('EmSize');
		var em2px=ele.offsetLeft
		//alert('1em == '+em2px+'px');
	</script>


	<script type='text/javascript'>
		temporisation_chargement='ok';
	</script>

</div>

		<?php
			if ($tbs_microtime!="") {
				echo "
   <p class='microtime'>Page générée en ";
   			echo $tbs_microtime;
				echo " sec</p>
   			";
	}
?>

		<?php
			if ($tbs_pmv!="") {
				echo "
	<script type='text/javascript'>
		//<![CDATA[
   			";
				echo $tbs_pmv;
				echo "
		//]]>
	</script>
   			";
		}
?>

</body>
</html>
