<?php

/**
 * Fichier index.php pour l'archivage pour ParcourSup
 *
 * Copyright 2010 Jerome Etheve
 *
 * This file is part of archivageAPB, a plugin for GEPI.
 *
 * GEPI is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Archivage ParcourSup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GEPI; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

$titre_page = "Archivage ParcourSup";
$affiche_connexion = 'yes';
$niveau_arbo = "2";


// ===============================================================
//
//                  IMPORTATION DES FONCTIONS
//
// ===============================================================
include("../../lib/initialisations.inc.php");

// TESTS DE SECURITE
$resultat_session = $session_gepi->security_check();
if ($resultat_session == 'c') {
	header("Location: ../utilisateurs/mon_compte.php?change_mdp=yes");
	die();
} else if ($resultat_session == '0') {
	header("Location: ../logout.php?auto=1");
	die();
}

require_once("../../lib/header.inc.php");
require_once("./check_tables.php");
require_once("./apb_classes.php");

echo "<p class='bold'><a href='../../accueil.php'>Accueil</a></p>";

// On va uploader les fichiers XML dans le tempdir de l'utilisateur (administrateur, ou scolarité)
	$tempdir=get_user_temp_directory();

$annee=isset($_POST['annee']) ? $_POST['annee'] : (isset($_GET['annee']) ? $_GET['annee'] : NULL);


if (!isset($annee)) { 
  $annee_actu=intval(strftime("%Y"));
echo "<p>Avant d'utiliser ce module, il est recommandé de lire la
      <a href='http://www.sylogix.org/projects/gepi/wiki/RefDoc_APB'>documentation située sur le wiki de GEPI</a></p>";
echo "<h2>Sélection de l'année&nbsp;:</h2>";
echo "<p>Veuillez selectionner l'année qui va être archivée.
      </p>";
   echo "<form enctype='multipart/form-data' action='".$_SERVER['PHP_SELF']."' method='post'>\n";
        echo "<select name='annee'>\n";
        // on essaie d'afficher automatiquement l'annee d'archivage
        $mois_actu=intval(strftime("%m"));
        if ($mois_actu>=8 AND $mois_actu<=12) {
          $annee_ref=$annee_actu+1;
        } else {
          $annee_ref=$annee_actu;
        }
        for ($i=0;$i<3;$i++) {
          $an=$annee_actu-1+$i;
          echo "<option value=".$an;
          if ($an==$annee_ref) { echo " selected"; }
          echo ">".nom_annee($an)."</option>";
        }
        echo "</select>";
        echo "<input type='hidden' name='is_posted' value='yes' />\n";
        echo "<p><input type='submit' value='Valider' /></p>\n";
        echo "</form>\n";
        echo "<br/>
        <p style='margin-left:1em;text-indent:-1em;'>* Seront archivées les classes de première pour être exploitées l'année prochaine, ainsi que les classes de terminale,
              pour l'export ParcourSup <em>(ex-APB)</em> de cette année et exploitation l'année prochaine (redoublants).<br />
              En fait, le plugin mémorise toutes les données dont il a besoin pour ensuite les exploiter dans la dernière phase, ou l'année suivante.</p>";


//
    // On affiche ce qui est déjà archivé
    //
    $sql="SELECT DISTINCT annee FROM plugin_archAPB_classes ORDER BY annee";
    $res_annee=mysqli_query($GLOBALS["mysqli"], $sql);   
    //if(){
    if(mysqli_num_rows($res_annee)==0){
            echo "<p>Aucune année n'est encore sauvegardée.</p>\n";
    }
    else{
            echo "<h2>Voici la liste des années sauvegardées&nbsp;:</h2>\n";
            echo "<i>Note&nbsp;: Vous pouvez voir <a href=\"index_complet.php\">le nombre d'élèves ayant des notes archivées dans le plugin en cliquant ici</a> (attention, cela peut être un peu long).</i>";
            echo "<ul>\n";
            while($lig_annee=mysqli_fetch_object($res_annee)){
                    $annee_scolaire=$lig_annee->annee;
                    $themessage="Êtes-vous sûr(e) ?";
                    echo "<li><b>Année ".nom_annee($annee_scolaire)." (<a href='".$_SERVER['PHP_SELF']."?action=supannee&amp;annee_supp=".$annee_scolaire."&annee=".$annee.add_token_in_url()."'   onclick=\"return confirm_abandon (this, 'yes', '$themessage')\">Supprimer toutes les données archivées pour cette année</a>)&nbsp;:<br /></b> ";
                    $sql="SELECT DISTINCT id,nom_court,annee FROM plugin_archAPB_classes WHERE annee=".$annee_scolaire." ORDER BY nom_court";
                    //echo "$sql<br />";
                    $res_classes=mysqli_query($GLOBALS["mysqli"], $sql);
                    if(mysqli_num_rows($res_classes)==0){
                            echo "Aucune classe???";
                    }
                    else{
                      $lig_classe=mysqli_fetch_object($res_classes);                      // nombre d'élèves qui ont des notes archivées
                      
                      echo $lig_classe->nom_court." ";

                      while($lig_classe=mysqli_fetch_object($res_classes)){
                        echo ", ".$lig_classe->nom_court;
                      }
                    }
                    echo "</li>\n";
            }
            echo "</ul>\n";
            echo "<p><br /></p>\n";

    }
} else {

      // si une action est requise
  if (isset($_GET['action'])) {
    $action=$_GET['action'];
    if (in_array($action, array("def","arch","sconetclasses","mefeleves","mefgroupes","supannee","nettoyage"))) {
      if (isset($annee)) {
        echo "<p class='bold'><a href=\"./index.php?annee=".$annee."\"><img src='../../images/icons/back.png' alt='Menu du plugin' class='back_link' /> Retour au menu du plugin</a></p>";
      }
      else {
        echo "<p class='bold'><a href=\"./index.php\"><img src='../../images/icons/back.png' alt='Menu du plugin' class='back_link' /> Retour au menu du plugin</a></p>";
      }
      include ("./".$action.".php");
    }


  // sinon, on affiche le menu
  } else {
    echo "<h3 class=\"Gepi\">Archivage pour ParcourSup <em>(Admission PostBac)</em> - Année ".$annee."</h3>";
    echo "<p class='bold'> <a href=\"./index.php\">Changer d'année</a></p>";
    
    // on teste si tous les élèves ont un PP
	$my_req="SELECT 1=1 FROM eleves e LEFT JOIN j_eleves_professeurs jep ON jep.login=e.login where jep.login is NULL"; 
	if(mysqli_num_rows(mysqli_query($GLOBALS["mysqli"], $my_req))!=0){
		echo "<p class='headerMessage bold'>ATTENTION&nbsp;: certains élèves n'ont pas de professeur principal dans GEPI. Un professeur principal doit obligatoirement être remonté dans ParcourSup. <br\> Veuillez vérifier que le problème ne concerne pas les classes remontées dans ParcourSup <br\> (<a href='../../classes/prof_suivi.php'>Accès au paramétrage prof principal</a>).</p>";
	}
	
	// on teste si tous les élèves ont un INE
	$my_req="SELECT DISTINCT e.*, jer.* FROM eleves e, classes c, j_eleves_classes jec, j_eleves_regime jer
		WHERE (e.elenoet='' OR e.no_gep='') AND
		jer.login=e.login AND
		jec.login=e.login AND
		c.id=jec.id_classe";
	if(mysqli_num_rows(mysqli_query($GLOBALS["mysqli"], $my_req))!=0) {
		echo "<p class='headerMessage bold'>ATTENTION&nbsp;: certains élèves n'ont pas d'INE dans GEPI. Les élèves n'ayant pas d'INE ne seront pas remontés dans ParcourSup. <br\> Veuillez vérifier que le problème ne concerne pas les élèves des classes de premières et terminales <br\> (<a href='../../eleves/index.php?quelles_classes=incomplet' target='_blank'>Obtenir la liste des élèves sans INE</a>).</p>";
	}

	$sql="SELECT distinct ine FROM plugin_archAPB_notes WHERE ine REGEXP '[0-9]{1,}[a-zA-Z]{1}$' AND annee='".$annee."';";
	$check_format_INE=mysqli_query($GLOBALS["mysqli"], $sql);
	if(mysqli_num_rows($check_format_INE)>0) {
		echo "<p class='headerMessage bold'>ATTENTION&nbsp;: certains élèves (".mysqli_num_rows($check_format_INE).") archivés ont un numéro INE à l'ancien format.<br />
		Ils risquent de ne pas être extraits dans le XML.<br />
		Vous devriez effectuer une <a href='../responsables/maj_import.php' target='_blank'>Mise à jour d'après Sconet</a> en cochant <strong>utiliser le nouveau champ INE</strong>.</p>";
	}

    //
    // On affiche ce qui est déjà archivé
    //
    $sql="SELECT DISTINCT annee FROM plugin_archAPB_classes ORDER BY annee";
    $res_annee=mysqli_query($GLOBALS["mysqli"], $sql);
    //if(){
    if(mysqli_num_rows($res_annee)==0) {
            echo "<p>Aucune année n'est encore sauvegardée.</p>\n";
    }
    else{
            echo "<p>Voici la liste des années sauvegardées&nbsp;:</p>\n";
            echo "<i>Note&nbsp;: Vous pouvez voir <a href=\"index_complet.php?annee=".$annee."\">le nombre d'élèves ayant des notes archivées dans le plugin en cliquant ici</a> (attention, cela peut être un peu long).</i>";
            echo "<ul>\n";
            while($lig_annee=mysqli_fetch_object($res_annee)){
                    $annee_scolaire=$lig_annee->annee;
                    $themessage="Êtes-vous sûr(e) ?";
                    if (isset($annee)) {
                      echo "<li><b>Année $annee_scolaire (<a href='".$_SERVER['PHP_SELF']."?action=supannee&amp;annee_supp=".$annee_scolaire."&annee=".$annee.add_token_in_url()."'   onclick=\"return confirm_abandon (this, 'yes', '$themessage')\">Supprimer toutes les données archivées pour cette année</a>)&nbsp;:<br /></b> ";
                    }
                    else {
                      echo "<li><b>Année $annee_scolaire (<a href='".$_SERVER['PHP_SELF']."?action=supannee&amp;annee_supp=".$annee_scolaire.add_token_in_url()."'   onclick=\"return confirm_abandon (this, 'yes', '$themessage')\">Supprimer toutes les données archivées pour cette année</a>)&nbsp;:<br /></b> ";
                    }
                    $sql="SELECT DISTINCT id,nom_court FROM plugin_archAPB_classes WHERE annee=".$annee_scolaire;
                    $res_classes=mysqli_query($GLOBALS["mysqli"], $sql);
                    if(mysqli_num_rows($res_classes)==0){
                            echo "Aucune classe???";
                    }
                    else{
                      $lig_classe=mysqli_fetch_object($res_classes);                      // nombre d'élèves qui ont des notes archivées
                      echo $lig_classe->nom_court;

                      while($lig_classe=mysqli_fetch_object($res_classes)){
                        echo ", ".$lig_classe->nom_court;
                      }
                    }
                    echo "</li>\n";
            }
            echo "</ul>\n";
            echo "<p><br /></p>\n";

    }
    //
    // le menu himself
    //
    echo "<h3>Menu</h3>";
    echo "<p>Pour utiliser ce module, vous aurez besoin des fichiers Sconet suivants&nbsp;: <strong>Structures.xml</strong>, <strong>Nomenclature.xml</strong> et <strong>ElevesSansAdresses.xml</strong></p>";

    echo "<p>La procédure d'archivage va se dérouler en plusieurs étapes&nbsp;: </p>";
    echo "<p><a href=\"index.php?action=def&annee=".$annee.add_token_in_url()."\">-->Cliquez ici pour commencer par l'étape 1 (!!!)</a></p>";

	echo "<h3>Dès la fin du 1<sup>er</sup> trimestre&nbsp;:</h3>
	<div style='margin-left:3em;'>
	<p>Vous pouvez effectuer les opérations suivantes assez tôt dans l'année <em>(sauf l'archivage qui doit attendre la fin du 1er trimestre)</em>.</p>";

    echo "<ol>
        <li><a href=\"index.php?action=def&annee=".$annee.add_token_in_url()."\">Definition des classes de premi&egrave;re et terminale</a></li>
        <li><a href=\"index.php?action=sconetclasses&annee=".$annee.add_token_in_url()."\">Association des nomenclatures Sconet aux classes</a></li>
        <li><a href=\"index.php?action=mefeleves&annee=".$annee.add_token_in_url()."\">Association des élèves aux MEF de Sconet</a></li>
        <li><a href=\"index.php?action=mefgroupes&annee=".$annee.add_token_in_url()."\">Association des nomenclatures Sconet aux groupes</a></li>
        <li><a href=\"index.php?action=arch&annee=".$annee.add_token_in_url()."\">Archivage des donn&eacute;es</a> <em title=\"il sera refait/complété en fin de 2è trimestre\">(facultatif)</em></li>
        <!--
           <li><a href=\"index_export.php?annee=".$annee.add_token_in_url()."\">Export vers ParcourSup</a></li>
        -->
      </ol>
      <p>Vous pouvez également récupérer un <a href=\"index.php?action=arch&step=2&annee=".$annee.add_token_in_url()."\">fichier de sauvegarde</a>.</p>
      <br />
      <p>Aucun export vers ParcourSup n'est plus requis en fin de 1er trimestre.<br />
      Un seul export sera effectué en fin de 2è trimestre pour les Terminales.<br />
      Et un deuxième export en fin de 3è trimestre pour les Premières.</p>
      </div>";

	echo "<h3>À la fin du 2<sup>ème</sup> trimestre&nbsp;:</h3>";
	echo "
	<div style='margin-left:3em;'>
	<p>Recommencer les étapes suivantes&nbsp;:</p>";
	echo "<ol start=5>
		<li><a href=\"index.php?action=arch&annee=".$annee.add_token_in_url()."&num_export=2\">Archivage des donn&eacute;es</a><br />
		Les périodes 1 et 2 seront archivées <em>(les corrections éventuelles sur la période 1 écraseront un éventuel précédent archivage)</em></li>
        <li><a href=\"index_export.php?annee=".$annee.add_token_in_url()."&num_export=12\">Export vers ParcourSup</a> des deux premières périodes de terminale
      </ol>
      </div>";

	echo "<h3>À la fin du 3<sup>ème</sup> trimestre&nbsp;:</h3>";
	echo "
	<div style='margin-left:3em;'>
	<p>Recommencer les étapes suivantes&nbsp;:</p>";
	echo "<ol start=5>
		<li><a href=\"index.php?action=arch&niveau=premiere&annee=".$annee.add_token_in_url()."\">Archivage des donn&eacute;es</a></li>
        <li><a href=\"index_export1eres.php?annee=".$annee.add_token_in_url()."\">Export des classes de première vers ParcourSup</a>
      </ol>
      </div>";

	echo "<h3>À tout moment de l'année&nbsp;:</h3>";
	echo "
	<div style='margin-left:3em;'>
	<ul>
		<li><a href=\"index.php?action=arch&step=2&annee=".$annee.add_token_in_url()."\">Récupérer un fichier de sauvegarde.</a></li>
        <li><a href=\"index.php?action=nettoyage&annee=".$annee.add_token_in_url()."\">Supprimer les données des élèves ayant quitté l'établissement.</a></li>
      </ul>
      </div>";

  }

}

    require_once("../../lib/footer.inc.php");

?>
