<?php

/**
 * Fichier index.php pour l'archivage pour APB
 *
 * Copyright 2010 Jerome Etheve
 *
 * This file is part of archivageAPB, a plugin for GEPI.
 *
 * GEPI is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Archivage APB is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GEPI; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

$titre_page = "Archivage ParcourSup";
$affiche_connexion = 'yes';
$niveau_arbo = "2";


// ===============================================================
//
//                  IMPORTATION DES FONCTIONS
//
// ===============================================================
include("../../lib/initialisations.inc.php");

// TESTS DE SECURITE
$resultat_session = $session_gepi->security_check();
if ($resultat_session == 'c') {
	header("Location: ../utilisateurs/mon_compte.php?change_mdp=yes");
	die();
} else if ($resultat_session == '0') {
	header("Location: ../logout.php?auto=1");
	die();
}

    require_once("../../lib/header.inc.php");
    require_once("./apb_classes.php");

echo "<p class='bold'><a href='../../accueil.php'>Accueil</a></p>";

// On va uploader les fichiers XML dans le tempdir de l'utilisateur (administrateur, ou scolarité)
	$tempdir=get_user_temp_directory();

$annee=isset($_POST['annee']) ? $_POST['annee'] : (isset($_GET['annee']) ? $_GET['annee'] : NULL);


if (!isset($annee)) { 
  $annee_actu=intval(strftime("%Y"));
echo "<p>Avant d'utiliser ce module, il est recommandé de lire la
      <a href='http://www.sylogix.org/projects/gepi/wiki/RefDoc_APB'>documentation située sur le wiki de GEPI</a></p>";
echo "<h2>Sélection de l'année :</h2>";
echo "<p>Veuillez selectionner l'année qui va être archivée.
      </p>";
   echo "<form enctype='multipart/form-data' action='".$_SERVER['PHP_SELF']."' method='post'>\n";
        echo "<select name='annee'>\n";
        // on essaie d'afficher automatiquement l'annee d'archivage
        $mois_actu=intval(strftime("%m"));
        if ($mois_actu>=8 AND $mois_actu<=12) {
          $annee_ref=$annee_actu+1;
        } else {
          $annee_ref=$annee_actu;
        }
        for ($i=0;$i<3;$i++) {
          $an=$annee_actu-1+$i;
          echo "<option value=".$an;
          if ($an==$annee_ref) { echo " selected"; }
          echo ">".nom_annee($an)."</option>";
        }
        echo "</select>";
        echo "<input type='hidden' name='is_posted' value='yes' />\n";
        echo "<p><input type='submit' value='Valider' /></p>\n";
        echo "</form>\n";
        echo "<br/><p>*Seront archivées les classes de première pour être exploitées l'année prochaine, ainsi que les classes de terminale,
              pour l'export APB de cette année et exploitation l'année prochaine (redoublants). </p>
              <p>En fait, le plugin mémorise toutes les données dont il a besoin pour ensuite les exploiter dans la dernière phase, ou l'année suivante.</p>";
//
    // On affiche ce qui est déjà archivé
    //
    $sql="SELECT DISTINCT annee FROM plugin_archAPB_classes ORDER BY annee";
    $res_annee=mysqli_query($GLOBALS["mysqli"], $sql);
    //if(){
    if(mysqli_num_rows($res_annee)==0){
            echo "<p>Aucune année n'est encore sauvegardée.</p>\n";
    }
    else{
            echo "<h2>Voici la liste des années sauvegardées&nbsp;:</h2>\n";
            echo "<i>Note : Entre parenthèses, figure le nombre d'élèves ayant des notes archivées dans le plugin.</i>";
            echo "<ul>\n";
            while($lig_annee=mysqli_fetch_object($res_annee)){
                    $annee_scolaire=$lig_annee->annee;
                    $themessage="Êtes-vous sûr(e) ?";
                    echo "<li><b>Année ".nom_annee($annee_scolaire)." (<a href='".$_SERVER['PHP_SELF']."?action=supannee&amp;annee_supp=".$annee_scolaire."&annee=".$annee.add_token_in_url()."'   onclick=\"return confirm_abandon (this, 'yes', '$themessage')\">Supprimer toute les données archivées pour cette année</a>) :<br /></b> ";
                    $sql="SELECT DISTINCT id,nom_court,annee FROM plugin_archAPB_classes WHERE annee=".$annee_scolaire." ORDER BY nom_court";
                    $res_classes=mysqli_query($GLOBALS["mysqli"], $sql);
                    if(mysqli_num_rows($res_classes)==0){
                            echo "Aucune classe???";
                    }
                    else{
                      $lig_classe=mysqli_fetch_object($res_classes);                      // nombre d'élèves qui ont des notes archivées
                      $req_el=mysqli_query($GLOBALS["mysqli"], "SELECT COUNT(DISTINCT(n.ine)) nb FROM plugin_archAPB_notes n, plugin_archAPB_eleves e WHERE n.ine=e.ine AND e.id_classe=".$lig_classe->id." AND e.annee=".$annee_scolaire." AND n.trimestre=1");
                      $nombre = mysqli_fetch_object($req_el);
                      $nombre = $nombre->nb;
                      $req_el=mysqli_query($GLOBALS["mysqli"], "SELECT COUNT(DISTINCT(n.ine)) nb FROM plugin_archAPB_notes n, plugin_archAPB_eleves e WHERE n.ine=e.ine AND e.id_classe=".$lig_classe->id." AND e.annee=".$annee_scolaire." AND n.trimestre=2");
                      $nombre2 = mysqli_fetch_object($req_el);
                      $nombre2 = $nombre2->nb;
                      $req_el=mysqli_query($GLOBALS["mysqli"], "SELECT COUNT(DISTINCT(n.ine)) nb FROM plugin_archAPB_notes n, plugin_archAPB_eleves e WHERE n.ine=e.ine AND e.id_classe=".$lig_classe->id." AND e.annee=".$annee_scolaire." AND n.trimestre=3");
                      $nombre3 = mysqli_fetch_object($req_el);
                      $nombre3 = $nombre3->nb;
                      echo $lig_classe->nom_court." (".$nombre."-".$nombre2."-".$nombre3.")";

                      while($lig_classe=mysqli_fetch_object($res_classes)){
                        $req_el=mysqli_query($GLOBALS["mysqli"], "SELECT COUNT(DISTINCT(n.ine)) nb FROM plugin_archAPB_notes n, plugin_archAPB_eleves e WHERE n.ine=e.ine AND e.id_classe=".$lig_classe->id." AND e.annee=".$annee_scolaire." AND n.trimestre=1");
                        $nombre = mysqli_fetch_object($req_el);
                        $nombre = $nombre->nb;
                        $req_el=mysqli_query($GLOBALS["mysqli"], "SELECT COUNT(DISTINCT(n.ine)) nb FROM plugin_archAPB_notes n, plugin_archAPB_eleves e WHERE n.ine=e.ine AND e.id_classe=".$lig_classe->id." AND e.annee=".$annee_scolaire." AND n.trimestre=2");
                        $nombre2 = mysqli_fetch_object($req_el);
                        $nombre2 = $nombre2->nb;
                        $req_el=mysqli_query($GLOBALS["mysqli"], "SELECT COUNT(DISTINCT(n.ine)) nb FROM plugin_archAPB_notes n, plugin_archAPB_eleves e WHERE n.ine=e.ine AND e.id_classe=".$lig_classe->id." AND e.annee=".$annee_scolaire." AND n.trimestre=3");
                        $nombre3 = mysqli_fetch_object($req_el);
                        $nombre3 = $nombre3->nb;
                        echo ", ".$lig_classe->nom_court." (".$nombre."-".$nombre2."-".$nombre3.")";
                      }
                    }
                    echo "</li>\n";
            }
            echo "</ul>\n";
            echo "<p><br /></p>\n";

    }
} else {

      // si une action est requise
  if (isset($_GET['action'])) {
    $action=$_GET['action'];
    if (in_array($action, array("def","arch","sconetclasses","mefeleves","mefgroupes","supannee"))) {
      if (isset($annee)) {
        echo "<p class='bold'><a href=\"./index.php?annee=".$annee."\"><img src='../../images/icons/back.png' alt='Menu du plugin' class='back_link' /> Retour au menu du plugin</a></p>";
      }
      else {
        echo "<p class='bold'><a href=\"./index.php\"><img src='../../images/icons/back.png' alt='Menu du plugin' class='back_link' /> Retour au menu du plugin</a></p>";
      }
      include ("./".$action.".php");
    }


  // sinon, on affiche le menu
  } else {
    echo "<h3 class=\"Gepi\">Archivage pour Admission PostBac - Année ".$annee."</h3>";
    echo "<p class='bold'> <a href=\"./index.php\">Changer d'année</a></p>";
    //
    // On affiche ce qui est déjà archivé
    //
    $sql="SELECT DISTINCT annee FROM plugin_archAPB_classes ORDER BY annee";
    $res_annee=mysqli_query($GLOBALS["mysqli"], $sql);
    //if(){
    if(mysqli_num_rows($res_annee)==0){
            echo "<p>Aucune année n'est encore sauvegardée.</p>\n";
    }
    else{
            echo "<p>Voici la liste des années sauvegardées&nbsp;:</p>\n";
            echo "<i>Note : Entre parenthèses, figure le nombre d'élèves ayant des notes archivées dans le plugin.</i>";
            echo "<ul>\n";
            while($lig_annee=mysqli_fetch_object($res_annee)){
                    $annee_scolaire=$lig_annee->annee;
                    $themessage="Êtes-vous sûr(e) ?";
                    if (isset($annee)) {
                      echo "<li><b>Année $annee_scolaire (<a href='".$_SERVER['PHP_SELF']."?action=supannee&amp;annee_supp=".$annee_scolaire."&annee=".$annee.add_token_in_url()."'   onclick=\"return confirm_abandon (this, 'yes', '$themessage')\">Supprimer toute les données archivées pour cette année</a>) :<br /></b> ";
                    }
                    else {
                      echo "<li><b>Année $annee_scolaire (<a href='".$_SERVER['PHP_SELF']."?action=supannee&amp;annee_supp=".$annee_scolaire.add_token_in_url()."'   onclick=\"return confirm_abandon (this, 'yes', '$themessage')\">Supprimer toute les données archivées pour cette année</a>) :<br /></b> ";
                    }
                    $sql="SELECT DISTINCT id,nom_court FROM plugin_archAPB_classes WHERE annee=".$annee_scolaire;
                    $res_classes=mysqli_query($GLOBALS["mysqli"], $sql);
                    if(mysqli_num_rows($res_classes)==0){
                            echo "Aucune classe???";
                    }
                    else{
                      $lig_classe=mysqli_fetch_object($res_classes);                      // nombre d'élèves qui ont des notes archivées
                      $req_el=mysqli_query($GLOBALS["mysqli"], "SELECT COUNT(DISTINCT(n.ine)) nb FROM plugin_archAPB_notes n, plugin_archAPB_eleves e WHERE n.ine=e.ine AND e.id_classe=".$lig_classe->id." AND e.annee=".$annee_scolaire." AND n.trimestre=1");
                      $nombre = mysqli_fetch_object($req_el);
                      $nombre = $nombre->nb;
                      $req_el=mysqli_query($GLOBALS["mysqli"], "SELECT COUNT(DISTINCT(n.ine)) nb FROM plugin_archAPB_notes n, plugin_archAPB_eleves e WHERE n.ine=e.ine AND e.id_classe=".$lig_classe->id." AND e.annee=".$annee_scolaire." AND n.trimestre=2");
                      $nombre2 = mysqli_fetch_object($req_el);
                      $nombre2 = $nombre2->nb;
                      $req_el=mysqli_query($GLOBALS["mysqli"], "SELECT COUNT(DISTINCT(n.ine)) nb FROM plugin_archAPB_notes n, plugin_archAPB_eleves e WHERE n.ine=e.ine AND e.id_classe=".$lig_classe->id." AND e.annee=".$annee_scolaire." AND n.trimestre=3");
                      $nombre3 = mysqli_fetch_object($req_el);
                      $nombre3 = $nombre3->nb;
                      echo $lig_classe->nom_court." (".$nombre."-".$nombre2."-".$nombre3.")";

                      while($lig_classe=mysqli_fetch_object($res_classes)){
                        $req_el=mysqli_query($GLOBALS["mysqli"], "SELECT COUNT(DISTINCT(n.ine)) nb FROM plugin_archAPB_notes n, plugin_archAPB_eleves e WHERE n.ine=e.ine AND e.id_classe=".$lig_classe->id." AND e.annee=".$annee_scolaire." AND n.trimestre=1");
                        $nombre = mysqli_fetch_object($req_el);
                        $nombre = $nombre->nb;
                        //echo "SELECT COUNT(DISTINCT(n.ine)) nb FROM plugin_archAPB_notes n, plugin_archAPB_eleves e WHERE n.ine=e.ine AND e.id_classe=".$lig_classe->id." AND n.annee=".$annee_scolaire." AND n.trimestre=2";
                        $req_el=mysqli_query($GLOBALS["mysqli"], "SELECT COUNT(DISTINCT(n.ine)) nb FROM plugin_archAPB_notes n, plugin_archAPB_eleves e WHERE n.ine=e.ine AND e.id_classe=".$lig_classe->id." AND e.annee=".$annee_scolaire." AND n.trimestre=2");
                        $nombre2 = mysqli_fetch_object($req_el);
                        $nombre2 = $nombre2->nb;
                        $req_el=mysqli_query($GLOBALS["mysqli"], "SELECT COUNT(DISTINCT(n.ine)) nb FROM plugin_archAPB_notes n, plugin_archAPB_eleves e WHERE n.ine=e.ine AND e.id_classe=".$lig_classe->id." AND e.annee=".$annee_scolaire." AND n.trimestre=3");
                        $nombre3 = mysqli_fetch_object($req_el);
                        $nombre3 = $nombre3->nb;
                        echo ", ".$lig_classe->nom_court." (".$nombre."-".$nombre2."-".$nombre3.")";
                      }
                    }
                    echo "</li>\n";
            }
            echo "</ul>\n";
            echo "<p><br /></p>\n";

    }
    //
    // le menu himself
    //
    echo "<h3>Menu</h3>";
    echo "<p>Pour utiliser ce module, vous aurez besoin des fichiers Sconet suivants : Structures.xml, Nomenclature.xml et ElevesSansAdresses.xml</p>";

    echo "<p>La procédure d'archivage va se dérouler en 5 étapes : </p>";
    echo "<p><a href=\"index.php?action=def&annee=".$annee.add_token_in_url()."\">-->Cliquez ici pour commencer par l'étape 1 (!!!)</a></p>";


    echo "<ol>
        <li><a href=\"index.php?action=def&annee=".$annee.add_token_in_url()."\">Definition des classes de premi&egrave;re et terminale</a></li>
        <li><a href=\"index.php?action=sconetclasses&annee=".$annee.add_token_in_url()."\">Association des nomenclatures Sconet aux classes</a></li>
        <li><a href=\"index.php?action=mefeleves&annee=".$annee.add_token_in_url()."\">Association des élèves aux MEF de Sconet.</a></li>
        <li><a href=\"index.php?action=mefgroupes&annee=".$annee.add_token_in_url()."\">Association des nomenclatures Sconet aux groupes</a></li>
        <li><a href=\"index.php?action=arch&annee=".$annee.add_token_in_url()."\">Archivage des donn&eacute;es</a></li>
        <p></p>
        <li><a href=\"index_export.php?annee=".$annee.add_token_in_url()."\">Export vers APB</a></li>
      </ol>";

	if((strtoupper(substr(PHP_OS,0,3))!='WIN')||(file_exists("../../gestion/mysqldump.exe"))) {
		echo "
	<p>Vous pouvez également récupérer un <a href=\"index.php?action=arch&step=2&annee=".$annee.add_token_in_url()."\">fichier de sauvegarde</a>.</p>";
	}

  }

}

    require_once("../../lib/footer.inc.php");

?>
