<?php

/*
*
* Copyright 2014-2018 Régis Bouguin, Stephane Boireau
*
* This file is part of GEPI.
*
* GEPI is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 3 of the License, or
* (at your option) any later version.
*
* GEPI is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with GEPI; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

//**************************************************
////********* tester la présence du plugin *********
//**************************************************
$APBinstalle = APBinstalle();

$competences = extraitCompetences();
$classes = extraitClasses($anneeScolaire);
$debug=false;
if($debug) {
	echo "\$classes = extraitClasses($anneeScolaire);<br />";
}

$formations = extraitFormations($anneeAPB);

if(isset($_SESSION['choixFormation']) && $_SESSION['choixFormation']) {
	$programmes = extraitProgrammes($_SESSION['choixFormation']);
} else {
	$programmes = NULL;
}

//Mise à jour plugin_lsl_formations à partir de nomenclatures_valeurs 
if($formations) {
	MaJFormations($formations);
}
$formations = extraitFormations($anneeAPB);

$tab_mef=get_tab_mef();

if(isset($msg)) {
	echo "<div style='text-align:center;margin:1em;;padding:0.5em;' class='fieldset_opacite50'>".$msg."</div>";
}

if (!$APBinstalle || 0 == $APBinstalle->num_rows ) {
?>

<p class="center rouge grand bold" >
	Vous devez avoir installé et ouvert le plugin APB avant d'utiliser ce plugin.
</p>
	<?php
} else {
?>

<p class="center rouge grand" >
	Les données utilisées sont celles du plugin APB.
	<br />
	Vous devez avoir effectué les extractions du 3<sup>ème</sup> trimestre 
	avant de créer le fichier .xml à importer dans LSL.
</p>

<fieldset class='fieldset_opacite50'>
	<legend>Télécharger les programmes</legend>

	<fieldset>
		<legend>Choisissez la formation à afficher</legend>
		<form method="post" action="index.php" id="form_LSL_select_Programme" enctype="multipart/form-data">
			<div class='fieldset_opacite50' style='padding:0.5em; margin-bottom:1em;'>
			<p style="text-align:center;">
				<?php if (function_exists("add_token_field")) {echo add_token_field(); } ?>
				<br />
				<select name="selectClasse" onchange="submit()">
					<option value="">Choisissez une formation</option>
<?php while ($obj = $formations->fetch_object()) { ?>
					<option value="<?php echo $obj->code_mef; ?>"
<?php if (isset($_SESSION['choixFormation']) && $_SESSION['choixFormation'] == $obj->code_mef) { ?>
							selected="selected"
<?php } ?>
							>
						<?php echo $obj->code_mef; ?> - <?php echo $obj->edition; ?>
					</option>
<?php } ?>
				</select>
				<button name="choixClasse" value="y">
					Choisir
				</button>
			</p>
			</div>
		</form>

	<form method="post" action="index.php" id="form_LSL_select_Programme" enctype="multipart/form-data">
	<div class='fieldset_opacite50' style='padding:0.5em; margin-bottom:1em;'>
	<table class="boireaus sortable resizable"
		   id="tableProgrammes">
		<tr>
			<th>MEF de rattachement</th>
			<th>Matière</th>
			<th>Modalité</th>
			<th>Note obligatoire</th>
			<th>Appreciation obligatoire</th>
			<th>Libellé</th>
			<th>Supprimer</th>
		</tr>
	<?php 
		$cpt =1; 
		if ($programmes) {
			while ($programme = $programmes->fetch_object()) {
	?>
		<tr class="lig<?php echo $cpt; ?>">
			<td><?php echo $programme->formation ?></td>
			<td><?php echo $programme->matiere ?></td>
			<td><?php echo $programme->Modalite ?></td>
			<td><?php echo $programme->note ?></td>
			<td><?php echo $programme->appreciation ?></td>
			<td style="text-align:left;"><?php echo $programme->annee ?> → <?php echo $programme->option ?></td>
			<td>

<?php if ('administrateur' == $_SESSION['statut'] 
   && (($_SESSION['choixFormation'] == $programme->formation) && LSL_peut_supprimer($programme->matiere, $programme->Modalite)) ){ ?>
				<input type="checkbox" name="supprime" value="<?php echo $programme->id ?>" />
<?php } ?>
			</td>
		</tr>
	<?php
		$cpt*=-1;
			}
			reset($programmes);
		}
	?>

	</table>

<?php if ('administrateur' == $_SESSION['statut']){ ?>
		<p style="text-align:center; margin-top: .5em;">
			<button name="supprimeAssociation" value="y" >Supprimer les associations cochées</button>
		</p>
<?php } ?>
		</div>
	</fieldset>

 <?php /* ?>
	<fieldset>
	<legend>Importer les programmes</legend>
	<form method="post" action="index.php" id="form_LSL_Programme" enctype="multipart/form-data">
		<p>
			Pour créer les programmes par MEF, importez le fichier nomenclature.xml ou un fichier avec la même structure.
		</p>
		<p>
			Ce fichier peut-être compressé (ExportXML_Nomenclature.zip)
		</p>
		<p class="rouge">
			Attention dans nomenclature.xml, 
			le caractère obligatoire ou pas des notes et appréciations n'est pas renseigné.
			Vous devez le renseigner manuellement
		</p>
		<p>
			<?php if (function_exists("add_token_field")) {echo add_token_field(); } ?>
			<input type="file" name="fileToUpload" id="fileToUpload">
			<button name="uploadProgramme" id="uploadFichier" value="y">Télécharger</button>
		</p>
	</form>
	</fieldset>
	<p style="margin:1em; font-size: larger;">
		La plupart des matières qui doivent apparaître dans le livret scolaire sont prédéfinies 
		mais il vous appartient de vérifier que toutes les langues vivantes enseignées dans votre établissement 
		sont bien présentes et au besoin d'ajouter celles qui manquent.
	</p>
 <?php /* */ ?>

 <?php if (!$formations->num_rows) {  ?>
	<p class="center rouge grand bold" >
            Aucune formation n'a été trouvée, soit vous n'avez pas effectué les extractions dans le module APB soit il y a eu un problème lors
            de l'initialisation du plugin.
        </p>
        <p class="center rouge grand bold" >
            Vous devez initialiser le module, désinstallez puis réinstallez le plugin. Attention, les appréciations déjà saisies l'année dernière
            sont perdues lors de cette manœuvre.
        </p>
        <p class="center rouge grand bold" >
            Les données exportées l'année dernière vers LSL devraient être conservée dans LSL
        </p>
        <p class="center rouge grand bold" >
            Vous pouvez aussi mettre à jour la structure des tables au besoin,
            puis récupérer et exécuter les requêtes d'initialisation présentes dans mod_plugins/livretscolaire/plugin.xml.
        </p>
        <p class="center rouge grand bold" >		 
            Ceci permet d'initialiser sans détruire les données mais est beaucoup plus compliqué.
        </p>
<?php } else { ?>

<?php if ('administrateur' == $_SESSION['statut']){ ?>
<?php if (isset($_SESSION['choixFormation']) && $_SESSION['choixFormation'] && LSL_est_maitre($_SESSION['choixFormation'])) { ?>
	<fieldset class='fieldset_opacite50'>
	<legend>Créer/modifier les programmes</legend>
	<form method="post" action="index.php" id="form_LSL_Programme" enctype="multipart/form-data">
		<p class="center">
			Pour créer ou modifier une association pour le MEF : <?php echo $_SESSION['choixFormation']; ?> , 
			saisissez la ci-dessous
		</p>
		<p>
		<?php if (function_exists("add_token_field")) {echo add_token_field(); } ?>
		MEF : <?php echo $_SESSION['choixFormation']; ?>
		<input type="hidden" name="creerMEF" value="<?php echo $_SESSION['choixFormation']; ?>" />
		— Matière :
		<input type="text" style="width:4em;" name="creerMatiere" />
		— Modalité :
		<select name="creerModalite">
			<option value="S">Obligatoire (S)</option>
			<option value="F">Facultatif (F)</option>
			<option value="O">Option (O)</option>
		</select>

		— Note obligatoire dans le livret :
		<select name="creerNote">
			<option value="y">Oui</option>
			<option value="n">Non</option>
		</select>
		— Appréciation obligatoire dans le livret 
		<select name="creerAppreciation">
			<option value="y">Oui</option>
			<option value="n">Non</option>
		</select>
		<br />
		— Commentaires :
		<input type="text" name="creerOption" />
		</p>
		<p class="center">
			<button name="creeModifie" value="y">
				Créer/Modifier une association
			</button>
		</p>
	</form>
	</fieldset>

	<fieldset class='fieldset_opacite50'>
		<legend>Créer/modifier un rattachement de MEF</legend>
		<form method="post" action="index.php" id="form_LSL_Rattachement" enctype="multipart/form-data">
			<p class="center">
			Pour créer ou modifier un rattachement au MEF : <?php echo $_SESSION['choixFormation']; ?> , 
			saisissez le ci-dessous.
			</p>
			<p>
				<?php if (function_exists("add_token_field")) {echo add_token_field(); } ?>
				MEF de rattachement : <?php echo $_SESSION['choixFormation']; ?>
				<input type="hidden" name="MEF_rattachement" value="<?php echo $_SESSION['choixFormation']; ?>" />
				— Année :
				<input type="text" name="annee" size="4"/>
				— MEF à rattacher : 
				<input type="text" name="MEF" size="11"/>
				<br/>
				— Édition : 
				<input type="text" name="edition"/>
				<br/>
				— Libellé :  
				<input type="text" name="libelle"/>
			</p>
			<p class="center">
				<button name="rattachement" value="y">
					Créer/Modifier un rattachement
				</button>
			</p>

		</form>
	</fieldset>
<?php } ?>
<?php } ?>

</fieldset>

<fieldset class='fieldset_opacite50' <?php if (!lsl_getDroit('droitCompetences')) { ?> 
	style="display : none;"
<?php } ?>	>
	<legend>Télécharger les définitions des compétences</legend>
	<form method="post" action="index.php" id="form_LSL_competences" enctype="multipart/form-data">
		<div class='fieldset_opacite50' style='padding:0.5em; margin-bottom:1em;'>
			Chaque ligne du fichier doit contenir 2 colonnes séparées par un point virgule : CODE_COMPETENCE ; LIBELLE_COMPETENCE
			<br />
			La première ligne n'est pas traitée. Vous pouvez voir les compétences déjà saisies en cliquant sur <span style="cursor:pointer; font-weight:bold" onclick="bascule('tableCompetences');">Tableau des compétences</span>
			<br /><br />
			<p>
				<?php if (function_exists("add_token_field")) {echo add_token_field(); } ?>
				<input type="file" name="fileToUpload" id="fileToUpload">
				<input type="submit" name="uploadFichier" id="uploadFichier" value="télécharger">
			</p>
		</div>
	</form>
	<?php
		if ($competences->num_rows) { 
			$tab_competence=array();
	?>
	<p title="Cliquez pour afficher/masquer le tableau" 
	   onclick="bascule('tableCompetences');"
	   class="center grand bold"
		   style="cursor:pointer" >
		Tableau des compétences
		 <img src='../../images/icons/visible.png' class='icone16' />
	</p>
	<table class="boireaus boireaus_alt sortable resizable"
		   id="tableCompetences"
		   style="display:none;">
		<tr>
			<th style='text-align:left'>
				code
			</th>
			<th style='text-align:left'>
				Compétence
			</th>
		</tr>
	<?php 
		$cpt =1; 
		while ($obj = $competences->fetch_object()) {
	?>

		<tr>
			<td style='text-align:left'>
				<?php 
					echo $obj->code_competences; 
					$tab_competence[$obj->code_competences]=$obj->texte_competences;
				?>
			</td style='text-align:left'>
			<td id="competences_<?php echo $obj->code_competences; ?>">
				<?php echo $obj->texte_competences; ?>
			</td>
		</tr>
	<?php
		$cpt*=-1;
		}
	?>
	</table>

	<?php
			$tab_matiere=array();
			$sql="SELECT * FROM nomenclatures_valeurs WHERE type='matiere' AND nom='libelle_edition' ORDER BY valeur;";
			//echo "$sql<br />";
			$res_mat=mysqli_query($mysqli, $sql);
			if(mysqli_num_rows($res_mat)>0) {
				while($lig_mat=mysqli_fetch_object($res_mat)) {
					$tab_matiere[$lig_mat->code]=$lig_mat->valeur;
				}
			}
			$tab_matiere['030001']='LV1';
			$tab_matiere['030002']='LV2';
			$tab_matiere['030003']='LV3';
			$tab_matiere['030004']='LV4';

			$sql="SELECT DISTINCT matiere, option FROM plugin_lsl_programmes WHERE annee='".$anneeScolaire."' ORDER BY matiere;";
			//echo "$sql<br />";
			$res_mat=mysqli_query($mysqli, $sql);
			if(mysqli_num_rows($res_mat)>0) {
				while($lig_mat=mysqli_fetch_object($res_mat)) {
					if(!isset($tab_matiere[$lig_mat->matiere])) {
						$tab_matiere[$lig_mat->matiere]=$lig_mat->option;
					}
				}
			}
	?>

	<p title="Cliquez pour afficher/masquer le tableau
(soyez patient, l'affichage/masquage est un peu long pour ce tableau)." 
	   onclick="bascule('tableCorrespondances');bascule('p_suppr_assoc_mef_matiere_competence')"
	   class="center grand bold"
		   style="cursor:pointer" >
		Compétences par MEF
		 <img src='../../images/icons/visible.png' class='icone16' />
	</p>
	<form method="post" action="index.php" id="form_LSL_correspondances" enctype="multipart/form-data" >
		<div class='fieldset_opacite50' style='padding:0.5em; margin-bottom:1em;'>
		<p class="center">
			<?php if (function_exists("add_token_field")) {echo add_token_field(); } ?>
			<input type='hidden' name='lsl_annee' value='<?php echo $anneeScolaire;?>'>
			Nouvelle association MEF ←→ compétence
		</p>
		<p>
			MEF 
			<select name='lsl_mef'>
				<option value=''>---</option>
				<?php
					foreach($tab_mef as $code_mef => $current_mef) {
						$selected='';
						if((isset($_POST['lsl_mef']))&&($_POST['lsl_mef']==$code_mef)) {
							$selected=' selected';
						}
						echo "
				<option value='".$code_mef."'".$selected.">".$current_mef['designation_courte']."</option>";
					}
				?>
			</select><br />
			Matière 
			<select name="lsl_matiere">
				<option value=''>---</option>
				<?php
					foreach($tab_matiere as $code_matiere => $current_matiere) {
						$selected='';
						if((isset($_POST['lsl_matiere']))&&($_POST['lsl_matiere']==$code_matiere)) {
							$selected=' selected';
						}
						echo "
				<option value='".$code_matiere."'".$selected.">".$current_matiere."</option>";
					}
				?>
			</select>
			Modalité 
			<select name="lsl_modalite">
				<option value=''>---</option>
				<?php
					foreach($tab_modalites_election_par_defaut as $code_modalite_elect => $current_modalite) {
						$selected='';
						if((isset($_POST['lsl_modalite']))&&($_POST['lsl_modalite']==$code_modalite_elect)) {
							$selected=' selected';
						}
						echo "
				<option value='".$code_modalite_elect."'".$selected." title=\"".$current_modalite["libelle_long"]."\">".$code_modalite_elect."</option>";
					}
				?>
			</select><br />

			Compétence 
			<select name="lsl_code">
				<option value=''>---</option>
				<?php
					foreach($tab_competence as $code_competences => $current_competence) {
						$selected='';
						if((isset($_POST['lsl_code']))&&($_POST['lsl_code']==$code_modalite_elect)) {
							$selected=' selected';
						}
						echo "
				<option value='".$code_competences."'".$selected.">".$code_competences.'. '.$current_competence."</option>";
					}
				?>
			</select><br />
			<!--
			<input type="text" 
				   name="lsl_code" 
				   id="lsl_code_competence" 
				   style="width:4em;" 
				   onblur="afficheCompetences(getElementById('lsl_code_competence').value);"/> 
			Code compétence 
			-->
		</p>
		<p>
			<input type="submit" name="creeCorrespondance" id="creeCorrespondance" value="Créer">
		</p>
		</div>
	</form>

	<form method="post" action="index.php" id="form_LSL_Rattachement" enctype="multipart/form-data">
		<div class='fieldset_opacite50'>
			<?php if (function_exists("add_token_field")) {echo add_token_field(); } ?>
	<table class="boireaus boireaus_alt sortable resizable"
		   id="tableCorrespondances"
		   style="display:none;">
		<tr>
			<th>
				MEF
			</th>
			<!--th>
				Regroupement
			</th-->
			<th>
				Code compétence
			</th>
			<th>
				Compétence
			</th>
			<th>
				Modalité
			</th>
			<th>
				Matière
			</th>
			<th>
				Année
			</th>
			<th>
				Supprimer
			</th>
		</tr>
		<?php
			// A FAIRE : 20180827 A compléter en parsant plugin_lsl_competences_matieres

/*
MariaDB [gepi173]> select * from plugin_lsl_competences_matieres limit 5;
+----+-------------+------------------+----------+---------+-------+
| id | MEF         | code_competences | modalite | matiere | annee |
+----+-------------+------------------+----------+---------+-------+
|  1 | 21133104110 | 0206             | S        | 061300  | 2016  |
|  2 | 21133104110 | 0207             | S        | 061300  | 2016  |
|  3 | 21133104110 | 0224             | S        | 061300  | 2016  |
|  4 | 21133104110 | 0237             | S        | 061300  | 2016  |
|  5 | 21133104110 | 0242             | S        | 061300  | 2016  |
+----+-------------+------------------+----------+---------+-------+
5 rows in set (0.01 sec)

MariaDB [gepi173]> 
*/
			$sql="SELECT * FROM plugin_lsl_competences_matieres ORDER BY annee DESC, MEF, matiere, modalite, code_competences;";
			//echo "$sql<br />";
			$res_comp=mysqli_query($mysqli, $sql);
			if(mysqli_num_rows($res_comp)>0) {
				while($lig_comp=mysqli_fetch_object($res_comp)) {
					echo "
		<tr>
			<td title=\"".$lig_comp->MEF."\">".(isset($tab_mef[$lig_comp->MEF]['designation_courte']) ? $tab_mef[$lig_comp->MEF]['designation_courte'] : $lig_comp->MEF)."</td>
			<td>".$lig_comp->code_competences."</td>
			<td>".$tab_competence[$lig_comp->code_competences]."</td>
			<td>".$lig_comp->modalite."</td>
			<td title=\"Code matière ".$lig_comp->matiere."\">";
					if(isset($tab_matiere[$lig_comp->matiere])) {
						echo $tab_matiere[$lig_comp->matiere];
					}
					else {
						$sql="SELECT * FROM plugin_lsl_programmes WHERE matiere='".$lig_comp->matiere."' AND 
														formation='".$lig_comp->MEF."' AND 
														Modalite='".$lig_comp->modalite."';";
						//echo "$sql<br />";
						$res_mat=mysqli_query($mysqli, $sql);
						if(mysqli_num_rows($res_mat)>0) {
							$lig_mat=mysqli_fetch_object($res_mat);
							echo $lig_mat->option;
						}
						else {
							$sql="SELECT * FROM plugin_lsl_programmes WHERE matiere='".$lig_comp->matiere."' AND 
															formation='".$lig_comp->MEF."';";
							//echo "$sql<br />";
							$res_mat=mysqli_query($mysqli, $sql);
							if(mysqli_num_rows($res_mat)>0) {
								$lig_mat=mysqli_fetch_object($res_mat);
								echo $lig_mat->option;
							}
							else {
								echo $lig_comp->matiere;
							}
						}
					}
					echo "</td>
			<td title=\"".$lig_comp->annee."\">".$lig_comp->annee."</td>
			<td><input type='checkbox' name='suppr_assoc_mef_matiere_competence[]' value='".$lig_comp->id."' /></td>
		</tr>";
				}
			}
		?>
	</table>
		<p id='p_suppr_assoc_mef_matiere_competence' style="display:none;"><input type='submit' value="Supprimer les correspondances sélectionnées" /></p>
		</div>
	</form>

	<?php } ?>

</fieldset>


<fieldset class='fieldset_opacite50'>
	<legend>Liste des classes <?php echo $anneeScolaire; ?>/<?php echo $anneeScolaire+1; ?></legend>
	<?php if ($classes && $classes->num_rows) { ?>
	<p title="Cliquez pour afficher/masquer le tableau"
	   onclick="bascule('tableClasses');"
	   class="center grand bold"
	   style="cursor:pointer" 
	   >
		Il y a <?php echo $classes->num_rows ?> classes pour <?php echo $anneeScolaire; ?>/<?php echo $anneeScolaire+1; ?>.
		 <img src='../../images/icons/visible.png' class='icone16' />
	</p>

	<form method="post" action="index.php" id="form_LSL_classe" enctype="multipart/form-data">
		<div class='fieldset_opacite50' style='padding:0.5em; margin-bottom:1em;'>
		<p class="center">
			<button type="button" 
					onclick="bascule('tableClasses');" 
					title="Cliquez pour afficher/masquer le tableau" >
				afficher/masquer le tableau
			</button>
		</p>
		<p class="center" style="margin-top:.5em;">
			<button name="ouvertsProfs" 
					id="ouvertsProfs" 
					value="1" 
					title="Enregistrer les classes à ouvrir à la saisie par les enseignants" >
				Ouvrir les classes aux enseignants
			</button>
			&nbsp;
			<button type="submit" 
					name="creeFichier" 
					id="creeFichier" 
					value="1"
					title="Créer le fichier .xml à importer dans LSL">
				Créer le fichier .xml
			</button>
		</p>

		<table class="boireaus sortable resizable"
			   id="tableClasses"
			   >
			<tr>
				<th>
					nom court
				</th>
				<th>
					nom complet
				</th>
				<th>
					niveau
				</th>
				<th style="cursor:pointer" 
					title="Sélectionner les classes à ouvrir à la saisie par les enseignants" >
					saisie en profs
						<img src='../../images/enabled.png' 
							 class='icone15' 
							 title='Cocher toutes les classes'
							 style="cursor:pointer"
							 onclick="CocheProfSelect(<?php echo $classes->num_rows ?>)" />
					/
						<img src='../../images/disabled.png' 
							 class='icone15' 
							 title='Décocher toutes les classes'
							 style="cursor:pointer"
							 onclick="DecocheProfSelect(<?php echo $classes->num_rows ?>)"  />
				</th>
				<th title="Sélectionner les classes à extraire dans le fichier .xml pour LSL" 
					style="cursor:pointer" >
					<span onclick="getElementById('creeFichier').validate()">
						à extraire
					</span>

						<img src='../../images/enabled.png' 
							 class='icone15' 
							 title='Cocher toutes les classes'
							 style="cursor:pointer"
							 onclick="CocheColonneSelect(<?php echo $classes->num_rows ?>)" />
					/
						<img src='../../images/disabled.png' 
							 class='icone15' 
							 title='Décocher toutes les classes'
							 style="cursor:pointer"
							 onclick="DecocheColonneSelect(<?php echo $classes->num_rows ?>)"  />
				</th>
			</tr>
	<?php 
		$cpt =1;
		$id =1;
		while ($obj = $classes->fetch_object()) {
	?>
			<tr class="lig<?php echo $cpt; ?>">

				<td>
					<?php echo $obj->nom_court; ?>
				</td>
				<td>
					<?php echo $obj->nom_complet; ?>
				</td>
				<td>
					<?php echo $obj->niveau; ?>
				</td>
				<td>
					<input type="checkbox" 
						   name="classe_prof[<?php echo $obj->id; ?>]" 
						   id="classe_prof_<?php echo $id; ?>" 
						   <?php if (lsl_get_ouvert_prof($obj->id)){ ?>
						   checked="checked"
						   <?php } ?>
						   />
				</td>
				<td>
					<?php if(formationValide($obj->id,$anneeAPB)){ ?>
					<input type="checkbox" 
						   name="classes[<?php echo $obj->id; ?>]" 
						   id="classe_<?php echo $id; ?>"
						   />
						   <?php } ?> 
				</td>

			</tr>

	<?php
		$cpt*=-1;
		$id++;
		}
	?>

		</table>

	<?php } else if ($classes) { ?>
		<p class="rouge bold">Aucune classe trouvée, avez-vous bien fait les extractions APB ? </p>
<?php } else  { ?>
		<p class="rouge bold">Erreur lors de l'extraction des classes, le plugin APB est-il bien installé ? </p>
<?php } ?>
		<p class="center" style="margin-top:1em;">
			<?php if (function_exists("add_token_field")) {echo add_token_field(); } ?>
			<button name="ouvertsProfs" 
					id="ouvertsProfs" 
					value="1" 
					title="Enregistrer les classes à ouvrir à la saisie par les enseignants" >
				Ouvrir les classes aux enseignants
			</button>
			&nbsp;
			<button type="submit" 
					name="creeFichier" 
					id="creeFichier" 
					value="1"
					title="Créer le fichier .xml à importer dans LSL">
				Créer le fichier .xml
			</button>
		</p>
		</div>
	</form>
</fieldset>

	<?php
}
}
?>
<fieldset class='fieldset_opacite50'>
	<legend>Modules ouverts</legend>
	<form method="post" action="index.php" id="form_LSL_ouvert" enctype="multipart/form-data">
		<div class='fieldset_opacite50' style='padding:0.5em; margin-bottom:1em;'>
		<p>
			<label for="droitAppreciation">
				Saisie des appréciations
			</label>
			<input type="checkbox" 
				   name="droitAppreciation"
				   id="droitAppreciation"
				   <?php if (lsl_getDroit('droitAppreciation')) {echo " checked='checked' ";} ?>
					  />
		</p>
		<p>
			<label for="droitCompetences">
				Saisie des compétences
			</label>
			<input type="checkbox" 
				   name="droitCompetences" 
				   id="droitCompetences"
				   <?php if (lsl_getDroit('droitCompetences')) {echo " checked='checked' ";} ?>
					  />
			<!--
				   disabled="disabled"
			<span style='color:red'>non encore implémenté...</span>
			-->
		</p>
		<p>
			<?php if (function_exists("add_token_field")) {echo add_token_field(); } ?>
			<button name="sauveDroits" id="sauveDroits" value="oui" >
				Enregistrer les droits
			</button>
		</p>

		<p style='margin-top:1em;'><em>NOTES&nbsp;:</em></p>
		<ul>
			<li><p>Si un professeur signale qu'un enseignement n'a pas de Compétences proposées, c'est peut-être parce que lors de l'archivage ParcourSup/APB, la matière n'était associée à aucune nomenclature Siècle/Sconet.<br />
			Il aurait fallu mettre à jour les nomenclatures de matières d'après Siècle/Sconet après y avoir vérifié les associations.<br />
			En l'état, la table 'plugin_archAPB_matieres' et sans doute  la table 'matieres' n'ont pas l'association requise.<br />
			Voir <a href='../../matieres/index.php' target='_blank'>Gestion des matières</a>,<br />
			<a href='../../gestion/admin_nomenclatures.php?action=importnomenclature' target='_blank'>Import des nomenclatures</a>,<br />
			<a href='../archivageAPB/index.php' target='_blank'>Archivage ParcourSup/APB</a></p></li>
		</ul>
		</div>
	</form>
</fieldset>
