<?php

/*
*
* Copyright 2014-2018 Régis Bouguin, Stephane Boireau
*
* This file is part of GEPI.
*
* GEPI is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 3 of the License, or
* (at your option) any later version.
*
* GEPI is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with GEPI; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

$annee = NULL;

if (isset($_GET['classe'])) {unset($_SESSION['classes']);}

// on passe par un tableau, reste 
$classesChoisies = isset($_GET['classe']) ? $_GET['classe'] : (isset($_SESSION['classes']) ? $_SESSION['classes'] : NULL) ;


$_SESSION['classes'] = $classesChoisies;

//===== Recherche des classes =====
// 20180611
$classesProf = chercheClassesProf($_SESSION['login'], $anneeAPB);

//===== Recherche des élèves =====
if ($classesChoisies) {
	$elevesChoisis = chercheElevesProf($classesChoisies, $_SESSION['login'], $anneeAPB);
}

// 20180823 : Compétences
$saisie_competences=lsl_getDroit('droitCompetences');

//debug_var();

//===== Recherche des notes =====
if((isset($_POST['appEleves']))||(isset($_POST['appEleves2']))) {
	//$_POST[app]['100820889DJ_2345_2019']=

	$nb_reg=0;
	foreach ($_POST['app'] as $key => $value) {
		if ($value) {
			$clefs = explode ("_",$key) ;
			// $clefs[0] = INE
			// $clefs[1] = id_groupe
			// $clefs[2] = annee
			setAppreciationProf($clefs[0], $clefs[1], $clefs[2], $value, $_SESSION['login']);
			$nb_reg++;
		}
	}

	// 20180823 : Compétences
	if(isset($_POST['comp'])) {
		foreach ($_POST['comp'] as $key => $value) {
			if ("$value"!='') {
				$clefs = explode ("_",$key) ;
				//comp[070532955BD_4231_2018_0206]
				$tmp_ine=$clefs[0];
				$tmp_id_groupe=$clefs[1];
				$tmp_annee=$clefs[2];
				$tmp_competence=$clefs[3];
				$tmp_valeur=$value;
				//echo "setCompetenceProf($tmp_ine, $tmp_id_groupe, $tmp_annee, $tmp_competence, $tmp_valeur, ".$_SESSION['login'].");<br />";
				setCompetenceProf($tmp_ine, $tmp_id_groupe, $tmp_annee, $tmp_competence, $tmp_valeur, $_SESSION['login']);
				$nb_reg++;
			}
		}
	}

	if($nb_reg>0) {
		echo "<p style='text-align:center; font-weight:bold; color:red'>$nb_reg enregistrement(s) traité(s) (".strftime("%d/%m/%Y à %H:%M:%S").").</p>";
	}
}

?>
<fieldset>
	<legend>Liste des classes <?php echo $anneeLSL; ?>/<?php echo $anneeAPB; ?></legend>
<?php
if($classesProf->num_rows) {
	while ($classeProf = $classesProf->fetch_object()){ 
		if (lsl_get_ouvert_prof($classeProf->id)) { ?>
	<p>
		<a href="?classe[<?php echo $classeProf->id; ?>]=on<?php echo add_token_in_url(); ?>">
			<?php echo $classeProf->nom_complet; ?>
		</a>		
	</p>
<?php		}
	}
}

$tab_modalites_election=get_tab_modalites_election('code');
?>
</fieldset>

<?php if($classesChoisies) {?>

	<?php
	if($elevesChoisis) {
		$cpt_ligne=0;
	?>
<fieldset class="margin-top:1em">
	<legend>Élèves</legend>
	<form method="post" action="index.php" id="form_elv" enctype="multipart/form-data">	
		<table class="boireaus boireaus_alt sortable resizable"
			   id="tableEleves"
			   >
			<tr>
				<th>
					Classe
				</th>
				<th>
					Nom Prénom
				</th>
				<th>
					Notes
				</th>
				<th>
					Appréciation (prof)
				</th>
			</tr>
				<?php $cpt=1;?>
				<?php while ($elvChoisi = $elevesChoisis->fetch_object()){?>
			<tr>
				<td>
					<?php 
						/*
						echo "<pre>";
						print_r($elvChoisi);
						echo "</pre>";
						*/
						echo cherche_classe_APB($elvChoisi->id_classe, $anneeAPB)->nom_court; 
					?>
				</td>
				<td style="text-align: left;">
					<?php echo $elvChoisi->nom; ?> <?php echo $elvChoisi->prenom; ?> 
				</td>
				<td style="text-align: left;">
				<?php
					// 20180611
					$notes = chercheNotes($elvChoisi->ine,$_SESSION['login'],$anneeAPB);
					if($notes) {?>
					<?php 
						$exMatiere = "";
						$moyenne = 0;
						$nbNotes = 0; 
					while ($noteActive = $notes->fetch_object()) {
						if ($exMatiere != $noteActive->code_service) {
							//on change de matière

							if (0 != $moyenne) {
							//on change vraiment de matière, on ferme la case, on entre l'appréciation, on crée une autre ligne
								echo " moyenne = ".number_format($moyenne/$nbNotes, 2, ',', ' ')." ";
								?>
				</td>
				<td style="text-align: left;">
				<?php if (lsl_getDroit('droitAppreciation')) { ?>
					<textarea rows="4" cols="70"  
							  name="app[<?php echo $elvChoisi->ine; ?>_<?php echo $exMatiere ?>_<?php echo $anneeAPB; ?>]"
							  id="app_<?php echo $elvChoisi->ine; ?>_<?php echo $exMatiere ?>_<?php echo $anneeAPB; ?>"
							  maxlength="300"
							  style="text-align: left;"
							  /><?php echo trim(getAppreciationProf($elvChoisi->ine, $exMatiere, $anneeAPB)); ?></textarea>
					<?php $prof = getUtilisateur(getLoginProfAppreciation($elvChoisi->ine, $exMatiere, $anneeAPB)); ?>
					<?php if ($prof) {echo " (".$prof->nom." ".$prof->prenom.")";} ?>
				<?php
					}

					// 20180823 : Compétences
					if($saisie_competences) {
/*
CREATE TABLE IF NOT EXISTS `plugin_lsl_competences` (
`id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id unique',
`code_competences` varchar(10) NOT NULL DEFAULT '' COMMENT 'code MEF des compétences',
`texte_competences` varchar(250) NOT NULL DEFAULT '' COMMENT 'Descriptif des compétences',
`annee` varchar(4) NOT NULL DEFAULT '' COMMENT 'annee LSL de la compétence',
UNIQUE KEY `code_competences` (`code_competences`, `annee`),
PRIMARY KEY (`id`)
) ENGINE=MyISAM  COMMENT 'liste des competences' ;

$sql="CREATE TABLE IF NOT EXISTS `plugin_lsl_eval_competences` (
	`id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id unique',
	`annee` smallint(6) NOT NULL DEFAULT 0 COMMENT 'année',
	`prof` varchar(50) NOT NULL DEFAULT '' COMMENT 'login du prof',
	`eleve` VARCHAR( 50 )  NOT NULL DEFAULT '' COMMENT 'login de l\'élève',
	`code_competences` varchar(300) NOT NULL DEFAULT '' COMMENT 'code de la compétence',
	`valeur` varchar(300) NOT NULL DEFAULT '' COMMENT 'Valeur obtenue sur la compétence',
	`id_APB` int(11) COMMENT 'code matiere dans APB',
	UNIQUE KEY `annee_idAPB_eleve_competence` ( `annee` , `id_APB` , `eleve`, `code_competences` ),
	PRIMARY KEY (`id`)
	) ENGINE=MyISAM  COMMENT 'Niveau obtenu par les élèves sur les compétences' ;";

MariaDB [gepi173]> select * from plugin_lsl_competences_matieres limit 5;
+----+------------+------------------+----------+---------+-------+
| id | MEF        | code_competences | modalite | matiere | annee |
+----+------------+------------------+----------+---------+-------+
|  1 | 2113310411 | 0206             | S        | 061300  | 2016  |
|  2 | 2113310411 | 0207             | S        | 061300  | 2016  |
|  3 | 2113310411 | 0224             | S        | 061300  | 2016  |
|  4 | 2113310411 | 0237             | S        | 061300  | 2016  |
|  5 | 2113310411 | 0242             | S        | 061300  | 2016  |
+----+------------+------------------+----------+---------+-------+
5 rows in set (0.00 sec)

MariaDB [gepi173]> 


*/

// 20181202 : ERREUR 
/*
<matiere regroupement="ENSEIGNEMENTS SPÉCIFIQUES À LA SÉRIE L : ENSEIGNEMENTS COMMUNS A TOUS LES ELEVES" discipline="LITTÉRATURE ÉTRANGÈRE EN" codeBcn="030008" presenceEvaluationPeriodique="true" modaliteElection="O" >
	<competences>
		<competence>0108</competence>
		<competence>0117</competence>
		<competence>0149</competence>
	</competences>
</matiere>

<competence code="0108" annee="2017">Mettre en relation des oeuvres en fonction d'une thématique</competence>
<competence code="0119" annee="2017">Mobiliser les connaissances attendues pour expliquer le fonctionnement du vivant</competence>
<competence code="0149" annee="2017">Rendre compte des éléments pertinents de textes littéraires</competence>

A chercher dans 'plugin_lsl_competences_matieres'
*/

						// Dans le cas d'une langue vivante (préfixe 03 et dernier caractère 1, 2, 3 ou 4), on se moque de la modalité O ou F qui est parfois mal paramétrée.
						// De toute façon, ce sont les mêmes compétences en LV1, LV2, LV3 et LV4
						/*
						$sql="SELECT DISTINCT plc.code_competences, plc.texte_competences FROM plugin_lsl_competences plc, 
										plugin_lsl_competences_matieres plcm, 
										plugin_archAPB_eleves_mef apb_mef, 
										mef 
									WHERE plcm.annee='".$anneeLSL."' AND 
										plcm.MEF=mef.mef_rattachement AND 
										mef.mef_code=apb_mef.code_mef AND 
										apb_mef.annee='".$anneeAPB."' AND 
										apb_mef.no_gep='".$elvChoisi->ine."' AND 
										plcm.matiere='".$current_code_sconet_matiere."' AND ".(!preg_match("/^03[0-9A-Z]*[1-4]$/", $current_code_sconet_matiere) ? "
										plcm.modalite='".$current_modalite."' AND " : '')."
										plcm.annee=plc.annee AND 
										plcm.code_competences=plc.code_competences 
									ORDER BY plc.code_competences;";
						*/
						if(preg_match("/^03[0-9A-Z]*[1-4]{1}$/", $current_code_sconet_matiere)) {
							$current_code_sconet_matiere_test='03%'.substr($current_code_sconet_matiere, -1);
							$sql="SELECT DISTINCT plc.code_competences, plc.texte_competences FROM plugin_lsl_competences plc, 
										plugin_lsl_competences_matieres plcm, 
										plugin_archAPB_eleves_mef apb_mef, 
										mef 
									WHERE plcm.annee='".$anneeLSL."' AND 
										plcm.MEF=mef.mef_rattachement AND 
										mef.mef_code=apb_mef.code_mef AND 
										apb_mef.annee='".$anneeAPB."' AND 
										apb_mef.no_gep='".$elvChoisi->ine."' AND 
										plcm.matiere LIKE '".$current_code_sconet_matiere_test."' AND 
										plcm.annee=plc.annee AND 
										plcm.code_competences=plc.code_competences 
									ORDER BY plc.code_competences;";
						}
						else {
							$sql="SELECT DISTINCT plc.code_competences, plc.texte_competences FROM plugin_lsl_competences plc, 
										plugin_lsl_competences_matieres plcm, 
										plugin_archAPB_eleves_mef apb_mef, 
										mef 
									WHERE plcm.annee='".$anneeLSL."' AND 
										plcm.MEF=mef.mef_rattachement AND 
										mef.mef_code=apb_mef.code_mef AND 
										apb_mef.annee='".$anneeAPB."' AND 
										apb_mef.no_gep='".$elvChoisi->ine."' AND 
										plcm.matiere='".$current_code_sconet_matiere."' AND ".(!preg_match("/^03[0-9A-Z]*[1-4]$/", $current_code_sconet_matiere) ? "
										plcm.modalite='".$current_modalite."' AND " : '')."
										plcm.annee=plc.annee AND 
										plcm.code_competences=plc.code_competences 
									ORDER BY plc.code_competences;";
						}
						//echo "1<br />";
						//echo $sql."<br />";
						$res_comp=mysqli_query($mysqli, $sql);
						$nb_competences=mysqli_num_rows($res_comp);

						if($nb_competences>0) {
							// Récupérer ce qui est déjà validé.
							$tab_select=array();
							$sql="SELECT * FROM plugin_lsl_eval_competences 
										WHERE annee='".$anneeAPB."' AND 
											eleve='".$elvChoisi->ine."' AND 
											id_APB='".$current_id_groupe."';";
							//echo $sql."<br />";
							$res_comp_deja=mysqli_query($mysqli, $sql);
							if(mysqli_num_rows($res_comp_deja)>0) {
								while($lig_comp_deja=mysqli_fetch_object($res_comp_deja)) {
									$tab_select[$lig_comp_deja->code_competences]=$lig_comp_deja->valeur;
								}
							}

							// 4 niveaux pour tous les enseignements sauf les langues vivantes qui ont 6 niveaux
							/*
							if(($current_code_sconet_matiere=='030001')||
								($current_code_sconet_matiere=='030002')||
								($current_code_sconet_matiere=='030003')||
								($current_code_sconet_matiere=='030004')) {
							*/
							if(preg_match("/^03[0-9A-Z]*[1-4]$/", $current_code_sconet_matiere)) {
								echo "
							<table class='boireaus boireaus_alt'>
								<tr>
									<th>Compétence</th>
									<th title=\"Compétence non évaluée\" onclick=\"coche_colonne_comp($cpt_ligne, 'NE', 5)\">NE</th>
									<th title=\"Utilisateur élémentaire, niveau introductif\" onclick=\"coche_colonne_comp($cpt_ligne, 'A1', 5)\" style='color:#f3843d'>A1</th>
									<th title=\"Utilisateur élémentaire, niveau \" onclick=\"coche_colonne_comp($cpt_ligne, 'A2', 5)\" style='color:#1499a8'>A2</th>
									<th title=\"Utilisateur indépendant, niveau seuil\" onclick=\"coche_colonne_comp($cpt_ligne, 'B1', 5)\" style='color:#006ca5'>B1</th>
									<th title=\"Utilisateur indépendant, niveau avancé\" onclick=\"coche_colonne_comp($cpt_ligne, 'B2', 5)\" style='color:#ed5444'>B2</th>
									<th title=\"Utilisateur expérimenté, autonome\" onclick=\"coche_colonne_comp($cpt_ligne, 'C1', 5)\" style='color:#1aa773'>C1</th>
									<th title=\"Utilisateur expérimenté, maîtrise\" onclick=\"coche_colonne_comp($cpt_ligne, 'C2', 5)\" style='color:#613e90'>C2</th>
									<th title=\"Supprimer cette évaluation de compétence\" onclick=\"coche_colonne_comp($cpt_ligne, '0', 5)\" style='color:'><img src='../../images/delete16.png' class='icone16' /></th>
								</tr>";
								while($lig_comp=mysqli_fetch_object($res_comp)) {
									/*
									echo "<pre>";
									print_r($lig_comp);
									echo "</pre>";
									*/
									echo "
									<tr>
										<td title='Compétence n°".$lig_comp->code_competences."' id='libelle_comp_".$cpt_ligne."'>".$lig_comp->texte_competences."</td>
										<td id='td_comp_".$cpt_ligne."_NE'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_NE'
												value='NE' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='NE') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_A1'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_A1'
												value='A1' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='A1') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_A2'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_A2'
												value='A2' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='A2') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_B1'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_B1'
												value='B1' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='B1') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_B2'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_B2'
												value='B2' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='B2') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_C1'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_C1'
												value='C1' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='C1') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_C2'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_C2'
												value='C2' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='C2') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_0'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_0'
												value='0' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='0') ? 'checked' : '')." /></td>
									</tr>";
									$cpt_ligne++;
								}
								echo "
							</table>";
							}
							elseif(($current_code_sconet_matiere=='100100')||
								($current_code_sconet_matiere=='104100')) {
								echo "
							<table class='boireaus boireaus_alt'>
								<tr>
									<th title=\"Compléter au moins trois compétences parmi les 5 premières et une compétence parmi les 3 dernières.\"><img src='../../images/icons/ico_aide.png' width='15' height='25' /></th>
									<th>Compétence</th>
									<th title=\"Compétence non évaluée\" onclick=\"coche_colonne_comp($cpt_ligne, 'NE', $nb_competences)\">NE</th>
									<th title=\"Compétence non maîtrisée\" style='color:red' onclick=\"coche_colonne_comp($cpt_ligne, '1', $nb_competences)\">NM</th>
									<th title=\"Compétence insuffisamment maîtrisée\" style='color:orange' onclick=\"coche_colonne_comp($cpt_ligne, '2', $nb_competences)\">IM</th>
									<th title=\"Compétence maîtrisée\" style='color:green' onclick=\"coche_colonne_comp($cpt_ligne, '3', $nb_competences)\">M</th>
									<th title=\"Compétence bien maîtrisée\" style='color:blue' onclick=\"coche_colonne_comp($cpt_ligne, '4', $nb_competences)\">BM</th>
									<th title=\"Supprimer cette évaluation de compétence\" onclick=\"coche_colonne_comp($cpt_ligne, '0', $nb_competences)\"><img src='../../images/delete16.png' class='icone16' /></th>
								</tr>";
								$cpt_comp_eps=0;
								while($lig_comp=mysqli_fetch_object($res_comp)) {
									/*
									echo "<pre>";
									print_r($lig_comp);
									echo "</pre>";
									*/
									echo "
									<tr>";
									if($cpt_comp_eps==0) {
										echo "
										<td rowspan='5' style='text-align:left; background-color:orange;' title='Compléter au moins trois compétences parmi les 5 premières.'></td>";
									}
									elseif($cpt_comp_eps==5) {
										echo "
										<td rowspan='3' style='text-align:left; background-color:lightgreen;' title='Compléter au moins une compétence parmi les 3 dernières.'></td>";
									}
									echo "
										<td style='text-align:left' title='Compétence n°".$lig_comp->code_competences."' id='libelle_comp_".$cpt_ligne."'>".$lig_comp->texte_competences."</td>
										<td id='td_comp_".$cpt_ligne."_NE'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_NE'
												value='NE' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='NE') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_1'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_1'
												value='1' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='1') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_2'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_2'
												value='2' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='2') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_3'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_3'
												value='3' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='3') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_4'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_4'
												value='4' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='4') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_0'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_0'
												value='0' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='0') ? 'checked' : '')." /></td>
									</tr>";
									$cpt_comp_eps++;
									$cpt_ligne++;
								}
								echo "
							</table>";
							}
							else {
								echo "
							<table class='boireaus boireaus_alt'>
								<tr>
									<th>Compétence</th>
									<th title=\"Compétence non évaluée\" onclick=\"coche_colonne_comp($cpt_ligne, 'NE', $nb_competences)\">NE</th>
									<th title=\"Compétence non maîtrisée\" style='color:red' onclick=\"coche_colonne_comp($cpt_ligne, '1', $nb_competences)\">NM</th>
									<th title=\"Compétence insuffisamment maîtrisée\" style='color:orange' onclick=\"coche_colonne_comp($cpt_ligne, '2', $nb_competences)\">IM</th>
									<th title=\"Compétence maîtrisée\" style='color:green' onclick=\"coche_colonne_comp($cpt_ligne, '3', $nb_competences)\">M</th>
									<th title=\"Compétence bien maîtrisée\" style='color:blue' onclick=\"coche_colonne_comp($cpt_ligne, '4', $nb_competences)\">BM</th>
									<th title=\"Supprimer cette évaluation de compétence\" onclick=\"coche_colonne_comp($cpt_ligne, '0', $nb_competences)\"><img src='../../images/delete16.png' class='icone16' /></th>
								</tr>";
								while($lig_comp=mysqli_fetch_object($res_comp)) {
									/*
									echo "<pre>";
									print_r($lig_comp);
									echo "</pre>";
									*/
									echo "
									<tr>
										<td style='text-align:left' title='Compétence n°".$lig_comp->code_competences."' id='libelle_comp_".$cpt_ligne."'>".$lig_comp->texte_competences."</td>
										<td id='td_comp_".$cpt_ligne."_NE'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_NE'
												value='NE' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='NE') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_1'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_1'
												value='1' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='1') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_2'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_2'
												value='2' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='2') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_3'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_3'
												value='3' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='3') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_4'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_4'
												value='4' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='4') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_0'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_0'
												value='0' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='0') ? 'checked' : '')." /></td>
									</tr>";
									$cpt_ligne++;
								}
								echo "
							</table>";
							}
						}
						elseif((mysqli_num_rows($res_comp)==0)&&(preg_match("/^03[0-9A-Z]*[1-4]$/", $current_code_sconet_matiere))) {
							// On a probablement une langue vivante avec le préfixe 03, mais elle n'a pas d'association spécifique pour son code matière.
							// On va faire comme si c'était une LV1 030001
							$sql="SELECT DISTINCT plc.code_competences, plc.texte_competences FROM plugin_lsl_competences plc, 
											plugin_lsl_competences_matieres plcm, 
											plugin_archAPB_eleves_mef apb_mef, 
											mef 
										WHERE plcm.annee='".$anneeLSL."' AND 
											plcm.MEF=mef.mef_rattachement AND 
											mef.mef_code=apb_mef.code_mef AND 
											apb_mef.annee='".$anneeAPB."' AND 
											apb_mef.no_gep='".$elvChoisi->ine."' AND 
											plcm.matiere='030001' AND 
											plcm.annee=plc.annee AND 
											plcm.code_competences=plc.code_competences 
										ORDER BY plc.code_competences;";
							//echo "2<br />";
							//echo $sql."<br />";
							$res_comp=mysqli_query($mysqli, $sql);
							$nb_competences=mysqli_num_rows($res_comp);

							if($nb_competences>0) {
								// Récupérer ce qui est déjà validé.
								$tab_select=array();
								$sql="SELECT * FROM plugin_lsl_eval_competences 
											WHERE annee='".$anneeAPB."' AND 
												eleve='".$elvChoisi->ine."' AND 
												id_APB='".$current_id_groupe."';";
								//echo $sql."<br />";
								$res_comp_deja=mysqli_query($mysqli, $sql);
								if(mysqli_num_rows($res_comp_deja)>0) {
									while($lig_comp_deja=mysqli_fetch_object($res_comp_deja)) {
										$tab_select[$lig_comp_deja->code_competences]=$lig_comp_deja->valeur;
									}
								}

								echo "
							<table class='boireaus boireaus_alt'>
								<tr>
									<th>Compétence</th>
									<th title=\"Compétence non évaluée\" onclick=\"coche_colonne_comp($cpt_ligne, 'NE', 5)\">NE</th>
									<th title=\"Utilisateur élémentaire, niveau introductif\" onclick=\"coche_colonne_comp($cpt_ligne, 'A1', 5)\" style='color:#f3843d'>A1</th>
									<th title=\"Utilisateur élémentaire, niveau \" onclick=\"coche_colonne_comp($cpt_ligne, 'A2', 5)\" style='color:#1499a8'>A2</th>
									<th title=\"Utilisateur indépendant, niveau seuil\" onclick=\"coche_colonne_comp($cpt_ligne, 'B1', 5)\" style='color:#006ca5'>B1</th>
									<th title=\"Utilisateur indépendant, niveau avancé\" onclick=\"coche_colonne_comp($cpt_ligne, 'B2', 5)\" style='color:#ed5444'>B2</th>
									<th title=\"Utilisateur expérimenté, autonome\" onclick=\"coche_colonne_comp($cpt_ligne, 'C1', 5)\" style='color:#1aa773'>C1</th>
									<th title=\"Utilisateur expérimenté, maîtrise\" onclick=\"coche_colonne_comp($cpt_ligne, 'C2', 5)\" style='color:#613e90'>C2</th>
									<th title=\"Supprimer cette évaluation de compétence\" onclick=\"coche_colonne_comp($cpt_ligne, '0', 5)\" style='color:'><img src='../../images/delete16.png' class='icone16' /></th>
								</tr>";
								while($lig_comp=mysqli_fetch_object($res_comp)) {
									/*
									echo "<pre>";
									print_r($lig_comp);
									echo "</pre>";
									*/
									echo "
									<tr>
										<td title='Compétence n°".$lig_comp->code_competences."' id='libelle_comp_".$cpt_ligne."'>".$lig_comp->texte_competences."</td>
										<td id='td_comp_".$cpt_ligne."_NE'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_NE'
												value='NE' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='NE') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_A1'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_A1'
												value='A1' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='A1') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_A2'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_A2'
												value='A2' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='A2') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_B1'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_B1'
												value='B1' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='B1') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_B2'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_B2'
												value='B2' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='B2') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_C1'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_C1'
												value='C1' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='C1') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_C2'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_C2'
												value='C2' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='C2') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_0'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_0'
												value='0' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='0') ? 'checked' : '')." /></td>
									</tr>";
									$cpt_ligne++;
								}
								echo "
							</table>";
							}

						}
						elseif((mysqli_num_rows($res_comp)==0)&&(preg_match("/^03[0-9A-Z]*8$/", $current_code_sconet_matiere))) {
							// On a Littérature étrangère avec le préfixe 03 et le suffixe 8,
							// mais elle n'a pas d'association spécifique pour son code matière.
							// On va faire comme si c'était une LV1 030008
							$sql="SELECT DISTINCT plc.code_competences, plc.texte_competences FROM plugin_lsl_competences plc, 
											plugin_lsl_competences_matieres plcm, 
											plugin_archAPB_eleves_mef apb_mef, 
											mef 
										WHERE plcm.annee='".$anneeLSL."' AND 
											plcm.MEF=mef.mef_rattachement AND 
											mef.mef_code=apb_mef.code_mef AND 
											apb_mef.annee='".$anneeAPB."' AND 
											apb_mef.no_gep='".$elvChoisi->ine."' AND 
											plcm.matiere='030008' AND 
											plcm.annee=plc.annee AND 
											plcm.code_competences=plc.code_competences 
										ORDER BY plc.code_competences;";
							//echo "2<br />";
							//echo $sql."<br />";
							$res_comp=mysqli_query($mysqli, $sql);
							$nb_competences=mysqli_num_rows($res_comp);

							if($nb_competences>0) {
								// Récupérer ce qui est déjà validé.
								$tab_select=array();
								$sql="SELECT * FROM plugin_lsl_eval_competences 
											WHERE annee='".$anneeAPB."' AND 
												eleve='".$elvChoisi->ine."' AND 
												id_APB='".$current_id_groupe."';";
								//echo $sql."<br />";
								$res_comp_deja=mysqli_query($mysqli, $sql);
								if(mysqli_num_rows($res_comp_deja)>0) {
									while($lig_comp_deja=mysqli_fetch_object($res_comp_deja)) {
										$tab_select[$lig_comp_deja->code_competences]=$lig_comp_deja->valeur;
									}
								}

								echo "
							<table class='boireaus boireaus_alt'>
								<tr>
									<th>Compétence</th>
									<th title=\"Compétence non évaluée\" onclick=\"coche_colonne_comp($cpt_ligne, 'NE', $nb_competences)\">NE</th>
									<th title=\"Compétence non maîtrisée\" style='color:red' onclick=\"coche_colonne_comp($cpt_ligne, '1', $nb_competences)\">NM</th>
									<th title=\"Compétence insuffisamment maîtrisée\" style='color:orange' onclick=\"coche_colonne_comp($cpt_ligne, '2', $nb_competences)\">IM</th>
									<th title=\"Compétence maîtrisée\" style='color:green' onclick=\"coche_colonne_comp($cpt_ligne, '3', $nb_competences)\">M</th>
									<th title=\"Compétence bien maîtrisée\" style='color:blue' onclick=\"coche_colonne_comp($cpt_ligne, '4', $nb_competences)\">BM</th>
									<th title=\"Supprimer cette évaluation de compétence\" onclick=\"coche_colonne_comp($cpt_ligne, '0', $nb_competences)\"><img src='../../images/delete16.png' class='icone16' /></th>
								</tr>";
								while($lig_comp=mysqli_fetch_object($res_comp)) {
									/*
									echo "<pre>";
									print_r($lig_comp);
									echo "</pre>";
									*/
									echo "
									<tr>
										<td style='text-align:left' title='Compétence n°".$lig_comp->code_competences."' id='libelle_comp_".$cpt_ligne."'>".$lig_comp->texte_competences."</td>
										<td id='td_comp_".$cpt_ligne."_NE'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_NE'
												value='NE' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='NE') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_1'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_1'
												value='1' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='1') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_2'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_2'
												value='2' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='2') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_3'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_3'
												value='3' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='3') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_4'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_4'
												value='4' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='4') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_0'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_0'
												value='0' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='0') ? 'checked' : '')." /></td>
									</tr>";
									$cpt_ligne++;
								}
								echo "
							</table>";
							}

						}
						//$cpt_ligne++;
					}

				?>
				</td>
			</tr>
			<tr>
				<td><?php echo cherche_classe_APB($elvChoisi->id_classe, $anneeAPB)->nom_court; ?></td>
				<td style="text-align: left;"><?php echo $elvChoisi->nom; ?> <?php echo $elvChoisi->prenom; ?></td>
				<td style="text-align: left;">
				<?php	

								//echo $moyenne;
								$exMatiere = "";
								$moyenne = 0;
								$nbNotes = 0;
							}

							echo " ".getMatiere($noteActive->code_service,$anneeAPB)." "; 
							echo " <span title=\"Enseignement n°".$noteActive->code_service."\n".get_info_grp($noteActive->code_service, array('description', 'matieres', 'classes', 'profs'), "")."\">(".$noteActive->code_service.")</span> ";
							$current_modalite=get_valeur_champ("plugin_archAPB_matieres", "id_gepi='".$noteActive->code_service."'", "modalite");
							$current_code_sconet_matiere=sprintf('%06d', get_valeur_champ("plugin_archAPB_matieres", "id_gepi='".$noteActive->code_service."'", "code_sconet"));
							/*
							if(substr($current_code_sconet_matiere, 0, 2)=='03') {
								// On considère toutes les langues vivantes comme une LV1
								// http://infocentre.pleiade.education.fr/bcn/index.php/workspace/viewTable/n/N_MATIERE/d/29
								// http://infocentre.pleiade.education.fr/bcn/index.php/workspace/viewTable/n/N_LANGUE_VIVANTE/d/29
								$current_code_sconet_matiere='030001';
							}
							*/
							$current_id_groupe=$noteActive->code_service;
							if(isset($tab_modalites_election[$current_modalite]['libelle_long'])) {
								echo "<span title=\"".$tab_modalites_election[$current_modalite]['libelle_long']."\">(".$current_modalite.")</span> ";
							}
						}
						echo "-";
						if("D" == $noteActive->etat) {
							echo "Dispensé";
						} elseif ("N" == $noteActive->etat) {
							echo "Non noté";
						} else {
							echo $noteActive->moyenne;
							$nbNotes++;
							$moyenne += floatval($noteActive->moyenne);
						}
						echo "-";
						$exMatiere = $noteActive->code_service;
					}
					if (0 != $nbNotes) {
						echo " moyenne = ".number_format($moyenne/$nbNotes, 2, ',', ' ')." ";
					}
					 ?>
				<?php	} ?>
				</td>
				<td style="text-align: left;">
				<?php
					if (lsl_getDroit('droitAppreciation')) { ?>
					<textarea rows="4" cols="70"  
							  name="app[<?php echo $elvChoisi->ine; ?>_<?php echo $exMatiere ?>_<?php echo $anneeAPB; ?>]"
							  id="app_<?php echo $elvChoisi->ine; ?>_<?php echo $exMatiere ?>_<?php echo $anneeAPB; ?>"
							  maxlength="300"
							  style="text-align: left;"
							  /><?php echo trim(getAppreciationProf($elvChoisi->ine, $exMatiere, $anneeAPB)); ?></textarea>
					<?php $prof = getUtilisateur(getLoginProfAppreciation($elvChoisi->ine, $exMatiere, $anneeAPB)); ?>
					<?php if ($prof) {echo " (".$prof->nom." ".$prof->prenom.")";} ?>
				<?php
					}
					// 20180823 : Compétences
					if($saisie_competences) {
/*
CREATE TABLE IF NOT EXISTS `plugin_lsl_competences` (
`id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id unique',
`code_competences` varchar(10) NOT NULL DEFAULT '' COMMENT 'code MEF des compétences',
`texte_competences` varchar(250) NOT NULL DEFAULT '' COMMENT 'Descriptif des compétences',
`annee` varchar(4) NOT NULL DEFAULT '' COMMENT 'annee LSL de la compétence',
UNIQUE KEY `code_competences` (`code_competences`, `annee`),
PRIMARY KEY (`id`)
) ENGINE=MyISAM  COMMENT 'liste des competences' ;

$sql="CREATE TABLE IF NOT EXISTS `plugin_lsl_eval_competences` (
	`id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id unique',
	`annee` smallint(6) NOT NULL DEFAULT 0 COMMENT 'année',
	`prof` varchar(50) NOT NULL DEFAULT '' COMMENT 'login du prof',
	`eleve` VARCHAR( 50 )  NOT NULL DEFAULT '' COMMENT 'login de l\'élève',
	`code_competences` varchar(300) NOT NULL DEFAULT '' COMMENT 'code de la compétence',
	`valeur` varchar(300) NOT NULL DEFAULT '' COMMENT 'Valeur obtenue sur la compétence',
	`id_APB` int(11) COMMENT 'code matiere dans APB',
	UNIQUE KEY `annee_idAPB_eleve_competence` ( `annee` , `id_APB` , `eleve`, `code_competences` ),
	PRIMARY KEY (`id`)
	) ENGINE=MyISAM  COMMENT 'Niveau obtenu par les élèves sur les compétences' ;";

MariaDB [gepi173]> select * from plugin_lsl_competences_matieres limit 5;
+----+------------+------------------+----------+---------+-------+
| id | MEF        | code_competences | modalite | matiere | annee |
+----+------------+------------------+----------+---------+-------+
|  1 | 2113310411 | 0206             | S        | 061300  | 2016  |
|  2 | 2113310411 | 0207             | S        | 061300  | 2016  |
|  3 | 2113310411 | 0224             | S        | 061300  | 2016  |
|  4 | 2113310411 | 0237             | S        | 061300  | 2016  |
|  5 | 2113310411 | 0242             | S        | 061300  | 2016  |
+----+------------+------------------+----------+---------+-------+
5 rows in set (0.00 sec)

MariaDB [gepi173]> 


*/
						// Dans le cas d'une langue vivante (préfixe 03), on se moque de la modalité O ou F qui est parfois mal paramétrée.
						// De toute façon, ce sont les mêmes compétences en LV1, LV2 et LV3
						/*
						$sql="SELECT DISTINCT plc.code_competences, plc.texte_competences FROM plugin_lsl_competences plc, 
										plugin_lsl_competences_matieres plcm, 
										plugin_archAPB_eleves_mef apb_mef, 
										mef 
									WHERE plcm.annee='".$anneeLSL."' AND 
										plcm.MEF=mef.mef_rattachement AND 
										mef.mef_code=apb_mef.code_mef AND 
										apb_mef.annee='".$anneeAPB."' AND 
										apb_mef.no_gep='".$elvChoisi->ine."' AND 
										plcm.matiere='".$current_code_sconet_matiere."' AND ".(!preg_match("/^03[0-9A-Z]*[1-4]$/", $current_code_sconet_matiere) ? "
										plcm.modalite='".$current_modalite."' AND " : '')."
										plcm.annee=plc.annee AND 
										plcm.code_competences=plc.code_competences 
									ORDER BY plc.code_competences;";
						*/
						if(preg_match("/^03[0-9A-Z]*[1-4]{1}$/", $current_code_sconet_matiere)) {
							$current_code_sconet_matiere_test='03%'.substr($current_code_sconet_matiere, -1);
							$sql="SELECT DISTINCT plc.code_competences, plc.texte_competences FROM plugin_lsl_competences plc, 
										plugin_lsl_competences_matieres plcm, 
										plugin_archAPB_eleves_mef apb_mef, 
										mef 
									WHERE plcm.annee='".$anneeLSL."' AND 
										plcm.MEF=mef.mef_rattachement AND 
										mef.mef_code=apb_mef.code_mef AND 
										apb_mef.annee='".$anneeAPB."' AND 
										apb_mef.no_gep='".$elvChoisi->ine."' AND 
										plcm.matiere LIKE '".$current_code_sconet_matiere_test."' AND 
										plcm.annee=plc.annee AND 
										plcm.code_competences=plc.code_competences 
									ORDER BY plc.code_competences;";
						}
						else {
							$sql="SELECT DISTINCT plc.code_competences, plc.texte_competences FROM plugin_lsl_competences plc, 
										plugin_lsl_competences_matieres plcm, 
										plugin_archAPB_eleves_mef apb_mef, 
										mef 
									WHERE plcm.annee='".$anneeLSL."' AND 
										plcm.MEF=mef.mef_rattachement AND 
										mef.mef_code=apb_mef.code_mef AND 
										apb_mef.annee='".$anneeAPB."' AND 
										apb_mef.no_gep='".$elvChoisi->ine."' AND 
										plcm.matiere='".$current_code_sconet_matiere."' AND ".(!preg_match("/^03[0-9A-Z]*[1-4]$/", $current_code_sconet_matiere) ? "
										plcm.modalite='".$current_modalite."' AND " : '')."
										plcm.annee=plc.annee AND 
										plcm.code_competences=plc.code_competences 
									ORDER BY plc.code_competences;";
						}
						//echo "3<br />";
						//echo $sql."<br />";
						$res_comp=mysqli_query($mysqli, $sql);
						$nb_competences=mysqli_num_rows($res_comp);
						if($nb_competences>0) {
							// Récupérer ce qui est déjà validé.
							$tab_select=array();
							$sql="SELECT * FROM plugin_lsl_eval_competences 
										WHERE annee='".$anneeAPB."' AND 
											eleve='".$elvChoisi->ine."' AND 
											id_APB='".$current_id_groupe."';";
							//echo $sql."<br />";
							$res_comp_deja=mysqli_query($mysqli, $sql);
							if(mysqli_num_rows($res_comp_deja)>0) {
								while($lig_comp_deja=mysqli_fetch_object($res_comp_deja)) {
									$tab_select[$lig_comp_deja->code_competences]=$lig_comp_deja->valeur;
								}
							}

							// 4 niveaux pour tous les enseignements sauf les langues vivantes qui ont 6 niveaux
							/*
							if(($current_code_sconet_matiere=='030001')||
								($current_code_sconet_matiere=='030002')||
								($current_code_sconet_matiere=='030003')||
								($current_code_sconet_matiere=='030004')) {
							*/
							if(preg_match("/^03[0-9A-Z]*[1-4]$/", $current_code_sconet_matiere)) {
								echo "
							<table class='boireaus boireaus_alt'>
								<tr>
									<th>Compétence</th>
									<th title=\"Compétence non évaluée\" onclick=\"coche_colonne_comp($cpt_ligne, 'NE', 5)\">NE</th>
									<th title=\"Utilisateur élémentaire, niveau introductif\" onclick=\"coche_colonne_comp($cpt_ligne, 'A1', 5)\" style='color:#f3843d'>A1</th>
									<th title=\"Utilisateur élémentaire, niveau \" onclick=\"coche_colonne_comp($cpt_ligne, 'A2', 5)\" style='color:#1499a8'>A2</th>
									<th title=\"Utilisateur indépendant, niveau seuil\" onclick=\"coche_colonne_comp($cpt_ligne, 'B1', 5)\" style='color:#006ca5'>B1</th>
									<th title=\"Utilisateur indépendant, niveau avancé\" onclick=\"coche_colonne_comp($cpt_ligne, 'B2', 5)\" style='color:#ed5444'>B2</th>
									<th title=\"Utilisateur expérimenté, autonome\" onclick=\"coche_colonne_comp($cpt_ligne, 'C1', 5)\" style='color:#1aa773'>C1</th>
									<th title=\"Utilisateur expérimenté, maîtrise\" onclick=\"coche_colonne_comp($cpt_ligne, 'C2', 5)\" style='color:#613e90'>C2</th>
									<th title=\"Supprimer cette évaluation de compétence\" onclick=\"coche_colonne_comp($cpt_ligne, '0', 5)\" style='color:'><img src='../../images/delete16.png' class='icone16' /></th>
								</tr>";
								while($lig_comp=mysqli_fetch_object($res_comp)) {
									/*
									echo "<pre>";
									print_r($lig_comp);
									echo "</pre>";
									*/
									echo "
									<tr>
										<td title='Compétence n°".$lig_comp->code_competences."' id='libelle_comp_".$cpt_ligne."'>".$lig_comp->texte_competences."</td>
										<td id='td_comp_".$cpt_ligne."_NE'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_NE'
												value='NE' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='NE') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_A1'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_A1'
												value='A1' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='A1') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_A2'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_A2'
												value='A2' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='A2') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_B1'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_B1'
												value='B1' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='B1') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_B2'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_B2'
												value='B2' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='B2') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_C1'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_C1'
												value='C1' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='C1') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_C2'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_C2'
												value='C2' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='C2') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_0'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_0'
												value='0' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='0') ? 'checked' : '')." /></td>
									</tr>";
									$cpt_ligne++;
								}
								echo "
							</table>";
							}
							elseif(($current_code_sconet_matiere=='100100')||
								($current_code_sconet_matiere=='104100')) {
								echo "
							<table class='boireaus boireaus_alt'>
								<tr>
									<th title=\"Compléter au moins trois compétences parmi les 5 premières et une compétence parmi les 3 dernières.\"><img src='../../images/icons/ico_aide.png' width='15' height='25' /></th>
									<th>Compétence</th>
									<th title=\"Compétence non évaluée\" onclick=\"coche_colonne_comp($cpt_ligne, 'NE', $nb_competences)\">NE</th>
									<th title=\"Compétence non maîtrisée\" style='color:red' onclick=\"coche_colonne_comp($cpt_ligne, '1', $nb_competences)\">NM</th>
									<th title=\"Compétence insuffisamment maîtrisée\" style='color:orange' onclick=\"coche_colonne_comp($cpt_ligne, '2', $nb_competences)\">IM</th>
									<th title=\"Compétence maîtrisée\" style='color:green' onclick=\"coche_colonne_comp($cpt_ligne, '3', $nb_competences)\">M</th>
									<th title=\"Compétence bien maîtrisée\" style='color:blue' onclick=\"coche_colonne_comp($cpt_ligne, '4', $nb_competences)\">BM</th>
									<th title=\"Supprimer cette évaluation de compétence\" onclick=\"coche_colonne_comp($cpt_ligne, '0', $nb_competences)\"><img src='../../images/delete16.png' class='icone16' /></th>
								</tr>";
								$cpt_comp_eps=0;
								while($lig_comp=mysqli_fetch_object($res_comp)) {
									/*
									echo "<pre>";
									print_r($lig_comp);
									echo "</pre>";
									*/
									echo "
									<tr>";
									if($cpt_comp_eps==0) {
										echo "
										<td rowspan='5' style='text-align:left; background-color:orange;' title='Compléter au moins trois compétences parmi les 5 premières.'></td>";
									}
									elseif($cpt_comp_eps==5) {
										echo "
										<td rowspan='3' style='text-align:left; background-color:lightgreen;' title='Compléter au moins une compétence parmi les 3 dernières.'></td>";
									}
									echo "
										<td style='text-align:left' title='Compétence n°".$lig_comp->code_competences."' id='libelle_comp_".$cpt_ligne."'>".$lig_comp->texte_competences."</td>
										<td id='td_comp_".$cpt_ligne."_NE'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_NE'
												value='NE' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='NE') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_1'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_1'
												value='1' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='1') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_2'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_2'
												value='2' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='2') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_3'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_3'
												value='3' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='3') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_4'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_4'
												value='4' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='4') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_0'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_0'
												value='0' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='0') ? 'checked' : '')." /></td>
									</tr>";
									$cpt_comp_eps++;
									$cpt_ligne++;
								}
								echo "
							</table>";
							}
							else {
								echo "
							<table class='boireaus boireaus_alt'>
								<tr>
									<th>Compétence</th>
									<th title=\"Compétence non évaluée\" onclick=\"coche_colonne_comp($cpt_ligne, 'NE', $nb_competences)\">NE</th>
									<th title=\"Compétence non maîtrisée\" style='color:red' onclick=\"coche_colonne_comp($cpt_ligne, '1', $nb_competences)\">NM</th>
									<th title=\"Compétence insuffisamment maîtrisée\" style='color:orange' onclick=\"coche_colonne_comp($cpt_ligne, '2', $nb_competences)\">IM</th>
									<th title=\"Compétence maîtrisée\" style='color:green' onclick=\"coche_colonne_comp($cpt_ligne, '3', $nb_competences)\">M</th>
									<th title=\"Compétence bien maîtrisée\" style='color:blue' onclick=\"coche_colonne_comp($cpt_ligne, '4', $nb_competences)\">BM</th>
									<th title=\"Supprimer cette évaluation de compétence\" onclick=\"coche_colonne_comp($cpt_ligne, '0', $nb_competences)\"><img src='../../images/delete16.png' class='icone16' /></th>
								</tr>";
								while($lig_comp=mysqli_fetch_object($res_comp)) {
									/*
									echo "<pre>";
									print_r($lig_comp);
									echo "</pre>";
									*/
									echo "
									<tr>
										<td style='text-align:left' title='Compétence n°".$lig_comp->code_competences."' id='libelle_comp_".$cpt_ligne."'>".$lig_comp->texte_competences."</td>
										<td id='td_comp_".$cpt_ligne."_NE'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_NE'
												value='NE' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='NE') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_1'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_1'
												value='1' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='1') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_2'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_2'
												value='2' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='2') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_3'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_3'
												value='3' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='3') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_4'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_4'
												value='4' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='4') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_0'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_0'
												value='0' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='0') ? 'checked' : '')." /></td>
									</tr>";
									$cpt_ligne++;
								}
								echo "
							</table>";
							}
						}
						elseif((mysqli_num_rows($res_comp)==0)&&(preg_match("/^03[0-9A-Z]*[1-4]$/", $current_code_sconet_matiere))) {
							// On a probablement une langue vivante avec le préfixe 03, mais elle n'a pas d'association spécifique pour son code matière.
							// On va faire comme si c'était une LV1 030001

							$sql="SELECT DISTINCT plc.code_competences, plc.texte_competences FROM plugin_lsl_competences plc, 
											plugin_lsl_competences_matieres plcm, 
											plugin_archAPB_eleves_mef apb_mef, 
											mef 
										WHERE plcm.annee='".$anneeLSL."' AND 
											plcm.MEF=mef.mef_rattachement AND 
											mef.mef_code=apb_mef.code_mef AND 
											apb_mef.annee='".$anneeAPB."' AND 
											apb_mef.no_gep='".$elvChoisi->ine."' AND 
											plcm.matiere='030001' AND 
											plcm.annee=plc.annee AND 
											plcm.code_competences=plc.code_competences 
										ORDER BY plc.code_competences;";
							//echo "4<br />";
							//echo $sql."<br />";
							$res_comp=mysqli_query($mysqli, $sql);
							$nb_competences=mysqli_num_rows($res_comp);

							if($nb_competences>0) {
								// Récupérer ce qui est déjà validé.
								$tab_select=array();
								$sql="SELECT * FROM plugin_lsl_eval_competences 
											WHERE annee='".$anneeAPB."' AND 
												eleve='".$elvChoisi->ine."' AND 
												id_APB='".$current_id_groupe."';";
								//echo $sql."<br />";
								$res_comp_deja=mysqli_query($mysqli, $sql);
								if(mysqli_num_rows($res_comp_deja)>0) {
									while($lig_comp_deja=mysqli_fetch_object($res_comp_deja)) {
										$tab_select[$lig_comp_deja->code_competences]=$lig_comp_deja->valeur;
									}
								}

								echo "
							<table class='boireaus boireaus_alt'>
								<tr>
									<th>Compétence</th>
									<th title=\"Compétence non évaluée\" onclick=\"coche_colonne_comp($cpt_ligne, 'NE', 5)\">NE</th>
									<th title=\"Utilisateur élémentaire, niveau introductif\" onclick=\"coche_colonne_comp($cpt_ligne, 'A1', 5)\" style='color:#f3843d'>A1</th>
									<th title=\"Utilisateur élémentaire, niveau \" onclick=\"coche_colonne_comp($cpt_ligne, 'A2', 5)\" style='color:#1499a8'>A2</th>
									<th title=\"Utilisateur indépendant, niveau seuil\" onclick=\"coche_colonne_comp($cpt_ligne, 'B1', 5)\" style='color:#006ca5'>B1</th>
									<th title=\"Utilisateur indépendant, niveau avancé\" onclick=\"coche_colonne_comp($cpt_ligne, 'B2', 5)\" style='color:#ed5444'>B2</th>
									<th title=\"Utilisateur expérimenté, autonome\" onclick=\"coche_colonne_comp($cpt_ligne, 'C1', 5)\" style='color:#1aa773'>C1</th>
									<th title=\"Utilisateur expérimenté, maîtrise\" onclick=\"coche_colonne_comp($cpt_ligne, 'C2', 5)\" style='color:#613e90'>C2</th>
									<th title=\"Supprimer cette évaluation de compétence\" onclick=\"coche_colonne_comp($cpt_ligne, '0', 5)\" style='color:'><img src='../../images/delete16.png' class='icone16' /></th>
								</tr>";
								while($lig_comp=mysqli_fetch_object($res_comp)) {
									/*
									echo "<pre>";
									print_r($lig_comp);
									echo "</pre>";
									*/
									echo "
									<tr>
										<td title='Compétence n°".$lig_comp->code_competences."' id='libelle_comp_".$cpt_ligne."'>".$lig_comp->texte_competences."</td>
										<td id='td_comp_".$cpt_ligne."_NE'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_NE'
												value='NE' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='NE') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_A1'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_A1'
												value='A1' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='A1') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_A2'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_A2'
												value='A2' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='A2') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_B1'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_B1'
												value='B1' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='B1') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_B2'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_B2'
												value='B2' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='B2') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_C1'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_C1'
												value='C1' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='C1') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_C2'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_C2'
												value='C2' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='C2') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_0'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_0'
												value='0' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='0') ? 'checked' : '')." /></td>
									</tr>";
									$cpt_ligne++;
								}
								echo "
							</table>";
							}
						}
						elseif((mysqli_num_rows($res_comp)==0)&&(preg_match("/^03[0-9A-Z]*8$/", $current_code_sconet_matiere))) {
							// On a Littérature étrangère avec le préfixe 03 et le suffixe 8,
							// mais elle n'a pas d'association spécifique pour son code matière.
							// On va faire comme si c'était une LV1 030008
							$sql="SELECT DISTINCT plc.code_competences, plc.texte_competences FROM plugin_lsl_competences plc, 
											plugin_lsl_competences_matieres plcm, 
											plugin_archAPB_eleves_mef apb_mef, 
											mef 
										WHERE plcm.annee='".$anneeLSL."' AND 
											plcm.MEF=mef.mef_rattachement AND 
											mef.mef_code=apb_mef.code_mef AND 
											apb_mef.annee='".$anneeAPB."' AND 
											apb_mef.no_gep='".$elvChoisi->ine."' AND 
											plcm.matiere='030008' AND 
											plcm.annee=plc.annee AND 
											plcm.code_competences=plc.code_competences 
										ORDER BY plc.code_competences;";
							//echo "2<br />";
							//echo $sql."<br />";
							$res_comp=mysqli_query($mysqli, $sql);
							$nb_competences=mysqli_num_rows($res_comp);

							if($nb_competences>0) {
								// Récupérer ce qui est déjà validé.
								$tab_select=array();
								$sql="SELECT * FROM plugin_lsl_eval_competences 
											WHERE annee='".$anneeAPB."' AND 
												eleve='".$elvChoisi->ine."' AND 
												id_APB='".$current_id_groupe."';";
								//echo $sql."<br />";
								$res_comp_deja=mysqli_query($mysqli, $sql);
								if(mysqli_num_rows($res_comp_deja)>0) {
									while($lig_comp_deja=mysqli_fetch_object($res_comp_deja)) {
										$tab_select[$lig_comp_deja->code_competences]=$lig_comp_deja->valeur;
									}
								}

								echo "
							<table class='boireaus boireaus_alt'>
								<tr>
									<th>Compétence</th>
									<th title=\"Compétence non évaluée\" onclick=\"coche_colonne_comp($cpt_ligne, 'NE', $nb_competences)\">NE</th>
									<th title=\"Compétence non maîtrisée\" style='color:red' onclick=\"coche_colonne_comp($cpt_ligne, '1', $nb_competences)\">NM</th>
									<th title=\"Compétence insuffisamment maîtrisée\" style='color:orange' onclick=\"coche_colonne_comp($cpt_ligne, '2', $nb_competences)\">IM</th>
									<th title=\"Compétence maîtrisée\" style='color:green' onclick=\"coche_colonne_comp($cpt_ligne, '3', $nb_competences)\">M</th>
									<th title=\"Compétence bien maîtrisée\" style='color:blue' onclick=\"coche_colonne_comp($cpt_ligne, '4', $nb_competences)\">BM</th>
									<th title=\"Supprimer cette évaluation de compétence\" onclick=\"coche_colonne_comp($cpt_ligne, '0', $nb_competences)\"><img src='../../images/delete16.png' class='icone16' /></th>
								</tr>";
								while($lig_comp=mysqli_fetch_object($res_comp)) {
									/*
									echo "<pre>";
									print_r($lig_comp);
									echo "</pre>";
									*/
									echo "
									<tr>
										<td style='text-align:left' title='Compétence n°".$lig_comp->code_competences."' id='libelle_comp_".$cpt_ligne."'>".$lig_comp->texte_competences."</td>
										<td id='td_comp_".$cpt_ligne."_NE'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_NE'
												value='NE' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='NE') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_1'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_1'
												value='1' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='1') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_2'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_2'
												value='2' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='2') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_3'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_3'
												value='3' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='3') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_4'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_4'
												value='4' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='4') ? 'checked' : '')." /></td>
										<td id='td_comp_".$cpt_ligne."_0'><input type='radio' 
												name='comp[".$elvChoisi->ine.'_'.$exMatiere.'_'.$anneeAPB.'_'.$lig_comp->code_competences."]' 
												id='comp_".$cpt_ligne."_0'
												value='0' 
												onchange=\"changement(); maj_couleurs_maitrise($cpt_ligne)\" 
												".((isset($tab_select[$lig_comp->code_competences]) && $tab_select[$lig_comp->code_competences]=='0') ? 'checked' : '')." /></td>
									</tr>";
									$cpt_ligne++;
								}
								echo "
							</table>";
							}

						}
						//$cpt_ligne++;
					}
				?>
				</td>
			</tr>
				<?php	$cpt *= -1; ?>
				<?php } ?>

		</table>

		<script type='text/javascript'>

			var tab_valeur=new Array('NE', '1', '2', '3', '4', '0', 'A1', 'A2', 'B1', 'B2', 'C1', 'C2');

			var couleur_maitrise=new Array();
			couleur_maitrise['NE']='black';
			couleur_maitrise['1']='red';
			couleur_maitrise['2']='orange';
			couleur_maitrise['3']='green';
			couleur_maitrise['4']='blue';

			couleur_maitrise['0']='black';

			couleur_maitrise['A1']='#f3843d';
			couleur_maitrise['A2']='#1499a8';
			couleur_maitrise['B1']='#006ca5';
			couleur_maitrise['B2']='#ed5444';
			couleur_maitrise['C1']='#1aa773';
			couleur_maitrise['C2']='#613e90';
			

			//var couleur_maitrise={'NE':'black', '1':'red', '2':'orange', '3':'green', '4':'blue', '0':'black', 'A1':'#1853a', 'A2':'#1499a8', 'B1':'#006ca5', 'B2':'#ed5444', 'C1':'#1aa773', 'C2':'#613e90'};

			function maj_couleurs_maitrise(cpt_lig) {

				if(document.getElementById('libelle_comp_'+cpt_lig)) {
					/*
					if(cpt_lig<1) {
						alert('plop');
					}
					*/
					indice_coche='_';
					for(j=0;j<tab_valeur.length;j++) {
						if((document.getElementById('comp_'+cpt_lig+'_'+tab_valeur[j]))&&
						(document.getElementById('comp_'+cpt_lig+'_'+tab_valeur[j]).checked==true)) {
							indice_coche=j;
							break;
						}
					}

					if(indice_coche!='_') {
						for(j=0;j<tab_valeur.length;j++) {
							if(document.getElementById('td_comp_'+cpt_lig+'_'+tab_valeur[j])) {
								document.getElementById('td_comp_'+cpt_lig+'_'+tab_valeur[j]).style.backgroundColor='';
							}
						}

						/*
						if(cpt_lig<5) {
							alert('indice_coche='+indice_coche+' et tab_valeur['+indice_coche+']='+tab_valeur[indice_coche]);
							alert('couleur_maitrise[tab_valeur[indice_coche]]='+couleur_maitrise[tab_valeur[indice_coche]]);
						}
						*/

						document.getElementById('libelle_comp_'+cpt_lig).style.color=couleur_maitrise[tab_valeur[indice_coche]];
						//if(tab_valeur[indice_coche]!='0') {
							document.getElementById('td_comp_'+cpt_lig+'_'+tab_valeur[indice_coche]).style.backgroundColor=couleur_maitrise[tab_valeur[indice_coche]];
						//}
					}
				}
			}

			for(i=0;i<<?php echo $cpt_ligne;?>;i++) {
				maj_couleurs_maitrise(i);
			}

			function coche_colonne_comp(cpt_lig, valeur, nb_lig) {
				for(i=0;i<nb_lig;i++) {
					if(document.getElementById('comp_'+cpt_lig+'_'+valeur)) {
						document.getElementById('comp_'+cpt_lig+'_'+valeur).checked=true;
						maj_couleurs_maitrise(cpt_lig);
					}
					cpt_lig++;
				}
			}
		</script>

		<p class="center">
			<?php if (function_exists("add_token_field")) echo add_token_field(); ?>
			<input style="margin-top:1em;" type="submit" name="appEleves" id="appEleves" value="Enregistrer" />
		</p>
		<div id='fixe'>
			<input style="margin-top:1em;" type="submit" name="appEleves2" id="appEleves2" value="Enregistrer" />
		</div>
	</form>
</fieldset>
<!-- Un espace en bas de page pour ne pas avoir de blague au scroll avec le div fixe -->
<p><br /></p>

	<?php } ?>

<?php }


