<?php

//********************************************
//********* Récupération des données *********
//********************************************
$sxe = simplexml_load_string(mb_convert_encoding(file_get_contents('livret.xml'),"ISO-8859-15","ISO-8859-15"));
$sxe->entete->etablissement = getSettingValue("gepiSchoolRne");

$niveaux = niveauConcernees($anneeScolaire, $selectClasses);
$classes = classesConcernees($anneeScolaire, $selectClasses);
$eleves = elevesConcernees($anneeScolaire, $selectClasses);
// id , ine , nom , prenom , ddn , annee , anneelsl , id_classe , code_mef //

// 20180823 : Compétences
$saisie_competences=lsl_getDroit('droitCompetences');

//================================================
// 20181008
$restriction_extraction_a_certains_ele_id=false;
$tab_conversion_ele_id=array(
// 1ère littéraire (110):
1489898=>2528228,
1490002=>2799467,
1490028=>2799841,
1490222=>2799889,
1490264=>3055309,
// 1ère ES (120):
// 1ère S (130):
// TL (010):
1340689=>2528338,
1340723=>2528374,
1340763=>2528382,
1340787=>2559490,
1672383=>2620850,
// TES (020):
1340681=>2203867,
1340685=>2203901,
1340713=>2204059,
1168276=>2204105,
1340791=>2528142,
1340799=>2528144,
1340803=>2528208,
1340811=>2528340,
1340825=>2528360,
1340835=>2528418,
// TS (030):
1340703=>2203909,
1340711=>2528134,
1340717=>2528146,
1340727=>2528170,
1340733=>2528230,
1490014=>2528324,
1340739=>2528394,
1490098=>2947713,
1340761=>3058873,
1340739=>2528134,
1340895=>2528230,
1490098=>2528146,
1340785=>2528170,
1340815=>2528230,
1340895=>2528324
);

/*
// TL:
$tab_conversion_ele_id=array(1340689=>2197489,
1340723=>2466688,
1340763=>2466722,
1340787=>2624468);
*/
//================================================

$eleves2 = $eleves;
while($eleve = $eleves2->fetch_object()){
    // 20181008
    if ((LSL_get_ele_id($eleve))&&
       ((!$restriction_extraction_a_certains_ele_id)||((isset($eleve->id))&&(array_key_exists($eleve->id, $tab_conversion_ele_id))))) {
        /*
        echo "<pre>";
        print_r($eleve);
        echo "</pre>==================================<br />";
        */
        $changeClasse = LSL_change_classe($eleve->ine,$anneeAPB);
        if ($changeClasse) {
            $affiche = 'Dans APB '.$eleve->ine.' cet élève a changé de classe ou de groupe en cours d\'année '.($anneeAPB-1).'-'.$anneeAPB;
            $affiche .= ' ou vous avez plusieurs enseignements pour une matière. Vous devriez vérifier les remontées de cet élève';
            echo '<p>'.$affiche.'</p>';
            ecrit($affiche."\n");
        }
        $changeClasseLSL = LSL_change_classe($eleve->ine,$anneeLSL);
        if ($changeClasseLSL) {
            $affiche = 'Dans LSL '.$eleve->ine.' cet élève a changé de classe ou de groupe en cours d\'année '.($anneeAPB-1).'-'.$anneeAPB;
            //echo '<p>'.$affiche.'</p>';
            ecrit($affiche."\n");
        }
        $lastNiveau="";
        $newElv = $sxe->donnees->addChild('eleve');
        // 20181008
        if($restriction_extraction_a_certains_ele_id) {
            $newElv->addAttribute('id', $tab_conversion_ele_id[$eleve->id]);
        }
        else {
            $newElv->addAttribute('id', LSL_get_ele_id($eleve));
        }
        ecrit("\nid → ".LSL_get_ele_id($eleve)."\n");

        // récupérer les engagements
        $listeEngagements = engagementsEleve($eleve->ine);
        if(($listeEngagements->num_rows > 0)) {
            ecrit("Engagements :\n");
            $engagements = $newElv->addChild('engagements');
            if(($listeEngagements->num_rows > 0)) {
                while ($engagement = $listeEngagements->fetch_object()){
                    $os=array(1,2,3,4,5);
                    if (in_array($engagement->id_engagement, $os)){
                        $newEngagement = $engagements->addChild('engagement');
                        $newEngagement->addAttribute('code',$engagement->code );
                        ecrit('Code engagement → '.$engagement->code."\n");
                    } else {
                        $description=substr($engagement->description,0,300);
                        $newEngagement = $engagements->addChild('engagement-autre',$description);
                        ecrit('Engagement autre → '.$description."\n");
                    }
                }
            }
        }

        // récupérer les scolarités
        $scolarites = $newElv->addChild('scolarites');
        $annees = anneesEleve($eleve->ine);
        $derniereAnnee = NULL;
        // annee , id_classe , nom_court , nom_complet , login_pp , niveau // 
        while ($annee = $annees->fetch_object()) {
            //var_dump($annee);
            //echo '<br />';
            ecrit("\n-----------------".$annee->annee."-----------------\n");
            
            if (!$derniereAnnee || $annee->niveau != $derniereAnnee) {
                // on change d'année
                $derniereAnnee = $annee->niveau;
                ecrit('année → '.$annee->annee.' nom court → '.$annee->nom_court." code MEF → ".$annee->code_mef."\n");

                // On récupère le niveau
                $getNiveau = getNiveau($annee->annee, $annee->id_classe);
                $niveau = $getNiveau->fetch_object();
                // Ne pas récupérer une année redoublée
                if ($niveau && $lastNiveau != $niveau->apb_niveau) {

			// 20181202
			// Récupération des programmes pour la formation courante:
			$tab_programmes=array();
			$res_programmes=extraitProgrammes($annee->code_mef, $annee->annee);
			if(mysqli_num_rows($res_programmes)>0) {
				while($lig_programme=mysqli_fetch_assoc($res_programmes)) {
					$tab_programmes[$lig_programme['matiere']][$lig_programme['Modalite']]=$lig_programme;
				}
			}
			/*
			echo "\$tab_programmes=extraitProgrammes(".$annee->code_mef.");<br />";
			echo "<pre>";
			print_r($tab_programmes);
			echo "</pre>";
			*/

                    $newScolarite = $scolarites->addChild('scolarite');
                    $newScolarite->addAttribute('annee-scolaire',$annee->annee);
                    $codePeriode=codePeriode($eleve->ine, $annee->annee);
                    $newScolarite->addAttribute('code-periode',$codePeriode);
                    ecrit("Scolarité : année scolaire → ".$annee->annee." code période → ".$codePeriode."\n");

                    $lastNiveau = $niveau->apb_niveau;
                    ecrit("Dernier niveau → ".$lastNiveau."\n");

                    $nbPeriode = 0;
                    if ($newScolarite["code-periode"] == "T") {
                            $nbPeriode = 3;
                    } elseif ($newScolarite["code-periode"] == "S") {
                            $nbPeriode = 2;
                    }

                    $newEvaluations = evaluations($eleve->ine,$annee->annee);
                    $lastMatiere = NULL;
                    $lastService = NULL;
                    $periodesNotes = NULL;
                    ecrit("nombre d'évaluation : ".$newEvaluations->num_rows."\n");

                    while ($evaluation = $newEvaluations->fetch_object()) {
                        /*
                        if ($eleve->id == '1413136') {
                            var_dump ($eleve);
                            echo '<br /><br />';
                            var_dump ($evaluation);
                            echo '<br /><br />';
                        }
                        */

                            // 20181202: DEBUG
                            /*
                            echo "<pre>";
                            print_r($eleve);
                            echo '<br /><br />';
                            print_r($evaluation);
                            echo '<br /><br />';
                            echo "</pre>";
                            */

                        $sectionEuro = EstSectionEuro(str_pad($evaluation->code_sconet, 6, '0', STR_PAD_LEFT));
                        if(!$sectionEuro) {

                            // TODO on limite aux $evaluation de la série
                            if ('0' == $evaluation->code_sconet || 0 == intval($evaluation->code_sconet)) {
                                $getMatiere = getMatiere($evaluation->code_service,$annee->annee+1,'nom_complet');
                                echo "<p class='red'>L'enseignement ".$evaluation->code_service." → ";
                                echo $getMatiere.", n'est pas reconnu";
                                echo " pour l'année ".$annee->annee."-".($annee->annee+1).".";
                                echo " Vous devez régler ce problème, les notes ne sont pas exportées.</p>";
                                echo "<p class='red'>La matière n'est peut-être pas à exporter pour cette année.</p>";
                                continue;
                            }
                            //var_dump($evaluation);
                            if (LSL_matiereDeSerie($annee->code_mef, str_pad($evaluation->code_sconet, 6, '0', STR_PAD_LEFT),$annee->annee, $evaluation->modalite)) {
                                //echo 'La matière '.$annee->code_mef.'est bien enseignée';
                                ecrit("La matière ".str_pad($evaluation->code_sconet, 6, '0', STR_PAD_LEFT)." → ".$evaluation->modalite
                                        . " est bien enseignée en ".$annee->code_mef." en ".$annee->annee."-".($annee->annee+1)."\n");
                                if(is_array($periodesNotes)) {ecrit(count($periodesNotes)."\n");}

                                if ($lastService != $evaluation->code_service) {
                                    $lastService = $evaluation->code_service;
                                    if ($lastMatiere != str_pad($evaluation->code_sconet, 6, '0', STR_PAD_LEFT).$evaluation->modalite) {
                                        //echo $evaluation->modalite;
                                        // on change de matière
                                        $periodesNotes;
                                        if ($periodesNotes) {
                                            // On vérifie si le trimestre est renseigné pour des élèves, 
                                            // si oui, on met à -1 pour cet élève
                                            PeriodeNExistePas($Periodiques, $periodesNotes, $annee, $lastService, $newScolarite);
                                        }
                                        $periodesNotes = NULL;

                                        $lastMatiere = str_pad($evaluation->code_sconet, 6, '0', STR_PAD_LEFT).$evaluation->modalite;
                                        $compteEleves = compteElvEval($annee->annee, $evaluation->code_service);
                                        $compteElv = $compteEleves->fetch_object();
                                        if ($compteElv->nombre){
                                            $newEval = $newScolarite->addChild('evaluation');
                                            //TODO : rechercher la modalité dans les tables LSL
                                            $code_matiere = str_pad($evaluation->code_sconet, 6, '0', STR_PAD_LEFT);

                                            // 20180823
                                            // id_groupe : $evaluation->code_service
                                            // code_sconet_matiere : $evaluation->code_sconet (sans zéro à gauche)
                                            // code_sconet_matiere à 7 chiffres : $code_matiere
                                            //echo 'DEBUG: '.$eleve->ine.' '.$evaluation->code_service.' '.$evaluation->code_sconet.' '.$code_matiere.'<br />';
                                            /*
                                            $modalite = LSL_modalite($code_matiere, $annee->code_mef);
                                            if (!$modalite) {
                                                    $modalite = $evaluation->modalite;
                                            }
                                             * 
                                             */
                                            $modalite = $evaluation->modalite;
                                            $newEval->addAttribute('modalite-election',$modalite);
                                            $newEval->addAttribute('code-matiere',$code_matiere);
                                            $newStructure = $newEval->addChild('structure');
                                            $structureEvaluation = structureEval($annee->annee, $evaluation->code_service);
                                            $structureEval = $structureEvaluation->fetch_object();

                                            $newStructure->addAttribute('effectif',$compteElv->nombre);

                                            // 20181202
                                            if((!isset($tab_programmes[$code_matiere][$modalite]))||
                                            ($tab_programmes[$code_matiere][$modalite]['note']=='y')) {
                                                $moinsHuit = reparMoinsHuit($annee->annee, $evaluation->code_service);
                                                $huitDouze = reparMoinsHuit($annee->annee, $evaluation->code_service, 8, 12);
                                                $plusDouze = 100-($moinsHuit + $huitDouze);


                                                $newStructure->addAttribute('moyenne',round($structureEval->moyenne,2));
                                                $newStructure->addAttribute('repar-moins-huit',$moinsHuit);
                                                $newStructure->addAttribute('repar-huit-douze',$huitDouze);
                                                $newStructure->addAttribute('repar-plus-douze',$plusDouze);
                                            }

                                            $structureEvaluation ->close();
                                            //$appAnnuelle=" ";
                                            $appAnnuelle=getAppreciationProf($eleve->ine, $evaluation->code_service, $annee->annee+1);
                                            if (!$appAnnuelle) {
                                                $appAnnuelle="&#160;";
                                                $newMessage = $eleve->nom." ".$eleve->prenom;
                                                $newMessage .= " n'a pas d'appréciation pour la matière ".getMatiere($evaluation->code_service, $annee->annee+1);
                                                $newMessage .= " pour l'année ".$annee->annee."-".($annee->annee+1) ;
                                                $messages[] = $newMessage;
                                            } else {
                                                $newEval->addChild('annuelle', $appAnnuelle);
                                            }


                                            // 20181202
                                            if((!isset($tab_programmes[$code_matiere][$modalite]))||
                                            ($tab_programmes[$code_matiere][$modalite]['note']=='y')) {
                                                $Periodiques = $newEval->addChild('periodiques');
                                                $moyennes = moyenneTrimestre($annee->annee, $evaluation->code_service, $eleve->ine);
                                                //echo $annee->annee."<br />";
                                                //var_dump($moyennes);
                                                while ($moyenne = $moyennes->fetch_object()) {
                                                    $periodesNotes[] = $moyenne->trimestre;
                                                    $trimestre = $Periodiques->addChild('periode');
                                                    $trimestre->addAttribute('numero', $moyenne->trimestre);
                                                    if ("S" == $moyenne->etat) {
                                                            $trimestre->addAttribute('moyenne', $moyenne->moyenne);
                                                    } else {
                                                            $trimestre->addAttribute('moyenne', -1);
                                                    }
                                                }
                                                $moyennes->close();
                                            }

							if($saisie_competences) {
								// 20180823 : Compétences
								// id_groupe : $evaluation->code_service
								// code_sconet_matiere : $evaluation->code_sconet (sans zéro à gauche)
								// code_sconet_matiere à 7 chiffres : $code_matiere
								$sql="SELECT * FROM plugin_lsl_eval_competences 
											WHERE annee='".($annee->annee+1)."' AND 
												eleve='".$eleve->ine."' AND 
												id_APB='".$evaluation->code_service."';";
								//echo $sql."<br />";
								$res_comp_deja=mysqli_query($mysqli, $sql);
								if(mysqli_num_rows($res_comp_deja)>0) {
									$newCompetences = $newEval->addChild('competences');
									while($lig_comp_deja=mysqli_fetch_object($res_comp_deja)) {
										CreeNoeudCompetence ($lig_comp_deja->code_competences, $lig_comp_deja->valeur);
									}
								}
							}

                                            $newEnseignants = $newEval->addChild('enseignants');
                                            $enseignantsPassees = getEnseignantsPassees($annee->annee, $evaluation->code_service, $newEnseignants);
                                            if (!$enseignantsPassees) {
                                                $getEnseignants = Enseignants($annee->annee, $evaluation->code_service);
                                                while ($getEnseignant = $getEnseignants->fetch_object()) {
                                                    CreeNoeudProf ($getEnseignant->nom, $getEnseignant->prenom);
                                                }
                                                $getEnseignants->close();
                                            }
                                        }
                                        $compteEleves->close();

                                    } else {
                                        /*
                                        $moyennes = moyenneTrimestre($annee->annee, $evaluation->code_service, $eleve->ine);
                                        while ($moyenne = $moyennes->fetch_object()) {
                                            $periodesNotes[] = $moyenne->trimestre;
                                            $trimestre = $Periodiques->addChild('periode');
                                            $trimestre->addAttribute('numero', $moyenne->trimestre);
                                            if ("S" == $moyenne->etat) {
                                                $trimestre->addAttribute('moyenne', $moyenne->moyenne);
                                            } else {
                                                $trimestre->addAttribute('moyenne', -1);
                                            }
                                        }
                                         * 
                                         */
                                    }
                                }
                            } else {
                                // on change de matière
                                if ($periodesNotes) {
                                    // On vérifie si le trimestre est renseigné pour des élèves, 
                                    // si oui, on met à -1 pour cet élève
                                    PeriodeNExistePas($Periodiques, $periodesNotes, $annee, $lastService, $newScolarite);
                                    $periodesNotes = NULL;
                                }

                            }
                        }
                    
                    }
                    
                    $newEvaluations->close();
                    // on change de matière
                    if ($periodesNotes) {
                        // On vérifie si le trimestre est renseigné pour des élèves, 
                        // si oui, on met à -1 pour cet élève
                        PeriodeNExistePas($Periodiques, $periodesNotes, $annee, $lastService, $newScolarite);
                        $periodesNotes = NULL;
		    }	
		}
                else {
                    ecrit("redoublant");
                }
	    }
	}
		$annees->close();
	} elseif(!$restriction_extraction_a_certains_ele_id) {
		//l'élève n'existe pas dans la table élève, il faut le traiter manuellement
?>
<p class='rouge' 
   title="Vous devriez vérifier ses données, il peut s'agir d'une modification de l'INE de cet élève après un export APB.
Dans ce cas, un export devrait exister pour cet élève avec le bon INE et vous n'avez pas à tenir compte de cet avertissement."
   style="cursor:pointer"
>
	<?php echo $eleve->nom; ?> <?php echo $eleve->prenom; ?>
	ine <?php echo $eleve->ine; ?>
	né le <?php echo $eleve->ddn; ?>
	est inconnu dans la table eleves.
	Aucun export n'est généré pour cet élève.
</p>
<?php	
	}
}

//$extension=".txt";
$extension="";
$nomFichier = "LSL_".date("d-m-Y_H:i").".xml1".$extension;
//echo $dirTemp.$nomFichier;
   
$sxe->asXML($dirTemp.$nomFichier);

//===== vérifier le schéma avec import-lsl.xsd =====

$file = $dirTemp.$nomFichier;
$schema = "xsd/import-lsl.xsd";


// active la gestion d'erreur personnalisée
libxml_use_internal_errors(true);

// Instanciation d’un DOMDocument
$dom = new DOMDocument("1.0");

// Charge du XML depuis un fichier
$dom->load($file);

// Validation du document XML
/*
$validate = $dom->schemaValidate($schema) ?
"<p class='center grand vert'>Le schéma XML paraît valide !</p>" :
"<p class='center grand rouge'>Schéma XML non valide !</p>";
 * 
 */
if (!$dom->schemaValidate($schema)) { ?>
<p class='center grand rouge'>Validation du schema d'export → Votre fichier <?php echo $nomFichier; ?> n'est pas valide</p>
<?php	    //libxml_display_errors();

	$errors = libxml_get_errors();
	
    foreach ($errors as $error) {
        echo display_xml_error($error);
    }


}


unset($dom);
// Affichage du résultat
//echo $validate;




if (isset($messages)) {
?>
<p class="center grand bold rouge" 
	onclick="bascule('messages')" 
	style="cursor:pointer"
	title="Cliquez pour déplier/plier">
	<?php echo count($messages); ?> appréciation<?php if(count($messages) > 1) {echo "s";} ?> manquante<?php if(count($messages) > 1) {echo "s";} ?> 
        <br />
        <!-- votre fichier .xml n'est pas valide, toutes les appréciations doivent être renseignées. -->>
</p>
<p style="text-align: center">
	<button type="button" onclick="bascule('messages')">Afficher/Cacher les appréciations manquantes</button>
</p>

<block id="messages" style="display:none;">
<?php	
	foreach ($messages as $message) {
?>
<p class="center rouge ">
	<?php echo $message; ?>
</p>
<?php		
	} ?>
</block>
<?php
	unset ($message);
}

// On crée un lien pour télécharger le fichier
 ?>
<p>
	<a class="bold"  href='../temp/<?php echo $dirTemp ; ?><?php echo $nomFichier; ?>' target='_blank'>
		Récupérer le fichier XML
	</a>
	(<em>effectuer un clic-droit/enregistrer la cible [vous pouvez supprimer le 1 de l'extension]</em>)
</p>


