<?php

/*
*
* Copyright 2016, 2018 Régis Bouguin, Stephane Boireau
*
* This file is part of GEPI.
*
* GEPI is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 3 of the License, or
* (at your option) any later version.
*
* GEPI is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with GEPI; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// 20180823
include_once 'lib/fonctionAdmin.php';
verifieTables();

$sql="CREATE TABLE IF NOT EXISTS `plugin_lsl_eval_competences` (
	`id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id unique',
	`annee` smallint(6) NOT NULL DEFAULT 0 COMMENT 'année',
	`prof` varchar(50) NOT NULL DEFAULT '' COMMENT 'login du prof',
	`eleve` VARCHAR( 50 )  NOT NULL DEFAULT '' COMMENT 'login de l\'élève',
	`code_competences` varchar(300) NOT NULL DEFAULT '' COMMENT 'code de la compétence',
	`valeur` varchar(300) NOT NULL DEFAULT '' COMMENT 'Valeur obtenue sur la compétence',
	`id_APB` int(11) COMMENT 'code matiere dans APB',
	UNIQUE KEY `annee_idAPB_eleve_competence` ( `annee` , `id_APB` , `eleve`, `code_competences` ),
	PRIMARY KEY (`id`)
	) ENGINE=MyISAM  COMMENT 'Niveau obtenu par les élèves sur les compétences' ;";
$create_table=mysqli_query($mysqli, $sql);

$sql="CREATE TABLE IF NOT EXISTS `plugin_lsl_competences_matieres` (
	`id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id unique',
	`MEF` varchar(11) NOT NULL DEFAULT '' COMMENT 'code MEF du niveau et de la serie',
	`code_competences` varchar(10) NOT NULL DEFAULT '' COMMENT 'code des compétences',
	`modalite` ENUM('S', 'F', 'O') NOT NULL  COMMENT 'Matière obligatoire ou pas', 
	`matiere` varchar(50) NOT NULL DEFAULT '' COMMENT 'Code Matière BCN' , 
	`annee` varchar(4) NOT NULL DEFAULT '' COMMENT 'annee LSL de la compétence',
	UNIQUE KEY `mef_comp`  (`MEF`,`annee`,`matiere`,`modalite`,`code_competences`),
	PRIMARY KEY (`id`)
	) ENGINE=MyISAM  COMMENT 'liste des correspondances MEF/matière/compétences' ;";
$create_table=mysqli_query($mysqli, $sql);

$fichierXML = 'xml/lsl-nomenclatures.xml';
if (!file_exists($fichierXML)) {
    ?>
<p class="center grand rouge ">Échec lors de l'ouverture du fichier de mise à jour des nomenclatures → <?php echo $fichierXML ?></p>
    <?php
} else {
    // Mettre à jour la structure de plugin_lsl_formations
    $sql = "ALTER TABLE `plugin_lsl_formations` CHANGE `libelle` `libelle` VARCHAR(250) "
            . "CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'libelle long';";
    //echo $sql.'<br /><br />';
    $resultchargeDB = $mysqli->query($sql);
    $sql = "ALTER TABLE `plugin_lsl_programmes` "
            . "ADD `annee` VARCHAR(4) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'Session concernée' AFTER `option`;";
    //echo $sql.'<br /><br />';
    $resultchargeDB2 = $mysqli->query($sql);
    $sql = "ALTER TABLE `gepiSTMG`.`plugin_lsl_programmes` "
            . "DROP INDEX `couple`, ADD UNIQUE `couple` (`formation`, `matiere`, `Modalite`, `annee`);";
    $resultchargeDB3 = $mysqli->query($sql);
    
    $xml = simplexml_load_file($fichierXML);
    $nbAnnees= $xml->anneeScolaire->count();
    //echo $nbAnnees.' années<br/>';
    foreach ($xml->anneeScolaire as $anneeScolaire) {
        // Mise à jour de la table plugin_lsl_formations à partir des nœuds mef
        $annee = $anneeScolaire['millesime'];
        //echo $annee.'<br />';
        foreach ($anneeScolaire->mef as $mefs) {
            $codeMef = $mefs['codeMef'];
            $niveau = $mefs['niveau'];
            $codeSerie = $mefs['codeSerie'];
            $serie = $mefs['serie'];
            $specialite = $mefs['specialite'];
            
            $sql = "INSERT INTO `plugin_lsl_formations` (`id`, `MEF`, `edition`, `libelle`, `MEF_rattachement`, `annee`) "
            . "VALUES (NULL, \"$codeMef\", \"$niveau-$codeSerie\", \"$niveau $serie\", \"$codeMef\", \"$annee\")"
            . "ON DUPLICATE KEY UPDATE `edition`= \"$niveau-$codeSerie\", `libelle`= \"$niveau $serie\", `MEF_rattachement`=\"$codeMef\" ";
            //echo $sql.'<br />';
            $resultchargeDB = $mysqli->query($sql);
            
            //  Mise à jour de la table plugin_lsl_programmes à partir des nœuds matiere
            foreach ($mefs->matiere as $matieres) {
                $matiere = $matieres['discipline'];
                $codeBcn = $matieres['codeBcn'];
                $modalite = $matieres['modaliteElection'];
                $note = $matieres['presenceEvaluationPeriodique']=="true" ? "y" : "n";
                $appreciation = "y";
                $sql = "INSERT INTO `plugin_lsl_programmes` (`id`, `formation`, `matiere`, `Modalite`, `note`, `appreciation`, `option`, `annee`) "
                . "VALUES (NULL, \"$codeMef\", \"$codeBcn\", \"$modalite\", \"$note\", \"$appreciation\", \"$matiere\", \"$annee\") "
                . "ON DUPLICATE KEY UPDATE `note`= \"$note\", `appreciation`= \"$appreciation\", `option`= \"$matiere\" ";
                //echo $sql.'<br />';
                $resultchargeDB = $mysqli->query($sql);

			foreach ($matieres->competences as $competences) {
				foreach ($competences->competence as $competence => $value) {
					$sql = "INSERT INTO plugin_lsl_competences_matieres SET MEF='".$codeMef."',
														code_competences='".$value."', 
														modalite='".$modalite."', 
														matiere='".$codeBcn."', 
														annee='".$annee."' 
													ON DUPLICATE KEY UPDATE MEF='".$codeMef."',
														code_competences='".$value."', 
														modalite='".$modalite."', 
														matiere='".$codeBcn."', 
														annee='".$annee."';";
					//echo $sql.'<br />';
					$resultchargeDB = $mysqli->query($sql);
				}
			}

            }
            //echo '<br />';
            
        }
        
        
    }


	$sql="SHOW INDEX FROM plugin_lsl_competences WHERE Key_name='code_competences';";
	$test=mysqli_query($GLOBALS["mysqli"], $sql);
	if(mysqli_num_rows($test)>0) {
		$sql="ALTER TABLE plugin_lsl_competences DROP INDEX code_competences;";
		//echo "$sql<br />";
		$del=mysqli_query($mysqli, $sql);
	}

	$sql="SHOW INDEX FROM plugin_lsl_competences WHERE Key_name='code_competences_annee';";
	$test=mysqli_query($GLOBALS["mysqli"], $sql);
	if(mysqli_num_rows($test)==0) {
		$sql="ALTER TABLE plugin_lsl_competences ADD INDEX code_competences_annee(code_competences, annee);";
		//echo "$sql<br />";
		$res=mysqli_query($mysqli, $sql);
	}

	//$cpt=0;
	//$nbCompetences= $xml->competences->count();
	//echo $nbCompetences.' compétences<br/>'; // On récupère une occurrence de 'competence*s*'
	$nbCompetence= $xml->competences->competence->count();
	//echo $nbCompetence.' compétences<br/>'; //
	foreach ($xml->competences as $competences) {
		foreach ($competences->competence as $competence) {
			/*
			echo "<pre>";
			print_r($competence);
			echo "</pre>";
			echo "\$competence[0]=".$competence[0]."<br />";
			*/

			$code_competences = $competence['code'];
			$annee_competences = $competence['annee'];
			$texte_competences = $competence[0];

			$sql="SELECT * FROM plugin_lsl_competences WHERE code_competences=\"$code_competences\" AND annee=\"$annee_competences\";";
			//echo $sql.'<br />';
			$test=mysqli_query($mysqli, $sql);
			if(mysqli_num_rows($test)==0) {
				$sql = "INSERT INTO `plugin_lsl_competences` (`id`, `code_competences`, `texte_competences`, `annee`) "
				. "VALUES (NULL, \"$code_competences\", \"$texte_competences\", \"$annee_competences\");";
			}
			else {
				$sql = "UPDATE plugin_lsl_competences SET texte_competences`= \"$texte_competences\" WHERE code_competences= \"$code_competences\" AND annee=\"$annee_competences\";";
			}
			//echo $sql.'<br />';
			$resultchargeDB = $mysqli->query($sql);

			/*
			$sql = "INSERT INTO `plugin_lsl_competences` (`id`, `code_competences`, `texte_competences`, `annee`) "
			. "VALUES (NULL, \"$code_competences\", \"$texte_competences\", \"$annee_competences\") "
			. "ON DUPLICATE KEY UPDATE `code_competences`= \"$code_competences\", `texte_competences`= \"$texte_competences\", annee=\"$annee_competences\";";
			//echo $sql.'<br />';
			$resultchargeDB = $mysqli->query($sql);
			*/
			//$cpt++;
		}
	}

    //print_r($xml->anneeScolaire[1]);
}

