DROP TABLE IF EXISTS grr_calendrier_feries;
CREATE TABLE grr_calendrier_feries (  `DAY` int(11) NOT NULL DEFAULT '0');
DROP TABLE IF EXISTS grr_calendrier_vacances;
CREATE TABLE grr_calendrier_vacances (  `DAY` int(11) NOT NULL DEFAULT '0');
DROP TABLE IF EXISTS grr_j_group_area;
CREATE TABLE grr_j_group_area (idgroupes int NOT NULL, id_area int NOT NULL DEFAULT '0', PRIMARY KEY (idgroupes,id_area));
CREATE TABLE grr_j_group_site (idgroupes int NOT NULL, id_site int NOT NULL DEFAULT '0', PRIMARY KEY (idgroupes,id_site));
DROP TABLE IF EXISTS grr_j_mailuser_room;
CREATE TABLE grr_j_mailuser_room (login varchar(190) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', id_room int(11) NOT NULL default '0', mail_resa tinyint(1) NOT NULL DEFAULT '1', mail_hebdo tinyint(1) NOT NULL DEFAULT '0', PRIMARY KEY  (login,id_room) );
DROP TABLE IF EXISTS grr_j_user_area;
CREATE TABLE grr_j_user_area (login varchar(190) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', id_area int(11) NOT NULL default '0', idgroupes int(11) NOT NULL default '0', PRIMARY KEY  (login,id_area) );
DROP TABLE IF EXISTS grr_j_user_room;
CREATE TABLE grr_j_user_room (login varchar(190) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', id_room int(11) NOT NULL default '0', PRIMARY KEY  (login,id_room) );
DROP TABLE IF EXISTS grr_j_user_site;
CREATE TABLE grr_j_user_site (login varchar(190) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', id_site int(11) NOT NULL default '0', idgroupes int(11) NOT NULL default '0', PRIMARY KEY  (login,id_site) );
DROP TABLE IF EXISTS grr_j_userbook_room;
CREATE TABLE grr_j_userbook_room (login varchar(190) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', id_room int(11) NOT NULL default '0', PRIMARY KEY  (login,id_room) );
DROP TABLE IF EXISTS grr_j_useradmin_area;
CREATE TABLE grr_j_useradmin_area (login varchar(190) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', id_area int(11) NOT NULL default '0', PRIMARY KEY  (login,id_area) );
DROP TABLE IF EXISTS grr_log;
CREATE TABLE grr_log (LOGIN varchar(190) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', `START` datetime NOT NULL default '1970-01-01 00:00:00', SESSION_ID varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', REMOTE_ADDR varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', USER_AGENT varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', REFERER varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', AUTOCLOSE enum('0','1') NOT NULL default '0', `END` datetime NOT NULL default '1970-01-01 00:00:00', PRIMARY KEY  (SESSION_ID,`START`));
DROP TABLE IF EXISTS grr_log_mail;
CREATE TABLE grr_log_mail (idlogmail int(11) NOT NULL AUTO_INCREMENT, date int(11) NOT NULL, de varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL, a varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL, sujet varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL, message text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL, PRIMARY KEY (`idlogmail`));
DROP TABLE IF EXISTS grr_log_resa;
CREATE TABLE grr_log_resa (idlogresa bigint(20) NOT NULL AUTO_INCREMENT, date int(11) NOT NULL, idresa int(11) NOT NULL, identifiant varchar(100) NOT NULL, action tinyint(3) UNSIGNED NOT NULL, infoscomp text NOT NULL, PRIMARY KEY (`idlogresa`));
DROP TABLE IF EXISTS grr_area;
CREATE TABLE grr_area (id int(11) NOT NULL auto_increment, area_name varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', access char(1) NOT NULL default '', order_display smallint(6) NOT NULL default '0', ip_adr varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '',   morningstarts_area smallint(6) NOT NULL default '0', eveningends_area smallint(6) NOT NULL default '0', duree_max_resa_area INT NOT NULL default '-1', resolution_area INT NOT NULL default '0', eveningends_minutes_area smallint(6) NOT NULL default '0', weekstarts_area smallint(6) NOT NULL default '0', twentyfourhour_format_area smallint(6) NOT NULL default '0', calendar_default_values char(1) NOT NULL default 'y', enable_periods char(1) NOT NULL default 'n', display_days varchar(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default 'yyyyyyy', id_type_par_defaut int(11) NOT NULL default '-1', duree_par_defaut_reservation_area INT NOT NULL DEFAULT '0', max_booking smallint(6) NOT NULL default '-1', PRIMARY KEY  (id));
DROP TABLE IF EXISTS grr_entry;
CREATE TABLE grr_entry (id int(11) NOT NULL auto_increment, start_time int(11) NOT NULL default '0', end_time int(11) NOT NULL default '0', entry_type int(11) NOT NULL default '0', repeat_id int(11) NOT NULL default '0', room_id int(11) NOT NULL default '1',timestamp timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, create_by varchar(190) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', beneficiaire_ext varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', beneficiaire varchar(190) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', name varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', type char(2) NOT NULL default 'A', description text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci, statut_entry char(1) NOT NULL default '-', option_reservation int(11) NOT NULL default '0',overload_desc text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci, moderate tinyint(1) default '0', jours int(2) NOT NULL default '0', clef int(2) NOT NULL default '0', courrier int(2) NOT NULL default '0', nbparticipantmax int(11) NOT NULL default '0', supprimer tinyint(1) NOT NULL default '0', PRIMARY KEY (id), KEY idxStartTime (start_time), KEY idxEndTime (end_time), KEY room_id (room_id) );
DROP TABLE IF EXISTS grr_repeat;
CREATE TABLE grr_repeat ( id int(11) NOT NULL auto_increment, start_time int(11) NOT NULL default '0', end_time int(11) NOT NULL default '0', rep_type int(11) NOT NULL default '0', end_date int(11) NOT NULL default '0', rep_opt varchar(32) NOT NULL default '', room_id int(11) NOT NULL default '1', timestamp timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, create_by varchar(190) NOT NULL default '', beneficiaire_ext varchar(200) NOT NULL default '', beneficiaire varchar(190) NOT NULL default '', name varchar(80) NOT NULL default '', type char(2) NOT NULL default 'A', description text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci, rep_num_weeks tinyint(4) default '0',overload_desc text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci, jours tinyint(2) NOT NULL default '0', courrier int(2) NOT NULL default '0', nbparticipantmax int(11) NOT NULL default '0', PRIMARY KEY  (id));
DROP TABLE IF EXISTS grr_room;
CREATE TABLE grr_room ( id int(11) NOT NULL auto_increment,  area_id int(11) NOT NULL default '0',  room_name varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '',  description varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '',  capacity int(11) NOT NULL default '0',  max_booking smallint(6) NOT NULL default '-1', statut_room char(1) NOT NULL default '1', show_fic_room char(1) NOT NULL default 'n', picture_room varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', comment_room text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL, show_comment CHAR(1) NOT NULL DEFAULT 'n', delais_max_resa_room smallint(6) NOT NULL default '-1', delais_min_resa_room mediumint NOT NULL default '0', allow_action_in_past char(1) NOT NULL default 'n', dont_allow_modify char(1) NOT NULL default 'n', order_display smallint(6) NOT NULL default '0', delais_option_reservation smallint(6) NOT NULL default '0', type_affichage_reser smallint(6) DEFAULT '0' NOT NULL, moderate tinyint(1) default '0', qui_peut_reserver_pour char(1) NOT NULL default '5', active_ressource_empruntee char(1) NOT NULL default 'y', active_cle char(1) NOT NULL default 'y', active_participant tinyint(1) NOT NULL DEFAULT '0', inscription_participant tinyint(1) NOT NULL DEFAULT '1', nb_participant_defaut smallint NOT NULL DEFAULT '0', who_can_see SMALLINT DEFAULT '0' NOT NULL, booking_range SMALLINT(6) NOT NULL DEFAULT '-1', who_can_book tinyint(1) NOT NULL DEFAULT '1', PRIMARY KEY  (id));
DROP TABLE IF EXISTS grr_utilisateurs;
CREATE TABLE grr_utilisateurs (login varchar(190) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', nom varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', prenom varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', password varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', changepwd tinyint(1) NOT NULL DEFAULT '0', email varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', statut varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', etat varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', default_site smallint(6) NOT NULL default '0', default_area smallint(6) NOT NULL default '0', default_room smallint(6) NOT NULL default '0', default_style varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', default_list_type varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', default_language char(8) NOT NULL default '', source varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default 'local', commentaire mediumtext NOT NULL, desactive_mail tinyint NOT NULL DEFAULT '0', nb_tentative tinyint NOT NULL DEFAULT '0', date_blocage int NOT NULL DEFAULT '0', popup tinyint NOT NULL DEFAULT '0', PRIMARY KEY  (login) );
DROP TABLE IF EXISTS grr_setting;
CREATE TABLE grr_setting (  NAME varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '',  VALUE text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,  PRIMARY KEY  (NAME));
DROP TABLE IF EXISTS grr_area_periodes;
CREATE TABLE grr_area_periodes (id_area int(11) NOT NULL default '0', num_periode smallint(6) NOT NULL default '0', nom_periode varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', PRIMARY KEY  (`id_area`,`num_periode`));
DROP TABLE IF EXISTS grr_type_area;
CREATE TABLE grr_type_area (id int(11) NOT NULL auto_increment, type_name varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '',order_display smallint(6) NOT NULL default '0',couleur smallint(6) NOT NULL default '0',couleurhexa varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL, couleurtexte varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '#000000', couleuricone varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '#000000', type_letter char(2) NOT NULL default '',disponible VARCHAR(1) NOT NULL DEFAULT '2', PRIMARY KEY  (id));
DROP TABLE IF EXISTS grr_j_type_area;
CREATE TABLE grr_j_type_area (id_type int(11) NOT NULL default '0', id_area int(11) NOT NULL default '0');
DROP TABLE IF EXISTS grr_calendar;
CREATE TABLE grr_calendar (DAY int(11) NOT NULL default '0');
DROP TABLE IF EXISTS grr_calendrier_jours_cycle;
CREATE TABLE grr_calendrier_jours_cycle (DAY int(11) NOT NULL default '0', Jours varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '');
DROP TABLE IF EXISTS grr_overload;
CREATE TABLE grr_overload (id int(11) NOT NULL auto_increment, id_area INT NOT NULL, fieldname VARCHAR(55) NOT NULL default '', fieldtype VARCHAR(25) NOT NULL default '', fieldlist text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL, obligatoire CHAR( 1 ) DEFAULT 'n' NOT NULL, affichage CHAR( 1 ) DEFAULT 'n' NOT NULL, confidentiel CHAR( 1 ) DEFAULT 'n' NOT NULL, overload_mail CHAR( 1 ) DEFAULT 'n' NOT NULL, mail_spec text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL, PRIMARY KEY (id_area,fieldname), UNIQUE KEY (id));
DROP TABLE IF EXISTS grr_entry_moderate;
CREATE TABLE grr_entry_moderate (id int(11) NOT NULL auto_increment, login_moderateur varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '',motivation_moderation text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,start_time int(11) NOT NULL default '0',end_time int(11) NOT NULL default '0',entry_type int(11) NOT NULL default '0', repeat_id int(11) NOT NULL default '0',room_id int(11) NOT NULL default '1',timestamp timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, create_by varchar(190) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', beneficiaire_ext varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', beneficiaire varchar(190) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', name varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '',type char(2) default NULL,description text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,statut_entry char(1) NOT NULL default '-',option_reservation int(11) NOT NULL default '0',overload_desc text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci, moderate tinyint(1) default '0', PRIMARY KEY  (id), KEY idxStartTime (start_time), KEY idxEndTime (end_time));
DROP TABLE IF EXISTS grr_site;
CREATE TABLE grr_site ( id int(11) NOT NULL AUTO_INCREMENT, sitecode varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL, sitename varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', access CHAR(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'a', adresse_ligne1 varchar(38) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL, adresse_ligne2 varchar(38) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL, adresse_ligne3 varchar(38) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL, cp varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL, ville varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL, pays varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL, tel varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL, fax varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL, PRIMARY KEY (id), UNIQUE KEY name (sitename), UNIQUE KEY code (sitecode));
DROP TABLE IF EXISTS grr_j_site_area;
CREATE TABLE grr_j_site_area ( id_site int(11) NOT NULL default '0', id_area int(11) NOT NULL default '0', PRIMARY KEY  (`id_site`,`id_area`));
DROP TABLE IF EXISTS grr_j_useradmin_site;
CREATE TABLE grr_j_useradmin_site (login varchar(190) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', id_site int(11) NOT NULL default '0', PRIMARY KEY  (login,id_site) );
DROP TABLE IF EXISTS grr_correspondance_statut;
CREATE TABLE grr_correspondance_statut (id int(11) NOT NULL auto_increment, code_fonction varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL, libelle_fonction varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL, statut_grr varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,  PRIMARY KEY (id));
DROP TABLE IF EXISTS grr_page;
CREATE TABLE grr_page ( nom varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL, titre varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '', valeur longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL, systeme tinyint(1) NOT NULL DEFAULT '0', statutmini varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL, lien varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL, nouveauonglet tinyint(1) NOT NULL DEFAULT '1', ordre smallint(6) NOT NULL DEFAULT '0', emplacement smallint(6) NOT NULL DEFAULT '1', PRIMARY KEY  (`nom`));
DROP TABLE IF EXISTS grr_modulesext;
CREATE TABLE grr_modulesext ( nom varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL, actif tinyint(1) NOT NULL DEFAULT '0', version INT(11) NOT NULL, PRIMARY KEY  (`nom`));
DROP TABLE IF EXISTS grr_participants;
CREATE TABLE grr_participants (id_participation int(11) NOT NULL auto_increment, idresa int(11) NOT NULL, timestamp timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, cree_par varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', beneficiaire varchar(190) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', beneficiaire_ext varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL default '', moderation tinyint(1) NOT NULL default '0', PRIMARY KEY (`id_participation`));
DROP TABLE IF EXISTS grr_groupes;
CREATE TABLE grr_groupes (`idgroupes` int(11) NOT NULL AUTO_INCREMENT, `nom` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci  NOT NULL, description text NOT NULL, `archive` tinyint(1) NOT NULL DEFAULT '0', PRIMARY KEY (`idgroupes`));
DROP TABLE IF EXISTS grr_utilisateurs_demandes;
CREATE TABLE grr_utilisateurs_demandes (`idutilisateursdemandes` bigint(20) NOT NULL AUTO_INCREMENT, `nom` varchar(30) NOT NULL, `prenom` varchar(30) NOT NULL, `email` varchar(100) NOT NULL, `telephone` varchar(20) NOT NULL, `mdp` varchar(184) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, `commentaire` text NOT NULL, `datedemande` date NOT NULL, `etat` tinyint(1) NOT NULL DEFAULT 0, `gestionnaire` varchar(40) NOT NULL DEFAULT '', `datechoix` date DEFAULT NULL, PRIMARY KEY (`idutilisateursdemandes`))  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
DROP TABLE IF EXISTS grr_utilisateurs_groupes;
CREATE TABLE grr_utilisateurs_groupes (`idutilisateursgroupes` bigint(20) NOT NULL AUTO_INCREMENT, `login` varchar(190) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci  NOT NULL, `idgroupes` int(11) NOT NULL, PRIMARY KEY (`idutilisateursgroupes`), UNIQUE KEY `idutilisateurs` (`login`,`idgroupes`));
INSERT INTO grr_type_area VALUES (1, 'Cours', 1, 1, '#1abc9c', '#000000', '#000000', 'A', 2);
INSERT INTO grr_type_area VALUES (2, 'Réunion', 2, 2, '#C03000', '#000000', '#000000', 'B', 2);
INSERT INTO grr_type_area VALUES (3, 'Autre', 3, 3, '#4BB5C1', '#000000', '#000000', 'C', 2);
INSERT INTO grr_utilisateurs VALUES ('ADMINISTRATEUR', 'Administrateur', 'grr', 'VariableInstal05', 0, 'VariableInstal06', 'administrateur', 'actif', 0, 0, 0, 'default', 'item', 'fr-fr','local', '', 0,0,0,0);
INSERT INTO grr_area (`id`, `area_name`, `access`, `order_display`, `ip_adr`, `morningstarts_area`, `eveningends_area`, `duree_max_resa_area`, `resolution_area`, `eveningends_minutes_area`, `weekstarts_area`, `twentyfourhour_format_area`, `calendar_default_values`, `enable_periods`, `display_days`, `id_type_par_defaut`, `duree_par_defaut_reservation_area`, `max_booking`) VALUES (1, 'Domaine 1', 'a', 0, '', 8, 19, -1, 1800, 0, 1, 1, 'n', 'n', 'yyyyyyy', -1, 1800, -1);
INSERT INTO grr_room (`id`, `area_id`, `room_name`, `description`, `capacity`, `max_booking`, `statut_room`, `show_fic_room`, `picture_room`, `comment_room`, `show_comment`, `delais_max_resa_room`, `delais_min_resa_room`, `allow_action_in_past`, `dont_allow_modify`, `order_display`, `delais_option_reservation`, `type_affichage_reser`, `moderate`, `qui_peut_reserver_pour`, `active_ressource_empruntee`, `active_cle`, `who_can_see`) VALUES (NULL, '1', 'Ressource 1', '', '0', '-1', '1', 'n', '', '', 'n', '-1', '0', 'n', 'n', '0', '0', '0', '0', '5', 'y', 'y', '0');
INSERT INTO grr_setting VALUES ('acces_fiche_reservation', '0');
INSERT INTO grr_setting VALUES ('ActiveModeDiagnostic', 'n');
INSERT INTO grr_setting VALUES ('allow_gestionnaire_modify_del', '1');
INSERT INTO grr_setting VALUES ('allow_search_level', '1');
INSERT INTO grr_setting VALUES ('allow_user_delete_after_begin', '0');
INSERT INTO grr_setting VALUES ('allow_users_modify_email', '2');
INSERT INTO grr_setting VALUES ('allow_users_modify_mdp', '2');
INSERT INTO grr_setting VALUES ('allow_users_modify_profil', '2');
INSERT INTO grr_setting VALUES ('allow_users_modify_affichage', '2');
INSERT INTO grr_setting VALUES ('allow_users_modify_domaine', '2');
INSERT INTO grr_setting VALUES ('allow_users_modify_theme', '2');
INSERT INTO grr_setting VALUES ('allow_users_modify_langue', '2');
INSERT INTO grr_setting VALUES ('area_list_format', 'item');
INSERT INTO grr_setting VALUES ('authentification_obli', '1');
INSERT INTO grr_setting VALUES ('automatic_mail', 'yes');
INSERT INTO grr_setting VALUES ('backup_date', '');
INSERT INTO grr_setting VALUES ('begin_bookings', '1735686000');
INSERT INTO grr_setting VALUES ('calcul_plus_mois', 'y');
INSERT INTO grr_setting VALUES ('calcul_plus_mois2_all', 'y');
INSERT INTO grr_setting VALUES ('calcul_plus_semaine_all', 'y');
INSERT INTO grr_setting VALUES ('cas_port', '');
INSERT INTO grr_setting VALUES ('cas_racine', '');
INSERT INTO grr_setting VALUES ('cas_serveur', '');
INSERT INTO grr_setting VALUES ('company', 'VariableInstal01');
INSERT INTO grr_setting VALUES ('ConvertLdapUtf8toIso', 'n');
INSERT INTO grr_setting VALUES ('default_css', 'default');
INSERT INTO grr_setting VALUES ('default_language', 'fr-fr');
INSERT INTO grr_setting VALUES ('default_report_days', '30');
INSERT INTO grr_setting VALUES ('default_room', '-1');
INSERT INTO grr_setting VALUES ('default_site', '-1');
INSERT INTO grr_setting VALUES ('disable_login', 'no');
INSERT INTO grr_setting VALUES ('display_beneficiaire_nc', '1');
INSERT INTO grr_setting VALUES ('display_beneficiaire_vi', '1');
INSERT INTO grr_setting VALUES ('display_beneficiaire_us', '1');
INSERT INTO grr_setting VALUES ('display_beneficiaire_gr', '1');
INSERT INTO grr_setting VALUES ('display_beneficiaire_ad', '1');
INSERT INTO grr_setting VALUES ('display_full_description_nc', '1');
INSERT INTO grr_setting VALUES ('display_full_description_vi', '1');
INSERT INTO grr_setting VALUES ('display_full_description_us', '1');
INSERT INTO grr_setting VALUES ('display_full_description_gr', '1');
INSERT INTO grr_setting VALUES ('display_full_description_ad', '1');
INSERT INTO grr_setting VALUES ('display_horaires_nc', '1');
INSERT INTO grr_setting VALUES ('display_horaires_vi', '1');
INSERT INTO grr_setting VALUES ('display_horaires_us', '1');
INSERT INTO grr_setting VALUES ('display_horaires_gr', '1');
INSERT INTO grr_setting VALUES ('display_horaires_ad', '1');
INSERT INTO grr_setting VALUES ('display_level_email', '0');
INSERT INTO grr_setting VALUES ('display_level_view_entry', '0');
INSERT INTO grr_setting VALUES ('display_short_description_nc', '1');
INSERT INTO grr_setting VALUES ('display_short_description_vi', '1');
INSERT INTO grr_setting VALUES ('display_short_description_us', '1');
INSERT INTO grr_setting VALUES ('display_short_description_gr', '1');
INSERT INTO grr_setting VALUES ('display_short_description_ad', '1');
INSERT INTO grr_setting VALUES ('display_type_nc', '1');
INSERT INTO grr_setting VALUES ('display_type_vi', '1');
INSERT INTO grr_setting VALUES ('display_type_us', '1');
INSERT INTO grr_setting VALUES ('display_type_gr', '1');
INSERT INTO grr_setting VALUES ('display_type_ad', '1');
INSERT INTO grr_setting VALUES ('end_bookings', '1798757999');
INSERT INTO grr_setting VALUES ('envoyer_email_avec_formulaire', 'no');
INSERT INTO grr_setting VALUES ('file', '1');
INSERT INTO grr_setting VALUES ('firstversion', 'VariableInstal07');
INSERT INTO grr_setting VALUES ('gestion_lien_aide', 'ext');
INSERT INTO grr_setting VALUES ('grr_mail_Bcc', 'n');
INSERT INTO grr_setting VALUES ('grr_mail_method', 'bloque');
INSERT INTO grr_setting VALUES ('grr_mail_Password', '');
INSERT INTO grr_setting VALUES ('grr_mail_smtp', '');
INSERT INTO grr_setting VALUES ('grr_mail_Username', '');
INSERT INTO grr_setting VALUES ('grr_url', 'VariableInstal02');
INSERT INTO grr_setting VALUES ('imprimante', '1');
INSERT INTO grr_setting VALUES ('ip_autorise', '');
INSERT INTO grr_setting VALUES ('javascript_info_admin_disabled', '0');
INSERT INTO grr_setting VALUES ('javascript_info_disabled', '0');
INSERT INTO grr_setting VALUES ('jour_debut_Jours_Cycles', '1');
INSERT INTO grr_setting VALUES ('jours_cycles_actif', 'Non');;
INSERT INTO grr_setting VALUES ('ldap_champ_email', 'mail');
INSERT INTO grr_setting VALUES ('ldap_champ_nom', 'sn');
INSERT INTO grr_setting VALUES ('ldap_champ_prenom', 'givenname');
INSERT INTO grr_setting VALUES ('ldap_champ_recherche', 'uid');
INSERT INTO grr_setting VALUES ('legend', '1');
INSERT INTO grr_setting VALUES ('lien_aide', '');
INSERT INTO grr_setting VALUES ('log_mail', '0');
INSERT INTO grr_setting VALUES ('login_template', '1');
INSERT INTO grr_setting VALUES ('login_logo', '1');
INSERT INTO grr_setting VALUES ('login_nom', '1');
INSERT INTO grr_setting VALUES ('longueur_liste_ressources_max', '20');
INSERT INTO grr_setting VALUES ('mail_destinataire', 'test@test.fr');
INSERT INTO grr_setting VALUES ('mail_etat_destinataire', '0');
INSERT INTO grr_setting VALUES ('maj194_champs_additionnels', '1');
INSERT INTO grr_setting VALUES ('maj195_champ_rep_type_grr_repeat', '1');
INSERT INTO grr_setting VALUES ('maj196_qui_peut_reserver_pour', '1');
INSERT INTO grr_setting VALUES ('menu_gauche', '1');
INSERT INTO grr_setting VALUES ('message_home_page', 'En raison du caractère personnel du contenu, ce site est soumis à des restrictions utilisateurs. Pour accéder aux outils de réservation, identifiez-vous :');
INSERT INTO grr_setting VALUES ('nb_calendar', '1');
INSERT INTO grr_setting VALUES ('nextalertemailhebdo', '1735686000');
INSERT INTO grr_setting VALUES ('nombre_jours_Jours_Cycles', '1');
INSERT INTO grr_setting VALUES ('pass_leng', '8');
INSERT INTO grr_setting VALUES ('pass_nb_ch', '1');
INSERT INTO grr_setting VALUES ('pass_nb_maj', '1');
INSERT INTO grr_setting VALUES ('pass_nb_min', '1');
INSERT INTO grr_setting VALUES ('pass_nb_sp', '1');
INSERT INTO grr_setting VALUES ('periodicite', 'y');
INSERT INTO grr_setting VALUES ('pview_new_windows', '1');
INSERT INTO grr_setting VALUES ('redirection_https', 'no');
INSERT INTO grr_setting VALUES ('remplissage_description_breve', '1');
INSERT INTO grr_setting VALUES ('remplissage_description_complete', '0');
INSERT INTO grr_setting VALUES ('sessionMaxLength', '60');
INSERT INTO grr_setting VALUES ('show_courrier', 'n');
INSERT INTO grr_setting VALUES ('show_holidays', 'Non');
INSERT INTO grr_setting VALUES ('smtp_allow_self_signed', 'false');
INSERT INTO grr_setting VALUES ('smtp_secure', '');
INSERT INTO grr_setting VALUES ('smtp_port', '25');
INSERT INTO grr_setting VALUES ('smtp_verify_depth', '3');
INSERT INTO grr_setting VALUES ('smtp_verify_peer_name', 'true');
INSERT INTO grr_setting VALUES ('smtp_verify_peer', 'true');
INSERT INTO grr_setting VALUES ('technical_support_email', 'VariableInstal04');
INSERT INTO grr_setting VALUES ('title_home_page', 'Gestion et Réservation de Ressources');
INSERT INTO grr_setting VALUES ('url_disconnect', '');
INSERT INTO grr_setting VALUES ('use_fckeditor', '1');
INSERT INTO grr_setting VALUES ('UserAllRoomsMaxBooking', '-1');
INSERT INTO grr_setting VALUES ('verif_reservation_auto', '0');
INSERT INTO grr_setting VALUES ('version', '0400007');
INSERT INTO grr_setting VALUES ('visu_fiche_description', '0');
INSERT INTO grr_setting VALUES ('webmaster_name', 'Webmestre de GRR');
INSERT INTO grr_setting VALUES ('webmaster_email', 'VariableInstal03');
INSERT INTO grr_setting VALUES ('mail_user_destinataire', 'y');
INSERT INTO grr_setting VALUES ('horaireconnexionde', '');
INSERT INTO grr_setting VALUES ('horaireconnexiona', '');
INSERT INTO grr_setting VALUES ('cas_version', 'CAS_VERSION_2_0');
INSERT INTO grr_setting VALUES ('select_date_directe', 'y');
INSERT INTO grr_page VALUES ('cgu', 'CGU', 'Les CGU', 0,'','',0,0,0);
INSERT INTO grr_page VALUES ('contactresa', 'contactresa', '', 0,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resacreation2_de-de', 'GRR: Meldung %ressource% - %resadatedebut% - Neue Reservierung %enattentemoderation%', '<p>%nometablissement% - Automatische Nachricht von der GRR Webseite : %urlgrr%</p><p>Benutzer %logincompletuser% für Sie reserviert hat %ressource% (%domaine%)</p><br><p>Beginn der Reservierung : %resadatedebut%<br></p><p>Dauer : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Art : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%<p></p><p></p><p><br></p><p>------</p><p>%raisonmail%<br></p>Wenn\r\n sie diese automatische Nachricht nicht mehr erhalten wollen, wenden Sie\r\n sich bitte an Ihren GRR-Systemverwalter : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resacreation2_en-gb', 'GRR : notice %ressource% - %resadatedebut% - New reservation %enattentemoderation%', '<p>%nometablissement% - Automatic message emitted by GRR site : %urlgrr%</p><p>The user %logincompletuser% has reserved for you %ressource% (%domaine%)</p><br><p>Reservation will start : %resadatedebut%<br></p><p>Duration : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Type : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%<p></p><p></p><p><br></p><p>------</p><p>%raisonmail%<br></p>If you no longer wish to get these automatic mails, write to GRR manager : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resacreation2_es-es', 'GRR : opinión %ressource% - %resadatedebut% - Nueva reserva %enattentemoderation%', '<p>%nometablissement% - Mensaje automático emitido por el GRR : %urlgrr%</p><p>El usuario %logincompletuser% ha reservado para ti %ressource% (%domaine%)</p><br><p>Principio de la reserva : %resadatedebut%<br></p><p>Duración : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Tipo : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%<p></p><p></p><p><br></p><p>------</p><p>%raisonmail%<br></p>Si usted no desea recibir estos mensajes automáticos, escriba al gestor de GRR : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resacreation2_fr-fr', 'GRR : avis %ressource% - %resadatedebut% - Nouvelle réservation %enattentemoderation%', '<p><p>%nometablissement% - Message automatique émis par le site GRR : %urlgrr%</p>L\'utilisateur %logincompletuser%&nbsp; a réservé pour vous %ressource% (%domaine%) </p><p><p><br></p><p>Début de la réservation : %resadatedebut%<br></p><p>Durée : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Type : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%</p><p><p><br></p><p>------<br></p>Si vous ne souhaitez plus recevoir ces messages automatiques, écrivez en ce sens au gestionnaire de GRR : %webmasteremail%<p></p><p></p><p></p><p></p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resacreation2_it-it', 'GRR : opinione %ressource% - %resadatedebut% - Nuova prenotazione %enattentemoderation%', '<p>%nometablissement% - Messaggio automatico emesso dal sito GRR : %urlgrr%</p><p>L\'utente %logincompletuser% ti ha riservato %ressource% (%domaine%)</p><br><p>Inizio della prenotazione : %resadatedebut%<br></p><p>Durata : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Tipo : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%<p></p><p></p><p><br></p><p>------</p><p>%raisonmail%<br></p>Se non desiderate ricevere più questi messaggi automatici, scrivete in questo senso all\'amministratore di GRR : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resacreation_de-de', 'GRR: Meldung %ressource% - %resadatedebut% - Neue Reservierung %enattentemoderation%', '<p><p>%nometablissement% - Automatische Nachricht von der GRR Webseite : %urlgrr%</p><p>Benutzer %logincompletuser% hat reserviert %ressource% (%domaine%)</p><p><br></p><p>Reservierung im Namen von&nbsp; %logincompletbeneficiaire%</p><p>Beginn der Reservierung : %resadatedebut%<br></p><p>Dauer : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Art : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%</p><p><p><br></p><p>------</p><p>%raisonmail%<br></p>Wenn sie diese automatische Nachricht nicht mehr erhalten wollen, wenden Sie sich bitte an Ihren GRR-Systemverwalter : %webmasteremail%<p></p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resacreation_en-gb', 'GRR : notice %ressource% - %resadatedebut% - New reservation %enattentemoderation%', '<p><p>%nometablissement% - Automatic message emitted by GRR site : %urlgrr%</p><p>The user %logincompletuser% has reserved %ressource% (%domaine%)</p><p><br></p><p>Reservation in the name of %logincompletbeneficiaire%</p><p>Reservation will start : %resadatedebut%<br></p><p>Duration : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Type : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%</p><p><p><br></p><p>------</p><p>%raisonmail%<br></p>If you no longer wish to get these automatic mails, write to GRR manager : %webmasteremail%<p></p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resacreation_es-es', 'GRR : opinión %ressource% - %resadatedebut% - Nueva reserva %enattentemoderation%', '<p><p>%nometablissement% - Mensaje automático emitido por el GRR : %urlgrr%</p><p>El usuario %logincompletuser% ha reservado %ressource% (%domaine%)</p><p><br></p><p>Reserva por cuenta del usuario : %logincompletbeneficiaire%</p><p>Principio de la reserva : %resadatedebut%<br></p><p>Duración : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Tipo : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%</p><p><p><br></p><p>------</p><p>%raisonmail%<br></p>Si usted no desea recibir estos mensajes automáticos, escriba al gestor de GRR : %webmasteremail%<p></p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resacreation_fr-fr', 'GRR : avis %ressource% - %resadatedebut% - Nouvelle réservation %enattentemoderation%', '<p><p>%nometablissement% - Message automatique émis par le site GRR : %urlgrr%</p><p>L\'utilisateur %logincompletuser% a réservé %ressource% (%domaine%)</p><p><br></p><p>Réservation au nom de l\'utilisateur %logincompletbeneficiaire%</p><p>Début de la réservation : %resadatedebut%<br></p><p>Durée : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Type : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%</p><p><p><br></p><p>------</p><p>%raisonmail%<br></p>Si vous ne souhaitez plus recevoir ces messages automatiques, écrivez en ce sens au gestionnaire de GRR : %webmasteremail%<p></p><p></p><p></p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resacreation_it-it', 'GRR : opinione %ressource% - %resadatedebut% - Nuova prenotazione %enattentemoderation%', '<p>%nometablissement% - Messaggio automatico emesso dal sito GRR : %urlgrr%</p><p>L\'utente %logincompletuser% ha riservato %ressource% (%domaine%)</p><p><br></p><p>Prenotazione per conto dell\'utente : %logincompletbeneficiaire%</p><p>Inizio della prenotazione : %resadatedebut%<br></p><p>Durata : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Tipo : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%<p></p><p></p><p><br></p><p>------</p><p>%raisonmail%<br></p>Se non desiderate ricevere più questi messaggi automatici, scrivete in questo senso all\'amministratore di GRR : %webmasteremail%<p></p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation2_de-de', 'GRR: Meldung %ressource% - %resadatedebut% - Verarbeitung einer Reservierung im Warten von Moderation %enattentemoderation%', '<p>%nometablissement% - Automatische Nachricht von der GRR Webseite : %urlgrr%</p><p>Benutzer %logincompletuser% hat die Reservierungsanfrage für Ressource %ressource% (%domaine%) im Namen von Benutzer %logincompletbeneficiaire% verarbeitet</p><p><font style=\"background-color: rgb(255, 255, 0);\" color=\"#000000\">%decisionmoderation%</font></p><p>%decisionmotif%</p><p>Sehen Sie sich die Details an :</p><p>%urldetail%</p><p><br></p><p><u>Erinnerung an die Anfrage:</u><br></p><p></p><p>Reservierung im Namen von&nbsp; %logincompletbeneficiaire%</p><p>Beginn der Reservierung : %resadatedebut%<br></p><p>Dauer : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Art : %resatype%</p><p><br></p><p></p><p>------</p><p>%raisonmail%<br></p>Wenn\r\n sie diese automatische Nachricht nicht mehr erhalten wollen, wenden Sie\r\n sich bitte an Ihren GRR-Systemverwalter : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation2_en-gb', 'GRR : notice %ressource% - %resadatedebut% - Processing of a reservation waiting for a moderation', '<p>%nometablissement% - Automatic message emitted by GRR site : %urlgrr%</p><p>The user %logincompletuser% processed the resource booking request %ressource% (%domaine%) on behalf of the user %logincompletbeneficiaire%</p><p><font style=\"background-color: rgb(255, 255, 0);\" color=\"#000000\">%decisionmoderation%</font></p><p>%decisionmotif%</p><p>See the details :</p><p>%urldetail%</p><p><br><u>Reminder of the request :</u></p><p>Reservation on behalf of the user : %logincompletbeneficiaire%</p><p>Reservation will start : %resadatedebut%<br></p><p>Duration : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Type : %resatype%</p><p><br></p><p></p><p>------</p><p>%raisonmail%<br></p>If you no longer wish to get these automatic mails, write to GRR manager : %webmasteremail%', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation2_es-es', 'GRR : opinión %ressource% - %resadatedebut% - Tratamiento de una reserva en espera de moderación', '<p>%nometablissement% - Mensaje automático emitido por el GRR : %urlgrr%</p><p>El usuario %logincompletuser% procesó la solicitud de reserva del recurso %ressource% (%domaine%) en nombre del usuario %logincompletbeneficiaire%</p><p><font style=\"background-color: rgb(255, 255, 0);\" color=\"#000000\">%decisionmoderation%</font></p><p>%decisionmotif%</p><p>Ver los detalles :</p><p>%urldetail%</p><p></p><p><br></p><p><u>Recordatorio de la solicitud:</u><br></p><p>Reserva por cuenta del usuario : %logincompletbeneficiaire%</p><p>Principio de la reserva : %resadatedebut%<br></p><p>Duración : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Tipo : %resatype%</p><br><p>------</p><p>%raisonmail%<br></p>Si usted no desea recibir estos mensajes automáticos, escriba al gestor de GRR : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation2_fr-fr', 'GRR : avis %ressource% - %resadatedebut% - Traitement d\'une réservation en attente de modération', '<p>%nometablissement% - Message automatique émis par le site GRR : %urlgrr%</p><p>L\'utilisateur %logincompletuser%&nbsp; a traité la demande de réservation de  la ressource %ressource% (%domaine%) au nom de l\'utilisateur %logincompletbeneficiaire%</p><p><font style=\"background-color: rgb(255, 255, 0);\" color=\"#000000\">%decisionmoderation%</font></p><p>%decisionmotif%</p><p>Voir les détails :</p><p>%urldetail%</p><p><br></p><p><u>Rappel de la demande:</u><br></p><p>Réservation au nom de l\'utilisateur %logincompletbeneficiaire%</p><p>Début de la réservation : %resadatedebut%<br></p><p>Durée : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Type : %resatype%</p><br><p>------</p><p>%raisonmail%</p>Si vous ne souhaitez plus recevoir ces messages automatiques, écrivez en ce sens au gestionnaire de GRR : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation2_it-it', 'GRR : opinione %ressource% - %resadatedebut% - Trattamento di una prenotazione in attesa di moderazione', '<p>%nometablissement% - Messaggio automatico emesso dal sito GRR : %urlgrr%</p><p>L\'utente %logincompletuser% ha elaborato la richiesta di prenotazione per la risorsa %ressource% (%domaine%) per conto dell\'utente %logincompletbeneficiaire%</p><p><font style=\"background-color: rgb(255, 255, 0);\" color=\"#000000\">%decisionmoderation%</font></p><p>%decisionmotif%</p><p>Guarda i dettagli :</p><p>%urldetail%</p><p></p><p><br></p><p><u>Promemoria della richiesta :</u><br></p><p>Prenotato da %logincompletuser%</p><p>Inizio della prenotazione : %resadatedebut%<br></p><p>Durata : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Tipo : %resatype%</p><p><br></p><p>------</p><p>%raisonmail%<br></p>Se non desiderate ricevere più questi messaggi automatici, scrivete in questo senso all\'amministratore di GRR : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation3_de-de', 'GRR: Meldung %ressource% - %resadatedebut% - Reservierung ist im Warten von Moderation', '<p>%nometablissement% - Automatische Nachricht von der GRR Webseite : %urlgrr%</p>Ihre Anfrage steht zur Moderation aus.<br>Sie werden benachrichtigt, sobald der Ressourcenmanager eine Entscheidung trifft.<p><u>Erinnerung an die Anfrage:</u><br></p><p></p><p>Reservierung im Namen von&nbsp; %logincompletbeneficiaire%</p><p>Beginn der Reservierung : %resadatedebut%<br></p><p>Dauer : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Art : %resatype%</p><p><br></p><p></p><p>------</p><p>%raisonmail%<br></p>Wenn\r\n sie diese automatische Nachricht nicht mehr erhalten wollen, wenden Sie\r\n sich bitte an Ihren GRR-Systemverwalter : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation3_en-gb', 'GRR : notice %ressource% - %resadatedebut% - Reservation waiting for a moderation', '<p>%nometablissement% - Automatic message emitted by GRR site : %urlgrr%</p><p>Your request is pending moderation.</p><p>You will be notified as soon as the resource manager decides.</p><p><u>Reminder of the request:</u><br></p><p>Booked by %logincompletuser%</p><p>Reservation in the name of %logincompletbeneficiaire%</p><p>Reservation will start : %resadatedebut%<br></p><p>Duration : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Type : %resatype%</p><p><br></p><p></p><p>------</p><p>%raisonmail%<br></p>If you no longer wish to get these automatic mails, write to GRR manager : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation3_es-es', 'GRR : opinión %ressource% - %resadatedebut% - Reserva en espera de moderación', '<p>%nometablissement% - Mensaje automático emitido por el GRR : %urlgrr%</p>Su solicitud está pendiente de moderación.<br>Se le notificará tan pronto como el administrador de recursos decida.<p></p><p><br></p><p><u>Recordatorio de la solicitud:</u><br></p><p>Reserva por cuenta del usuario : %logincompletbeneficiaire%</p><p>Principio de la reserva : %resadatedebut%<br></p><p>Duración : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Tipo : %resatype%</p><br><p>------</p><p>%raisonmail%<br></p>Si usted no desea recibir estos mensajes automáticos, escriba al gestor de GRR : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation3_fr-fr', 'GRR : avis %ressource% - %resadatedebut% - Réservation en attente de modération', '<p>%nometablissement% - Message automatique émis par le site GRR : %urlgrr%</p><p>Votre demande est en attente de modération.</p><p>Vous serez notifié dès la décision du gestionnaire de la ressource.</p><p><br></p><p><u>Rappel de la demande:</u></p><p> Ressource : %ressource% (%domaine%)<br></p><p>Réservation au nom de l\'utilisateur %logincompletbeneficiaire%</p><p>Début de la réservation : %resadatedebut%<br></p><p>Durée : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Type : %resatype%</p><p><br></p><p>------</p><p>%raisonmail%<br></p>Si vous ne souhaitez plus recevoir ces messages automatiques, écrivez en ce sens au gestionnaire de GRR : %webmasteremail%<p></p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation3_it-it', 'GRR : opinione %ressource% - %resadatedebut% - Prenotazione in attesa di moderazione', '<p>%nometablissement% - Messaggio automatico emesso dal sito GRR : %urlgrr%</p><p>La tua richiesta è in attesa di moderazione.<br>Riceverai una notifica non appena il responsabile delle risorse deciderà.<br></p><br><p><u>Promemoria della richiesta :<br></u>Prenotazione per conto dell\'utente %logincompletbeneficiaire%</p><p>Inizio della prenotazione : %resadatedebut%<br></p><p>Durata : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Tipo : %resatype%</p><p><br></p><p>------</p><p>%raisonmail%<br></p>Se non desiderate ricevere più questi messaggi automatici, scrivete in questo senso all\'amministratore di GRR : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation4_de-de', 'GRR: Meldung %ressource% - %resadatedebut% - Verarbeitung einer Reservierung im Warten von Moderation %enattentemoderation%', '<p>%nometablissement% - Automatische Nachricht von der GRR Webseite : %urlgrr%</p><p>Benutzer\r\n %logincompletuser% Ihre Reservierungsanfrage für die Ressource wurde bearbeitet %ressource% (%domaine%)</p><p><font style=\"background-color: rgb(255, 255, 0);\" color=\"#000000\">%decisionmoderation%</font></p><p>%decisionmotif%</p><p>Sehen Sie sich die Details an :</p><p>%urldetail%</p><p><br></p><p><u>Erinnerung an die Anfrage:</u><br></p><p></p><p>Reservierung im Namen von&nbsp; %logincompletbeneficiaire%</p><p>Beginn der Reservierung : %resadatedebut%<br></p><p>Dauer : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Art : %resatype%</p><p><br></p><p></p><p>------</p><p>%raisonmail%<br></p>Wenn\r\n sie diese automatische Nachricht nicht mehr erhalten wollen, wenden Sie\r\n sich bitte an Ihren GRR-Systemverwalter : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation4_en-gb', 'GRR : notice %ressource% - %resadatedebut% - Processing of a reservation waiting for a moderation', '<p>%nometablissement% - Automatic message emitted by GRR site : %urlgrr%</p><p>The\r\n user %logincompletuser% processed your reservation request for the resource \r\n%ressource% (%domaine%)<br></p><p><font style=\"background-color: rgb(255, 255, 0);\" color=\"#000000\">%decisionmoderation%</font></p><p>%decisionmotif%</p><p>See the details :</p><p>%urldetail%</p><p><br><u>Reminder of the request :</u></p><p>Reservation on behalf of the user : %logincompletbeneficiaire%</p><p>Reservation will start : %resadatedebut%<br></p><p>Duration : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Type : %resatype%</p><p><br></p><p></p><p>------</p><p>%raisonmail%<br></p>If you no longer wish to get these automatic mails, write to GRR manager : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation4_es-es', 'GRR : opinión %ressource% - %resadatedebut% - Tratamiento de una reserva en espera de moderación', '<p>%nometablissement% - Mensaje automático emitido por el GRR : %urlgrr%</p><p>El\r\n usuario %logincompletuser% procesó su solicitud de reserva para el recurso\r\n%ressource% (%domaine%)<br></p><p><font style=\"background-color: rgb(255, 255, 0);\" color=\"#000000\">%decisionmoderation%</font></p><p>%decisionmotif%</p><p>Ver los detalles :</p><p>%urldetail%</p><p></p><p><br></p><p><u>Recordatorio de la solicitud:</u><br></p><p>Reserva por cuenta del usuario : %logincompletbeneficiaire%</p><p>Principio de la reserva : %resadatedebut%<br></p><p>Duración : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Tipo : %resatype%</p><br><p>------</p><p>%raisonmail%<br></p>Si usted no desea recibir estos mensajes automáticos, escriba al gestor de GRR : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation4_fr-fr', 'GRR : avis %ressource% - %resadatedebut% - Traitement d\'une réservation en attente de modération', '<p>%nometablissement% - Message automatique émis par le site GRR : %urlgrr%</p><p>L\'utilisateur %logincompletuser%&nbsp; a traité la demande de votre réservation \r\npour la ressource %ressource% (%domaine%)</p><p><font style=\"background-color: rgb(255, 255, 0);\" color=\"#000000\">%decisionmoderation%</font></p><p>%decisionmotif%</p><p>Voir les détails :</p><p>%urldetail%</p><p><br></p><p><u>Rappel de la demande:</u><br></p><p>Réservation au nom de l\'utilisateur %logincompletbeneficiaire%</p><p>Début de la réservation : %resadatedebut%<br></p><p>Durée : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Type : %resatype%</p><p><br></p><p></p><p>------</p><p>%raisonmail%<br></p>Si vous ne souhaitez plus recevoir ces messages automatiques, écrivez en ce sens au gestionnaire de GRR : %webmasteremail%<p></p><p></p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation4_it-it', 'GRR : opinione %ressource% - %resadatedebut% - Trattamento di una prenotazione in attesa di moderazione', '<p>%nometablissement% - Messaggio automatico emesso dal sito GRR : %urlgrr%</p><p>L\'utente\r\n %logincompletuser% ha elaborato la tua richiesta di prenotazione per la risorsa %ressource% (%domaine%)<br></p><p><font style=\"background-color: rgb(255, 255, 0);\" color=\"#000000\">%decisionmoderation%</font></p><p>%decisionmotif%</p><p>Guarda i dettagli :</p><p>%urldetail%</p><p></p><p><br></p><p><u>Promemoria della richiesta :</u><br></p><p>Prenotazione per conto dell\'utente %logincompletbeneficiaire%</p><p>Inizio della prenotazione : %resadatedebut%<br></p><p>Durata : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Tipo : %resatype%</p><p><br></p><p>------</p><p>%raisonmail%<br></p>Se non desiderate ricevere più questi messaggi automatici, scrivete in questo senso all\'amministratore di GRR : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation5_de-de', 'GRR: Meldung %ressource% - %resadatedebut% - Eine Reservierung löschen', '<p><p>%nometablissement% - Automatische Nachricht von der GRR Webseite : %urlgrr%</p>Benutzer %logincompletuser% hat Buchungsanfrage für Ressource %ressource% (%domaine%) gelöscht</p><p><p><u>Erinnerung an die Anfrage:</u><br></p><p></p><p>Reservierung im Namen von&nbsp; %logincompletbeneficiaire%</p><p>Beginn der Reservierung : %resadatedebut%<br></p><p>Dauer : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Art : %resatype%</p><p><br></p><p></p><p>------</p><p>%raisonmail%<br></p>Wenn\r\n sie diese automatische Nachricht nicht mehr erhalten wollen, wenden Sie\r\n sich bitte an Ihren GRR-Systemverwalter : %webmasteremail%<p><br></p><p></p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation5_en-gb', 'GRR : notice %ressource% - %resadatedebut% - Deleting a reservation', '<p>%nometablissement% - Automatic message emitted by GRR site : %urlgrr%</p><p>The\r\n user %logincompletuser% deleted the booking request for the resource \r\n%ressource% (%domaine%)<br></p><p><br><u>Reminder of the request :</u></p><p>Reservation on behalf of the user : %logincompletbeneficiaire%</p><p>Reservation will start : %resadatedebut%<br></p><p>Duration : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Type : %resatype%</p><p><br></p><p></p><p>------</p><p>%raisonmail%<br></p>If you no longer wish to get these automatic mails, write to GRR manager : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation5_es-es', 'GRR : opinión %ressource% - %resadatedebut% - Supresión de una reserva', '<p>%nometablissement% - Mensaje automático emitido por el GRR : %urlgrr%</p>El usuario %logincompletuser% eliminó la solicitud de reserva para el recurso %ressource% (%domaine%)<p></p><p><br></p><p><u>Recordatorio de la solicitud:</u><br></p><p>Reserva por cuenta del usuario : %logincompletbeneficiaire%</p><p>Principio de la reserva : %resadatedebut%<br></p><p>Duración : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Tipo : %resatype%</p><br><p>------</p><p>%raisonmail%<br></p>Si usted no desea recibir estos mensajes automáticos, escriba al gestor de GRR : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation5_fr-fr', 'GRR : avis %ressource% - %resadatedebut% - Suppression d\'une réservation', '<p>%nometablissement% - Message automatique émis par le site GRR : %urlgrr%</p><p>L\'utilisateur %logincompletuser%&nbsp; a supprimé la demande de réservation \r\npour la ressource %ressource% (%domaine%)</p><p><br></p><p><u>Rappel de la demande:</u><br></p><p>Réservation au nom de l\'utilisateur %logincompletbeneficiaire%</p><p>Début de la réservation : %resadatedebut%<br></p><p>Durée : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Type : %resatype%</p><p><br></p><p></p><p>------</p><p>%raisonmail%<br></p>Si vous ne souhaitez plus recevoir ces messages automatiques, écrivez en ce sens au gestionnaire de GRR : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation5_it-it', 'GRR : opinione %ressource% - %resadatedebut% - Soppressione di una prenotazione', '<p>%nometablissement% - Messaggio automatico emesso dal sito GRR : %urlgrr%</p><p>L\'utente %logincompletuser% ha eliminato la richiesta di prenotazione per la risorsa %ressource% (%domaine%)<br></p><br><p><u>Promemoria della richiesta :<br></u>Prenotazione per conto dell\'utente %logincompletbeneficiaire%</p><p>Inizio della prenotazione : %resadatedebut%<br></p><p>Durata : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Tipo : %resatype%</p><p><br></p><p>------</p><p>%raisonmail%<br></p>Se non desiderate ricevere più questi messaggi automatici, scrivete in questo senso all\'amministratore di GRR : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation6_de-de', 'GRR: Meldung %ressource% - %resadatedebut% - Verarbeitung einer Reservierung im Warten von Moderation', '<p>%nometablissement% - Automatische Nachricht von der GRR Webseite : %urlgrr%</p><p>Eine Reservierungsanfrage lautet nun:</p><p>%urldetail%</p><p>Der folgende vorbehalt wartet auf die moderation %ressource%  (%domaine%)</p><p>Gebucht von %logincompletuser%</p><p>Reservierung im Namen von&nbsp; %logincompletbeneficiaire%</p><p>Beginn der Reservierung : %resadatedebut%<br></p><p>Dauer : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Art : %resatype%</p><p><br></p><p></p><p>------</p><p>%raisonmail%<br></p>Wenn\r\n sie diese automatische Nachricht nicht mehr erhalten wollen, wenden Sie\r\n sich bitte an Ihren GRR-Systemverwalter : %webmasteremail%<p><br></p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation6_en-gb', 'GRR : notice %ressource% - %resadatedebut% - Processing of a reservation waiting for a moderation', '<p>%nometablissement% - Automatic message emitted by GRR site : %urlgrr%</p><p>A reservation request is to be moderated :</p><p>%urldetail%</p><p>The following reservation is awaiting moderation for %ressource% (%domaine%)<br></p><p>Booked by %logincompletuser%</p><p>Reservation on behalf of the user : %logincompletbeneficiaire%</p><p>Reservation will start : %resadatedebut%<br></p><p>Duration : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Type : %resatype%</p><p><br></p><p></p><p>------</p><p>%raisonmail%<br></p>If you no longer wish to get these automatic mails, write to GRR manager : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation6_es-es', 'GRR : opinión %ressource% - %resadatedebut% - Tratamiento de una reserva en espera de moderación', '<p>%nometablissement% - Mensaje automático emitido por el GRR : %urlgrr%</p><p>Una solicitud de reserva debe ser moderada :</p><p>%urldetail%</p>La siguiente reserva está pendiente de moderación para %ressource% (%domaine%)<p></p><p>Reservado por %logincompletuser%</p><p>Reserva por cuenta del usuario : %logincompletbeneficiaire%</p><p>Principio de la reserva : %resadatedebut%<br></p><p>Duración : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Tipo : %resatype%</p><br><p>------</p><p>%raisonmail%<br></p>Si usted no desea recibir estos mensajes automáticos, escriba al gestor de GRR : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation6_fr-fr', 'GRR : avis %ressource% - %resadatedebut% - Traitement d\'une réservation en attente de modération', '<p>%nometablissement% - Message automatique émis par le site GRR : %urlgrr%</p><p>Une demande de réservation est à modérer :</p><p>%urldetail%<br></p><p>La réservation suivante est en attente de modération pour %ressource% (%domaine%)</p><p>Réservé par %logincompletuser%</p><p>Réservation au nom de l\'utilisateur %logincompletbeneficiaire%</p><p>Début de la réservation : %resadatedebut%<br></p><p>Durée : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Type : %resatype%</p><br><p>------</p><p>%raisonmail%</p>Si vous ne souhaitez plus recevoir ces messages automatiques, écrivez en ce sens au gestionnaire de GRR : %webmasteremail%', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation6_it-it', 'GRR : opinione %ressource% - %resadatedebut% - Trattamento di una prenotazione in attesa di moderazione', '<p>%nometablissement% - Messaggio automatico emesso dal sito GRR : %urlgrr%</p><p>Una richiesta di prenotazione deve essere moderata :</p><p>%urldetail%</p><p>La seguente prenotazione è in attesa di moderazione per %ressource% (%domaine%)<br></p>Prenotato da %logincompletuser%<p>Prenotazione per conto dell\'utente %logincompletbeneficiaire%</p><p>Inizio della prenotazione : %resadatedebut%<br></p><p>Durata : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Tipo : %resatype%</p><p><br></p><p>------</p><p>%raisonmail%<br></p>Se non desiderate ricevere più questi messaggi automatici, scrivete in questo senso all\'amministratore di GRR : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation_de-de', 'GRR: Meldung %ressource% - %resadatedebut% - Reservierung ist im Warten von Moderation', '<p>%nometablissement% - Automatische Nachricht von der GRR Webseite : %urlgrr%</p><p>Der folgende vorbehalt wartet auf die moderation %ressource%  (%domaine%)</p><p>Gebucht von %logincompletuser%</p><p>Reservierung im Namen von&nbsp; %logincompletbeneficiaire%</p><p>Beginn der Reservierung : %resadatedebut%<br></p><p>Dauer : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Art : %resatype%</p><p><br></p><p></p><p>------</p><p>%raisonmail%<br></p>Wenn\r\n sie diese automatische Nachricht nicht mehr erhalten wollen, wenden Sie\r\n sich bitte an Ihren GRR-Systemverwalter : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation_en-gb', 'GRR : notice %ressource% - %resadatedebut% - Reservation waiting for a moderation', '<p>%nometablissement% - Automatic message emitted by GRR site : %urlgrr%</p><p>The following reservation is awaiting moderation for %ressource% (%domaine%)</p><p>Booked by %logincompletuser%</p><p>Reservation in the name of %logincompletbeneficiaire%</p><p>Reservation will start : %resadatedebut%<br></p><p>Duration : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Type : %resatype%</p><p><br></p><p></p><p>------</p><p>%raisonmail%<br></p>If you no longer wish to get these automatic mails, write to GRR manager : %webmasteremail%<p><br></p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation_es-es', 'GRR : opinión %ressource% - %resadatedebut% - Reserva en espera de moderación', '<p>%nometablissement% - Mensaje automático emitido por el GRR : %urlgrr%</p><p>La siguiente reserva está pendiente de moderación para %ressource% (%domaine%)</p><p>Reservado por %logincompletuser%<br></p><p>Reserva por cuenta del usuario : %logincompletbeneficiaire%</p><p>Principio de la reserva : %resadatedebut%<br></p><p>Duración : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Tipo : %resatype%</p><br><p>------</p><p>%raisonmail%<br></p>Si usted no desea recibir estos mensajes automáticos, escriba al gestor de GRR : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation_fr-fr', 'GRR : avis %ressource% - %resadatedebut% - Réservation en attente de modération', '<p>%nometablissement% - Message automatique émis par le site GRR : %urlgrr%</p><p>La réservation suivante est en attente de modération pour %ressource% (%domaine%)</p><p>Réservé par %logincompletuser%</p><p>Réservation au nom de l\'utilisateur %logincompletbeneficiaire%</p><p>Début de la réservation : %resadatedebut%<br></p><p>Durée : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Type : %resatype%</p><br><p>------</p><p>%raisonmail%</p>Si vous ne souhaitez plus recevoir ces messages automatiques, écrivez en ce sens au gestionnaire de GRR : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamoderation_it-it', 'GRR : opinione %ressource% - %resadatedebut% - Prenotazione in attesa di moderazione', '<p>%nometablissement% - Messaggio automatico emesso dal sito GRR : %urlgrr%</p><p>La seguente prenotazione è in attesa di moderazione per %ressource%  (%domaine%) <br></p><p><br></p><p>Prenotato da %logincompletuser%</p><p>Inizio della prenotazione : %resadatedebut%<br></p><p>Durata : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Tipo : %resatype%</p><p><br></p><p>------</p><p>%raisonmail%<br></p>Se non desiderate ricevere più questi messaggi automatici, scrivete in questo senso all\'amministratore di GRR : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamodification2_de-de', 'GRR: Meldung %ressource% - %resadatedebut% - Eine Reservierung ändern %enattentemoderation%', '<p><p>%nometablissement% - Automatische Nachricht von der GRR Webseite : %urlgrr%</p><p>Benutzer %logincompletuser% hat folgende Reservierung geändert %ressource% (%domaine%) das du getan hast.</p><p><br></p><p>Reservierung im Namen von&nbsp; %logincompletbeneficiaire%</p><p>Beginn der Reservierung : %resadatedebut%<br></p><p>Dauer : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Art : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%</p><p><p><br></p><p>------</p><p>%raisonmail%<br></p>Wenn\r\n sie diese automatische Nachricht nicht mehr erhalten wollen, wenden Sie\r\n sich bitte an Ihren GRR-Systemverwalter : %webmasteremail%</p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamodification2_en-gb', 'GRR : notice %ressource% - %resadatedebut% - Modifying a reservation %enattentemoderation%', '<p><p>%nometablissement% - Automatic message emitted by GRR site : %urlgrr%</p><p>The user %logincompletuser% has modified the reservation of %ressource% (%domaine%) that you had done.</p><p><br></p><p>Reservation in the name of %logincompletbeneficiaire%</p><p>Reservation will start : %resadatedebut%<br></p><p>Duration : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Type : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%</p><p><p><br></p><p>------</p><p>%raisonmail%<br></p>If you no longer wish to get these automatic mails, write to GRR manager : %webmasteremail%<p></p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamodification2_es-es', 'GRR : opinión %ressource% - %resadatedebut% - Modificación de una reserva %enattentemoderation%', '<p><p>%nometablissement% - Mensaje automático emitido por el GRR : %urlgrr%</p><p>El usuario %logincompletuser% cambió la reserva del recurso %ressource%  (%domaine%) que habías hecho.</p><br><p>Principio de la reserva : %resadatedebut%<br></p><p>Duración : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Tipo : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%</p><p><p><br></p><p>------</p><p>%raisonmail%<br></p>Si usted no desea recibir estos mensajes automáticos, escriba al gestor de GRR : %webmasteremail%<p></p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamodification2_fr-fr', 'GRR : avis %ressource% - %resadatedebut% - Modification d\'une réservation %enattentemoderation%', '<p><p>%nometablissement% - Message automatique émis par le site GRR : %urlgrr%</p><p>L\'utilisateur %logincompletuser% a modifié la réservation de la ressource %ressource% (%domaine%)&nbsp; que vous aviez effectuée.</p><p><br></p><p>Début de la réservation : %resadatedebut%<br></p><p>Durée : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Type : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%</p><p><p><br></p><p>------<br></p>Si vous ne souhaitez plus recevoir ces messages automatiques, écrivez en ce sens au gestionnaire de GRR : %webmasteremail%<p></p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamodification2_it-it', 'GRR : opinione %ressource% - %resadatedebut% - Modifica di una prenotazione %enattentemoderation%', '<p><p>%nometablissement% - Messaggio automatico emesso dal sito GRR : %urlgrr%</p><p>L\'utente %logincompletuser% ha cambiato la prenotazione della risorsa %ressource%  (%domaine%) che avevi fatto.<br></p><p><br></p><p>Inizio della prenotazione : %resadatedebut%<br></p><p>Durata : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Tipo : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%</p><p><p><br></p><p>------</p><p>%raisonmail%<br></p>Se non desiderate ricevere più questi messaggi automatici, scrivete in questo senso all\'amministratore di GRR : %webmasteremail%<p></p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamodification_de-de', 'GRR: Meldung %ressource% - %resadatedebut% - Eine Reservierung ändern %enattentemoderation%', '<p><p>%nometablissement% - Automatische Nachricht von der GRR Webseite : %urlgrr%</p><p>Benutzer %logincompletuser% hat folgende Reservierung geändert %ressource% (%domaine%)</p><p><br></p><p>Reservierung im Namen von&nbsp; %logincompletbeneficiaire%</p><p>Beginn der Reservierung : %resadatedebut%<br></p><p>Dauer : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Art : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%</p><p><p><br></p><p>------</p><p>%raisonmail%<br></p>Wenn\r\n sie diese automatische Nachricht nicht mehr erhalten wollen, wenden Sie\r\n sich bitte an Ihren GRR-Systemverwalter : %webmasteremail%</p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamodification_en-gb', 'GRR : notice %ressource% - %resadatedebut% - Modifying a reservation %enattentemoderation%', '<p><p>%nometablissement% - Automatic message emitted by GRR site : %urlgrr%</p><p>The user %logincompletuser% has modified the reservation of %ressource% (%domaine%)</p><p><br></p><p>Reservation in the name of %logincompletbeneficiaire%</p><p>Reservation will start : %resadatedebut%<br></p><p>Duration : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Type : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%</p><p><p><br></p><p>------</p><p>%raisonmail%<br></p>If you no longer wish to get these automatic mails, write to GRR manager : %webmasteremail%<p></p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamodification_es-es', 'GRR : opinión %ressource% - %resadatedebut% - Modificación de una reserva %enattentemoderation%', '<p><p>%nometablissement% - Mensaje automático emitido por el GRR : %urlgrr%</p><p>El usuario %logincompletuser% cambió la reserva del recurso %ressource%  (%domaine%)</p><p><br></p><p>Reserva por cuenta del usuario : %logincompletbeneficiaire%</p><p>Principio de la reserva : %resadatedebut%<br></p><p>Duración : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Tipo : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%</p><p><p><br></p><p>------</p><p>%raisonmail%<br></p>Si usted no desea recibir estos mensajes automáticos, escriba al gestor de GRR : %webmasteremail%<p></p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamodification_fr-fr', 'GRR : avis %ressource% - %resadatedebut% - Modification d\'une réservation %enattentemoderation%', '<p>%nometablissement% - Message automatique émis par le site GRR : %urlgrr%</p><p>L\'utilisateur %logincompletuser% a modifié la réservation de la ressource %ressource% (%domaine%)</p><p><br></p><p>Réservation au nom de l\'utilisateur %logincompletbeneficiaire%</p><p>Début de la réservation : %resadatedebut%<br></p><p>Durée : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Type : %resatype%</p><p>%resaperiodique%</p><p>%resaconfirmation%</p><p><br></p><p>------</p><p>%raisonmail%<br></p><p>Si vous ne souhaitez plus recevoir ces messages automatiques, écrivez en ce sens au gestionnaire de GRR : %webmasteremail%<br></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resamodification_it-it', 'GRR : opinione %ressource% - %resadatedebut% - Modifica di una prenotazione %enattentemoderation%', '<p><p>%nometablissement% - Messaggio automatico emesso dal sito GRR : %urlgrr%</p><p>L\'utente %logincompletuser% ha cambiato la prenotazione della risorsa %ressource%  (%domaine%)</p><p><br></p><p>Prenotazione per conto dell\'utente : %logincompletbeneficiaire%</p><p>Inizio della prenotazione : %resadatedebut%<br></p><p>Durata : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Tipo : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%</p><p><p><br></p><p>------</p><p>%raisonmail%<br></p>Se non desiderate ricevere più questi messaggi automatici, scrivete in questo senso all\'amministratore di GRR : %webmasteremail%</p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resasuppression2_de-de', 'GRR: Meldung %ressource% - %resadatedebut% - Eine Reservierung löschen %enattentemoderation%', '<p>%nometablissement% - Automatische Nachricht von der GRR Webseite : %urlgrr%</p><p>Der Benutzer %logincompletuser% hat die von Ihnen vorgenommene Reservierung der Ressource %ressource% (%domaine%) geändert.<br></p><p><br></p><p>Beginn der Reservierung : %resadatedebut%<br></p><p>Dauer : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Art : %resatype%</p><p><br></p><p></p><p>------</p><p>%raisonmail%<br></p>Wenn\r\n sie diese automatische Nachricht nicht mehr erhalten wollen, wenden Sie\r\n sich bitte an Ihren GRR-Systemverwalter : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resasuppression2_en-gb', 'GRR : notice %ressource% - %resadatedebut% - Deleting a reservation %enattentemoderation%', '<p>%nometablissement% - Automatic message emitted by GRR site : %urlgrr%</p><p>The user %logincompletuser% has deleted the reservation of %ressource% that you had done.</p><br><p>Reservation will start : %resadatedebut%<br></p><p>Duration : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Type : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%<p></p><p></p><p><br></p><p>------</p><p>%raisonmail%<br></p>If you no longer wish to get these automatic mails, write to GRR manager : %webmasteremail%<p></p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resasuppression2_es-es', 'GRR : opinión %ressource% - %resadatedebut% - Supresión de una reserva %enattentemoderation%', '<p>%nometablissement% - Mensaje automático emitido por el GRR : %urlgrr%</p><p>El usuario %logincompletuser% eliminó la reserva de %ressource%  (%domaine%) que habías hecho.</p><p><br></p><p>Principio de la reserva : %resadatedebut%<br></p><p>Duración : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Tipo : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%<p></p><p></p><p><br></p><p>------</p><p>%raisonmail%<br></p>Si usted no desea recibir estos mensajes automáticos, escriba al gestor de GRR : %webmasteremail%<p></p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resasuppression2_fr-fr', 'GRR : avis %ressource% - %resadatedebut% - Suppression d\'une réservation  %enattentemoderation%', '<p><p>%nometablissement% - Message automatique émis par le site GRR : %urlgrr%</p>L\'utilisateur %logincompletuser% a supprimé la réservation de la ressource %ressource% (%domaine%)&nbsp; que vous aviez effectuée.</p><p><p><br></p><p>Début de la réservation : %resadatedebut%<br></p><p>Durée : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Type : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%</p><p><p><br></p><p>------<br></p>Si vous ne souhaitez plus recevoir ces messages automatiques, écrivez en ce sens au gestionnaire de GRR : %webmasteremail%<p></p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resasuppression2_it-it', 'GRR : opinione %ressource% - %resadatedebut% -  Soppressione di una prenotazione %enattentemoderation%', '<p>%nometablissement% - Messaggio automatico emesso dal sito GRR : %urlgrr%</p><p>L\'utente %logincompletuser% cancellata la prenotazione di %ressource%  (%domaine%) che avevi fatto.</p><br><p>Inizio della prenotazione : %resadatedebut%<br></p><p>Durata : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Tipo : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%<p></p><p></p><p><br></p><p>------</p><p>%raisonmail%<br></p>Se non desiderate ricevere più questi messaggi automatici, scrivete in questo senso all\'amministratore di GRR : %webmasteremail%<p></p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resasuppression3_de-de', 'GRR: Meldung %ressource% - %resadatedebut% - Eine Reservierung löschen %enattentemoderation%', '<p>%nometablissement% - Automatische Nachricht von der GRR Webseite : %urlgrr%</p><p>Die Frist für die Reservierungsbestätigung ist abgelaufen.</p>Automatisches Löschen der Ressourcenreservierung %ressource% (%domaine%) <p></p><p><br></p><p>Beginn der Reservierung : %resadatedebut%<br></p><p>Dauer : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Art : %resatype%</p><p><br></p><p></p><p>------</p><p>%raisonmail%<br></p>Wenn\r\n sie diese automatische Nachricht nicht mehr erhalten wollen, wenden Sie\r\n sich bitte an Ihren GRR-Systemverwalter : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resasuppression3_en-gb', 'GRR : notice %ressource% - %resadatedebut% - Deleting a reservation %enattentemoderation%', '<p>%nometablissement% - Automatic message emitted by GRR site : %urlgrr%</p><p>The delay of confirmation of the reservation is exceeded.</p><p>Automatic suppression of the reservation of %ressource% (%domaine%) </p><p><br></p><p>Reservation will start : %resadatedebut%<br></p><p>Duration : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Type : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%<p></p><p></p><p><br></p><p>------</p><p>%raisonmail%<br></p>If you no longer wish to get these automatic mails, write to GRR manager : %webmasteremail%<p></p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resasuppression3_es-es', 'GRR : opinión %ressource% - %resadatedebut% - Supresión de una reserva %enattentemoderation%', '<p>%nometablissement% - Mensaje automático emitido por el GRR : %urlgrr%</p><p>El plazo de confirmación de reserva sobrepasó.</p><p>Supresión automático de la reserva de %ressource%  (%domaine%)</p><p><br></p><p>Principio de la reserva : %resadatedebut%<br></p><p>Duración : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Tipo : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%<p></p><p></p><p><br></p><p>------</p><p>%raisonmail%<br></p>Si usted no desea recibir estos mensajes automáticos, escriba al gestor de GRR : %webmasteremail%<p></p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resasuppression3_fr-fr', 'GRR : avis %ressource% - %resadatedebut% - Suppression d\'une réservation  %enattentemoderation%', '<p><p>%nometablissement% - Message automatique émis par le site GRR : %urlgrr%</p><p>Le délai de confirmation de réservation a été dépassé.</p><p>Suppression automatique de la réservation de la ressource %ressource% (%domaine%) </p><p><br></p><p>Début de la réservation : %resadatedebut%<br></p><p>Durée : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Type : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%</p><p><p><br></p><p>------<br></p>Si vous ne souhaitez plus recevoir ces messages automatiques, écrivez en ce sens au gestionnaire de GRR : %webmasteremail%<p></p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resasuppression3_it-it', 'GRR : opinione %ressource% - %resadatedebut% - Soppressione di una prenotazione %enattentemoderation%', '<p>%nometablissement% - Messaggio automatico emesso dal sito GRR : %urlgrr%</p><p>Il termine per la conferma della prenotazione è scaduto.<br>Cancellazione automatica della prenotazione di %ressource%  (%domaine%)</p><p><br></p><p>Inizio della prenotazione : %resadatedebut%<br></p><p>Durata : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Tipo : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%<p></p><p></p><p><br></p><p>------</p><p>%raisonmail%<br></p>Se non desiderate ricevere più questi messaggi automatici, scrivete in questo senso all\'amministratore di GRR : %webmasteremail%<p></p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resasuppression_de-de', 'GRR: Meldung %ressource% - %resadatedebut% - Eine Reservierung löschen %enattentemoderation%', '<p>%nometablissement% - Automatische Nachricht von der GRR Webseite : %urlgrr%</p><p>Benutzer %logincompletuser% hat folgende Reservierung gelöscht %ressource%</p><p><br></p><p>Reservierung im Namen von&nbsp; %logincompletbeneficiaire%</p><p>Beginn der Reservierung : %resadatedebut%<br></p><p>Dauer : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Art : %resatype%</p><p><br></p><p></p><p>------</p><p>%raisonmail%<br></p>Wenn\r\n sie diese automatische Nachricht nicht mehr erhalten wollen, wenden Sie\r\n sich bitte an Ihren GRR-Systemverwalter : %webmasteremail%<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resasuppression_en-gb', 'GRR : notice %ressource% - %resadatedebut% - Deleting a reservation %enattentemoderation%', '<p><p>%nometablissement% - Automatic message emitted by GRR site : %urlgrr%</p><p>The user %logincompletuser% has deleted the reservation of %ressource%</p><p><br></p><p>Reservation in the name of %logincompletbeneficiaire%</p><p>Reservation will start : %resadatedebut%<br></p><p>Duration : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Type : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%</p><p><p><br></p><p>------</p><p>%raisonmail%<br></p>If you no longer wish to get these automatic mails, write to GRR manager : %webmasteremail%<p></p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resasuppression_es-es', 'GRR : opinión %ressource% - %resadatedebut% - Supresión de una reserva %enattentemoderation%', '<p><p>%nometablissement% - Mensaje automático emitido por el GRR : %urlgrr%</p><p>El usuario %logincompletuser% eliminó la reserva de %ressource%  (%domaine%)</p><p><br></p><p>Reserva por cuenta del usuario : %logincompletbeneficiaire%</p><p>Principio de la reserva : %resadatedebut%<br></p><p>Duración : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Tipo : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%</p><p><p><br></p><p>------</p><p>%raisonmail%<br></p>Si usted no desea recibir estos mensajes automáticos, escriba al gestor de GRR : %webmasteremail%<p></p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resasuppression_fr-fr', 'GRR : avis %ressource% - %resadatedebut% - Suppression d\'une réservation  %enattentemoderation%', '<p>%nometablissement% - Message automatique émis par le site GRR : %urlgrr%</p><p>L\'utilisateur %logincompletuser% a supprimé la réservation de %ressource% (%domaine%)</p><p><br></p><p>Réservation au nom de l\'utilisateur %logincompletbeneficiaire%</p><p>Début de la réservation : %resadatedebut%<br></p><p>Durée : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Type : %resatype%</p><br><p>------</p><p>%raisonmail%</p><p>Si vous ne souhaitez plus recevoir ces messages automatiques, écrivez en ce sens au gestionnaire de GRR : %webmasteremail%<br></p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_resasuppression_it-it', 'GRR : opinione %ressource% - %resadatedebut% - Soppressione di una prenotazione %enattentemoderation%', '<p><p>%nometablissement% - Messaggio automatico emesso dal sito GRR : %urlgrr%</p><p>L\'utente %logincompletuser% cancellata la prenotazione di %ressource%  (%domaine%)</p><p><br></p><p>Prenotazione per conto dell\'utente : %logincompletbeneficiaire%</p><p>Inizio della prenotazione : %resadatedebut%<br></p><p>Durata : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Tipo : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%</p><p><p><br></p><p>------</p><p>%raisonmail%<br></p>Se non desiderate ricevere più questi messaggi automatici, scrivete in questo senso all\'amministratore di GRR : %webmasteremail%<p></p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_retardrestitution2_de-de', 'GRR: Meldung %ressource% - %resadatedebut% - Verzögerungsbenachrichtigung', '<p>%nometablissement% -&nbsp;Automatische Nachricht von der GRR Webseite&nbsp; : %urlgrr%</p><br><p>Sofern ich mich nicht irre, wurde die von Ihnen geliehene ressource&nbsp;<b>%ressource%</b> (%domaine%) nicht zurückgegeben. Wenn es sich hierbei um einen Fehler handelt, ignorieren Sie diese E-Mail bitte.</p><p><br></p><p>Reservierung im Namen von : %logincompletbeneficiaire%</p><p>Beginn der Reservierung : %resadatedebut%<br></p><p>Dauer : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Art : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%<p><br></p><p></p>------<p></p><p>%raisonmail%</p><p>Wenn\r\n sie diese automatische Nachricht nicht mehr erhalten wollen, wenden Sie\r\n sich bitte an Ihren GRR-Systemverwalter : %webmasteremail%</p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_retardrestitution2_en-gb', 'GRR : notice %ressource% - %resadatedebut% - Notifying a delay', '<p>%nometablissement% -&nbsp;Automatic message emitted by GRR site : %urlgrr%</p><br><p>Errors excepted, the resource&nbsp;<b>%ressource% </b>(%domaine%) you borrowed was not restored. If it is an error, please not take this mail into account.</p><p><br></p><p>Reservation in the name of : %logincompletbeneficiaire%</p><p>Reservation will start : %resadatedebut%<br></p><p>Duration : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Type : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%<p><br></p><p></p>------<p></p><p>%raisonmail%<br>If you no longer wish to get these automatic mails, write to GRR manager : %webmasteremail%</p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_retardrestitution2_es-es', 'GRR : opinión %ressource% - %resadatedebut% - Notificación de retraso', '<p>%nometablissement% -&nbsp;Mensaje automático emitido por el GRR : %urlgrr%</p><br><p>A menos que me equivoque, el recurso <b>%ressource%</b> (%domaine%)que tomó prestado no se ha devuelto. Si se trata de un error, ignore este correo.</p><p><br></p><p>Reserva por cuenta del usuario : %logincompletbeneficiaire%</p><p>Principio de la reserva : %resadatedebut%<br></p><p>Duración : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Tipo : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%<p><br></p><p></p>------<p></p><p>%raisonmail%</p><p>Si usted no desea recibir estos mensajes automáticos, escriba al gestor de GRR : %webmasteremail%</p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_retardrestitution2_fr-fr', 'GRR : avis %ressource% - %resadatedebut% - Notification de retard', '<p>%nometablissement% - Message automatique émis par le site GRR : %urlgrr%</p><br><p>Sauf erreur, la ressource <b>%ressource%</b> (%domaine%) que vous avez empruntée n\'a pas été restituée. S\'il s\'agit d\'une erreur, veuillez ne pas tenir compte de ce courrier.</p><p><br></p><p>Réservation au nom de l\'utilisateur : %logincompletbeneficiaire%</p><p>Début de la réservation : %resadatedebut%<br></p><p>Durée : %resaduree%</p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Type : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%<p><br></p><p></p>------<p></p><p>%raisonmail%<br>Si vous ne souhaitez plus recevoir ces messages automatiques, écrivez en ce sens au gestionnaire de GRR : %webmasteremail%</p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_retardrestitution2_it-it', 'GRR : opinione %ressource% - %resadatedebut% - Notifica di ritardo', '<p>%nometablissement% -&nbsp;Messaggio automatico emesso dal sito GRR : %urlgrr%</p><br><p>Se non sbaglio, la risorsa <b>%ressource%</b> (%domaine%) che hai preso in prestito non è stata restituita. Se si tratta di un errore, si prega di ignorare questa mail.</p><p><br></p><p>Prenotazione per conto dell\'utente : %logincompletbeneficiaire%</p>Inizio della prenotazione : %resadatedebut%<p></p><p>Durata : %resaduree%</p><p></p><p>%resanom%<br></p><p>%resadescription%<br></p><p>%resachampsadditionnels%</p><p>Tipo : %resatype%</p><p>%resaperiodique%</p>%resaconfirmation%<p><br></p><p></p>------<p></p><p>%raisonmail%</p><p>Se non desiderate ricevere più questi messaggi automatici, scrivete in questo senso all\'amministratore di GRR : %webmasteremail%</p><p></p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_retardrestitution_de-de', 'GRR: Meldung %ressource% - %resadatedebut% - Verzögerungsbenachrichtigung', '<p>%nometablissement% -&nbsp;Automatische Nachricht von der GRR Webseite :  %urlgrr%</p><p>Ressource<b> %ressource%</b> (%domaine%) <u>wurde nicht zurückgegeben</u>.<br></p>Name des Kreditnehmers : %logincompletbeneficiaire%<p></p><p></p><p>%maildestinataire%<br></p>Wenn die Ressource zurückgegeben wurde, gehen Sie zur folgenden Adresse, um den Status der Reservierung zu ändern:<p></p>%urldetail%<p></p><p></p><p><br></p>------<p></p><p>%raisonmail%<br>Wenn\r\n sie diese automatische Nachricht nicht mehr erhalten wollen, wenden Sie\r\n sich bitte an Ihren GRR-Systemverwalter : %webmasteremail%</p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_retardrestitution_en-gb', 'GRR : notice %ressource% - %resadatedebut% - Notifying a delay', '<p>%nometablissement% -&nbsp;Automatic message emitted by GRR site : %urlgrr%</p><p>The resource<b> %ressource%</b> (%domaine%) <u>has not been returned.</u><br></p>Name of the borrower : %logincompletbeneficiaire%<p></p><p></p><p>%maildestinataire%<br></p>Lorsque la ressource aura été restituée, rendez-vous à l\'adresse suivante pour changer le statut de la réservation :<p></p>%urldetail%<p></p><p></p><p><br></p>------<p></p><p>%raisonmail%<br>If you no longer wish to get these automatic mails, write to GRR manager : %webmasteremail%</p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_retardrestitution_es-es', 'GRR : opinión %ressource% - %resadatedebut% - Notificación de retraso', '<p>%nometablissement% -&nbsp;Mensaje automático emitido por el GRR : %urlgrr%</p><p>El recurso<b> %ressource%</b> (%domaine%) <u>no ha sido devuelto</u>.<br></p>Nombre del prestatario : %logincompletbeneficiaire%<p></p><p></p><p>%maildestinataire%<br></p>Cuando el recurso habrá sido restituido, vayase a la dirección siguiente para cambiar el estatuto de la reserva :<p></p>%urldetail%<p></p><p></p><p><br></p>------<p></p><p>%raisonmail%</p><p>Si usted no desea recibir estos mensajes automáticos, escriba al gestor de GRR : %webmasteremail%</p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_retardrestitution_fr-fr', 'GRR : avis %ressource% - %resadatedebut% - Notification de retard', '<p>%nometablissement% - Message automatique émis par le site GRR : %urlgrr%</p><p>La ressource<b> %ressource%</b> (%domaine%) <u>n\'a pas été restituée</u>.<br></p>Nom de l\'emprunteur : %logincompletbeneficiaire%<p></p><p></p><p>%maildestinataire%<br></p>Lorsque la ressource aura été restituée, rendez-vous à l\'adresse suivante pour changer le statut de la réservation :<p></p>%urldetail%<p></p><p></p><p><br></p>------<p></p><p>%raisonmail%<br>Si vous ne souhaitez plus recevoir ces messages automatiques, écrivez en ce sens au gestionnaire de GRR : %webmasteremail%</p><p></p><p></p><p></p><p></p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_retardrestitution_it-it', 'GRR : opinione %ressource% - %resadatedebut% - Notifica di ritardo', '<p>%nometablissement% -&nbsp;Messaggio automatico emesso dal sito GRR : %urlgrr%</p><p>La risorsa<b> %ressource%</b> (%domaine%) <u>non è stato restituito</u>.<br></p>Nome del mutuatario : %logincompletbeneficiaire%<p></p><p></p><p>%maildestinataire%<br></p>Quando la risorsa è stata restituita, vai al seguente indirizzo per modificare lo stato della prenotazione :<p></p>%urldetail%<p></p><p></p><p><br></p>------<p></p><p>%raisonmail%</p><p>Se non desiderate ricevere più questi messaggi automatici, scrivete in questo senso all\'amministratore di GRR : %webmasteremail%</p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_test_de-de', 'Test seit %urlgrr%', '<p>Willkommen bei <span style=\"background-color: rgb(255, 255, 0);\">%nomdusite%</span> von %nometablissement%<br></p>Diese E-Mail <b>validiert </b>die Konfiguration Ihres Mailservers.<p></p><p></p><p><br></p>E-Mail von der Verwaltung Ihres GRR.<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_test_en-gb', 'Test since %urlgrr%', '<p>Welcome to <span style=\"background-color: rgb(255, 255, 0);\">%nomdusite%</span>&nbsp; of %nometablissement%<br></p>This email <b>validates</b> the configuration of your mail server.<p></p><p><br></p><p></p><p></p><p></p>Mail sent from the administration of your GRR.<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_test_es-es', 'Después de la prueba %urlgrr%', '<p>Bienvenido a <span style=\"background-color: rgb(255, 255, 0);\"><font style=\"background-color: rgb(255, 255, 0);\" color=\"#000000\"></font>%nomdusite%</span> de %nometablissement%<br></p>Este correo electrónico <b>valida </b>la configuración de su servidor de correo.\r\n\r\n\r\n<p></p><p></p><p><br></p>Correo enviado desde la administración de su GRR.<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_test_fr-fr', 'Test depuis %urlgrr%', '<p>Bienvenue sur <span style=\"background-color: rgb(255, 255, 0);\"><font style=\"background-color: rgb(255, 255, 0);\" color=\"#000000\"></font>%nomdusite%</span> de %nometablissement%<br></p>Ce mail <b>valide </b>la configuration de votre serveur de mail.<p></p><p></p><p><br></p><p>Mail envoyé depuis l\'administration de votre GRR.<br><br></p><p></p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_test_it-it', 'Prueba desde %urlgrr%', '<p>Benvenuto in <span style=\"background-color: rgb(255, 255, 0);\">%nomdusite%</span>&nbsp; di %nometablissement%<br></p>Questa e-mail <b>convalida</b> la configurazione del tuo server di posta.<p></p><p><br></p><p></p><p></p><p></p>Mail inviata dall\'amministrazione del tuo GRR.<p></p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_demandecompte2_de-de', '[Ergebnis] Anfrage zur Kontoerstellung', '<p>Guten Morgen<br>Ihre Anfrage zur Erstellung eines Kontos auf %urlgrr% wurde angenommen.</p><p><br>Sie können sich jetzt unten mit Ihrem Benutzernamen anmelden.<br>Bezeichner: %identifiant%<br>Passwort: Das Passwort, das Sie bei Ihrer Anfrage angegeben haben.</p><p><br></p><p>---</p><p><span class=\"HwtZe\" lang=\"de\"><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\">Bitte antworten Sie nicht auf diese Email.</span></span></span></p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_demandecompte2_en-gb', '[Result] Account creation request %formnom% %formprenom%', '<p><span class=\"HwtZe\" lang=\"en\"><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\">Good morning,<br></span></span><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\">Your request to create an account on %urlgrr% has been accepted.<br></span></span><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\">You can now log in with your username below.<br></span></span><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\">Identifier: %identifiant%<br></span></span><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\">Password: The one you provided during your request.</span></span></span></p><p><span class=\"HwtZe\" lang=\"en\"><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\"><br></span></span></span></p><p><span class=\"HwtZe\" lang=\"en\"><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\">---</span></span></span></p><p><span class=\"HwtZe\" lang=\"en\"><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\">Please do not reply to this email.</span></span></span></p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_demandecompte2_es-es', '[Resultado] Solicitud de creación de cuenta', '<p>Buenos dias<br>Su solicitud para crear una cuenta en %urlgrr% ha sido aceptada.<br>Ahora puede iniciar sesión con su nombre de usuario a continuación.<br>Identificador: %identifiant%<br>Contraseña: La que usted proporcionó durante su solicitud.</p><p><br></p><p>---</p><p><span class=\"HwtZe\" lang=\"es\"><span class=\"jCAhz\"><span class=\"ryNqvb\">\r\n</span></span><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\">Por favor no responder a este email.</span></span></span></p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_demandecompte2_fr-fr', '[Résultat] Demande de création de compte %formnom% %formprenom%', '<p>Bonjour,</p><p>Votre demande création de compte sur&nbsp;%urlgrr% a été acceptée.<br>Vous pouvez désormais vous connecter avec votre identifiant ci-dessous.<br>Identifiant : %identifiant%<br>Mot de passe : Celui que vous avez renseigné lors de votre demande.</p><p><br></p><p>---</p>Veuillez ne pas répondre à ce mail.<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_demandecompte2_it-it', '[Risultato]  Richiesta di creazione dell\'account', '<p>Buongiorno<br>La tua richiesta di creare un account su %urlgrr% è stata accettata.<br>Ora puoi accedere con il tuo nome utente qui sotto.<br>Identificatore: %identifiant%<br>Password: quella che hai fornito durante la richiesta.</p><p><br></p><p>---</p><p><span class=\"HwtZe\" lang=\"it\"><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\">Per favore non rispondere a questa email.</span></span></span></p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_demandecompte3_de-de', '[Ergebnis] Anfrage zur Kontoerstellung', '<p>Guten Morgen,<br>Ihre Anfrage, ein Konto bei %urlgrr% zu erstellen, wurde abgelehnt.</p><p><br></p><p>---</p><p><span class=\"HwtZe\" lang=\"de\"><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\">Bitte antworten Sie nicht auf diese Email.</span></span></span></p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_demandecompte3_en-gb', '[Result] Account creation request %formnom% %formprenom%', '<p><span class=\"HwtZe\" lang=\"en\"><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\">Good morning,<br></span></span><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\">Your request to create an account on %urlgrr% has been refused.</span></span></span></p><p><span class=\"HwtZe\" lang=\"en\"><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\"><br></span></span></span></p><p><span class=\"HwtZe\" lang=\"en\"><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\">---</span></span></span></p><p><span class=\"HwtZe\" lang=\"en\"><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\">Please do not reply to this email.</span></span></span></p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_demandecompte3_es-es', '[Resultado] Solicitud de creación de cuenta', '<p>Buenos dias,<br>Su solicitud para crear una cuenta en %urlgrr% ha sido rechazada.</p><p><br></p><p>---</p><p><span class=\"HwtZe\" lang=\"es\"><span class=\"jCAhz\"><span class=\"ryNqvb\">\r\n</span></span><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\">Por favor no responder a este email.</span></span></span></p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_demandecompte3_fr-fr', '[Résultat] Demande de création de compte %formnom% %formprenom%', '<p>Bonjour,</p><p>Votre demande création de compte sur&nbsp;%urlgrr% a été refusée.</p><p>---</p>Veuillez ne pas répondre à ce mail.<p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_demandecompte3_it-it', '[Risultato]  Richiesta di creazione dell\'account', '<p>Buongiorno,<br>La tua richiesta di creare un account su %urlgrr% è stata rifiutata.</p><p><br></p><p>---</p><p><span class=\"HwtZe\" lang=\"it\"><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\">Per favore non rispondere a questa email.</span></span></span></p><p></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_demandecompte_de-de', 'Anfrage zur Kontoerstellung', '<p>%nometablissement% - Automatische Nachricht von der GRR Webseite : %urlgrr%</p><p><br></p><p>Anfrage zur Kontoerstellung für: %formnom% %formprenom%<br>E-Mail: %formemail%<br>Telefon: %formtelephone%<br>Kommentar: %formcommentaire%</p><p><br></p><p>---</p><p><span class=\"HwtZe\" lang=\"de\"><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\">Bitte antworten Sie nicht auf diese Email.</span></span></span></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_demandecompte_en-gb', 'Account creation request %formnom% %formprenom%', '<p>%nometablissement% - Automatic message emitted by GRR site : %urlgrr%</p><p><span class=\"HwtZe\" lang=\"en\"><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\">Account creation request for: %formnom% %formprenom%<br></span></span><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\">Email: %formemail%<br></span></span><span class=\"jCAhz\"><span class=\"ryNqvb\">\r\n</span></span><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\">Telephone: %formtelephone%<br></span></span><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\">Comment: %formcommentaire%</span></span></span></p><p><span class=\"HwtZe\" lang=\"en\"><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\"><br></span></span></span></p><p><span class=\"HwtZe\" lang=\"en\"><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\">---</span></span></span></p><p><span class=\"HwtZe\" lang=\"en\"><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\">Please do not reply to this email.</span></span></span></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_demandecompte_es-es', 'Solicitud de creación de cuenta', '<p>%nometablissement% - Mensaje automático emitido por el GRR : %urlgrr%</p><p><br></p><p>Solicitud de creación de cuenta para: %formnom% %formprenom%<br>Correo electrónico: %formemail%<br>Teléfono: %formtelephone%<br>Comentario: %formcommentaire%</p><p><br></p><p>---</p><p><span class=\"HwtZe\" lang=\"es\"><span class=\"jCAhz\"><span class=\"ryNqvb\">\r\n</span></span><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\">Por favor no responder a este email.</span></span></span></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_demandecompte_fr-fr', 'Demande de création de compte %formnom% %formprenom%', '<p>%nometablissement% - Message automatique émis par le site GRR : %urlgrr%</p><p>Demande de création de compte pour : %formnom% %formprenom%<br>Email : %formemail%<br>Téléphone : %formtelephone%<br>Commentaire : %formcommentaire%</p><p><br></p><p>---</p><p>Veuillez ne pas répondre à ce mail.<br></p>', 1,'','',0,0,0);
INSERT INTO grr_page VALUES('mails_demandecompte_it-it', 'Richiesta di creazione dell\'account', '<p>%nometablissement% - Messaggio automatico emesso dal sito GRR : %urlgrr%</p><p><br></p><p>Richiesta di creazione account per: %formnom% %formprenom%<br>E-mail: %formemail%<br>Telefono: %formtelephone%<br>Commento: %formcommentaire%</p><br><p>---</p><p><span class=\"HwtZe\" lang=\"it\"><span class=\"jCAhz ChMk0b\"><span class=\"ryNqvb\">Per favore non rispondere a questa email.</span></span></span></p>', 1,'','',0,0,0);