<?php

/**

* @package   copix

* @subpackage SmartyPlugins

* @version   $Id: modifier.substrpos.php,v 1.1 2007-03-23 16:22:01 cbeyer Exp $

* @author   Christophe Beyer

* @copyright 2007 CAP-TIC

* @link      http://www.cap-tic.fr

* @licence  http://www.gnu.org/licenses/lgpl.html GNU Lesser General Public Licence, see LICENCE file

*/


/**

 * Plugin smarty type modifier
 * Purpose: A partir d'une chaine de caractres (typiquement une URL), en extrait la fin, en commenant  la dernire occurence d'un caractre (par dfaut le slash).
 * Input: Chaine de caractres (URL ou autre)
 * Output: Chaine de caractres.
 * Example:  {$text|substrpos} {$text|substrpos:/}
 * @return string
 */

function smarty_modifier_substrpos ($string, $char="/")
{
    $txt = $string;
    $pos = strrpos($string, $char);
    if ($pos !== false) {
      $txt = substr($string,$pos+1);
    }
    return $txt;
}

