-- example de création d'une base de données MySQL
-- création de la base de donnée
CREATE DATABASE iconito CHARACTER SET utf8 COLLATE utf8_general_ci;

-- création du user de la base
grant all privileges on iconito.* to iconito@%%adresse_ip_web identified by 'iconito';
flush privileges ;

-- connexion à la base
\r iconito

-- phpMyAdmin SQL Dump
-- version 3.3.2deb1ubuntu1
-- http://www.phpmyadmin.net
--
-- Serveur: 127.0.0.1
-- Généré le : Jeu 28 Novembre 2013 à 16:09
-- Version du serveur: 5.1.72
-- Version de PHP: 5.3.2-1ubuntu4.21

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Base de données: `iconito`
--

-- --------------------------------------------------------

--
-- Structure de la table `copixconfig`
--

CREATE TABLE IF NOT EXISTS `copixconfig` (
  `id_ccfg` varchar(255) NOT NULL DEFAULT '',
  `module_ccfg` varchar(255) NOT NULL DEFAULT '',
  `value_ccfg` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id_ccfg`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Contenu de la table `copixconfig`
--

INSERT INTO `copixconfig` (`id_ccfg`, `module_ccfg`, `value_ccfg`) VALUES
('admin|defaultThemeId', 'admin|', 'default'),
('default|homePage', 'default|', 'index.php/kernel'),
('default|titlePage', 'default|', 'Iconito'),
('default|titleBar', 'default|', '{$TITLE_PAGE} - Iconito'),
('default|mailEnabled', 'default|', '1'),
('default|mailLogging', 'default|', '0'),
%if %%is_defined('domaine_messagerie_etab')
('default|mailFrom', 'default|', 'admin@%%domaine_messagerie_etab'),
%else
('default|mailFrom', 'default|', '%%system_mail_to'),
%end if
('default|mailFromName', 'default|', 'Alerte Iconito'),
('default|mailAlwaysBcc', 'default|', ''),
('default|mailMethod', 'default|', 'smtp'),
%if %%is_defined('passerelle_smtp')
('default|mailSmtpHost', 'default|', '%%passerelle_smtp'),
%else
%if %%is_defined('activer_exim_relay_smtp') and %%activer_exim_relay_smtp == 'oui'
('default|mailSmtpHost', 'default|', '%%exim_relay_smtp'),
%else
('default|mailSmtpHost', 'default|', ''),
%end if
%end if
('default|mailSmtpAuth', 'default|', ''),
('default|mailSmtpPass', 'default|', ''),
('default|mailSmtpPort', 'default|', ''),
('default|proxyEnabled', 'default|', '0'),
('default|proxyHost', 'default|', ''),
('default|proxyPort', 'default|', ''),
('default|proxyUser', 'default|', ''),
('default|proxyPass', 'default|', ''),
('default|webservicesInterface', 'default|', ''),
('default|isDemo', 'default|', '0'),
('default|urlGael', 'default|', ''),
('default|conf_DirClasse', 'default|', '0'),
('default|conf_ModTeleprocedures', 'default|', '1'),
('default|conf_ModSso', 'default|', '0'),
('default|statsEnabled', 'default|', '1'),
('default|conf_ModConcerto', 'default|', '0'),
('default|conf_assistance_default', 'default|', '0'),
('default|conf_assistance_ien_default', 'default|', '0'),
('default|conf_ModVisio', 'default|', '0'),
('default|conf_ModVisio_url', 'default|', ''),
('default|conf_Cas_actif', 'default|', '0'),
('default|conf_Cas_host', 'default|', ''),
('default|conf_Cas_port', 'default|', ''),
('default|conf_Cas_path', 'default|', ''),
('default|conf_Ceriseprim_actif', 'default|', '0'),
('default|conf_Ceriseprim_url', 'default|', ''),
('default|conf_Ceriseprim_secret', 'default|', ''),
('default|conf_ModClasseur_options', 'default|', '0'),
('default|conf_ModClasseur_upload', 'default|', '0'),
('default|rssEtagereEnabled', 'default|', '0'),
('default|conf_Edito_type', 'default|', ''),
('default|conf_Edito_id', 'default|', ''),
('default|can_group_createpublic', 'default|', '1'),
('default|can_group_showlist', 'default|', '1'),
('default|can_public_rssfeed', 'default|', '1'),
('default|can_annuaire_menu', 'default|', '1'),
('default|can_pref_assistance_animtice', 'default|', '1'),
('default|can_pref_assistance_ien', 'default|', '1'),
('default|can_pref_assistance', 'default|', '1'),
('default|can_module_ressources', 'default|', '1'),
('default|can_module_rssfeed', 'default|', '1'),
('default|notification_maxnodes', 'default|', '30'),
('kernel|jeuEssaiInstalled', 'kernel|', '0'),
('kernel|gestionAutonomeEnabled', 'kernel|', '1'),
('kernel|groupeAssistance', 'kernel|', '0'),
('kernel|carnetDeLiaison', 'kernel|', '0'),
('kernel|defaultVocabularyCatalog', 'kernel|', '1'),
('auth|createUser', 'auth|', '0'),
('auth|typeConfirm', 'auth|', 'email'),
('auth|multipleConnectionHandler', 'auth|', '1'),
('auth|timetolive', 'auth|', '2678400'),
('auth|cryptPassword', 'auth|', 'md5'),
('auth|authorizeRedirectIfOK', 'auth|', '1'),
('auth|authorizeRedirectIfNoK', 'auth|', '1'),
('teleprocedures|statutNouveau', 'teleprocedures|', '1'),
('teleprocedures|default_format', 'teleprocedures|', 'ckeditor'),
('teleprocedures|formats_types', 'teleprocedures|', 'wiki,dokuwiki,html,fckeditor,ckeditor'),
('teleprocedures|USER_ADM_as_USER_ENS', 'teleprocedures|', '0'),
('rssnotifier|rss_url', 'rssnotifier|', 'http://feeds.feedburner.com/viedemerde'),
('rssnotifier|rss_type', 'rssnotifier|', 'Atom'),
('rssnotifier|enable', 'rssnotifier|', 'false'),
('rssmix|enable', 'rssmix|', 'false'),
('rssmix|itemsLimit', 'rssmix|', '20');

-- --------------------------------------------------------

--
-- Structure de la table `copixlog`
--

CREATE TABLE IF NOT EXISTS `copixlog` (
  `date` varchar(255) NOT NULL DEFAULT '',
  `profile` varchar(255) NOT NULL DEFAULT '',
  `message` text NOT NULL,
  `level` varchar(255) NOT NULL DEFAULT '',
  `user` varchar(255) DEFAULT NULL,
  `classname` varchar(255) DEFAULT NULL,
  `functionname` varchar(255) DEFAULT NULL,
  `line` varchar(5) DEFAULT NULL,
  `file` varchar(255) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Contenu de la table `copixlog`
--


-- --------------------------------------------------------

--
-- Structure de la table `copixmodule`
--

CREATE TABLE IF NOT EXISTS `copixmodule` (
  `name_cpm` varchar(255) NOT NULL DEFAULT '',
  `path_cpm` varchar(255) NOT NULL DEFAULT '',
  `version_cpm` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`name_cpm`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Contenu de la table `copixmodule`
--

INSERT INTO `copixmodule` (`name_cpm`, `path_cpm`, `version_cpm`) VALUES
('admin', 'project/modules/public/stable/standard/', '0'),
('auth', 'project/modules/public/stable/standard/', '0'),
('default', 'project/modules/public/stable/standard/', '0'),
('generictools', 'project/modules/public/stable/standard/', '0'),
('gestionautonome', 'project/modules/public/stable/iconito/gestionautonome', '0');

-- --------------------------------------------------------

--
-- Structure de la table `dbgroup`
--

CREATE TABLE IF NOT EXISTS `dbgroup` (
  `id_dbgroup` int(11) NOT NULL AUTO_INCREMENT,
  `caption_dbgroup` varchar(255) NOT NULL,
  `description_dbgroup` text,
  `superadmin_dbgroup` tinyint(4) NOT NULL,
  `public_dbgroup` tinyint(4) NOT NULL,
  `registered_dbgroup` tinyint(4) NOT NULL,
  PRIMARY KEY (`id_dbgroup`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

--
-- Contenu de la table `dbgroup`
--

INSERT INTO `dbgroup` (`id_dbgroup`, `caption_dbgroup`, `description_dbgroup`, `superadmin_dbgroup`, `public_dbgroup`, `registered_dbgroup`) VALUES
(1, 'Admin', 'Groupe administrateur', 1, 0, 0),
(2, 'current_user', 'Utilisation classique de l''application', 0, 0, 1),
(3, 'cities_group_agent', NULL, 0, 0, 0),
(4, 'city_agent', NULL, 0, 0, 0),
(5, 'administration_staff', NULL, 0, 0, 0),
(6, 'principal', NULL, 0, 0, 0),
(7, 'teacher', NULL, 0, 0, 0),
(8, 'cities_group_animator', NULL, 0, 0, 0),
(9, 'schools_group_animator', NULL, 0, 0, 0),
(10, 'teacher_school', NULL, 0, 0, 0);

-- --------------------------------------------------------

--
-- Structure de la table `dbgroup_users`
--

CREATE TABLE IF NOT EXISTS `dbgroup_users` (
  `id_dbgroup` int(11) NOT NULL,
  `userhandler_dbgroup` varchar(255) NOT NULL,
  `user_dbgroup` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Contenu de la table `dbgroup_users`
--

INSERT INTO `dbgroup_users` (`id_dbgroup`, `userhandler_dbgroup`, `user_dbgroup`) VALUES
(1, 'auth|dbuserhandler', '1');

-- --------------------------------------------------------

--
-- Structure de la table `dbuser`
--

CREATE TABLE IF NOT EXISTS `dbuser` (
  `id_dbuser` int(11) NOT NULL AUTO_INCREMENT,
  `login_dbuser` varchar(32) NOT NULL,
  `password_dbuser` varchar(32) NOT NULL,
  `email_dbuser` varchar(255) NOT NULL,
  `enabled_dbuser` tinyint(4) NOT NULL,
  PRIMARY KEY (`id_dbuser`),
  UNIQUE KEY `login` (`login_dbuser`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Contenu de la table `dbuser`
--

INSERT INTO `dbuser` (`id_dbuser`, `login_dbuser`, `password_dbuser`, `email_dbuser`, `enabled_dbuser`) VALUES
(1, 'admin', '922c6e7d71c38d433563a8493ebd8cf0', '', 1);

-- --------------------------------------------------------

--
-- Structure de la table `dynamiccredentials`
--

CREATE TABLE IF NOT EXISTS `dynamiccredentials` (
  `id_dc` int(11) NOT NULL AUTO_INCREMENT,
  `name_dc` varchar(255) NOT NULL,
  PRIMARY KEY (`id_dc`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `dynamiccredentials`
--


-- --------------------------------------------------------

--
-- Structure de la table `dynamiccredentialsgroups`
--

CREATE TABLE IF NOT EXISTS `dynamiccredentialsgroups` (
  `id_dcg` int(11) NOT NULL AUTO_INCREMENT,
  `id_dc` int(11) NOT NULL,
  `id_dcv` int(11) DEFAULT NULL,
  `handler_group` varchar(255) DEFAULT NULL,
  `id_group` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id_dcg`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `dynamiccredentialsgroups`
--


-- --------------------------------------------------------

--
-- Structure de la table `dynamiccredentialsvalues`
--

CREATE TABLE IF NOT EXISTS `dynamiccredentialsvalues` (
  `id_dcv` int(11) NOT NULL AUTO_INCREMENT,
  `value_dcv` varchar(255) NOT NULL,
  `id_dc` int(11) NOT NULL,
  `level_dcv` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_dcv`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `dynamiccredentialsvalues`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_animateurs`
--

CREATE TABLE IF NOT EXISTS `kernel_animateurs` (
  `user_type` varchar(10) NOT NULL,
  `user_id` int(11) NOT NULL,
  `can_connect` tinyint(4) NOT NULL,
  `can_tableaubord` tinyint(4) NOT NULL,
  `can_comptes` tinyint(4) NOT NULL,
  `is_visibleannuaire` tinyint(4) NOT NULL,
  `updated_at` datetime NOT NULL,
  `updated_by` varchar(50) NOT NULL,
  PRIMARY KEY (`user_type`,`user_id`),
  KEY `is_visibleannuaire` (`is_visibleannuaire`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `kernel_animateurs`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_animateurs2regroupements`
--

CREATE TABLE IF NOT EXISTS `kernel_animateurs2regroupements` (
  `user_type` varchar(10) NOT NULL,
  `user_id` int(11) NOT NULL,
  `regroupement_type` enum('villes','ecoles') NOT NULL,
  `regroupement_id` int(11) NOT NULL,
  PRIMARY KEY (`user_type`,`user_id`,`regroupement_type`,`regroupement_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `kernel_animateurs2regroupements`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_annee_scolaire`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_annee_scolaire` (
  `id_as` int(11) NOT NULL DEFAULT '0',
  `annee_scolaire` varchar(10) NOT NULL DEFAULT '',
  `dateDebut` date NOT NULL DEFAULT '0000-00-00',
  `dateFin` date NOT NULL DEFAULT '0000-00-00',
  `current` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_as`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `kernel_bu_annee_scolaire`
--

INSERT INTO `kernel_bu_annee_scolaire` (`id_as`, `annee_scolaire`, `dateDebut`, `dateFin`, `current`) VALUES
(2011, '2011-2012', '2011-09-05', '2012-07-05', 1);

-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_auth`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_auth` (
  `node_type` varchar(15) NOT NULL,
  `node_id` int(11) NOT NULL,
  `service` varchar(15) NOT NULL,
  `login` varchar(40) NOT NULL,
  `password` varchar(40) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `kernel_bu_auth`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_civilite`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_civilite` (
  `id_civ` tinyint(4) NOT NULL AUTO_INCREMENT,
  `civilite` varchar(15) NOT NULL DEFAULT '',
  `civ_court` varchar(5) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_civ`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `kernel_bu_civilite`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_classe_niveau`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_classe_niveau` (
  `id_n` tinyint(4) NOT NULL AUTO_INCREMENT,
  `niveau` varchar(30) NOT NULL DEFAULT '',
  `id_cycle` tinyint(4) NOT NULL DEFAULT '0',
  `niveau_court` varchar(4) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_n`),
  KEY `id_cycle` (`id_cycle`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=10 ;

--
-- Contenu de la table `kernel_bu_classe_niveau`
--

INSERT INTO `kernel_bu_classe_niveau` (`id_n`, `niveau`, `id_cycle`, `niveau_court`) VALUES
(1, 'Toute petite section', 1, 'TPS'),
(2, 'Petite section', 1, 'PS'),
(3, 'Moyenne section', 1, 'MS'),
(4, 'Grande section', 1, 'GS'),
(5, 'Cours préparatoire', 2, 'CP'),
(6, 'Cours élémentaire 1er année', 2, 'CE1'),
(7, 'Cours élémentaire 2ème année', 3, 'CE2'),
(8, 'Cours moyen 1er année', 3, 'CM1'),
(9, 'Cours moyen 2ème année', 3, 'CM2');

-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_classe_type`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_classe_type` (
  `id_tycla` tinyint(4) NOT NULL AUTO_INCREMENT,
  `type_classe` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_tycla`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=34 ;

--
-- Contenu de la table `kernel_bu_classe_type`
--

INSERT INTO `kernel_bu_classe_type` (`id_tycla`, `type_classe`) VALUES
(11, 'Ordinaire'),
(12, 'CLAD'),
(13, 'CLIS'),
(31, 'CLIN'),
(24, 'Groupe d''enseignement'),
(32, 'Regroupement d''adaptation'),
(33, 'Autre');

-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_cycle`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_cycle` (
  `id_c` tinyint(4) NOT NULL AUTO_INCREMENT,
  `cycle` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_c`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=4 ;

--
-- Contenu de la table `kernel_bu_cycle`
--

INSERT INTO `kernel_bu_cycle` (`id_c`, `cycle`) VALUES
(1, 'Maternelle'),
(2, 'Cycle 2'),
(3, 'Cycle 3');

-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_ecole`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_ecole` (
  `numero` int(11) NOT NULL AUTO_INCREMENT,
  `RNE` varchar(10) DEFAULT NULL,
  `siret` varchar(255) DEFAULT NULL,
  `code_ecole_vaccination` varchar(15) DEFAULT NULL,
  `type` varchar(32) DEFAULT 'Primaire',
  `nom` varchar(50) NOT NULL,
  `num_rue` varchar(5) DEFAULT NULL,
  `num_seq` varchar(10) DEFAULT NULL,
  `adresse1` varchar(100) DEFAULT NULL,
  `adresse2` varchar(100) DEFAULT NULL,
  `code_postal` varchar(8) DEFAULT NULL,
  `commune` varchar(100) DEFAULT NULL,
  `tel` varchar(15) DEFAULT NULL,
  `web` varchar(80) DEFAULT NULL,
  `mail` varchar(80) DEFAULT NULL,
  `num_intranet` int(11) DEFAULT NULL,
  `numordre` int(11) DEFAULT '0',
  `num_plan_interactif` int(11) DEFAULT '0',
  `id_ville` int(11) DEFAULT '0',
  PRIMARY KEY (`numero`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 PACK_KEYS=0 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `kernel_bu_ecole`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_ecole_classe`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_ecole_classe` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ecole` int(11) NOT NULL DEFAULT '0',
  `nom` varchar(50) NOT NULL DEFAULT '',
  `annee_scol` int(11) NOT NULL DEFAULT '0',
  `is_validee` tinyint(1) NOT NULL DEFAULT '0',
  `is_supprimee` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ecole` (`ecole`),
  KEY `is_validee` (`is_validee`),
  KEY `is_supprimee` (`is_supprimee`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `kernel_bu_ecole_classe`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_ecole_classe_niveau`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_ecole_classe_niveau` (
  `classe` int(11) NOT NULL DEFAULT '0',
  `niveau` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`classe`,`niveau`),
  KEY `type` (`type`),
  KEY `classe` (`classe`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `kernel_bu_ecole_classe_niveau`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_eleve`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_eleve` (
  `idEleve` int(11) NOT NULL AUTO_INCREMENT,
  `numero` varchar(22) DEFAULT NULL,
  `INE` varchar(20) DEFAULT NULL,
  `nom` varchar(50) NOT NULL,
  `nom_jf` varchar(50) DEFAULT NULL,
  `prenom1` varchar(50) NOT NULL,
  `prenom2` varchar(50) DEFAULT NULL,
  `prenom3` varchar(50) DEFAULT NULL,
  `civilite` varchar(15) DEFAULT NULL,
  `id_sexe` int(11) DEFAULT '0',
  `pays_nais` varchar(50) DEFAULT NULL,
  `nationalite` int(11) DEFAULT NULL,
  `dep_nais` varchar(10) DEFAULT NULL,
  `com_nais` varchar(100) DEFAULT NULL,
  `date_nais` date DEFAULT NULL,
  `annee_france` int(11) DEFAULT NULL,
  `num_rue` varchar(5) DEFAULT NULL,
  `num_seq` varchar(10) DEFAULT NULL,
  `adresse1` varchar(100) DEFAULT NULL,
  `adresse2` varchar(100) DEFAULT NULL,
  `code_postal` varchar(8) DEFAULT NULL,
  `commune` varchar(100) DEFAULT NULL,
  `id_ville` int(11) DEFAULT '0',
  `pays` int(11) DEFAULT '1',
  `hors_scol` tinyint(4) DEFAULT '0',
  `id_directeur` varchar(10) DEFAULT NULL,
  `observations` varchar(255) DEFAULT NULL,
  `flag` int(11) NOT NULL DEFAULT '0',
  `adresse_tmp` varchar(150) DEFAULT NULL,
  `date_tmp` datetime DEFAULT NULL,
  `ele_last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idEleve`),
  KEY `id_directeur` (`id_directeur`),
  KEY `civilite` (`civilite`),
  KEY `id_sexe` (`id_sexe`),
  KEY `pays_nais` (`pays_nais`),
  KEY `nationalite` (`nationalite`),
  KEY `date_nais` (`date_nais`),
  KEY `adresse1` (`adresse1`),
  KEY `commune` (`commune`),
  KEY `flag` (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `kernel_bu_eleve`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_eleve_admission`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_eleve_admission` (
  `numero` int(11) NOT NULL AUTO_INCREMENT,
  `eleve` int(11) NOT NULL DEFAULT '0',
  `etablissement` int(11) NOT NULL DEFAULT '0',
  `annee_scol` int(11) NOT NULL DEFAULT '0',
  `id_niveau` int(11) NOT NULL DEFAULT '0',
  `etat_eleve` int(11) NOT NULL DEFAULT '0',
  `date` date NOT NULL DEFAULT '0000-00-00',
  `date_effet` date NOT NULL DEFAULT '0000-00-00',
  `code_radiation` int(11) NOT NULL DEFAULT '0',
  `previsionnel` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`numero`),
  KEY `eleve` (`eleve`),
  KEY `etablissement` (`etablissement`),
  KEY `annee_scol` (`annee_scol`),
  KEY `etat_eleve` (`etat_eleve`),
  KEY `code_radiation` (`code_radiation`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `kernel_bu_eleve_admission`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_eleve_affectation`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_eleve_affectation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `eleve` int(11) NOT NULL DEFAULT '0',
  `annee_scol` int(11) NOT NULL DEFAULT '0',
  `classe` int(11) NOT NULL DEFAULT '0',
  `niveau` int(11) NOT NULL DEFAULT '0',
  `dateDebut` date NOT NULL DEFAULT '0000-00-00',
  `current` tinyint(4) NOT NULL DEFAULT '1',
  `previsionnel_cl` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `eleve` (`eleve`),
  KEY `annee_scol` (`annee_scol`),
  KEY `classe` (`classe`),
  KEY `niveau` (`niveau`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `kernel_bu_eleve_affectation`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_eleve_classe_mvt`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_eleve_classe_mvt` (
  `id_eleve` int(11) NOT NULL DEFAULT '0',
  `id_ecole_ini` int(11) NOT NULL DEFAULT '0',
  `id_classe_ini` int(11) NOT NULL DEFAULT '0',
  `id_niveau_ini` tinyint(4) NOT NULL DEFAULT '0',
  `id_classe_next` int(11) DEFAULT NULL,
  `id_niveau_next` tinyint(4) DEFAULT NULL,
  `code_radiation` int(11) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `kernel_bu_eleve_classe_mvt`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_eleve_etat`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_eleve_etat` (
  `id_ee` int(11) NOT NULL AUTO_INCREMENT,
  `lib_etat` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_ee`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `kernel_bu_eleve_etat`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_eleve_inscription`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_eleve_inscription` (
  `numero` int(11) NOT NULL AUTO_INCREMENT,
  `eleve` int(11) NOT NULL DEFAULT '0',
  `annee_scol` int(11) NOT NULL DEFAULT '0',
  `date_preinscript` date NOT NULL DEFAULT '0000-00-00',
  `date_effet_preinscript` date NOT NULL DEFAULT '0000-00-00',
  `date_inscript` date NOT NULL DEFAULT '0000-00-00',
  `date_effet_inscript` date NOT NULL DEFAULT '0000-00-00',
  `etablissement` int(11) DEFAULT '0',
  `etablissement_refus` int(11) NOT NULL DEFAULT '0',
  `id_niveau` tinyint(4) NOT NULL DEFAULT '0',
  `id_typ_cla` tinyint(4) NOT NULL DEFAULT '11',
  `vaccins_aj` tinyint(4) NOT NULL DEFAULT '0',
  `attente` tinyint(4) NOT NULL DEFAULT '0',
  `date_attente` date DEFAULT NULL,
  `derogation_dem` tinyint(4) NOT NULL DEFAULT '0',
  `derogation_accept` tinyint(4) DEFAULT NULL,
  `derogation_date_dem` date DEFAULT NULL,
  `derogation_date_accept` date DEFAULT NULL,
  `derogation_maire` tinyint(4) DEFAULT NULL,
  `derogation_commune` varchar(50) DEFAULT NULL,
  `temporaire` tinyint(4) NOT NULL DEFAULT '0',
  `date_vac_limit` date DEFAULT NULL,
  `current_inscr` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`numero`),
  KEY `eleve` (`eleve`),
  KEY `annee_scol` (`annee_scol`),
  KEY `etablissement` (`etablissement`),
  KEY `id_niveau` (`id_niveau`),
  KEY `id_typ_cla` (`id_typ_cla`),
  KEY `vaccins_aj` (`vaccins_aj`),
  KEY `temporaire` (`temporaire`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `kernel_bu_eleve_inscription`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_eleve_periscolaire`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_eleve_periscolaire` (
  `id_ps` int(11) NOT NULL AUTO_INCREMENT,
  `eleve` int(11) NOT NULL DEFAULT '0',
  `etablissement` int(11) NOT NULL DEFAULT '0',
  `annee_scol` int(11) NOT NULL DEFAULT '0',
  `garderie_matin` tinyint(4) NOT NULL DEFAULT '0',
  `garderie_soir` tinyint(4) NOT NULL DEFAULT '0',
  `etude_surv` tinyint(4) NOT NULL DEFAULT '0',
  `resto_scol` tinyint(4) NOT NULL DEFAULT '0',
  `transp_scol` tinyint(4) NOT NULL DEFAULT '0',
  `allergies_alim` tinyint(4) NOT NULL DEFAULT '0',
  `allergies_autres` tinyint(4) NOT NULL DEFAULT '0',
  `a_regimes` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_ps`),
  KEY `eleve` (`eleve`),
  KEY `etablissement` (`etablissement`),
  KEY `annee_scol` (`annee_scol`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `kernel_bu_eleve_periscolaire`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_eleve_vaccins`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_eleve_vaccins` (
  `eleve` int(11) NOT NULL DEFAULT '0',
  `bcg_contre_indic` date NOT NULL DEFAULT '0000-00-00',
  `bcg_injection1` date NOT NULL DEFAULT '0000-00-00',
  `bcg_injection2` date NOT NULL DEFAULT '0000-00-00',
  `bcg_injection3` date NOT NULL DEFAULT '0000-00-00',
  `diphterie_contre_indic` date NOT NULL DEFAULT '0000-00-00',
  `diphterie_type` char(4) NOT NULL DEFAULT '',
  `diphterie_date` date NOT NULL DEFAULT '0000-00-00',
  `diphterie_nature` tinyint(4) NOT NULL DEFAULT '0',
  `diphterie_next` date NOT NULL DEFAULT '0000-00-00',
  `tetanos_contre_indic` date NOT NULL DEFAULT '0000-00-00',
  `tetanos_type` char(4) NOT NULL DEFAULT '',
  `tetanos_date` date NOT NULL DEFAULT '0000-00-00',
  `tetanos_next` date NOT NULL DEFAULT '0000-00-00',
  `polio_contre_indic` date NOT NULL DEFAULT '0000-00-00',
  `polio_type` char(4) NOT NULL DEFAULT '',
  `polio_date` date NOT NULL DEFAULT '0000-00-00',
  `polio_next` date NOT NULL DEFAULT '0000-00-00',
  `coqueluche_contre_indic` date NOT NULL DEFAULT '0000-00-00',
  `coqueluche_type` char(4) NOT NULL DEFAULT '',
  `coqueluche_date` date NOT NULL DEFAULT '0000-00-00',
  `coqueluche_nature` tinyint(4) NOT NULL DEFAULT '0',
  `coqueluche_next` date NOT NULL DEFAULT '0000-00-00',
  `haemophilus_contre_indic` date NOT NULL DEFAULT '0000-00-00',
  `haemophilus_type` char(4) NOT NULL DEFAULT '',
  `haemophilus_date` date NOT NULL DEFAULT '0000-00-00',
  `haemophilus_next` date NOT NULL DEFAULT '0000-00-00',
  `rougeole_inj1` date NOT NULL DEFAULT '0000-00-00',
  `rougeole_inj2` date NOT NULL DEFAULT '0000-00-00',
  `oreillons_inj1` date NOT NULL DEFAULT '0000-00-00',
  `oreillons_inj2` date NOT NULL DEFAULT '0000-00-00',
  `rubeole_inj1` date NOT NULL DEFAULT '0000-00-00',
  `rubeole_inj2` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`eleve`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `kernel_bu_eleve_vaccins`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_geo_departements`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_geo_departements` (
  `C_Reg` char(2) NOT NULL DEFAULT '',
  `C_Dpt` char(3) NOT NULL DEFAULT '',
  `N_Dpt_min` varchar(50) NOT NULL DEFAULT '',
  `N_Dpt_maj` varchar(50) NOT NULL DEFAULT '',
  `C_Chef_lieu` varchar(50) NOT NULL DEFAULT '',
  `N_Chef_lieu_min` varchar(50) NOT NULL DEFAULT '',
  `N_Chef_lieu_maj` varchar(50) NOT NULL DEFAULT '',
  `Arr` tinyint(4) NOT NULL DEFAULT '0',
  `Cant` int(11) NOT NULL DEFAULT '0',
  `Com` int(11) NOT NULL DEFAULT '0',
  `Pop90` int(11) NOT NULL DEFAULT '0',
  `Pop99` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`C_Dpt`),
  KEY `C_Dpt` (`C_Dpt`),
  KEY `C_Reg` (`C_Reg`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `kernel_bu_geo_departements`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_groupe_villes`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_groupe_villes` (
  `id_grv` int(11) NOT NULL AUTO_INCREMENT,
  `nom_groupe` varchar(150) NOT NULL DEFAULT '',
  `date_creation` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_grv`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

--
-- Contenu de la table `kernel_bu_groupe_villes`
--

INSERT INTO `kernel_bu_groupe_villes` (`id_grv`, `nom_groupe`, `date_creation`) VALUES
(1, 'Les villes', '2013-11-28 16:07:01');

-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_lien_parental`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_lien_parental` (
  `id_pa` tinyint(4) NOT NULL AUTO_INCREMENT,
  `parente` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_pa`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=12 ;

--
-- Contenu de la table `kernel_bu_lien_parental`
--

INSERT INTO `kernel_bu_lien_parental` (`id_pa`, `parente`) VALUES
(1, 'Mère'),
(2, 'Père'),
(3, 'Frère'),
(4, 'Soeur'),
(5, 'Grand-père'),
(6, 'Grand-mère'),
(7, 'Oncle'),
(8, 'Tante'),
(9, 'Collatéraux'),
(10, 'Tuteur'),
(11, 'Inconnu');

-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_nationalite`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_nationalite` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nationalite` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `nationalite` (`nationalite`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `kernel_bu_nationalite`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_organisme`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_organisme` (
  `numero` int(11) NOT NULL AUTO_INCREMENT,
  `nom` varchar(50) NOT NULL DEFAULT '',
  `num_rue` varchar(5) NOT NULL DEFAULT '',
  `num_seq` varchar(10) DEFAULT NULL,
  `adresse1` varchar(100) NOT NULL DEFAULT '',
  `adresse2` varchar(100) NOT NULL DEFAULT '',
  `code_postal` varchar(8) NOT NULL DEFAULT '',
  `commune` varchar(100) NOT NULL DEFAULT '',
  `tel` varchar(15) NOT NULL DEFAULT '',
  `web` varchar(80) DEFAULT NULL,
  PRIMARY KEY (`numero`),
  KEY `commune` (`commune`),
  KEY `nom` (`nom`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `kernel_bu_organisme`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_pays`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_pays` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pays` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `nationalite` (`pays`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `kernel_bu_pays`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_pcs`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_pcs` (
  `id_p` int(11) NOT NULL DEFAULT '0',
  `pcs` varchar(80) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_p`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `kernel_bu_pcs`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_personnel`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_personnel` (
  `numero` int(11) NOT NULL AUTO_INCREMENT,
  `nom` varchar(50) NOT NULL,
  `nom_jf` varchar(50) DEFAULT NULL,
  `prenom1` varchar(50) DEFAULT NULL,
  `civilite` varchar(15) DEFAULT NULL,
  `id_sexe` int(11) DEFAULT '0',
  `date_nais` date DEFAULT NULL,
  `cle_privee` varchar(128) DEFAULT NULL,
  `profession` varchar(80) DEFAULT NULL,
  `tel_dom` varchar(15) DEFAULT NULL,
  `tel_gsm` varchar(15) DEFAULT NULL,
  `tel_pro` varchar(15) DEFAULT NULL,
  `mel` varchar(80) DEFAULT NULL,
  `num_rue` varchar(5) DEFAULT NULL,
  `num_seq` varchar(10) DEFAULT NULL,
  `adresse1` varchar(100) DEFAULT NULL,
  `adresse2` varchar(100) DEFAULT NULL,
  `code_postal` varchar(8) DEFAULT NULL,
  `commune` varchar(100) DEFAULT NULL,
  `id_ville` int(11) DEFAULT '0',
  `pays` int(11) DEFAULT '1',
  `challenge` varchar(128) DEFAULT NULL,
  `dateChallenge` int(11) DEFAULT NULL,
  PRIMARY KEY (`numero`),
  KEY `nom` (`nom`),
  KEY `id_sexe` (`id_sexe`),
  KEY `adresse1` (`adresse1`),
  KEY `commune` (`commune`),
  KEY `pays` (`pays`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `kernel_bu_personnel`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_personnel_entite`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_personnel_entite` (
  `id_per` int(11) NOT NULL DEFAULT '0',
  `reference` int(11) NOT NULL DEFAULT '0',
  `type_ref` char(6) NOT NULL DEFAULT '',
  `role` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_per`,`reference`,`type_ref`),
  KEY `id_per` (`id_per`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `kernel_bu_personnel_entite`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_personnel_role`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_personnel_role` (
  `id_role` int(11) NOT NULL AUTO_INCREMENT,
  `nom_role` varchar(80) NOT NULL DEFAULT '',
  `nom_role_pluriel` varchar(80) NOT NULL DEFAULT '',
  `perimetre` varchar(30) NOT NULL DEFAULT '',
  `priorite` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id_role`),
  KEY `nom_role` (`nom_role`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=6 ;

--
-- Contenu de la table `kernel_bu_personnel_role`
--

INSERT INTO `kernel_bu_personnel_role` (`id_role`, `nom_role`, `nom_role_pluriel`, `perimetre`, `priorite`) VALUES
(1, 'Enseignant', 'Enseignants', 'ECOLE|CLASSE', 2),
(2, 'Directeur', 'Directeurs', 'ECOLE|CLASSE', 1),
(3, 'Personnel administratif', 'Personnels administratif', 'ECOLE', 3),
(4, 'Agent de ville', 'Agents de ville', 'VILLE', 4),
(5, 'Agent de groupe de villes', 'Agents de groupes de villes', 'GVILLE', 5);

-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_radiation`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_radiation` (
  `id` int(11) NOT NULL DEFAULT '0',
  `libelle` varchar(60) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `kernel_bu_radiation`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_responsable`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_responsable` (
  `numero` int(11) NOT NULL AUTO_INCREMENT,
  `nom` varchar(50) NOT NULL,
  `nom_jf` varchar(50) DEFAULT NULL,
  `prenom1` varchar(50) NOT NULL,
  `civilite` varchar(15) DEFAULT NULL,
  `id_sexe` int(11) DEFAULT '0',
  `id_pcs` int(11) DEFAULT NULL,
  `profession` varchar(80) DEFAULT NULL,
  `id_fam` int(11) DEFAULT NULL,
  `tel_dom` varchar(15) DEFAULT NULL,
  `tel_gsm` varchar(15) DEFAULT NULL,
  `tel_pro` varchar(15) DEFAULT NULL,
  `mel` varchar(80) DEFAULT NULL,
  `num_rue` varchar(5) DEFAULT NULL,
  `num_seq` varchar(10) DEFAULT NULL,
  `adresse1` varchar(100) DEFAULT NULL,
  `adresse2` varchar(100) DEFAULT NULL,
  `code_postal` varchar(8) DEFAULT NULL,
  `commune` varchar(100) DEFAULT NULL,
  `id_ville` int(11) DEFAULT '0',
  PRIMARY KEY (`numero`),
  KEY `nom` (`nom`),
  KEY `id_sexe` (`id_sexe`),
  KEY `id_pcs` (`id_pcs`),
  KEY `id_fam` (`id_fam`),
  KEY `adresse1` (`adresse1`),
  KEY `commune` (`commune`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `kernel_bu_responsable`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_responsables`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_responsables` (
  `id_rel` int(11) NOT NULL AUTO_INCREMENT,
  `id_beneficiaire` int(11) NOT NULL DEFAULT '0',
  `type_beneficiaire` varchar(12) NOT NULL DEFAULT 'eleve',
  `id_responsable` int(11) NOT NULL DEFAULT '0',
  `type` varchar(12) NOT NULL DEFAULT '',
  `auth_parentale` tinyint(4) NOT NULL DEFAULT '0',
  `id_par` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_rel`),
  KEY `id_beneficiaire` (`id_beneficiaire`),
  KEY `id_responsable` (`id_responsable`),
  KEY `auth_parentale` (`auth_parentale`),
  KEY `id_par` (`id_par`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `kernel_bu_responsables`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_rue`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_rue` (
  `id_voie` int(11) NOT NULL AUTO_INCREMENT,
  `type_voie` varchar(20) NOT NULL DEFAULT '',
  `lien_voie` varchar(50) DEFAULT NULL,
  `nom_voie` varchar(100) NOT NULL DEFAULT '',
  `code_postal` varchar(10) NOT NULL DEFAULT '',
  `commune` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_voie`),
  KEY `commune` (`commune`),
  KEY `nom_voie` (`nom_voie`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `kernel_bu_rue`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_scolarite`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_scolarite` (
  `idEleve` int(11) NOT NULL DEFAULT '0',
  `b2i` tinyint(4) NOT NULL DEFAULT '0',
  `comp_b2i` tinyint(4) NOT NULL DEFAULT '0',
  `aper` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idEleve`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `kernel_bu_scolarite`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_sexe`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_sexe` (
  `id_s` tinyint(4) NOT NULL AUTO_INCREMENT,
  `sexe` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_s`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=3 ;

--
-- Contenu de la table `kernel_bu_sexe`
--

INSERT INTO `kernel_bu_sexe` (`id_s`, `sexe`) VALUES
(1, 'Masculin'),
(2, 'Féminin');

-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_situation_familiale`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_situation_familiale` (
  `id_sf` tinyint(4) NOT NULL AUTO_INCREMENT,
  `situation` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_sf`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `kernel_bu_situation_familiale`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_utilisateurs_bu`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_utilisateurs_bu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `login` varchar(20) NOT NULL DEFAULT '',
  `password` varchar(50) NOT NULL DEFAULT '',
  `nom` varchar(50) NOT NULL DEFAULT '',
  `prenom` varchar(50) NOT NULL DEFAULT '',
  `email` varchar(80) NOT NULL DEFAULT '',
  `profil` int(11) NOT NULL DEFAULT '0',
  `code_utilisateur` varchar(10) DEFAULT NULL,
  `connexion_nb` int(11) NOT NULL DEFAULT '0',
  `connexion_first` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `connexion_last` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_creation` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `login` (`login`),
  KEY `profil` (`profil`),
  KEY `login_2` (`login`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `kernel_bu_utilisateurs_bu`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_utilisateurs_bu_entite`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_utilisateurs_bu_entite` (
  `utilisateur` int(11) NOT NULL DEFAULT '0',
  `reference` int(11) NOT NULL DEFAULT '0',
  `type_ref` char(6) NOT NULL DEFAULT '',
  PRIMARY KEY (`utilisateur`,`reference`,`type_ref`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `kernel_bu_utilisateurs_bu_entite`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_utilisateurs_bu_profils`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_utilisateurs_bu_profils` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `profil_nom` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `kernel_bu_utilisateurs_bu_profils`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_bu_ville`
--

CREATE TABLE IF NOT EXISTS `kernel_bu_ville` (
  `id_vi` int(11) NOT NULL AUTO_INCREMENT,
  `nom` varchar(150) NOT NULL DEFAULT '',
  `canon` varchar(80) NOT NULL DEFAULT '',
  `id_grville` int(11) NOT NULL DEFAULT '0',
  `date_creation` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_vi`),
  UNIQUE KEY `canon` (`canon`),
  KEY `nom` (`nom`,`id_grville`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 PACK_KEYS=0 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `kernel_bu_ville`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_conf_user`
--

CREATE TABLE IF NOT EXISTS `kernel_conf_user` (
  `path` varchar(255) NOT NULL,
  `id_dbuser` int(11) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`path`,`id_dbuser`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `kernel_conf_user`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_conf_uservisibility`
--

CREATE TABLE IF NOT EXISTS `kernel_conf_uservisibility` (
  `src` enum('USER_ELE','USER_RES','USER_ENS','USER_ADM','USER_VIL','USER_EXT') NOT NULL,
  `dst` enum('USER_ELE','USER_RES','USER_ENS','USER_ADM','USER_VIL','USER_EXT') NOT NULL,
  `visibility` enum('FULL','BU_GRVILLE','BU_VILLE','BU_ECOLE','BU_CLASSE','CLUB','NONE') NOT NULL,
  PRIMARY KEY (`src`,`dst`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `kernel_conf_uservisibility`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_ext_user`
--

CREATE TABLE IF NOT EXISTS `kernel_ext_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nom` varchar(255) NOT NULL DEFAULT '',
  `prenom` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

--
-- Contenu de la table `kernel_ext_user`
--

INSERT INTO `kernel_ext_user` (`id`, `nom`, `prenom`, `description`) VALUES
(1, 'Root', '', '');

-- --------------------------------------------------------

--
-- Structure de la table `kernel_i18n_node_vocabularycatalog`
--

CREATE TABLE IF NOT EXISTS `kernel_i18n_node_vocabularycatalog` (
  `node_type` varchar(15) NOT NULL,
  `node_id` int(11) NOT NULL,
  `vocabulary_catalog_id` int(11) NOT NULL,
  PRIMARY KEY (`node_type`,`node_id`,`vocabulary_catalog_id`),
  KEY `fk_vocabulary_catalog` (`vocabulary_catalog_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `kernel_i18n_node_vocabularycatalog`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_i18n_vocabulary_catalog`
--

CREATE TABLE IF NOT EXISTS `kernel_i18n_vocabulary_catalog` (
  `id_vc` int(11) NOT NULL AUTO_INCREMENT,
  `name_vc` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id_vc`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=3 ;

--
-- Contenu de la table `kernel_i18n_vocabulary_catalog`
--

INSERT INTO `kernel_i18n_vocabulary_catalog` (`id_vc`, `name_vc`) VALUES
(1, 'academic'),
(2, 'entertainment');

-- --------------------------------------------------------

--
-- Structure de la table `kernel_i18n_vocabulary_word`
--

CREATE TABLE IF NOT EXISTS `kernel_i18n_vocabulary_word` (
  `id_word` int(11) NOT NULL AUTO_INCREMENT,
  `vocabulary_catalog_id` int(11) NOT NULL,
  `key_word` varchar(255) NOT NULL,
  `value_word` varchar(255) NOT NULL,
  `definite_word` varchar(255) DEFAULT NULL,
  `indefinite_word` varchar(255) DEFAULT NULL,
  `lang_word` varchar(255) NOT NULL,
  PRIMARY KEY (`id_word`),
  KEY `fk_vocabulary_catalog` (`vocabulary_catalog_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=48 ;

--
-- Contenu de la table `kernel_i18n_vocabulary_word`
--

INSERT INTO `kernel_i18n_vocabulary_word` (`id_word`, `vocabulary_catalog_id`, `key_word`, `value_word`, `definite_word`, `indefinite_word`, `lang_word`) VALUES
(1, 1, 'structure_element_staff_person', 'enseignant', 'l''enseignant', 'un enseignant', 'fr'),
(2, 1, 'user_ens', 'enseignant', 'l''enseignant', 'un enseignant', 'fr'),
(3, 1, 'user_ens2', 'enseignante', 'l''enseignante', 'une enseignante', 'fr'),
(4, 1, 'user_adm', 'équipe administrative', 'l''équipe administrative', 'une équipe administrative', 'fr'),
(5, 1, 'user_adm2', 'équipe administrative', 'l''équipe administrative', 'une équipe administrative', 'fr'),
(6, 1, 'user_ele', 'élève', 'l''élève', 'un élève', 'fr'),
(7, 1, 'user_ele2', 'élève', 'l''élève', 'une élève', 'fr'),
(8, 1, 'user_res', 'responsable', 'le responsable', 'un responsable', 'fr'),
(9, 1, 'user_res2', 'responsable', 'la responsable', 'une responsable', 'fr'),
(10, 1, 'user_vil', 'agent de ville', 'l''agent de ville', 'un agent de ville', 'fr'),
(11, 1, 'user_vil2', 'agent de ville', 'l''agent de ville', 'une agent de ville', 'fr'),
(12, 1, 'user_ext', 'intervenant extérieur', 'l''intervenant extérieur', 'un intervenant extérieur', 'fr'),
(13, 1, 'user_ext2', 'intervenante extérieur', 'l''intervenante extérieur', 'une intervenante extérieur', 'fr'),
(14, 2, 'user_ens2', 'responsable d''accueil de loisirs', 'la responsable d''accueil de loisirs', 'une responsable d''accueil de loisirs', 'fr'),
(15, 2, 'user_ens', 'responsable d''accueil de loisirs', 'le responsable d''accueil de loisirs', 'un responsable d''accueil de loisirs', 'fr'),
(16, 1, 'structure', 'école', 'l''école', 'une école', 'fr'),
(17, 2, 'structure', 'accueil de loisirs', 'l''accueil de loisirs', 'un accueil de loisirs', 'fr'),
(18, 1, 'structures', 'écoles', 'les écoles', 'des écoles', 'fr'),
(19, 2, 'structures', 'accueils de loisirs', 'les accueils de loisirs', 'des accueils de loisirs', 'fr'),
(20, 1, 'user_dir', 'directeur', 'les directeurs', 'le directeur', 'fr'),
(21, 1, 'structure_element', 'classe', 'la classe', 'une classe', 'fr'),
(22, 1, 'city', 'ville', 'la ville', 'une ville', 'fr'),
(23, 1, 'citygroup', 'groupe de ville', 'le groupe de ville', 'un groupe de ville', 'fr'),
(24, 1, 'structure_element_Responsables', 'Parents', 'Les parents', 'Des parents', 'fr'),
(25, 1, 'structure_element_person', 'élève', 'l''élève', 'un élève', 'fr'),
(26, 1, 'structure_element_staff_Persons', 'Enseignants', 'Les enseignants', 'Des enseignants', 'fr'),
(27, 1, 'structure_element_Persons', 'Elèves', 'Les élèves', 'Des élèves', 'fr'),
(28, 1, 'another_structure_element', 'autre classe', 'l''autre classe', 'une autre classe', 'fr'),
(29, 1, 'structure_element_administration_staff', 'personnel administratif', 'le personnel administratif', 'un personnel administratif', 'fr'),
(30, 1, 'structure_element_responsable', 'parent', 'le parent', 'un parent', 'fr'),
(31, 1, 'structure_element_persons', 'élèves', 'les élèves', 'des élèves', 'fr'),
(32, 1, 'structure_element_staff_persons', 'enseignants', 'les enseignants', 'des enseignants', 'fr'),
(33, 1, 'structure_element_responsables', 'parents', 'les parents', 'des parents', 'fr'),
(34, 1, 'Structure_element', 'Classe', 'La classe', 'Une classe', 'fr'),
(35, 1, 'Structure', 'Ecole', 'L''école', 'Une école', 'fr'),
(45, 1, 'structure_element_director_staff', 'directeur', 'le directeur', 'un directeur', 'fr'),
(46, 1, 'Structure_element_fiche', 'Classes & enseignants', 'Les classes & les enseignants', 'Des Classes & des enseignants', 'fr'),
(47, 2, 'Structure_element_fiche', 'Classes & enseignants', 'Les classes & les enseignants', 'Des Classes & des enseignants', 'fr');

-- --------------------------------------------------------

--
-- Structure de la table `kernel_ien`
--

CREATE TABLE IF NOT EXISTS `kernel_ien` (
  `user_type` varchar(10) NOT NULL,
  `user_id` int(11) NOT NULL,
  `can_connect` tinyint(4) NOT NULL,
  `can_tableaubord` tinyint(4) NOT NULL,
  `can_comptes` tinyint(4) NOT NULL,
  `is_visibleannuaire` tinyint(4) NOT NULL,
  `updated_at` datetime NOT NULL,
  `updated_by` varchar(50) NOT NULL,
  PRIMARY KEY (`user_type`,`user_id`),
  KEY `is_visibleannuaire` (`is_visibleannuaire`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `kernel_ien`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_ien2regroupements`
--

CREATE TABLE IF NOT EXISTS `kernel_ien2regroupements` (
  `user_type` varchar(10) NOT NULL,
  `user_id` int(11) NOT NULL,
  `regroupement_type` enum('villes','ecoles') NOT NULL,
  `regroupement_id` int(11) NOT NULL,
  PRIMARY KEY (`user_type`,`user_id`,`regroupement_type`,`regroupement_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `kernel_ien2regroupements`
--


-- --------------------------------------------------------

--
-- Doublure de structure pour la vue `kernel_info_users`
--
CREATE TABLE IF NOT EXISTS `kernel_info_users` (
`user_type` varchar(8)
,`user_id` int(11)
,`user_id_copix` int(11)
,`nom` varchar(255)
,`prenom` varchar(255)
,`id_sexe` int(11)
);
-- --------------------------------------------------------

--
-- Structure de la table `kernel_limits_urls`
--

CREATE TABLE IF NOT EXISTS `kernel_limits_urls` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `theme` varchar(50) DEFAULT NULL,
  `id_blog` int(11) DEFAULT NULL,
  `ville` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `url` (`url`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `kernel_limits_urls`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_link_bu2user`
--

CREATE TABLE IF NOT EXISTS `kernel_link_bu2user` (
  `user_id` int(11) NOT NULL DEFAULT '0',
  `bu_type` varchar(10) NOT NULL DEFAULT '',
  `bu_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`bu_type`,`bu_id`),
  KEY `bu` (`bu_type`,`bu_id`),
  KEY `copix` (`user_id`),
  KEY `bu_id` (`bu_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `kernel_link_bu2user`
--

INSERT INTO `kernel_link_bu2user` (`user_id`, `bu_type`, `bu_id`) VALUES
(1, 'USER_EXT', 1);

-- --------------------------------------------------------

--
-- Structure de la table `kernel_link_groupe2node`
--

CREATE TABLE IF NOT EXISTS `kernel_link_groupe2node` (
  `groupe_id` int(11) NOT NULL DEFAULT '0',
  `node_type` varchar(15) NOT NULL DEFAULT '',
  `node_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`groupe_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `kernel_link_groupe2node`
--

INSERT INTO `kernel_link_groupe2node` (`groupe_id`, `node_type`, `node_id`) VALUES
(1, 'ROOT', 0);

-- --------------------------------------------------------

--
-- Structure de la table `kernel_link_user2node`
--

CREATE TABLE IF NOT EXISTS `kernel_link_user2node` (
  `user_type` varchar(15) NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `node_type` varchar(15) NOT NULL DEFAULT '',
  `node_id` int(11) NOT NULL DEFAULT '0',
  `droit` int(11) NOT NULL DEFAULT '0',
  `debut` varchar(8) DEFAULT NULL,
  `fin` varchar(8) DEFAULT NULL,
  PRIMARY KEY (`user_type`,`user_id`,`node_type`,`node_id`),
  KEY `node` (`node_type`,`node_id`),
  KEY `user` (`user_type`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `kernel_link_user2node`
--

INSERT INTO `kernel_link_user2node` (`user_type`, `user_id`, `node_type`, `node_id`, `droit`, `debut`, `fin`) VALUES
('USER_EXT', 1, 'ROOT', 0, 70, NULL, NULL),
('USER_ENS', 1, 'ROOT', 0, 70, NULL, NULL),
('USER_ENS', 1, 'CLUB', 1, 70, NULL, NULL),
('USER_EXT', 1, 'CLUB', 1, 70, NULL, NULL);

-- --------------------------------------------------------

--
-- Structure de la table `kernel_mod_available`
--

CREATE TABLE IF NOT EXISTS `kernel_mod_available` (
  `node` varchar(15) NOT NULL DEFAULT '',
  `module` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`node`,`module`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `kernel_mod_available`
--

INSERT INTO `kernel_mod_available` (`node`, `module`) VALUES
('BU_CLASSE', 'MOD_AGENDA'),
('BU_CLASSE', 'MOD_BLOG'),
('BU_CLASSE', 'MOD_CAHIERDETEXTES'),
('BU_CLASSE', 'MOD_CLASSEUR'),
('BU_CLASSE', 'MOD_MAGICMAIL'),
('BU_CLASSE', 'MOD_QUIZ'),
('BU_ECOLE', 'MOD_AGENDA'),
('BU_ECOLE', 'MOD_BLOG'),
('BU_ECOLE', 'MOD_CLASSEUR'),
('BU_ECOLE', 'MOD_MAGICMAIL'),
('BU_VILLE', 'MOD_BLOG'),
('BU_VILLE', 'MOD_CLASSEUR'),
('BU_VILLE', 'MOD_MAGICMAIL'),
('BU_VILLE', 'MOD_TELEPROCEDURES'),
('CLUB', 'MOD_AGENDA'),
('CLUB', 'MOD_BLOG'),
('CLUB', 'MOD_CLASSEUR'),
('CLUB', 'MOD_FORUM'),
('CLUB', 'MOD_LISTE'),
('CLUB', 'MOD_MAGICMAIL'),
('CLUB', 'MOD_QUIZ'),
('USER_%', 'MOD_AGENDA'),
('USER_%', 'MOD_CLASSEUR'),
('USER_%', 'MOD_MINIMAIL'),
('USER_ELE', 'MOD_CAHIERDETEXTES'),
('USER_ENS', 'MOD_WEBMAIL'),
('USER_EXT', 'MOD_WEBMAIL'),
('USER_RES', 'MOD_CORRESP'),
('USER_VIL', 'MOD_WEBMAIL');

-- --------------------------------------------------------

--
-- Structure de la table `kernel_mod_enabled`
--

CREATE TABLE IF NOT EXISTS `kernel_mod_enabled` (
  `node_type` varchar(20) NOT NULL DEFAULT '',
  `node_id` int(11) NOT NULL DEFAULT '0',
  `module_type` varchar(20) NOT NULL DEFAULT '',
  `module_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`node_type`,`node_id`,`module_type`,`module_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `kernel_mod_enabled`
--

INSERT INTO `kernel_mod_enabled` (`node_type`, `node_id`, `module_type`, `module_id`) VALUES
('CLUB', 1, 'MOD_BLOG', 1),
('CLUB', 1, 'MOD_CLASSEUR', 1),
('CLUB', 1, 'MOD_MAGICMAIL', 1);

-- --------------------------------------------------------

--
-- Structure de la table `kernel_notifications_lastvisit`
--

CREATE TABLE IF NOT EXISTS `kernel_notifications_lastvisit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `date` datetime NOT NULL,
  `node_type` varchar(20) DEFAULT NULL,
  `node_id` int(11) DEFAULT NULL,
  `module_type` varchar(20) DEFAULT NULL,
  `module_id` varchar(20) DEFAULT NULL,
  `last_check` datetime DEFAULT NULL,
  `last_number` int(11) DEFAULT NULL,
  `last_message` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`node_type`,`node_id`,`module_type`,`module_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=7 ;

--
-- Contenu de la table `kernel_notifications_lastvisit`
--

INSERT INTO `kernel_notifications_lastvisit` (`id`, `user_id`, `date`, `node_type`, `node_id`, `module_type`, `module_id`, `last_check`, `last_number`, `last_message`) VALUES
(1, 1, '2013-11-28 16:08:40', 'ROOT', 0, 'SYSUTILS', NULL, NULL, NULL, NULL),
(2, 1, '2013-11-28 16:08:40', 'ROOT', 0, 'CHARTE', NULL, NULL, NULL, NULL),
(3, 1, '2013-11-28 16:08:40', 'ROOT', 0, 'REGROUPEMENTS', 'ROOT-0', NULL, NULL, NULL),
(4, 1, '2013-11-28 16:08:40', 'ROOT', 0, 'GESTIONAUTONOME', 'ROOT-0', NULL, NULL, NULL),
(5, 1, '2013-11-28 16:08:40', 'CLUB', 1, 'BLOG', '1', NULL, NULL, NULL),
(6, 1, '2013-11-28 16:08:40', 'CLUB', 1, 'CLASSEUR', '1', NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Structure de la table `kernel_sso_challenges`
--

CREATE TABLE IF NOT EXISTS `kernel_sso_challenges` (
  `id_sso` mediumint(8) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  `challenge` varchar(50) NOT NULL,
  PRIMARY KEY (`id_sso`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `kernel_sso_challenges`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_sso_users`
--

CREATE TABLE IF NOT EXISTS `kernel_sso_users` (
  `id_sso` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `login` varchar(50) NOT NULL,
  `cle_privee` varchar(50) NOT NULL,
  PRIMARY KEY (`id_sso`),
  KEY `login` (`login`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `kernel_sso_users`
--


-- --------------------------------------------------------

--
-- Structure de la table `kernel_version_bdd`
--

CREATE TABLE IF NOT EXISTS `kernel_version_bdd` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `version` smallint(6) NOT NULL,
  `date` varchar(14) NOT NULL,
  `ip` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `version` (`version`),
  KEY `date` (`date`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=22 ;

--
-- Contenu de la table `kernel_version_bdd`
--

INSERT INTO `kernel_version_bdd` (`id`, `version`, `date`, `ip`) VALUES
(1, 10, '2013-11-28 16:', 'install'),
(2, 11, '20131128160810', '172.30.107.190'),
(3, 12, '20131128160810', '172.30.107.190'),
(4, 13, '20131128160810', '172.30.107.190'),
(5, 14, '20131128160810', '172.30.107.190'),
(6, 15, '20131128160810', '172.30.107.190'),
(7, 16, '20131128160810', '172.30.107.190'),
(8, 17, '20131128160810', '172.30.107.190'),
(9, 18, '20131128160810', '172.30.107.190'),
(10, 19, '20131128160810', '172.30.107.190'),
(11, 20, '20131128160810', '172.30.107.190'),
(12, 21, '20131128160810', '172.30.107.190'),
(13, 22, '20131128160810', '172.30.107.190'),
(14, 23, '20131128160810', '172.30.107.190'),
(15, 24, '20131128160810', '172.30.107.190'),
(16, 25, '20131128160810', '172.30.107.190'),
(17, 26, '20131128160810', '172.30.107.190'),
(18, 27, '20131128160810', '172.30.107.190'),
(19, 28, '20131128160810', '172.30.107.190'),
(20, 29, '20131128160810', '172.30.107.190'),
(21, 30, '20131128160810', '172.30.107.190');

-- --------------------------------------------------------

--
-- Structure de la table `modulecredentials`
--

CREATE TABLE IF NOT EXISTS `modulecredentials` (
  `id_mc` int(11) NOT NULL AUTO_INCREMENT,
  `module_mc` varchar(255) DEFAULT NULL,
  `name_mc` varchar(255) NOT NULL,
  PRIMARY KEY (`id_mc`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=13 ;

--
-- Contenu de la table `modulecredentials`
--

INSERT INTO `modulecredentials` (`id_mc`, `module_mc`, `name_mc`) VALUES
(1, 'gestionautonome', 'cities_group'),
(2, 'gestionautonome', 'city'),
(3, 'gestionautonome', 'school'),
(4, 'gestionautonome', 'classroom'),
(5, 'gestionautonome', 'cities_group_agent'),
(6, 'gestionautonome', 'city_agent'),
(7, 'gestionautonome', 'administration_staff'),
(8, 'gestionautonome', 'principal'),
(9, 'gestionautonome', 'teacher'),
(10, 'gestionautonome', 'student'),
(11, 'gestionautonome', 'person_in_charge'),
(12, 'gestionautonome', 'access');

-- --------------------------------------------------------

--
-- Structure de la table `modulecredentialsgroups`
--

CREATE TABLE IF NOT EXISTS `modulecredentialsgroups` (
  `id_mcg` int(11) NOT NULL AUTO_INCREMENT,
  `id_mc` int(11) NOT NULL,
  `id_mcv` int(11) DEFAULT NULL,
  `handler_group` varchar(255) DEFAULT NULL,
  `id_group` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id_mcg`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=50 ;

--
-- Contenu de la table `modulecredentialsgroups`
--

INSERT INTO `modulecredentialsgroups` (`id_mcg`, `id_mc`, `id_mcv`, `handler_group`, `id_group`) VALUES
(1, 1, 3, 'auth|dbgrouphandler', '3'),
(2, 2, 6, 'auth|dbgrouphandler', '3'),
(3, 3, 9, 'auth|dbgrouphandler', '3'),
(4, 5, 15, 'auth|dbgrouphandler', '3'),
(5, 6, 18, 'auth|dbgrouphandler', '3'),
(6, 7, 21, 'auth|dbgrouphandler', '3'),
(7, 8, 24, 'auth|dbgrouphandler', '3'),
(8, 9, 27, 'auth|dbgrouphandler', '3'),
(9, 10, 30, 'auth|dbgrouphandler', '3'),
(10, 11, 33, 'auth|dbgrouphandler', '3'),
(11, 12, NULL, 'auth|dbgrouphandler', '3'),
(12, 3, 9, 'auth|dbgrouphandler', '4'),
(13, 4, 12, 'auth|dbgrouphandler', '4'),
(23, 9, 27, 'auth|dbgrouphandler', '6'),
(22, 4, 12, 'auth|dbgrouphandler', '6'),
(16, 7, 21, 'auth|dbgrouphandler', '4'),
(17, 8, 24, 'auth|dbgrouphandler', '4'),
(18, 9, 27, 'auth|dbgrouphandler', '4'),
(19, 10, 30, 'auth|dbgrouphandler', '4'),
(20, 11, 33, 'auth|dbgrouphandler', '4'),
(21, 12, NULL, 'auth|dbgrouphandler', '4'),
(24, 10, 30, 'auth|dbgrouphandler', '6'),
(25, 11, 33, 'auth|dbgrouphandler', '6'),
(26, 12, NULL, 'auth|dbgrouphandler', '6'),
(32, 11, 32, 'auth|dbgrouphandler', '7'),
(33, 3, 8, 'auth|dbgrouphandler', '8'),
(29, 12, NULL, 'auth|dbgrouphandler', '7'),
(30, 4, 12, 'auth|dbgrouphandler', '3'),
(31, 10, 29, 'auth|dbgrouphandler', '7'),
(34, 4, 12, 'auth|dbgrouphandler', '8'),
(35, 7, 21, 'auth|dbgrouphandler', '8'),
(36, 8, 24, 'auth|dbgrouphandler', '8'),
(37, 9, 27, 'auth|dbgrouphandler', '8'),
(38, 10, 30, 'auth|dbgrouphandler', '8'),
(39, 11, 33, 'auth|dbgrouphandler', '8'),
(40, 12, NULL, 'auth|dbgrouphandler', '8'),
(41, 4, 11, 'auth|dbgrouphandler', '9'),
(42, 9, 27, 'auth|dbgrouphandler', '9'),
(43, 10, 30, 'auth|dbgrouphandler', '9'),
(44, 11, 33, 'auth|dbgrouphandler', '9'),
(45, 12, NULL, 'auth|dbgrouphandler', '9'),
(46, 8, 24, 'auth|dbgrouphandler', '9'),
(47, 10, 29, 'auth|dbgrouphandler', '10'),
(48, 11, 32, 'auth|dbgrouphandler', '10'),
(49, 12, NULL, 'auth|dbgrouphandler', '10');

-- --------------------------------------------------------

--
-- Structure de la table `modulecredentialsoverpass`
--

CREATE TABLE IF NOT EXISTS `modulecredentialsoverpass` (
  `id_mco` int(11) NOT NULL AUTO_INCREMENT,
  `id_mc` int(11) DEFAULT NULL,
  `overpass_id_mc` int(11) DEFAULT NULL,
  `overpath_id_mc` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_mco`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `modulecredentialsoverpass`
--


-- --------------------------------------------------------

--
-- Structure de la table `modulecredentialsvalues`
--

CREATE TABLE IF NOT EXISTS `modulecredentialsvalues` (
  `id_mcv` int(11) NOT NULL AUTO_INCREMENT,
  `value_mcv` varchar(255) NOT NULL,
  `id_mc` int(11) NOT NULL,
  `level_mcv` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_mcv`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=34 ;

--
-- Contenu de la table `modulecredentialsvalues`
--

INSERT INTO `modulecredentialsvalues` (`id_mcv`, `value_mcv`, `id_mc`, `level_mcv`) VALUES
(1, 'create', 1, 1),
(2, 'update', 1, 2),
(3, 'delete', 1, 3),
(4, 'create', 2, 1),
(5, 'update', 2, 2),
(6, 'delete', 2, 3),
(7, 'create', 3, 1),
(8, 'update', 3, 2),
(9, 'delete', 3, 3),
(10, 'create', 4, 1),
(11, 'update', 4, 2),
(12, 'delete', 4, 3),
(13, 'create', 5, 1),
(14, 'update', 5, 2),
(15, 'delete', 5, 3),
(16, 'create', 6, 1),
(17, 'update', 6, 2),
(18, 'delete', 6, 3),
(19, 'create', 7, 1),
(20, 'update', 7, 2),
(21, 'delete', 7, 3),
(22, 'create', 8, 1),
(23, 'update', 8, 2),
(24, 'delete', 8, 3),
(25, 'create', 9, 1),
(26, 'update', 9, 2),
(27, 'delete', 9, 3),
(28, 'create', 10, 1),
(29, 'update', 10, 2),
(30, 'delete', 10, 3),
(31, 'create', 11, 1),
(32, 'update', 11, 2),
(33, 'delete', 11, 3);

-- --------------------------------------------------------

--
-- Structure de la table `module_account`
--

CREATE TABLE IF NOT EXISTS `module_account` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_account` int(11) unsigned NOT NULL,
  `id_school` int(11) unsigned NOT NULL,
  `id_director` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_account` (`id_account`,`id_school`,`id_director`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_account`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_account_class`
--

CREATE TABLE IF NOT EXISTS `module_account_class` (
  `id_account` int(11) unsigned NOT NULL,
  `id_class_SUB` int(11) unsigned NOT NULL,
  `id_class_EN` int(11) unsigned NOT NULL,
  `creation_date` date NOT NULL,
  `validity_date` date NOT NULL,
  KEY `id_account` (`id_account`,`id_class_SUB`,`id_class_EN`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Contenu de la table `module_account_class`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_admindash`
--

CREATE TABLE IF NOT EXISTS `module_admindash` (
  `content` text,
  `picture` varchar(255) DEFAULT NULL,
  `id_zone` int(11) unsigned NOT NULL,
  `type_zone` varchar(255) NOT NULL,
  `social_stream` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id_zone`,`type_zone`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Contenu de la table `module_admindash`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_agenda_agenda`
--

CREATE TABLE IF NOT EXISTS `module_agenda_agenda` (
  `id_agenda` int(11) NOT NULL AUTO_INCREMENT,
  `title_agenda` varchar(255) NOT NULL DEFAULT '',
  `desc_agenda` varchar(255) DEFAULT '',
  `type_agenda` int(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_agenda`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_agenda_agenda`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_agenda_event`
--

CREATE TABLE IF NOT EXISTS `module_agenda_event` (
  `id_event` int(11) NOT NULL AUTO_INCREMENT,
  `id_agenda` int(11) DEFAULT '0',
  `title_event` varchar(255) NOT NULL DEFAULT '',
  `desc_event` text,
  `place_event` varchar(100) DEFAULT NULL,
  `datedeb_event` varchar(8) NOT NULL DEFAULT '',
  `heuredeb_event` varchar(5) DEFAULT '',
  `datefin_event` varchar(8) NOT NULL DEFAULT '',
  `heurefin_event` varchar(5) DEFAULT NULL,
  `alldaylong_event` int(1) NOT NULL DEFAULT '0',
  `everyday_event` int(1) NOT NULL DEFAULT '0',
  `everyweek_event` int(1) NOT NULL DEFAULT '0',
  `everymonth_event` int(1) NOT NULL DEFAULT '0',
  `everyyear_event` int(1) NOT NULL DEFAULT '0',
  `endrepeatdate_event` varchar(8) DEFAULT '',
  PRIMARY KEY (`id_event`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_agenda_event`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_agenda_lecon`
--

CREATE TABLE IF NOT EXISTS `module_agenda_lecon` (
  `id_lecon` int(11) NOT NULL AUTO_INCREMENT,
  `id_agenda` int(11) DEFAULT '0',
  `desc_lecon` text,
  `date_lecon` varchar(8) DEFAULT '',
  PRIMARY KEY (`id_lecon`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_agenda_lecon`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_agenda_work`
--

CREATE TABLE IF NOT EXISTS `module_agenda_work` (
  `module_cahierdetextes_travail_id` int(11) NOT NULL,
  `module_agenda_agenda_id_agenda` int(11) NOT NULL,
  PRIMARY KEY (`module_cahierdetextes_travail_id`,`module_agenda_agenda_id_agenda`),
  KEY `fk_travail` (`module_cahierdetextes_travail_id`),
  KEY `fk_agenda` (`module_agenda_agenda_id_agenda`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `module_agenda_work`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_album_albums`
--

CREATE TABLE IF NOT EXISTS `module_album_albums` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nom` varchar(255) NOT NULL DEFAULT '',
  `prefs` text NOT NULL,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `cle` varchar(10) NOT NULL DEFAULT '',
  `public` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_album_albums`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_album_dossiers`
--

CREATE TABLE IF NOT EXISTS `module_album_dossiers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_album` int(11) NOT NULL,
  `id_parent` int(11) NOT NULL DEFAULT '0',
  `nom` varchar(255) NOT NULL,
  `commentaire` text NOT NULL,
  `date` datetime NOT NULL,
  `cle` varchar(10) NOT NULL,
  `public` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_album_dossiers`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_album_photos`
--

CREATE TABLE IF NOT EXISTS `module_album_photos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_album` int(11) NOT NULL DEFAULT '0',
  `id_dossier` int(11) NOT NULL DEFAULT '0',
  `nom` varchar(255) NOT NULL DEFAULT '',
  `commentaire` text,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ext` varchar(5) NOT NULL DEFAULT '',
  `cle` varchar(10) NOT NULL DEFAULT '',
  `public` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_album` (`id_album`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_album_photos`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_blog`
--

CREATE TABLE IF NOT EXISTS `module_blog` (
  `id_blog` bigint(20) NOT NULL AUTO_INCREMENT,
  `name_blog` varchar(100) NOT NULL DEFAULT '',
  `id_ctpt` bigint(20) NOT NULL DEFAULT '0',
  `logo_blog` varchar(100) DEFAULT NULL,
  `url_blog` varchar(100) DEFAULT NULL,
  `style_blog_file` tinyint(4) NOT NULL DEFAULT '0',
  `is_public` tinyint(4) NOT NULL DEFAULT '1',
  `privacy` tinyint(4) NOT NULL DEFAULT '0',
  `has_comments_activated` tinyint(1) NOT NULL DEFAULT '0',
  `type_moderation_comments` varchar(5) NOT NULL DEFAULT 'POST',
  `default_format_articles` varchar(10) NOT NULL DEFAULT 'wiki',
  `template` varchar(30) DEFAULT NULL COMMENT 'Template a utiliser, si different de blog_main.tpl',
  PRIMARY KEY (`id_blog`),
  KEY `url_blog` (`url_blog`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

--
-- Contenu de la table `module_blog`
--

INSERT INTO `module_blog` (`id_blog`, `name_blog`, `id_ctpt`, `logo_blog`, `url_blog`, `style_blog_file`, `is_public`, `privacy`, `has_comments_activated`, `type_moderation_comments`, `default_format_articles`, `template`) VALUES
(1, 'Edito', 1, NULL, 'edito', 0, 0, 0, 0, 'POST', 'ckeditor', NULL);

-- --------------------------------------------------------

--
-- Structure de la table `module_blog_article`
--

CREATE TABLE IF NOT EXISTS `module_blog_article` (
  `id_bact` bigint(20) NOT NULL AUTO_INCREMENT,
  `id_blog` bigint(20) NOT NULL DEFAULT '0',
  `name_bact` varchar(100) NOT NULL DEFAULT '',
  `sumary_bact` text,
  `sumary_html_bact` text,
  `content_bact` text,
  `content_html_bact` text,
  `format_bact` varchar(10) NOT NULL DEFAULT 'wiki',
  `author_bact` int(11) NOT NULL DEFAULT '0',
  `date_bact` varchar(8) NOT NULL DEFAULT '',
  `time_bact` varchar(5) NOT NULL DEFAULT '',
  `url_bact` varchar(100) NOT NULL DEFAULT '',
  `sticky_bact` int(1) NOT NULL DEFAULT '0',
  `is_online` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id_bact`),
  KEY `is_online` (`is_online`),
  KEY `id_blog` (`id_blog`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=3 ;

--
-- Contenu de la table `module_blog_article`
--

INSERT INTO `module_blog_article` (`id_bact`, `id_blog`, `name_bact`, `sumary_bact`, `sumary_html_bact`, `content_bact`, `content_html_bact`, `format_bact`, `author_bact`, `date_bact`, `time_bact`, `url_bact`, `sticky_bact`, `is_online`) VALUES
(1, 1, 'L''école du Bois Fleuri se met à Iconito', '<p>\r\n	A partir d&#39;aujourd&#39;hui, Iconito est d&eacute;ploy&eacute; &agrave; l&#39;&eacute;cole du Bois Fleuri. Gr&acirc;ce notamment &agrave; l&#39;implication du directeur M. Franc et des enseignants, les parents d&#39;&eacute;l&egrave;ves vont pouvoir :</p>\r\n<ul>\r\n	<li>\r\n		suivre les aventures de leurs enfants lors des sorties et des classes vertes</li>\r\n	<li>\r\n		communiquer avec les enseignants</li>\r\n	<li>\r\n		obtenir des informations pratiques sur l&#39;&eacute;cole</li>\r\n</ul>\r\n', '<p>\r\n	A partir d&#39;aujourd&#39;hui, Iconito est d&eacute;ploy&eacute; &agrave; l&#39;&eacute;cole du Bois Fleuri. Gr&acirc;ce notamment &agrave; l&#39;implication du directeur M. Franc et des enseignants, les parents d&#39;&eacute;l&egrave;ves vont pouvoir :</p>\r\n<ul>\r\n	<li>\r\n		suivre les aventures de leurs enfants lors des sorties et des classes vertes</li>\r\n	<li>\r\n		communiquer avec les enseignants</li>\r\n	<li>\r\n		obtenir des informations pratiques sur l&#39;&eacute;cole</li>\r\n</ul>\r\n', '<br />\r\n', '<br />\r\n', 'ckeditor', 1, '20111004', '0722', '1_lecole_du_bois_fleuri_se_met_iconito', 0, 1),
(2, 1, 'Démarrage du projet', '<p>\r\n	Apr&egrave;s une installation facile et rapide, Iconito est install&eacute; dans notre commune. Les &eacute;coles devraient rapidement s&#39;approprier l&#39;outil et permettre &agrave; tous les acteurs du monde &eacute;ducatif d&#39;en profiter...</p>\r\n', '<p>\r\n	Apr&egrave;s une installation facile et rapide, Iconito est install&eacute; dans notre commune. Les &eacute;coles devraient rapidement s&#39;approprier l&#39;outil et permettre &agrave; tous les acteurs du monde &eacute;ducatif d&#39;en profiter...</p>\r\n', '<br />\r\n', '<br />\r\n', 'ckeditor', 1, '20111004', '0709', '2_demarrage_du_projet', 0, 1);

-- --------------------------------------------------------

--
-- Structure de la table `module_blog_articlecategory`
--

CREATE TABLE IF NOT EXISTS `module_blog_articlecategory` (
  `id_bacg` bigint(20) NOT NULL AUTO_INCREMENT,
  `id_blog` bigint(20) NOT NULL DEFAULT '0',
  `order_bacg` bigint(10) NOT NULL DEFAULT '0',
  `name_bacg` varchar(100) NOT NULL DEFAULT '',
  `url_bacg` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_bacg`),
  KEY `id_blog` (`id_blog`),
  KEY `order_bacg` (`order_bacg`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

--
-- Contenu de la table `module_blog_articlecategory`
--

INSERT INTO `module_blog_articlecategory` (`id_bacg`, `id_blog`, `order_bacg`, `name_bacg`, `url_bacg`) VALUES
(1, 1, 1, 'Actualités', 'actualites20100921103303');

-- --------------------------------------------------------

--
-- Structure de la table `module_blog_articlecomment`
--

CREATE TABLE IF NOT EXISTS `module_blog_articlecomment` (
  `id_bacc` bigint(20) NOT NULL AUTO_INCREMENT,
  `id_bact` bigint(20) NOT NULL DEFAULT '0',
  `authorid_bacc` int(11) DEFAULT NULL,
  `authorname_bacc` varchar(50) NOT NULL DEFAULT '',
  `authoremail_bacc` varchar(50) DEFAULT NULL,
  `authorweb_bacc` varchar(100) DEFAULT NULL,
  `authorip_bacc` varchar(15) NOT NULL DEFAULT '',
  `date_bacc` varchar(8) NOT NULL DEFAULT '',
  `time_bacc` varchar(8) NOT NULL DEFAULT '',
  `content_bacc` text NOT NULL,
  `is_online` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id_bacc`),
  KEY `authorid_bacc` (`authorid_bacc`),
  KEY `is_online` (`is_online`),
  KEY `id_bact` (`id_bact`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_blog_articlecomment`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_blog_article_blogarticlecategory`
--

CREATE TABLE IF NOT EXISTS `module_blog_article_blogarticlecategory` (
  `id_bact` bigint(20) NOT NULL DEFAULT '0',
  `id_bacg` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_bact`,`id_bacg`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `module_blog_article_blogarticlecategory`
--

INSERT INTO `module_blog_article_blogarticlecategory` (`id_bact`, `id_bacg`) VALUES
(1, 1),
(2, 1);

-- --------------------------------------------------------

--
-- Structure de la table `module_blog_fluxrss`
--

CREATE TABLE IF NOT EXISTS `module_blog_fluxrss` (
  `id_bfrs` bigint(20) NOT NULL AUTO_INCREMENT,
  `id_blog` bigint(20) NOT NULL DEFAULT '0',
  `name_bfrs` varchar(255) NOT NULL DEFAULT '',
  `order_bfrs` bigint(10) NOT NULL DEFAULT '0',
  `url_bfrs` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_bfrs`),
  KEY `id_blog` (`id_blog`),
  KEY `order_bfrs` (`order_bfrs`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_blog_fluxrss`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_blog_functions`
--

CREATE TABLE IF NOT EXISTS `module_blog_functions` (
  `id_blog` bigint(20) NOT NULL DEFAULT '0',
  `article_bfct` int(1) NOT NULL DEFAULT '0',
  `archive_bfct` int(1) NOT NULL DEFAULT '0',
  `find_bfct` int(1) NOT NULL DEFAULT '0',
  `link_bfct` int(1) NOT NULL DEFAULT '0',
  `rss_bfct` int(1) NOT NULL DEFAULT '0',
  `photo_bfct` int(1) NOT NULL DEFAULT '0',
  `option_bfct` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_blog`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `module_blog_functions`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_blog_link`
--

CREATE TABLE IF NOT EXISTS `module_blog_link` (
  `id_blnk` bigint(20) NOT NULL AUTO_INCREMENT,
  `id_blog` bigint(20) NOT NULL DEFAULT '0',
  `order_blnk` bigint(10) NOT NULL DEFAULT '0',
  `name_blnk` varchar(100) NOT NULL DEFAULT '',
  `url_blnk` varchar(1024) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_blnk`),
  KEY `id_blog` (`id_blog`),
  KEY `order_blnk` (`order_blnk`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_blog_link`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_blog_page`
--

CREATE TABLE IF NOT EXISTS `module_blog_page` (
  `id_bpge` bigint(20) NOT NULL AUTO_INCREMENT,
  `id_blog` bigint(20) NOT NULL DEFAULT '0',
  `name_bpge` varchar(100) NOT NULL DEFAULT '',
  `content_bpge` text,
  `content_html_bpge` text,
  `format_bpge` varchar(10) NOT NULL DEFAULT 'wiki',
  `author_bpge` int(11) NOT NULL DEFAULT '0',
  `date_bpge` varchar(8) NOT NULL DEFAULT '',
  `url_bpge` varchar(100) NOT NULL DEFAULT '',
  `order_bpge` bigint(10) NOT NULL DEFAULT '0',
  `is_online` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id_bpge`),
  KEY `id_blog` (`id_blog`),
  KEY `order_bpge` (`order_bpge`),
  KEY `is_online` (`is_online`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

--
-- Contenu de la table `module_blog_page`
--

INSERT INTO `module_blog_page` (`id_bpge`, `id_blog`, `name_bpge`, `content_bpge`, `content_html_bpge`, `format_bpge`, `author_bpge`, `date_bpge`, `url_bpge`, `order_bpge`, `is_online`) VALUES
(1, 1, 'Bienvenue à Iconito Ecole Numérique 2012 !', '<p>\r\n	<img class="left" alt="Bo&icirc;te" src="/static/classeur/1-49376fcb9d/3-2c8c12e0c6_240.png" />Iconito Ecole Num&eacute;rique est un portail &eacute;ducatif comprenant un ensemble d&#39;outils et de ressources &agrave; destination des enseignants et des &eacute;l&egrave;ves, mais aussi des parents et des autres intervenants du syst&egrave;me scolaire.</p>\r\n<p>\r\n	Il est d&eacute;velopp&eacute; sous licence libre (GNU GPL). Vous trouverez plus d&#39;informations sur le site d&eacute;di&eacute; <strong><a href="http://www.iconito.fr/" target="_blank" title="Site web d''iconito">iconito.fr</a></strong></p>\r\n<p>\r\n	Cette &eacute;dition 2012 vous propose une nouvelle approche ergonomique que nous esp&eacute;rons plus claire qu&#39;avant. De nouvelles fonctionnalit&eacute;s sont &eacute;galement disponibles, dont la Gestion des Usagers int&eacute;gr&eacute;e ou les Quiz dans les groupes de travail. Pour d&#39;autres informations, n&#39;h&eacute;sitez pas &agrave; consulter notre <strong><a href="http://www.iconito.fr/telechargement/documentation/62-utilisation-ecole-numerique/154-apercu-des-nouveautes-diconito-ecole-numerique-2010" target="_blank" title="Nouveautés Iconito Ecole Numérique 2012">aper&ccedil;u des nouveaut&eacute;s Iconito Ecole Num&eacute;rique 2012</a></strong></p>\r\n', '<p>\r\n	<img class="left" alt="Bo&icirc;te" src="/static/album/1_b3ce1d6dcb/1_2c8c12e0c6_240.png" />Iconito Ecole Num&eacute;rique est un portail &eacute;ducatif comprenant un ensemble d&#39;outils et de ressources &agrave; destination des enseignants et des &eacute;l&egrave;ves, mais aussi des parents et des autres intervenants du syst&egrave;me scolaire.</p>\r\n<p>\r\n	Il est d&eacute;velopp&eacute; sous licence libre (GNU GPL). Vous trouverez plus d&#39;informations sur le site d&eacute;di&eacute; <strong><a href="http://www.iconito.fr/" target="_blank" title="Site web d''iconito">iconito.fr</a></strong></p>\r\n<p>\r\n	Cette &eacute;dition 2012 vous propose une nouvelle approche ergonomique que nous esp&eacute;rons plus claire qu&#39;avant. De nouvelles fonctionnalit&eacute;s sont &eacute;galement disponibles, dont la Gestion des Usagers int&eacute;gr&eacute;e ou les Quiz dans les groupes de travail. Pour d&#39;autres informations, n&#39;h&eacute;sitez pas &agrave; consulter notre <strong><a href="http://www.iconito.fr/telechargement/documentation/62-utilisation-ecole-numerique/154-apercu-des-nouveautes-diconito-ecole-numerique-2010" target="_blank" title="Nouveautés Iconito Ecole Numérique 2012">aper&ccedil;u des nouveaut&eacute;s Iconito Ecole Num&eacute;rique 2012</a></strong></p>\r\n', 'ckeditor', 1, '20111004', 'bienvenue', 1, 1);

-- --------------------------------------------------------

--
-- Structure de la table `module_cahierdetextes`
--

CREATE TABLE IF NOT EXISTS `module_cahierdetextes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_cahierdetextes`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_cahierdetextes_domaine`
--

CREATE TABLE IF NOT EXISTS `module_cahierdetextes_domaine` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kernel_bu_ecole_classe_id` int(11) NOT NULL,
  `nom` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_classe` (`kernel_bu_ecole_classe_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_cahierdetextes_domaine`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_cahierdetextes_memo`
--

CREATE TABLE IF NOT EXISTS `module_cahierdetextes_memo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kernel_bu_ecole_classe_id` int(11) NOT NULL,
  `date_creation` varchar(14) NOT NULL,
  `date_validite` varchar(14) NOT NULL,
  `message` text NOT NULL,
  `avec_signature` tinyint(1) NOT NULL DEFAULT '0',
  `date_max_signature` varchar(14) DEFAULT NULL,
  `supprime` tinyint(1) NOT NULL DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_classe` (`kernel_bu_ecole_classe_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_cahierdetextes_memo`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_cahierdetextes_memo2eleve`
--

CREATE TABLE IF NOT EXISTS `module_cahierdetextes_memo2eleve` (
  `module_cahierdetextes_memo_id` int(11) NOT NULL,
  `kernel_bu_eleve_idEleve` int(11) NOT NULL,
  `signe_le` varchar(14) DEFAULT NULL,
  `commentaire` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`module_cahierdetextes_memo_id`,`kernel_bu_eleve_idEleve`),
  KEY `fk_memo` (`module_cahierdetextes_memo_id`),
  KEY `fk_eleve` (`kernel_bu_eleve_idEleve`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `module_cahierdetextes_memo2eleve`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_cahierdetextes_memo2files`
--

CREATE TABLE IF NOT EXISTS `module_cahierdetextes_memo2files` (
  `module_cahierdetextes_memo_id` int(11) NOT NULL,
  `module_files_type` varchar(64) NOT NULL,
  `module_malle_files_id` int(11) NOT NULL,
  PRIMARY KEY (`module_cahierdetextes_memo_id`,`module_malle_files_id`),
  KEY `fk_memo` (`module_cahierdetextes_memo_id`),
  KEY `fk_files` (`module_malle_files_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `module_cahierdetextes_memo2files`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_cahierdetextes_travail`
--

CREATE TABLE IF NOT EXISTS `module_cahierdetextes_travail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module_cahierdetextes_domaine_id` int(11) NOT NULL,
  `a_faire` tinyint(1) NOT NULL DEFAULT '0',
  `date_creation` varchar(14) NOT NULL,
  `date_realisation` varchar(14) DEFAULT NULL,
  `description` text NOT NULL,
  `a_rendre` tinyint(4) NOT NULL DEFAULT '0',
  `module_classeur_dossier_id` int(11) DEFAULT NULL,
  `supprime` tinyint(1) NOT NULL DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_domaine` (`module_cahierdetextes_domaine_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_cahierdetextes_travail`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_cahierdetextes_travail2eleve`
--

CREATE TABLE IF NOT EXISTS `module_cahierdetextes_travail2eleve` (
  `module_cahierdetextes_travail_id` int(11) NOT NULL,
  `kernel_bu_eleve_idEleve` int(11) NOT NULL,
  `rendu_le` datetime DEFAULT NULL,
  PRIMARY KEY (`module_cahierdetextes_travail_id`,`kernel_bu_eleve_idEleve`),
  KEY `fk_travail` (`module_cahierdetextes_travail_id`),
  KEY `fk_eleve` (`kernel_bu_eleve_idEleve`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `module_cahierdetextes_travail2eleve`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_cahierdetextes_travail2files`
--

CREATE TABLE IF NOT EXISTS `module_cahierdetextes_travail2files` (
  `module_cahierdetextes_travail_id` int(11) NOT NULL,
  `module_files_type` varchar(64) NOT NULL,
  `module_malle_files_id` int(11) NOT NULL,
  PRIMARY KEY (`module_cahierdetextes_travail_id`,`module_malle_files_id`),
  KEY `fk_travail` (`module_cahierdetextes_travail_id`),
  KEY `fk_files` (`module_malle_files_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `module_cahierdetextes_travail2files`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_carnet_messages`
--

CREATE TABLE IF NOT EXISTS `module_carnet_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `topic` int(11) NOT NULL DEFAULT '0',
  `eleve` int(11) NOT NULL DEFAULT '0',
  `message` text NOT NULL,
  `format` varchar(10) NOT NULL,
  `auteur` int(11) NOT NULL DEFAULT '0',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `topic` (`topic`),
  KEY `eleve` (`eleve`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_carnet_messages`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_carnet_topics`
--

CREATE TABLE IF NOT EXISTS `module_carnet_topics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `titre` varchar(150) NOT NULL DEFAULT '',
  `message` text NOT NULL,
  `format` varchar(10) NOT NULL,
  `createur` int(11) NOT NULL DEFAULT '0',
  `classe` int(11) NOT NULL DEFAULT '0',
  `date_creation` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `createur` (`createur`),
  KEY `classe` (`classe`),
  KEY `date_creation` (`date_creation`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_carnet_topics`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_carnet_topics_to`
--

CREATE TABLE IF NOT EXISTS `module_carnet_topics_to` (
  `topic` int(11) NOT NULL DEFAULT '0',
  `eleve` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`topic`,`eleve`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `module_carnet_topics_to`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_carnet_tracking`
--

CREATE TABLE IF NOT EXISTS `module_carnet_tracking` (
  `topic` int(11) NOT NULL DEFAULT '0',
  `utilisateur` int(11) NOT NULL DEFAULT '0',
  `eleve` int(11) NOT NULL DEFAULT '0',
  `last_visite` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`topic`,`utilisateur`,`eleve`),
  KEY `last_visite` (`last_visite`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `module_carnet_tracking`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_charte_chartes`
--

CREATE TABLE IF NOT EXISTS `module_charte_chartes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(75) NOT NULL,
  `file_url` varchar(500) NOT NULL,
  `file_id` int(11) unsigned DEFAULT NULL,
  `active` tinyint(2) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_type` (`user_type`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_charte_chartes`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_charte_users_validation`
--

CREATE TABLE IF NOT EXISTS `module_charte_users_validation` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) unsigned NOT NULL,
  `date` int(11) unsigned NOT NULL,
  `charte_id` int(11) unsigned NOT NULL,
  `user_type` varchar(75) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_charte_users_validation`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_classeur`
--

CREATE TABLE IF NOT EXISTS `module_classeur` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `titre` varchar(255) DEFAULT NULL,
  `cle` varchar(10) NOT NULL,
  `date_creation` datetime NOT NULL,
  `date_publication` datetime DEFAULT NULL,
  `public` tinyint(4) DEFAULT '0',
  `upload_fs` varchar(255) DEFAULT NULL,
  `upload_db` int(11) DEFAULT NULL,
  `upload_pw` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

--
-- Contenu de la table `module_classeur`
--

INSERT INTO `module_classeur` (`id`, `titre`, `cle`, `date_creation`, `date_publication`, `public`, `upload_fs`, `upload_db`, `upload_pw`) VALUES
(1, 'Edito', '49376fcb9d', '2011-10-04 10:52:39', NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Structure de la table `module_classeur_dossier`
--

CREATE TABLE IF NOT EXISTS `module_classeur_dossier` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module_classeur_id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `nom` varchar(255) NOT NULL,
  `nb_dossiers` int(11) NOT NULL DEFAULT '0',
  `nb_fichiers` int(11) NOT NULL DEFAULT '0',
  `taille` int(11) NOT NULL DEFAULT '0',
  `cle` varchar(10) NOT NULL,
  `casier` tinyint(4) DEFAULT '0',
  `date_creation` datetime NOT NULL,
  `user_type` varchar(64) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `date_publication` datetime DEFAULT NULL,
  `public` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fk_classeur` (`module_classeur_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=3 ;

--
-- Contenu de la table `module_classeur_dossier`
--

INSERT INTO `module_classeur_dossier` (`id`, `module_classeur_id`, `parent_id`, `nom`, `nb_dossiers`, `nb_fichiers`, `taille`, `cle`, `casier`, `date_creation`, `user_type`, `user_id`, `date_publication`, `public`) VALUES
(1, 1, 0, 'Photos défilantes', 0, 2, 154131, 'eefc8f8c50', 0, '2011-10-04 09:24:55', '', 0, NULL, NULL),
(2, 1, 0, 'Illustrations accueil', 0, 1, 19905, '3e1a0664bc', 0, '2011-10-04 09:24:55', '', 0, NULL, NULL);

-- --------------------------------------------------------

--
-- Structure de la table `module_classeur_fichier`
--

CREATE TABLE IF NOT EXISTS `module_classeur_fichier` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module_classeur_id` int(11) NOT NULL,
  `module_classeur_dossier_id` int(11) NOT NULL,
  `titre` varchar(255) DEFAULT NULL,
  `commentaire` varchar(255) DEFAULT NULL,
  `fichier` varchar(255) NOT NULL,
  `taille` int(11) NOT NULL,
  `type` varchar(64) NOT NULL,
  `cle` varchar(10) NOT NULL,
  `date_upload` datetime NOT NULL,
  `user_type` varchar(64) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_dossier` (`module_classeur_dossier_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=4 ;

--
-- Contenu de la table `module_classeur_fichier`
--

INSERT INTO `module_classeur_fichier` (`id`, `module_classeur_id`, `module_classeur_dossier_id`, `titre`, `commentaire`, `fichier`, `taille`, `type`, `cle`, `date_upload`, `user_type`, `user_id`) VALUES
(1, 1, 1, 'Un joli dessin', 'Un joli dessin', 'Un joli dessin.jpg', 107484, 'JPG', '7a646493bc', '2011-10-04 09:24:55', '', 0),
(2, 1, 1, 'Une famille', 'Une famille', 'Une famille.jpg', 46647, 'JPG', 'ce1960caf0', '2011-10-04 09:24:55', '', 0),
(3, 1, 2, 'Boîte', NULL, 'Boîte.png', 19905, 'PNG', '2c8c12e0c6', '2011-10-04 09:24:55', '', 0);

-- --------------------------------------------------------

--
-- Structure de la table `module_contacts`
--

CREATE TABLE IF NOT EXISTS `module_contacts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `titre` varchar(100) NOT NULL,
  `email` varchar(255) DEFAULT NULL COMMENT 'Email du destinataire. Si plusieurs, separer par des virgules',
  `date_creation` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_contacts`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_contacts_messages`
--

CREATE TABLE IF NOT EXISTS `module_contacts_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `contact` int(11) NOT NULL,
  `from_nom` varchar(150) NOT NULL,
  `from_email` varchar(150) NOT NULL,
  `from_login` varchar(32) DEFAULT NULL,
  `from_user_id` int(11) DEFAULT NULL,
  `to_email` varchar(255) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `message` text NOT NULL,
  `ip` varchar(20) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `contact` (`contact`),
  KEY `type` (`type`),
  KEY `from_user_id` (`from_user_id`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_contacts_messages`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_contacts_types`
--

CREATE TABLE IF NOT EXISTS `module_contacts_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `contact` int(11) NOT NULL,
  `nom` varchar(50) NOT NULL,
  `is_default` tinyint(4) DEFAULT NULL,
  `ordre` smallint(6) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `contact` (`contact`),
  KEY `ordre` (`ordre`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_contacts_types`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_fiches_ecoles`
--

CREATE TABLE IF NOT EXISTS `module_fiches_ecoles` (
  `id` int(11) NOT NULL,
  `horaires` text,
  `zone_ville_titre` varchar(200) DEFAULT NULL,
  `zone_ville_texte` text,
  `zone1_titre` varchar(200) DEFAULT NULL,
  `zone1_texte` text,
  `zone2_titre` varchar(200) DEFAULT NULL,
  `zone2_texte` text,
  `zone3_titre` varchar(200) DEFAULT NULL,
  `zone3_texte` text,
  `zone4_titre` varchar(200) DEFAULT NULL,
  `zone4_texte` text,
  `photo` varchar(200) DEFAULT NULL,
  `doc1_titre` varchar(200) DEFAULT NULL,
  `doc1_fichier` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `module_fiches_ecoles`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_forum_forums`
--

CREATE TABLE IF NOT EXISTS `module_forum_forums` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `titre` varchar(100) NOT NULL DEFAULT '',
  `date_creation` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `date_creation` (`date_creation`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_forum_forums`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_forum_messages`
--

CREATE TABLE IF NOT EXISTS `module_forum_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `topic` int(11) NOT NULL DEFAULT '0',
  `forum` int(11) NOT NULL DEFAULT '0',
  `auteur` int(11) NOT NULL DEFAULT '0',
  `message` text NOT NULL,
  `format` varchar(10) NOT NULL,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` tinyint(4) NOT NULL DEFAULT '1',
  `nb_alertes` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `topic` (`topic`),
  KEY `date` (`date`),
  KEY `status` (`status`),
  KEY `nb_alertes` (`nb_alertes`),
  KEY `auteur` (`auteur`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_forum_messages`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_forum_topics`
--

CREATE TABLE IF NOT EXISTS `module_forum_topics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `titre` varchar(150) NOT NULL DEFAULT '',
  `forum` int(11) NOT NULL DEFAULT '0',
  `date_creation` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `createur` int(11) NOT NULL DEFAULT '0',
  `nb_messages` int(11) NOT NULL DEFAULT '0',
  `nb_lectures` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(4) NOT NULL DEFAULT '1',
  `last_msg_id` int(11) DEFAULT NULL,
  `last_msg_auteur` int(11) DEFAULT NULL,
  `last_msg_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `forum` (`forum`),
  KEY `date_creation` (`date_creation`),
  KEY `status` (`status`),
  KEY `last_msg_date` (`last_msg_date`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_forum_topics`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_forum_tracking`
--

CREATE TABLE IF NOT EXISTS `module_forum_tracking` (
  `topic` int(11) NOT NULL DEFAULT '0',
  `utilisateur` int(11) NOT NULL DEFAULT '0',
  `last_visite` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`topic`,`utilisateur`),
  KEY `last_visite` (`last_visite`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `module_forum_tracking`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_getreq`
--

CREATE TABLE IF NOT EXISTS `module_getreq` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `parent` text NOT NULL,
  `enfants` text NOT NULL,
  `date` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_getreq`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_groupe_groupe`
--

CREATE TABLE IF NOT EXISTS `module_groupe_groupe` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `titre` varchar(100) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `is_open` tinyint(4) NOT NULL DEFAULT '0',
  `createur` int(11) NOT NULL DEFAULT '0',
  `date_creation` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

--
-- Contenu de la table `module_groupe_groupe`
--

INSERT INTO `module_groupe_groupe` (`id`, `titre`, `description`, `is_open`, `createur`, `date_creation`) VALUES
(1, 'Edito', 'Groupe destiné à gérer la page d''accueil', 0, 1, '2013-11-28 16:07:01');

-- --------------------------------------------------------

--
-- Structure de la table `module_grvilles_gr2ville`
--

CREATE TABLE IF NOT EXISTS `module_grvilles_gr2ville` (
  `id_groupe` int(11) NOT NULL,
  `id_ville` int(11) NOT NULL,
  `updated_at` datetime NOT NULL,
  `updated_by` varchar(50) NOT NULL,
  PRIMARY KEY (`id_groupe`,`id_ville`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `module_grvilles_gr2ville`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_liste_listes`
--

CREATE TABLE IF NOT EXISTS `module_liste_listes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `titre` varchar(100) NOT NULL DEFAULT '',
  `date_creation` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `date_creation` (`date_creation`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_liste_listes`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_liste_messages`
--

CREATE TABLE IF NOT EXISTS `module_liste_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `liste` int(11) NOT NULL DEFAULT '0',
  `titre` varchar(150) NOT NULL DEFAULT '',
  `message` text NOT NULL,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `auteur` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `liste` (`liste`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_liste_messages`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_logs_logs`
--

CREATE TABLE IF NOT EXISTS `module_logs_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `type` varchar(20) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `message` varchar(255) DEFAULT NULL,
  `mod_name` varchar(30) NOT NULL DEFAULT '',
  `mod_action` varchar(40) NOT NULL DEFAULT '',
  `user_id` int(11) DEFAULT '0',
  `user_login` varchar(30) DEFAULT NULL,
  `user_ip` varchar(15) NOT NULL DEFAULT '',
  `node_type` varchar(15) DEFAULT NULL,
  `node_id` int(11) DEFAULT NULL,
  `module_type` varchar(20) DEFAULT NULL,
  `module_id` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=3 ;

--
-- Contenu de la table `module_logs_logs`
--

INSERT INTO `module_logs_logs` (`id`, `date`, `type`, `url`, `message`, `mod_name`, `mod_action`, `user_id`, `user_login`, `user_ip`, `node_type`, `node_id`, `module_type`, `module_id`) VALUES
(1, '2013-11-28 16:08:32', 'LOG', '', 'Login failed: admin/ico55', 'auth', 'in', NULL, NULL, '172.30.107.190', NULL, NULL, NULL, NULL),
(2, '2013-11-28 16:08:40', 'LOG', '', 'Login ok: admin', 'auth', 'in', 1, 'admin', '172.30.107.190', NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Structure de la table `module_magicmail`
--

CREATE TABLE IF NOT EXISTS `module_magicmail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `login` varchar(32) NOT NULL DEFAULT '',
  `domain` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

--
-- Contenu de la table `module_magicmail`
--

INSERT INTO `module_magicmail` (`id`, `login`, `domain`) VALUES
(1, '', '');

-- --------------------------------------------------------

--
-- Structure de la table `module_mailext`
--

CREATE TABLE IF NOT EXISTS `module_mailext` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) unsigned NOT NULL,
  `protocol` varchar(255) NOT NULL,
  `server` varchar(255) NOT NULL,
  `port` int(2) unsigned NOT NULL,
  `ssl` tinyint(2) unsigned NOT NULL,
  `tls` tinyint(2) unsigned NOT NULL,
  `login` varchar(150) NOT NULL,
  `pass` varchar(150) NOT NULL,
  `imap_path` varchar(150) DEFAULT NULL,
  `name` varchar(150) NOT NULL,
  `webmail_url` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_mailext`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_malle_files`
--

CREATE TABLE IF NOT EXISTS `module_malle_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `malle` int(11) NOT NULL DEFAULT '0',
  `folder` int(11) NOT NULL DEFAULT '0',
  `nom` varchar(200) NOT NULL DEFAULT '',
  `fichier` varchar(200) NOT NULL DEFAULT '',
  `taille` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL DEFAULT '',
  `cle` varchar(10) NOT NULL,
  `date_upload` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `malle` (`malle`),
  KEY `folder` (`folder`),
  KEY `nom` (`nom`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_malle_files`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_malle_folders`
--

CREATE TABLE IF NOT EXISTS `module_malle_folders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `malle` int(11) NOT NULL DEFAULT '0',
  `parent` int(11) NOT NULL DEFAULT '0',
  `nom` varchar(200) NOT NULL DEFAULT '',
  `nb_folders` int(11) NOT NULL DEFAULT '0',
  `nb_files` int(11) NOT NULL DEFAULT '0',
  `taille` int(11) NOT NULL DEFAULT '0',
  `date_creation` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `malle` (`malle`),
  KEY `parent` (`parent`),
  KEY `nom` (`nom`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_malle_folders`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_malle_malles`
--

CREATE TABLE IF NOT EXISTS `module_malle_malles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `titre` varchar(100) NOT NULL DEFAULT '',
  `date_creation` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `cle` varchar(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `date_creation` (`date_creation`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_malle_malles`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_minimail_from`
--

CREATE TABLE IF NOT EXISTS `module_minimail_from` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `from_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(80) NOT NULL DEFAULT '',
  `message` text NOT NULL,
  `format` varchar(10) NOT NULL,
  `date_send` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `attachment1` varchar(100) DEFAULT NULL,
  `attachment2` varchar(100) DEFAULT NULL,
  `attachment3` varchar(100) DEFAULT NULL,
  `is_deleted` tinyint(4) NOT NULL DEFAULT '0',
  `is_forwarded` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `from_id` (`from_id`),
  KEY `date_send` (`date_send`),
  KEY `is_deleted` (`is_deleted`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_minimail_from`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_minimail_to`
--

CREATE TABLE IF NOT EXISTS `module_minimail_to` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_message` int(11) NOT NULL DEFAULT '0',
  `to_id` int(11) NOT NULL DEFAULT '0',
  `date_read` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `is_read` tinyint(4) NOT NULL DEFAULT '0',
  `is_replied` tinyint(4) NOT NULL DEFAULT '0',
  `is_forwarded` tinyint(4) DEFAULT NULL,
  `is_deleted` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_message` (`id_message`),
  KEY `to_id` (`to_id`),
  KEY `is_read` (`is_read`),
  KEY `is_deleted` (`is_deleted`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_minimail_to`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_prefs_preferences`
--

CREATE TABLE IF NOT EXISTS `module_prefs_preferences` (
  `user` int(11) NOT NULL DEFAULT '0',
  `module` varchar(20) NOT NULL DEFAULT '',
  `code` varchar(30) NOT NULL DEFAULT '',
  `value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`user`,`module`,`code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `module_prefs_preferences`
--

INSERT INTO `module_prefs_preferences` (`user`, `module`, `code`, `value`) VALUES
(1, 'prefs', 'avatar', 'admin.png');

-- --------------------------------------------------------

--
-- Structure de la table `module_quiz_choices`
--

CREATE TABLE IF NOT EXISTS `module_quiz_choices` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_question` int(11) unsigned NOT NULL,
  `content` text,
  `correct` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `order` int(5) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_quiz_choices`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_quiz_groupes`
--

CREATE TABLE IF NOT EXISTS `module_quiz_groupes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_quiz_groupes`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_quiz_questions`
--

CREATE TABLE IF NOT EXISTS `module_quiz_questions` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(75) NOT NULL,
  `id_quiz` int(11) unsigned NOT NULL,
  `content` text,
  `order` int(5) unsigned NOT NULL,
  `opt_type` varchar(75) NOT NULL DEFAULT 'choice',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_quiz_questions`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_quiz_quiz`
--

CREATE TABLE IF NOT EXISTS `module_quiz_quiz` (
  `id` int(4) unsigned NOT NULL AUTO_INCREMENT,
  `id_owner` int(4) unsigned NOT NULL,
  `date_start` int(5) unsigned NOT NULL DEFAULT '0',
  `date_end` int(5) unsigned NOT NULL DEFAULT '0',
  `name` varchar(128) NOT NULL,
  `description` text,
  `help` text,
  `pic` varchar(255) DEFAULT NULL,
  `opt_save` varchar(75) NOT NULL,
  `opt_show_results` varchar(75) NOT NULL,
  `lock` tinyint(4) NOT NULL DEFAULT '0',
  `gr_id` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `gr_id` (`gr_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_quiz_quiz`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_quiz_responses`
--

CREATE TABLE IF NOT EXISTS `module_quiz_responses` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_user` int(11) unsigned NOT NULL,
  `id_choice` int(11) unsigned NOT NULL,
  `id_question` int(11) unsigned NOT NULL,
  `date` int(11) unsigned NOT NULL,
  `txt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_quiz_responses`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_regroupements_grecoles`
--

CREATE TABLE IF NOT EXISTS `module_regroupements_grecoles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nom` varchar(255) NOT NULL,
  `updated_at` datetime NOT NULL,
  `updated_by` varchar(49) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_regroupements_grecoles`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_regroupements_grecoles2ecoles`
--

CREATE TABLE IF NOT EXISTS `module_regroupements_grecoles2ecoles` (
  `id_groupe` int(11) NOT NULL,
  `id_ecole` int(11) NOT NULL,
  `updated_at` datetime NOT NULL,
  `updated_by` varchar(50) NOT NULL,
  PRIMARY KEY (`id_groupe`,`id_ecole`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `module_regroupements_grecoles2ecoles`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_regroupements_grvilles`
--

CREATE TABLE IF NOT EXISTS `module_regroupements_grvilles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nom` varchar(255) NOT NULL,
  `updated_at` datetime NOT NULL,
  `updated_by` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_regroupements_grvilles`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_regroupements_grvilles2villes`
--

CREATE TABLE IF NOT EXISTS `module_regroupements_grvilles2villes` (
  `id_groupe` int(11) NOT NULL,
  `id_ville` int(11) NOT NULL,
  `updated_at` datetime NOT NULL,
  `updated_by` varchar(50) NOT NULL,
  PRIMARY KEY (`id_groupe`,`id_ville`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `module_regroupements_grvilles2villes`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_ressource_annuaires`
--

CREATE TABLE IF NOT EXISTS `module_ressource_annuaires` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date_crea` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=3 ;

--
-- Contenu de la table `module_ressource_annuaires`
--

INSERT INTO `module_ressource_annuaires` (`id`, `date_crea`) VALUES
(2, '2013-11-28 16:07:01');

-- --------------------------------------------------------

--
-- Structure de la table `module_ressource_contenus`
--

CREATE TABLE IF NOT EXISTS `module_ressource_contenus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nom` varchar(255) NOT NULL DEFAULT '',
  `ordre` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=14 ;

--
-- Contenu de la table `module_ressource_contenus`
--

INSERT INTO `module_ressource_contenus` (`id`, `nom`, `ordre`) VALUES
(1, 'Scénarios pédagogiques', 1),
(2, 'Progressions et programmations', 2),
(3, 'Évaluations', 3),
(4, 'Sites pédagogiques', 4),
(5, 'Site pour les enfants', 5),
(6, 'Emplois du temps', 6),
(7, 'Autres sites', 7),
(8, 'Logiciels', 8),
(9, 'Images', 9),
(10, 'Vidéos', 10),
(11, 'Sons', 11),
(12, 'Trucs et astuces', 12),
(13, 'Encyclopédies/Dictionnaires', 13);

-- --------------------------------------------------------

--
-- Structure de la table `module_ressource_domaines`
--

CREATE TABLE IF NOT EXISTS `module_ressource_domaines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_niveau` int(11) NOT NULL DEFAULT '0',
  `nom` varchar(255) NOT NULL DEFAULT '',
  `parent` int(11) NOT NULL DEFAULT '0',
  `ordre` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=27 ;

--
-- Contenu de la table `module_ressource_domaines`
--

INSERT INTO `module_ressource_domaines` (`id`, `id_niveau`, `nom`, `parent`, `ordre`) VALUES
(1, 1, 'Le langage au cœur des apprentissages', 0, 1),
(2, 1, 'Vivre ensemble', 0, 2),
(3, 1, 'Agir et s''exprimer avec son corps', 0, 3),
(4, 1, 'Découvrir le monde', 0, 4),
(5, 1, 'La sensibilité, l''imagination, la création', 0, 5),
(6, 1, 'Compétences transversales', 0, 6),
(7, 2, 'Maîtrise du langage et de la langue française', 0, 1),
(8, 2, 'Vivre ensemble', 0, 2),
(9, 2, 'Mathématiques', 0, 3),
(10, 2, 'Découvrir le monde', 0, 4),
(11, 2, 'Langues étrangères ou régionales', 0, 5),
(12, 2, 'Éducation artistique', 0, 6),
(13, 2, 'Éducation physique et sportive', 0, 7),
(14, 3, 'Maîtrise du langage et de la langue française', 0, 1),
(15, 3, 'Observation réfléchie de la langue française', 0, 2),
(16, 3, 'Langue étrangère ou régionale', 0, 3),
(17, 3, 'Histoire', 0, 4),
(18, 3, 'Géographie', 0, 5),
(19, 3, 'Education civique', 0, 6),
(20, 3, 'Vie collective (débat réglé)', 0, 7),
(21, 3, 'Mathématiques', 0, 8),
(22, 3, 'Sciences expérimentales et technologie', 0, 9),
(23, 3, 'Éducation musicale', 0, 10),
(24, 3, 'Arts visuels', 0, 11),
(25, 3, 'EPS: Activités physiques, sportives et artistiques, et compétences spécifiques', 0, 12),
(26, 3, 'B2I: Mise en place du B2I niveau 1', 0, 13);

-- --------------------------------------------------------

--
-- Structure de la table `module_ressource_fonctions`
--

CREATE TABLE IF NOT EXISTS `module_ressource_fonctions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nom` varchar(255) NOT NULL DEFAULT '',
  `ordre` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=5 ;

--
-- Contenu de la table `module_ressource_fonctions`
--

INSERT INTO `module_ressource_fonctions` (`id`, `nom`, `ordre`) VALUES
(1, 'Pour préparer la classe', 1),
(2, 'Pour gérer une école', 2),
(3, 'Pour se former et s''informer', 3),
(4, 'Pour l''accompagnement et le soutien scolaire', 4);

-- --------------------------------------------------------

--
-- Structure de la table `module_ressource_licences`
--

CREATE TABLE IF NOT EXISTS `module_ressource_licences` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nom` varchar(255) NOT NULL DEFAULT '',
  `ordre` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=13 ;

--
-- Contenu de la table `module_ressource_licences`
--

INSERT INTO `module_ressource_licences` (`id`, `nom`, `ordre`) VALUES
(1, 'GNU Gerenal Public Licence (GPL)', 1),
(2, 'GNU Lesser General Public License (LGPL)', 2),
(3, 'GNU Free Documentation License (FDL)', 3),
(4, 'Licence Art Libre (Free Art)', 4),
(5, 'Public Domain', 5),
(6, 'Creative Commons (by)', 6),
(7, 'Creative Commons (by-nd)', 7),
(8, 'Creative Commons (by-nc-nd)', 8),
(9, 'Creative Commons (by-nc)', 9),
(10, 'Creative Commons (by-nc-sa)', 10),
(11, 'Creative Commons (by-sa)', 11),
(12, 'Autre licence libre', 9999);

-- --------------------------------------------------------

--
-- Structure de la table `module_ressource_niveaux`
--

CREATE TABLE IF NOT EXISTS `module_ressource_niveaux` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nom` varchar(255) NOT NULL DEFAULT '',
  `description` varchar(255) NOT NULL DEFAULT '',
  `age_min` int(11) DEFAULT NULL,
  `age_max` int(11) DEFAULT NULL,
  `ordre` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=4 ;

--
-- Contenu de la table `module_ressource_niveaux`
--

INSERT INTO `module_ressource_niveaux` (`id`, `nom`, `description`, `age_min`, `age_max`, `ordre`) VALUES
(1, 'Cycle 1', 'Maternelle : PS MS', NULL, NULL, 1),
(2, 'Cycle 2', 'Maternelle : GS, Primaire : CP CE1', NULL, NULL, 2),
(3, 'Cycle 3', 'Primaire : CE2 CM1 CM2', NULL, NULL, 3);

-- --------------------------------------------------------

--
-- Structure de la table `module_ressource_res2contenu`
--

CREATE TABLE IF NOT EXISTS `module_ressource_res2contenu` (
  `id_ressource` int(11) NOT NULL DEFAULT '0',
  `id_contenu` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_ressource`,`id_contenu`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `module_ressource_res2contenu`
--

INSERT INTO `module_ressource_res2contenu` (`id_ressource`, `id_contenu`) VALUES
(17, 1),
(17, 4),
(17, 12),
(19, 1),
(20, 1),
(21, 1),
(21, 3),
(22, 12),
(24, 13),
(25, 7),
(26, 3),
(28, 5),
(29, 5),
(29, 13),
(30, 5),
(30, 13),
(31, 5),
(32, 5),
(33, 5),
(34, 5),
(35, 5),
(35, 13),
(36, 5),
(36, 9),
(37, 5),
(38, 5),
(39, 5),
(40, 5),
(41, 5),
(42, 4),
(42, 5),
(43, 4),
(43, 5),
(43, 9),
(43, 13),
(44, 5),
(45, 4),
(45, 5),
(46, 1),
(46, 5),
(47, 1),
(47, 2),
(48, 1),
(50, 1),
(51, 1),
(51, 2),
(52, 1),
(53, 1),
(53, 2),
(54, 1),
(57, 1),
(57, 8),
(58, 5),
(59, 9),
(60, 1),
(60, 5),
(60, 7),
(61, 1),
(62, 5),
(63, 5),
(64, 5),
(64, 13),
(65, 1),
(65, 5),
(66, 5),
(67, 8),
(68, 8),
(69, 4),
(69, 7),
(70, 8),
(71, 8),
(72, 5),
(73, 5),
(73, 9),
(74, 1),
(74, 8),
(75, 5),
(76, 1),
(77, 9),
(78, 1),
(78, 5),
(79, 5),
(79, 9),
(80, 8),
(81, 8),
(82, 8),
(83, 8),
(84, 8),
(85, 8),
(86, 8),
(87, 8),
(88, 8),
(89, 8),
(90, 4),
(91, 1),
(92, 5),
(93, 5),
(94, 5),
(95, 5),
(96, 2),
(97, 4),
(98, 1),
(98, 4),
(98, 9),
(98, 10),
(98, 11),
(98, 13),
(99, 1),
(99, 12),
(100, 1),
(101, 5),
(102, 8),
(103, 8),
(103, 9),
(104, 1),
(104, 5),
(104, 8),
(105, 8),
(106, 1),
(106, 8),
(107, 1),
(107, 8),
(108, 1),
(108, 8),
(108, 9),
(109, 5),
(110, 5),
(111, 5),
(112, 5),
(113, 5),
(114, 5),
(115, 5),
(116, 5),
(117, 5),
(118, 1),
(118, 4),
(118, 5),
(118, 12),
(119, 1),
(120, 5),
(121, 5),
(123, 1),
(123, 9),
(123, 10),
(124, 1),
(125, 8),
(125, 9),
(126, 5),
(126, 8),
(127, 5),
(129, 5),
(129, 8),
(130, 2),
(131, 2),
(131, 3),
(132, 1),
(132, 2),
(132, 10),
(133, 11),
(135, 5),
(136, 9),
(136, 11),
(137, 8),
(138, 8),
(139, 8),
(140, 12),
(141, 3),
(142, 11),
(143, 13),
(144, 9),
(144, 13),
(145, 8),
(146, 12),
(147, 5),
(148, 4),
(149, 12),
(151, 12),
(153, 5),
(153, 8),
(154, 13),
(155, 13),
(156, 13),
(157, 13),
(158, 5),
(158, 13),
(159, 5),
(159, 13),
(160, 5),
(161, 13),
(162, 5),
(162, 13),
(163, 5),
(164, 5),
(164, 13),
(165, 5),
(165, 13),
(166, 4),
(166, 13),
(167, 5),
(167, 13),
(168, 5),
(169, 5),
(170, 5),
(171, 1),
(172, 4),
(173, 1),
(173, 2),
(173, 4),
(174, 1),
(174, 2),
(175, 1),
(177, 1),
(178, 2),
(180, 1),
(180, 2),
(181, 5),
(181, 13),
(182, 8),
(182, 12),
(183, 13),
(184, 4),
(185, 1),
(186, 1),
(187, 1),
(188, 1),
(189, 1),
(191, 1),
(192, 1),
(193, 1),
(194, 2),
(194, 3),
(195, 2),
(195, 3),
(196, 1),
(197, 2),
(197, 3),
(198, 2),
(198, 3),
(199, 2),
(199, 3),
(201, 5),
(201, 8),
(202, 5),
(202, 8),
(203, 8),
(204, 8),
(205, 8),
(206, 8),
(207, 8),
(208, 8),
(209, 8),
(213, 7),
(214, 1),
(215, 7),
(216, 1),
(216, 2),
(216, 8),
(216, 10),
(217, 11),
(225, 1),
(226, 2),
(230, 3),
(231, 3),
(232, 3),
(233, 3),
(234, 1),
(234, 3),
(236, 1),
(236, 3),
(237, 1),
(237, 3),
(239, 7),
(240, 7),
(242, 3),
(243, 3),
(244, 3),
(248, 3),
(249, 7),
(250, 7),
(251, 3),
(251, 7),
(252, 3),
(253, 3),
(253, 7),
(254, 3),
(254, 7),
(255, 7),
(260, 7),
(261, 7),
(262, 7),
(263, 4),
(264, 4),
(266, 4),
(269, 4),
(270, 1),
(271, 1),
(271, 9),
(272, 2),
(272, 4),
(272, 5),
(273, 9),
(274, 8),
(275, 8),
(276, 8),
(277, 9),
(279, 9),
(280, 5),
(281, 7),
(282, 5),
(283, 7),
(284, 7),
(285, 11),
(286, 11),
(287, 11),
(288, 11),
(289, 7),
(290, 11),
(291, 7),
(291, 11),
(292, 5),
(293, 11),
(294, 7),
(295, 7),
(295, 9),
(296, 7),
(297, 5),
(297, 9),
(297, 11),
(298, 5),
(298, 10),
(299, 5),
(300, 10),
(301, 7),
(301, 10),
(302, 7),
(302, 9),
(303, 7),
(303, 10),
(304, 5),
(304, 10),
(305, 5),
(305, 10),
(306, 7),
(307, 5),
(308, 8),
(309, 8),
(310, 8),
(311, 8),
(312, 8),
(313, 8),
(314, 8),
(315, 8),
(316, 1),
(317, 1),
(318, 4),
(319, 1),
(320, 4),
(321, 11),
(322, 1),
(323, 1),
(325, 10),
(326, 5),
(327, 1),
(327, 5),
(328, 5),
(329, 5),
(330, 5),
(331, 5),
(332, 5),
(333, 5),
(334, 5),
(335, 5),
(336, 5),
(337, 5),
(338, 5),
(339, 5),
(340, 5),
(341, 1),
(342, 5),
(343, 5),
(344, 5),
(345, 5),
(347, 11),
(348, 8),
(349, 8),
(350, 8),
(351, 8),
(352, 8),
(353, 8),
(354, 8),
(355, 8),
(356, 8),
(357, 8),
(358, 8),
(359, 8),
(360, 8),
(361, 8),
(362, 8),
(363, 8),
(365, 8),
(367, 12),
(368, 11),
(369, 5),
(369, 8),
(370, 5),
(370, 8),
(371, 5),
(371, 8),
(372, 5),
(372, 8),
(373, 5),
(373, 8),
(374, 5),
(374, 8),
(375, 5),
(375, 8),
(376, 5),
(376, 8),
(377, 5),
(377, 8),
(378, 5),
(378, 8),
(379, 7),
(380, 7),
(380, 9),
(381, 1),
(381, 12),
(382, 10),
(384, 5),
(384, 8),
(385, 9),
(385, 12),
(387, 7),
(388, 13),
(390, 13),
(392, 5),
(394, 13),
(395, 13),
(396, 13),
(397, 13),
(398, 13),
(399, 13),
(400, 13),
(401, 1),
(401, 2),
(401, 4),
(401, 12),
(404, 11),
(405, 8),
(405, 13),
(406, 8),
(406, 13),
(407, 8),
(408, 2),
(408, 12),
(409, 12),
(410, 5),
(411, 4),
(411, 13),
(412, 4),
(413, 4),
(414, 4),
(415, 4),
(416, 4),
(417, 9),
(418, 12),
(419, 9),
(420, 5),
(420, 8),
(421, 5),
(421, 8),
(422, 5),
(422, 8),
(423, 5),
(424, 5),
(425, 8),
(425, 13),
(426, 8),
(427, 5),
(427, 8),
(428, 8),
(429, 8),
(430, 8),
(431, 8),
(432, 8),
(433, 7),
(434, 8),
(435, 8),
(437, 2),
(438, 2),
(439, 5),
(439, 8),
(440, 8),
(441, 5),
(442, 5),
(442, 8),
(443, 5),
(443, 8),
(444, 5),
(444, 8),
(445, 2),
(446, 2),
(447, 4),
(448, 4),
(449, 4),
(450, 2),
(451, 2),
(452, 4),
(453, 1),
(453, 2),
(454, 4),
(455, 2),
(455, 4),
(458, 4),
(460, 4),
(461, 4),
(463, 7),
(464, 7),
(465, 7),
(466, 7),
(467, 7),
(471, 5),
(471, 8),
(472, 5),
(472, 8),
(473, 5),
(473, 8),
(475, 5),
(475, 11),
(476, 5),
(476, 8),
(477, 5),
(477, 8),
(478, 5),
(478, 8),
(479, 8),
(481, 1),
(481, 4),
(482, 1),
(483, 7),
(484, 1),
(486, 4),
(487, 7),
(489, 12),
(490, 1),
(491, 5),
(492, 5),
(492, 7),
(492, 8),
(493, 8),
(494, 8),
(495, 8),
(496, 8),
(497, 8),
(498, 8),
(499, 8),
(500, 8),
(501, 8),
(502, 8),
(503, 8),
(504, 8),
(505, 8),
(506, 8),
(507, 8),
(508, 8),
(509, 8),
(510, 8),
(511, 8),
(512, 8),
(513, 8),
(514, 8),
(515, 5),
(516, 8),
(517, 8),
(518, 8),
(519, 8),
(520, 8),
(521, 8),
(522, 8),
(523, 8),
(524, 8),
(525, 8),
(526, 8),
(527, 12),
(528, 8),
(529, 8),
(530, 8),
(531, 8),
(532, 8),
(533, 8),
(534, 8),
(535, 8),
(536, 8),
(537, 1),
(537, 2),
(539, 1),
(539, 2),
(539, 3),
(540, 2),
(540, 3),
(541, 5),
(542, 5),
(542, 8),
(543, 5),
(544, 5),
(545, 5),
(546, 5),
(547, 5),
(548, 5),
(549, 5),
(550, 5),
(551, 5),
(552, 5),
(553, 5),
(554, 5),
(555, 5),
(556, 5),
(557, 5),
(558, 5),
(559, 5),
(560, 5),
(561, 5),
(562, 5),
(562, 13),
(563, 5),
(564, 5),
(565, 5),
(566, 5),
(567, 5),
(568, 5),
(568, 12),
(569, 5),
(569, 13),
(570, 5),
(570, 13),
(571, 13),
(572, 9),
(573, 5),
(574, 5),
(575, 1),
(575, 2),
(577, 5),
(578, 5),
(579, 5),
(580, 5),
(581, 5),
(582, 5),
(583, 5),
(584, 5),
(585, 5),
(586, 7),
(587, 5),
(588, 5),
(589, 5),
(589, 13),
(590, 7),
(591, 7),
(592, 7),
(593, 7),
(595, 7),
(596, 7),
(597, 7),
(597, 13),
(598, 7),
(598, 13),
(599, 7),
(600, 13),
(601, 7),
(602, 7),
(603, 7),
(603, 13),
(604, 7),
(605, 7),
(605, 13),
(606, 7),
(607, 7),
(608, 7),
(609, 7),
(610, 7),
(611, 4),
(612, 5),
(613, 7),
(614, 7),
(615, 5),
(615, 10),
(616, 5),
(616, 10),
(617, 7),
(617, 9),
(618, 7),
(619, 7),
(620, 7),
(620, 13),
(621, 7),
(622, 7),
(622, 9),
(623, 7),
(624, 7),
(625, 5),
(626, 7),
(627, 7),
(628, 7),
(629, 5),
(630, 5),
(630, 10),
(631, 5),
(631, 10),
(632, 5),
(633, 7),
(633, 10),
(634, 5),
(635, 5),
(636, 7),
(637, 7),
(637, 9),
(638, 7),
(639, 7),
(639, 13),
(640, 13),
(641, 10),
(642, 7),
(643, 5),
(643, 10),
(644, 4),
(645, 8),
(646, 7),
(647, 8),
(648, 8),
(650, 7),
(650, 9),
(651, 8),
(652, 8),
(653, 12),
(654, 7),
(655, 8),
(656, 7),
(656, 8),
(657, 8),
(658, 8),
(659, 8),
(660, 8),
(661, 8),
(662, 8),
(663, 8),
(664, 7),
(665, 5),
(665, 7),
(665, 8),
(666, 8),
(667, 8),
(667, 13),
(668, 13),
(669, 8),
(669, 13),
(670, 7),
(671, 7),
(672, 7),
(672, 13),
(673, 7),
(673, 9),
(674, 8),
(675, 5),
(675, 8),
(676, 5),
(676, 7),
(677, 5),
(678, 7),
(679, 5),
(680, 5),
(681, 5),
(682, 7),
(683, 5),
(684, 8),
(685, 8),
(686, 8),
(687, 8),
(688, 8),
(689, 12),
(690, 8),
(690, 12),
(691, 8),
(691, 9),
(692, 8),
(693, 8),
(694, 5),
(695, 1),
(696, 5),
(696, 13),
(698, 1),
(698, 7),
(698, 13),
(699, 5),
(699, 8),
(700, 5),
(700, 8),
(701, 5),
(701, 13),
(702, 7),
(703, 5),
(704, 8),
(705, 5),
(705, 8),
(706, 4),
(707, 5),
(707, 8),
(708, 8),
(709, 5),
(710, 5),
(711, 5),
(712, 5),
(713, 7),
(714, 5),
(715, 5),
(715, 10),
(716, 5),
(716, 10),
(717, 13),
(718, 5),
(719, 5),
(719, 10),
(720, 5),
(721, 13),
(722, 5),
(723, 5),
(724, 7),
(725, 7),
(726, 5),
(727, 5),
(728, 5),
(729, 5),
(730, 5),
(731, 7),
(732, 9),
(733, 5),
(734, 5),
(734, 11),
(735, 5),
(736, 5),
(737, 7),
(738, 5),
(739, 5),
(740, 5),
(741, 5),
(741, 10),
(741, 11),
(742, 5),
(742, 10),
(743, 5),
(743, 10),
(744, 5),
(744, 10),
(745, 7),
(746, 7),
(747, 7),
(747, 12),
(748, 7),
(749, 1),
(749, 5),
(750, 1),
(751, 5),
(752, 1),
(753, 5),
(754, 5),
(755, 5),
(756, 5),
(757, 1),
(757, 5),
(758, 8),
(759, 8),
(760, 5),
(761, 5),
(762, 5),
(763, 8),
(765, 5),
(766, 3),
(767, 5),
(768, 2),
(769, 7),
(769, 9),
(770, 5),
(770, 9),
(771, 5),
(771, 8),
(772, 5),
(773, 5),
(774, 5),
(776, 8),
(777, 8),
(778, 8),
(779, 8),
(780, 8),
(781, 8),
(782, 8),
(783, 8),
(784, 4),
(785, 8),
(786, 8),
(787, 8),
(788, 8),
(789, 8),
(790, 8),
(791, 8),
(792, 8),
(793, 8),
(794, 8),
(795, 8),
(796, 8),
(797, 8),
(798, 11),
(799, 5),
(800, 5),
(801, 5),
(802, 5),
(804, 5),
(804, 7),
(806, 1),
(807, 5),
(808, 1),
(809, 1),
(810, 1),
(811, 1),
(812, 1),
(813, 1),
(814, 1),
(816, 5),
(817, 5),
(821, 5),
(822, 5),
(824, 7),
(825, 5),
(826, 7),
(827, 8),
(828, 8),
(829, 7),
(832, 7),
(833, 8),
(834, 7),
(835, 5),
(836, 5),
(838, 7),
(838, 13),
(839, 11),
(841, 11),
(842, 8),
(843, 8),
(844, 8),
(845, 8),
(846, 7),
(847, 7),
(848, 5),
(849, 5),
(850, 8),
(851, 5),
(852, 5),
(853, 7),
(854, 13),
(855, 7),
(856, 7),
(858, 7),
(859, 8),
(860, 4),
(861, 5),
(861, 8),
(862, 5),
(862, 8),
(863, 1),
(864, 7),
(865, 8),
(866, 8),
(867, 8),
(867, 11),
(868, 8),
(868, 9),
(869, 8),
(870, 8),
(871, 8),
(871, 11),
(872, 8),
(873, 8),
(874, 8),
(874, 9),
(875, 8),
(876, 8),
(877, 8),
(878, 8),
(879, 8),
(880, 8),
(881, 8),
(882, 8),
(882, 13),
(883, 8),
(884, 8),
(885, 8),
(886, 8),
(887, 1),
(887, 8),
(888, 8),
(889, 8),
(890, 8),
(891, 8),
(892, 8),
(893, 8),
(894, 8),
(895, 8),
(896, 8),
(897, 8),
(898, 8),
(899, 8),
(900, 8),
(901, 1),
(901, 8),
(902, 1),
(902, 8),
(903, 1),
(903, 8),
(904, 8),
(905, 1),
(905, 8),
(906, 1),
(906, 8),
(907, 8),
(908, 8),
(909, 1),
(909, 8),
(910, 8),
(911, 1),
(911, 8),
(912, 1),
(912, 8),
(913, 1),
(913, 8),
(914, 4),
(915, 2),
(916, 1),
(920, 7),
(921, 1),
(921, 4),
(922, 7),
(923, 4),
(924, 5),
(925, 4),
(926, 7),
(927, 7),
(928, 5),
(929, 5),
(930, 5),
(931, 5),
(933, 4),
(934, 1),
(934, 2),
(934, 4),
(934, 9),
(935, 7),
(936, 5),
(937, 7),
(938, 4),
(940, 5),
(953, 5),
(954, 4),
(955, 4),
(956, 4),
(959, 8),
(960, 8),
(961, 7),
(961, 11),
(962, 4),
(963, 7),
(963, 11),
(964, 7),
(964, 11),
(965, 7),
(965, 11),
(966, 7),
(966, 11),
(968, 7),
(968, 11),
(969, 7),
(970, 4),
(971, 4),
(972, 8),
(973, 8),
(974, 8),
(975, 8);

-- --------------------------------------------------------

--
-- Structure de la table `module_ressource_res2domaine`
--

CREATE TABLE IF NOT EXISTS `module_ressource_res2domaine` (
  `id_ressource` int(11) NOT NULL DEFAULT '0',
  `id_domaine` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_ressource`,`id_domaine`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `module_ressource_res2domaine`
--

INSERT INTO `module_ressource_res2domaine` (`id_ressource`, `id_domaine`) VALUES
(19, 1),
(19, 4),
(19, 7),
(19, 10),
(20, 1),
(21, 10),
(21, 18),
(21, 22),
(25, 1),
(25, 7),
(25, 14),
(26, 26),
(28, 1),
(28, 2),
(28, 3),
(28, 4),
(28, 5),
(28, 6),
(28, 7),
(28, 8),
(28, 9),
(28, 10),
(28, 11),
(28, 12),
(28, 13),
(28, 14),
(28, 15),
(28, 16),
(28, 17),
(28, 18),
(28, 19),
(28, 20),
(28, 21),
(28, 22),
(28, 23),
(28, 24),
(28, 25),
(28, 26),
(29, 7),
(29, 14),
(29, 15),
(30, 7),
(30, 14),
(30, 15),
(31, 7),
(31, 14),
(31, 15),
(32, 9),
(32, 21),
(33, 9),
(33, 21),
(34, 10),
(34, 18),
(35, 17),
(36, 10),
(36, 22),
(37, 22),
(38, 22),
(39, 14),
(39, 15),
(39, 16),
(39, 17),
(39, 18),
(39, 19),
(39, 20),
(39, 21),
(39, 22),
(39, 24),
(39, 25),
(39, 26),
(40, 12),
(40, 24),
(41, 12),
(41, 24),
(42, 4),
(42, 12),
(42, 23),
(43, 10),
(43, 17),
(43, 18),
(43, 19),
(43, 22),
(43, 24),
(44, 26),
(45, 4),
(45, 10),
(46, 4),
(46, 10),
(46, 22),
(47, 3),
(47, 10),
(47, 22),
(48, 1),
(48, 2),
(48, 4),
(48, 7),
(48, 8),
(48, 10),
(48, 14),
(48, 19),
(48, 22),
(49, 2),
(49, 8),
(49, 19),
(50, 1),
(51, 2),
(51, 8),
(51, 19),
(52, 1),
(52, 2),
(53, 8),
(53, 19),
(53, 20),
(54, 1),
(54, 2),
(54, 8),
(54, 19),
(54, 20),
(57, 14),
(57, 24),
(57, 26),
(58, 7),
(58, 8),
(58, 12),
(58, 14),
(58, 24),
(58, 26),
(59, 12),
(59, 24),
(59, 26),
(60, 7),
(60, 12),
(60, 14),
(60, 24),
(61, 24),
(61, 26),
(62, 7),
(62, 8),
(62, 10),
(62, 14),
(62, 17),
(62, 18),
(63, 11),
(63, 16),
(64, 7),
(64, 10),
(64, 14),
(64, 15),
(64, 18),
(64, 22),
(65, 10),
(65, 22),
(66, 10),
(66, 17),
(67, 5),
(67, 12),
(67, 23),
(68, 12),
(68, 23),
(70, 1),
(70, 7),
(70, 14),
(71, 1),
(71, 7),
(72, 22),
(73, 22),
(74, 22),
(75, 22),
(76, 10),
(76, 19),
(76, 22),
(77, 4),
(77, 10),
(77, 22),
(78, 22),
(79, 10),
(79, 22),
(80, 1),
(80, 4),
(80, 10),
(81, 4),
(81, 6),
(82, 1),
(82, 7),
(83, 6),
(83, 7),
(83, 10),
(84, 4),
(84, 9),
(84, 21),
(85, 9),
(85, 21),
(86, 6),
(86, 7),
(86, 8),
(86, 9),
(86, 10),
(86, 11),
(86, 12),
(86, 13),
(86, 14),
(86, 15),
(86, 16),
(86, 17),
(86, 18),
(86, 20),
(86, 21),
(86, 22),
(86, 23),
(86, 24),
(87, 21),
(88, 21),
(89, 4),
(89, 9),
(89, 21),
(90, 14),
(91, 10),
(91, 22),
(92, 10),
(92, 22),
(93, 21),
(94, 21),
(95, 21),
(96, 1),
(96, 7),
(96, 14),
(97, 1),
(97, 7),
(97, 14),
(98, 11),
(98, 16),
(99, 1),
(99, 2),
(99, 3),
(99, 4),
(99, 5),
(99, 6),
(99, 7),
(99, 8),
(99, 9),
(99, 10),
(99, 11),
(99, 12),
(99, 13),
(99, 14),
(99, 15),
(99, 16),
(99, 17),
(99, 18),
(99, 19),
(99, 20),
(99, 21),
(99, 22),
(99, 23),
(99, 24),
(99, 25),
(99, 26),
(100, 14),
(100, 24),
(100, 26),
(101, 7),
(101, 12),
(101, 24),
(101, 26),
(102, 12),
(102, 24),
(102, 26),
(103, 12),
(103, 24),
(103, 26),
(104, 12),
(104, 24),
(104, 26),
(105, 12),
(105, 24),
(105, 26),
(106, 14),
(106, 24),
(106, 26),
(107, 24),
(107, 26),
(108, 1),
(108, 5),
(108, 7),
(108, 12),
(108, 14),
(108, 24),
(108, 26),
(109, 1),
(110, 1),
(111, 1),
(112, 1),
(112, 4),
(113, 1),
(114, 12),
(114, 23),
(115, 4),
(115, 10),
(116, 9),
(116, 21),
(117, 4),
(118, 2),
(118, 3),
(118, 4),
(118, 5),
(118, 6),
(118, 8),
(118, 10),
(118, 13),
(118, 14),
(118, 15),
(118, 25),
(119, 1),
(119, 2),
(119, 3),
(119, 4),
(119, 5),
(119, 6),
(119, 7),
(119, 12),
(119, 13),
(120, 14),
(120, 17),
(121, 14),
(121, 15),
(123, 1),
(123, 4),
(123, 5),
(123, 6),
(123, 7),
(123, 10),
(123, 14),
(124, 7),
(124, 12),
(124, 14),
(124, 24),
(125, 14),
(125, 17),
(125, 18),
(126, 15),
(127, 14),
(129, 15),
(130, 7),
(130, 8),
(130, 9),
(130, 10),
(130, 11),
(132, 11),
(133, 11),
(133, 16),
(134, 11),
(134, 16),
(135, 15),
(136, 11),
(136, 16),
(137, 21),
(138, 1),
(138, 4),
(138, 10),
(138, 18),
(139, 9),
(139, 21),
(142, 16),
(143, 11),
(143, 16),
(144, 1),
(144, 7),
(144, 11),
(144, 14),
(144, 16),
(147, 14),
(148, 7),
(148, 14),
(149, 9),
(149, 21),
(150, 7),
(150, 14),
(150, 15),
(151, 9),
(152, 7),
(152, 14),
(153, 9),
(153, 21),
(154, 7),
(154, 14),
(154, 15),
(155, 4),
(155, 10),
(155, 22),
(156, 15),
(157, 15),
(158, 15),
(159, 16),
(160, 15),
(161, 15),
(162, 15),
(163, 15),
(164, 15),
(165, 15),
(166, 15),
(167, 15),
(168, 15),
(169, 15),
(170, 7),
(170, 14),
(170, 15),
(171, 10),
(171, 22),
(172, 4),
(172, 10),
(172, 22),
(173, 10),
(173, 22),
(174, 4),
(174, 10),
(174, 22),
(175, 10),
(175, 22),
(176, 1),
(176, 7),
(177, 10),
(178, 22),
(180, 10),
(180, 22),
(181, 26),
(183, 7),
(183, 14),
(184, 14),
(185, 14),
(186, 14),
(187, 14),
(188, 14),
(189, 14),
(191, 14),
(192, 14),
(193, 14),
(194, 9),
(194, 21),
(195, 9),
(195, 21),
(196, 21),
(197, 9),
(197, 21),
(198, 9),
(198, 21),
(199, 9),
(199, 21),
(200, 21),
(201, 9),
(201, 21),
(202, 21),
(203, 9),
(203, 21),
(204, 9),
(204, 21),
(205, 9),
(205, 21),
(206, 9),
(206, 21),
(207, 9),
(207, 21),
(208, 9),
(208, 21),
(209, 9),
(209, 21),
(216, 11),
(216, 16),
(217, 11),
(217, 16),
(218, 11),
(218, 16),
(219, 11),
(219, 16),
(225, 7),
(225, 14),
(226, 7),
(227, 7),
(228, 7),
(228, 14),
(230, 7),
(231, 7),
(232, 7),
(233, 7),
(234, 7),
(236, 7),
(237, 7),
(237, 14),
(238, 1),
(239, 7),
(240, 7),
(243, 7),
(246, 7),
(247, 7),
(248, 7),
(251, 3),
(252, 13),
(253, 25),
(254, 3),
(255, 9),
(255, 21),
(256, 9),
(256, 21),
(257, 21),
(258, 9),
(258, 21),
(259, 9),
(259, 21),
(260, 4),
(262, 9),
(262, 21),
(263, 9),
(264, 21),
(265, 10),
(265, 22),
(266, 22),
(267, 11),
(267, 16),
(269, 7),
(269, 14),
(270, 1),
(271, 1),
(271, 5),
(271, 7),
(271, 12),
(272, 11),
(272, 16),
(273, 11),
(273, 16),
(274, 11),
(274, 16),
(275, 11),
(275, 16),
(276, 11),
(276, 16),
(277, 11),
(277, 16),
(278, 11),
(278, 22),
(279, 11),
(279, 16),
(280, 11),
(280, 16),
(281, 11),
(281, 16),
(282, 16),
(283, 16),
(284, 16),
(285, 11),
(285, 16),
(285, 23),
(286, 16),
(286, 23),
(287, 16),
(287, 23),
(288, 16),
(288, 23),
(289, 16),
(290, 16),
(291, 16),
(292, 11),
(292, 16),
(293, 16),
(294, 16),
(295, 16),
(296, 16),
(297, 16),
(298, 16),
(299, 16),
(300, 16),
(301, 16),
(302, 16),
(303, 16),
(304, 16),
(305, 16),
(306, 11),
(307, 16),
(308, 15),
(308, 16),
(309, 7),
(309, 15),
(310, 1),
(311, 7),
(311, 14),
(312, 1),
(313, 4),
(313, 6),
(313, 9),
(313, 10),
(313, 18),
(313, 21),
(313, 22),
(314, 7),
(314, 9),
(314, 14),
(314, 21),
(315, 7),
(315, 15),
(316, 1),
(317, 1),
(318, 14),
(318, 17),
(319, 14),
(319, 24),
(319, 26),
(320, 12),
(320, 23),
(321, 23),
(322, 7),
(322, 14),
(322, 20),
(323, 12),
(323, 24),
(324, 12),
(324, 24),
(325, 7),
(325, 8),
(325, 14),
(325, 19),
(325, 20),
(326, 10),
(326, 22),
(326, 26),
(327, 14),
(327, 17),
(327, 26),
(328, 17),
(329, 17),
(330, 14),
(330, 17),
(331, 17),
(331, 26),
(332, 17),
(332, 26),
(333, 14),
(333, 17),
(333, 26),
(334, 14),
(334, 17),
(334, 26),
(335, 14),
(335, 17),
(335, 26),
(336, 14),
(336, 17),
(336, 26),
(337, 14),
(337, 17),
(337, 26),
(338, 14),
(338, 17),
(338, 26),
(339, 14),
(339, 17),
(339, 26),
(340, 14),
(340, 17),
(340, 26),
(341, 14),
(341, 17),
(341, 26),
(342, 22),
(342, 26),
(343, 14),
(343, 22),
(343, 26),
(344, 14),
(344, 22),
(344, 26),
(345, 14),
(345, 22),
(345, 26),
(347, 5),
(347, 12),
(347, 23),
(348, 26),
(349, 5),
(349, 12),
(350, 5),
(350, 12),
(350, 24),
(351, 4),
(351, 9),
(352, 9),
(352, 10),
(352, 22),
(353, 4),
(353, 9),
(354, 6),
(354, 7),
(355, 9),
(356, 9),
(356, 21),
(357, 9),
(357, 21),
(358, 9),
(358, 21),
(359, 7),
(360, 4),
(360, 9),
(361, 7),
(361, 14),
(362, 9),
(363, 6),
(363, 9),
(365, 9),
(365, 21),
(366, 1),
(366, 6),
(368, 1),
(368, 7),
(368, 14),
(369, 9),
(370, 9),
(371, 9),
(372, 9),
(373, 21),
(374, 21),
(375, 21),
(376, 21),
(377, 21),
(378, 21),
(379, 14),
(379, 18),
(380, 12),
(380, 24),
(381, 5),
(381, 12),
(381, 24),
(382, 1),
(382, 2),
(382, 3),
(382, 4),
(382, 5),
(382, 6),
(382, 7),
(382, 8),
(382, 10),
(382, 11),
(382, 12),
(382, 13),
(382, 14),
(382, 17),
(382, 18),
(382, 19),
(382, 20),
(382, 22),
(382, 23),
(382, 24),
(382, 26),
(387, 22),
(390, 15),
(392, 15),
(392, 17),
(392, 18),
(393, 1),
(397, 22),
(398, 22),
(399, 14),
(400, 22),
(401, 7),
(402, 25),
(403, 12),
(403, 23),
(404, 14),
(405, 15),
(407, 7),
(407, 14),
(409, 7),
(410, 7),
(410, 14),
(410, 26),
(411, 7),
(411, 15),
(412, 7),
(412, 12),
(413, 7),
(414, 7),
(415, 1),
(415, 7),
(416, 7),
(418, 7),
(418, 9),
(418, 10),
(420, 7),
(420, 15),
(421, 7),
(421, 15),
(422, 7),
(422, 15),
(423, 15),
(424, 7),
(424, 15),
(425, 15),
(426, 5),
(426, 12),
(426, 24),
(427, 12),
(427, 24),
(429, 14),
(429, 16),
(429, 17),
(429, 18),
(429, 19),
(429, 20),
(429, 21),
(429, 22),
(429, 23),
(429, 24),
(429, 26),
(431, 12),
(431, 24),
(432, 26),
(434, 24),
(435, 24),
(437, 12),
(437, 23),
(438, 5),
(438, 12),
(438, 24),
(439, 15),
(440, 7),
(440, 15),
(441, 7),
(441, 14),
(441, 26),
(442, 1),
(442, 7),
(442, 14),
(443, 14),
(444, 7),
(444, 14),
(444, 26),
(445, 13),
(445, 25),
(446, 4),
(446, 10),
(446, 22),
(447, 4),
(447, 10),
(447, 22),
(448, 22),
(449, 14),
(449, 22),
(450, 4),
(450, 10),
(450, 22),
(451, 4),
(451, 10),
(451, 22),
(452, 14),
(452, 22),
(453, 4),
(453, 10),
(453, 22),
(454, 1),
(454, 7),
(454, 14),
(454, 15),
(455, 1),
(455, 7),
(455, 14),
(456, 1),
(456, 7),
(456, 14),
(457, 7),
(457, 14),
(458, 1),
(458, 7),
(458, 14),
(459, 1),
(459, 7),
(459, 14),
(460, 1),
(460, 7),
(460, 14),
(461, 1),
(461, 7),
(461, 14),
(463, 1),
(463, 7),
(463, 14),
(464, 7),
(464, 14),
(465, 1),
(465, 7),
(465, 14),
(466, 7),
(466, 14),
(467, 1),
(467, 7),
(467, 14),
(468, 16),
(471, 1),
(471, 7),
(472, 7),
(473, 7),
(475, 23),
(476, 7),
(477, 9),
(477, 21),
(478, 9),
(478, 21),
(480, 1),
(481, 1),
(482, 1),
(484, 7),
(484, 14),
(486, 17),
(487, 26),
(488, 19),
(491, 26),
(492, 7),
(492, 12),
(492, 24),
(492, 26),
(493, 7),
(494, 1),
(494, 7),
(495, 1),
(496, 1),
(496, 7),
(497, 1),
(497, 7),
(498, 1),
(499, 1),
(499, 7),
(500, 1),
(500, 7),
(501, 1),
(501, 7),
(502, 1),
(502, 7),
(503, 1),
(503, 7),
(503, 15),
(504, 1),
(504, 7),
(504, 14),
(505, 7),
(505, 15),
(506, 1),
(506, 7),
(507, 7),
(507, 14),
(508, 7),
(508, 14),
(509, 1),
(509, 7),
(510, 5),
(510, 6),
(510, 7),
(510, 9),
(510, 10),
(510, 14),
(510, 15),
(510, 17),
(510, 18),
(510, 21),
(510, 24),
(511, 7),
(512, 7),
(512, 14),
(513, 1),
(513, 4),
(513, 7),
(514, 1),
(514, 7),
(514, 11),
(514, 16),
(515, 7),
(515, 11),
(515, 14),
(515, 15),
(515, 16),
(516, 1),
(516, 7),
(517, 7),
(517, 15),
(518, 7),
(518, 15),
(519, 7),
(519, 15),
(520, 7),
(521, 7),
(522, 9),
(523, 9),
(524, 9),
(525, 7),
(525, 10),
(525, 14),
(525, 17),
(525, 18),
(525, 19),
(525, 22),
(526, 9),
(526, 21),
(528, 22),
(529, 18),
(530, 18),
(531, 1),
(531, 6),
(532, 7),
(532, 9),
(532, 10),
(532, 11),
(532, 14),
(532, 15),
(532, 16),
(532, 17),
(532, 18),
(532, 19),
(532, 21),
(532, 22),
(532, 23),
(533, 7),
(533, 14),
(533, 15),
(534, 7),
(535, 1),
(535, 7),
(535, 11),
(535, 16),
(536, 1),
(538, 19),
(539, 13),
(540, 3),
(540, 13),
(540, 25),
(541, 5),
(541, 12),
(541, 23),
(542, 7),
(542, 9),
(542, 14),
(542, 15),
(542, 21),
(543, 4),
(543, 9),
(544, 1),
(544, 4),
(544, 7),
(544, 10),
(544, 14),
(545, 1),
(545, 4),
(545, 6),
(545, 7),
(545, 9),
(545, 10),
(546, 1),
(546, 5),
(546, 12),
(546, 24),
(547, 1),
(547, 4),
(547, 6),
(547, 10),
(548, 1),
(548, 11),
(548, 16),
(549, 7),
(549, 12),
(549, 14),
(549, 24),
(550, 1),
(550, 12),
(550, 24),
(551, 5),
(551, 12),
(552, 1),
(552, 7),
(552, 12),
(553, 7),
(553, 12),
(553, 14),
(553, 24),
(554, 1),
(554, 7),
(555, 1),
(555, 7),
(555, 12),
(556, 7),
(556, 14),
(557, 7),
(557, 14),
(558, 14),
(558, 15),
(558, 26),
(559, 7),
(559, 8),
(560, 9),
(560, 21),
(560, 24),
(561, 1),
(561, 7),
(561, 11),
(561, 16),
(562, 7),
(562, 10),
(562, 14),
(562, 15),
(562, 22),
(563, 7),
(563, 10),
(563, 14),
(563, 22),
(564, 7),
(564, 10),
(564, 14),
(565, 12),
(565, 24),
(566, 12),
(566, 24),
(566, 26),
(567, 14),
(567, 18),
(567, 24),
(568, 12),
(568, 14),
(568, 24),
(568, 26),
(569, 12),
(569, 23),
(570, 14),
(570, 23),
(571, 12),
(571, 23),
(572, 23),
(572, 26),
(573, 24),
(573, 26),
(574, 12),
(574, 23),
(575, 7),
(575, 8),
(575, 14),
(575, 19),
(575, 20),
(575, 26),
(576, 7),
(576, 14),
(576, 26),
(577, 14),
(577, 17),
(577, 18),
(577, 19),
(577, 20),
(578, 14),
(579, 14),
(579, 24),
(580, 14),
(580, 26),
(581, 14),
(581, 26),
(582, 14),
(582, 15),
(582, 17),
(582, 26),
(583, 14),
(584, 14),
(584, 26),
(585, 14),
(585, 26),
(586, 14),
(586, 17),
(587, 7),
(587, 14),
(587, 26),
(588, 14),
(588, 26),
(589, 14),
(589, 15),
(590, 14),
(590, 17),
(591, 17),
(591, 26),
(592, 14),
(592, 17),
(592, 26),
(593, 14),
(593, 17),
(593, 26),
(594, 14),
(594, 18),
(594, 26),
(595, 17),
(595, 26),
(596, 18),
(596, 21),
(596, 26),
(597, 15),
(597, 18),
(597, 26),
(598, 18),
(598, 26),
(599, 14),
(599, 17),
(599, 24),
(599, 26),
(600, 14),
(600, 17),
(600, 26),
(601, 14),
(601, 17),
(601, 26),
(602, 14),
(602, 17),
(602, 26),
(603, 14),
(603, 17),
(603, 26),
(604, 14),
(604, 17),
(604, 26),
(605, 17),
(605, 26),
(606, 14),
(606, 17),
(606, 26),
(607, 14),
(607, 17),
(607, 26),
(608, 14),
(608, 17),
(608, 26),
(609, 14),
(609, 17),
(609, 26),
(610, 14),
(610, 17),
(610, 26),
(611, 14),
(611, 17),
(611, 26),
(612, 14),
(612, 17),
(612, 26),
(613, 14),
(613, 17),
(614, 14),
(614, 17),
(614, 26),
(615, 14),
(615, 17),
(615, 26),
(616, 14),
(616, 17),
(616, 26),
(617, 12),
(617, 14),
(617, 17),
(617, 24),
(617, 26),
(618, 14),
(618, 17),
(618, 24),
(618, 26),
(619, 14),
(619, 17),
(619, 24),
(619, 26),
(620, 14),
(620, 17),
(620, 24),
(620, 26),
(621, 24),
(622, 14),
(622, 17),
(622, 24),
(622, 26),
(623, 14),
(623, 17),
(623, 26),
(624, 14),
(624, 17),
(624, 26),
(625, 14),
(625, 17),
(625, 24),
(625, 26),
(626, 14),
(626, 17),
(626, 26),
(627, 14),
(627, 17),
(627, 26),
(628, 14),
(628, 17),
(628, 26),
(629, 14),
(629, 17),
(629, 24),
(629, 26),
(630, 14),
(630, 17),
(630, 26),
(631, 14),
(631, 17),
(631, 26),
(632, 14),
(632, 17),
(632, 26),
(633, 14),
(633, 17),
(633, 26),
(634, 14),
(634, 17),
(634, 26),
(635, 14),
(635, 17),
(635, 26),
(636, 14),
(636, 17),
(636, 26),
(637, 18),
(637, 26),
(638, 18),
(638, 26),
(639, 18),
(639, 26),
(640, 18),
(640, 26),
(641, 14),
(641, 19),
(642, 14),
(642, 18),
(642, 26),
(643, 14),
(643, 18),
(643, 19),
(643, 26),
(644, 18),
(645, 18),
(645, 26),
(646, 18),
(646, 26),
(647, 18),
(647, 26),
(648, 14),
(648, 26),
(650, 18),
(651, 18),
(652, 10),
(652, 17),
(653, 17),
(654, 14),
(654, 18),
(654, 26),
(655, 18),
(656, 18),
(657, 14),
(657, 18),
(657, 26),
(658, 18),
(659, 18),
(660, 18),
(661, 18),
(662, 18),
(663, 18),
(664, 18),
(665, 14),
(665, 15),
(665, 26),
(666, 14),
(666, 15),
(666, 26),
(668, 14),
(668, 15),
(669, 14),
(669, 15),
(670, 18),
(671, 18),
(672, 18),
(673, 18),
(674, 18),
(675, 18),
(676, 19),
(676, 26),
(677, 14),
(677, 19),
(677, 26),
(678, 14),
(678, 17),
(678, 19),
(678, 26),
(679, 14),
(679, 18),
(679, 19),
(679, 26),
(680, 14),
(680, 19),
(680, 26),
(681, 7),
(681, 8),
(681, 14),
(681, 19),
(681, 26),
(682, 14),
(682, 17),
(682, 26),
(683, 14),
(683, 17),
(683, 19),
(683, 26),
(685, 8),
(685, 19),
(686, 21),
(687, 14),
(687, 17),
(687, 18),
(687, 23),
(688, 4),
(688, 9),
(688, 21),
(691, 26),
(693, 14),
(694, 14),
(694, 22),
(694, 26),
(695, 14),
(695, 17),
(695, 18),
(695, 19),
(695, 22),
(695, 23),
(695, 24),
(695, 26),
(696, 14),
(696, 19),
(696, 20),
(696, 26),
(697, 9),
(697, 21),
(698, 14),
(698, 19),
(698, 20),
(698, 26),
(699, 21),
(700, 21),
(701, 21),
(702, 14),
(702, 19),
(702, 26),
(703, 21),
(704, 21),
(705, 21),
(706, 21),
(707, 15),
(708, 21),
(709, 21),
(710, 15),
(710, 21),
(711, 9),
(711, 21),
(712, 21),
(712, 22),
(712, 26),
(713, 14),
(713, 22),
(713, 26),
(714, 14),
(714, 22),
(714, 26),
(715, 14),
(715, 22),
(715, 26),
(716, 14),
(716, 22),
(717, 14),
(717, 22),
(717, 26),
(718, 14),
(718, 22),
(718, 26),
(719, 14),
(719, 22),
(719, 26),
(720, 14),
(720, 22),
(720, 26),
(721, 26),
(722, 14),
(722, 22),
(722, 26),
(723, 14),
(723, 22),
(723, 26),
(724, 14),
(724, 22),
(724, 26),
(725, 14),
(725, 22),
(725, 26),
(726, 14),
(726, 22),
(726, 26),
(727, 14),
(727, 22),
(727, 24),
(727, 26),
(728, 14),
(728, 22),
(728, 26),
(729, 14),
(729, 22),
(729, 26),
(730, 14),
(730, 19),
(730, 22),
(730, 26),
(731, 14),
(731, 24),
(731, 26),
(732, 23),
(732, 26),
(733, 12),
(733, 24),
(733, 26),
(734, 23),
(734, 26),
(735, 14),
(735, 23),
(735, 26),
(736, 21),
(737, 23),
(737, 26),
(738, 14),
(738, 17),
(738, 24),
(739, 11),
(739, 12),
(739, 16),
(739, 24),
(740, 24),
(740, 26),
(741, 14),
(741, 26),
(742, 14),
(742, 24),
(742, 26),
(743, 14),
(743, 24),
(743, 26),
(744, 17),
(744, 18),
(744, 26),
(745, 14),
(745, 17),
(745, 24),
(745, 26),
(746, 14),
(746, 17),
(746, 24),
(746, 26),
(747, 14),
(747, 26),
(748, 14),
(748, 18),
(748, 26),
(749, 14),
(749, 26),
(750, 7),
(750, 14),
(751, 14),
(751, 26),
(752, 22),
(753, 14),
(754, 14),
(754, 26),
(755, 14),
(756, 14),
(756, 16),
(756, 26),
(757, 14),
(757, 19),
(757, 26),
(758, 7),
(758, 14),
(758, 15),
(759, 7),
(759, 14),
(759, 15),
(760, 14),
(760, 15),
(760, 26),
(761, 14),
(761, 26),
(762, 16),
(763, 24),
(764, 11),
(764, 16),
(765, 11),
(765, 16),
(765, 26),
(766, 11),
(766, 16),
(767, 11),
(767, 16),
(768, 11),
(768, 16),
(770, 11),
(770, 16),
(771, 9),
(771, 21),
(772, 4),
(773, 10),
(773, 16),
(774, 16),
(776, 1),
(776, 7),
(777, 15),
(778, 14),
(779, 7),
(779, 14),
(779, 15),
(780, 7),
(780, 10),
(780, 14),
(780, 15),
(780, 17),
(780, 18),
(781, 14),
(781, 15),
(781, 16),
(781, 17),
(781, 19),
(781, 21),
(781, 22),
(781, 23),
(781, 24),
(781, 26),
(783, 14),
(783, 15),
(784, 14),
(785, 14),
(786, 14),
(787, 14),
(788, 14),
(789, 14),
(790, 15),
(791, 15),
(792, 15),
(793, 15),
(794, 15),
(795, 7),
(795, 15),
(796, 14),
(797, 15),
(798, 11),
(798, 16),
(799, 8),
(799, 20),
(800, 7),
(800, 8),
(800, 14),
(800, 19),
(800, 26),
(801, 7),
(801, 14),
(801, 26),
(802, 14),
(802, 26),
(803, 8),
(803, 19),
(803, 20),
(804, 13),
(804, 25),
(804, 26),
(806, 10),
(806, 22),
(807, 14),
(807, 22),
(807, 26),
(808, 14),
(808, 22),
(808, 26),
(809, 14),
(809, 17),
(809, 26),
(810, 14),
(810, 22),
(810, 26),
(811, 22),
(812, 14),
(812, 22),
(812, 26),
(813, 14),
(813, 19),
(813, 20),
(813, 26),
(814, 22),
(814, 26),
(816, 16),
(817, 16),
(818, 14),
(818, 26),
(819, 25),
(820, 22),
(821, 14),
(821, 22),
(821, 26),
(822, 10),
(822, 14),
(822, 15),
(822, 16),
(822, 18),
(822, 22),
(823, 14),
(824, 14),
(825, 18),
(825, 26),
(826, 23),
(827, 23),
(828, 23),
(829, 23),
(830, 23),
(831, 23),
(832, 23),
(833, 21),
(834, 9),
(834, 21),
(835, 12),
(835, 23),
(836, 12),
(836, 23),
(837, 23),
(838, 23),
(839, 23),
(840, 23),
(841, 23),
(842, 23),
(843, 12),
(843, 23),
(844, 23),
(845, 23),
(846, 23),
(847, 23),
(848, 23),
(849, 23),
(850, 23),
(851, 23),
(852, 12),
(852, 23),
(853, 12),
(853, 23),
(854, 23),
(855, 23),
(856, 23),
(857, 23),
(858, 14),
(859, 23),
(860, 23),
(861, 12),
(861, 23),
(862, 21),
(863, 7),
(863, 14),
(864, 18),
(864, 26),
(865, 4),
(869, 21),
(870, 21),
(872, 7),
(872, 9),
(872, 21),
(873, 6),
(875, 16),
(876, 7),
(876, 14),
(877, 7),
(878, 4),
(879, 4),
(879, 9),
(880, 1),
(880, 7),
(881, 21),
(882, 14),
(882, 15),
(883, 14),
(883, 17),
(883, 18),
(883, 22),
(884, 14),
(884, 17),
(884, 18),
(884, 19),
(884, 22),
(884, 23),
(884, 24),
(885, 7),
(885, 8),
(885, 9),
(885, 10),
(885, 11),
(885, 12),
(885, 14),
(885, 15),
(885, 16),
(885, 19),
(885, 21),
(885, 22),
(885, 23),
(885, 24),
(885, 26),
(886, 9),
(887, 9),
(887, 21),
(888, 21),
(889, 4),
(889, 6),
(889, 7),
(889, 9),
(889, 10),
(889, 11),
(889, 14),
(889, 16),
(889, 17),
(889, 18),
(889, 21),
(890, 21),
(891, 21),
(892, 9),
(892, 21),
(893, 21),
(894, 21),
(895, 9),
(895, 21),
(896, 9),
(896, 21),
(897, 9),
(897, 21),
(898, 9),
(898, 21),
(899, 9),
(899, 21),
(900, 21),
(901, 4),
(901, 6),
(903, 4),
(903, 6),
(905, 6),
(906, 4),
(906, 6),
(907, 4),
(907, 6),
(908, 4),
(908, 6),
(909, 4),
(909, 6),
(910, 6),
(912, 9),
(912, 21),
(913, 18),
(913, 26),
(914, 7),
(914, 14),
(915, 1),
(915, 2),
(915, 3),
(915, 4),
(915, 5),
(915, 6),
(915, 7),
(915, 8),
(915, 9),
(915, 10),
(915, 12),
(915, 13),
(916, 14),
(920, 14),
(920, 22),
(921, 22),
(922, 14),
(922, 22),
(923, 22),
(924, 14),
(924, 22),
(925, 10),
(925, 22),
(926, 14),
(926, 22),
(927, 14),
(927, 22),
(928, 8),
(929, 14),
(929, 17),
(929, 18),
(929, 19),
(929, 26),
(930, 14),
(930, 17),
(930, 18),
(930, 19),
(930, 26),
(931, 7),
(931, 10),
(931, 14),
(932, 14),
(932, 24),
(933, 14),
(933, 15),
(933, 21),
(934, 17),
(935, 14),
(935, 17),
(935, 26),
(936, 14),
(936, 17),
(936, 18),
(936, 19),
(936, 26),
(953, 14),
(953, 19),
(953, 26),
(954, 7),
(954, 14),
(955, 11),
(955, 16),
(958, 26),
(959, 21),
(960, 7),
(960, 9),
(962, 1),
(962, 2),
(962, 3),
(962, 4),
(962, 5),
(962, 6),
(969, 12),
(969, 23),
(970, 7),
(970, 8),
(970, 9),
(970, 10),
(970, 11),
(970, 12),
(970, 13),
(970, 14),
(970, 16),
(970, 17),
(970, 18),
(970, 19),
(970, 20),
(970, 21),
(970, 22),
(970, 23),
(970, 24),
(970, 25),
(970, 26),
(971, 7),
(971, 10),
(971, 11),
(971, 14),
(971, 16),
(971, 18),
(971, 26),
(972, 18),
(973, 7),
(973, 9),
(974, 1),
(974, 6),
(975, 11),
(975, 16);

-- --------------------------------------------------------

--
-- Structure de la table `module_ressource_res2fonction`
--

CREATE TABLE IF NOT EXISTS `module_ressource_res2fonction` (
  `id_ressource` int(11) NOT NULL DEFAULT '0',
  `id_fonction` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_ressource`,`id_fonction`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `module_ressource_res2fonction`
--

INSERT INTO `module_ressource_res2fonction` (`id_ressource`, `id_fonction`) VALUES
(17, 1),
(17, 3),
(19, 1),
(20, 1),
(21, 1),
(22, 2),
(23, 3),
(24, 1),
(24, 3),
(26, 3),
(28, 1),
(28, 4),
(29, 1),
(30, 1),
(30, 4),
(31, 1),
(31, 4),
(32, 1),
(32, 4),
(33, 1),
(33, 4),
(34, 1),
(34, 4),
(35, 1),
(36, 1),
(37, 1),
(38, 1),
(39, 1),
(40, 1),
(40, 4),
(41, 1),
(41, 4),
(42, 1),
(43, 1),
(44, 1),
(45, 1),
(46, 1),
(46, 4),
(47, 1),
(48, 1),
(49, 1),
(49, 3),
(50, 3),
(51, 1),
(52, 1),
(53, 1),
(54, 1),
(55, 2),
(57, 1),
(57, 4),
(58, 1),
(59, 1),
(60, 1),
(61, 1),
(62, 1),
(63, 1),
(64, 1),
(65, 1),
(67, 1),
(67, 4),
(68, 1),
(68, 4),
(69, 1),
(70, 1),
(71, 1),
(72, 1),
(73, 1),
(74, 1),
(75, 1),
(76, 1),
(77, 1),
(79, 1),
(80, 1),
(81, 1),
(82, 1),
(82, 4),
(83, 1),
(83, 4),
(84, 1),
(84, 4),
(85, 1),
(86, 1),
(86, 4),
(87, 1),
(87, 4),
(88, 1),
(88, 4),
(89, 1),
(89, 4),
(90, 1),
(91, 1),
(92, 1),
(92, 4),
(93, 1),
(93, 4),
(94, 1),
(94, 4),
(95, 1),
(96, 1),
(96, 3),
(97, 1),
(98, 1),
(98, 4),
(99, 1),
(100, 1),
(100, 4),
(101, 1),
(101, 4),
(102, 1),
(103, 1),
(103, 4),
(104, 1),
(104, 4),
(105, 1),
(105, 4),
(106, 1),
(107, 1),
(108, 1),
(108, 4),
(109, 1),
(110, 1),
(111, 1),
(111, 4),
(112, 1),
(112, 4),
(113, 1),
(113, 4),
(114, 1),
(114, 4),
(115, 1),
(115, 4),
(116, 1),
(117, 1),
(117, 4),
(118, 1),
(119, 1),
(120, 1),
(121, 1),
(123, 1),
(124, 1),
(125, 1),
(126, 1),
(127, 1),
(128, 3),
(129, 1),
(130, 1),
(131, 1),
(132, 1),
(133, 1),
(134, 1),
(134, 3),
(135, 1),
(135, 4),
(136, 1),
(137, 1),
(137, 4),
(138, 1),
(139, 1),
(140, 1),
(141, 1),
(141, 3),
(142, 1),
(143, 1),
(144, 1),
(145, 1),
(146, 1),
(147, 1),
(147, 4),
(148, 1),
(149, 1),
(152, 1),
(152, 4),
(153, 1),
(154, 1),
(155, 1),
(156, 1),
(156, 4),
(157, 1),
(157, 4),
(158, 1),
(158, 4),
(159, 1),
(159, 4),
(160, 1),
(160, 4),
(161, 1),
(161, 4),
(162, 1),
(162, 4),
(163, 1),
(163, 4),
(164, 1),
(164, 4),
(165, 1),
(165, 4),
(166, 1),
(166, 4),
(167, 1),
(167, 4),
(168, 1),
(168, 4),
(169, 1),
(169, 4),
(170, 1),
(170, 4),
(171, 1),
(172, 1),
(172, 3),
(173, 1),
(174, 1),
(174, 3),
(175, 1),
(175, 3),
(176, 3),
(177, 1),
(178, 1),
(180, 1),
(181, 1),
(181, 4),
(182, 1),
(182, 2),
(182, 3),
(183, 1),
(183, 4),
(184, 1),
(185, 1),
(186, 1),
(187, 1),
(188, 1),
(189, 1),
(191, 1),
(192, 1),
(193, 1),
(194, 1),
(195, 1),
(196, 1),
(196, 4),
(197, 1),
(198, 1),
(199, 1),
(200, 3),
(201, 1),
(201, 4),
(202, 1),
(202, 4),
(203, 1),
(203, 4),
(204, 1),
(204, 4),
(205, 1),
(205, 4),
(206, 1),
(206, 4),
(207, 1),
(207, 4),
(208, 1),
(209, 1),
(209, 4),
(210, 1),
(210, 3),
(211, 3),
(212, 3),
(213, 1),
(213, 3),
(214, 1),
(214, 3),
(215, 1),
(215, 3),
(215, 4),
(216, 1),
(217, 1),
(218, 1),
(219, 1),
(220, 3),
(220, 4),
(221, 2),
(221, 3),
(221, 4),
(222, 3),
(222, 4),
(223, 2),
(223, 3),
(223, 4),
(224, 2),
(224, 3),
(224, 4),
(225, 1),
(225, 3),
(226, 1),
(226, 3),
(227, 1),
(228, 1),
(228, 3),
(230, 1),
(231, 1),
(232, 1),
(233, 1),
(234, 1),
(236, 3),
(237, 3),
(238, 3),
(239, 3),
(240, 3),
(242, 1),
(243, 1),
(244, 1),
(244, 3),
(245, 2),
(246, 1),
(246, 4),
(247, 1),
(247, 4),
(248, 1),
(249, 1),
(249, 3),
(249, 4),
(250, 1),
(250, 3),
(251, 1),
(251, 3),
(252, 1),
(252, 3),
(253, 1),
(253, 3),
(254, 1),
(254, 3),
(255, 1),
(255, 3),
(256, 1),
(257, 2),
(257, 3),
(258, 1),
(258, 3),
(259, 1),
(259, 3),
(260, 1),
(260, 3),
(261, 1),
(261, 3),
(262, 1),
(262, 3),
(263, 1),
(263, 3),
(264, 1),
(264, 3),
(265, 1),
(265, 3),
(266, 1),
(266, 3),
(267, 1),
(267, 3),
(268, 1),
(268, 3),
(269, 1),
(269, 3),
(270, 1),
(271, 1),
(271, 3),
(272, 1),
(273, 1),
(274, 1),
(275, 1),
(276, 1),
(277, 1),
(278, 1),
(279, 1),
(280, 1),
(281, 1),
(282, 1),
(283, 1),
(284, 1),
(285, 1),
(286, 1),
(287, 1),
(288, 1),
(289, 1),
(290, 1),
(291, 1),
(292, 1),
(293, 1),
(294, 1),
(295, 1),
(296, 1),
(297, 1),
(298, 1),
(299, 1),
(300, 1),
(301, 1),
(302, 1),
(303, 1),
(304, 1),
(305, 1),
(306, 1),
(307, 1),
(308, 1),
(308, 4),
(309, 1),
(310, 1),
(311, 1),
(311, 4),
(312, 1),
(313, 1),
(314, 1),
(314, 4),
(315, 1),
(316, 1),
(317, 1),
(318, 1),
(319, 1),
(320, 1),
(321, 1),
(322, 1),
(322, 4),
(323, 1),
(324, 3),
(325, 1),
(325, 4),
(326, 1),
(326, 4),
(327, 1),
(327, 4),
(328, 1),
(328, 4),
(329, 1),
(329, 4),
(330, 1),
(330, 4),
(331, 1),
(331, 4),
(332, 1),
(332, 4),
(333, 1),
(333, 4),
(334, 1),
(334, 4),
(335, 1),
(335, 4),
(336, 1),
(336, 4),
(337, 1),
(337, 4),
(338, 1),
(338, 4),
(339, 1),
(339, 4),
(340, 1),
(340, 4),
(341, 1),
(342, 1),
(342, 4),
(343, 1),
(343, 4),
(344, 1),
(344, 4),
(345, 1),
(345, 4),
(347, 1),
(348, 1),
(349, 1),
(349, 4),
(350, 1),
(350, 4),
(351, 1),
(351, 4),
(352, 1),
(352, 4),
(353, 1),
(353, 4),
(354, 1),
(354, 4),
(355, 1),
(355, 4),
(356, 1),
(356, 4),
(357, 1),
(357, 4),
(358, 1),
(358, 4),
(359, 1),
(359, 4),
(360, 1),
(360, 4),
(361, 1),
(361, 4),
(362, 1),
(362, 4),
(363, 1),
(363, 4),
(365, 1),
(365, 4),
(366, 1),
(367, 1),
(368, 1),
(369, 1),
(369, 4),
(370, 1),
(370, 4),
(371, 1),
(371, 4),
(372, 1),
(372, 4),
(373, 1),
(373, 4),
(374, 1),
(374, 4),
(375, 1),
(375, 4),
(376, 1),
(376, 4),
(377, 1),
(377, 4),
(378, 1),
(378, 4),
(379, 1),
(380, 1),
(381, 1),
(382, 1),
(382, 3),
(384, 1),
(384, 4),
(385, 1),
(386, 3),
(387, 1),
(387, 4),
(388, 1),
(390, 1),
(390, 4),
(392, 1),
(392, 4),
(393, 3),
(394, 1),
(394, 3),
(395, 1),
(395, 3),
(396, 1),
(396, 3),
(397, 1),
(397, 3),
(398, 1),
(398, 3),
(399, 1),
(400, 1),
(401, 1),
(402, 3),
(403, 3),
(404, 1),
(405, 1),
(405, 4),
(406, 4),
(407, 1),
(407, 3),
(407, 4),
(408, 1),
(409, 1),
(409, 4),
(410, 1),
(410, 4),
(411, 1),
(411, 4),
(412, 1),
(413, 1),
(413, 4),
(414, 1),
(414, 4),
(415, 1),
(415, 4),
(416, 1),
(416, 4),
(417, 1),
(418, 1),
(418, 4),
(419, 1),
(420, 1),
(420, 4),
(421, 1),
(421, 4),
(422, 1),
(422, 4),
(423, 1),
(423, 4),
(424, 1),
(424, 4),
(425, 1),
(425, 4),
(426, 1),
(426, 4),
(427, 1),
(427, 4),
(428, 1),
(428, 4),
(429, 1),
(429, 4),
(430, 1),
(431, 1),
(431, 4),
(432, 1),
(432, 4),
(433, 1),
(434, 1),
(434, 4),
(435, 1),
(437, 1),
(438, 1),
(439, 1),
(439, 4),
(440, 1),
(440, 4),
(441, 1),
(441, 4),
(442, 1),
(442, 4),
(443, 1),
(443, 4),
(444, 1),
(444, 4),
(445, 1),
(446, 1),
(447, 1),
(447, 4),
(448, 3),
(449, 1),
(449, 3),
(450, 1),
(451, 1),
(452, 1),
(452, 4),
(453, 1),
(453, 3),
(454, 1),
(454, 3),
(455, 1),
(455, 3),
(456, 1),
(456, 3),
(457, 3),
(458, 3),
(459, 1),
(459, 3),
(460, 1),
(460, 3),
(461, 1),
(461, 3),
(461, 4),
(463, 3),
(464, 3),
(465, 3),
(466, 3),
(467, 3),
(468, 1),
(469, 2),
(471, 1),
(472, 1),
(472, 4),
(473, 1),
(473, 4),
(474, 1),
(475, 1),
(476, 1),
(476, 4),
(477, 1),
(477, 4),
(478, 1),
(478, 4),
(479, 1),
(479, 4),
(480, 1),
(481, 1),
(482, 1),
(483, 2),
(484, 1),
(485, 3),
(486, 1),
(486, 3),
(487, 3),
(488, 3),
(489, 3),
(490, 1),
(491, 1),
(491, 4),
(492, 1),
(492, 4),
(493, 1),
(493, 4),
(494, 1),
(494, 4),
(495, 1),
(495, 4),
(496, 1),
(496, 4),
(497, 1),
(497, 4),
(498, 1),
(498, 4),
(499, 1),
(499, 4),
(500, 1),
(500, 4),
(501, 1),
(501, 4),
(502, 1),
(502, 4),
(503, 1),
(503, 4),
(504, 1),
(504, 4),
(505, 1),
(505, 4),
(506, 1),
(506, 4),
(507, 1),
(507, 4),
(508, 1),
(508, 4),
(509, 1),
(509, 4),
(510, 1),
(510, 4),
(511, 1),
(511, 4),
(512, 1),
(512, 4),
(513, 1),
(513, 4),
(514, 1),
(514, 4),
(515, 1),
(515, 4),
(516, 1),
(516, 4),
(517, 1),
(517, 4),
(518, 1),
(518, 4),
(519, 1),
(519, 4),
(520, 1),
(520, 4),
(521, 1),
(521, 4),
(522, 1),
(522, 4),
(523, 1),
(523, 4),
(524, 1),
(524, 4),
(525, 1),
(525, 4),
(526, 1),
(526, 4),
(527, 1),
(528, 1),
(529, 1),
(530, 1),
(530, 4),
(531, 1),
(532, 1),
(533, 1),
(533, 4),
(534, 1),
(534, 4),
(535, 1),
(535, 4),
(536, 4),
(537, 1),
(537, 2),
(538, 1),
(539, 1),
(540, 1),
(541, 1),
(541, 4),
(542, 1),
(542, 4),
(543, 1),
(543, 4),
(544, 1),
(544, 4),
(545, 1),
(545, 4),
(546, 1),
(546, 4),
(547, 1),
(547, 4),
(548, 1),
(548, 4),
(549, 1),
(549, 4),
(550, 1),
(550, 4),
(551, 1),
(551, 4),
(552, 1),
(552, 4),
(553, 1),
(553, 4),
(554, 1),
(554, 4),
(555, 1),
(555, 4),
(556, 1),
(556, 4),
(557, 1),
(557, 4),
(558, 1),
(558, 4),
(559, 1),
(559, 4),
(560, 1),
(560, 4),
(561, 1),
(561, 4),
(562, 1),
(562, 4),
(563, 1),
(563, 4),
(564, 1),
(564, 4),
(565, 1),
(565, 4),
(566, 1),
(566, 4),
(567, 1),
(567, 4),
(568, 1),
(568, 4),
(569, 1),
(569, 4),
(570, 1),
(570, 4),
(571, 1),
(571, 4),
(572, 1),
(572, 4),
(573, 1),
(573, 4),
(574, 1),
(574, 4),
(575, 1),
(575, 2),
(575, 3),
(576, 3),
(577, 1),
(577, 4),
(578, 1),
(579, 1),
(579, 4),
(580, 1),
(580, 4),
(581, 1),
(581, 4),
(582, 1),
(582, 4),
(583, 1),
(583, 4),
(584, 1),
(584, 4),
(585, 1),
(585, 4),
(586, 1),
(586, 4),
(587, 1),
(587, 4),
(588, 1),
(588, 4),
(589, 1),
(589, 4),
(590, 1),
(590, 4),
(591, 1),
(591, 4),
(592, 1),
(592, 4),
(593, 1),
(593, 4),
(594, 1),
(594, 4),
(595, 1),
(595, 4),
(596, 1),
(596, 4),
(597, 1),
(597, 4),
(598, 1),
(598, 4),
(599, 1),
(599, 4),
(600, 1),
(600, 4),
(601, 1),
(601, 4),
(602, 1),
(602, 4),
(603, 1),
(603, 4),
(604, 1),
(604, 4),
(605, 1),
(605, 3),
(606, 1),
(606, 4),
(607, 1),
(607, 4),
(608, 1),
(608, 4),
(609, 1),
(609, 4),
(610, 1),
(610, 4),
(611, 1),
(611, 4),
(612, 1),
(612, 4),
(613, 1),
(613, 4),
(614, 1),
(614, 4),
(615, 1),
(615, 4),
(616, 1),
(616, 4),
(617, 1),
(617, 4),
(618, 1),
(618, 4),
(619, 1),
(619, 4),
(620, 1),
(620, 4),
(621, 1),
(622, 1),
(622, 4),
(623, 1),
(623, 4),
(624, 1),
(624, 4),
(625, 1),
(625, 4),
(626, 1),
(626, 4),
(627, 1),
(627, 4),
(628, 1),
(628, 4),
(629, 1),
(629, 4),
(630, 1),
(630, 4),
(631, 1),
(631, 4),
(632, 1),
(632, 4),
(633, 1),
(633, 4),
(634, 1),
(634, 4),
(635, 1),
(635, 4),
(636, 1),
(637, 1),
(638, 1),
(639, 1),
(639, 4),
(640, 1),
(640, 4),
(641, 1),
(642, 1),
(642, 4),
(643, 1),
(643, 4),
(644, 1),
(644, 3),
(645, 1),
(646, 1),
(646, 4),
(647, 1),
(647, 4),
(648, 1),
(648, 3),
(649, 3),
(650, 1),
(651, 1),
(652, 1),
(653, 1),
(654, 1),
(654, 4),
(655, 1),
(656, 1),
(657, 1),
(657, 4),
(658, 1),
(658, 4),
(659, 1),
(659, 4),
(660, 1),
(660, 4),
(661, 1),
(661, 3),
(662, 1),
(663, 1),
(664, 1),
(664, 3),
(665, 1),
(665, 4),
(666, 1),
(666, 4),
(667, 1),
(668, 1),
(668, 4),
(669, 1),
(670, 1),
(671, 1),
(672, 1),
(673, 1),
(674, 1),
(675, 1),
(675, 4),
(676, 1),
(676, 4),
(677, 1),
(677, 4),
(678, 1),
(678, 4),
(679, 1),
(679, 4),
(680, 1),
(680, 4),
(681, 1),
(681, 4),
(682, 1),
(682, 4),
(683, 1),
(683, 4),
(684, 1),
(685, 1),
(685, 4),
(686, 1),
(686, 4),
(687, 1),
(688, 1),
(688, 4),
(689, 1),
(690, 1),
(691, 1),
(692, 1),
(693, 1),
(693, 4),
(694, 1),
(695, 1),
(696, 1),
(696, 4),
(697, 1),
(697, 4),
(698, 1),
(699, 1),
(699, 4),
(700, 1),
(700, 4),
(701, 1),
(701, 4),
(702, 1),
(702, 4),
(703, 1),
(703, 4),
(704, 1),
(704, 4),
(705, 1),
(705, 4),
(706, 1),
(706, 4),
(707, 1),
(707, 4),
(708, 1),
(708, 4),
(709, 1),
(709, 4),
(710, 1),
(710, 4),
(711, 1),
(711, 4),
(712, 1),
(712, 4),
(713, 1),
(713, 4),
(714, 1),
(714, 4),
(715, 1),
(715, 4),
(716, 1),
(716, 4),
(717, 1),
(717, 4),
(718, 1),
(718, 4),
(719, 1),
(719, 4),
(720, 1),
(720, 4),
(721, 1),
(721, 4),
(722, 1),
(722, 4),
(723, 1),
(723, 4),
(724, 1),
(724, 4),
(725, 1),
(725, 4),
(726, 1),
(726, 4),
(727, 1),
(727, 4),
(728, 1),
(728, 4),
(729, 1),
(729, 4),
(730, 1),
(730, 4),
(731, 1),
(731, 4),
(732, 1),
(732, 4),
(733, 1),
(733, 4),
(734, 1),
(734, 4),
(735, 1),
(735, 4),
(736, 1),
(736, 4),
(737, 1),
(737, 4),
(738, 1),
(738, 4),
(739, 1),
(739, 4),
(740, 1),
(740, 4),
(741, 1),
(741, 4),
(742, 1),
(742, 4),
(743, 1),
(743, 4),
(744, 1),
(744, 4),
(745, 1),
(745, 4),
(746, 1),
(746, 4),
(747, 1),
(747, 3),
(748, 1),
(748, 4),
(749, 1),
(749, 4),
(750, 1),
(751, 1),
(751, 4),
(752, 1),
(752, 4),
(753, 1),
(753, 4),
(754, 1),
(754, 4),
(755, 1),
(755, 4),
(756, 1),
(756, 4),
(757, 1),
(757, 4),
(758, 1),
(758, 4),
(759, 1),
(759, 4),
(760, 1),
(760, 4),
(761, 1),
(761, 4),
(762, 1),
(763, 1),
(763, 4),
(764, 3),
(765, 1),
(765, 4),
(766, 1),
(767, 1),
(767, 4),
(768, 1),
(769, 1),
(770, 1),
(770, 4),
(771, 1),
(771, 4),
(772, 1),
(773, 1),
(773, 4),
(774, 1),
(774, 4),
(775, 3),
(776, 1),
(776, 4),
(777, 1),
(777, 4),
(778, 1),
(778, 4),
(779, 1),
(779, 4),
(780, 1),
(780, 4),
(781, 1),
(782, 2),
(783, 1),
(783, 4),
(784, 1),
(784, 4),
(785, 1),
(785, 4),
(786, 1),
(786, 4),
(787, 1),
(787, 4),
(788, 1),
(788, 4),
(789, 1),
(789, 4),
(790, 1),
(790, 4),
(791, 1),
(791, 4),
(792, 1),
(792, 4),
(793, 1),
(793, 4),
(794, 1),
(794, 4),
(795, 1),
(795, 4),
(796, 1),
(796, 4),
(797, 1),
(797, 4),
(798, 1),
(798, 4),
(799, 1),
(800, 1),
(800, 4),
(801, 1),
(801, 4),
(802, 1),
(802, 4),
(803, 1),
(803, 3),
(804, 1),
(804, 4),
(805, 3),
(806, 1),
(807, 1),
(807, 4),
(808, 1),
(809, 1),
(810, 1),
(811, 1),
(812, 1),
(813, 1),
(814, 1),
(816, 1),
(816, 4),
(817, 1),
(817, 4),
(818, 3),
(819, 3),
(820, 1),
(820, 3),
(821, 1),
(822, 1),
(822, 4),
(823, 1),
(823, 4),
(824, 4),
(825, 1),
(826, 3),
(827, 3),
(828, 3),
(829, 3),
(830, 3),
(831, 3),
(832, 3),
(833, 4),
(834, 1),
(834, 4),
(835, 1),
(835, 4),
(836, 1),
(836, 4),
(837, 1),
(837, 3),
(838, 3),
(839, 1),
(840, 2),
(840, 3),
(841, 1),
(842, 1),
(843, 1),
(843, 4),
(844, 1),
(844, 4),
(845, 1),
(845, 4),
(846, 1),
(846, 3),
(847, 1),
(847, 4),
(848, 1),
(849, 1),
(849, 4),
(850, 1),
(850, 4),
(851, 1),
(851, 4),
(852, 1),
(852, 4),
(853, 3),
(854, 1),
(855, 1),
(856, 1),
(857, 4),
(858, 1),
(858, 4),
(859, 1),
(860, 1),
(861, 1),
(861, 4),
(862, 1),
(862, 4),
(863, 1),
(863, 3),
(864, 1),
(865, 1),
(865, 4),
(866, 1),
(867, 1),
(868, 1),
(869, 1),
(870, 1),
(870, 4),
(871, 1),
(872, 1),
(872, 4),
(873, 1),
(874, 1),
(875, 1),
(875, 4),
(876, 1),
(877, 1),
(877, 4),
(878, 1),
(878, 4),
(879, 1),
(879, 4),
(880, 1),
(880, 4),
(881, 1),
(881, 4),
(882, 1),
(882, 4),
(883, 1),
(883, 4),
(884, 1),
(884, 4),
(885, 1),
(885, 4),
(886, 1),
(886, 4),
(887, 1),
(887, 4),
(888, 1),
(888, 4),
(889, 1),
(889, 4),
(890, 1),
(890, 4),
(891, 1),
(891, 4),
(892, 1),
(892, 4),
(893, 4),
(894, 1),
(894, 4),
(895, 1),
(895, 4),
(896, 1),
(896, 4),
(897, 1),
(897, 4),
(898, 1),
(898, 4),
(899, 1),
(899, 4),
(900, 1),
(900, 4),
(901, 1),
(901, 4),
(902, 1),
(902, 4),
(903, 1),
(903, 4),
(904, 1),
(904, 4),
(905, 1),
(905, 4),
(906, 1),
(906, 4),
(907, 1),
(907, 4),
(908, 1),
(908, 4),
(909, 1),
(909, 4),
(910, 1),
(910, 4),
(911, 1),
(911, 4),
(912, 1),
(912, 4),
(913, 1),
(914, 1),
(914, 3),
(915, 1),
(916, 1),
(916, 3),
(917, 2),
(918, 2),
(919, 2),
(920, 3),
(921, 1),
(922, 1),
(922, 3),
(923, 1),
(923, 3),
(924, 1),
(925, 1),
(925, 3),
(926, 1),
(926, 4),
(927, 1),
(927, 3),
(928, 1),
(928, 4),
(929, 1),
(929, 4),
(930, 1),
(930, 4),
(931, 1),
(931, 4),
(932, 1),
(933, 1),
(933, 3),
(934, 1),
(935, 1),
(935, 4),
(936, 1),
(936, 4),
(937, 3),
(938, 2),
(939, 3),
(940, 3),
(941, 3),
(942, 3),
(943, 3),
(944, 2),
(945, 3),
(946, 3),
(947, 2),
(947, 3),
(948, 2),
(948, 3),
(949, 2),
(949, 3),
(950, 2),
(950, 3),
(951, 2),
(951, 3),
(952, 2),
(952, 3),
(953, 2),
(953, 3),
(954, 1),
(954, 3),
(955, 1),
(955, 3),
(956, 3),
(957, 3),
(958, 1),
(959, 1),
(959, 4),
(960, 1),
(960, 4),
(961, 1),
(961, 4),
(962, 1),
(962, 3),
(963, 1),
(963, 4),
(964, 1),
(964, 4),
(965, 1),
(965, 4),
(966, 1),
(966, 4),
(968, 1),
(968, 4),
(969, 1),
(969, 4),
(970, 1),
(970, 4),
(971, 1),
(971, 3),
(971, 4),
(972, 1),
(972, 4),
(973, 1),
(973, 4),
(974, 1),
(974, 4),
(975, 1),
(975, 4),
(976, 2);

-- --------------------------------------------------------

--
-- Structure de la table `module_ressource_ressources`
--

CREATE TABLE IF NOT EXISTS `module_ressource_ressources` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_annu` int(11) NOT NULL DEFAULT '0',
  `nom` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `mots` varchar(255) NOT NULL DEFAULT '',
  `auteur` varchar(255) NOT NULL DEFAULT '',
  `submit_user` varchar(255) NOT NULL DEFAULT '',
  `submit_date` datetime DEFAULT '0000-00-00 00:00:00',
  `valid_user` int(11) DEFAULT '0',
  `valid_date` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `id_annu` (`id_annu`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=977 ;

--
-- Contenu de la table `module_ressource_ressources`
--

INSERT INTO `module_ressource_ressources` (`id`, `id_annu`, `nom`, `url`, `description`, `mots`, `auteur`, `submit_user`, `submit_date`, `valid_user`, `valid_date`) VALUES
(856, 2, 'Site de Mauro Giuliani et de la guitare', 'http://www.metronimo.com/fr/annuaire/site-musique/index.php?url=http://maurogiuliani.free.fr/', 'Partitions\r\nIntegral\r\nSolos\r\nDuos\r\nTrios/Quatuors\r\nConcertos\r\nGuitare et Piano\r\nGuit et Flute ou Violon Chant et Guit ou Piano\r\nHistoire\r\nLe 18ème siècle\r\nLe 19ème siècle\r\nGuitares Anciennes\r\nVidéos\r\nRossiniane Op 121\r\nAllegro Maesto Op 30\r\nVariations Op 107\r\nVariations Op 45', 'musique;partitions;vidéos;guitare', 'metronimo', '0', '2006-08-27 00:02:59', NULL, NULL),
(855, 2, 'Partitions de chansons du domaine public', 'http://www.metronimo.com/fr/partitions_chansons/', 'ous trouverez ici quelques partitions de chansons appartenant au domaine public. Vous êtes libre de les télécharger, les imprimer et les exécuter. Chaque partition comporte au minimum une portée pour la voix, les paroles et un accompagnement de piano.\r\n\r\n    * Cadet Rousselle\r\n    * C''est le roi Dagobert\r\n    * Fanchon (elle aime à rire, elle aime à boire)\r\n    * Au clair de la lune\r\n    * L''invincible Malbrough (Malbrough s''en va en guerre)\r\n    * Les noces de Figaro (l''air est le même que celui de L''invincible Malbrough)\r\n    * Ah! vous dirai-je maman!\r\n    * La marseillaise\r\n    * Plaisir d''amour\r\n', 'chants;partitions;musique', 'metronimo', '0', '2006-08-27 00:00:21', NULL, NULL),
(854, 2, 'Dictionnaire pratique et historique de la musique', 'http://dictionnaire.metronimo.com/index.php?a=index&amp;d=1', ' Les définitions proviennent du dictionnaire pratique et historique de la musique par Marie BOBILLIER, - en littérature Michel BRENET, - édité en 1926. Il n''y a donc pas de termes en rapport avec  le jazz, le rock, la musique contemporaine, etc. Si vous ne trouvez pas ici les renseignements dont vous avez besoin, consultez l''annuaire de Métronimo ou l''annuaire dmoz. Certaines définitions ont été modifiées pour rester d’actualité. Vous pouvez télécharger le dictionnaire original au format pdf sur le site Gallica (Bibliothèque Nationale de France).\r\n', 'dictionnaire:musique;histoire', 'metronimo', '0', '2006-08-26 23:58:13', NULL, NULL),
(852, 2, 'Logiciel pour jouer au xylophone', 'http://www.metronimo.com/fr/jeux/index.php?page=xylophone', 'Possibilité de jouer au xylophone en ligne.\r\n', 'musique;instrument;xylophone', 'metronimo', '0', '2006-08-26 23:51:52', NULL, NULL),
(853, 2, 'Annuaire de musique', 'http://www.metronimo.com/fr/annuaire/', 'Diffusion - Interprètes - Radios - Sonorisation - Spectacles - Studios\r\nAnalyses - Apprendre un instrument - Enseignement à distance - Formation - Théorie\r\nEditeurs de partitions - Educatifs - MP3 - Séquenceurs\r\nFormes et genres - Les compositeurs - Les époques - Musique de film\r\nrique - Amérique du nord - Amérique latine, centrale, du Sud - Asie - Europe - Moyen-Orient\r\nChanson française - Country - Danse - M.A.O. - Musique électronique - Musique mécanique - Pop, rock - Punk, hardcore, hardrock, métal - Rap, Hip hop - Reggae', 'musique;annuaire', 'metronimo', '0', '2006-08-26 23:56:26', NULL, NULL),
(851, 2, 'Logiciel de mémoire - reproduire des séquences sonores', 'http://www.metronimo.com/fr/jeux/index.php?page=memogame', 'Reproduire les séquences sonores en suivant les couleurs', 'logiciel;mémoire;musique;attention', 'metronimo', '0', '2006-08-26 23:48:39', NULL, NULL),
(850, 2, 'Jeux du pendu pour la musique', 'http://www.metronimo.com/fr/jeux/pendu/', ' 5 jeux où vous devez deviner les noms d''instruments, de compositeurs, de chanteurs, de musiciens de jazz, de danses avant que Métronimo ne soit pendu\r\nChoisissez le thème du pendu :\r\nLes compositeurs\r\nLes instruments\r\nLe jazz\r\nLes danses\r\nLa chanson française', 'musique;jeux;compositeurs;instruments;danses;jazz;chanson', 'metronimo', '0', '2006-08-26 23:46:09', NULL, NULL),
(849, 2, 'Mots mêlés sur le thème de la musique', 'http://www.metronimo.com/fr/jeux/index.php?page=motscaches', 'liquez sur le thème de votre choix parmi ceux proposés ci-dessous :\r\n\r\n    * Les compositeursExemple\r\n    * Les instruments\r\n    * Le jazz\r\n    * Les danses\r\n    * La chanson française (A-C)\r\n    * La chanson française (D-L)\r\n    * La chanson française (M-Z)\r\n    * Les contemporains de Beethoven\r\n    * Les contemporains de Mozart\r\n    * Les opéras de Puccini\r\n    * Les œuvres orchestrales de Maurice Ravel\r\n    * Les œuvres symphoniques de George Gershwin\r\n    * Le Carnaval des Animaux de Camille Saint-Saëns\r\n    * Chopin et le piano\r\n    * Les opéras de Verdi\r\n    * Les opéras de Rossini\r\n', 'musique;jeux;mots;mêlés', 'metronimo', '0', '2006-08-26 23:43:15', NULL, NULL),
(848, 2, 'portraits de compsiteurs en musique-Puzzle', 'http://www.metronimo.com/fr/jeux/megapuzzle/', 'Méga Puzzle avec des portraits de compositeurs', 'puzzles;compositeurs;musique', 'metronimo', '0', '2006-08-26 23:41:47', NULL, NULL),
(847, 2, 'Jeux de quiz de reconnaissance de musique', 'http://www.metronimo.com/fr/jeux/quiz/', '    *   Reconnaissance de musiques\r\n    * Lecture de notes\r\n    * Les prénoms de chanteurs français\r\n    * Les compositeurs\r\n    * Les instruments\r\n    * Divers\r\n', 'musique:quiz;compositeurs;instuments;chanteurs', 'metronimo', '0', '2006-08-26 23:39:41', NULL, NULL),
(846, 2, 'Un site pour télécharger les partitions', 'http://partitions.metronimo.com/', 'Cet annuaire référence des pages contenant des partitions gratuites. Elles proviennent de musiques tombées dans le domaine public. Vous pouvez donc imprimer les partitions et interpréter la musique sans devoir payer de droit d''auteurs. Vous pouvez  utiliser le moteur de recherche ou choisir une catégorie. Les partitions sont classées par compositeur et par instrument.', 'musique;partition;compositeurs;instruments', 'metronimo', '0', '2006-08-26 23:37:37', NULL, NULL),
(845, 2, 'Métronimo Quiz un logiciel pour tester sa culture musicale', 'http://www.metronimo.com/fr/logiciels/index.php?page=quiz', 'Métronimo Quiz - Version 2.30 est un questionnaire contenant plus de 600 questions liées à l''histoire de la musique, aux compositeurs, à la théorie de la musique, aux termes musicaux.\r\nPour jouer, vous devez d''abord télécharger l''interface du jeu, puis ensuite installer les questions.\r\nCe programme permet de jouer seul contre l''ordinateur. Dans ce cas vous pouvez soit vous entraîner, soit essayer de faire le score le plus élevé. Il est aussi possible de jouer à 2 ou à 3 en même temps.', 'musique;quiz,compositeurs', 'metronimo', '0', '2006-08-26 23:34:30', NULL, NULL),
(844, 2, 'Logiciel &quot;Le livre du compositeur&quot;', 'http://www.metronimo.com/fr/logiciels/index.php?page=livre', 'Le livre des compositeurs est un logiciel éducatif dont l''objectif est de vous faire apprendre le nom des plus grands compositeurs de musiques classiques. Ce programme contient 104 compositeurs, 192 portraits, dont 22 caricatures, et 328 musiques.\r\nIl est constitué de 2 parties : une partie ludique, sous forme de jeu du pendu, et une partie encyclopédie.\r\nLa section &quot;encyclopédie&quot; permet d''écouter les musiques, de voir les portraits, l’année de naissance, l’année du décès et la nationalité des 104 compositeurs. Les compositeurs sont classés par ordre alphabétique.\r\nLa section &quot;Jeux&quot; permet de découvrir les compositeurs par l''intermédiaire d''un jeu proche du jeu du pendu.', 'logiciel;gratuit;musique;compositeur', 'metronimo', '0', '2006-08-26 23:31:35', NULL, NULL),
(843, 2, 'Logiciel pour apprendre à reconnaître les instruments de musique', 'http://www.metronimo.com/fr/logiciels/index.php?page=instruments', 'Le jeu consiste à déplacer le nom d''un instrument sur l''image correspondante. \r\n\r\nParmi 24 instruments, le joueur doit reconnaître:\r\n\r\n    * les instruments à vent\r\n    * les instruments à cordes\r\n    * les percussions\r\n    * tous les instruments à partir de leur nom\r\n    * les instruments à partir du nom de leur famille (vent, cordes, percussions)\r\n\r\nChaque section possède 3 niveaux différents (les instruments sont les mêmes, mais le temps pour les reconnaître est différent)', 'musique;instrument;jeux', 'metronimo', '0', '2006-08-26 23:29:22', NULL, NULL),
(841, 2, 'Musical''Ecoles pour le chant choral', 'http://j.lepeintre.free.fr/', 'Un site pour chanter. Un répertoire. Du karaoké. Des pistes pour le chant chorale.', 'musique;chants;chorale', 'jlepeintre@aei.ca', '0', '2006-08-26 23:22:30', NULL, NULL),
(842, 2, 'Logiciels de musique de Métronimo', 'http://www.metronimo.com/fr/logiciels/', 'Ces programmes ludo-éducatifs permettent de tester sa culture musicale, d''apprendre le solfège, les instruments, les compositeurs classiques.\r\n    *  Mini Tétronimo et Les instruments de musique sont gratuits\r\n    * Les autres programmes sont vendus chacun 22 euros.\r\n', 'logiciel;musique;payant', 'metronimo', '0', '2006-08-26 23:27:27', NULL, NULL),
(840, 2, 'Bibliothèque en ligne de l''IRMA', 'http://www.irma.asso.fr/rubrique.php3?id_rubrique=6', 'Le Centre de documentation et de ressources de l’irma propose, en téléchargement ou en lien, une sélection d’ouvrages dont il dispose.\r\nMusiques enregistrées\r\n\r\n    * Economie du secteur phonographique\r\n    * Production, édition et distribution indépendantes\r\n    * Nouvelles technologies\r\n\r\nSpectacles\r\n\r\n    * Reglementations et économie du spectacle\r\n    * Spectacles et développement local\r\n    * Intermittence\r\n\r\nMédia\r\n\r\n    * Audiovisuel\r\n    * Radio\r\n\r\nCréation et droits d’auteur\r\n\r\n    * La création artistique\r\n    * Code de la propriété intellectuelle et droits d’auteur\r\n    * Gestion collective des droits d’auteur et des droits voisins\r\n    * Oeuvres du domaine public\r\n    * Droits d’auteur et téléchargement', 'musique:textes;droits;auteurs;voisins', 'IRMA', '0', '2006-08-26 23:18:24', NULL, NULL),
(839, 2, 'Radio classique pour écouter des morceaux classiques', 'http://www.radioclassique.com/', 'Une radio dédiée au classique.\r\nPossibilité de rechercher une oeuvre dans un moteur de recherche.\r\nLes morceaux présentés sont légendés.', 'musique;écoute;radio', 'Radio Classique', '0', '2006-08-26 23:14:17', NULL, NULL),
(835, 2, 'Tralalère un site musical', 'http://www.tralalere.com/', 'Tralalere.com est un site ludo-culturel et musical destiné aux enfants.Adapté aux 3-10 ans,  le site est personnalisé en fonction du profil de l''enfant.', 'musique;culture', 'www.tralalere.net', '0', '2006-08-26 23:00:25', NULL, NULL),
(834, 2, 'Cats Family un jeu de carte pour développer le calcul mental', 'http://france.catsfamily.net/main/jeuxatelecharger.html', 'Edités par Cat’s Family, Addi Cat’s et Multipli Cat’s sont 2 jeux de cartes à la fois ludiques et éducatifs, dont l’un des objectifs est d’entraîner petits et grands au calcul mental, soit des additions, soit des multiplications. Le but du jeu est de donner toutes ses cartes à ses adversaires en tapant judicieusement sur la souris, carte placée au centre de la table. Ces 2 jeux développent le calcul mental, la concentration, la mémoire et la rapidité. 13,5€ le jeu', 'calcul;mental;additions;mutiplications;', 'Catsfamily', '0', '2006-08-26 22:56:08', NULL, NULL),
(829, 2, 'Editeur de partitions &quot;encore&quot;', 'http://www.gvox.com/encore_fr.php', 'Un logiciel pour éditer des partitions. Un tutoriel', 'musique;partition;encore', 'académie de Reims', '0', '2006-08-26 22:12:21', NULL, NULL),
(830, 2, 'Des fiches pédagogiques de Sébastien Bouvier', 'http://membres.multimania.fr/jsb/fichespedagogiques.html', 'La période baroque et la basse continue-La flûte traversière-Le trombone', 'musique;instrument;baroque;trombone;flûte', 'Sébastien Bouvier', '0', '2006-08-26 22:23:00', NULL, NULL),
(831, 2, 'Musica et Mémoria', 'http://www.musimem.com/', 'Un site pour mieux connaître des compositeurs.', 'musique;compositeurs', '', '0', '2006-08-26 22:26:50', NULL, NULL),
(833, 2, 'Exercice de conversions sur les mesures de longueurs, de masses, de capacités', 'http://www.lyclucor.edres74.net/pagesweb/qcm/indqcm.htm', 'Des exercices de conversion (mesure de longueur, masses, capacité)\r\nFin de cycle 3 collège', 'capacité;masses;longueurs;mathématiques;Cycle3', '', '0', '2006-08-26 22:47:49', NULL, NULL),
(828, 2, 'NoteWorthy Composer, un éditeur de partition gratuit', 'http://www.noteworthysoftware.com/', 'NoteWorthy Composer est essentiellement dédié à la production et l''impression de partitions musicales. On peut le comparer à un petit traitement de texte musical.\r\nUn logiciel à l''essai pour 30  jours.\r\nPour les musiciens et compositeurs.', 'Logiciel;shareware;gratuit;musique;partition', 'jean-jacques.freycon@ac-lyon.fr', '0', '2006-08-26 22:08:52', NULL, NULL),
(827, 2, 'Tutoriaux pour le son', 'http://www.cestfacile.org/audio.htm', 'Le site cestfacile.org propose des tutoriaux pour les formats MP3, Ogg vorbis, MPC, Wav. Les logiciels présentés sont Cdex et Audacity. ', 'AUDIO;MP3;WAV; OGG;VORBIS;MPC;son;logiciel', 'cestfacile.org', '0', '2006-08-26 22:05:39', NULL, NULL),
(826, 2, 'EDUMUSIC La liste de diffusion sur l''éducation musicale à l''école', 'http://membres.lycos.fr/jsb/page18.shtml', 'Objet de la liste :\r\nLa liste edumusic constitue un organe de liaison entre ces différents intervenants en permettant l''échange d''idées et de démarches pédagogiques. Elle rend possible l''expression et la solution de problèmes rencontrés sur le terrain et consolide les fondements de l''enseignement de la musique à l''école.', 'musique;formation', 'Christian Wild', '0', '2006-08-26 22:02:13', NULL, NULL),
(824, 2, 'French chat pour apprendre le Français FLE', 'http://french-chat.com/', 'French Chat est destiné à promouvoir les échanges entre francophones et non-francophones, et aider ces derniers à parfaire leur maîtrise de la langue française. Ici vous rencontrerez des gens venus des quatre coins du monde, des gens de tous âges et de toutes cultures, des gens qui ont en commun de parler ou d''apprendre à parler la langue française.', 'FLE;communication orale;français', '', '0', '2006-08-26 20:30:59', NULL, NULL),
(823, 2, 'Ressources pédagogiques en Français langue étrangère', 'http://www3.sympatico.ca/denis.bussieres/', 'Des fiches pour aborder le Français sur différents thèmes. ', 'FLE;français', 'denis.bussieres', '0', '2006-08-26 20:27:25', NULL, NULL),
(822, 2, 'Les signets de Diane pour des exercices en ligne', 'http://www.lessignets.com/signetsdiane/index.php', 'Des  exercices en ligne:\r\nPréscolaire  Grammaire Mathématiques Lecture Sciences Vocabulaire Verbes Anglais débutant Anglais 2 Jeux de mots. Des liens pour les recherches:Les animaux Les pays du monde Le Québec Le Canada Les fleurs Les arbres La ville de Québec La ville de Montréal Les fruits Les légumes\r\n\r\n	\r\n\r\n', 'exercices;grammaire; sciences;vocabulaire;lecture;anglais;pays;fleurs;arbres', 'Diane', '0', '2006-08-26 20:23:21', NULL, NULL),
(817, 2, 'Jeux de compréhension à l''oral', 'http://www.eslall.com/apprendre_anglais_775.html', 'Jeux sonores en ligne permettant des activités d''écoute sur des thèmes divers.', 'langue;anglais;oral;compréhension', 'eslall.com', '0', '2006-08-26 20:00:09', NULL, NULL),
(818, 2, 'Dossier sur les blogs', 'http://www.francparler.org/dossiers/blogs.htm', 'Textes et retours d''usages des blogs pour la classe.', 'blogs;TIC;B2I', 'francparler.org', '0', '2006-08-26 20:07:29', NULL, NULL),
(820, 2, 'Envirodoc ... une base de ressources sur l''environnement', 'http://www.envirodoc.org/', 'EnviroDoc est un projet d''échanges franco-belges sur l''information, la documentation et l''évaluation en matière d''éducation relative à l''environnement\r\nVous êtes enseignant, animateur, formateur... à la recherche de ressources pédagogiques? Consultez notre base de données d''outils pédagogiques en ligne ! Elle regroupe des centaines d''outils sélectionnés par la Maison de la Nature et de l''Environnement de Lille (France) et le Réseau IDée (Belgique)', 'Environnement;documentation', ' Maison de la Nature et de l''Environnement de Lille (France) et le Réseau IDée (Belgique)', '0', '2006-08-26 20:12:32', NULL, NULL),
(816, 2, 'Sites pour enfants pour apprendre l''anglais', 'http://www.eslall.com/newsletter/Newsletter_june_06.html', 'Site pouvant être un support d''activités en Anglais. A utiliser dès le cycle 3 et au collège.', 'langue;anglais;oral;compréhension', 'eslall.com', '0', '2006-08-26 19:57:16', NULL, NULL),
(813, 2, 'Le monde en tête', 'http://www.mondeentete.net/', '43 activités pédagogiques classées dans trois zones: démocratie, paix et coopération, et selon les trois cycles du primaire et le niveau secondaire.\r\nDes animations destinées aux élèves du 1er cycle, 2e cycle et 3e cycle du primaire', 'démocratie;paix;coopération;citoyenneté;lecture', 'Commission scolaire de Montréal,agence canadienne pour le développement international,', '0', '2006-08-26 18:15:37', NULL, NULL),
(815, 2, 'Production d''un album souvenir', 'http://ecoles.csbf.qc.ca/recit2/scenarios/album.htm', '', '', '', '0', '2006-08-26 18:26:38', NULL, NULL),
(812, 2, 'Déclic sciences technologie -Situations problèmes en sciences', 'http://www.cspi.qc.ca/cpp/sciences/index.php', 'À tire-d’aile. Cette problématique permet aux élèves de se familiariser avec le fonctionnement des machines qui se déplacent grâce à l’action de l’air.Situations d’apprentissage en sciences au cycle 3\r\nCette section contient différents type de situations d’apprentissage que vous pouvez utiliser en science et technologie.  Problématiques pour le  -  1er cycle   -  2e cycle  -  3e cycle\r\n\r\n', 'sciences;techologie;air', 'Alexandre Gaudreau', '0', '2006-08-26 18:10:39', NULL, NULL),
(811, 2, 'À tire-d’aile: Les techniques du mouvement au cycle 3', 'http://station05.qc.ca/csrs/bouscol/propositions.asp?act=listepropo&amp;pkpropositions=4196', 'Travail documentaire et expérimental proposé . Ressources Internet\r\nÀ tire-d’aile: Les techniques du mouvement\r\nhttp://www.cspi.qc.ca/cpp/sciences/article.php?id_article=62\r\nÀ tire-d’aile: Les techniques du mouvement - Guide de l’enseignant\r\nhttp://www.cspi.qc.ca/cpp/sciences/IMG/pdf/tire_aile_guide.pdf', 'mouvement;sciences;technologie;cycle3;air', 'Martine Laurin, Hélène Paquin, Annick Lysight, Geneviève Pelechaty, des Samar', '0', '2006-08-26 18:03:47', NULL, NULL),
(809, 2, 'A la recherche des dinosaures', 'http://ecoles.csbf.qc.ca/recit2/scenarios/dino.htm', 'Ressources Internet - À la recherche des dinosaures (Projet TIC))\r\nhttp://ecoles.csbf.qc.ca/recit2/scenarios/dino.htm\r\n Objectifs et/ou Compétences\r\nÀ partir d’une lecture basée sur le thème «Les dinosaures et la préhistoire», j’ai ciblé leur intérêt en leur proposant de réaliser une recherche deux à deux.\r\n\r\n ', 'préhistoire;histoire;dinosaures', 'dfortier@csbf.qc.ca', '0', '2006-08-26 17:56:22', NULL, NULL),
(805, 2, 'Ressources pour l''AIS', 'http://perso.orange.fr/m.duplessy/', 'Des liens, des articles, des références pour l''AIS.', 'AIS;enseignement;spécialisé;intégration;adaptation', 'Duplessy', '0', '2006-08-26 17:10:31', NULL, NULL),
(807, 2, 'Bêtes pas bêtes', 'http://radio-canada.ca/jeunesse/betes/index.html', 'Bêtes pas bêtes+, c''est plein d''animaux à découvrir!\r\nDécouvre quel est l''animal Internet de la semaine ', 'animaux;lecture;document;', 'radio-canada.ca', '0', '2006-08-26 17:47:15', NULL, NULL),
(804, 2, 'Jeux pour les cours d''école', 'http://www.cslaval.qc.ca/prof-inet/anim/rec-jeux/recherche.asp', 'Un répertoire de jeux pour la cour d''école. On peut trouver les jeux par âge \r\n5 ans  \r\n 6 - 7  \r\n 8 - 10  \r\n 11 - 12 \r\nLe site « Les jeux des cours d''écoles » est un outil de support à la réalisation du projet que l''on complète au fur et à mesure de son déroulement.\r\n\r\n', 'jeux;cour;EPS', 'jeanfrancois2004@videotron.ca', '0', '2006-08-26 17:07:33', NULL, NULL),
(801, 2, 'Exemples de podcasts réalisés avec des élèves', 'http://pedagogie.ac-toulouse.fr/eco-pri-hivernerie-gourdon/article.php3?id_article=101', 'Productions orales et diffusées par Podcast', 'lecture:oral;récit', 'Ecole Hivervenie', '0', '2006-08-26 16:52:30', NULL, NULL),
(800, 2, 'Actualités-Journal fabriqué par des élèves', 'http://pedagogie.ac-toulouse.fr/eco-pri-hivernerie-gourdon/rubrique.php3?id_rubrique=53', 'Un journal en ligne fabriqué par les enfants pour les enfants. ', 'journal;actualités;presse;cycle3;cycle2', 'Ecole Hivervenie', '0', '2006-08-26 16:50:15', NULL, NULL),
(799, 2, 'Règles de vie en images', 'http://pedagogie.ac-toulouse.fr/eco-pri-hivernerie-gourdon/article.php3?id_article=69', 'Un roman-photos pour les règles de vie en images.\r\nPeut-être réalisé en utilsant le logiciel Open Office et Impress', 'citoyenneté;images;romans;photos;', 'Ecole Hivervenie', '0', '2006-08-26 16:44:11', NULL, NULL),
(786, 2, 'Questionnaire de lecture-Charlie et la chocolaterie', 'http://www.enseignons.be/fondamental/preparations-18-ls--charlie-et-la-chocolaterie-1192.html', 'Questionnaire dynamqique en ligne de lecture . Vérification de la compréhension du texte chapitre par chapitre du roman de Roald Dahl.', 'lecture;compréhension;littérature;Charlie;chocolaterie;Roald;Dahl;cycle3', 'Michel Neroucheff', '0', '2006-08-18 08:54:54', NULL, NULL),
(783, 2, ' Logiciel RomansTic', 'http://perso.orange.fr/jm.campaner/jmc_RomansTic/index.htm', ' RomansTic travaille la compréhension du texte, mais aussi des notions orthographiques et grammaticales à partir de la littérature Jeunesse. Le premier roman à disposition est &quot;Un Serpent dans la Peau&quot; de Philippe Tassel, qui est également disponible gratuitement en téléchargement sur son site. Utilisable au cycle 3.\r\n\r\n', 'logiciel;lecture;roman;freeware;cycle3', 'Jean-Marc Campaner', '0', '2006-08-15 17:41:12', NULL, NULL),
(782, 2, 'Loto des associations pour organiser un loto', 'http://perso.orange.fr/jm.campaner/jmc_Loto/index.htm', 'Pour organiser un Loto au profit de votre coopérative, votre foyer socio-éducatif ou votre association, le logiciel (version 32 bits) génère des cartons de loto (à usage unique ou non) tous différents et permet de les imprimer à raison de 2, 3 ou 6 par feuille ainsi qu''une fiche de contrôle des gagnants.\r\nSi un ordinateur est présent dans la salle, il peut aussi contrôler automatiquement les gagnants en cours de partie et même assurer le tirage en évitant les ex-aequos !', 'coopérative;loto;logiciel;shareware', 'Jean-Marc Campaner', '0', '2006-08-15 17:38:16', NULL, NULL),
(781, 2, 'Présente3 un logiciel pour produire des CD-Roms', 'http://perso.orange.fr/jm.campaner/jmc_Presente3/index.htm', 'PRESENTE3 permet de réaliser des présentations multimédia destinées à être gravées sur un cédérom', 'multimédia;logiciel;shareware', 'Jean-Marc Campaner', '0', '2006-08-15 17:36:09', NULL, NULL),
(780, 2, 'Logiciel  Edusprint', 'http://perso.orange.fr/jm.campaner/jmc_Edusprint/index.htm', 'Dans Edusprint, deux joueurs d’âges différents s’affrontent par l''intermédiaire de questions adaptées sans que le plus jeune soit nécessairement pénalisé. Le jeu se présente sous la forme d’un circuit de course de voitures, chacun des deux pilotes s’efforçant de parvenir à la victoire en répondant à un questionnaire multimédia à choix multiple tout au long du parcours. ', 'logiciel;shareware;ORL;lecture;cycle2;cycle3;gratuit;histoire;géographie', 'http://perso.orange.fr/jm.campaner/jmc_Edusprint/index.htm', '0', '2006-08-15 17:11:58', NULL, NULL),
(779, 2, 'Logiciel  WEXR - les exerciseurs', 'http://perso.orange.fr/jm.campaner/jmc_Wexr/index.htm', 'En version 32 bits, ces exerciseurs multi-disciplines pour les cycles II, III et le Collège, sont répartis en 8 modules indépendants : Apparie, Associe, Désordre, Questionnaire, Reconstitution de texte/autodictée, Relie, exercices à Trous et Souligne. Ils sont fournis avec 627 exercices de base du CP au Collège. Ils intègrent une gestion des groupes d''élèves, des bilans ainsi qu''un éditeur permettant de saisir de nouveaux exercices.\r\n', 'logiciel;shareware;ORL;lecture;cycle2;cycle3;gratuit', 'Campaner', '0', '2006-08-15 17:09:00', NULL, NULL),
(778, 2, 'Logiciel de contrôle de lecture silencieuse', 'http://perso.orange.fr/jm.campaner/jmc_cls/index.htm', 'Pour inciter les élèves de cycle III et de Collège à aller au bout d''un roman. Idéal lorsqu''on n''a qu''un seul ordinateur en fond de classe. Le logiciel en version 32 bits réseau avec l''éditeur de questions pour créer ses propres questionnaires en plus des 212 romans disponibles.', 'logiciel;shareware;ORL;lecture;ENT;cycle3', 'Campaner', '0', '2006-08-15 17:06:59', NULL, NULL),
(777, 2, 'Thematic un ENT pour l''orthographe', 'http://perso.orange.fr/jm.campaner/jmc_Thematic/index.htm', 'Un environnement de travail complet pour développer et mutualiser des exercices par l''intermédiaire du Web. Le logiciel est fourni dans un premier temps avec une progression d''ORL pour le cycle III.\r\nIl est fourni avec 89 fichiers qui couvrent le programme d''ORL du premier trimestre du CE2. Cependant c''est principalement un programme auteur qui permet de créer et mutualiser des exercices et des progressions par l''intermédiaire du WEB. La licence shareware donne accès à la totalité des éditeurs d''exercices et à environ 300 exercices supplémentaires pour l''ORL au cycle III.30 Euros pour la licence', 'logiciel;shareware;ORL;orthographe;ENT;cycle3;payant', 'Campaner', '0', '2006-08-15 17:01:23', NULL, NULL),
(776, 2, 'Logiciel  1000 mots pour apprendre à lire', 'http://perso.orange.fr/jm.campaner/jmc_1000MOTS/index.htm', 'Ce logiciel propose 14 exercices de lecture (écoute, reconnaissance globale, décomposition syllabique) qui viennent enrichir les activités proposées au fil des leçons des principales méthodes de lecture qu''on trouve dans les classes. S''appuyant sur un imagier visuel et sonore de 1200 mots, il est fourni avec un éditeur qui permet de l''adapter au niveau des apprenants. Logiciel destiné aux enfants de CP mais aussi de GS, de CE1 et aux primo-arrivants. On le trouve également souvent en rééducation orthophonique. Logiciel en shareware.', 'logiciel;shareware;lecture;cycle2', 'Campaner', '0', '2006-08-15 16:59:03', NULL, NULL),
(774, 2, 'Ecouter des histoires en Anglais', 'http://www.bookpop.com/index2.html', 'Une série de libres lus par l''auteur du site', '', 'Stephen Cosgrove', '0', '2006-08-12 12:35:50', NULL, NULL),
(775, 2, 'Google Scholar', 'http://scholar.google.com/schhp?hl=fr', 'Un moteur de recherche pour des articles de fonds et des productions  universitaires.\r\nGoogle Scholar permet d''effectuer facilement une recherche étendue portant sur des travaux universitaires. Vous pouvez, à partir d''un emplacement unique, explorer un grand nombre de domaines et de sources : articles revus par des comités de lecture, thèses, livres, résumés analytiques et articles. Ces travaux peuvent provenir de sources telles que des éditeurs scientifiques, des sociétés savantes, des référentiels de prépublication, des universités et d''autres organisations de recherche. \r\n', 'pédagogie;didactique;enseignement;moteur;recherche', 'Google', '0', '2006-08-13 22:29:26', NULL, NULL),
(773, 2, 'Le site BabyKB.com pour apprendre l''anglais', 'http://www.BabyKB.com/', 'Tu rentres dans une maison. Tu peux choisir une chambre que tu as envie de visiter.Tu cliques sur les objets de la chambre. On te dit en anglais ce que cela représente. On te dit des phrases.\r\n', 'vocabulaire;anglais;maison;', 'BabyKB.com', '0', '2006-08-12 11:40:50', NULL, NULL),
(770, 2, 'Dictionnaire en images (French-english)', 'http://www.enchantedlearning.com/languages/french/Hisfor.shtml', 'Un dictionnaire avec des thèmes simples pour l''école élémentaire', 'langues;vivantes;images;anglais', 'enchantedlearning.com', '0', '2006-08-12 10:59:00', NULL, NULL),
(771, 2, 'S''entraîner en mathématiques avec un logiciel en ligne', 'http://www.edbydesign.com/maths/', 'Un site en anglais mais utilisable dans les classes. Entraînement pour les 4 opérations. La division;la soustraction;l''addition', 'mathématiques;cycle2;cycle3;division;opération;soustraction;addition;logiciel;gratuit', 'edbydesign', '0', '2006-08-12 11:05:52', NULL, NULL),
(768, 2, 'Comment construire une progression en langues vivantes au cycle 3', 'http://www.primlangues.education.fr/forums/list.php?f=1', 'Un forum riche en pistes et en réflexions pour construire une progression ou une programmation.', 'langues;vivantes;progression', 'Primlangue CIEP', '0', '2006-08-12 00:16:02', NULL, NULL),
(764, 2, 'Site Educnet pour les langues vivantes', 'http://www.educnet.education.fr/dossier/langues/', 'Portail pour l''enseignement des LV.\r\nDonnées générales sur l''enseignement des langues. De nombreux liens.', 'langues;vivantes;', 'gouvernement Education Nationale', '0', '2006-08-12 00:01:12', NULL, NULL),
(767, 2, 'Jeux en Anglais-Word et pictures de la BBC', 'http://www.bbc.co.uk/schools/wordsandpictures/index.shtml', 'Un site dela BBC pour s''entraîner. Des jeux \r\nBuild a sandcastle and get to know the common spelling patterns for the Year 2 vowel phonemes.\r\nHelp Salty Sam write a postcard and get used to using words containing alternative spelling patterns for vowel phonemes in sentences.\r\nWatch how Magic Pencil writes some words containing vowel phonemes. Then have a go yourself.\r\nHave some fun playing the games and doing the activity sheets.  \r\n', 'langues vivantes;jeux;anglais;cycle3', 'BBC', '0', '2006-08-12 00:12:54', NULL, NULL),
(763, 2, 'Le logiciel Plopp ... un logiciel pour la 3 D pour les enfants', 'http://www.planet-plopp.de/', 'Un logiciel payant qui est une petite merveille permettant aux élèves de créer des dessins en 3 dimensions.\r\n14,95 EUR . Le logiciel est pour l''instant en Allemand mais les logos sont très évocateurs pour une utilisation fonctionnelle du logiciel.', 'arts;visuels;logiciel;payant', 'Editeur Terzio', '0', '2006-08-11 22:23:21', NULL, NULL),
(761, 2, ' Les météorites : 2 aventures en bande dessinée interactive', 'http://meteorites.bw.qc.ca/main.html', ' «Les météorites, l’aventure commence» et « Les météorites, l’aventure continue» sont deux bandes dessinées interactives réalisées en Flash.Une réalisation intéressante et de qualité pour les jeunes de 10 ans et plus...', 'astronomie;lecture;bande;dessinée', 'Bienvenue Welcome Multimédia -Ministère de la culture et de la communication du Québec-Uni Mac-Gill', '0', '2006-08-11 17:13:27', NULL, NULL),
(760, 2, 'Atelier d’écriture de contes de la BNF', 'http://expositions.bnf.fr/contes/pedago/atelier/index.htm', 'L’atelier d’écriture de contes de la bibliothèque nationale de France vous propose d’inventer vous-même un récit à partir d''une sélection d''ingrédients d''un conte. Ecrivez-le ou improvisez en racontant l''histoire autour du fil conducteur et des illustrations qui vous sont proposés. Vous choisissez :\r\n    * Le héros ou l''héroine\r\n    * Le départ\r\n    * L''arrivée\r\n    * La raison\r\n    * Les épreuves\r\n    * Un pays inconnu\r\n    * Les rencontres\r\n    * L''objet magique\r\n    * La récompense\r\n    * La morale ', 'contes;écriture;récits', 'BNF', '0', '2006-08-11 17:07:51', NULL, NULL),
(759, 2, 'Logiciel  &quot;J''écoute puis j''écris&quot; pour le cycle 2 et le cycle 3', 'http://pragmatice.net/jecoutepuisjecris/telechargement.htm', ' Le logiciel  &quot;J''écoute puis j''écris&quot;  est offert par l''association PragmaTICE. Il est gratuit et librement diffusable à certaines conditions. Ce logiciel permet de s''entraîner à saisir précisément un mot, une expression ou un nombre après l''écoute d''un message sonore, en s''aidant éventuellement d''une image et/ou d''un texte d''accompagnement. Si le message sonore est strictement l''expression à saisir, le logiciel entraîne l''élève à écrire sous la dictée en respectant l''orthographe. Principe du logiciel : l''élève écoute un message sonore, puis saisit sa réponse.', 'dictée;orthographe;ORL', 'association PragmaTICE', '0', '2006-08-11 16:39:26', NULL, NULL),
(758, 2, ' Logiciel &quot;Je lis puis j''écris&quot;  Entraînement à l''écriture pour le cycle 2 et le cycle 3', 'http://pragmatice.net/jelispuisjecris/telechargement.htm', 'Je lis puis j''écris proposé gratuitement par l’association PragmaTICE permet de s''entraîner à saisir précisément un mot, une expression, une phrase, un texte, un nombre, etc... après les avoir lus et mémorisés. \r\nLes éléments à saisir sont contenus dans un fichier texte (TXT) dont le nom est celui qui est attribué à l’exercice. Ce dernier se compose d’un ou plusieurs items (en général des phrases) qui sont présentés soit dans l’ordre aléatoire (par défaut), soit dans un ordre déterminé (s’il est inscrit ORDRE sur la première ligne du fichier texte). Chaque item peut être segmenté en empans afin d’être mémorisé puis saisi en plusieurs temps. ', 'écriture;lecture;mémorisation;copie;dictée;cycle2;cycle3', ' Eric Chenavier, Frédéric Mathy et Cédric Thivind', '0', '2006-08-11 16:31:32', NULL, NULL),
(757, 2, 'Le site du réseau In-Terre-Actif', 'http://www.in-terre-actif.com/fr/index.php', 'Le Réseau In-Terre-Actif est un outil d’éducation à la citoyenneté permettant aux jeunes d’être sensibilisés aux enjeux mondiaux actuels et de jouer un rôle en solidarité internationale. C’est un lieu d’échange d’informations, d’engagement, d’animation, de jeux et de libre circulation des idées en faveur du développement durable et d’un monde plus juste et fraternel.Le Réseau In-Terre-Actif s’avère aussi être une boîte à outils pour les enseignants (3e cycle du primaire et secondaire). Il offre du matériel pédagogique portant sur des thématiques reliées, de près ou de loin, à l’exercice de la citoyenneté et à la solidarité internationale. Tu peux envoyer des articles à la salle de presse', 'citoyenneté;solidarité;presse;actualités', 'in-terre-actif.com', '0', '2006-08-11 16:21:58', NULL, NULL),
(755, 2, 'Ecole de FLE en ligne', 'http://www.bonjourdefrance.com/index/indexapp.htm', 'Bonjour de France, le magazine pour étudier le français en ligne, vous propose une série d''images centrée sur un thème comportant des éléments &quot;hypertexte&quot; qui renvoie à une explication et suivie d''un jeu afin de tester votre mémorisation. Les textes et exercices peuvent être librement utilisés en cours de français.\r\nUtilisable pour les parents de primo-arrivants qui veulent apprendre le français.', 'FLE;langue;grammaire;conjugaison;vocabulaire;compréhension', 'Ecole Azurlingua', '0', '2006-08-11 15:49:04', NULL, NULL),
(754, 2, 'Radio junior, la radio pour les enfants', 'http://www.radiojunior.com/', 'Un site de radio dédié aux enfants.\r\nPour rechercher un sujet, un dossier, une recette, un artiste ou tout autre chose, tape un mot ou une phrase dans la case ci-dessous et ensuite, appuie sur le bouton &quot;chercher&quot;.Possibilité d''écouter des émissions pour les enfants.', 'radio;moteur;recherche;dossier;actualités', 'radiojunior', '0', '2006-08-11 15:33:13', NULL, NULL),
(752, 2, 'Le site Astro-nature', 'http://stbourge.chez-alice.fr/', 'Avec ce site, on pourra observer le ciel et le comprendre\r\n-Observer notre étoile : le Soleil\r\n-La durée du jour. La durée de la nuit.\r\n -Les saisons sur la Terre.\r\n -La Lune et ses phases.\r\nDes documents intéressants pour aborder l''astronomie au cycle 3', 'astronomie;lune;étoile;saisons;jour:nuit', 'Stephane.bourge@libertysurf.fr', '0', '2006-08-11 10:01:07', NULL, NULL),
(750, 2, 'Des livres qui cliquent', 'http://ecoles.uneq.qc.ca/', 'Des exemples de pistes pour aborder la littérature Jeunesse à l''école; les albums; les oeuvres longues.\r\nActivités pédagogiques autour de la littérature Jeunesse', 'littérature ;lecture;écriture;romans;livres;albums', '/ecoles.uneq.qc.ca', '0', '2006-08-04 22:00:05', NULL, NULL),
(751, 2, 'Cyberpoésies pour le cycle 2 et le cycle 3', 'http://www.cyberpoesie.net/html/enfants.html', 'Des poésies animées à lire à l''écran. Des jeux en ligne.', 'poésies;lecture,jeux', 'cyberpoesie.ne', '0', '2006-08-04 22:07:34', NULL, NULL),
(745, 2, 'L''aventure des écritures', 'http://classes.bnf.fr/dossiecr/index.htm', 'Tout savoir sur les écritures.', 'écriture;lettres;histoire', 'BNF', '0', '2006-08-04 21:27:35', NULL, NULL),
(746, 2, 'Petite histoire des écritures', 'http://lesecritures.le-nombre.fr/', 'Des textes assez simples et des illustrations sur les différentes écritures et alphabets', 'écriture;histoire;alphabets', 'Patrick Bresson', '0', '2006-08-04 21:30:17', NULL, NULL),
(743, 2, ' Miro  pour le cycle 2 et le cycle 3', 'http://education.france5.fr/miro/index.html', 'Tu peux découvrir les oeuvres et la vie de Miro. Tu pourras accéder à une vidéo et un labo interactif.\r\nLe texte est simple et abordable dès le CE1. Exploitable au cycle 3(CE2,CM1,CM2)', 'arts;visuels;Paul;Miro;vidéo', 'Centre Pompidou et France 5', '0', '2006-08-04 21:19:55', NULL, NULL),
(742, 2, 'Paul Gaughin expliqué aux enfants', 'http://education.france5.fr/gauguin/index.html', 'Un site de France 5 pour découvrir Paul Gaughin, son oeuvre, sa vie. Tu pourras visionner une vidéo , jouer en ligneret tester tes connaissances avec un quiz.Utilisable dès le cycle 3(CE2,CM1,CM2)', 'arts;visuels;Paul;Gaughin;vidéo', 'France 5 et la réunion des musées nationaux.', '0', '2006-08-04 21:16:25', NULL, NULL),
(740, 2, 'Décodart ... Le sens caché de l''art', 'http://education.france5.fr/decodart/home.html', 'Décodart analyse, compare, explore des peintures de maîtres.Nature morte -La Joconde -Léonard de Vinci-Arcimboldo- Lumières dans la nuit-Picasso - Le rêve de Pierrot', 'arts;visuels;analyse;regard;', 'France 5 Education', '0', '2006-08-04 21:02:35', NULL, NULL),
(741, 2, 'Le cirque Plume', 'http://www.cirqueplume.com/', 'Site sur le cirque Plume. C''est plein de surprises et beau à voir.\r\n&quot;Le spectacle de cirque est un spectacle vivant.Le spectacle du Cirque Plume est fait par des vivants pour des vivants ;\r\nIl est joyeux, coloré, profond, poétique, sale, brouillon, précis, il est comme la vie.&quot; Bernard Kudlack', 'cirque;lecture', 'Cirque Plume - Tania Rinnert - Galliot.com 2Jean-Marie Jacquet, membre fondateur du Cirque Plume', '0', '2006-08-04 21:04:30', NULL, NULL),
(737, 2, 'Les instruments du monde', 'http://www.instrumentsdumonde.com/index.php', 'Tu as découvrir un musée virtuel d''instruments de musique riche d''environ 150 pièces. Cette collection unique représente le fruit de nombreux voyages : du violon Er-hu chinois, en passant par la flûte Ney turque, la harpe Seng de Birmanie, près de 33 pays sont ainsi représentés.Tous ces instruments sont classés par continent puis par pays, mais vous pouvez également les rechercher suivant leur mode de mise en vibration', 'musique;monde;écoute', 'Alexis AUBRY', '0', '2006-08-04 20:29:38', NULL, NULL),
(739, 2, 'ABCdaire en anglais', 'http://www.bemboszoo.com/Bembo.swf', 'Un ABCEdaire très beau visuellement. Tu cliques sur une lettre. Puis ... effet de surprise... les lettres bougent et représentent un mot. Exploitable en arts .', 'lettres;ABCdaire;anglais;abécédaire', 'bemboszoo.com', '0', '2006-08-04 20:49:13', NULL, NULL),
(735, 2, 'Des grands compositeurs en musique', 'http://www.artsalive.ca/fr/mus/greatcomposers/', 'Sélectionne le compositeur qui t'' intéresse le plus. Les textes rédigés à son sujet te  transporteront dans un autre pays et une autre époque. ', 'musique;compositeurs', 'Centre national des Arts', '0', '2006-08-04 20:07:27', NULL, NULL),
(736, 2, 'Flût@lors pour des cours de flûte en ligne', 'http://www.csdraveurs.qc.ca/musique/flutalors/', 'Tu apprends à jouer de flûte en ligne. Tu as les doigtés\r\n			\r\n', 'musique;instruments;flûte', 'webphonie@iquebec.com', '0', '2006-08-04 20:21:33', NULL, NULL),
(734, 2, 'Ecouter les baladiffusions et Posdcats', 'http://www.artsalive.ca/fr/mus/musicresources/podcasts.html', 'Répertoire de baladodiffusion du CNA.  Un balado est un fichier audio qu''il est possible de télécharger en format MP3 ou dans un format de balado rehaussé (AAC). On peut le télécharger et l’écouter en cliquant sur un lien dans une page Web.\r\n', 'musique;podcast;baladodiffusion', 'Centre national des Arts', '0', '2006-08-04 20:04:17', NULL, NULL),
(732, 2, 'Banque d''images sur les instruments de musique du moyen-âge', 'http://www.instrumentsmedievaux.org/pages/depart.html', 'Une banque d''images sur les instruments de musique au moyen âge faites par l''auteur du site.', 'musique;écoute;histoire;moyen;âge', 'Christian Brassy', '0', '2006-08-04 18:59:13', NULL, NULL),
(733, 2, 'Le labo d''instruments pour le cycle 2 et le cycle 3', 'http://www.artsalive.ca/fr/mus/instrumentlab/', 'Pour tester et écouter des instruments en ligne.\r\nFais l''expérience en ligne de tous vos instruments préférés! \r\nDans ce Labo d''instruments tu peux  écouter et manipuler « virtuellement » tous les instruments de l''orchestre.\r\nTu pourras te familiariser  avec l''orchestre tout entier. Pour le cycle 2 (CP,CE1) et le cycle 3 (CE2,CM1,CM2)', 'musique;instruments;écouter;manipuler;cycle2;cycle3', 'Centre national des Arts', '0', '2006-08-04 19:58:28', NULL, NULL),
(731, 2, 'Instruments et musiques du Moyen Age', 'http://www.instrumentsmedievaux.org/', 'Tu cliques sur un instrument du moyen âge  et tu as directement sur sa page, toutes les informations.\r\nTu peux écouter quelques extraits d''enregistrements de référence où chaque instrument est mis en valeur. Ces enregistrements sont de simples citations, d''une durée inférieure à 45 secondes.Représentation d''instruments dans l''art du moyen âge ( enluminures ...)', 'musique;écoute;histoire;moyen;âge;enluminures', 'Christian Brassy', '0', '2006-08-04 18:51:35', NULL, NULL),
(729, 2, 'Site &quot;les débrouillards&quot;', 'http://www.lesdebrouillards.qc.ca/applicationWeb/pages/publique/', 'Un site pour faire des sciences. Des défis, des magazines en sciences, des expériences. Le Webbabillard avec des sciences en question.', 'sciences;magazines;défis;actualités', 'club débrouillard', '0', '2006-08-04 18:44:30', NULL, NULL),
(730, 2, 'A quoi servent les emballages ? Un site de France5 pour le cycle 3', 'http://education.france5.fr/MINTE/MINTE10901/page_10901_71560.cfm', 'Un site dédié pour les emballages. De nombreuves vidéos. Tu peux rentrer dans le labo-interactif.Utilisable dès le cycle 3 (CE2,CM1,CM2)', 'sciences;environnement;citoyenneté;lecture;emballages', 'France 5 Education', '0', '2006-08-04 18:48:04', NULL, NULL),
(727, 2, 'Jeux et expériences interactifs de la cité des sciences', 'http://www.cite-sciences.fr/francais/experiences_ligne.htm#', 'Expérimentez avec des interactifs ludiques, jouez, explorez, bricolez... Faites le en ligne et si vous avez aimé, venez à la Cité pour en savoir plus, pour découvrir d''autres manipulations dans chacune de ses expositions.', 'jeux;physique;biologie;arts;informatique;bricolage;environnement;logique;expériences', 'cité des sciences', '0', '2006-08-04 18:34:36', NULL, NULL),
(728, 2, 'Les phases de la lune au cycle 3', 'http://www.mcq.org/societe/phases_lunaires/', 'Pourquoi la Lune brille-t-elle?\r\nTantôt ronde, tantôt fin croissant, la Lune change d''aspect tout au long du mois lunaire. Pourquoi?  Étant une boule suspendue dans l''espace, la Lune est toujours à moitié éclairée par le Soleil. La Lune tournant autour de la Terre, cette partie éclairée change continuellement d''apparence, d''où les phases de la Lune. Pour mieux visualiser ce phénomène, le site te propose d''utiliser une démonstration interactive.', 'sciences;astronomie;cycle3;lecture;expériences;observations', 'musée de la civilisation', '0', '2006-08-04 18:39:31', NULL, NULL),
(726, 2, 'Electropolis ... un site du musée Electropolis  pour aborder l''électricité', 'http://www.electropolis.tm.fr/frgenie.html', 'Ce site te propose des montages très simples à effectuer à la maison ou en classe. Ils sont pour chacun d''entre eux accompagnés d''un texte explicatif.Les phénomènes électrostatiques, la pile électrique, la danse des pantins, un électro-aimant;une lampe électrique.', 'sciences;électricité;musée;lecture;cycle3', 'Musée Electropolis', '0', '2006-08-04 18:30:40', NULL, NULL),
(725, 2, 'Le site de Pascal Blondé ...un passionné des volcans', 'http://pascal-blonde.info/pblonde.html', 'Pascal Blondé est un passionnée de volcans et il a fait un site sur ce thème.\r\nTu pourras voir tous ses reportages, ses photos et ses commentaires.', 'volcans;sciences;lecture', 'Pascal Blondé', '0', '2006-08-04 18:17:36', NULL, NULL),
(723, 2, 'Découvrir l''univers brûlant des volcans avec France5', 'http://www.curiosphere.tv/index.cfm?mot_clef=volcans&typeObjet=3', 'Un site pour découvrir les volcans. Tu seras invité(e) à passer dans le laboratoire interactif.Utilisable dès le cycle 3\r\n( CE2,CM1,CM2)', 'volcans;sciences;lecture;cycle3', 'France 5 Education et Larousse', '0', '2006-08-04 18:07:58', NULL, NULL),
(722, 2, 'Défi pour la Terre un site pour le cycle 3', 'http://www.defipourlaterre.org/juniors/', 'Avec Polo, relève le défi pour la Terre. Des informations. \r\nRelever le Défi pour la Terre, c’est s’engager  à réduire son impact sur l’environnement à travers des gestes simples et concrets au quotidien. Tu choisiras des défis à relever pour sauver la planète.', 'terre;environnement;sciences;écologie;lecture', 'Adème;Fondation Nicolas Hulot', '0', '2006-08-04 17:47:24', NULL, NULL),
(721, 2, 'L''encyclopédia des sciences de Google', 'http://encyclopedia.erpi.com/science/', 'L''encyclopédi@ des Sciences associe une encyclopédie traditionnelle à un environnement en ligne permettant d''accéder à des informations complémentaires. Le site Internet associé au livre a été créé en collaboration avec Google, le moteur de recherche le plus utilisé au monde. Il guide le lecteur vers les sites Internet les plus intéressants, les plus adaptés aux enfants et les plus étonnants.\r\nMatière et matériaux	Forces et énergie	Électricité et magnétisme	Espace	Terre	Plantes	Animaux	Corps humain', 'sciences;encyclopédie;lecture', 'google, ERPI Jeunesse', '0', '2006-08-04 17:42:33', NULL, NULL),
(720, 2, 'La fenêtre de l''univers... pour s''initier en astronomie', 'http://funivers.free.fr/', 'La Fenêtre de l''Univers va te  permettre d''en apprendre plus sur le Système Solaire : son étoile, ses planètes, ses astéroïdes et ses comètes. Vous pourrez aussi découvrir chacune des 88 constellations, et apprendre à en répérer une partie dans le ciel d''été.Tu peux aussi poser les questions auxquelles vous ne trouvez pas de réponse dans la rubrique Questions / Réponses.Tu trouveras surtout une imposante Galerie de Photos qui compte exactement 456 photos des merveilles de l''Univers, regroupées en catégorie. On t''explique l''éclipse du soleil.Utilisable dès le cycle 3.', 'sciences;astronomie;lecture;cycle3', 'Olivier - Webmaster de La Fenêtre de l''Univers', '0', '2006-08-04 17:36:42', NULL, NULL),
(716, 2, 'A la découverte du cycle de l''eau avec MétéoFrance', 'http://www.meteofrance.com/FR/pedagogie/jeunesse_et_jeux/cycleau/index.html', 'Un personnage qui ressemble à Donald va tout te faire comprendre sur le cycle de l''eau.\r\nUn site avec de belles animations. Il y a des quizs qui t''attendent à chaque étape du cycle.\r\nUtilisable au CE2,CM1,CM2.', 'eau;lecture;sciences;cycle;glace;vapeur;évaporation;cycle 3;jeux', 'météoFrance', '0', '2006-08-04 17:18:45', NULL, NULL),
(718, 2, 'Site  &quot;ma forêt m''a dit&quot; au cycle 3', 'http://www.frapna.org/content/category/7/23/84/', 'Site pour explorer et exploiter la forêt. Dès le cycle 3.\r\nDes activités et des ressources.', 'forêt:lecture', ' FRAPNA Région', '0', '2006-08-04 17:26:38', NULL, NULL),
(719, 2, 'Bricocité le site de la cité des sciences pour bricoler,s''informer', 'http://www.cite-sciences.fr/francais/web_cite/experime/bricocite/frame_brico_fran.htm', 'un site pour les enfants. Tu pourras tout savoir sur les planeurs, les grenouilles rainettes, et puis la menthe ...', 'sciences;bricolage;lecture', 'cité des sciences', '0', '2006-08-04 17:32:08', NULL, NULL),
(715, 2, 'Les différents états de l''eau ... un site de France5', 'http://education.france5.fr/MINTE/MINTE10977/page_10977_71571.cfm', 'Un site pour découvrir et comprendre les différents états de l''eau, les changements d''état de l''eau, le cycle de l''eau.\r\nUtilisable dès le cycle 3.', 'eau;sciences;cycle3;états,changements', 'France 5 Education', '0', '2006-08-04 17:14:12', NULL, NULL),
(713, 2, 'Le cycle de l''eau et les réservoirs', 'http://www.cnrs.fr/cw/dossiers/doseau/decouv/cycle/menuCycle.html', 'Un site pour découvrir un dossier sur le thème de l''eau.', 'eau;environnement;cycle', 'CNRS et Sagasciences', '0', '2006-08-04 17:07:26', NULL, NULL),
(711, 2, 'Opérations en ligne du CP au CM2', 'http://sites.rapidus.net/celmarti/maths.html', 'Un site pour t''entraîner à faire des opérations. C''est interactif  et tu as ton score de réussite', 'mathématiques;techniques;opérations;additions', 'hmido29@hotmail.com', '0', '2006-08-04 16:54:47', NULL, NULL);
INSERT INTO `module_ressource_ressources` (`id`, `id_annu`, `nom`, `url`, `description`, `mots`, `auteur`, `submit_user`, `submit_date`, `valid_user`, `valid_date`) VALUES
(710, 2, 'Exercices en ligne du chat bleu', 'http://www.chatbleu.com/', 'CP\r\nRepérages-Déplacements-Comparer-Les nombres jusqu''à 10-Additions-Les formes\r\n\r\nCE\r\nAdditions-Repérages-Lire l''heure\r\nExercices d''orthographe et de grammaire\r\nPour le CP,CE;CM1', 'calcul;exercices;grammaire;orthographe', 'Le chat bleu', '0', '2006-08-04 16:47:49', NULL, NULL),
(707, 2, 'Exercices de grammaire et de conjugaison autocorrectifs  pour le  cycle 3', 'http://pcolleu.free.fr/grammaire/index.html', 'Ce site propose des exercices de grammaire et de conjugaison en ligne destinés à des enfants de CM1 et CM2. .A faire sur papier...ou à faire à l''écran...\r\n\r\n', 'exercices;grammaire;conjugaison;ORL', 'Philippe Colleu', '0', '2006-08-04 16:25:11', NULL, NULL),
(706, 2, 'Exercices de mathématiques autocorrectifs en ligne en calcul au cycle 3', 'http://pcolleu.free.fr/maths/Maths-Index.html', 'Exercices pour chaque  chapitre du programme de mathématiques au cycle 3 ( CE2,CM1,CM2).\r\nDes exercices avec des corrections.', 'mathématiques;exercices;corrections;', 'mathématiques;exercices;corrections;corrigés', '0', '2006-08-04 16:15:57', NULL, NULL),
(705, 2, 'Des animations en ligne pour apprendre à  faire des constructions géométriques', 'http://pcolleu.free.fr/maths/flash/geometrie.html', 'Avec ce lien et les logiciels en ligne, tu pourras trouves des animations pour apprendre à tracer des perpendiculaires, des parallèles, un triangle, un carré, un rectangle, un losange, un parallèlogramme avec une équerre, une règle, ou avec une règle et un compas. Utilisable dès le cycle 3 (CE2,CM1,CM2)', 'géométrie;construction;figures;tracer;équerre;compas;cycle3', 'pcolleu@free.fr', '0', '2006-08-04 16:04:38', NULL, NULL),
(704, 2, 'Réaliser une figure au cycle 3  avec le logiciel de géométrie instrument poche', 'http://instrumenpoche.sesamath.net/IMG/instruments.html', 'Tu peux construire des figures géométriques avec les instruments à l''écran. Utilisable au cycle 3.\r\n', 'géométrie;logiciel;instrument;dynamique;libre', 'Equipe de math en poche', '0', '2006-08-04 15:58:13', NULL, NULL),
(703, 2, 'Récréomath ... un site pour les mathématiques récréatives', 'http://www.recreomath.qc.ca/index.htm', 'Ce site est consacré aux  mathématiques récréatives. Il contient une banque de problèmes récréatifs et une banque d''outils mathématiques, une banque de jeux de société. Banque de problèmes récréatifs. Banque d''outils mathématiques. Vous allez pouvoir vous récréer et relever des défis en mathématiques. Vous goûterez aux mathématiques récréatives et pourrez améliorer votre performance en résolution de problèmes. Tu as un aide mémoire à ta disposition.\r\n\r\n 	\r\n\r\n	\r\n\r\nDétente\r\n\r\n\r\n	\r\n\r\n	\r\n\r\n', 'jeux;logique;mathématiques;mémoire;problèmes;outils', 'Charles-É. Jean,', '0', '2006-08-04 15:54:17', NULL, NULL),
(702, 2, 'Le Développement durable.. pourquoi une exposition pédagogique pour tous', 'http://www.ledeveloppementdurable.fr/', 'Une exposition pédagogique de 22 affiches sur le Développement Durable\r\nmise gratuitement à disposition de toutes les écoles, collèges et lycées de France.\r\n50 000 établissements concernés. Un public de 10 millions d''enfants et de leurs parents.\r\n', 'environnement;développement;durable;exposition;affiches', 'Un projet de Yann Arthus-Bertrand / Association GoodPlanet.org', '0', '2006-08-04 15:48:13', NULL, NULL),
(699, 2, 'Le matou matheux, des exercices de mathématiques en ligne pour le cycle 3', 'http://matoumatheux.ac-rennes.fr/accueilniveaux/accueilFrance.htm', 'Un site pout t''entrainer en mathématiques avec des logiciels en ligne. Des exerices interactifs d''entrainement en numération sur les les nombres entiers, la multiplication, les tables de multiplication, des problèmes, les graphiques, des constructions, la symétrie axiale, avec un quadrillage, la division, les nombres décimaux, les unités de mesure, la division, les fractions, les pourcentages, la proportionnalité, les graphiques, calcul mental;les unités de mesure, les figures géométriques, la symétrie axiale, les périmètres et les aires, les angles, des constructions.\r\n', 'mathématiques;calcul;exercices;logiciel;gratuit', 'matoumatheux', '0', '2006-08-04 15:32:08', NULL, NULL),
(696, 2, 'Site &quot;Eco-emballages&quot; Juniors pour le cycle 3', 'http://www.lespetitscitoyens.com/', 'Outils en ligne du petit citoyen.\r\nEspace interactif du site consacré pour comprendre et apprendre à être bons citoyens. Zoom sur 25 pays de l''union européenne.Guide, puzzles,cartes et fiches et techniques. Jeux et concours.La newsletter des petits citoyens.Informations pratiques et conseils.Magazine les petits citoyens pour les 7 au 11 ans pour apprendre la citoyenneté.Dictionnaire des petits citoyens.', 'citoyenneté;magazine;Europe;dictionnaire;lecture;jeux;concours;jeux;environnement', 'Dominique Sibon et l''association les petits citoyens', '0', '2006-08-04 14:01:40', NULL, NULL),
(683, 2, 'Histoire de l''esclavage', 'http://www.esclavage-martinique.com/', 'Un site pour jouer et discuter sur le thème de l''esclavage.Découvre l''histoire de l''esclavage en Martinique en retrouvant les origines d''un jeune étudiant au travers d''un jeu ludo-éducatif...Joue au jeu ludo-éducatif ou discute\r\n   Si tu as envie de faire partagertess opinions sur l’esclavage, le forum est pour toi.\r\n ', 'esclavage;histoire;lecture', 'esclavage-martinique.com', '0', '2006-08-03 20:40:20', NULL, NULL),
(682, 2, 'Sites des monuments français', 'http://www.monuments-nationaux.fr/fr/monuments/carte-des-monuments/', 'Tu cliques sur un monument de la carte devant toi. Tu sauras tout sur le monument.\r\n', 'histoire;monuments;', 'culture.fr centre des monuments nationaux', '0', '2006-08-03 20:34:02', NULL, NULL),
(680, 2, 'La maison des droits de l''enfant', 'http://www.droits-et-enfants.com/', '    Tu as un travail de recherche à faire\r\n        * sur les droits du mineur dans des situations\r\n          - de maltraitance\r\n          - d''adoption\r\n          - de délinquance\r\n          - de changement de nationalité...\r\n        * sur les problèmes de société\r\n          - les sectes\r\n          - la toxicomanie\r\n          - la violence... \r\n\r\n  Tu vas trouver à la maison des droits de l''enfant\r\n une documentation spécialisée sous forme de livres, de revues, de dossiers thématiques\r\n \r\n\r\n    ', 'droits;enfants;maltraitance;adoption;délinquance;violence;toxicomanie;sectes', ' maison des droits de l''enfant', '0', '2006-08-03 20:23:46', NULL, NULL),
(679, 2, 'Site de l''UNICEF, la voix des jeunes', 'http://www.unicef.org/voy/french/explore/explore.php', '  Site pour les enfants traitant des points suivants ;\r\nDroits de l'' enfant     Connais-tu tes droits ?Education Pourquoi tous les enfants ne vont-ils pas à l''école ? Eau, assainissement et environnement Comment peux-tu aider à prévenir les maladies liées à l''eau ? Les médias Quelle est la couverture des jeunes dans les médias ?Objectifs du Millénaire Comment faire pour mettre fin à la pauvreté ? VIH et le SIDA, l''exploitation sexuelle des enfants à des fins commerciales. Comment mettre fin à  l''exploitation sexuelle des enfants ? La Situation des enfants dans le monde Comment atteindre  les enfants les plus vulnérables ? Forum de discussion', 'UNICEF;droits;enfants;pauvreté;eau;environnement;médias;lecture;SIDA;forum', 'UNICEF', '0', '2006-08-03 20:19:36', NULL, NULL),
(675, 2, 'Puzzle des départements français en ligne', 'http://splaf.free.fr/puzzle.html', 'Jeu animé visant à reconstituer le puzzle des départements français.Possiblité de varier le niveau en indiquant ou pas le contour des départements ou des régions', 'cartes;géographie;départements;régions', ' Stéphane Guillot.', '0', '2006-08-03 20:02:49', NULL, NULL),
(677, 2, 'Le sénat Junior', 'http://www.junior.senat.fr/', 'Tu peux faire un voyage virtuel au sénat. Dessin animé sur la loi et toi.Portrait de sénateurs, interviews, journée d''un sénateur. Tu pourras découvrir le  palais du Luxembourg, une véritable ville .Il y a  un salon de coiffure, une lingerie, une salle de sport, une infirmerie, un labo-photo, un atelier d''ébénisterie, un poste souterrain de sécurité. Place ton curseur sur les pièces. Sénatin,le héros du site t''apprend ce qu''est la démocratie. Tu apprends comment fonctionne le sénat. Tu peux avoir accès à des dossiers comme &quot;l''environnement&quot;, la discrimination, le racisme ou la violence.', 'sénat;loi;démocratie;palais;Luxembourg;lecture;racisme;discrimination;environnement', 'junior.senat', '0', '2006-08-03 20:13:05', NULL, NULL),
(673, 2, 'Site pour avoir des vues aériennes de votre ville et des documents historiques', 'http://www.notrefamille.com/v2/services-villes-villages/default.asp', 'La plus grande collection de photos et illustrations anciennes du Net ! Entrez votre ville et découvrez tous les documents des XVIIIe, XIXe et XXe siècles qui la concernent : photos, gravures, cartes, livres...\r\nVilles &amp; Villages\r\nHistoire des Villages-Mémoires des Régions-Cartes Anciennes-La France en 1850-La France en 1750-La France en 1600- Images de France-Cartes Postales 1900-Gravures Anciennes-La France Vue du Ciel', 'géographie;vues;aériennes;photos;cartes;postales', 'notrefamille.com', '0', '2006-08-03 19:22:17', NULL, NULL),
(670, 2, 'Mappy .. un site pour plans et itinéraires en  France et en Europe', 'http://www.mappy.fr/', ' Mappy.fr  - Plans et itinéraires pour la France et  l''Europe', 'géographie;plans', 'Mappy', '0', '2006-08-03 18:58:31', NULL, NULL),
(672, 2, 'Bottin cartographe', 'http://www.1bis.com/1bis/default.asp', 'Carte et  Plan. Calcul d''itinéraire entre 2 villes. Trajet RATP à Paris et en ile de France\r\n	', 'géographie;carte;plan', 'Planfax', '0', '2006-08-03 19:03:51', NULL, NULL),
(668, 2, 'Dictionnaire du français MEMODATA', 'http://www.sensagent.com/dictionnaires/fr-fr/dictionnaire/', 'Le dictionnaire de français de MEMODATA comporte plus 250,000 entrées avec de l''ordre de 450,000 traductions.  En version papier, il représenterait plus de quatre mille pages.  Des suppléments sont en outre apportés par de nombreuses terminologies propres à des domaines spécifiques (médecine, documentation etc.).\r\nIl y a également un outil pour la conjugaison intégré ainsi qu''un outil d''analyse grammaticale du mot.', 'dictionnaire;grammaire;vocabulaire', 'Mémodata', '0', '2006-08-03 18:30:26', NULL, NULL),
(669, 2, 'Ajouter Alexandria à la barre de Firefox', 'http://www.sensagent.com/fr/alexandria/plugin/plugin-recherche-firefox.html', 'Alexandria est un outil qui est intéressant pour les élèves de cycle 3 qui peuvent à tout moment, rechercher la définition d''un mot dans un texte du Web. On peut également faire des recherches sur les mots ( sens d''un mot, analyse grammaticale, conjugaison d''un verbe), mais aussi trouver un synonyme.', 'dictionnaire;conjugaison;vocabulaire;grammaire', 'Alexandria', '0', '2006-08-03 18:33:45', NULL, NULL),
(666, 2, 'Dictionnaire en ligne d''Alexandria', 'http://www.sensagent.com/fr/index.html', 'Dictionnaire', 'dictionnaire;définitions;traductions', 'Alexandria', '0', '2006-08-03 18:04:20', NULL, NULL),
(667, 2, ' Alexandria , un logiciel pour pouvoir traduire ou définir le sens d''un mot  sur un site', 'http://www.memodata.com/2004/fr/index.shtml', 'Alexandria à chaque fois que le besoin s''en fera sentir vous fournira: traductions vers votre langue, définitions et synonymes dans la langue d''origine...Vous rencontrez parfois des difficultés face à un terme technique ou rare?  Comptez sur Alexandria pour faire le possible pour vous renseigner en un instant. D''une manipulation rapide de votre souris, obtenez l''information que vous recherchez. A tout moment, vous pouvez rechercher la définition d''un mot en ligne \r\n\r\n\r\n\r\nRien de plus simple et immédiat que de double-cliquer! Si la page web que vous consultez a fait le nécessaire, Alexandria se mettra à votre service.\r\n\r\n\r\n \r\n', 'dictionnaire;traducteur', 'Contributeurs d''Alexandria  Memodata  Wordnet 2.0 Copyright 2003 by Princeton University. All rights', '0', '2006-08-03 18:12:52', NULL, NULL),
(665, 2, 'Un moteur de recherche &quot;Mozmot&quot; pour les synonymes, les expressions, la conjugaison', 'http://www.mozbot.fr/', 'Un moteur qui rend bien des services pour chercher des synonymes ou des expressions à partir d''un mot.\r\nPar exemple pour le mot &quot;manger&quot;, Mozmot te donne comme synonyme : casser la croûte, bâfrer, croquer, bouffer, dévorer, dépenser, se nourrir, se sustenter, chipoter, nourriture, s''empiffrer, grignoter.\r\nSuggestions : manger au râtelier, manger avec un lance-pierres, manger comme quatre, bien manger...\r\nUn tableau de conjugaison est accessible pour les verbes.', 'moteur;synonymes;expressions;dictionnaire;conjugaison', 'mozmot Moteur de recherche © Abondance, Brioude-Internet et Raynette  en partenariat avec Google', '0', '2006-08-03 17:45:11', NULL, NULL),
(663, 2, 'Le site Géoclip pour créer ses cartes en ligne', 'http://www.geoclip.net/fr/', 'Geoclip.net/fr  - Geoclip est un excellent outil pour créer ses cartes en ligne (Flash 6 nécessaire), proposé par Eric Mauvière et Isabelle Coulomb.', 'logiciel;géographie;gratuit;cartes', 'Geoclip.net/fr', '0', '2006-08-03 17:24:51', NULL, NULL),
(664, 2, 'Site Insee du recensement de la population', 'http://www.recensement.insee.fr/home.action', 'Vous pouvez choisir un thème d''étude, choisir une zone géographique, choisir un produit en ligne', 'géographie;INSEE;population', 'INSEE', '0', '2006-08-03 17:29:05', NULL, NULL),
(660, 2, 'Logiciel sur les départements français', 'http://olivier.leflon.free.fr/jeux/jeux.htm', 'Le logiciel &quot;Les DEPARTEMENTS français 2.0&quot; permet de mémoriser les différents départements de la France\r\nPrincipe du jeu : recherche sur un fond de carte des départements, affectation des préfectures et des sous préfectures, des régions. Nouveautés  par exemple un mode apprentissage, qui vous présente la bonne réponse, et qui vous permet de visualiser une fiche de renseignements sur les départements (source INSEE 1990), le paramétrage du jeu pour choisir les étapes et leur ordre, ...\r\n\r\n', 'géographie;départements;régions;cartes;préfecture', ' Pierre Leflon', '0', '2006-08-03 17:10:55', NULL, NULL),
(653, 2, 'Tutoriel pour utiliser le logiciel &quot;Time line maker&quot; pour faire des frises historiques', 'http://soshg.free.fr/timeline/timeline-hlp.htm', 'Aide pour utliser le logiciel &quot;Time line maker&quot;', 'logiciel;gratuit;frise;histoire;tutoriel', '?', '0', '2006-08-03 16:44:45', NULL, NULL),
(655, 2, 'GEOSTAT 1.0 un logiciel pour fabriquer des cartes', 'http://olg137.perso.sfr.fr/Softs/Geostat/Geostat.htm', 'GEOSTAT 1.0 Ce programme vous permet, à partir d''une carte vierge de la France départementale, de représenter géographiquement diverses répartitions :\r\n- Répartition de la population\r\n- Représentation en couleur de la superficie des départements français', 'géographie;population;départements', 'O Guilleton', '0', '2006-08-03 16:50:38', NULL, NULL),
(651, 2, 'Le logiciel &quot;Make your map&quot; pour créer une carte sur Internet', 'http://www.makeyourmap.net/', 'Logiciel gratuit en ligne. Vous choisissez une carte. Vous choisissez vos données. Vous choisissez le mode de repésentation. Ce logiciel peut vous rendre service en géographie. Vous êtes aidé avec un tutoriel.http://mym.articque.com/files/mym_help.fr.pdf\r\n ', 'géographie;carte;logiciel;gratuit;', 'makeyourmap.net', '0', '2006-08-03 16:24:56', NULL, NULL),
(652, 2, 'Le logiciel &quot;Time Line maker&quot; pour concevoir des frises historiques', 'http://soshg.free.fr/loghist.htm', ' Time Line Maker est un logiciel qui permet concevoir des tableaux et surtout des axes chronologiques à partir de bases de données incluant des dates, des évènements et autres renseignements. L''interface est simple et rapide à utiliser. L''on peut créer 3 sortes de chronologies à partir d''une sélection d''évènements choisis dans l''ensemble d''un fichiers de données. - Possibilité de sélectionner les évènements à inclure dans la chronologie\r\n- Ajustement automatique de l''échelle et de la position des données sur l''axe chronologique\r\n- Aperçu avant impression\r\n- Accepte toute date de JC à 9999 y compris avec jour/mois/année (NOTA : impossibilité avant JC)\r\n\r\nDes élèments de : réflexion, conseils, évaluations et des pistes de travail avec les élèves Une AIDE en français : TUTORIAL illustré ', 'frise;logiciel;freeware;gratuit,événements;dates', '', '0', '2006-08-03 16:37:01', NULL, NULL),
(649, 2, 'Chroniques Internet ... un site pour s''informer et se former en histoire et en géographie.', 'http://aphgcaen.free.fr/chronique.htm', 'Chroniques Internet ... est un site pour s''informer et se former en histoire et en géographie. Il est édité par une association de professeurs d''histoires et de géographie de Caen', 'histoire;géographie;chroniques', 'aphgcaen', '0', '2006-08-03 16:13:44', NULL, NULL),
(650, 2, 'Cartothèque .... des cartes libres de droit pour un usage scolaire', 'http://histgeo.ac-aix-marseille.fr/carto/index.htm', ' Fonds de cartes pour l''enseignement de l''histoire et de la géographie, libres de droits dans le cadre d''un usage scolaire.\r\nCes documents sont disponibles en cinq formats :\r\n# Un format bitmap (GIF) pouvant être récupéré et inséré dans tous les traitements de texte par simple copier/coller.\r\n# Quatre formats vectorisés pour une impression plus précise des tracés, un redimensionnement sans altération de la qualité de l''image, ou une modification à l''aide du logiciel adéquat : Monde,Afrique,Amérique,Europe,Asie,France', 'cartes;géographie', 'Professeurs de l''ac-aix-marseille', '0', '2006-08-03 16:17:20', NULL, NULL),
(647, 2, 'Un site avec des cartes pour se repérer', 'http://virtualearth.msn.com', 'Tu choisis l''endroit sur la carte où tu veux te repérer. Tu as un curseur qui te donnera un effet zoom .. et tu peux avoir des plans.', 'cartes;échelles;plans', 'windows', '0', '2006-08-03 16:00:08', NULL, NULL),
(648, 2, 'Le logiciel PrintGoogle pour rechercher un livre ou une page de livre sur Internet', 'http://books.google.com/', 'l suffit d''effectuer une recherche sur la page d''accueil du service Google Recherche de Livres. Chaque fois que les termes de votre recherche figurent dans un livre, un lien vers cet ouvrage s''affiche dans les résultats obtenus. Cliquez sur le titre d''un livre, pour qu''apparaisse la page dans laquelle se trouvent vos termes de recherche. Cette page est accompagnée d''autres informations concernant l''ouvrage, mais aussi de liens « Acheter ce livre » permettant d''accéder à des librairies en ligne. Si le livre est libre de droits, vous pourrez le consulter intégralement. ', 'moteur;recherche;Google;livres', 'Google', '0', '2006-08-03 16:04:32', NULL, NULL),
(646, 2, 'Le logiciel Mapsgoogle pour la géographie au cycle 3', 'http://maps.google.com/', 'Un logiciel pour rechercher un plan. Faites glisser la carte avec la souris ou double-cliquez sur un point pour effectuer un zoom.', 'géographie;carte;plan', 'Google', '0', '2006-08-03 15:37:56', NULL, NULL),
(645, 2, 'Google Earth pour chercher et découvrir', 'http://earth.google.com/', 'Vous souhaitez en savoir plus sur un lieu précis ? Lancez-vous ! Google Earth met des informations géographiques sur le monde entier à votre portée en associant des images satellite, des plans, des cartes et la puissance de la recherche GoogleLles sites de Google permettant de voir la terre d''en haut proposent images satellites, aériennes et cartes à de multiples échelles des Etats-Unis mais aussi de plus en plus pour l''ensemble du globeSurvolez la planète ou explorez votre quartier. Saisissez une adresse et zoomez dessus. Recherchez des écoles, des parcs, des restaurants et des hôtels Calculez des itinéraires.Inclinez la vue et faites-la pivoter pour voir les bâtiments et le relief en 3D.Enregistrez et partagez vos recherches et vos endroits préférés. Vous pouvez même ajouter vos propres annotations.', 'géographie;images;satellites;plans;cartes;vues;échelle', 'Google', '0', '2006-08-03 15:36:42', NULL, NULL),
(643, 2, 'Le site pour apprendre l''Union européenne', 'http://education.france5.fr/europe/', 'Un site qui te permet de découvrir comment l''Europe a été construite. Tu as une vidéo, un quizz et de nombreuses informations pour découvrir les rouages de l''Europe.', 'Europe;citoyenneté;géographie;vidéo', 'France 5 Education', '0', '2006-08-03 15:23:18', NULL, NULL),
(642, 2, 'La France vue sur mer pour le cycle 3', 'http://www.francevuesurmer.com/', '5 500 kilomètres de littoral 15 000 photos aériennes.Tu cliques sur une région ou tu utilises le moteur de recherche pour trouver une ville près d''une côte de France. Tu te rapproches en un clic et tu peux voir les différentes côtes et paysages de France. Utilisable au cycle 3(CE2,CM1,CM2). Francevuesurmer.com est le diaporama géographique et touristique de l’ensemble des côtes françaises. Il te permet de visiter en quelques clics le port de Saint Tropez et la plage de Deauville, les rochers de Trégastel et la citadelle de Bonifacio, le phare de Biarritz et les falaises d’Etretat.\r\n', 'géographie;côtes;mer;paysage;lecture;cycle3;moteur;recherche', 'francevuesurmer.com', '0', '2006-08-03 15:20:52', NULL, NULL),
(640, 2, 'Moteur de recherche pour chercher une carte ou des objets géographiques', 'http://www.atlasgeo.net/search.htm', 'Un service de Atlas Géo. Un moteur de recherche pour chercher des cartes, des hymnes.\r\nNe marche qu''avec Internet Explorer', 'géographie;cartes;monde;libre', 'atlasgeo.net', '0', '2006-08-03 12:21:17', NULL, NULL),
(639, 2, 'Atlas géographique mondial', 'http://www.atlasgeo.net/', 'Vous trouverez sur ce site chaque pays classé d''abord par continent,puis par ordre alphabétique. En suivant les différents liens,situez-les à l''aide des cartes et découvrez leurs drapeaux,leurs hymnes, leurs armoiries et leurs fiches descriptives.Afrique, Amérique,Antarctique,Asie,Europe,Océanie', 'atlas;géographie;pays;continent;cartes;drapeaux;hymnes;Afrique; Amérique;Antarctique;Asie;Europe', 'atlasgeo.net', '0', '2006-08-03 12:00:28', NULL, NULL),
(638, 2, 'Géoportail Le site de l''IGN ', 'http://www.geoportail.fr/', 'Le site de l''IGN qui permet d''afficher la france en 2D 3D,avec soit la vue aérienne, le cadastre, la carte IGN classique et bien d''autres possibilités...', 'géographie;cartes; France; ', 'IGN', '0', '2006-08-03 11:18:47', NULL, NULL),
(637, 2, 'Le site de l''IGN pour les cartes de la France', 'http://www.ign.fr/', 'Le site de l''IGN, avec un lien vers Edu géo et Géoportail', 'géographie;départements;régions;cartes;', 'IGN', '0', '2006-08-03 11:14:27', NULL, NULL),
(636, 2, '1944, la bataille de Normandie', 'http://www.normandie44lamemoire.com/', 'des témoignages, des documents exploitables en classe sur la bataille de Normandie. A adapter en choisissant des documents', 'guerre;mondiale;Normandie;1944', 'Conseil Régional de Basse Normandie et normandie44lamemoire.com', '0', '2006-08-03 11:10:44', NULL, NULL),
(635, 2, 'Le 06 Juin 1944,  le débarquement expliqué aux enfants', 'http://www.france5.fr/images/flash/2gm/fla2/debarquement2.html', 'Site qui te permet de découvrir ce qui s''est passé le 06 Juin 1944, quand les armées alliées se sont lancées à l''assaut des plages normandes pendants la deuxième guerre mondiale. Tu as un parcours interactif avec des vidéos, des extraits de radio de l''époque. Utilisable dès le cycle 3.(CE2,CM1,CM2)', 'histoire;guerre;seconde;mondiale;lecture;débarquement;', 'France 5 Education', '0', '2006-08-03 11:09:35', NULL, NULL),
(634, 2, 'Le grenier de Sarah pour comprendre la Shoah au cycle 3', 'http://www.grenierdesarah.org/', 'Le grenier de la Shoah permet d''aborder la Shoah à travers les destins de cinq enfants Juifs.Tu apprendras à connaître ce temps où on exterminait les Juifs du temps des Nazis pendant la seconde guerre mondiale.', 'histoire;Shoah;juifs;guerre;mondiale;judaïsme;nazis;nazisme;lecture', 'Musée, centre de documentation juive contemporaine;mémorial de la Shoah', '0', '2006-08-03 10:55:58', NULL, NULL),
(633, 2, 'La maison de Anne Frank un site interactif pour le cycle 3', 'http://www.annefrank.org/fr/Lhistoire-dAnne-Frank/', 'Ce site interactif propose un grand nombre de documents sur l’histoire d’Anne Frank et la Seconde Guerre mondiale ainsi que des conseils pour préparer un exposé. C’est une base de données avec des textes, des photos et des extraits audio-visuels sur les thèmes d’Anne Frank et de la Seconde Guerre mondiale.Utilisable au cycle 3(CE2,CM1,CM2)', 'histoire;guerre;seconde;mondiale;lecture;écriture;cycle3', 'Association Anne Frank', '0', '2006-08-03 10:42:05', NULL, NULL),
(632, 2, 'L''arbre d''Anne Frank, un monument interactif', 'http://www.annefranktree.nl/index.aspx?lang=fr', 'Anne Frank regardait souvent un marronnier par la lucarne de sa maison. Elle a également parlé de cet arbre dans son journal. Âgé de plus de 150 ans, l’arbre est maintenant malade, mais il continue de vivre en ligne. Laisse ta feuille dans le marronnier virtuel, fais-la suivre à des ami(e)s et maintiens ainsi vivants les idéaux d’Anne Frank.', 'Anne;Frank;journal;juifs;lecture;écriture', 'Anne Frank Stichting', '0', '2006-08-03 10:37:52', NULL, NULL),
(630, 2, 'La seconde guerre mondiale et le débarquement', 'http://www.france5.fr/images/flash/2gm/fla1/debarquement1.html', 'Tout au long de ce parcours interactif, tu peux découvrir les principaux faits du 06 Juin 1944 et le débarquement', 'histoire;guerre;mondiale;débarquement', 'France 5 Education', '0', '2006-08-03 09:59:39', NULL, NULL),
(629, 2, 'Le site de Napoléon pour le cycle 3', 'http://education.france5.fr/napoleon/', 'France 5 et Le Louvre te  proposent de découvrir la vie et l''oeuvre de Napoléon. Tu as un commentaire et une explication de la vie de Napoléon. On t''explique la peinture du sacre de Napoléon 1er est une fresque historique monumentale (six mètres sur dix) servant la propagande de l''Empire. Tu as à ta disposition un labo-interactif où tu peux jouer en ligne  avec Napoléon Bonaparte du Consulat à l''Empire. Tu as un espace vidéo pour &quot; La mise en scène du Sacre&quot;, la composition de la toile. Accessible dès le cycle 3(CE1,CE2,CM1,CM2). \r\n\r\n\r\n\r\n', 'histoire;Napoléon;sacre;vidéo;peinture,cycle3;lecture', 'Le Louvre et France 5', '0', '2006-08-03 09:51:29', NULL, NULL),
(628, 2, 'Site du château de Versailles', 'http://www.chateauversailles.fr/fr/', 'Pour découvrir le château de Versailles, comme si tu y étais.', 'histoire;château;Versailles', 'chateauversailles.fr', '0', '2006-08-03 09:43:18', NULL, NULL),
(626, 2, 'Découvrir le château de la Loire de Cheverny au cycle 3', 'http://www.chateau-cheverny.com/', 'Un site où tu peux visiter le château de la Loire. Le domaine de Cheverny appartient à la même famille, les Hurault, depuis plus de six siècles. Le père du constructeur fut chancelier ( ministre de la justice ) des rois Henri III et Henri IV. Cheverny servit de modèle au célèbre dessinateur Hergé‚ pour créer Moulinsart.', 'château;Loire;renaissance;lecture', 'chateau-cheverny.com', '0', '2006-08-03 09:21:35', NULL, NULL),
(623, 2, 'Paris sous Philippe Auguste pour le cycle 3', 'http://www.philippe-auguste.com/', ' Un site qui t''apporte des renseignements sur la muraille, le quotidien, la ville du roi. Tu as une bibliographie à ta disposition si tu veux en savoir plus.', 'Paris;Philippe;Auguste;vie;quotidienne;lecture;ville;histoire;moyen;âge;recherche', 'mchristine@ecole-multimedia.com', '0', '2006-08-03 09:04:28', NULL, NULL),
(625, 2, 'Léonard de Vinci, un site pour le cycle 3', 'http://artdevinci.free.fr/', ' Un site pour découvrir la vie et l''oeuvre de Léonard de Vinci. Tu pourras lire et comprendre  ses oeuvres, des peintures, ses dessins.Tu peux décrypter les détails de tableaux.Tu as une biographie complète. Tu peux jouer sur le site avec des  quizz ou les jeux des détails. Utilisable dès le cycle 3(CE2,CM1;CM2)', 'arts;Léonard;Vinci;vie;oeuvre;biographie;tableaux;lecture', 'artdevinci.free.fr', '0', '2006-08-03 09:19:19', NULL, NULL),
(622, 2, 'Les cadhédrales de France pour le cycle 3', 'http://www.culture.gouv.fr/culture/inventai/itiinv/cathedrale/cat_2.html', 'Une sélection d''images numériques réalisées à partir des fonds photographiques conservés aux Archives photographiques a donné lieu à cette exposition virtuelle. Tu as là des photos et des images numériques concernant les cathédrales en France.\r\n', 'histoire;cathédrales;images;moyen;âge;lecture;recherche', 'Archives Photographiques - Médiathèque de l''architecture et du patrimoine (DAPA)', '0', '2006-08-03 08:57:23', NULL, NULL),
(619, 2, 'Site sur l''art gothique au cycle 3', 'http://www.clioetcalliope.com/medieval/gothique/gothiquemenu.htm', 'Un site bien illustré sur le temps des cathédrales et sur l''art gothique pour le cycle 3. (CE2,CM1,CM2)', 'histoire;cathédrales;arts;lecture;cycle3', 'Clio et Calliope', '0', '2006-08-03 08:40:27', NULL, NULL),
(620, 2, 'Base de données pour trouver des documents sur une époque en histoire', 'http://clioetcalliope.free.fr/recherche.htm', 'Avce ce site, tu peux rechercher et trouver un article sur Clio et Calliope. Tu as à ta disposition un moteur de recherche avec une recherche multi-critères. ( Histoire, archéologie, architecture, peinture, sculpture) et puis une entrée par époque (antiquité,médiéval,moderne,contemporaine).Utilisable dès le cycle 3 pour trouver des textes ou des photos illustrant une période en histoire.', 'histoire;moteur; architecture; peinture;sculpture;antiquité;médiéval;moderne;contemporaine;période', 'Clio et Calliope', '0', '2006-08-03 08:44:59', NULL, NULL),
(617, 2, 'Enluminures une base de données d''images pour illustrer la vie au moyen-âge', 'http://www.enluminures.culture.fr/documentation/enlumine/fr/index3.html', 'Tu travailles sur le moyen-âge, tu cherches des informations sur les enluminures. Tu as là la base Enluminures qui propose la consultation gratuite de plus de 80 000 images, sous forme de vignette et de plein écran, reproductions numériques des enluminures et éléments de décor de plus de 4 000 manuscrits médiévaux conservés dans une centaine de bibliothèques municipales françaises. Tu peux faire une visite culturelle sur la nativité, les rois de France, les sciences, les travaux des champs; le moyen-âge à table... une façon de découvrir des images de la vie quotidienne du moyen-âge. Utilisable à tous les niveaux pour la lecture des images.', 'moyen;âge;histoire;chevaliers;lecture;images;rois;champs;paysans;vie;quotidienne', 'Ministère de la culture', '0', '2006-08-03 08:25:47', NULL, NULL),
(616, 2, 'A votre service, mon seigneur un site de TV5 pour le cycle 3', 'http://education.france5.fr/moyenage/illustrations/labo02.swf', 'Un site pour partir à la découverte des châteaux-forts, de la vie des paysans, des seigneurs, des moines, des chevaliers, les personnages principaux du moyen-âge. Un site adapté pour les élèves du cycle 3 (CE2;CM1;CM2)', 'histoire;moyen;âge;château;lecture;cycle3;paysans;seigneurs;moines;chevaliers', 'France 5  Le Louvre et Hachette Jeunesse', '0', '2006-08-03 08:14:39', NULL, NULL),
(615, 2, 'Explorer le moyen-âge sur France 5... pour le cycle 3', 'http://education.france5.fr/Moyenage/index.htm', 'Site très complet où tu peux découvrir ce qu''est le moyen-âge, comment on vivait à cette époque là. Tu sauras tout sur l''art au moyen-âge, le monde des paysans, les banquets, les châteaux, les divertissements. La vidéo pourra te montrer les secrets du moyen-âge. France 5 a prévu un labo-interactif pour toi pour voir comment la France s''est construite. Tu  pourras le faire dès que tu es au CE2. Tu as également un jeu interactif pour découvrir la vie des seigneurs, des paysans, des chevaliers si tu es au CM ou au collège. Un quiz t''attend.Tu seras aidé car tu auras un glossaire à ta disposition à tout moment.', 'histoire;moyen;âge;seigneurs;paysans;chevaliers;vie;vidéo;cycle3;jeux;glossaire', 'France 5  Le Louvre et Hachette Jeunesse', '0', '2006-08-03 08:12:08', NULL, NULL),
(611, 2, 'La cité romaine le site de France 5 pour tout savoir sur la vie des Romains', 'http://education.france5.fr/romains/accueil.html', 'Tu trouveras des informations sur la cité romaine;les habitants, les bâtiments. France 5 va t''aider à constuire une cité romaine. ', 'histoire;Romains;cité;habitants;bâtiments;vie', 'France5; Education.france5.fr', '0', '2006-08-02 10:20:18', NULL, NULL),
(610, 2, 'Un site d''histoire sur Alésia', 'http://www.alesia.com/avant-la-bataille_fr_05_01.html', 'Tout savoir sur Alésia et la guerre entre Gaulois et Romains', 'Alésia;Gaulois;Romains', 'Association &quot;Alésia&quot;', '0', '2006-08-01 23:22:31', NULL, NULL),
(609, 2, 'Le temps des châteaux forts - un DVD  à exploiter au  cycle 3', 'http://www.herodote.net/Boutique/dvd.htm', 'Le DVD Le temps des châteaux forts offre un vrai moment de bonheur à tous les amateurs d''Histoire  qui voient revivre sous leurs yeux le Moyen Âge comme s''ils y étaient.  A travers les images, le rythme, la musique et les commentaires, les auteurs nous communiquent leur passion pour cette époque lointaine et réussissent la gageure de nous la montrer comme si nous y étions.\r\nL''Éducation nationale certifie l''intérêt pédagoqique de ce DVD (label RIP)\r\n', 'histoire;moyen;âge;DVD;RIP;atlas;châteaux;forts', 'Herodote.net', '0', '2006-08-01 23:14:27', NULL, NULL),
(614, 2, 'La vie quotidienne en l''an 1000... Un site sur le moyen-âge pour le cycle 3', 'http://www.culture.gouv.fr/culture/arcnat/charavines/fr/chepay.htm', 'Nous sommes en l''an 1008, peut-être 1010, de l''ère chrétienne. Une troupe se fraie difficilement un passage sur le territoire de l''actuel département de l''Isère. Les femmes sont accompagnées d''enfants ; les hommes, en armes, montent à cheval tandis que d''autres mènent à grand bruit cochons, chèvres et vaches. Dans les charrettes se trouve tout le matériel pour vivre. Une aventure qui les mènera jusqu''aux rives boisées du lac de Paladru.\r\nQui sont ces chevaliers-paysans ? Quelle était la nourriture ? la défense? quels étaient les divertissements ?\r\nTextes intéressants à dévouvrir au CE2,CM1,CM2.', 'chevaliers;paysans;moyen;âge;histoire;cycle3;rechercher;lecture;divertissements;', 'Ministère de la culture', '0', '2006-08-03 08:00:52', NULL, NULL),
(608, 2, 'Diaporamas de cartes pour l''histoire au cycle 3', 'http://www.histoirealacarte.com/histoire_de_france/diaporama.htm', 'Une animation cartographique soutenue par un commentaire sonore permet de suivre en continu les principales évolutions territoriales qui ont conduit de la Gaule romaine à la France d''aujourd''hui. Cet enchaînement est découpé en trois grandes périodes, caractérisées par trois couleurs différentes. Jusqu''à la fin du Xème siècle la notion d''espace prime. Du XIème siècle à la Révolution française on fait référence à la notion de royaume, ensuite à celle d''état-nation.', 'histoire;Gaule;romaine;animation;carte', 'Images et Savoirs a coédité avec le Centre Régional de Documentation Pédagogique d’Aix Marseille', '0', '2006-08-01 23:10:30', NULL, NULL),
(613, 2, 'Découvrir le chantier médiéval de Guédelon', 'http://www.guedelon.com/', 'Découvre le chantier médiéval de Guédelon ; la construction d''un château fort en plein coeur de la Puisaye, en Bourgogne.Utilisable pour les élèves du cycle 3', 'histoire;moyen;âge;château;lecture;cycle3', 'guedelon.com', '0', '2006-08-02 10:42:45', NULL, NULL),
(607, 2, 'Des dossiers en histoire pour le cycle 3', 'http://www.histoirealacarte.com/histoire_de_france/dossiers/index.htm', ' Au nombre de vingt-sept, tu trouves des dossiers avec des sujets très divers : un homme, un événement, une œuvre d''art, un témoignage... Chacun d''entre eux constitue une sorte de «petite leçon d''histoire» illustrant comment travaille l''historien aujourd''hui. De nombreux documents, textes ou images, sont consultables. Des textes d''historiens de diverses époques sont présentés pour montrer l''évolution de la perception des événements passés et de leur importance.Chaque dossier est introduit par une courte animation audiovisuelle. ', 'histoire; baptême;Clovis;Empereur;Normands;guerres;religion', 'Images et Savoirs a coédité avec le Centre Régional de Documentation Pédagogique d’Aix Marseille le', '0', '2006-08-01 23:09:11', NULL, NULL),
(606, 2, 'Une frise chronologique pour percer les secrets de chaque période de l''histoire', 'http://www.histoirealacarte.com/histoire_de_france/chronologie.htm', ' Une grande frise chronologique et interactivete  permet de faire défiler sur yon  écran 15 siècles d’histoire de France : personnages, évènements, monuments, régimes politiques….Visuellement cette frise est très colorée : chaque grande période est caractérisée par une couleur et le passage progressif d’une couleur à l’autre rappelle que les grandes évolutions se font dans la durée. Tu verras comme c''est bien de remonter ainsi l''histoire ', 'frise;histoire;périodes;personnages; évènements; monuments; régimes: politiques', 'histoirealacarte.com', '0', '2006-08-01 23:04:39', NULL, NULL),
(605, 2, 'Cartes animées et atlas historiques pour mieux comprendre l''histoire.', 'http://www.histoirealacarte.com/', 'Un site pour composer votre atlas historique multimédia. Le site l’Histoire à la carte, vous propose de constituer progressivement votre propre atlas historique multimédia, personnel ou familial, en téléchargeant* sur votre ordinateur tout ou partie des cartes animées que nous mettons régulièrement en ligne.\r\n* Nous pouvons également les graver sur un cédérom', 'histoire;cartes;atlas', '', '0', '2006-08-01 22:59:16', NULL, NULL),
(603, 2, 'L''Histoire de A à Z - L''index des noms', 'http://www.herodote.net/indx.htm', 'L''Histoire de A à Z - Index des noms\r\nRecherche sur Herodote.net. Tape  une date ou le nom de personne ou de lieu de ton  choix.\r\nDécouvre aussi le sens des mots en rapport avec l''Histoire et les curiosités de l''orthographe des noms propres\r\n \r\n', 'histoire;index;noms;personnages;dates', 'herodote.net', '0', '2006-08-01 22:52:33', NULL, NULL),
(604, 2, 'La guerre des Gaules pour le cycle 3 - un texte à lire', 'http://www.herodote.net/histoire011100.htm', 'Un document sur la guerre des Gaules', 'Gaulle;carte;peuple;gaulois;histoire;guerre;lecture', 'herodote.net', '0', '2006-08-01 22:55:20', NULL, NULL),
(601, 2, 'La guerre des Gaules pour le cycle 3', 'http://www.gergovie.fr/htmfr/bataille.html', 'Site dédié à la guerre des Gaules. Un résumé, des commentaires. Texte et illustration sur  Gergovie\r\nprésentation de l''armée romaine et l''armée gauloise', 'histoire;guerre;Gergovie;Gaule:Gaules;armées;lecture;documents;recherche;César', 'alesia.asso', '0', '2006-08-01 22:40:40', NULL, NULL),
(600, 2, 'Histoire naturelle des oiseaux en 9 volumes', 'http://www.oiseaux.net/buffon/buffon.tome1.html', 'Des articles sur les oiseaux. Document historique de Buffon', 'oiseaux;recherche;document', 'Buffon (George-Louis Leclerc 1707-1788)', '0', '2006-08-01 22:36:08', NULL, NULL),
(599, 2, 'Bestiaires en images de la BNF', 'http://expositions.bnf.fr/bestiaire/index.htm', 'Le site des bestiaires de la BNF ( bibliothèque nationale de France).\r\nTu y découvres des dragons; des histoires merveilleuses;le roman de renard\r\nTu pourras avec ton maître et ta maîtresse travailler sur des bestiaires et des maxi-monstres.Les classes sont invitées à travailler sur un projet de création collective d''un album illustré à la manière des bestiaires médiévaux.\r\n', 'bestiaire;images;arts;enluminures;moyen;âge;roman;renard;animaux', 'biblithèque nationale de France', '0', '2006-08-01 22:27:29', NULL, NULL),
(597, 2, 'Dictionnaires des habitants des villes de France', 'http://www.lexilogos.com/noms_habitants_villes.htm', 'Tu cherches le  nom des habitants d''une ville. Tu cherches le nom de la ville dans la liste et tu cliques sur  [Ctrl]+F', 'villes;France;orthographe;dictionnaire', 'lexilogos', '0', '2006-08-01 22:15:18', NULL, NULL),
(598, 2, 'Lexilogos', 'http://www.lexilogos.com/index.htm', 'Une collection de cartes, de dictionnaires', 'dictionnaires;cartes;recherche', 'lexilogo', '0', '2006-08-01 22:22:02', NULL, NULL),
(594, 2, 'Un site sur les Gaulois à exploiter au cycle 3', 'http://www.lattara.culture.fr/', 'Un site sur les Gaulois de Lattes dans le Languedoc', 'histoire;Gaulois,Gaulle;grèce;Grecs', 'culture.gouv.fr', '0', '2006-08-01 21:59:47', NULL, NULL),
(595, 2, 'Carte de la Gaule pour le cycle 3', 'http://www.lexilogos.com/gaulois_peuples_carte.htm', 'Tu cliques sur la carte. Tu découvres le nom des peuple gaulois, le nom de la région, de la ville, le nom antique  	', 'Gaulle;carte;peuple;gaulois;histoire', 'lexilogos.com', '0', '2006-08-01 22:02:36', NULL, NULL),
(596, 2, 'Accès aux différentes cartes de France', 'http://www.lexilogos.com/france_carte.htm', 'geoportail : carte ign 1/25 000 &amp; 1/100 000 de toute la France &amp; photo satellite [toutes les nouveautés]\r\ncarte Mappy : carte routière, plan de ville &amp; photos des principales villes de France vues du ciel\r\ncarte Michelin : carte routière de la France, plan de ville &amp; calcul d''itinéraire. \r\nLocalisation d''une commune;Carte des départements;Cartes anciennes-\r\nInformations partagées sur une commune par les contributeurs de GenCom', 'cartes;France;Mappy;géoportail;Michelin;départements', 'lexilogos.com', '0', '2006-08-01 22:06:16', NULL, NULL),
(593, 2, 'Les mégalithes du Morbihan', 'http://www.culture.gouv.fr/culture/arcnat/megalithes/fr/index.html', 'Inscrits dans le paysage, menhirs et agencements de pierres dressées font du Morbihan une région privilégiée en matière de recherche sur le mégalithisme. Les formes colossales de Carnac constituent la série la plus emblématique de cette architecture. Elles sont les marques des sociétés néolithiques des Ve-IIIe millénaires avant notre ère', 'mégalithes;menhirs', 'culture.gouv.fr', '0', '2006-08-01 21:53:00', NULL, NULL),
(590, 2, 'Un site sur la préhistoire pour le cycle 3', 'http://www.laprehistoire.net/', 'Un site où tu pourras chercher des informations sur la préhistoire.\r\nLexique  Chronologie Paléolithique  Néolithique Art, des références filmiques', 'préhistoire;histoire', 'Lucien SULTRA', '0', '2006-08-01 21:02:31', NULL, NULL),
(591, 2, 'Le site de l''homme de Tautavel', 'http://www.tautavel.culture.gouv.fr/', 'Un site sur la préhistoire. Le musée de Préhistoire de Tautavel, avec plus de 1500 m² de galeries d’exposition,\r\nvous invite à découvrir l’Homme de Tautavel, ses outils, les animaux qu’il chassait,\r\nson habitat et son environnement. Jeu sur les origines de l''homme.', 'préhisroire;histoire', 'tautavel.culture.gouv.fr', '0', '2006-08-01 21:49:21', NULL, NULL),
(592, 2, 'Site de la grotte de Lascaux', 'http://www.lascaux.culture.fr/', 'Visite virtuelle de la grotte de Lascaux permettant de découvrir la vie des hommes préhistoriques, l''art.\r\nUtilisable pour le cycle 3.', 'préhisroire;histoire', 'Ministère de la culture', '0', '2006-08-01 21:50:08', NULL, NULL),
(588, 2, 'Curiosphere', 'http://www.curiosphere.tv/', 'Un site de France  sur tous les thèmes', 'lecture;compréhension;sélection; sciences; europe; environnement; histoire; géo; géographie', 'France 5', '0', '2006-08-01 20:55:41', NULL, NULL),
(589, 2, 'Le dictionnaire multi-fonctions de TV5', 'http://dictionnaire.tv5.org/', 'Dictionnaire de définitons  	Dictionnaire de synonymes  	Dictionnaire de conjugaisons  	Dictionnaires Français-Anglais  	Dictionnaire Anglais-Français. Tu saisis ta requête et tu valides pour obtenir la définition ou cliquez sur l''onglet de ton  choix.', 'dictionnaires;synonymes;conugaison;anglais', 'TV5', '0', '2006-08-01 21:01:14', NULL, NULL),
(587, 2, 'L''Europe de contes pour le  cycle 2 et cycle 3', 'http://www.europeoftales.net/site/fr/', 'Ce site est une petite merveille. Il te fera découvrir des contes d''Europe ( Islande;Ecosse,Finlande,Bretagne;Italie).\r\nTu rentreras dans les histoires comme si tu étais au cinéma. Les personnes vont parler devant toi, comme si tu étais devant la télé, ou au cinéma, ou dans une bande dessinée. Tu verras apparaître pour chaque histoire, un narrateur ( un animal) qui &quot;observe&quot; et raconte à la troisième personne.Tu aimeras les narrations et les mises en scène des histoires interactives. Tu auras un dictionnaire à ta disposition et une carte poiur t''aider à tout moment.', 'littérature;narration;mise en scène;personnage;narrateur;contes;bulles;cycle 2', '.europeoftales.ne', '0', '2006-08-01 20:41:35', NULL, NULL),
(586, 2, 'Histoire de France ... des repères; des frises pour le cycle 3', 'http://www.alyon.org/generale/histoire/france/', 'L''histoire de France de l''antiquité à nos jours\r\nSouverains et chefs d''Etat Français\r\nLe calendrier Républicain\r\nConstitution française depuis 1789\r\nElection présidentielle depuis 1965\r\nMaréchaux de France depuis 1804\r\nHistoire des guerres françaises', 'histoire;france;frise', 'Association Alyon', '0', '2006-08-01 20:37:28', NULL, NULL),
(583, 2, 'Poèmes à voix haute de Victor Hugo au cycle 3', 'http://expositions.bnf.fr/hugo/grosplans/loupe/index.htm', 'Tu pourras lire et écouter des poèmes ou poésies de Victor Hugo.', 'Victor;Hugo;poésies;écoute;cycle3;littérature', 'bnf', '0', '2006-08-01 20:28:47', NULL, NULL),
(584, 2, 'Le site de Saint-Exupéry pour les élèves de cycle 3', 'http://www.saint-exupery.org/', 'Un site sur la vie et l''oeuvre de Saint-Exupéry. CE2-CM1-CM2', 'littérature:Jeunesse;Saint;Exupéry;cycle3', ' Société Civile pour l''Oeuvre et la Mémoire d''Antoine de Saint Exupéry', '0', '2006-08-01 20:30:54', NULL, NULL),
(585, 2, 'Les contes de Charles Perrault', 'http://www.alyon.asso.fr/litterature/livres/XVIII/esprit_salon/perrault/', '	\r\nContes de Perrault\r\nBarbe bleue\r\nCendrillon\r\nLa belle au bois dormant\r\nLe chat botté\r\nLe petit chaperon rouge\r\nLe petit poucet\r\nLes fées\r\nLes souhaits ridicules\r\nPeau d''âne\r\nRiquet à la houppe', 'contes;lecture;Perrault', 'www.alyon.asso.fr', '0', '2006-08-01 20:33:29', NULL, NULL),
(581, 2, ' A la découverte de Jean de La Fontaine au cycle 3', 'http://www.lafontaine.net/nouveau-site/index.php', 'Site sur les fables de La Fontaine.\r\nTu peux envoyer tes  pastiches de fables, tes dessins de fables, tes portraits de La Fontaine.\r\nTu verras les belles illustrations sur ce site. Elles sont faites par Willy Aractingi qui vient de mourir en Espagne pendant ses vacances en Espagne. On peut rendre hommage à ces belles oeuvres.', 'fables;littérature;La Fontaine;répertoire;illustration;cucle 3;CE2;CM1;CM2', 'Willy Aractingi pour l''illustration - Administrateur du site', '0', '2006-08-01 20:14:38', NULL, NULL),
(582, 2, 'Site sur Jules Verne pour les élèves du cycle 3', 'http://education.france5.fr/julesverne/', 'Site sur la vie et l''oeuvre de Jules Verne. Tu peux également voir des vidéos en ligne', 'Jules;Verne;littérature;vidéo;cycle 3', 'education.france5. La vidéo : CNDP', '0', '2006-08-01 20:26:08', NULL, NULL),
(578, 2, 'Les 1001 nuits pour le cycle 3', 'http://www.2001nuits.net/', 'Histoire avec le texte et lue par un conteur. Tu verras les belles illustrations et calligraphies.', 'histoire;récit;cycle3;calligraphie', '2001nuits.net', '0', '2006-08-01 19:57:18', NULL, NULL),
(579, 2, 'La citadelle du Ty Pouet ... petite  poésie pour sourire', 'http://www.la-citadelle-du-typouet.info/', 'Une façon &quot;rigolote&quot; d''user du moteur de recherche', 'poésies;humour;moteur;recherche', 'la-citadelle-du-typouet', '0', '2006-08-01 20:01:05', NULL, NULL),
(580, 2, 'Les enquêtes de l''inspecteur Lafouine pour le cycle 3', 'http://ecole.toussaint.free.fr/lafouine/lafouine.htm', 'Tu peux lire des textes où tu pourras mener des enquêtes policières. Il y aura des énigmes mais tu sauras trouver les indices...C''est interactif. Qu''il faille procéder par élimination, ou par déduction. Qu''il faille exposer les mensonges ou déchiffrer des codes, l''inspecteur Lafouine n''a pas son pareil pour venir à bout des énigmes les plus retorses.Tu peux devenir écrivain et écrire une enquête  policière.', 'énigmes;intrigies;policier;enquête;lecture;cycle3;écriture;littérature', 'Le personnage de Lafouine est une création de Christian Souchard', '0', '2006-08-01 20:08:00', NULL, NULL),
(577, 2, 'Les clés de l''actualité Junior pour le cycle 3', 'http://www.lesclesjunior.com/', 'Avec ce site, tu pourras découvrir l''actualité clairement expliquée aux élèves de  8/12 ans(CE2,CM1,CM2)', 'journal;actualités;presse;cycle3', 'Les clés de l''actualité Junior', '0', '2006-08-01 19:53:45', NULL, NULL);
INSERT INTO `module_ressource_ressources` (`id`, `id_annu`, `nom`, `url`, `description`, `mots`, `auteur`, `submit_user`, `submit_date`, `valid_user`, `valid_date`) VALUES
(576, 2, 'Ouest-France-Ecoles  pour l''éducation aux média', 'http://www.ouestfrance-ecole.com/commun/scripts/blocsmetiers/com_frame.asp?lien=/accueil.asp&amp;param=', 'Un site pour l''éducation aux média.Le site ouestfrance-ecole.com a été créé parce qu’il répond à des besoins légitimes à la fois de l’éducation nationale et d’Ouest-France.Le site a été créé d’abord pour aider à l’instruction et à l’éducation des élèves. Mais les enseignants, du premier et du second degré, sont les prescripteurs naturels. Le contenu et la forme du site ont été conçus pour répondre aux attentes des enseignants qui souhaitent :\r\n- être mieux armés pour aborder la presse à l’école : &quot; Le journal en 10 questions &quot; et &quot; Découvrir Ouest-France &quot;\r\n- avoir des propositions d’exercices en classe, avec des outils et des corpus d’articles ou de visuels : &quot; Travailler sur le journal &quot;\r\n- disposer d’articles et de visuels pour enrichir ou illustrer un cours : &quot; Comprendre l’actualité &quot;\r\n- échanger avec Ouest-France : of-ecole@ouest-france.fr \r\n- échanger avec d''autres enseignants, proposer aux élèves de valoriser leurs travaux en participant à des forums', 'médias;journaux;écrire;lire;presse', 'Ouest-France-Ecoles', '0', '2006-08-01 19:32:50', NULL, NULL),
(574, 2, 'Le monde de Koda pour un voyage musical du cycle 1 au  cycle 3', 'http://education.france5.fr/musique/', 'Sur la carte du monde, tu peux lire dans les pays des 4 contients, l''histoire des instruments. Tu vas découvrir les classes d''instrument et puis on t''emmènera dans un labo-interactif.Bon voyage musical. Tu ne seras pas déçu du voyage.', 'musique;instruments;jeux;cycle1;cycle2;cycle3', 'France 5', '0', '2006-08-01 19:16:50', NULL, NULL),
(575, 2, 'Site du CLEMI pour utiliser les médias à l''école', 'http://www.clemi.org/fr/', 'Accompagnement pédagogique des projets &quot;Presse&quot;. Outils et activités pour la classe. Projet de la semaine de la presse.', 'média,', 'CLEMI', '0', '2006-08-01 19:30:48', NULL, NULL),
(573, 2, 'Activités et jeux avec l''orchestre au cycle 3', 'http://www.capcanal.com/couleurs/pages/encyclo/encyclo.htm', 'Des activités et des jeux qui vont te permettre de mieux repérer et reconnaître les instruments de musique\r\n	Diapason de l''orchestre 	\r\n\r\n	Instruments à percussion 	\r\n\r\n	Instruments à cordes 	\r\n	Classification des 4 choeurs 	\r\n\r\n	Classification de toutes les voix 	\r\n	Hauteur : grave / aigu 	\r\n\r\n	Classification des instruments à vent 	\r\n	Colorie des instruments 	\r\n	La maison des cordes 	\r\n	Le chant 	\r\n	Peux-tu reconnaître les notes ? 	Dictée musicale (Do-mi-sol)\r\n	Le chant : la voix de ténor 	QCM\r\n	Les choristes et le travail de la voix\r\n	\r\n	Memory musical 	\r\n	Disposition des instruments 	\r\n	Teste-toi sur le VIOLONCELLE 	\r\n	Teste-toi sur le COR 	\r\n	Les cuivres 	\r\n	Les trois types de hautbois 	\r\n	Teste-toi sur le COR ANGLAIS 	\r\n	Teste-toi sur le TROMBONE 	\r\n	La durée des notes 	\r\n	Teste-toi sur la TROMPETTE 	\r\n	Les parties de la trompette 	\r\n	Les parties de la flûte 	\r\n	Teste toi sur le BASSON 	\r\n	Les parties de la clarinette \r\n	Pendu des instruments à vent 	\r\n	Teste-toi sur la FLUTE 	\r\n	Les cordes du violon 	\r\n	Teste-toi sur le VIOLON 	\r\n	Reconnaissance des bois 	\r\n	Les parties de l''alto 	\r\n	Teste-toi sur l''ALTO 	', 'musique;orchestre;jeux;instruments;écoute', 'capcanal.', '0', '2006-08-01 19:13:00', NULL, NULL),
(572, 2, 'Schéma simplifié de la classification des instruments', 'http://www.capcanal.com/couleurs/pages/encyclo/classification.htm', 'Un document qui te sert à te repérer avec tous les types d''instruments.Utilisable au cycle 3', 'musique;instruments;classification;schéma;cycle3', 'capcana', '0', '2006-08-01 19:08:55', NULL, NULL),
(570, 2, 'Encyclopédie musicale pour le cycle 3', 'http://www.capcanal.com/couleurs/pages/encyclo/encyclo.htm', 'Tu trouves là la définition de mots en musique. Cette encyclopédie peut être utilisée par les élèves du cycle 3', 'musique;définition;vocabulaire', 'capcanal', '0', '2006-08-01 19:03:18', NULL, NULL),
(571, 2, 'Disposition des instruments dans un orchestre', 'http://www.capcanal.com/couleurs/telecharger/disposition.pdf', 'Un document synthétique te permattant de voir en &quot;un schéma&quot; comment sont disposés les instruments dans un orchestre. ', 'instruments;orchestre', 'capcanal', '0', '2006-08-01 19:04:37', NULL, NULL),
(569, 2, 'Les couleurs de l''orchestre du cycle 1 au cycle 3', 'http://www.capcanal.com/couleurs/index.htm', 'Alors là ... tu voyages au choeur d''un orchestre comme si tu y étais. Tu découvres chaque série d''instruments de musique. Tu les entends jouer, tu les vois. Et puis .. sais-tu reconnaître les différentes voix d''une chorale ou d''un choeur? Tu as beaucoup d''informations sur l''époque de Verdi, Verdi,  et l''histoire d''Otello. Voici aussi une histoire de l''opéra qui te permettra de mieux connaître ce genre musical, ainsi que ses œuvres et ses compositeurs célèbres.', 'musique;enncyclopédie;instruments;écoute;voix;cycle1;cycle2;cycle3;Verdi;opéra;genre;musical', 'capcanal', '0', '2006-08-01 18:58:37', NULL, NULL),
(565, 2, 'L''art en s''amusant au cycle 3', 'http://www.bemberg-educatif.org/index.html', 'Avec ce site, tu vas pouvoir faire des parcours pour découvrir les arts... Des natures mortes, des paysages, des scènes de genre et puis tu pourras découvrir l''histoire de la peinture car tu disposes d''une machine à remonter le temps.\r\nTu peux aussi découvrir des oeuvres d''enfants. Adapté au cycle 3 (CE2;CM1;CM2)', 'arts;visuels;payages;peintres;scènes;histoire;peinture;natures;mortes;cycle3', 'Fondation Blemberg', '0', '2006-08-01 18:20:25', NULL, NULL),
(567, 2, 'Le musée des arts asiatiques des enfants', 'http://www.guimet.fr/-Jeux-et-jeunesse-', 'Un parcours asiatiques où tu peux découvrir des dragons, des oeuvres asiatiques. \r\nEn allant sur l''ancien site, un éléphant apparaîtra parfois avec des énigmes à trouver. Si tu lis bien, si tu observes, bien tu y arriveras facilement', 'lecture;arts;Asie', 'Musée des arts asiatiques Guimet', '0', '2006-08-01 18:37:59', NULL, NULL),
(563, 2, 'Fiches d''identité de certains animaux', 'http://darwin.cyberscol.qc.ca/Expo/Zoo/Fiches/Accueil.html', 'Tu cherches des renseignements  sur les mammifères, oiseaux, amphibiens... tu peux aller sur ce site qui te présentent des animaux avec une fiche d''identité.', 'animaux;lecture;document; mammifères, oiseaux; amphibiens;biologie', 'darwin.cyberscol.qc.ca', '0', '2006-08-01 18:00:07', NULL, NULL),
(564, 2, 'La petite ferme avec des jeux en ligne pour le Cycle 2', 'http://station05.qc.ca/csrs/ferme/', 'Tu vas découvrir des lieux avec des animaux et puis tu devras participer à des jeux.CP;CE1; éventuellement CE2\r\nTu devras associer les phrases aux dessins proposés. Il y a deux niveaux de difficulté. L''ordinateur t''indiquera si c''est juste ou faux.', 'animaux;lecture;document;résultats', 'Commission scolaire de Scherbrook au Canada', '0', '2006-08-01 18:06:53', NULL, NULL),
(562, 2, 'Encyclopédie de s animaux pour le cycle 2 et le cycle 3', 'http://www3.ac-nancy-metz.fr/crmfaulquemont/maternelle/ema2_imagier.php3', 'Sur ce site, tu peux découvrir des animaux, leurs modes de vie. Tu peux même entendre leurs bruits. Les  textes sont écrits par les camarades de ton âge. Toi aussi, tu peux contriber et enenvoyer un texte sur un animal. Tu as également un espace &quot;forum&quot;.', 'encyclopédie;recherche;animaux;écriture;lecture', 'académie de Nancy-Metz- CRM Faulquemont (Moselle)', '0', '2006-08-01 17:51:24', NULL, NULL),
(560, 2, 'Jeux magiques de Thérèse Eveillau du cycle 1 au cycle 3', 'http://perso.orange.fr/therese.eveilleau/pages/jeux_mat/indexF.htm', 'De nombreux jeux directement en ligne. Cycle 1- Cycle 2-Cycle 3\r\nGS;CP;CE1;CE2;CM1;CM2', 'mathématiques;numération:calcul;figures;soustraction;addition;problèmes;figure;repérage;logique', 'Thérèse Eveillau', '0', '2006-08-01 17:38:16', NULL, NULL),
(558, 2, 'Des machines à histoires de Clicksouris pour le cycle 3', 'http://www.clicksouris.com/machine.htm', 'Dans les histoires interactives de Clicksouris, tu es tour à tour, lecteur, acteur et auteur de l''histoire.\r\nDes histoires à lire, à écrire, à jouer... une autre façon de découvrir la lecture !\r\nTu verras, il y a de l''interactivité, des choix multiples, des parcours de lecture...\r\nMettre des histoires sur Internet, c''est aussi pour toi,  la possibilité de participer activement au récit, de devenir, tour à tour, lecteur, acteur et auteur de ce récit, et d''avoir la satisfaction valorisante de voir tes créations publiées.', 'lecture;écriture;récit;fiction;histoire', 'clicksouris', '0', '2006-08-01 17:23:38', NULL, NULL),
(556, 2, 'Histoires e-stories pour lire de belles histoires animées en ligne au cycle 2 et au cycle 3', 'http://www.e-stoires.net/vignette/Vignette.htm', 'Tu peux choisir 16 histoires à lire en ligne. Le texte n''est pas trop difficile si tu es au CE1 ou au CE2. Les histoires sont animées et sont très bien illustrées.', 'récits;histoires;animation', ' e-stories', '0', '2006-08-01 17:14:33', NULL, NULL),
(557, 2, 'Le bestiaire poétique pour le cycle 2, cycle 3', 'http://www.clicksouris.com/poesie/bestiaire.htm', 'Un atelier de découverte, d''écriture et de jeux autour de la poésie.\r\nDécouvrir les grands poètes et inventer des poèmes.Clique sur les lettres pour découvrir les animaux et leur poème, ainsi que les poésies créées par les enfants de ton âge.\r\n', 'écriture;lecture;poésie;bestiaire;cycle2;cycle3;GS;CP;CE1;CE2;CM1;CM2', 'Clicksouris', '0', '2006-08-01 17:17:48', NULL, NULL),
(555, 2, 'Histoire animée des &quot;Couleurs de balthazar&quot; pour le cycle 1 et le cycle 2', 'http://petitvelorouge.free.fr/Flash/balthazar.swf', 'Histoire animée des &quot;Couleurs de balthazar&quot;. Exploitable pour le jeu des mariage des couleurs.Texte abordable niveau CE1; début CE2', 'histoire;animation;littérature;cycle1;maternelle;récit;arts;visuels;CP;CE1', 'petitvelorouge.free.f', '0', '2006-08-01 17:09:33', NULL, NULL),
(553, 2, 'Wismo et le cirque Babum .. une histoire animée du cycle 1 au cycle 3', 'http://www.wismo.ch/pages/cirque.html', 'Une histoire animée en ligne pour les élèves du cycle 1 et cycle 2. Peut être utilisée pour des travaux en Arts... Une petite merveille à l''écran à découvrir.Exploitation en graphisme, en langage oral. Les élèves du cycle 3 pourront lire le texte associé à l''histoire. Les personnages sont tellement beaux... il y a là un petit chef d''oeuvre à exploiter. ( Découverte indivisuelle ou en vidéo-projecteur...iy TBI', 'histoire;langage;cycle1;cycle2;récit;cycle3;graphismes;décors', 'www.wismo.ch', '0', '2006-08-01 16:54:11', NULL, NULL),
(554, 2, 'Histoire animée de &quot;YO-YO&quot; l''ascenseur', 'http://petitvelorouge.free.fr/Flash/yoyo/Master.swf', 'Yoyo n''est pas un ascenseur comme un autre. Pour découvrir son secret, il faut cliquer sur des les boutons.Texte à lire au fur et à mesure de la progression de l''histoire.', 'histoire;arts;visuels;ascenseur;cycle1;cycle2;cycle3', 'petitvelorouge.free.fr Olivier Douzou', '0', '2006-08-01 17:03:12', NULL, NULL),
(552, 2, 'L''arbre magique de Tibao .. une histoire à voir et à écouter pour le cycle 1 et le cycle 2', 'http://www.tibao.com/', 'Histoire animée à l''écran. Pour le cycle 1 et le cycle 2\r\nElèves de GS;CP;CE1', 'histoire;animation;littérature;cycle1;maternelle', 'Grégory Korzeniowski 2006', '0', '2006-08-01 16:48:17', NULL, NULL),
(549, 2, 'Découvrir une illustratrice de livre', 'http://www.emilievanvolsem.info/', 'Emilie Vansomsem, illustratrice, se présente sur son site adapté aux élèves de l''école élémentaire qui aiment les albums et les arts visuels', 'littérature;illustration;histoire;images', 'Emilie Vansomsem', '0', '2006-08-01 16:28:36', NULL, NULL),
(550, 2, 'Les jeux de Margouillat du vélo rouge.. des albums animés', 'http://petitvelorouge.free.fr/', 'Des histoires animées à l''écran pour des élèves de l''école maternelle. de 3 à 7 ans ...\r\nou pour tous les âges, si on aime &quot;les belles choses à l''écran&quot;. jeux de couleur;une poule qui perd la boule;Jojo l''ascenceur\r\n', 'histoire;animation;littérature;cycle1;maternelle', 'vélo rouge', '0', '2006-08-01 16:35:29', NULL, NULL),
(551, 2, 'Le mémory des sons du petit vélo rouge pour les élèves de maternelle ( Cycle 1 et cycle 2)', 'http://petitvelorouge.free.fr/Flash/memoSon.swf', 'Associe deux boîtes qui font le même bruit.', 'musique;écoute;mémory;discrimination;auditive;cycle1:cycle2;maternelle', 'petitvelorouge.free.', '0', '2006-08-01 16:42:05', NULL, NULL),
(547, 2, 'Les jeux en ligne de Picandou pour le cycle 1', 'http://materalbum.free.fr/puzzles.htm', 'Jeux pour les élèves du cycle 1 ( maternelle ) et GS :puzzles, tableaux à double entrée,mémory;associations ', 'logiciel;puzzles; tableaux ;mémory;associations ;GS;MS', ' Picandou', '0', '2006-08-01 16:14:09', NULL, NULL),
(545, 2, 'Jeux et activités en ligne sur le site de Toupty pour le cycle 1 et cycle 2', 'http://www.toupty.com/', 'Site dédié aux enfants avec des activités diverses et variées en ligne. Puzzles en ligne classés par difficultés. Jeux pour découvrir l''intrus. Jeux d''observation. Grilles de sodoku pour enfants. Jeux sur les chiffres et les nombres.Jeux de mémory. Jeux pour classer les images dans l''ordre chronologique. Jeux de mémoire et de  logique. Mots croisés en ligne pour enfants. Jeux de  lettres. Jeux puissance4, jeu du morpion et taquins de 9, 12 et 16 pièces en ligne. Jeux divers. Activités à imprimer. coloriages à imprimer. Llabyrinthes à imprimer. Labyrinthes. Paroles de chansons', 'jeux;logiciel;cycle1;cycle2;exercice;labyrinthe;morpion;puissance4;mots:croisés;Sodokou', 'Toupty', '0', '2006-08-01 16:05:37', NULL, NULL),
(542, 2, 'Les jeux de Lulu pour le cycle 2 et le cycle 3', 'http://perso.orange.fr/jeux.lulu/', 'Jeux de logique;repérage.Exercices et jeux variés; logique; Le bon rythme;Le bon ordre;Autour du\r\nnombre;numération;jeux de lettre;jeux de mémory;Abécédaire;observations;jeux pour malvoyants.\r\nLogiciels directement accessibles en ligne.\r\n	\r\n\r\n	\r\n\r\n	', 'calcul;lecture;cycle2;cycle3;logique;repérage;logiciel;gratuit;freeware', 'Régine des jeux de Lulu', '0', '2006-08-01 15:35:24', NULL, NULL),
(543, 2, 'Le cercle enchanté pour aborder le nombre au cycle 1', 'http://station05.qc.ca/css/cercle/accueil.html', 'Le Cercle enchanté s''adresse à l''enfant de quatre et de cinq ans. Au fil des mois, par le biais de jeux tu apprendras à compter.Grâce  à  Mélisse et de Serpolet, tu auras à résoudre une série de trente problèmes simples sur le nombre. Exploitable en MS;GS;évetuellement au CP avec des élèves en difficulté.', 'calcul;numération;nombre;cycle1;MS;GS', 'cercle enchanté', '0', '2006-08-01 15:53:06', NULL, NULL),
(541, 2, 'Site Tralalère pour des activités musicales en ligne', 'http://www.tralalere.com/', 'Des activités musicales pour les enfants par niveau d''age pour l''école maternelle et aussi pour l''école élémentaire.\r\nSite interactif,sonore.Activités directes en ligne. Le site sera accessible sur abonnement après Septembre 2006', 'musique;chants;répertoire', 'site Tralalère', '0', '2006-08-01 15:33:25', NULL, NULL),
(540, 2, 'Les points essentiels des  programmes en EPS pour les 3 cycles', 'http://netia59a.ac-lille.fr/~siteia/ressources_peda/eps/index.php', 'Arrêté du 25-1-2002 . JO du 10-2-2002 (BO HS n°1 du 14 février 2002)\r\n\r\n    * Les Objectifs     * La Programmation  *  L''École Maternelle  *  Le cycle 2: Cycle des apprentissages fondamentaux \r\n\r\n   * Le cycle 3: Cycle des approfondissement', 'EPS;cycle2;cycle3;programmes;2002;maternelle', 'IA59', '0', '2006-08-01 15:23:36', NULL, NULL),
(539, 2, 'La natation à l''école au cycle 2', 'http://netia59a.ac-lille.fr/~siteia/ressources_peda/eps/cd_natation.php', 'S''appuyant sur les contenus des programmes de 2002 pour la natation à l’école élémentaire, ce cédérom vous propose :\r\n    * 4 situations de référence,\r\n    * plusieurs situations de jeux pour répondre aux besoins d’apprentissage des élèves selon 3 thèmes : immersion, équilibre et propulsion. Dans chaque thème, 3 niveaux d’acquisition sont repérés : du niveau 1 (orange) pour les élèves les moins débrouillés au niveau 3 (vert) pour ceux qui sont le plus à l’aise, en passant par un niveau intermédiaire (jaune),\r\n    * des éducatifs pour renforcer les acquis de chacun, avec des indicateurs visant à orienter l’observation et les conseils prodigués par l’enseignant le cas échéant,\r\n    * 4 tests d’évaluation de fin de module pour des niveaux de classe différents\r\nLe CD-Rom est téléchargeable\r\n', 'EPS;natation;cycle2;CD-ROM;programmes;2002', 'ia59', '0', '2006-08-01 15:18:35', NULL, NULL),
(538, 2, 'Attestations scolaires de sécurité routière de niveaux 1', 'http://eduscol.education.fr/D0187/accueil.htm', 'Espace de préparation individuelle des élèves de collège aux épreuves des attestations scolaires de sécurité routière de niveaux 1 et 2 propose plusieurs moyens d''évaluation des connaissances : des fiches thématiques, des questions liées à des vidéos en mode d''entraînement ou de test.Ressources pour les élèves.', 'sécurité;route;APER', 'DESCO;education nationale', '0', '2006-08-01 15:17:01', NULL, NULL),
(537, 2, 'Site sur la sécurité routière', 'http://netia59a.ac-lille.fr/~securite-route/', ' Tests APER ASSR | Fiches pédagogiques | Actions | Articles | Liens\r\nRessources pour les élèves sur la sécurité routière.\r\n\r\n', 'sécurité;route;APER', 'Ia59', '0', '2006-08-01 15:12:12', NULL, NULL),
(536, 2, 'Le petit-déjeuner d''Ali une histoire animée pour la maternelle', 'http://vbelmokhtar.free.fr/ali/page0.htm', ' Pour lire l''histoire d''Ali c''est très simple, dans chaque page qui apparaît à l''écran, clique sur un des objets animés et celui-ci te mènera à la page suivante de l''histoire. Attention, tous les objets ne marchent pas forcement, il faut trouver le bon !', 'histoire;lecture;cycle1;MS;GS;logiciel;gratuit', '', '0', '2006-08-01 15:06:21', NULL, NULL),
(535, 2, 'Imagiers de Pédagosite', 'http://pedagosite.net/archives/pedago_imagier.htm', 'Imagiers avec une entrée par thème. Utilisable dans les classes de maternelle, dans les classes de primo-arrivant pour apprendre le lexique des mots. L''imagier n''est pas sonore.On voit apparaître les images et le mot de ce qui est représenté.', 'vocabulaire;imagiers;catégorisation,lexique;logiciel;FLE;primo-arrivant', 'pédagogite', '0', '2006-08-01 15:03:21', NULL, NULL),
(534, 2, 'Logiciel Moi, je sais lire éditeur Club PoM pour le cycle 2', 'http://www.clubpom.fr/', '&quot;Moi, je sais lire&quot; offre une mine d''activités ludiques pour reconnaître les lettres, apprendre les sons, jouer à les assembler, former des mots, et jongler avec les phrases.\r\nCe logiciel, offre de nombreux paramètres (gestion des niveaux, sélection des thèmes à étudier, création d''exercices, suivi des activités, bilans personnalisés,...), il se révèle un outil d''enseignement sur mesure et peut être utilisé avec n''importe quelle méthode de lecture existante. Cdrom compatible Mac et PC Label RIP (Reconnu d''Interêt Pédagogique) 35 euros en version monoposte. ', 'logiciel;exerices;lecture;cycle2;CP;CE1', 'ClubPom', '0', '2006-08-01 14:46:47', NULL, NULL),
(531, 2, 'Logiciel Tuxpyping pour apprendre à utiliser le clavier', 'http://tuxtype.sourceforge.net 	', 'Le logiciel TuxType permet d’apprendre aux enfants (pas uniquement ;-) à taper au clavier. L''interface s''apparente aux jeux vidéos. Des lettres ou des mots tombent du haut de l''écran, il faut taper ce qui s''affiche pour nourrir le petit pingouin en bas de l''écran. Le logiciel est sonorisé. Il propose plusieurs niveaux de difficulté et un mode d''entrainement (Pratique) qui indique en même temps que la lettre à taper, le doigt à utiliser. Plusieurs langues sont proposées. Au lancement du logiciel, paramétrer le logiciel en français via le menu Options. Logiciel libre gratuit sous licence GNU/GPL PC Linux/Windows MAC', 'logiciel;libre;gratuit;lettres', ' Jesse Andrews', '0', '2006-08-01 14:30:47', NULL, NULL),
(530, 2, 'Logiciel avec des jeux de géographie', 'http://olivier.leflon.free.fr/jeux/jeux.htm', 'Avec ce logiciel, vous pouvez maintenant jouer avec les fleuves, rivières, lacs, montagnes et sommets de France, la carte du ciel, les pays ou états du monde entier (Europe, Amérique du Sud, Amérique du Nord, Afrique, Asie, ou Océanie), leur capitale et leur drapeau, ainsi qu''avec les départements français, leurs préfectures et leurs sous préfectures', 'logiciel;gratuit;géographie;fleuves;rivières;montagnes;sommet;pays;capitale;drapeaux;département;', 'Olivier Leflon', '0', '2006-08-01 14:23:38', NULL, NULL),
(528, 2, 'Une simulation d''écluse', 'http://www.pragmasoft.be/carnets/geo/ecluse/', 'Animation interactive en ligne permettant de découvrir le fonctionnement d''une écluse', 'sciences;technologie;fonctionnement;écluse', 'Pragmasoft', '0', '2006-08-01 14:09:57', NULL, NULL),
(529, 2, 'Logiciel Balamonde pour voyager en hélicopère', 'http://www.pragmasoft.be/balamonde/', '2 100 destinations à localiser en hélicoptère sur la carte du monde ! \r\n(pays, capitales, villes, mers, fleuves, montagnes, lieux historiques, ...)Version complète (10 EUR) ', 'logiciel;payant;goégraphie', 'Pragma-Soft', '0', '2006-08-01 14:18:24', NULL, NULL),
(527, 2, 'Mots dissimulés pour le cycle 3', 'http://www.ecoliciel.net/', 'Mots dissimulés à imprimer.\r\nMémorisation des noms de pays. Jeu d''attention', 'texte;mots;dissimulés;exercice', 'mnouvier@club-internet.fr', '0', '2006-08-01 14:04:00', NULL, NULL),
(526, 2, 'Logiciel  Calcul mental et comparaisons de nombre pour le cycle 2 et le cycle 3', 'http://www.ecoliciel.net/', 'Activités proposées : calcul mental avec les quatre opérations de base. Différents niveaux de difficulté pour chaque type d''opération.Comparaison de nombres et de sommes. Gestion optimisée des groupes d''élèves et des résultats.\r\nUtilisable en cycles 2 et 3 et plus... Pour l''enseignant:Une gestion des groupes et des résultats très simple, protégée par mot de passe créé par l''enseignant. Dix groupes, avec un maximum de trente élèves par groupe, peuvent être gérés. L''enseignant peut consulter les résultats individuels ou ceux d''un groupe et  les imprimer. Il peut aussi les archiver dans des fichiers externes ou les supprimer si besoin.  Pour l''élève:sélection de l''opération et du niveau de difficulté. L''élève peut voir et imprimer les résultats de sa séquence de travail.\r\naddition ( 5 niveaux) ajouter 10, 20, ..ajouter 100, 200...	soustraction (3 niveaux); retrancher 10, 20, ..\r\nretrancher 100, 200... 	multiplication ( 2 niveaux); tables; multiplier par 10, 100, 1000', 'calcul;mental;comparaison;numération;logiciel;gratuit;freeware;résultats;scores;cycle2;cycle3', 'mnouvier@club-internet.fr', '0', '2006-08-01 13:55:15', NULL, NULL),
(525, 2, 'Logiciel Questions et Réponses V.3a pour le cycle 2 et le cycle 3', 'http://www.ecoliciel.net/', 'Questionnaires et exercices élaborés. Création aisée de nouveaux exercices ou questionnaires avec un module de création. Questionnaires ou exercices pour toutes matières.Idéal pour proposer des fiches de lecture ou toutes sortes d''exercices variés. Les questionnaires peuvent être indépendants ou liés à un texte consultable à l''écran ( texte littéraire, règle de grammaire, énoncé,etc...). On peut ajouter un commentaire à chaque question.\r\nLe logiciel contient plusieurs questionnaires dans diverses matières.Utilisable en cycles 2 au au cycle 3.Une gestion très souple des groupes et des résultats.Dix groupes de trente élèves au maximum, peuvent être gérés.\r\nL''enseignant peut consulter  les résultats de chaque groupe ou ceux d''un élève en particulier et  les imprimer. Les dates, résultats et noms de questionnaires sont clairement indiqués. On peut donc contrôler simplement le parcours de chaque élève. ', 'lecture;compréhension;lecture;ouvert;gratuit;résultats;réussite;score;cycle2;cycle3', 'mnouvier@club-internet.fr', '0', '2006-08-01 13:36:09', NULL, NULL),
(524, 2, 'Logiciel  &quot;Operpose&quot; pour la technique de l''additions avec ou sans retenues', 'http://www.ecoliciel.net/', 'Operpose est un logiciel permettant de s''entraîner sur la technique de l''addition avec ou sans retenue.Pour le CP;CE1', 'logiciel;gratuit;exercices;calcul;opération;addition;cycle 2;CP;CE1', 'mnouvier@club-internet.fr', '0', '2006-08-01 13:29:19', NULL, NULL),
(523, 2, 'Logiciel &quot;Ordinombres&quot; pour le cycle 2', 'http://www.ecoliciel.net/', 'Logiciel de numération qui permet de travailler sur les comparaisons de nombres de façon ludique.six niveaux de recherche:nombre mystère entre:0 et 10, 0 et 20, 0 et 50,0 et 100, 0 et 250, 0 et 500. Trois niveaux de difficulté:\r\nfacile, moyen et difficile. L''enfant choisit au départ un niveau de difficulté. Pour gagner, il devra trouver le nombre mystère en ne dépassant pas le nombre d''essais proposé.Dans ce cas, il gagne une coupe. A la fin d''une partie complète, le score est affiché. Utilisable à partir du CP\r\n', 'calcul;numération;cycle2:CP;CE1;logiciel;gratuit;freeware;jeux;scores;réussite', 'mnouvier@club-internet.fr', '0', '2006-08-01 13:25:04', NULL, NULL),
(522, 2, 'Logiciel &quot;Ordinombres&quot; pour le cycle 2', 'http://www.ecoliciel.net/', 'Logiciel de numération pour le cycle 2.', 'mathématiques;CE1;numération;gratuit;freeware;logiciel', 'mnouvier@club-internet.fr', '0', '2006-08-01 13:21:11', NULL, NULL),
(521, 2, 'Logiciel de lecture &quot;Jumimot&quot; pour le cycle 2', 'http://www.ecoliciel.net/telecharger_jumimots.htm', 'Jeu de lecture, discrimination visuelle\r\nUtilisation avec la souris.\r\nDans chaque tableau , il faut retrouver les paires de mots identiques .\r\nTrois niveau de difficulté et huit tableaux de mots. Utilisable du CP au CE1.\r\n	\r\n\r\n', 'lecture;jeux;lettres;CP;GS;maternelle gratuit;freeware;ouvert', 'mnouvier@club-internet.fr', '0', '2006-08-01 13:16:22', NULL, NULL),
(520, 2, 'Logiciel &quot;Discrimots&quot; pour des jeux de lecture au cycle 2', 'http://www.ecoliciel.net/telecharger_discrimots.htm', 'Discrimots est un logiciel proposant des jeux de lecture, de discrimination visuelle. Entrainement pour l''utilisation avec la souris.Dans chaque ligne de mots, l&quot;élève doit retrouver celui qui est identique au premier mot. Le logiciel est fourni avec 6 fichiers externes format .txt modifiables à souhait.Ils correspondent aux 6 séries de mots du logiciel.Logiciel ouvert à la progression de la classe.\r\n\r\nLogiciel gratuit', 'logiciel;gratuit;exercices;lecture;ouvert;cycle2;CE1;CP', 'mnouvier@club-internet.fr', '0', '2006-08-01 13:13:17', NULL, NULL),
(519, 2, 'Logiciel &quot;les Orthonautes&quot; pour le cycle 2 et le cycle 3', 'http://monthey.ecolevs.ch/Jacquemettaz/Ortho/ortho.htm  	', 'Ce logiciciel propose aux élèves de recopier tous les mots du vocabulaire de base, classés par noms, verbes, adjectifs, autres mots, phrases. Les mots/goupes de mots, disparaissent progressivement à l''écran. Il est possible de revoir les mots. Ces mots sont issus de la répartition suisse romande du vocabulaire à étudier à l''école primaire. Logiciel entièrement paramètrable. Adaptable au niveau et au contexte de la classe \r\n\r\n\r\n \r\n\r\nLogiciell ouvert gratuit', 'logiciel;ouvert;gratuit;freeware;copie;orthographe', 'Georges JACQUEMETTAZ', '0', '2006-08-01 13:09:58', NULL, NULL),
(518, 2, 'Logiciel &quot;''aquadictées&quot; pour le cycle 2 et le cycle 3', 'http://monthey.ecolevs.ch/Jacquemettaz/Aquadictees/aquadict.htm   	', 'Aquadictées permet à l''élève de recopier des mots ou goupes de mots proposés par l''enseignant. Ces mots ou goupes de mots remontent progressivement l''écran, à une vitesse plus ou moins rapide selon le nombre de lettres et disparaissent. Il est possible de revoir les mots. Logiciel entièrement paramétrable par l''enseignant\r\nLogiciel ouvert gratuit', 'logiciel;ouvert;copie;orthographe;CP;CE1;CE2;CM1;CM2;cycle2;cycle3', 'Georges JACQUEMETTAZ', '0', '2006-08-01 13:07:03', NULL, NULL),
(517, 2, 'Logiciel  &quot;clavier&quot; pour des des exercices de copie ou de dictée au cycle 2 ou cycle 3', 'http://perso.wanadoo.fr/dbigeard/', 'L''activité proposée consiste à réécrire des mots qui sont donnés. Deux exercices au choix. L''un où l''on clique sur les touches, l''autre où l''on tape ces dernières. Le logiciel est &quot;ouvert&quot; et adaptable en fonction des mots étudiés en classe. Dans le  deuxième exercice, on peut changer les mots grâce au fichier &quot;data&quot; du répertoire d''installation.\r\nLogiciel ouvert gratuit ', 'logiciel:ouvert;orthographe;copie;ORL;freeware;CP;CE1;CE2;CM1;CM2;gratuit', 'Didier BIGEARD', '0', '2006-08-01 13:03:11', NULL, NULL),
(514, 2, 'Des imagiers en ligne', 'http://www.imagiers.net  	', 'Une trentaine d''imagiers sonorisés (alphabet, couleurs, aliments, jours de la semaine, mois, saisons, sport, corps, visage, animaux, transports etc...) à utiliser directement en ligne. \r\n\r\n', 'langage;vocabulaire;imagiers;thèmes;FLE;ELCO;lexique;logiciel;gratuit', 'Site &quot;imagier&quot;', '0', '2006-08-01 11:39:42', NULL, NULL),
(511, 2, 'Logiciel 1000 MOTS pour apprendre à lire', 'http://perso.wanadoo.fr/jm.campaner/  	', 'Le logiciel propose  un corpus de 1200 mots liés à autant d''images et autant de sons. A ces mots sont associés 14 types d''exercices, eux-mêmes gradués en plusieurs niveaux de difficulté (3 au maximum) ; ainsi chaque élève a-t-il la possibilité d''avancer à son rythme et selon ses possibilités tout en suivant la progression de la classe. Les exercices sont regroupés en trois grandes familles :les exercices d''écoute, les exercices de reconnaissances basés sur la recherche d''indices, les exercices de combinatoire.Le logiciel permet de plus une gestion de groupes de niveaux utilisant éventuellement des méthodes différentes. La progression est automatique. Un suivi sous forme de bilan individuel détaillé est également à la disposition du maître. L''enseignant peut  modifier la progression proposée pour l''adapter à ses élèves ou à la méthode utilisée. Licence 16 euros licence établissement 26 euros', 'logiciel;ouvert;payant;lecture;langues;bilan;progrès;langue;lecture;ELCO', 'Campaner Jean-Marc', '0', '2006-08-01 11:29:18', NULL, NULL),
(510, 2, 'Logiciel Gcompris', 'http://gcompris.net/-fr-', 'GCompris est un logiciel éducatif qui propose des activités variées aux enfants de 2 à 10 ans.\r\nVous trouverez des activités dans les domaines suivants :\r\ndécouverte de l''ordinateur : clavier, souris, les mouvements de la souris\r\nmathématiques : révision des tables, dénombrement, les tables à double entrée, symétrie\r\nsciences : l''écluse, le cycle de l''eau, le sous-marin\r\ngéographie : placer les pays sur une carte\r\njeux : des casses têtes, les échecs, le memory\r\nlecture : exercice d''entraînement à la lecture\r\nautres : lecture de l''heure, peintures célébres sous forme de puzzle, dessin vectoriel\r\nLogiciel ouvert libre sous la licence GPL . Gcompris fonctionne sur GNU/Linux, MacOSX, Windows et d’autres versions d’Unix. (40 mo) licence 20 euros', 'mathématiques;sciences;géographie;jeux;lecture;peintres;arts;libre', 'Bruno Coudoin', '0', '2006-08-01 11:21:08', NULL, NULL),
(509, 2, 'Logiciel de lecture &quot;Associations&quot;  d''AbulÉdu pour le cycle 1 et le cycle  2', 'http://www.abuledu.org/leterrier/', 'Le logiciel Associations propose de nombreuses activités d''entraînement à la lecture : J''entends / Je n''entends pas, J''entends (Début - Milieu - Fin) J''entends (quelle syllabe?)-Discrimination visuelle : lettres phonèmes ou mot-Reconnaître une image, plusieurs étiquettes /plusieurs images, une étiquette Remettre les syllabes en ordre, les lettres en ordre\r\nEcrire Dictée visuelle Dictée. Logiciel ouvert libre gratuit sous licence GNU/GPL PC Linux/Windows/Apple. \r\nPour en savoir plus. Voir l''espace premier degré du pôle de compétences des logiciels libres.http://www.logiciels-libres-premierdegre-sceren.fr/\r\nLe logiciel Association permet d''enregistrer les résultats nominatifs obtenus pour les différents exercices.', 'logiciel;lecture;CP;CE1;cycle2;dictée;libre;gratuit;progrès;résultats', 'AbulEdu et son équipe', '0', '2006-08-01 09:43:39', NULL, NULL),
(508, 2, 'Logiciel de lecture &quot;lectra&quot; pour générer des exercices au cycle 2 et au cycle 3', 'http://www.lectramini.com/lectra.htm', 'L''enseignant propose des textes avec de simples fichiers texte (format .txt). Lectra génère les exercices d''entraînement suivants : closure, reconstitution, mots outils, mots éclairs, phrase mélangée, phrase incomplète, phrases sans espaces, lecture rapide, mots identiques, l''intrus, ordre alphabétique, memory mots, texte mélangé, texte à corriger. Enregistrement des résultats pour chaque élève. Le programmme existe en trois versions PC : Lectra 16 bits (Windows 3.1) - Lectra 32 bits (Windows 9x, XP), Lectra + synthèse vocale (Windows 9x, XP) et une version MAC (sans synthèse). Logiciel en libre essai - License établissement 22,87 euros et 38,11 euros pour Lectra + synthèse vocale. Les versions en libre essai (Lectra 16, Lectra 32) ne sont pas limitées dans le temps.', 'lecture;exercices;closure;reconstitution;logiciel;gratuit;payant;ouvert;résultats;progrès;score', 'BRUN-VILLANI', '0', '2006-08-01 09:31:37', NULL, NULL),
(507, 2, 'Logiciel SupraLec pour augmenter la vitesse de lecture au cycle 2 et au cycle 3', 'http://jc.meier.free.fr', 'Un logiciel pour augmenter la vitesse de lecture et mesurer les progrès réalisés. Il est ouvert et adaptable aux textes de la classe. N''importe quel type de fichier texte (format .txt) peut être utilisé. De nombreuses possibilités de paramétrage sont offertes : vitesse de défilement, taille des caractères, couleurs du fond et du texte, choix de la fonte ...Il est livré avec plusieurs textes mais il est possible de saisir ses propres textes.\r\nLogiciel ouvert en libre essai limité dans le temps - licence 17,50 euros sur site 35 euros', 'lecture;exercices;vitesse;cycle2;cycle3;CP;CE1;CE2;CM1;CM2;payant:mesures;progrès', 'Jean-Claude MEIER', '0', '2006-08-01 09:26:09', NULL, NULL),
(506, 2, 'Logiciel &quot;Ecrivons&quot; un traitement de textes simplifié pour le cycle 1 ou cycle 2', 'http://pnoguer.free.fr/ 	', 'Écrivons est un traitement de texte simplifié pour les enfants de cycle 1 et cycle 2 . Il ne propose que 3 polices, correspondants aux trois graphies utilisées à l''école maternelle. Par défaut, l''enfant écrit en majuscules d''imprimerie et retrouve donc les lettres du clavier de l''ordinateur. Il peut également choisir de voir et imprimer son texte en scripte ou en cursive. Les autres fonctions disponibles sont l''agrandissement et la réduction de la taille du texte.\r\nLogiciel gratuit PC', 'traitement de textes;écriture;maternelle;C2;CP;GS;gratuit;freeware', ' Pierre NOGUER', '0', '2006-08-01 09:20:37', NULL, NULL),
(504, 2, 'Logiciel &quot; mémory&quot; pour jouer au mémory ou apprendre une liste de mots au cycle 2', 'http://jlgrenar.free.fr/', 'Jeu de mémoire. Permet de jouer seul au mémory avec des images, des mots ou des nombres.\r\nPossibilité d''ajouter vos listes d''images ou de mots personnelles. Adaptation possible en fonction des mots et des répertoires de la classe.', 'logiciel;lecture;CP;CE1;cycle2;correction;ouvert;mémoire;CP;GS;CE1;CE2;gratuit;freeware', 'Jean-Luc GRENARD', '0', '2006-08-01 09:11:43', NULL, NULL),
(503, 2, 'Logiciel du jeu du pendu pour le cycle 2 et le cycle 3', ' http://jc.meier.free.fr', 'Logiciel &quot;ouvert&quot;. Les listes de mots sont saisies dans un fichier texte (format .txt) . L''extension .txt de chaque fichier doit être changée en .pdu. Logiciel ouvert gratuit pour le cycle 2 voire cycle 3  permettant de travailler l''orthographe sur des mots étudiés en classe.', 'lecture;orthographe;lexicale;logiciel;gratuit;freeware;cycle2;cycle 3', 'Jean-Claude MEIER', '0', '2006-08-01 08:52:41', NULL, NULL),
(502, 2, 'Logiciel &quot;CacheMot &quot; pour la  maternelle GS ou le CP', 'http://jlgrenar.free.fr/  	', ' Écrire un mot avec pour modèle sa silhouette. Les listes de mots sont saisies dans un fichier texte (format .txt). Chaque liste doit obligatoirement contenir un minimum de dix mots.\r\nLogiciel ouvert gratuit pour la MS,GS et le CP', 'lecture;écriture;mot;lettres,MS;GS;CP;logiciel;ouvert;gratuit;freeware', 'Jean-Luc GRENARD', '0', '2006-08-01 08:48:50', NULL, NULL),
(501, 2, 'Logiciel de lecture &quot;Paires&quot; pour le  CP ou la GS', 'http://dan.gros.free.fr/logiciels/Logiciels.html ', 'Le logiciel Paires permet de créer des associations, de mettre par deux des étiquettes. Un éditeur est fourni dans le logiciel et vous permet d''adapter le corpus de mot. L''écriture est plus grosse que dans le logiciel &quot;paires&quot;, et un menu permet de changer la graphie (cursive ou scripte) : on peut mettre 2 mots identiques, script à gauche et cursive à droite...Il y a des variations possibles pour réaliser les paires.Jusqu''à 9 paires simultanées, les élèves peuvent également faire les exercices eux-mêmes pour leurs camarades.', 'lecture;jeux;lettres;CP;GS;maternelle gratuit;freeware;ouvert', ' Daniel GROS', '0', '2006-08-01 08:42:17', NULL, NULL),
(499, 2, 'Logiciel Mémory Lettres pour apprendre le nom des lettres en maternelle ou au CP', 'http://itineduc.free.fr/telecharg.htm 	', 'Pour apprendre le nom des lettres. Plusieurs niveaux. Affichage des lettres en minuscules, majuscules, cursives. Les consignes, les lettres sont sonorisées.Le paramétrage s''effectue par l''appui de la touche F2.\r\nLogiciel gratuit PC pour la maternelle GS, MS ou le CP', 'lecture;lettre;code;logiciel;CP;GS;MS;CP;majuscule;minuscule;cursive', 'Daniel Bouziat', '0', '2006-08-01 08:31:36', NULL, NULL),
(498, 2, 'Logiciel mariages pour  &quot;marier&quot; la majuscule avec sa minuscule au cycle 1(MS) ou au cycle 2(GS,CP)', 'http://perso.wanadoo.fr/dbigeard/', 'Logiciel pour  &quot;marier&quot; la majuscule avec sa minuscule. Déplacement de la minuscule bouton gauche, placement de la minuscule bouton droit.Logiciel gratuit pour la maternelle;MS,GS et le CP', 'logiciel;lecture;code;alphabet;lettre;majuscule,minuscule;gratuit;freeware;cycle1;CP', 'Didier BIGEARD', '0', '2006-08-01 08:28:21', NULL, NULL),
(497, 2, 'Logiciel Clavier pour s''entraîner à chercher les touches du clavier au cycle 1 ou cycle 2', 'http://jlgrenar.free.fr/  	', 'Un jeu pour s''entraîner à chercher les touches du clavier, (temps règlable).9 exercices différents : Alphabet minuscules-majuscules-les deux, Mots jusqu''à cinq lettres-plus de cinq lettres, Nombres de 1 à 4 chiffres, adaptables au niveau de chacun.\r\nLogiciel ouvert gratuit PC pour le cycle 2 et cycle 1,CP,GS', 'lecture;lettre;alphabet;logiciel;gratuit;freeware', 'Jean-Luc GRENARD', '0', '2006-08-01 08:24:35', NULL, NULL),
(493, 2, 'Logiciel Baby Majhong pour des jeux de lecture au cycle 2', 'http://freeperso.free.fr/', 'Le but de ce jeu est de constituer des paires :\r\n Images / Lettre initiale du mot\r\n- Lettre majuscule / Lettre minuscule\r\n- Image / Image (mots ayant la même initiale)\r\nPour cycle 2 et notamment le CP\r\nLogiciel gratuit PC \r\n', 'lecture;jeux;lettres;CP;gratuit;freeware;mémoire', 'Laurent CHRETIEN', '0', '2006-08-01 08:07:29', NULL, NULL),
(495, 2, 'Logiciel Tip Tape pour reconnaître les lettres et les chiffres au Cycle 1', 'http://perso.wanadoo.fr/adajls/softedu.html 	', 'Des lettres et chiffres mobiles s''affichent à l''écran, il faut les effacer en appuyant sur les touches correspondantes du clavier.Logiciel gratuit PC pour la GS, cycle 1, cycle 2, la maternelle', 'logiciel;lecture;CP;GS;cycle2;cycle1;MS;maternelle', ' Anne SCOLÉ', '0', '2006-08-01 08:15:16', NULL, NULL),
(492, 2, 'Atellier de calligraphie d''Emmanuel SPAETH', 'http://www.atelier-calligraphie.com/calligraphie1.htm', ' Mise en place de 13 ateliers de calligraphie avec des techniques illustrées.Matériel et techniques.\r\nDes exemples de créations et des galeries.Banque d''alphabets &amp; ductus originaux téléchargeables \r\nDes liens et une bibliographie sur la calligraphie. Des ductus d''alphabets calligraphiés à télécharger. Possibilité d''écrire au calame en direct sur l''écran avec logiciel de calligraphie direct en ligne. Utiilisation d''un traducteur en hiéroglyphes, écrire au pinveau en direct.Découverte active des principes de typographies.Un forum en ligne sur la calligraphie. Ce site est une merveille ...\r\n', 'écriture;calligraphie;typographie;alphabets;lettre;arts;visuels;techniques;hiéroglyphes', 'Emmanuel SPAETH', '0', '2006-07-31 12:07:07', NULL, NULL),
(491, 2, 'Takatrouver : un annuaire de recherche pour enfants pour Internet', ' http://www.takatrouver.net', 'Takatrouver : Un annuaire de recherche pour enfants\r\n \r\n', 'moteur;annuaire;recherche;internet', 'association Takatrouver', '0', '2006-07-30 23:26:24', NULL, NULL),
(489, 2, 'Inviter un auteur en classe', 'http://www.crdp-nantes.fr/ressources/dossier/inviter-auteur/index.htm', 'Des conseils pour préparer (avant), accompagner (pendant) et prolonger (après)\r\nune rencontre avec un écrivain, poète, romancier en classe\r\n(correspondance, atelier d''écriture ...)', 'auteur;rencontre;livre;lecture', 'CRDP Pays de la Loire', '0', '2006-07-30 23:01:06', NULL, NULL),
(490, 2, 'Des activités autour d''une exposition', 'http://www.crdp-nantes.fr/ressources/document/poesie_saffiche/index.htm', 'Des pistes d''activités autour du montage d''exposition. Poésies\r\nProposer des activités mêlant poésie, analyse d''images, mise en forme du texte et jeux de mots à partir d''une exposition . Fiches d’activités pour les élèves de maternelle et école élémentaire .\r\n', 'exposition;poésies', 'CRDP Pays de la Loire  l''Inspection Académique de Loire Atlantique et la Maison de la Poésie.', '0', '2006-07-30 23:03:31', NULL, NULL),
(487, 2, 'Rechercher des informations sur Internet', 'http://www.crdp-nantes.fr/ressources/document/outils_internet/index.htm', 'Présentation   Comment s''organiser ?  Des informations sur les  annuaires, les moteurs, les méta-moteurs .Des conseils pratiques.Pour des besoins spécifiques ou pour élargir son champ d''investigation, il est intéressant de consulter certains répertoires organisés. Une sélection commentée de ressources accessibles pour Internet [BNF] \r\nTous les outils en une page&quot; de Jean-Pierre Lardy [ADBS] \r\n\r\n \r\n\r\n\r\n', 'moteur;recherche;internet;annuaires', 'CRDP Pays de la Loire', '0', '2006-07-30 22:39:50', NULL, NULL),
(484, 2, 'Méthodologie du reportage vidéo', 'http://www.crdp-nantes.fr/ressources/document/reportage_video.pdf', 'Guide méthodologique pour intégrer la vidéo en classe au cycle 2 ou cycle 3.\r\nComment préparer et filmer une interview.', 'vidéo;démarche;guide;film', 'CRDP de Loire Atlantique', '0', '2006-07-30 22:30:59', NULL, NULL),
(485, 2, 'Sélection documentaire sur le thème du cinéma', 'http://www.crdp-nantes.fr/ressources/selection/cinema_techniques.pdf', 'Sélection documentaire sur le thème du cinéma', 'dcuments;bibliographie;cinéma', 'CRDP Pays de la Loire', '0', '2006-07-30 22:33:18', NULL, NULL),
(486, 2, 'Etudier l''antiquité à travers le roman historique', 'http://www.crdp-nantes.fr/ressources/selection/antiquite_roman_historique.pdf', 'Choisir un roman historique au cycle 3 pour traiter le thème de l''antiquité.', 'antiquité;histoire;roman', 'CRDP Pays de la Loire', '0', '2006-07-30 22:34:28', NULL, NULL),
(482, 2, 'imagiers et abécédaires', 'http://www.crdp-nantes.fr/ressources/dossier/ABCDAIR/Imagiers_reperes.htm', 'Pour aborder la création d’abécédaires ou d’imagiers avec les élèves au cycle 1.\r\n\r\n', 'imagiers;abécédaires', 'CRDP Pays de la Loire', '0', '2006-07-30 22:14:40', NULL, NULL),
(483, 2, 'Photographie et droits de l''image', 'http://www.educnet.education.fr/juri/photo.htm', 'Site juridique d''Educnet', 'photographie ;droit;image', 'Ministère EN', '0', '2006-07-30 22:18:03', NULL, NULL),
(469, 2, 'Éducation aux risques - Les usages de l''Internet au sein de l''établissement scolaire', 'http://www.crdp-nantes.fr/ressources/document/education_risques/index.htm', 'Des repères et élements pratiques (textes officiels, dispositifs de protection et filtrage, d''éducation et de formation).\r\nDes liens spécifiques vers les structures et ressources de l''Académie de Nantes.\r\nDes références au vocabulaire de l''informatique et de l''internet en usage (glossaire)', 'juridique;protection;filtrage;textes;officiels', 'CRDP de Nantes', '0', '2006-07-30 20:35:21', NULL, NULL),
(467, 2, 'Association &quot;Lire et faire lire&quot;', 'http://www.lireetfairelire.org/LFL/', 'L’association Lire et faire lire créée fin 1999 a pour objet statutaire &quot;d’encourager et de développer toutes initiatives citoyennes de nature à promouvoir et développer le goût de la lecture&quot;.\r\n', 'lire;lecture;association', 'Association &quot;Lire et faire lire&quot;', '0', '2006-07-30 18:45:49', NULL, NULL),
(468, 2, 'Le Chinois dans tous ses états', 'http://www.crdp-nantes.fr/service/vente/chinois/index.htm', 'Méthode pour apprendre le Chinois.Cette méthode originale d’apprentissage du chinois s’inscrit dans les différents programmes d’enseignement des langues vivantes, école, collège, lycée et enseignement supérieur.\r\nElle convient également pour l’apprentissage hors du milieu éducatif.\r\nTous les domaines de compétence sont couverts : comprendre et parler le putonghua, savoir lire et écrire.\r\n\r\n', 'LV;lanque;chinois;méthode', 'CRDP de Nantes', '0', '2006-07-30 20:13:33', NULL, NULL),
(465, 2, 'Livralire un site  pour la connaissance pratique sur la littérature-Jeunesse', 'http://www.livralire.org/', 'Un site pour la connaissance pratique sur la littérature-Jeunesse. Association &quot;LivraLire&quot;', 'littérature', 'Association &quot;LivraLire&quot;', '0', '2006-07-30 18:28:47', NULL, NULL),
(466, 2, 'Site &quot;leplaisir.net&quot; pour les livres enfance', 'http://www.leplaisir.net/', 'Site de &quot; référence &quot; animé par Jean-Paul Gourevitch, spécialiste de l''histoire et du patrimoine du livre d''enfance.\r\n Carnet d''adresses des gens du monde de la littérature enfantine : auteurs, illustrateurs, éditeurs, spécialistes et formateurs, organisateurs de salons, de prix et d''expositions. Panorama historique de la production littéraire pour la jeunesse : répertoire des titres de presse de 1850 à nos jours et textes de référence de la L-J.\r\n Bibliographies professionnelles : ouvrages et numéros spéciaux de revues sur auteurs contemporains ou classiques, sur des thématiques. Une banque de données, de références, et de liens, concernant le thème de la littérature Jeunesse\r\n   \r\n', 'Gourevitch;littérature; auteurs; illustrateurs; éditeurs;bibliographie;livres', 'Gourevitch', '0', '2006-07-30 18:34:18', NULL, NULL),
(464, 2, 'La maison des illustrateurs', 'http://www.lamaisondesillustrateurs.com/', 'La Maison des illustrateurs est un lieu de ressources, d''information et de promotion de l''illustration pour la jeunesse. Les illustrateurs sont reçus et accompagnés dans leurs démarches, soit administratives, soit artistiques auprès des éditeurs et des organisateurs d''événements culturels.Annuaire des illustrateurs. Possibilité de trouver des références et des adresses pour contacter les illustrateurs.\r\n', 'livre;illustrateurs', 'Association &quot;maison des illustrateurs&quot;', '0', '2006-07-30 18:23:56', NULL, NULL),
(463, 2, 'Le site &quot;Ricochet&quot; pour la littérature Jeunesse', 'http://www.ricochet-jeunes.org/', 'Le site très complet du Centre international d''études en littérature de jeunesse : à la fois portail et ressource, il réunit des actualités, des bibliographies, des articles sur la littérature de jeunesse, les auteurs, les illustrateurs, les éditeurs...\r\n', 'littérature;jeunesse; auteurs; les illustrateurs;éditeurs', 'Ricochet', '0', '2006-07-30 18:19:22', NULL, NULL),
(461, 2, 'Le site L@BD', 'http://www.labd.cndp.fr/', 'Le site L@BD est une base de données sur la bande dessinée (albums, ouvrages documentaires, revues pédagogiques, magazines spécialisés, fanzines, sites, vidéos... ) et sur l''actualité des parutions. Il offre des possibilités de recherche multicritères.\r\n\r\n', 'base;liste;', 'CNDP CRDP de Poitiers', '0', '2006-07-30 18:10:01', NULL, NULL);
INSERT INTO `module_ressource_ressources` (`id`, `id_annu`, `nom`, `url`, `description`, `mots`, `auteur`, `submit_user`, `submit_date`, `valid_user`, `valid_date`) VALUES
(462, 2, 'Site Attire-lire CDDP de la Gironde', 'http://crdp.ac-bordeaux.fr/cddp33/attirelire/somatirelire.asp', 'Le CDDP de Gironde propose des livrets d''accompagnement pédagogique pour l''exploitation en classe de valises-lecture.\r\n   \r\nBébés chouettes -  M. Waddel, P. Benson - Kaléidoscope - PS MS  \r\nEt le petit dit... - J. Maubille - L''école des loisirs, Pastel\r\n - PS \r\n \r\nLe petit loir qui voulait rencontrer Saint Nicolas - E. Schmid - Nord-Sud\r\n - PS MS \r\n \r\nLe plus bel oeuf du monde - H. Heine - Gallimard\r\n - PS MS \r\n \r\nLoup y es-tu ? -  S. Auzary-Luton - Kaléidoscope\r\n - MS GS \r\n \r\nRentrons à la maison petit ours - M. Waddel - L''école  des loisirs, Pastel\r\n - PS MS  \r\n \r\nRouge Matou - E. Battut - Milan\r\n - MS \r\n \r\n  \r\n    \r\nPour le cycle II      \r\nNiveau \r\n \r\n    \r\nBasile Boude - W. Steig - Kaléidoscope\r\n - CP CE \r\n \r\nBon appétit Monsieur Lapin - C. Boujon - L''école des loisirs,  Lutin poche\r\n - GS CP \r\nC''est moi le plus fort - M. Ramos - L''école des loisirs, Pastel\r\n - CP \r\n \r\nCric-Crac - Rascal &amp; Girel - L''école des loisirs\r\n - CP CE1 \r\n \r\nElmer - D. McKee - L''école des loisirs, Lutin poche\r\n - GS CP \r\n \r\nIl y a un crocodile sous mon lit - I. &amp; D. Schubert - Grasset \r\n - CP CE1 \r\n \r\nL’arbre aux corbeaux - Stibane - L''école des loisirs, Pastel \r\n -GS CP CE1 \r\n \r\nL''arbre généreux - S. Silverstein - L''école des loisirs\r\n -GS CP CE1 \r\n \r\nL''énorme crocodile - R. Dahl – Gallimard, Folio benjamin \r\n - CE1 CE2\r\n \r\nLa chanson d’Olive - R. Lewis - L''école des loisirs\r\n - CP CE1 \r\n \r\nLa chasse à l''ours  - M. Rosen - Kaléidoscope\r\n - GS CP \r\n \r\nLe buveur d''encre - E. Sanvoisin - M. Satje -  \r\n - CE1 CE2\r\n \r\nLe chat orange - A. Mets - L''école des loisirs\r\n - GS CP \r\n \r\nLe Géant de Zéralda - T. Ungerer - L''école des loisirs\r\n - GS CP \r\n \r\nLe loup est revenu - G. de Pennart -  Kaléidoscope\r\n - CP \r\n \r\nLe petit paradis - A. Mets - L''école des loisirs\r\n - CP CE1 \r\n \r\nLes trois brigands - T. Ungerer - L''école des loisirs\r\n - GS CP \r\n \r\nMais je suis un ours - F. Thaslin - L''école des loisirs \r\n - CE1 CE2\r\n \r\nPélagie la sorcière - V. Thomas - Milan \r\n - GS CP \r\n \r\nPetit Lapin Rouge - Rascal - L''école des loisirs, Pastel. \r\n - GS CP \r\n \r\nPorculus - A. Lobel - L''école des loisirs, Lutin poche \r\n - CP CE1 \r\n \r\nPoèmes de la lune... - Jean Joubert - L''école des loisirs  - Cycle 2 \r\nPuni Cagibi - A. Serres - L''école des loisirs, Lutin poche. \r\n - CP \r\n \r\nRenardeau - I. Korschunow - L''école des loisirs, Mouche de poche\r\n - CP CE1 \r\n \r\nValise thématique &quot;cochons&quot; \r\n - CP \r\n \r\nViens jouer avec moi, Petite Souris! - R. Kraus - L''école des loisirs\r\n - GS CP\r\n \r\n \r\n  \r\n \r\n Pour le cycle III   Niveau \r\n    \r\nDans les cheminées de Paris - M.C.Helgerson- Flammarion, Castor poche  - CM2 \r\n \r\nFabrice et les passeurs de l''ombre - J. Cazalbou - Flammarion, Castor poche  - CM \r\n \r\nFantastique Maître Renard - R. Dahl – Gallimard\r\n - CE2 CM1 \r\n \r\nJe n''aurai plus jamais de chien - J. Resh Thomas - L''école des loisirs\r\n - CE2 CM1 \r\n \r\nL''arbre généreux - S. Silverstein - L''école des loisirs\r\n - Cycle 3\r\n \r\nL''inondation - P. Oldfield - Flammarion\r\n - CE2 \r\n \r\nL''oeil du loup - D. Pennac - Pocket Junior\r\n - CM2 \r\n \r\nLa bête du Gévaudan - J. Féron Romano - Hachette, Le livre de poche jeunesse \r\n - CM 6° \r\n \r\nLa nuit du Boufadou - G. Pussey - Ecole des loisirs\r\n - CE2 \r\n \r\nLa petite marchande d''allumettes - Andersen - Nathan  - Cycle 3 \r\nLa vallée des mammouths - M. Peyramaure - Pocket Junior\r\n - CM2 6° 5° \r\nLa princesse de neige  - S Giral, P Nottet - L''école des loisirs - CM2 6° \r\nLe cabanon de l''oncle Jo - B. Smadja - L''école des loisirs - CM \r\nLe guerrier et le sage - D. Winiesky - L''école des loisirs\r\n - Cycle 3\r\n \r\nLe hollandais sans peine -  M.-A. Murail - L''école des loisirs\r\n - CE2 \r\n \r\nLe jobard - M. Piquemal - Milan \r\n - CM\r\n \r\nLe roi de la forêt des brumes - M. Morpurgo - Gallimard \r\n - CM 6° \r\n \r\nLes doigts rouges -  M. Villard - Pocket Junior, Mini souris noire \r\n - CE2\r\n \r\nLes souris de Sansonnet - D. King Smith - Gallimard, Lecture junior\r\n - CE2 \r\n \r\nMomo, petit prince des bleuets - Y. Hassan - Pocket Junior\r\n - CE2  CM \r\n \r\nMon bel oranger - J. Mauro de Vasconcelos - Hachette, Histoires de vie \r\n - CM2 6° 5° \r\n \r\nMusée Blues - S. Morgenstern, J. Claverie - Gallimard, Folio cadet \r\n - CM \r\n \r\nVerte - M. Desplechin - L''école des loisirs\r\n - Cycle 3\r\n \r\nUne Histoire à 4 voix - A. Browne - L''école des loisirs - Cycle 3 \r\n', '', '', '0', '2006-07-30 18:15:06', NULL, NULL),
(458, 2, 'Espace littérature sur le site Arts et Culture', 'http://www.presence-litterature.cndp.fr/', 'L''espace littérature du site Arts et Culture propose des informations pratiques pour mettre en place des projets pédagogiques en liaison avec la littérature de jeunesse (textes officiels, carnets d''adresses, listes de livres conseillés par niveau...)Pôles de ressources\r\n\r\n &quot;Ecritures contemporaines francophones et théâtre&quot; - Limoges\r\n\r\n &quot;Littérature à dominante Littérature de jeunesse&quot; - Créteil\r\n\r\n &quot;Littérature&quot; - Lyon\r\n\r\n &quot;Littérature-poésie&quot; - Clermont Ferrand\r\n\r\n &quot;Littérature de jeunesse&quot; - Grenoble\r\n', 'littérature;jeunesse', 'CNDP', '0', '2006-07-30 17:43:21', NULL, NULL),
(460, 2, 'Observatoire national de lecture', 'http://onl.inrp.fr/ONL/garde?accueil.htm', 'L''espace Livres de jeunesse et apprentissages sélectionne des titres pour chacun des trois cycles à partir de critères explicites définissant les apprentissages visés. Il donne des exemples, des explicitations et une mise en œuvre de la démarche affichée. Un espace est dédié pour les méthodes de lecture au CP.', 'lecture;littérature;méthodes', 'ONL Ministère de l''Éducation nationale,de l''Enseignement supérieur et de la Recherche', '0', '2006-07-30 18:03:15', NULL, NULL),
(457, 2, 'La présence de la littérature à l''école', 'http://www.presence-litterature.cndp.fr/', 'informations générales et nationales sur la littérature\r\nCet espace se propose d''être une source d''informations sur l''actualité de la littérature à l''école avec : \r\n- des dossiers pédagogiques\r\n- des articles de réflexion par des grands spécialistes\r\n- des pistes pédagogiques réalisées par des enseignants, et des documents complémentaires (photos, vidéos).\r\nUne rubrique permet de se renseigner sur l''opération Année du livre à l''école.', ' littérature;informations;s''informer;vidéo;livre', 'CNDP', '0', '2006-07-30 17:41:51', NULL, NULL),
(454, 2, 'Site &quot;Bien lire&quot; à l''école', 'http://www.bienlire.education.fr/', 'Le site d''accompagnement du plan de prévention de l''illettrisme propose aux adultes intervenant auprès des enfants et des jeunes des outils, des exemples d’actions menées sur le terrain, des documents d’analyse et des communications de chercheurs', 'lire;recherche;outils;lecture;chercheurs', 'Education nationale  Site institutionnel', '0', '2006-07-30 17:24:45', NULL, NULL),
(455, 2, 'SIte institutionnel EDUSCOL de la direction des écoles et oeuvres de littérature', 'http://eduscol.education.fr/D0102/biblio.htm', 'Le site pédagogique du Ministère de l''Éducation nationale présente les listes de références des œuvres de littérature pour les trois cycles de l''école primaire.\r\n', 'littérature;oeuvres;liste;références', 'Ministère EN', '0', '2006-07-30 17:27:31', NULL, NULL),
(452, 2, 'Un projet d''écriture &quot;Fiction ou journal&quot; à partir de sciences', 'http://www.educasciences.org/sciences_en_ligne/rubrique.php3?id_rubrique=144', 'Educasciences vous propose un site pour un projet d''écriture avec un arrière plan scientifique. Une occasion de réinvestir les notions vues en sciences et de changer de registre', 'projets;écriture;sciences', 'educasciences', '0', '2006-07-30 16:47:52', NULL, NULL),
(453, 2, 'Site &quot;des sciences en ligne&quot; pour l''école', 'http://www.educasciences.org/sciences_en_ligne/rubrique.php3?id_rubrique=136', 'Le site “Sciences en ligne” est dédié aux enseignants et leurs élèves. Ce projet est proposé par l’ASSOCIATION Educ@Sciences .\r\n\r\n', 'sciences;projets;Educ@Sciences', 'Association Educ@Sciences Claudette Balpe et Stéphane Respaud', '0', '2006-07-30 17:15:34', NULL, NULL),
(450, 2, 'Aides à la programmation de cycle en sciences', 'http://pedagogie.ac-toulouse.fr/ariege-education/sciences09/php/rubrique.php3?id_rubrique=67', 'Une rubrique du site &quot;enseigner les sciences&quot; en Ariège', 'sciences;programmations', 'site &quot;enseigner les sciences&quot; en Ariège', '0', '2006-07-30 16:31:06', NULL, NULL),
(451, 2, 'Des progressions complètes  à télécharger en sciences', 'http://www.educasciences.org/sciences_en_ligne/article.php3?id_article=185', 'Le site &quot;sciences en ligne&quot; vous propose une rubrique dédiée aux progressions en sciences.\r\nLes progressions (ensemble de situations d’investigation + les conseils pédagogiques pour bien les mener) sont désormais disponibles au téléchargement et, pour certaines concernant le Cycle 1, sous la forme d’un fichier pédagogique et d’une mallette de matériel expérimental.Chaque fichier à télécharger :   est au format PDF, \r\n  comporte les situations de départ sur le thème choisi,   des conseils relatifs à chaque situation de la progression et éventuellement sur le matériel   des extraits de travaux d’élèves (cahiers d’expériences) pour chaque situation.\r\nLle téléchargement des progressions est payant (moins de 2 euros par progression si vous êtes en France métropolitaine). Pour télécharger les progressions complètes, cliquez sur les liens :\r\n  Air Cycle 2 \r\n  Air Cycle 3 \r\n  Eau et matière Cycle 2 \r\n  Eau et matière Cycle 3 \r\n  Ombres et lumières Grande-Section (cycle 2) \r\n  Lumière Cycle 1 \r\n  Les aimants Cycle 1\r\n\r\n\r\n\r\n', 'progressions;sciences;matériel;thèmes;payant;', 'sciences en ligne', '0', '2006-07-30 16:36:23', NULL, NULL),
(449, 2, 'Enseigner les sciences dans l''Ariège- Exemples de cahier d''expériences et dossier thématiques', 'http://pedagogie.ac-toulouse.fr/ariege-education/sciences09/php/article.php3?id_article=14', 'Exemples de cahiers d''expérience sur le site &quot;enseigner les sciences dans l''Ariège&quot;', 'sciences;cahier;expériences;dossier;thèmes', 'réseau départemenal de la main à la pâte', '0', '2006-07-30 16:26:25', NULL, NULL),
(447, 2, 'Projets technologiques pour le cycle 1, cycle 2, cycle 3', 'http://www.montpellier.iufm.fr/technoprimaire/index5.htm', 'BASCULE DE MÉNAGE \r\nPermet de mesurer rapidement  tous les ingrédients usuels\r\n cycle 3\r\n   \r\n MATERNELLE\r\n \r\nPROJETS CYCLE 1\r\n\r\npar thèmes\r\n \r\n \r\nÉOLIENNE 4 VERSIONS\r\n\r\ncycle 1 -  2  - 3\r\n    \r\n Nouveau\r\nLAMPE SCULPTEE\r\n\r\n \r\n\r\nCycle  2 - 3 \r\n  \r\nLAMPE MAGIQUE\r\n\r\n3 versions - Cycle 2 - 3\r\n  TRIMARAN\r\n\r\n \r\n\r\nCycle  2 - 3 \r\n \r\nNouveau\r\nCHADOUF\r\n \r\nCycle   3\r\n \r\n LIVRE ANIMÉ\r\n\r\nCycle  2 - 3\r\n \r\n \r\nNouveau\r\n\r\nLAMPE CONIQUE\r\n\r\n \r\n\r\nCycle 2 - 3\r\n \r\n LIVRE SENSORIEL\r\nBOITE SENSORIELLE\r\n\r\nCycle 1 - 2\r\n \r\n \r\nMAQUETTE\r\n\r\ncycle   3\r\n \r\n VOILIER\r\n\r\n \r\n\r\nCycle  2 - 3\r\n \r\n \r\nBOITE DU DIABLE\r\n\r\nSystème bielle-manivelle\r\n\r\nCycle   3\r\n \r\n JEU QUESTIONS-REPONSES\r\n\r\n3 versions - cycle  2 - 3\r\n \r\n \r\nVTT \r\n\r\nTP Transmissions de mouvements\r\n\r\nCycle   3\r\n \r\n FUSEE A EAU \r\n\r\n \r\n\r\nCycle   3\r\n \r\n \r\n PORTE-CLÉS LUMINEUX \r\n\r\nPermet d''éclairer une serrure\r\net de transporter des clés \r\n\r\nCycle   3\r\n \r\n  HORLOGE A L''EAU\r\n\r\nCycle  2 - 3\r\n \r\n \r\nJEU D''ADRESSE \r\n\r\n \r\n\r\nCycle  2 - 3\r\n \r\n BOITE\r\nA FLEURS\r\n\r\n \r\n\r\nCycle   2 - 3\r\n \r\n \r\nTANGRAM - CD\r\n\r\n \r\n\r\nCycle   3\r\n \r\n   CALENDRIER\r\n\r\n \r\n\r\nCycle  2 - 3\r\n \r\n \r\nMOBILES\r\n2 versions\r\n\r\nTravail sur les leviers - Cycle  3\r\n \r\n PORTE-PHOTOS \r\n\r\n7 versions\r\n\r\nCycles 1 -  2 - 3\r\n  \r\n    TOUPIE\r\n\r\n \r\n\r\nCycle  2\r\n \r\n \r\n', 'technologie;sciences;projets', 'IUFM de Montpellier', '0', '2006-07-30 16:09:33', NULL, NULL),
(446, 2, 'Programmations en sciences', 'http://www.crdp-montpellier.fr/cd66/map66/pages/programmation/sommaire.htm', 'Base de données dt CRDP de Montpellier permettant de traiter les points suuvants du programme. La matière   La matière et les objets-Etats et changements d''état de l''eau Mélanges et solutions. L''air et son caractère pesant Plans horizontal et vertical - Université et diversité du monde vivant -Stades et condition de développement Divers modes de reproduction des êtres vivants-Les mouvements corporels Les grandes étapes de l''évolution   \r\nEducation à l''environnement-Approche écologique, rôle et place des êtres vivants-L''eau-Les déchets Le rôle de l''Homme -Energie Sources d''énergie utilisables, consommation et économie - Ciel et Terre- La lumière et les ombres Les points cardinaux et la boussole Mouvement apparent du soleil Rotation de la Terre sur elle-même et ses conséquences Le système solaire et l''Univers Mesure des durées et unités  -Le corps humain et l''éducation à la santé  Les mouvements corporels La reproduction des humains Première approche de la fonction de nutrition Hygiène Cinq sens -Monde construit par l''Homme \r\n', 'sciences;programmation;matière;environnement;vivant;énergie;ciel;Terre;corps,santé;technologie', 'CRDP de Montpellier', '0', '2006-07-30 16:02:12', NULL, NULL),
(443, 2, 'Contes irlandais en images animés', 'http://www.contes-irlandais.com', 'Association images et textes sonores. Chaque page est illustrée par une animation flash et accompagnée d''un texte écrit. &quot;Les  iconographies sont très réussies et donnent à voir de beaux personnages de l''imagerie celte&quot; (Fenêtres sur cours)&quot;. &quot;Contes Irlandais&quot; a obtenu le Net d''Or régional 2003 des Pays de la Loire (catégorie&quot;site insolite&quot;)\r\n ', 'contes;animation;logiciel;littérature;gratuit;histoires', 'James Fitz Patrick', '0', '2006-07-30 15:16:12', NULL, NULL),
(444, 2, 'Le site  Clicksouris ... des histoires interactives et des ateliers d''écriture', 'http://www.clicksouris.com', 'Des histoires interactives et des jeux dont tu es le héros, des choix, des énigmes, des ateliers d''écriture, des fins à inventer...Un bestiaire poétique pour lire, écrire et jouer avec les plus belles poésies sur les animaux.\r\n Le Bibliozoo : des livres choisis dans le meilleur de la littérature jeunesse. Tu peux organiser  un atelier &quot;Clicksouris&quot;. \r\nClicksouris c''est aussi découvrir la lecture interactive et l''écriture hypertextuelle en imaginant une fiction interactive \r\npubliée sur un site Internet d''histoires pour enfants.\r\n', 'histoires;récits;llittérature;interactive;bestiaire;écrire;lire;atelier;interactif', 'clicksouris', '0', '2006-07-30 15:23:53', NULL, NULL),
(442, 2, 'Histoires interactives et contes interactifs en flash', 'http://continette.free.fr', 'Contes interactifs pour enfants, avec jeux, sons...  \r\n', 'histoires;scénarios;littérature;langage;oral;récit;structure;logiciel', 'continette.', '0', '2006-07-30 15:09:08', NULL, NULL),
(441, 2, 'Site de Mamiplume pour échanger des histoires', 'http://mamiplume.free.fr/jeu%20de%20cadres.htm', 'Il s''agit d''une bourse amicale d''échange d''histoires illustrées pour enfants. Tu peux y accéder gratuitement à tous les livres et les IMPRIMER. Chacun peut faire héberger ses histoires illustrées à condition de respecter une charte.', 'histoires;récits;écriture;littérature;B2i;lecture', 'association Mamiplume et ses auteurs', '0', '2006-07-30 14:51:16', NULL, NULL),
(440, 2, 'logiciel avec des exercices interactifs en orthographe ORL  en ligne -Orthographe lexicale', 'http://pages.infinit.net/jaser2/', 'Des execices directs en ligne pour maîtriser l''orthographe d''usage de mots simples , en écrivant correctement les noms des objets ou des animaux représentés par un dessin, tu feras monter le mercure du thermomètre. Correction et score de réussite via un thermomètre &quot;qui monte&quot; dès que l''on a réussi.', 'ORL;orthographe;exercices;corrigé;correction;usage;lexical', 'realsjacques', '0', '2006-07-30 14:29:39', NULL, NULL),
(439, 2, 'logiciel avec des exercices interactifs en ligne en ORL', 'http://pages.infinit.net/jaser2/', 'Exercices d''orthographe en ligne, permettant l''entraînement autour des notions suivantes:\r\naccord sujet verbe, accord adjectif nom\r\nprésent de l''indicatif des verbes être et avoir\r\nprendre au présent de l''indicatif\r\nprésent de l''indicatif en « e, es ou ent »\r\nprésent de l''indicatif en « is, is ou it »\r\n présent en « es » à l''imparfait en « ais »\r\nprésent de l''indicatif des verbes être et avoir\r\nprendre au présent de l''indicatif\r\nprésent de l''indicatif en « e, es ou ent »\r\nprésent de l''indicatif en « is, is ou it »\r\nprésent en « es » à l''imparfait en « ais »\r\nprésent en « e » (3e pers. du sing.) à l''imparfait en « ait »\r\nprésent en « ons » à l''imparfait en « ions »\r\nprésent en « ez » à l''imparfait en « iez »\r\nprésent des verbes en venir et tenir (singulier)\r\nfutur en irai et ierai\r\nles sons é et è\r\nverbes en eler et eter \r\nprésent des verbes venir et tenir\r\nfutur en irai et ierai\r\nles sons é et è\r\nverbes en eler et eter \r\nparticipe passé en é ou infinitif en er Imparfait : i ou ii le conditionnel présent impératif présent à la forme négative', 'orthographe;grammaire;ORL;accords;conjugaison;verbes;logiciel;gratuit', 'realsjacques', '0', '2006-07-30 14:02:39', NULL, NULL),
(435, 2, 'Logiciel libre the GIMP pour les arts visuels', 'http://www.logiciels-libres-tice.org/spip.php?article128&var_recherche=gimp', 'Logiciel libre que l''on compare souvent à photoshop pour les nombreuses possibilités qu''il offre, il est un peu difficile à prendre en main et les élèves (surtout en collège) sont vite perdus au milieu des nombreuses fenêtres ouvertes. Néanmoins un fois que l''on a compris le principe et que l''on sait que tous les menus restent à disposition par un simple clic droit, les possibilités sont fort nombreuses. Il existe fort heureusement quelques tutoriels. Voir sur l''espace premier degré du pôle de compétences des logiciels libres.\r\n', 'arts visuels;logiciel;libre;gratuit', 'Spencer Kimball, Peter Mattis, et l’équipe de développement de The Gimp', '0', '2006-07-29 22:19:19', NULL, NULL),
(434, 2, 'Artweaver, un logiciel gratuit pour les arts', 'http://www.artweaver.de/download-de/', 'Entièrement gratuit, ce logiciel ressemble à Gimp en beaucoup plus simple. Une jolie palette d''outils et...la possibilité de travailler les calques ! Il a l''immense avantage par rapport à photofiltre de supporter les calques et d''avoir une palette d''outils et de brosses bien plus riche. En langue anglaise à l''origine, il a été en partie traduit en français (fichier disponible sur la page de téléchargement d''artweaver. http://www.artweaver.de/index.php?en_version\r\n\r\n\r\n', 'arts;visuels;freeware;gratuit;', 'Auteur de Artweare', '0', '2006-07-29 22:13:28', NULL, NULL),
(433, 2, 'Picasa  un logiciel pour classer les images sur l''ordinateur', 'http://www.zdnet.fr/telecharger/windows/fiche/0,39021313,11010531s,00.htm', 'Cet outil est très simple, ultrarapide pour aller retrouver les images disséminées dans votre ordinateur. Picasa crée des albums et vos donne la possibilté de les exporter sous forme de pages web. Picasa est entièrement gratuit.\r\nCe logiciel innove en en matière d’organisation de photos. Il ne raisonne pas en termes de dossiers et de fichiers mais en ceux d’espace et de temps. Il détecte automatiquement les appareils photos numériques connectés via un port USB et trie les photos importées en respectant l’ordre chronologique. Ceci facilite leur repérage et leur affichage et évite de devoir perdre du temps à les rechercher. Déplacer et renommer les photos, créer des albums virtuels sont autant d’opérations possibles sans avoir à farfouiller dans les répertoires\r\n http://www.zdnet.fr/telecharger/windows/fiche/0,39021313,11010531s,00.htm \r\n      ', 'images;classement;utilitaire', 'Picasa Google', '0', '2006-07-29 22:09:28', NULL, NULL),
(432, 2, 'Photofiltre, logiciel gratuit, simple et puissant pour la création et la retouche d''images.', 'http://www.photofiltre.com/', ' Logiciel gratuit, simple et puissant pour la création et la retouche d''images. Très léger, rapide, intuitif, PhotoFiltre propose une approche intéressante en fin de Cycke 3. Des informations, liens, tutoriels sont en ligne à l''adresse du site.PhotoFiltre Studio est disponible en version shareware.\r\nMis à jour régulièrement et gratuit , son principal défaut, en dehors de n''être disponible que pour windows, est de ne pas pouvoir utiliser les calques, mais cette lacune est comblée dans sa version payante : Photostudio', 'photos,retouche;image;arts;visuels;tutoriel;shareware;gratuit', 'Auteur de photofiltre', '0', '2006-07-29 21:58:43', NULL, NULL),
(426, 2, 'AniPaint, un logiciel pour dessiner et faire du montage mutimédia', 'http://www.anipaint.com/ap3/main.php?aptheme=2&amp;language=fr&amp;column=1', 'Logiciel simple et complet permettant de dessiner et de faire du montage multimédia. Logiciel payant', 'dessiner;dessin;logiciel;multimédia', 'AniPaint', '0', '2006-07-29 15:36:28', NULL, NULL),
(428, 2, 'FreeMind un logiciel de conception de cartes heuristiques pour &quot;apprendre à apprendre&quot;', 'http://www.logiciels-libres-tice.org/spip.php?page=recherche&recherche=freemind', 'FreeMind est un logiciel de conception de cartes heuristiques, appelées aussi &quot;remue-méninge&quot;. FreeMind est un outil de mise en forme des idées en «réseau de concepts». La navigation est particulièrement pratique car on peut faire déployer chaque concept avec toutes ses ramifications en un seul clic ou suivre les liens suggérés directement. On peut même s’en servir comme base de données, outil de planification, de suivi ou de gestion de projet, outil de scénarisation, d’agenda.\r\n', 'compétences;transversal;organisation;carte heuristique;outil;scénarisation;méthodologie:méthodes', 'Joerg Mueller', '0', '2006-07-29 16:03:16', NULL, NULL),
(602, 2, 'Frise et dossiers pour comprendre  l''histoire', 'http://www.herodote.net/frises/frises_theme/chrono.php?periode=9', 'Une frise qui défile. Tu voyages au fil du temps. Tu t''arrêtes sur un dossier et un commentaire oral qui te convient.\r\nTu apprendras plein de choses pour chaque période de l''histoire. A utiliser en fin de cycle 3 éventuellement à adapter en adaptant ou en choisissant les documents pour des élèves de cycle 3.', 'histoire;frise;dossier', 'Amis d''Hérodote', '0', '2006-08-01 22:49:02', NULL, NULL),
(429, 2, '&quot;Flash Slide Show Maker&quot;, un logiciel facile pour créer des diaporamas en flash', 'http://flash.dvd-photo-slideshow.com/', 'Flash Slide Show Maker permet la réalisation facile de diaporamas en flash. Les élèves pourront facilement créer leurs propres diaporamas, qui s''inséreront facilement dans un projet plus vaste (site internet, cd-rom...).Créez, à partir d''images, un diaporama en flash, en quelques clics de souris, avec insertion d''effets de transition, réglage (global) des durées (affichage de l''image et de la transition), insertion de musique (mp3 uniquement)... le tout en quelques clics ! Prise en main très facile.', 'logiciel;propriétaire;gratuit;diaporama', 'ANVSOFT', '0', '2006-07-29 20:49:34', NULL, NULL),
(430, 2, '&quot;Shrink pic&quot; un logiciel utilitaire de compression automatisée des photos', 'http://www.onthegosoft.com/fr/shrink_pic.htm', 'Shrink pic est utilitaire de compression automatisée des photos, lié à l''envoi de mails (via outlock ou thunderbird).\r\nshrink pic, qui redimensionne vos photos avant tout envoi sur le web.\r\nShrink Pic permet l’envoi de dizaine de photos en pièce jointe – rapidement et sans effort !Il vous suffit d’installer Shrink Pic sur votre ordinateur. Il détecte automatiquement l’envoi de grandes photos et les compresse automatiquement en arrière-plan.Il n’y a aucun réglage, ni instructions, rien, nadaIl vous suffit d’envoyer vos photos et Shrink Pic les compresse. ', 'photos;logiciel;gratuit;propriétaire;utilitaire', 'schrink', '0', '2006-07-29 21:14:36', NULL, NULL),
(424, 2, 'Exercices en ligne d''orthographe  avec &quot;le chat bleu&quot;', 'http://www.chatbleu.com/', '    Exercices interactifs sur les homophones.\r\n     ce ou se  	 	\r\n	c''est ou s''est 	\r\n	et ou est 	\r\n	et ou est ou es 	\r\n	à ou a 	\r\n	à ou a ou as 	\r\n	ou ou où 		\r\n	son ou sont 	\r\n	tout ou tous\r\nRemplacer les points d''interrogation avec l''homonyme qui convient.', 'grammmaire;orthographe;ORL;observation réfléchie de la langue', 'Auteur du chat bleu', '0', '2006-07-28 20:04:14', NULL, NULL),
(423, 2, 'Exercices en ligne de grammaire avec &quot;le chat bleu&quot;', 'http://www.chatbleu.com/', 'Site interactif pour les élèves. Exercices gradués par niveaux pour la grammaire.\r\nReconstituer la phrase. Reconnaître le type de phrases.', 'phrase; déclarative;interrogative;exclamative;impérative;grammaire', 'Auteur du chat bleu', '0', '2006-07-28 19:56:57', NULL, NULL),
(422, 2, 'Site &quot;Ortholud&quot;  pour des exercices de grammaire en ligne', 'http://www.ortholud.com/grammaire.php', 'Exercices en ligne en grammaire couvant l''ensemble des notions du programme.\r\nRetrouver l''ordre des phrases. Phrases pour CP - CE1:\r\nRetrouver le verbe dans ses phrases\r\nRelier les mots pour construire un phrase (exercice pour CP - CE1 - FLE)\r\nDans chaque phrase, trouve le mot qui est en trop: Exercice\r\nLa pontuation\r\nLa forme négative\r\nEcris les phrases sous forme négative: Exercice 1\r\nLes phrases découpées\r\nGenre des adjectifs qualificatifs (règles)    \r\nLes fins de mots en au et eau\r\nChoisissez entre au, aux, eau ou eaux \r\nLe pluriel des noms communs\r\nLes mots avec terminaison en au et eau (cm1,cm2,fle)\r\nChoisissez entre aux, eaux ou ots (cm1,cm2,fle)\r\nLe pluriel des mots se terminant en ail (cm1,cm2,fle)\r\nL''adjectif démonstratif\r\nExercice avec: &quot;Ce ou Cet&quot;\r\nExercice avec: &quot;Celle, Celles, Celui, Ceux, Ce ou Cela&quot; \r\nL''adjectif possessif, placer le bon adjectif possessif\r\nLes adverbes, choisissez entre près, très ou trop\r\nLes homophones: ne pas confondre Son ou Sont Se ou Ce Ses et ces:\r\nEt ou Est:On et Ont Quel, quels, quelles, quelle, qu''elle, qu''elles', 'grammaire;exercices;interactifs;étude de la langue;corrigés;homonymes;nature;gratuit', 'Auteur du site de Ortholud', '0', '2006-07-28 17:28:22', NULL, NULL),
(421, 2, 'Site &quot;Ortholud&quot;  pour des exercices en ligne en conjugaison', 'http://www.ortholud.com/conjugaison.php', 'Une façon de réviser la conjugaison des verbes du CE1 au CM2. Exercices gradués par thème d''étude, par temps, par groupe. Possibilité de s''auto-corriger et indication des scores de réussite l''exercice terminé.', 'exercices;conjugaison;CE1;CE2;CM1;CM2;groupes;temps;verbes', 'Ortholud', '0', '2006-07-28 15:58:38', NULL, NULL),
(420, 2, 'Site &quot;Ortholud&quot;  pour apprendre l''orthographe, la conjugaison, la grammaire', 'http://www.ortholud.com/', 'Tester vos connaissances en français. Jeux en ligne de grammaire de conjugaison et d''orthographe, phrases à trous, quiz et jeux avec correction en ligne. Auto-correction\r\n', 'jeux;grammaire;conjugaison;quiz;auto-correction;grammaire', 'Auteur d''Ortholud', '0', '2006-07-28 15:49:47', NULL, NULL),
(419, 2, 'Site de la petite souris - Illustration de l''histoire', 'http://lps13.free.fr/contenu/eleve/fichiers%20pdf/embr_breme.pdf', 'Illustrations téléchargeables de l''histoire les musiciens de Brême', 'histoire;illustration;contes', 'Auteur du site de la petite souris', '0', '2006-07-28 15:01:21', NULL, NULL),
(418, 2, 'Site de la petite souris - Des sous-mains évolutifs à proposer tout au long de l''année', 'http://lps13.free.fr/', 'Sous-mains ou référent individuels constitués de 2 pages A4 juxtaposées. Coloriables, personnalisables...à mettre en classe et aussi à prévoir à la maison... ou à transporter si l''outil est plastifié.\r\n1er semestre  \r\n29 sons et images-clés\r\n(oppositions appariées),\r\ngraphisme b-p-f, \r\njours de la semaine en script,\r\n20 mots-outils script, mots-couleurs,\r\nquantités de 1 à 10, file de 1 à 33,\r\ndroite, gauche\r\n \r\n2ème semestre\r\n16 maisons des sons,\r\nlettres cursives de l''alphabet,\r\n40 mot-outils en cursif,\r\njours de la semaine en cursif\r\nquantités de 11 à 20, file de 1 à 99\r\n \r\n', 'lecture;cycle 2;sous-main;outils', 'Auteur du site de la petite souris', '0', '2006-07-28 14:54:58', NULL, NULL),
(414, 2, 'Table de lecture systématique pour la lecture au cycle 2', 'http://lps13.free.fr/', 'entraînement oral systématique', 'cycle 2;lecture;entraînement;exercices', 'lps13.free.fr', '0', '2006-07-28 14:37:55', NULL, NULL),
(416, 2, 'Site de la petite souris - Des mots outils', 'http://lps13.free.fr/', 'série de mots-outils. Découpage et manipulations', 'mots outils; lecture;cycle 2', 'Auteur du site de la petite souris', '0', '2006-07-28 14:45:12', NULL, NULL),
(417, 2, 'Site de la petite souris - Affichage  d''images repères pour la lecture', 'http://lps13.free.fr/', 'Images repères pour affichage en classe ou  utilisation individuelle ', 'affichage;sons;lecture;phonème;images,CP,Cycle 2', 'Auteur du site de la petite souris', '0', '2006-07-28 14:50:14', NULL, NULL),
(413, 2, 'Site de la petite souris pour les apprentis lecteurs', 'http://lps13.free.fr/', 'Accès aux fiches élèves pour les sons pour la lecture au CP ou CE1 ( Cycle 2).\r\nFiches sur les sons\r\na -\r\n i -\r\n o -\r\n é -\r\n u -\r\n e -\r\n f -\r\n s -\r\n ch -\r\n v -\r\n j -\r\n m - \r\nr -\r\n ou -\r\n l -\r\n n -\r\n è -\r\n oi -\r\n p -\r\n t -\r\n c -\r\n d -\r\n on -\r\n b -\r\n g -\r\n gn -\r\n in -\r\n an/en am/em -\r\n z -\r\n ph -\r\n au-eau -\r\n eu-oeu -\r\n ai-ei -\r\n ette -\r\n tr-dr -\r\n fl-cl -\r\n ia-io-ie -\r\n car -\r\n que-qui -\r\n gue-gui -\r\n er-ez -\r\n ge-gi -\r\n ce-ci -\r\n er-es-ec -\r\n ien -\r\n ier-ion -\r\n ain -ein -\r\n oin -\r\n h muet -\r\n s-d-t muets -\r\n ill -\r\n -ail eil -\r\n y -oy -ay -\r\n k-w -\r\n \r\n', 'lecture;sons;CP', '', '0', '2006-07-28 14:33:48', NULL, NULL),
(411, 2, 'Echelle d''acquisition lexicale  Dubois-Buyse', 'http://jeanmarc.deleuze.free.fr/echelleDB/index.html', 'L''échelle Dubois-Buyse regroupe 3787 mots d''usage courant.\r\n\r\nL''intérêt de cette Echelle réside dans le fait que la maîtrise orthographique de ses mots, choisis pour leur très fréquente utilisation dans les écrits spontanés, a été testée sur un échantillon très important.\r\nCes mots sont regroupés en 2 catégories : \r\n- les mots-outils (&quot;0&quot; dans la rubrique &quot;échelon&quot; et &quot;Outil&quot; dans la rubrique &quot;Niveau&quot;) qui représentent à eux seuls environ 40% du vocabulaire écrit courant, \r\n- les autres mots étalonnés en degrés de difficulté, les échelons (exemple : les enfants sont censés acquérir en CP les mots des échelons 1 à 9). \r\nVous pouvez rechercher un échelon précis ou travailler sur un intervalle, ou recherche le &quot;niveau&quot; donné d''un mot donné dans la base.\r\n\r\n', 'orthographe lexicale;usage;liste;échelle Dubois-Buyse;base;échelle d''acquisition lexicale;base', 'Jean-Mars Deleuze', '0', '2006-07-28 14:20:38', NULL, NULL),
(412, 2, 'Site de la petite souris pour les apprentis lecteurs', 'http://lps13.free.fr/', 'Fiches relatives au domaine de la lecture, préparations de séquences ou fiches d''exercices  \r\nAccès à une  bibliothèque d''images, de polices, de comptines, de chants\r\n', 'lecture;cycle 2;images;comptines; chants;polices;exercices', '', '0', '2006-07-28 14:30:05', NULL, NULL),
(406, 2, 'Le conjugueur espagnol &quot; Elconjugador&quot;', 'http://www.elconjugador.com/', 'Possibilité de retrouver la conjugaison des verbes en espagnols', 'espagnol;conjugaison;ELCO', 'Le conjueur.com', '0', '2006-07-28 13:45:22', NULL, NULL),
(407, 2, 'Site pour les classes en CLIN', 'http://roland.kara.chez-alice.fr/', 'Site pour les classes en  CLIN. La clin est une classe qui accueille des élèves migrants non francophones primo-arrivants, avec pour objectif principal leur intégration rapide dans une classe francophone ordinaire.Roland Kara  présente ici &quot;une partie de son  travail afin de susciter un échange d''idées et d''outils avec les collègues de clin et d''apporter un soutien aux collègues débutants qui se sentiraient quelque peu perdus face à l''ampleur de la tâche qui leur incombe&quot;.\r\n\r\n', 'CLIN;FLE;français langue étrangère;oral;compréhension', 'Roland Kara', '0', '2006-07-28 13:51:09', NULL, NULL),
(408, 2, 'Outils pour la classe CLIN', 'http://roland.kara.chez-alice.fr/do/index.html', 'Préparations générales\r\nles apprentissages en clin \r\ntravail à l''oral et exercices systématiques\r\nprogrammation d''éveil avec ponts interdisciplinaires\r\n\r\n', 'CLIN;outils;oral;passeport', 'Roland Kara', '0', '2006-07-28 13:58:18', NULL, NULL),
(410, 2, 'Le grand atelier des petis poètes', 'http://www.ac-nancy-metz.fr/petitspoetes/', 'Le grand atelier des petis poètes est un espace :\r\n    * de rencontre\r\n    * d''expression\r\n    * d''échange\r\n    * de collaboration\r\nautour de la Poésie francophone à l''école.', 'poésies;lecture;écriture', 'Jean-Pierre Aubertin', '0', '2006-07-28 14:16:14', NULL, NULL),
(403, 2, 'Mémoire sur le chant à l''école', 'http://perso.orange.fr/archilecture/frameset.html', 'Mémoire d''IUFM sur le thème du chant à l''école', 'chants;mémoire IUFM;mémoire', 'inconnu', '0', '2006-07-28 13:12:17', NULL, NULL),
(405, 2, 'Site du conjugueur pour vérifier l''orthographe des verbes conjugués', 'http://www.leconjugueur.com/', 'Différents modules pour vérifier l''orthographe d''un mot. ( lexique,verbes,grammaire)\r\northographe en ligne-Module pour écrire un nombre- des règles de grammaire et d''orthographe\r\n', 'vérification;lecture;conjugaison;grammaire;orthographe;règles', 'www.leconjugueur.com', '0', '2006-07-28 13:38:13', NULL, NULL),
(402, 2, 'La situation-problème en E.P.S.... exemple dans une initiation à la Lutte au cycle 3', 'http://perso.orange.fr/archilecture/frameset.html', 'Mémoire d''IUFM : La situation-problème en E.P.S, exemple dans une initiation à la Lutte au cycle 3 \r\n \r\n\r\n', 'situation problème;EPS;lutte;cycle 3;mémoire', 'Anonyme', '0', '2006-07-28 13:08:22', NULL, NULL),
(399, 2, 'Anthologie d''or de la poésie française', 'http://www.poesie-francaise-francophone.com/', 'Anthologie de poésies classée par siècle', 'poésies; françaises;siècle', 'de Robert Lauret', '0', '2006-07-28 12:45:59', NULL, NULL),
(401, 2, 'Site &quot;Archi-lecture&quot; pour l''apprentissage de la lecture en GS, cycle 2', 'http://perso.orange.fr/archilecture/frameset.html', 'ARCHI LECTURE Ressources pédagogiques gratuites, relatives à l''apprentissage de la lecture au cycle 2 de l''école primaire. Site destiné aux enseignants du premier degré. Au programme: fiches d''activités, outils pédagogiques (affiches-sons, dictionnaire de sons, combinaisons de touches de l''alphabet phonétique, ouvrages pédagogiques), mémoires iufm, livrets d''évaluation, liens, téléchargements, humour aussi...Alphabet phonétique\r\nFiches d''activités pour grande section, cours préparatoire et cours élémentaire 1; dictionnaire de sons.\r\n', 'lecture;méthode;cycle 2;outils; affiches; sons; dictionnaire;GS;Cycle 2', 'Archi lecture', '0', '2006-07-28 13:01:07', NULL, NULL),
(397, 2, 'Lexique en français de botanique', 'http://fr.wiktionary.org/wiki/Cat%C3%A9gorie:Lexique_en_fran%C3%A7ais_de_la_botanique', 'Tiré de WIKIdictionnaire ; dictionnaire universel, libre et gratuit que chacun peut améliorer dans le domaine de la botanique\r\n', 'dictionnaire;lexique;botanique;végétaux;ressource libre;;wikidictionnaire', 'wikidictionnaire', '0', '2006-07-28 12:38:55', NULL, NULL),
(393, 2, 'Ani-mot-lire présentation d''une méthode de lecture', 'http://animotlire.canalblog.com/archives/1__l_auteur/index.html', 'Blog sur le thème de l''apprentissage de la lecture.\r\nBlog sur l''apprentissage de la Lecture de  Marie-Joëlle Bouchard.: une démarche novatrice permettant la découverte par les enfants de 4 à 7 ans de notre système de lecture-écriture.', 'méthode de lecture;Marie-Joëlle Bouchard', 'Marie-Joëlle Bouchard', '0', '2006-07-28 12:27:20', NULL, NULL),
(394, 2, 'Dictionnaire de botanique', 'http://encyclo.free.fr/pages/dico.htm', 'Ce dictionnaire peut  être consulté tel quel mais il est surtout intéractif. \r\nAu fil des pages vous trouverez nombre de mots indexés comme carnivore. Cliquez sur la petite icône du Dico et le dictionnaire s''ouvrira à la bonne page. ', 'botanique;dictionnaire', 'Encycle Free', '0', '2006-07-28 12:31:21', NULL, NULL),
(395, 2, 'Le glossaire de la nature', 'http://www.univers-nature.com/glo/glossaire/', 'Dictionnaire / lexique des termes de botanique, zoologie, éthologie\r\n', 'dictionnaire;glossaire;zoologie;botanique;biologie;définitions', 'Univers nature', '0', '2006-07-28 12:34:05', NULL, NULL),
(396, 2, 'Atlas des champignons', 'http://www.atlas-des-champignons.com/', 'Clé de détermination des champignons', 'atlas;champignons;clé;détermination;biologie;sciences du vivant', 'atlas-des-champignons.com/', '0', '2006-07-28 12:37:19', NULL, NULL),
(391, 2, 'Mots mêlés pour l''orthographe au cycle 2 et au cycle 3', 'http://o.bacquet.free.fr/', 'Mots mêlés pour le  cycle 2 et le cycle  3 à télécharger.  Classement thématique et liste des mots à disposition.  Recherche par mot clef possible\r\n', '', '', '0', '2006-07-28 11:41:40', NULL, NULL),
(392, 2, 'Mots croisés à thème  pour le cycle 2 et le cycle 3', 'http://o.bacquet.free.fr/', 'Possibilité de télécharger, d''imprimer ou de travailler en ligne à partir de mots croisés.\r\nDe nombreux domaines exploitables comme la géographie, la conjugaison, les sciences(les volcans), histoire (thème : les Gaulois)', 'mots croisés;cycle 2;cycle 3;exercices en ligne;', 'O Bacquet', '0', '2006-07-28 11:44:39', NULL, NULL),
(389, 2, 'La révolution française en 12 chansons', 'http://www.di-arezzo.com/france/detail_notice.php?no_article=ACOEJ02202&amp;aff=Shopping', 'La révolution Française en 12 chansons - Article payant\r\nEditeur : A Cœur Joie \r\nNo Article :  ACOEJ02202 \r\nchœur mixte Recueils Florilèges, Recueils et Grandes Partitions \r\n\r\n\r\n', 'chansons;CD-ROM,révolution française', 'Editions à coeur Joie', '0', '2006-07-28 11:33:27', NULL, NULL),
(390, 2, 'Listes orthographiques pour le cycle 3', 'http://o.bacquet.free.fr/', '  Liste CE 2 / 3ème année (684 mots), source  :  Guyon \r\n\r\n  Liste CM 1 / 4ème année (1 019 mots), source  :  Guyon \r\n\r\n  Liste CM 2 / 5ème année (981 mots), source  :  Guyon \r\n\r\n  Echelle Dubois-Buyse (3725 mots)\r\n\r\n \r\n', 'orthographe lexical, Cycle 3;échelle Dubois-Buse-Guyon;orthographe', 'Bacquet', '0', '2006-07-28 11:36:29', NULL, NULL),
(385, 2, 'Coloriages à imprimer', 'http://www.bonjourlesenfants.net/', 'Séries de dessins à télécharger pour &quot;coloriage&quot; mais aussi pour d''autres détournements en classe.\r\nThèmes divers avec des personnages clés des albums et des héros de la littérature Jeunesse des romans télévisés ou en livre', 'images; coloriage;personnages romans;littérature jeunesse', 'coloriage.com', '0', '2006-07-28 11:05:57', NULL, NULL),
(386, 2, 'Réseau école et nature', 'http://www.ecole-et-nature.org/papyrus.php', 'Le Réseau Ecole et Nature est un réseau français mettant en relation un grand nombre d''acteurs de l''éducation à l''environnement : des éducateurs (enseignants, animateurs...), des agents de l''Etat et des collectivités publiques, des acteurs du secteur privé, des porteurs de projets, des responsables de structures d''éducation, etc... afin de mieux travailler ensemble dans le sens d''un développement durable', 'nature;écologie;éducation à l''environnement;développement durable;formations', 'réseau école et nature', '0', '2006-07-28 11:13:46', NULL, NULL),
(382, 2, 'Des  ressources sur la région aquitaine', 'http://www.crdp-aquitaine.fr/aquivideo/index.asp', 'Au début des années 1970, le CRDP Aquitaine a conçu, réalisé et produit des films centrés sur la région aquitaine qui ont été diffusés sur le réseau de la Radio Télévision scolaire de façon hebdomadaire.\r\nConçus à l’origine pour une vision collective à l’intention des élèves du premier et second degré ils abordent les thèmes majeurs de l’évolution de la société et de l’économie en les illustrant d’exemples aquitains.\r\nD’une durée moyenne d’une vingtaine de minutes, ils sont au nombre de 39. De documents d’actualité, ils deviennent aujourd’hui un témoignage précieux sur les changements qui ont affecté l’industrie, l’agriculture, la presse, les moyens de transport, pour ne citer que ces domaines.\r\nTémoignages d’une ouverture de l’école à la réalité locale environnante ils participent également à l’essor des disciplines d’ « éveil » créant de nouveaux objets documentaires et pédagogiques caractérisés par une approche transdisciplinaire multi-niveaux qui leur confèrent aussi un statut original susceptible d’intéresser un très vaste public mêlant professionnels de l’éducation, Aquitains et Aquitaines attachés à la connaissance de l’histoire de leur région, enseignants-chercheurs soucieux d’illustrer concrètement les profondes mutations vécues dans tous les domaines socio-économiques.\r\nA cette première collection viendront s’ajouter dans un second temps des films plus récents toujours réalisés par le service audiovisuel du CRDP Aquitaine ayant comme thème majeur la région aquitaine.', 'vidéo;technique;cinéma d''animation;scénario;diffusion;projets vdéo;tournage;montage;imovie', 'CRDP de Bordeaux', '0', '2006-07-28 09:31:33', NULL, NULL),
(380, 2, 'Annuaire de peintures pour enseignants', 'http://www.paintings-directory.com/', 'Classement de photos en arts par mouvement ; art naïf baroque contemporain cubisme dada expressionnisme fauvisme futurisme impressionnisme réalisme renaissance rococco romantisme surréalisme symbolisme sculpures\r\nClassement par pays d''origine. Site à exploiter avec des liens ciblés  mis en garde rubrique  avec des photos de nus.\r\n\r\n\r\n\r\n', 'arts visuels;peinture;mouvement;peinture;peintre;', 'http://www.paintings-directory.com/', '0', '2006-07-28 08:46:33', NULL, NULL),
(378, 2, 'Le site &quot;Champion des mathématiques&quot; au CM2 Niveau 2', 'http://championmath.free.fr/page2CM2dif.htm', 'Logiciel en ligne permettant de travailler les notions suivantes- Additions-Divisions- Grands nombres-Mesures de longueurs-Soustractions-Apprendre les tables-Problèmes-Mesures de masses-Multiplications-Jeu des opérations-Durées-	Aires ', 'addition;numération;soustraction;division;durées;aires;tables;masses', 'Laurent Monnot', '0', '2006-07-27 16:07:24', NULL, NULL),
(379, 2, 'Destination voyages: un site avec des reportages dans le monde', 'http://www.destinationlemonde.com/destination-reportages.html', 'Un site avec des reportages photographiques légendées avec des textes simples à lire au cycle 3.\r\nIl y a 17 vidéos accessibles sur le site.Des liens avec des cartes permettant de voir des reportages sur la même région géographique. Carnets de route avec de purs récits.  Concerne les 4 continents: Amerique  Afrique  Asie  Europe  Oceanie \r\n\r\n', 'reportage;photos;vidéos;continents;Amérique;Afrique;asie;Océanie;carte;monde;mappemonde', 'contact@destinationlemonde.com', '0', '2006-07-28 08:23:52', NULL, NULL),
(377, 2, 'Le site &quot;Champion des mathématiques&quot; au CM2  Niveau 1', 'http://championmath.free.fr/page2CM2fac.htm', '  Logiciel en ligne pour s''entraîner-Additions-Divisions-Grands nombres-Mesures de longueurs-Soustractions-	\r\nApprendre les tables-Problèmes-Mesures de masses-Multiplications-Jeu des opérations-Durées-Aires ', 'addition;numération;soustraction;division;durées;aires;tables;masses', 'Laurent Monnot', '0', '2006-07-27 15:37:24', NULL, NULL),
(376, 2, 'Le site &quot;Champion des mathématiques&quot; au CM1 Niveau 2', 'http://championmath.free.fr/page2CM1dif.htm', 'Logiciel d''entrainement pour : Additions-Divisions-Grands nombres-Mesures de longueurs-Soustractions-	\r\nApprendre les tables-Problèmes-Mesures de masses-Multiplications-Jeu des opérations-Durées-Aires ', 'addition;numération;soustraction;division;durées;aires;tables', 'Laurent Monnot', '0', '2006-07-27 15:31:51', NULL, NULL),
(373, 2, 'Le site &quot;Champion des mathématiques&quot; au CE2 Niveau 1', 'http://championmath.free.fr/page2CE2fac.htm', '  Un site permettant de s''entraîner sur les notions suivantes: Additions-Apprendre les tables-Ordre des nombres-	\r\nMesures de longueurs-Soustractions-Suite de nombres-Nombre mystérieux-Multiplications-Ecriture de nombres-	\r\nProblèmes ', 'mathématiques;CE2;numération:calcul;figures;soustraction;addition;problèmes;figure;mesures', 'Laurent Monnot', '0', '2006-07-27 14:49:46', NULL, NULL),
(374, 2, 'Le site &quot;Champion des mathématiques&quot; au CE2 Niveau 2', 'http://championmath.free.fr/page2CE2dif.htm', '  Sites pour s''entraîner et s''exercer sur les notions suivantes :Additions-Apprendre les tables-Ordre des nombres-	Durées-Soustractions-Jeu des opérations-Suite de nombres-Mesures de longueurs-Multiplications-Ecriture de nombres-	\r\nProblème', 'mathématiques;CE2;numération:calcul;figures;soustraction;addition;problèmes;figure;mesures;durées', 'Laurent Monnot', '0', '2006-07-27 14:59:09', NULL, NULL),
(375, 2, 'Le site &quot;Champion des mathématiques&quot; au CM1 Niveau 1', 'http://championmath.free.fr/page2CM1fac.htm', ' Sites pour s''exercer. Additions-Divisions-Nombres-Mesures de longueurs-Soustractions-Apprendre les tables-Problèmes-Mesures de masses-Multiplications-Jeu des opérations-Durées ', 'CM1;numération:calcul;figures;soustraction;addition;problèmes;figure;mesures;durées;multiplication', 'Laurent Monnot', '0', '2006-07-27 15:04:22', NULL, NULL),
(372, 2, 'Le site &quot;Champion des mathématiques&quot; au CE1 Niveau 2', 'http://championmath.free.fr/page2CE1dif.htm', '  Additions-Apprendre les tables-Ordre des nombres-Soustractions-Ecriture de nombres-Nombre mystérieux-\r\nLes figures-Multiplications-Suite de nombres-Problèmes ', 'mathématiques;CE1;numération:calcul;figures;soustraction;addition;problèmes;figure', 'Laurent Monnot', '0', '2006-07-27 14:43:15', NULL, NULL),
(371, 2, 'Le site &quot;Champion des mathématiques&quot; au CE1 Niveau 1', 'http://championmath.free.fr/page2CE1fac.htm', 'Additions - Apprendre les tables - Ordre des nombres- Les figures-  Soustractions - Suite de nombres - Nombre mystérieux  -Multiplications  Ecriture de nombres- Problèmes  \r\nPossibilité de s''exercer dans l''ordre et dans le désordre. Bonne approche pour mémoriser les tables de multiplications\r\n', 'mathématiques;CE1;numération:calcul;figures;soustraction;addition;problèmes;figure', 'Laurent Monnot', '0', '2006-07-27 14:34:29', NULL, NULL),
(368, 2, 'Des histoires à écouter à télécharger', 'http://histoires.ratibus.net/histoire.html', 'Des séries d''histoire  à écouter et à télécharger. Les textes sont également téléchargeables', 'histoire;littérature;écouter;coin écoute;écoute;conte;sons', 'auteur de Ratibus', '0', '2006-07-27 14:15:20', NULL, NULL),
(369, 2, 'Le site &quot;Champion des mathématiques&quot; au CP Niveau 1', 'http://championmath.free.fr/page2CPfac.htm', 'Un site pour d''exercer en mathématiques au CP \r\nAdditions  Ordre des nombres  Problèmes  Soustractions  Ecriture de nombres Nombre mystérieux  \r\n', 'exercices;mathématiques;calcul;additions;problèmes;soustractions;numération;CP', 'Laurent Monnot', '0', '2006-07-27 14:23:08', NULL, NULL),
(370, 2, 'Le site &quot;Champion des mathématiques&quot; au CP Niveau 2', 'http://championmath.free.fr/page2CPdif.htm', 'Additions  Ordre des nombres  Problèmes  Soustractions  Ecriture de nombres  Les figures   Nombre mystérieux  \r\n', 'mathématiques;CP;numération:calcul;figures;soustraction;addition;problèmes', ' 	Laurent Monnot', '0', '2006-07-27 14:28:49', NULL, NULL),
(367, 2, 'Trucs et astuces à l''école maternelle', 'http://materalbum.free.fr/viedeclasse.htm', 'Trucs et astuces à l''école maternelle pour se simplifier la vie de classe, optimiser son temps, gérer son énergie\r\nDes idées, des p''tits trucs, des suggestions, le tout en vrac. \r\n\r\n', 'maternelle;trucs;conseils;astuces', '', '0', '2006-07-27 14:13:01', NULL, NULL);
INSERT INTO `module_ressource_ressources` (`id`, `id_annu`, `nom`, `url`, `description`, `mots`, `auteur`, `submit_user`, `submit_date`, `valid_user`, `valid_date`) VALUES
(366, 2, 'Des albums en maternelle', 'http://materalbum.free.fr/', 'Site dédié à la littérature Jeunesse. Exploitation d''albums à la l''école  maternelle.\r\n des activités imprimables pour les PS, MS, GS, en lecture, maths, graphisme, perception,  des comptines, des chansons, des poésies,  des idées en motricité, arts plastiques, activités manuelles,  des jeux en ligne : puzzles modulables de 2 à 60 pièces, tableaux à double entrée, associations, mémory, des liens vers des pages en rapport avec le thème de l''album\r\nune bibliographie ou des albums à mettre en réseau', 'albums;maternelle;puzzles;tableaux à double entrée;associations;mémory;graphisme;comptines;chansons;', '', '0', '2006-07-27 14:07:16', NULL, NULL),
(365, 2, 'Logiciel de l''atelier', 'http://freeperso.free.fr/freeware.html', 'Aperçu de l''heure\r\nle compte est bon \r\nAddition/Soustraction \r\nle pendu  \r\nLogiciel éducatif pour enfant de 4-8 ans.Il comprend une section addition &amp; soustraction, une section pendu, une section compte et bon, une section apprentissage de l''heure.\r\n\r\n ', 'lecture heure;addition;soustraction;pendu;compte est bon;freeware', 'Chrétien', '0', '2006-07-27 00:19:29', NULL, NULL),
(351, 2, 'Le logiciel Symcolor pour travailler la symétrie au cycle 1 et au cycle 2', 'http://www.logiciels-libres-tice.org/spip.php?article505&var_recherche=symcolor', 'Symcolor est un logiciel destiné à la construction du principe de symétrie axiale chez l’enfant à partir de la grande section en maternelle.\r\nLe logiciel est composé d’un éditeur qui permet la création d’images à partir de formes géométriques, qui seront utilisées pour les activités de symétrie.\r\n\r\nOn lance ensuite les activités de symétrie. Il s’agit alors de choisir une couleur et de peindre chaque élément de l’image conformément au modèle. Le logiciel comprend une série d’images mais il est préférable que l’enfant produise lui-même ses dessins, réalise les symétries à partir de ses dessins pour se situer dans une démarche d’expérimentation (aller-retour entre la phase de dessin et de coloriage par symétrie).\r\n\r\n\r\n', 'symétrie;mathématiques;logiciel;logiciels libres', 'AbulEdu et son équipe', '0', '2006-07-26 23:17:25', NULL, NULL),
(350, 2, 'Utiliser Tuxpaint à l''école', 'http://www.logiciels-libres-tice.org/spip.php?article44&var_recherche=tux%20paint', 'Tux Paint peut être utilisé pour apprendre aux jeunes enfants à dessiner avec un ordinateur. Une aide contextuelle est apportée par un petit Tux (pingouin mascotte) qui distille (à l’écrit, en bas de la zone de dessin) des explications sur les différentes fonctions, ainsi que des encouragements. La zone de dessin est fixe. On peut faire du dessin libre en variant l’épaisseur du trait, les couleurs.On peut sélectionner différentes formes géométriques prédéfinies, inclure du texte, On peut aussi utiliser des effets spéciaux : mosaïque, miroir (afin de pouvoir introduire la symétrie en mathématiques), négatif, arc-en-ciel, étincelles, ...\r\n\r\n', 'arts visuels;logiciel;tampons;formes géométriques;B2I;logiciel libre;tutoriel', ' Bill Kendrick', '0', '2006-07-26 23:07:55', NULL, NULL),
(349, 2, 'Je dessine.com', 'http://www.jedessine.com/', 'Site avec des dessins à colorier, des idées de bricolage...etc... Attention quelques publicités..', 'arts;dessin en ligne; bricolage', 'Johannes Wallroth', '0', '2006-07-26 22:42:50', NULL, NULL),
(348, 2, 'Utiliser Abiword à l''école', 'http://www.logiciels-libres-tice.org/spip.php?article115&var_recherche=abiword', 'Abiword est un traitement de texte rapide et complet, avec une interface simple, des possibilités de mise en forme de pages évoluées. Facile à utiliser même dans les petites classes. Abiword a les fonctionnalités principales comme Word, mais gratuit et beaucoup moins gourmand en place (- de 10 Mo avec les pilotes divers).Facile pour un passage en douceur vers des logiciels standards.De plus il gère les formats .txt .doc .html .rtf ', 'Traitement de textes;B2I;Abiword;logiciel libre;tutoriel', 'L’équipe de développement d’AbiWord; fiche descriptive Mdrechsler', '0', '2006-07-26 22:30:51', NULL, NULL),
(347, 2, 'Chants et comptines traditionnels', 'http://www.chez.com/kolymbia/index2.html', 'A Paris \r\nAgadou dou dou \r\nAh le petit vin blanc \r\nAllez viens boire \r\nAuprès de ma blonde \r\nCe n''est qu''un aurevoir \r\nDouce nuit, Sainte nuit\r\nDu rhum, des femmes \r\nEn passant par la Lorraine \r\nFélicie aussi \r\nFrench Cancan \r\nFrou-Frou \r\nJoyeux anniversaire  	  	  	La chenille \r\nLa danse des canards \r\nLa java bleue \r\nLa java des gaulois \r\nLa plus bath des javas \r\nMarche nuptiale \r\nMinuit chrétien \r\nMon beau sapin \r\nNe pleure pas Jeannette \r\nOn a soif \r\nPetit Papa Noël \r\nSous les ponts de Paris \r\nVive le vent (Jingle Bells) ', 'chansons;comptines', 'PAROLES - les Textes de la Chanson Française', '0', '2006-07-26 21:04:32', NULL, NULL),
(345, 2, 'Rallye scientifique sur le thème de la reprodution des poissons', 'http://www.ac-creteil.fr/lecturecollinet/reproduction/accueil.htm', 'Un rallye pour mettre en évidence le principe de la reproduction des poissons.', 'reproduction;sciences du vivant;lecture documentaire;poissons', 'académie de Créteil', '0', '2006-07-23 16:11:35', NULL, NULL),
(346, 2, 'Comptines et chants trandionnels  en ligne', 'http://www.chez.com/kolymbia/index2.html', 'A la volette \r\nAh vous dirais-je maman\r\nAlouette \r\nAu clair de la lune \r\nC''est la mère Michel \r\nCadet Rousselle \r\nFais dodo Colas \r\nFrère Jacques \r\nGentil coquelicot \r\nIl court le furet \r\nIl était un petit navire \r\nl était une bergère \r\nIl pleut bergère\r\nJ''ai du bon tabac \r\nJ''ai perdu le do\r\nLe bon roi Dagobert \r\nMalbrough s''en va-t''en guerre \r\nMon âne \r\nNous n''irons plus au bois \r\nSavez-vous planter les choux (\r\nSur le pont d''Avignon \r\nTrois jeunes tambours ', 'Chants;comptines', '', '0', '2006-07-26 21:00:21', NULL, NULL),
(344, 2, 'Rallye scientifique sur le thème de l''alimentation des poissons', 'http://www.ac-creteil.fr/lecturecollinet/poisson/accueil.htm', 'La forte compétition qui existe entre les poissons les a obligés à utiliser toutes les possibilités pour obtenir espace et nourriture. Ils occupent donc des milieux variés et consomment une grande variété de nourriture.\r\nOn peut les classer de la manière suivante :1. les végétariens  2. Les mangeurs d''animaux peu mobiles 3. Les carnassiers\r\nMais beaucoup de poissons mangent un peu de tout.', 'Alimentation;chaîne alimentaire;régime alimentaire;lecture documentaire;B2I', 'académie de Créteil', '0', '2006-07-23 16:07:43', NULL, NULL),
(343, 2, 'Rallye scientifique sur le thème de la respiration', 'http://www.ac-creteil.fr/lecturecollinet/respiration/accueil.htm', 'Un rallye pour mettre en évidence le principe de la rrespiration.Les élèves ont leur disposition des pages Web très simples avec du texte et des photographies. Ils doivent répondre à un questionnaire en ligne à partir des indices trouvés dans le texte.', 'respiration;rallye scientifique;lecture documentaire;B2I', 'académie de Créteil', '0', '2006-07-23 16:03:00', NULL, NULL),
(341, 2, 'Fiches pédagogiques Ecrire une UNE en histoire', 'http://www.ac-creteil.fr/lecturecollinet/uneshistoriques/accueil.htm', 'Ecrire une Une en histoire sur les thèmes suivants :La mobilisation en 1914-La bataille de la Marne-La résistance-La révolution française-La révolution industrielle-Les villes au Moyen-Age\r\n\r\n', 'bataille de la Marne;la résistance;révolution industrielle,les villes au Moyen-Age;14-18;1914-1918', 'Académie de Créteil', '0', '2006-07-23 15:32:50', NULL, NULL),
(340, 2, 'Fouquet le nuage du roi Soleil', 'http://www.ac-creteil.fr/lecturecollinet/uneshistoriques/accueil.htm', 'Des élèves de l''académie de Créteil ont rédigé une &quot;Une&quot; sur le thème de Fouquet le nuage du roi Soleil. Utilisable lors de lectures documentaires ou l''organisation d''un rallye. Un bon complément pour retenir des notions en histoire.', 'Louis 14;Louis XIV;Fouquet;histoire;lecture documentaire;rallye', 'académie de Créteil', '0', '2006-07-23 15:31:06', NULL, NULL),
(338, 2, 'Les grands découvertes-Version 2', 'http://www.ac-creteil.fr/lecturecollinet/uneshistoriques/accueil.htm', 'Des élèves de l''académie de Créteil ont rédigé une &quot;Une&quot; sur le thème des grandes découvertes. Utilisable lors de lectures documentaires ou l''organisation d''un rallye. Un bon complément pour retenir des notions en histoire.', 'grandes découvertes;histoire;lecture documentaire;rallye', 'académie de Créteil', '0', '2006-07-23 15:25:44', NULL, NULL),
(339, 2, 'La légende du masque de fer', 'http://www.ac-creteil.fr/lecturecollinet/uneshistoriques/accueil.htm', 'Des élèves de l''académie de Créteil ont rédigé une &quot;Une&quot; sur le thème de la légende du masque de fer. Utilisable lors de lectures documentaires ou l''organisation d''un rallye. Un bon complément pour retenir des notions en histoire.', 'masque de fer;histoire;lecture documentaire', 'académie de Créteil', '0', '2006-07-23 15:27:48', NULL, NULL),
(337, 2, 'La vie terrible des paysans au Moyen Age', 'http://www.ac-creteil.fr/lecturecollinet/uneshistoriques/accueil.htm', 'Des élèves de l''académie de Créteil ont rédigé une &quot;Une&quot; sur le thème de la vie terrible des paysans au Moyen-Age. Utilisable lors de lectures documentaires ou l''organisation d''un rallye. Un bon complément pour retenir des notions en histoire.', 'Moyen Age;histoire;paysans;lecture documentaire;rallye', 'académie de Créteil', '0', '2006-07-23 15:22:22', NULL, NULL),
(333, 2, 'Les grandes découvertes', 'http://www.ac-creteil.fr/lecturecollinet/uneshistoriques/decouvertes.htm', 'Des élèves de l''académie de Créteil ont rédigé une &quot;Une&quot; sur le thème des grandes découvertes. Utilisable lors de lectures documentaires ou l''organisation d''un rallye. Un bon complément pour retenir des notions. ', 'histoire;grandes découvertes;lecture documentaire', 'académie de Créteil', '0', '2006-07-23 15:07:48', NULL, NULL),
(334, 2, 'La libération', 'http://www.ac-creteil.fr/lecturecollinet/uneshistoriques/lib%E9ration.htm', 'Des élèves de l''académie de Créteil ont rédigé une &quot;Une&quot; sur le thème de la libération. Utilisable lors de lectures documentaires ou l''organisation d''un rallye. Un bon complément pour retenir des notions en Histoire.', 'libération;2ème guerre mondiale, lecture documentaire;rallye', 'académie de Créteil', '0', '2006-07-23 15:10:24', NULL, NULL),
(335, 2, 'Les villes au Moyen-Age', 'http://www.ac-creteil.fr/lecturecollinet/uneshistoriques/accueil.htm', 'Des élèves de l''académie de Créteil ont rédigé une &quot;Une&quot; en histoire sur le thème des villes au Moyen-Age.  Utilisable lors de lectures documentaires ou l''organisation d''un rallye. Un bon complément pour retenir des notions en histoire.', 'Moyen-Age;villes;histoire;lecture', 'académie de Créteil', '0', '2006-07-23 15:14:50', NULL, NULL),
(336, 2, 'Les chevaliers du Moyen Age', 'http://www.ac-creteil.fr/lecturecollinet/uneshistoriques/accueil.htm', 'Des élèves de l''académie de Créteil ont rédigé une &quot;Une&quot; sur le thème des chevaliers au Moyen-Age. Utilisable lors de lectures documentaires ou l''organisation d''un rallye. Un bon complément pour retenir des notions en histoire.', 'Moyen Age;histoire;chevaliers;lecture documentaire', 'académie de Créteil', '0', '2006-07-23 15:17:09', NULL, NULL),
(332, 2, 'La révolution industrielle', 'http://www.ac-creteil.fr/lecturecollinet/uneshistoriques/industrie.htm', 'Des élèves de l''académie de Créteil ont rédigé une &quot;Une&quot; sur le thème de la révolution industrielle. Utilisable lors de lectures documentaires ou l''organisation d''un rallye. Un bon complément pour retenir des notions. ', 'histoire;révolution industrielle;19 ème siècle', 'académie de Créteil', '0', '2006-07-23 15:01:41', NULL, NULL),
(330, 2, 'La résistance pendant la 2 ème guerre mondiale', 'http://www.ac-creteil.fr/lecturecollinet/uneshistoriques/resistance.htm', 'Des élèves de l''académie de Créteil ont rédigé une &quot;Une&quot; sur le thème de la résistance. Utisable lors de lectures documentaires ou l''organisation d''un rallye.', 'résistance;histoire;guerre mondiale;lecture documentaire;recherche documentaire', 'académie de Créteil', '0', '2006-07-23 14:54:08', NULL, NULL),
(331, 2, 'La révolution française de 1789', 'http://www.ac-creteil.fr/lecturecollinet/uneshistoriques/revolution.htm', 'Des élèves de l''académie de Créteil ont rédigé une &quot;Une&quot; sur le thème de la révolution française. Utilisable lors de lectures documentaires ou l''organisation d''un rallye.', 'histoire;révolution française de 1789;1789;recherche documentaire', 'académie de Créteil', '0', '2006-07-23 14:57:30', NULL, NULL),
(329, 2, 'La bataille de la Marne', 'http://www.ac-creteil.fr/lecturecollinet/uneshistoriques/la_bataille_de_l.htm', 'Une &quot;Une&quot; écrite par des élèves sur la bataille de la Marne', 'guerre 14 -18;lecture documentaire; histoire;recherche documentaire', 'académie de Créteil', '0', '2006-07-23 14:52:43', NULL, NULL),
(328, 2, 'La mobilisation Guerre de 14-18', 'http://www.ac-creteil.fr/lecturecollinet/uneshistoriques/mobilisation.htm', 'Une &quot;une&quot; réalisée par les élèves sur la mobilisation lors de la guerre de 14-18', 'guerre 14-18;lecture documentaire; histoire;recherche documentaire', 'académie de Créteil', '0', '2006-07-23 14:50:49', NULL, NULL),
(327, 2, 'Des exemples de UNE en histoire', 'http://www.ac-creteil.fr/lecturecollinet/uneshistoriques/accueil.htm', 'Ecrire des &quot;UNES&quot; en histoire .... une façon originale de travailler en histoire, lier la maîtrise de la langue aux apprentissages des notions historiques. Vous pouvez créer avec vos élèves une &quot;une&quot; historique reprenant les principaux événements d''une période de votre programme d''histoire.', 'une; historique;histoire;écrits;lecture;lecture documentaire', 'académie de Créteil', '0', '2006-07-23 14:45:55', NULL, NULL),
(326, 2, 'Des exemples de UNE en sciences', 'http://www.ac-creteil.fr/Ecoles/77/compayre2meaux/sciences/sommaireunes.htm', 'Des élèves ont rédigé des &quot;UNES&quot; scientifiques dans des journaux.\r\nThème La digestion - La respiration - La circulation - Les volcans - Les plantes\r\nExemplaires pour les démarches de productions d''écrits en sciences en direction d''un public. Bonne approche de la médiatisation de ce que l''on a compris sur une notion comme la digestion; la respiration, la circulation, les volcans.', ' digestion;respiration;circulation;volcans;plantes;traces écrites;sciences', 'Académie de Créteil', '0', '2006-07-23 14:38:38', NULL, NULL),
(325, 2, 'Lettres vidéo des élèves de l''IME d''Orly', 'http://www.ac-creteil.fr/ID/94/c13/ime/lettre/lettre_video.html', 'Un travail sur l’image (photos et vidéos).&quot;Cette lettre vidéo est destinée à interpeller les élus et les pouvoirs publics ; elle développe aussi les propositions des jeunes, investis alors dans une démarche d’apprentissage de citoyenneté&quot;.\r\n\r\n ', 'lettre vidéo;vidéo;langue orale; éducation à la citoyenneté;images', 'Michel FEVRE et Martine SAVIGNY', '0', '2006-07-23 14:26:09', NULL, NULL),
(322, 2, 'Radio cartable, la radio des enfants des écoles d’Ivry', 'http://radio-cartable.ouvaton.org/', 'La radio à l''école .... C’est par un &quot;jingle&quot; que, tous les jeudis après-midi de 14 heures à 15 heures, Radio-Cartable accueille ses auditeurs sur Radio Libertaire (89.4 FM) : chaque semaine, environ mille enfants d’une trentaine de classes d’Ivry-sur-Seine, dans le Val de Marne, conçoivent, réalisent, diffusent et écoutent des émissions de cette radio en milieu scolaire. ', 'radio;langue orale;oral', 'Site Radio cartable : Philippe Potier et toute l''équipe', '0', '2006-07-23 14:06:13', NULL, NULL),
(318, 2, 'Entrer dans l''histoire par la littérature Jeunesse', 'http://www.crdp.ac-creteil.fr/telemaque/document/histoire.htm', 'À propos du roman historique :qu''est ce que le roman historique ?Lle point de vue des auteurs\r\nExploration du contenu de l''édition française Les origines du roman historique\r\nRoman historique et pédagogie', 'histoire;littérature Jeunesse;romans', 'CRDP Créteil', '0', '2006-07-23 13:41:17', NULL, NULL),
(317, 2, 'BCD informatisée en maternelle', 'http://www.crdp.ac-creteil.fr/telemaque/pratiques/dossierBCDI.htm', 'Expérience relatée par Chantal Bouguennec sur le site du CRDP de Créteil', 'BCD;lecture;maternelle', 'Chantal Bouguennec', '0', '2006-07-23 11:50:59', NULL, NULL),
(316, 2, 'Une BCD classée et gérée par les écoles de l''école maternelle', 'http://www.crdp.ac-creteil.fr/telemaque/pratiques/BCD-gestion.htm', 'Les séquences présentées ont été réalisées avec des élèves de moyennes et grandes sections, par demi-groupes, à l''école maternelle Joliot Curie à Champigny-sur-Marne, située en Zone d''Éducation Prioritaire, pendant l''année scolaire 2001-2002. Le travail effectué a donné lieu à la réalisation, par le secteur Animation pédagogique du CRDP, d''une cassette vidéo.\r\n', 'BCD;lecture;ZEP', 'Académie de Créteil/CRDP/Télémaque', '0', '2006-07-23 11:48:15', NULL, NULL),
(301, 2, 'Dessins animés au format Realvideo en russe', 'http://skazochki.narod.ru/video/menu.html', 'Dessins animés en russe', 'dessins animés;russe', 'skazochki.narod.ru', '0', '2006-07-23 10:53:13', NULL, NULL),
(303, 2, 'Films très courts avec dialogues destinés à l''apprentissage du russe pour débutants.', 'http://russian.dmll.cornell.edu/brtf/films.htm', 'Films très courts avec dialogues destinés à l''apprentissage du russe pour débutants. ', 'films;russe', 'Université de Cornell.', '0', '2006-07-23 10:57:19', NULL, NULL),
(305, 2, 'Dessins animés en russe -Site Multer', 'http://multer.ru/', 'dessins animés en Russe', 'russe;dessins animés', '', '0', '2006-07-23 11:01:07', NULL, NULL),
(300, 2, 'Dessins animés en ligne en Russe', 'http://www.multikov.net/', 'Dessins animés en ligne', 'russe; dessins animés', 'www.multikov.net', '0', '2006-07-23 10:51:01', NULL, NULL),
(292, 2, 'Contes bilingues russes-français', ' http://perso.wanadoo.fr/bernard.blion/Index.htm', 'Bernard Blion a traduit sur son site, des contes en russe. Version française accessible', 'russe;contes', 'bernard.blion', '0', '2006-07-23 10:12:55', NULL, NULL),
(289, 2, 'Revue russe pour enfants', ' http://www.cofe.ru/read-ka/', 'Dans la revue  &quot;&amp;#1055;&amp;#1086;&amp;#1095;&amp;#1080;&amp;#1090;&amp;#1072;&amp;#1081;&amp;#1082;&amp;#1072;&quot; on trouve  contes, anecdotes, récits, poésies...', 'russe;contes;poésies', 'http://www.cofe.ru/', '0', '2006-07-23 09:59:35', NULL, NULL),
(281, 2, 'Jeu en russe au musée de Darwin', 'http://www.darwin.museum.ru/expos/dino/r_main.asp', 'Le musée Darwin consacre quelques pages aux dinosaures avec d''excellent dessins. Les questions simples peuvent être devinées. L''enseignant traduira les réponses (très synthétiques). ', 'compréhension orale;musée Darwin;russe', 'darwin.museum.', '0', '2006-07-23 09:18:57', NULL, NULL),
(279, 2, 'Alphabet illustrant les personnages et objets des contes russes', 'http://www.solnet.ee/sol/004/rr_011.html', 'Alphabet illustrant les personnages et objets des contes russes. ', 'alphabet;contes russes', '&amp;#1074;&amp;#1077;&amp;#1090;&amp;#1083;&amp;#1072;&amp;#1085;&amp;#1072; &amp;#1052;&amp;#1072;&amp;#1093;&amp;#1086;&amp;#1090;&amp;#1080;&amp;#1085;&amp;#1072;', '0', '2006-07-23 09:10:41', NULL, NULL),
(276, 2, 'Alphabet sonore pour le Russe à l''école', 'http://masterrussian.com/blalphabet.shtml', 'Alphabet sonore russe qui facilite la mémorisation', 'russe;alphabet sonore', 'masterrussian', '0', '2006-07-23 09:01:47', NULL, NULL),
(277, 2, 'Très bel alphabet russe', ' http://bomoonlight.ru/azbuka/a.html', 'Document à agrandir ou à afficher', 'alphabet russe;affichage', ' &amp;#1080;&amp;#1083;&amp;#1083;&amp;#1102;&amp;#1089;&amp;#1090;&amp;#1088;&amp;#1072;&amp;#1094;&amp;#1080;&amp;#1080;, &amp;#1089;&amp;#1090;&amp;#1080;&amp;#1093;&amp;#1080;, 2001', '0', '2006-07-23 09:03:33', NULL, NULL),
(274, 2, 'Alphabet russe à détourner', 'http://www.raskraska.narod.ru/azbuka/azbuka.html', 'L''alphabet à détourner : l''enseignant clique sur une lettre, elle apparait en grand format,  on peut jouer à qui sera le premier à la nommer. ', 'alphabet;russe', '', '0', '2006-07-23 08:55:56', NULL, NULL),
(271, 2, 'Présentation de Katy-Couprie et de ses albums', 'http://www.crdp.ac-creteil.fr/telemaque/document/katy-couprie.htm', 'Présentation de Katy Couprie, de sa démarche, de ses projets. Article intéressant mettant en lumière le rôle du carnet de croquis, une démarche de l''inventaire.Présentation de l''album &quot;Au jardin&quot; et &quot;tout un monde&quot;.', 'albums;littérature;carnet;croquis', 'CRDP Chantal Bouguennec et Madeleine Couet-Butlen', '0', '2006-07-23 08:32:41', NULL, NULL),
(261, 2, 'Educasource', 'http://www.educasources.education.fr', 'Éducasources est la base de ressources numériques en ligne sélectionnées et décrites par le réseau SCÉRÉN. Éducasources est également un modèle de description des ressources numériques en ligne compatible avec les normes et standards de métadonnées : LOM, LOM-FR et Dublin Core. \r\nLes nouveautés pour les utilisateurs sont : \r\n l’accès à des sélections thématiques régulièrement mises à jour /   la possibilité de mémoriser ses références et de se constituer sa propre sélection de ressources à la norme bibliographique (Z 44-005-2) /  la possibilité d’affiner ses recherches avec des descripteurs (Motbis). \r\n\r\n', 'Educasource;sélections thématiques;références;base de ressources;LOM', 'CNDP', '0', '2006-07-22 22:46:57', NULL, NULL),
(250, 2, 'Les programmes', 'http://eduscol.education.fr/D0048/primacc.htm', 'Les nouveaux programmes \r\n', '', 'DESCO Editeur CNDP', '0', '2006-07-22 21:55:44', NULL, NULL),
(246, 2, 'Lire au CP- Repérer les difficultés pour mieux agir', 'http://eduscol.education.fr/cid50487/savoir-parler-lire-ecrire.html', 'Guide accompagnant les nouveaux programmes.\r\nLe document de 40 pages donne des repères méthodologiques pour prendre en charge les élèves en difficultés en lecture. Compétences et tâches associées, les questions à se poser, les actions à prévoir', 'lecture;difficultés;enfant en difficulté', 'DESCO Editeur CNDP', '0', '2006-07-22 21:16:21', NULL, NULL),
(249, 2, 'Prévenir l''illettrisme', 'http://eduscol.education.fr/D0135/notes-ill.htm', 'Documents DESCO\r\nLa collection &quot;Prévenir l''illettrisme&quot; propose des outils d''information et guides méthodologiques brefs sur des thèmes en relation avec les difficultés scolaires en lecture et en écriture.\r\n\r\n    * Prévenir l''illettrisme numéro 1 - répondre à des besoins éducatifs particuliers\r\n    * Prévenir l''illettrisme numéro 2 - apprendre à lire avec un trouble du langage\r\n\r\n', 'illettrisme;prévevir l''illettrisme;trouble du langage;lecture;écriture;difficultés', 'DESCO Editeur CNDP', '0', '2006-07-22 21:46:58', NULL, NULL),
(245, 2, 'Guide pour la direction des écoles', 'http://eduscol.education.fr/D0028/accueil.htm', 'Destiné avant tout à aider les directeurs d''école dans leur fonction, le guide rassemble à leur intention les règles de fonctionnement de l''école..\r\n\r\n    * Surveillance des élèves\r\n\r\n    * L''école et l''argent\r\n\r\n    * Les parents et l''école\r\n\r\n    * Temps scolaire\r\n\r\n', 'surveillance;argent;parents;temps scolaire', 'DESCO direction des écoles du Ministère', '0', '2006-07-22 21:10:52', NULL, NULL),
(243, 2, 'Evaluations Cycle 2 en Français', 'http://www.banqoutils.education.gouv.fr/recherche/rechmultia2.php', 'Evaluations de la banqoutil du Ministère. Possibilité d''affiner la recerche par compétences.', 'évaluation', 'Ministère EN', '0', '2006-07-22 19:56:13', NULL, NULL),
(244, 2, 'Evaluation et aides personnalisées(Site Eduscol)', 'http://eduscol.education.fr/cid48441/l-evaluation.html', 'Textes relatifs à l''évaluation et les aides personnalisées', 'évaluation;réussite;aides personnalisées;PPRE', 'Eduscol, direction des écoles', '0', '2006-07-22 19:59:42', NULL, NULL),
(240, 2, 'Questions sur l''entrainement méthodique et les méthodes de lecture', 'http://www.uvp5.univ-paris5.fr/TFL/TFL.asp', 'textes théoriques sur l''autonomie et l''entrainement méthodique', 'lecture;CP;autonomie;entrainement méthodique', 'Bentolila', '0', '2006-07-22 18:19:56', NULL, NULL),
(242, 2, 'Banque d''outils pour l''évaluation', 'http://www.banqoutils.education.gouv.fr/', 'Banque d´outils d´aide à l´évaluation diagnostique \r\nNom d''utilisateur: outils / Mot de passe: dpd\r\nAccès à de nouveaux ouils avec les entrées suivantes\r\n \r\n    * La discipline concernée,\r\n    * la capacité ou famille de compétences visée,\r\n    * le niveau pour lequel il a été conçu,\r\n    * le titre,\r\n    * le résumé qui apporte un complément d''information (activité demandée aux élèves, caractéristiques particulières du support d’évaluation utilisé…). ', 'outils;évaluation;diagnostique', 'banqoutils.education.gouv.fr', '0', '2006-07-22 18:32:57', NULL, NULL),
(239, 2, 'Questions sur l''oral et les méthodes de lecture', 'http://www.uvp5.univ-paris5.fr/TFL/TFL.asp', 'Site TFL... une recherche rapide rapide de textes répondant à des questions précises.', 'oral;lecture;méthodes', 'Bentolila', '0', '2006-07-22 18:17:23', NULL, NULL),
(238, 2, 'Notions théoriques', 'http://www.uvp5.univ-paris5.fr/TFL/TFL.asp', '1-	Culture de l''écrit et composants de l''apprentissage\r\n2-	Structure de la langue\r\n3-	Oral et écrit\r\n4-	Identification des mots\r\n5-	Compréhension en lecture\r\n6-	Lecture experte\r\n7-	Pédagogie\r\n8-	Didactique\r\n9-	Français langue seconde\r\n10-	Difficultés et handicap\r\n', 'écrit;oral;mots;compréhension;lecture experte;FLS;lecture', 'Bentolila', '0', '2006-07-22 18:09:41', NULL, NULL),
(237, 2, 'Apprendre à lire en 10 pages et quarante notions', 'http://www.uvp5.univ-paris5.fr/TFL/TFL.asp', '  	Points évoqués\r\n        Maîtriser la langue orale\r\n	Apprendre ce que c''est que lire avant de savoir lire\r\n	Apprendre à lire et savoir lire\r\n	Apprendre à identifier les mots\r\n	En chemin vers la compréhension du texte lu : l''importance de la syntaxe\r\n	Apprendre à comprendre\r\n	Les difficultés d''apprentissage\r\n	Pluridisciplinarité et polyvalence\r\n	Évaluation des performances', 'lecture;CP;méthodes;évaluation;connaissance code', 'Alain Bentolila', '0', '2006-07-22 18:05:45', NULL, NULL),
(236, 2, 'Parcours de formation en lecture au CP', 'http://www.uvp5.univ-paris5.fr/TFL/TFL.asp', 'Série de modules de formation en ligne du TFL\r\nCinq  parcours constituent le socle des indispensables pour le CP\r\n\r\n1- Connaissance du code\r\n\r\n2- Entrer dans les textes, la compréhension\r\n\r\n3- Méthodes d''apprentissage et manuels\r\n\r\n4- Découverte de la culture écrite\r\n\r\n5- L’évaluation de la lecture\r\n ', 'lecture;CP;méthodes;évaluation;connaissance code', 'TFL', '0', '2006-07-22 18:01:29', NULL, NULL),
(235, 2, 'L''album Jeunesse support parallèle  privilégier', 'http://www.bienlire.education.fr/02-atelier/fiche.asp?theme=1120&amp;id=1110', 'Le travail en parallèle sur les deux supports (manuel de lecture et albums de jeunesse) permet d’appréhender différentes facettes de la lecture. Exemples de pistes d''exploitation', '', 'Arlette Weber (maître formateur)', '0', '2006-07-22 17:42:56', NULL, NULL),
(234, 2, 'Comprendre des consignes avec un support écrit aux cycles 2', 'http://www.bienlire.education.fr/02-atelier/fiche.asp?theme=1120&amp;id=1106', 'Pistes de travail proposées pour la compréhension de consignes\r\nEvaluation et aide aux apprentissages en grande section de maternelle et en cours préparatoire. Cet outil est présent dans chaque école sous forme d’une brochure verte et d’un cédérom et également accessible sur le site banqoutils ', 'compréhension;consignes;lecture', 'http://www.banqoutils.education.gouv.fr', '0', '2006-07-22 17:34:56', NULL, NULL),
(233, 2, 'Retrouver des sons dans les mots', 'http://www.banqoutils.education.gouv.fr/fic/ECPABD01.pdf', 'Évaluation et aide aux apprentissages en grande section de maternelle et en cours préparatoire. Cet outil est présent dans chaque école sous forme d’une brochure verte et d’un cédérom et également accessible sur le site banqoutils (http://www.banqoutils.education.gouv.fr\r\n', 'lecture;syllabe;conscience phonologique;mots', 'banqoutils.education.gouv.fr', '0', '2006-07-22 17:30:21', NULL, NULL),
(232, 2, 'Prendre conscience de la structure syllabique des mots(2)', 'http://www.banqoutils.education.gouv.fr/fic/EGSABC01.pdf', 'Évaluation et aide aux apprentissages en grande section de maternelle et en cours préparatoire. Cet outil est présent dans chaque école sous forme d’une brochure verte et d’un cédérom et également accessible sur le site banqoutils (http://www.banqoutils.education.gouv.fr\r\n\r\n', 'lecture;syllabe;conscience phonologique;mots', 'banqoutils.education.gouv.fr', '0', '2006-07-22 17:27:10', NULL, NULL),
(230, 2, 'Prendre conscience des rimes', 'http://www.banqoutils.education.gouv.fr/fic/EGSABB01.pdf', 'Outil d’Évaluation et aide aux apprentissages en grande section de maternelle et en cours préparatoire. ', 'évaluation;lecture;cycle2', 'banqoutils.education.gouv.fr', '0', '2006-07-22 17:17:46', NULL, NULL),
(231, 2, 'Prendre conscience de la structure syllabique des mots(1)', 'http://www.banqoutils.education.gouv.fr/fic/ECPABC01.pdf', 'Évaluation et aide aux apprentissages en grande section de maternelle et en cours préparatoire.\r\nCet outil est présent dans chaque école sous forme d’une brochure verte et d’un cédérom et également accessible sur le site banqoutils (http://www.banqoutils.education.gouv.fr ', 'lecture;syllabe;conscience phonologique', 'banqoutils.education.gouv.fr', '0', '2006-07-22 17:23:45', NULL, NULL),
(229, 2, ' Développer les compétences phonologiques au cycle 2', 'http://www.bienlire.education.fr/02-atelier/fiche.asp?theme=1120&amp;id=1107', 'Activités pédagogiques visant à favoriser le développement des compétences phonologiques au cours de la GS et au début du CP\r\n', 'compétences phonologiques;phonologie;lecture', 'Direction de la programmation et du développement', '0', '2006-07-22 16:28:06', NULL, NULL),
(226, 2, 'Programmation pour pour la lecture documentaire au cycle 2', 'http://www.bienlire.education.fr/02-atelier/fiche.asp?theme=1200&amp;id=1402', 'Programmation pour la lecture au cycle 2 faisant apparaître les 3 paramètres. ( Langage oral;lecture et écriture;découverte du monde).\r\nGS/CP/CE1 concernés', 'lecture documentaire;programmation;cycle2', 'Marylène Cochet, conseillère pédagogique ; Sylvie Crusson, conseillère pédagogique ; Lucie Desailly,', '0', '2006-07-22 15:40:11', NULL, NULL),
(225, 2, 'Des médiations au cycle 2 autour des ouvrages documentaires', 'http://www.bienlire.education.fr/02-atelier/fiche.asp?theme=1200&amp;id=1402', 'Textes théoriques  puis  quatre scenarii pédagogiques en première partie\r\n-Un éléphant dans le réseau\r\n-Les états de l’eau pour lire l’image\r\n-Ça pousse dans les albums documentaires\r\n-Un parcours très chouette\r\nDeuxième partie : des outils pour les maîtres\r\nComparer et choisir des ouvrages documentaires\r\nUne aide à la programmation\r\nUn rappel des textes officiels\r\nBibliographie sélective ', 'lecture;documents;médiations;lecture documentaire', 'Lucie Dessailly (IEN)', '0', '2006-07-22 15:36:01', NULL, NULL),
(224, 2, 'Association &quot;lire et faire lire&quot;', 'http://www.bienlire.education.fr/02-atelier/fiche.asp?theme=2200&amp;id=1138', 'Lire et faire lire est un programme d''ouverture à la lecture et de solidarité intergénérationnelle. C’est aussi le nom de l’association loi 1901 créée en décembre 1999 qui organise ce programme (http://www.lireetfairelire.org/). ', 'solidarité intergénérationnelle;lire et faire lire; accompagnement scolaire; scolarité', 'Lire et faire lire', '0', '2006-07-22 15:27:11', NULL, NULL),
(222, 2, 'L’Entraide Scolaire Amicale pour combattre les inégalités sociales face à la réussite scolaire.', 'http://www.bienlire.education.fr/02-atelier/fiche.asp?theme=2200&amp;id=1384', 'La nécessité d’une action extra-scolaire\r\nUne action citoyenne\r\nComment est organisée l’Entraide Scolaire Amicale ?\r\nQue peuvent apporter les bénévoles de l’Entraide Scolaire Amicale ?\r\nD’autres associations', 'réussite scolaire;accompagnement scolaire', 'Laurence Jung (professeur)', '0', '2006-07-22 15:16:04', NULL, NULL),
(223, 2, 'Les clubs coups de pouce', 'http://www.bienlire.education.fr/02-atelier/fiche.asp?theme=2200&amp;id=1145', 'Présentation de l’APFÉE (Association pour favoriser une école efficace) a été créée en 1984 à l''initiative d''une équipe d''enseignants soucieux d''agir contre l''échec scolaire. ', 'APFEE;accompagnement;scolarité', 'Georges Vissac (directeur de l’APFEE), Jean-Pierre Minassian (vice-président de Savoir Lire)', '0', '2006-07-22 15:22:18', NULL, NULL),
(221, 2, 'Fiches accompagnement à la scolarité', 'http://www.bienlire.education.fr/02-atelier/fiche.asp?theme=2200&amp;id=1410', 'Ensemble de fiches permettant d''apporter des conseils sur l''accompagnement à la scolarité\r\nLes fiches familiales, rédigées par une équipe interministérielle et partenariale, avec l’appui d’experts, cherchent à soutenir les familles dans leur effort pour créer des conditions favorables à la scolarité de leurs enfants. Elles proposent des pistes pour l’action et visent à faciliter les échanges, ainsi que la recherche d’informations. \r\n\r\n', 'accompagnement scolarité; fiches;relation famille-Ecole', 'Equipe interministérielle', '0', '2006-07-22 13:08:02', NULL, NULL),
(220, 2, 'Le travail des élèves à l''école et en dehors de l''école', 'http://www.bienlire.education.fr/04-media/a-glasman.asp', 'Rapport établi à la demande du Haut Conseil de l’évaluation de l’école. Ce rapport a été réalisé par Dominique Glasman, professeur de sociologie à l''Université de Savoie, chercheur au Laboratoire Langages.\r\nUn chapitre est consacré à chacun des thèmes suivants :\r\n- les devoirs à la maison \r\n- les jeux éducatifs \r\n- les cours particuliers \r\n- le coaching scolaire \r\n- l''accompagnement scolaire\r\n- les devoirs de vacances \r\n- une bibliographie générale. ', 'coaching:accompagnement;scolarité;devoirs;jeux éducatifs;cours particuliers', 'Dominique Glasman', '0', '2006-07-22 13:02:48', NULL, NULL),
(219, 2, 'Primlangue Allemand', 'http://www.primlangues.education.fr/php/suggestion_polyglotte.php?type=15&langue=1&x=28&y=19', 'Primlangue le site  en allemand', 'Langue vivante;allemand;conte;album;livre;bilingue', 'rede K., Furlano C Coll. « P’tit Bil Editions Zoom', '0', '2006-07-22 12:45:55', NULL, NULL),
(218, 2, 'A puffin year of stories and poems', 'http://www.primlangues.education.fr/php/suggestion_polyglotte.php', 'A puffin year of stories and poems  est un  album avec des poésies en anglais sur le thème des saisons. Poèmes classés en fonction des 4 saisons.', 'saisons;langues vivantes;LV;anglais', 'Editions Puffin Books', '0', '2006-07-22 12:44:39', NULL, NULL),
(217, 2, 'A l''ombre d''un olivier ... un album + un CD avec des chansons arabes et berbères', 'http://www.primlangues.education.fr/php/suggestion_polyglotte.php', '    *  Favret H., Lerasle M., Novi N.\r\n    * Coll. « Comptines du monde »\r\n    * Didier jeunesse\r\n    * 2001\r\n\r\n29 comptines, berceuses, rondes, chansons arabes et berbères.\r\n\r\nPour une approche culturelle \r\nPlouf tizen tizen - Sardine à l’huile - Minga touri - Param param - Ouahad jouj tlata - Hada li sraq ljaja - Dab alfar dbibatou - Un gros lézard est passé par là – Maymouna - Tita tita tita - Bisiklat klat klat - Atas atas amimmi - Ykhallik ! y’alli – Boughanja - Achta ta ta ta ta - Ya mtar khalti - Aoulad alharrata - Lalla fatima – Boudjaghlallou - Sannat lahmar -', 'livre;CD;chansons;comptines;arabe;berbère', ' Favret H., Lerasle M., Novi N.', '0', '2006-07-22 12:40:24', NULL, NULL),
(216, 2, 'Site national et institutionnel Primlangues', 'http://www.primlangues.education.fr/php/', 'Site national institutionnel pour les langues du CIEP et du Ministère.\r\nOutils didactiques pour l''enseignement des langues.De nombreuses ressources pour toutes les langues', 'langues vivantes;italien;allemand;anglais;arabe;turc', 'CIEP Ministère de l''Education Nationale', '0', '2006-07-22 11:30:41', NULL, NULL),
(215, 2, 'Devoirs à la maison : 50 ans de travail au noir', 'http://netia59a.ac-lille.fr/~siteia/bulletin_departemental/pdf/95_dossier.pdf', 'Un texte tiré du BD de l''IA59 du Nord. Dans ce dossier sont développés les points suivants.\r\n\r\n    * la législation sur les devoirs à la maison\r\n    * 7 types d’arguments\r\n    * Quel travail, le soir à la maison ?\r\n    * La démarche d’apprentissage des leçons\r\n    * L''exemple d''une leçon d''histoire\r\n    ', 'devoirs;apprendre une leçon', '', '0', '2006-07-22 10:55:07', NULL, NULL),
(214, 2, 'Site national &quot;Bien Lire à l''école&quot;', 'http://www.bienlire.education.fr/', 'Des outils, des fiches pratiques, des documents théoriques, des adresses utiles pour mieux répondre aux difficultés des enfants en lecture. Un accès aux Actualités sur le thème de la lecture. \r\nDes interviews et des manifestations avec une veille sur le domaine de la lecture.', 'lecture;fiches;théorie', 'CNDP et Ministère de l''Education Nationale', '0', '2006-07-22 10:43:46', NULL, NULL),
(213, 2, 'SPINOO Moteur de recherche', 'http://www.spinoo.fr/default.asp', 'SPINOO est un moteur de recherche dédié aux sites éducatifs institutionnels français.\r\nMis au point par le CNDP, il vous permet de trouver toutes les ressources pédagogiques, documentaires et administratives présentes dans l''ensemble de ces sites.\r\n', 'Moteur de recherche;sites éducatifs institutionnels', '', '0', '2006-07-21 21:08:28', NULL, NULL),
(211, 2, 'SIte institutionnel EDUSCOL de la direction des écoles', 'http://eduscol.education.fr/', 'Site pédagogique du ministère de l''Education Nationale DESCO', 'Eduscole;direction des écoles;', 'Ministère EN', '0', '2006-07-21 20:01:58', NULL, NULL),
(212, 2, 'Le portail national institutionnel EDUCNET pour la généralisation des TIC', 'http://www.educnet.education.fr/', 'Portail national Educnet - Une partie consacrée pour le primaire - Veille de toutes les nouveautés nationales en matière de TIC. BO...', 'TIC;Educnet;EDUCNET;portail', 'Ministère EN', '0', '2006-07-21 20:22:37', NULL, NULL),
(209, 2, 'Logiciel : le nombre mystère', 'http://www.scalpa.info/logiciels_mystere.php', 'Encadrement d''un nombre : L''ordinateur choisit aléatoirement un nombre que l''enfant doit deviner par encadrement successif.\r\n2 Euros', 'numération;comparaison;encadrement', '', '0', '2006-07-21 18:58:39', NULL, NULL),
(210, 2, 'Site institutionnel du Ministère de l''Education Nationale', 'http://www.education.gouv.fr/index.php', 'Site institutionnel et national du ministère de l''Education Nationale', 'Education Nationale;gouvernement', 'Ministère EN', '0', '2006-07-21 19:59:19', NULL, NULL),
(208, 2, 'Logiciel : écrire en chiffres', 'http://www.scalpa.info/logiciels_chiffre.php', 'Ecrire un nombre en chiffres : L''ordinateur choisit aléatoirement un nombre et le présente écrit en lettres. L''enfant doit l''écrire en chiffres. Indication des scores.\r\nPrix : 3 Euros', 'numération;orthographe;dictée de nombres', '', '0', '2006-07-21 18:53:49', NULL, NULL),
(206, 2, 'Logiciel : Comparer des nombres', 'http://www.scalpa.info/logiciels_comparer.php', 'Comparer des nombres entiers ou décimaux : Il faut trouver un nombre compris entre deux autres.\r\nIndication des scores. Prix 3 Euros', 'calcul; mathématiques;numération; comparer; nombres entiers;nombres décimaux', '', '0', '2006-07-21 18:46:19', NULL, NULL),
(207, 2, 'Logiciels : des nombres en lettres', 'http://www.scalpa.info/logiciels_lettres.php', 'Ecrire un nombre en lettres : l''ordinateur choisit aléatoirement un nombre et le présente écrit en chiffres. L''enfant doit l''écrire en lettres. Indication des scores - 3 Euros ', 'dictée de nombres;numération;logiciel; mathématiques', '', '0', '2006-07-21 18:51:11', NULL, NULL),
(205, 2, 'Logiciel : calcul mental', 'http://www.scalpa.info/logiciels_mental.php', 'Logiciel d''entraînement et de test des compétences en calcul mental à utiliser après une période d''apprentissage en classe dans laquelle on aura mis en évidence les techniques les plus efficaces pour chacun en fonction du type d''opérations à réaliser. Il s''agit avec ce logiciel de travailler toutes les techniques opératoires sous forme de calcul mental. L''utilisateur peut effectuer tous les réglages permettant de varier la difficulté du calcul :       \r\n\r\n            taille du nombre à droite du signe opératoire\r\n         \r\n\r\n            taille du nombre à gauche du signe opératoire\r\n          \r\n\r\n            signe opératoire\r\n\r\nA la fin du jeu, on revient à la fenêtre des résultats sur laquelle on découvre son score, le temps mis pour réaliser les quarante opérations.\r\n\r\nIndication des scores', 'Calcul mental', '', '0', '2006-07-21 18:42:56', NULL, NULL),
(204, 2, 'Logiciel : Ecrire des nombres entendus', 'http://www.scalpa.info/logiciels_entendus.php', 'Un nombre est dit par Merlin, les enfants doivent l''écrire en chiffres. Au bout de dix bonnes réponses, un jeu de labyrinthe leur est proposé.Maintenant Merlin parle aussi anglais...', 'numération;orthographe;dictée de nombres;dictée en anglais', '', '0', '2006-07-21 18:38:47', NULL, NULL),
(203, 2, 'Logiciel : Décomposer et réduire des nombres', 'http://www.scalpa.info/logiciels_decomposer.php', 'Il faut soit écrire la décomposition d''un nombre (entier ou décimal) en respectant l''ordre décroissant de valeur de chaque chiffre liée à sa position dans le nombre : exemple pour 245, il faudra écrire (2x100)+(4x10)+(5x1) bien que tout autre décomposition soit valable 200+40+5, 200+45, (4x10)+(2x100)+(5x1) etc.. Mais dans un premier temps respectons l''ordre ... cela facilite la mise en place du mécanisme !\r\nPrix : 5 Euros', 'numération; décomposition d''un nombre; décimal, entier', '', '0', '2006-07-21 18:25:46', NULL, NULL),
(200, 2, 'Les problèmes de recherche pour les élèves du cycle 3', 'http://www.scalpa.info/anipeda_probleme_2006.php', 'Animation pédagogique de Sandrine Guilbert, Conseillère pédagogique circo. de Mortain', 'problèmes de recherche', ' Sandrine Guilbert', '0', '2006-07-21 18:16:00', NULL, NULL),
(197, 2, 'Liste des compétences pour la géométrie à l''école élémentaire', 'http://www.scalpa.info/maths_geometrie.php', 'Liste des compétences attendues pour la géométrie - Programmes 2002', 'géométrie;compétences;programmes 2002', 'Ministère EN', '0', '2006-07-21 17:57:18', NULL, NULL),
(198, 2, 'Liste des compétences pour les mesures et grandeurs à l''école élémentaire', 'http://www.scalpa.info/maths_mesure.php', 'Liste des compétences attendues pour la rubrique &quot;mesures&quot; et &quot;grandeurs&quot;', 'mesures;mathématiques;calcul,programmes 2002;compétences;grandeurs', 'Ministère EN', '0', '2006-07-21 18:00:08', NULL, NULL),
(199, 2, 'Liste des compétences pour les problèmes  à l''école élémentaire', 'http://www.scalpa.info/maths_probleme.php', 'RESOLUTION DE PROBLEMES\r\n\r\nEXPLOITATION DE DONNÉES NUMÉRIQUES\r\nProblèmes relevant des quatre opérations\r\nProportionnalité\r\nOrganisation et représentation de données numériques', 'Problèmes;proportionnalité;données numériques', 'Ministère EN', '0', '2006-07-21 18:03:17', NULL, NULL),
(196, 2, 'Calcul réfléchi', 'http://www.scalpa.info/calcul.php', 'Calcul réfléchi : les poignées de main\r\n\r\nCalcul réfléchi : les trois nombres qui se suivent\r\n\r\nCalcul réfléchi : trouver la valeur de A et la valeur de B sachant la somme A + B et la différence A - B.\r\n\r\nCalcul réfléchi : calculer des additions en utilisant les complémentaires.\r\n', 'calcul réfléchi;exercices', 'Auteur de Scalpa', '0', '2006-07-21 17:49:34', NULL, NULL),
(195, 2, 'Liste des compétences pour le calcul à l''école élémentaire', 'http://www.scalpa.info/calcul.php', 'Résultats mémorisés, procédures automatisées\r\nCalcul réfléchi\r\nCalcul instrumenté', 'mathématiques;calcul;compétences:programmes 2002', 'Ministère EN', '0', '2006-07-21 17:43:09', NULL, NULL),
(193, 2, 'If de Rudyard Kipling / Guillaume Reynard', 'http://www.scalpa.info/lit_kipling.php', 'Exploitation de &quot;If&quot; de  Rudyard Kipling.\r\nPropostion de piste d''exploitation pour interpréter les strophes de ce texte célèbre.', 'littérature;poésie; Rudyard Kipling', 'Site de Scalpa', '0', '2006-07-21 17:35:50', NULL, NULL),
(194, 2, 'Liste des compétences pour la numération à l''école élémentaire', 'http://www.scalpa.info/maths_numeration.php', 'Liste des compétences attendues lors de la scolarité d''un élève d''après les programmes 2002.', 'Compétences;numération;liste;programmes 2002', '', '0', '2006-07-21 17:38:14', NULL, NULL),
(191, 2, 'Oeuvre de Raymond Queneau au cycle 3', 'http://www.scalpa.info/lit_queneau.php', 'Exploitation de l''ouvrage de Raymond Queneau', 'littérature;Raymond Queneau;poésies', 'Auteur de Scalpa', '0', '2006-07-21 17:17:49', NULL, NULL),
(192, 2, 'Poésies d''André Breton au cycle 3', 'http://www.scalpa.info/lit_breton.php', 'Des pistes d''exploitation comme le faisait Breton. \r\nApproche du surréalisme. \r\nUne présentation (succincte mais prolongée en arts-plastiques) du mouvement surréaliste et après un travail réalisé sur Queneau exploitation de à la création poétique à partir de collage d''extraits de journaux comme le faisait Breton', 'Breton;poésies;littérature;surréalisme', 'Auteur de Scalpa', '0', '2006-07-21 17:27:51', NULL, NULL),
(190, 2, 'Exploiter une BD  au cycle 3- Calvin et Hobbes', 'http://www.scalpa.info/lit_calvin.php', 'Pistes d''exploitation d''une BD ... Cavin et Hobbes\r\n\r\nL''enfance est pleine de désillusions et pleine d''inventions aussi. Heureusement Calvin, petit garçon de 6 ans, un peu turbulent, déborde d''imagination. Aidé de son fidèle tigre en peluche et compagnon Hobbes, il sait rendre la vie piquante et drôle. Tout le monde y passe : les parents, les filles, la maîtresse d''école. Mais la principale activité de ce tendre Calvin est d''animer le club le D.E.F.I. (Dehors énormes filles informes), dont Calvin et Hobbes sont seuls membres actifs, et ils se déchaînent sur la pauvre Susie Derkins.', 'littérature;BD;bandes dessinées;Calvin;Hobbes', 'Auteur du site de Scalpa', '0', '2006-07-21 17:15:20', NULL, NULL),
(188, 2, 'Exploiter une nouvelle d''alphonse Daudet au cycle 3', 'http://www.scalpa.info/lit_daudet.php', 'Exploitation d''une nouvelle d''Alphonse Daudet, au cycle3.', 'Nouvelles;lecture;Alphonse Daudet;sous-préfet;littérature', 'Auteur de Scalpa', '0', '2006-07-21 17:08:34', NULL, NULL),
(189, 2, 'Exploiter le conte du Petit Poucet au cycle 3', 'http://www.scalpa.info/lit_poucet.php', 'Pistes d''exploitation pour aborder le conte du Petit Poucet au cycle 3.', 'Contes;Petit-Poucet;littérature;lecture;Perrault', 'Auteur du site de Scalpa', '0', '2006-07-21 17:11:43', NULL, NULL),
(187, 2, 'Exploiter un roman au cycle 3-Le fermier Gilles de Ham de TOLKIEN / Sabatier / Ledoux', 'http://www.scalpa.info/tolkien.php', 'Pistes et exploitations du roman au cycle 3', 'TOLKIEN; Sabatier;Ledoux;romans;littérature', 'Site de Scalpa', '0', '2006-07-21 17:04:42', NULL, NULL),
(185, 2, 'Exploiter un roman au cycle 3 - Charlie et la Chocolaterie de Roald Dahl', 'http://www.scalpa.info/lit_charlie.php', 'Pistes d''exploitation du roman de Roald Dahl  Charlie et la chocolaterie', 'littérature;roman;Roald Dahl;Charlie et la chocolaterie', 'Auteur de Scalpa', '0', '2006-07-21 16:38:02', NULL, NULL),
(186, 2, 'Exploiter un roman au cycle 3 -Le mystère des mots-croisés de Senecal Didier / Chavanat Didier', 'http://www.scalpa.info/lit_tolkien.php', 'Pistes d''exploitation de cette oeuvre de Senecal Didier et Chavanat Didier\r\n\r\nRESUME\r\n\r\nLouis Mortier mène une vie oisive, sans se soucier de ses innombrables kilos en trop. Il est riche, si riche qu''il peut se permettre de ne pas travailler et passer ses journées à assouvir sa passion pour les mots croisés. Mais un beau matin il reçoit une lettre postée de Bangkok, en Thaïlande. Louis Mortier pâlit en découvrant son contenu : une grille de mots croisés qui fait allusion à des événements de sa vie qu''il croyait oubliés... Quel est ce serment qu''il a trahi ? Cette statue qu''il a volée ? Le passe-temps de Louis Mortier devient une machine à remonter le temps vers un passé où se croisent cupidité, mystère, trahison et vengeance...', 'Senecal Didier;Chavanat Didier;roman;littérature', 'Auteur de Scalpa', '0', '2006-07-21 17:00:45', NULL, NULL);
INSERT INTO `module_ressource_ressources` (`id`, `id_annu`, `nom`, `url`, `description`, `mots`, `auteur`, `submit_user`, `submit_date`, `valid_user`, `valid_date`) VALUES
(182, 2, 'Skype pour téléphoner gratuitement', 'http://telecharger-skype-fr.com/telephone-gratuit/', 'Logiciel permettant la téléphonie sur Internet d''une façon gratuite. Utisation possible pour les directeurs et voire même pour les élèves pour les échanges &quot;inter-classes&quot;.', 'communication; téléphonie Internet:Skype', '', '0', '2006-07-21 15:30:06', NULL, NULL),
(183, 2, 'Les mots les plus fréquents de la langue française Echelle Dubois Buyse', 'http://www.scalpa.info/orl_ortho.php', 'Liste des mots de l''échelle Dubois-Buyse\r\nliste-mots-alphabetique.txt\r\nliste-mots-nature-frequence.txt\r\nliste-mots-par-frequence.txt\r\nliste-mots-par-frequence.xls\r\néchelle Dubois-Buyse', 'orthographe;orthographe lexicale;échelle Dubois Buyse', '', '0', '2006-07-21 16:29:28', NULL, NULL),
(179, 2, 'Progressions et programmations pour les sciences en maternelle', 'http://pedagogie.ac-toulouse.fr/ariege-education/sciences09/php/article.php3?id_article=228', 'Des exemples de programmations au cycle 1 pour les sciences', 'sciences;programmation;cycle1', '', '0', '2006-07-21 14:31:13', NULL, NULL),
(180, 2, 'Sciences en ligne', 'http://www.educasciences.org/sciences_en_ligne/rubrique.php3?id_rubrique=7', 'Des progressions et des scénarios pour aborder les sciences à l''école', 'sciences', '', '0', '2006-07-21 14:34:42', NULL, NULL),
(177, 2, 'Sciences en ligne- Des fiches sur l''air au cycle 2', 'http://www.educasciences.org/sciences_en_ligne/rubrique.php3?id_rubrique=5', 'Des mises en situation pour travailler sur la notion de &quot;l''air&quot; au cycle 2.', 'sciences;air', '', '0', '2006-07-21 14:24:09', NULL, NULL),
(178, 2, 'Aides à la programmation de cycle en sciences', 'http://pedagogie.ac-toulouse.fr/ariege-education/sciences09/php/rubrique.php3?id_rubrique=67', 'Des aides pour des programmation de cycle dans les écoles en sciences', 'programmation;sciences;cycle', '', '0', '2006-07-21 14:27:31', NULL, NULL),
(175, 2, 'La fabrique des savoirs pour des projets autour des sciences+TICE+langue', 'http://pedagogie.ac-toulouse.fr/ariege-education/sciences09/php/revue/rubrique.php3?id_rubrique=79', '« La Fabrique des savoirs » est un projet qui a pour intention d’articuler apprentissages scientifiques, apprentissages langagiers et utilisation des T.I.C.E.', 'sciences;TICE;langue', '', '0', '2006-07-21 13:59:56', NULL, NULL),
(174, 2, 'Enseigner les sciences en Périgord', 'http://pedagogie.ac-toulouse.fr/ariege-education/sciences09/php/article.php3?id_article=14', 'Ce site est un site départemental du réseau &quot;La Main à la Pâte&quot;.\r\nLe site ariégeois des sciences à l''école propose des liens vers les  cahiers d''expérience  développés dans certains départements. De nombreux liens pour les sciences à l''école', 'cahier expériences;sciences', 'IA du Périgord', '0', '2006-07-21 13:53:53', NULL, NULL),
(172, 2, 'Textes et ressources pour les sciences à l''école EDUSCOL', 'http://eduscol.education.fr/D0027/EXSACC.htm', 'Consulter les textes de référence\r\nAccéder à des ressources nationale\r\nAccéder à des ressources académiques, d''IUFM, départementales, de circonscriptions ou d''écoles\r\nAccéder à des ressources non institutionnelles conformes aux programmes et aux prescriptions du plan de rénovation (Rubrique en projet)\r\n\r\n\r\n', '', '', '0', '2006-07-21 13:41:07', NULL, NULL),
(167, 2, 'Le dictionnaire multi-fonctions de TV5', 'http://dictionnaire.tv5.org/', 'Saisissez votre requête et validez pour obtenir la définition ou cliquez sur l''onglet de votre choix pour les autres fonctionnalités. (synonyme, dictionnaire Anglais Français ou Français Anglais)', 'dictionnaire', '', '0', '2006-07-21 12:26:51', NULL, NULL),
(168, 2, 'Orthonet', 'http://www.sdv.fr/orthonet/index.html', 'Saisissez le mot dont vous recherchez l''orthographe : \r\n(tapez UN SEUL MOT. Sous sa forme standard: nom au singulier, verbe à l''infinitif)\r\n\r\nLEXIQUE \r\nConsultation rapide du lexique grâce au formulaire sur cette page (formes difficiles, accords douteux, conjugaisons)\r\n\r\nLe Lexique propose également des informations sur l''orthographe des nombres, des éléments de grammaire, des éléments sur l''orthographe nouvelle...  \r\n  QUESTIONS  \r\nQuand le LEXIQUE ne suffit pas, des linguistes attendent votre question ; réponse rapide, précise, documentée. \r\n  CORRECTIONS \r\nUn texte (court) à contrôler ? il vous est rendu, orthographe vérifiée et corrigée. \r\n', 'orthographe;ORL', '', '0', '2006-07-21 12:51:13', NULL, NULL),
(165, 2, 'Règles en grammaire et en orthographe', 'http://www.leconjugueur.com/frreglesUsuelles.php', 'Mémentos ou condensé des règles à retenir.', 'orthographe:grammaire;règles', '', '0', '2006-07-21 12:11:42', NULL, NULL),
(166, 2, 'Le dictionnaire tout en un', 'http://www.le-dictionnaire.com/', 'Un tout-en-un comme on les aime (orthographe, synonymes, conjugaison, encyclopédie). Simple, pratique et efficace. \r\n', 'dictionnaire;orthographe;synonymes; conjugaison;encyclopédie', '', '0', '2006-07-21 12:25:25', NULL, NULL),
(163, 2, 'Vérifier l''orthographe d''un mot ( orthographe lexicale)', 'http://www.leconjugueur.com/frorthoonline.php', 'Vérifier l''orthographe d''un mot en ligne. L''élève saisit son mot', 'orthographe lexicale;vérificateur orthographique', '', '0', '2006-07-21 12:07:16', NULL, NULL),
(164, 2, 'Vérificateur orthographe  : écrire un nombre en lettres', 'http://www.leconjugueur.com/frnombre.php', 'Vérificateur en ligne pour savoir écrire à bon escient les nombres en toute lettre. Rappel des règles à côté de la réponse', 'orthographe;vérificateur;nombres;lettres', '', '0', '2006-07-21 12:10:17', NULL, NULL),
(159, 2, 'Dictionnaire Français-Anglais et Anglais-Français', 'http://dico.isc.cnrs.fr/dico_html/fr/index_tr.html', 'Dictionnaire d''Anglais en ligne', 'dictionnaire;anglais', '', '0', '2006-07-21 11:48:02', NULL, NULL),
(160, 2, 'DIctionnaire des synonymes de l''Université de Caen', 'http://elsap1.unicaen.fr/dicosyn.html', 'Ce dictionnaire des synonymes contient approximativement  49 000 entrées  et  396 000 relations synonymiques . La base de départ est constituée de sept dictionnaires classiques (Bailly, Benac, Du Chazaud, Guizot, Lafaye, Larousse et Robert) dont ont été extraites les relations synonymiques.', 'dictionnaire;synonymes', 'Université de Caen', '0', '2006-07-21 11:51:13', NULL, NULL),
(161, 2, 'Dictionnaire - Grammaire interactive', 'http://grammaire.reverso.net/', 'Les réponses à vos questions d''orthographe, de grammaire, des tests...\r\nFenêtre pour la recherche', 'grammaire;dictionnaire', '', '0', '2006-07-21 11:54:40', NULL, NULL),
(162, 2, 'Un moteur de recherche pour la conjugaison', 'http://www.la-conjugaison.fr/', 'Moteur de recherche pour trouver la conjugaison d''un verbe. Plus de 8000 verbes conjugués. Intéressant pour une utilisation quotidienne de la classe ... Accès aux verbes les plus fréquents', 'conjugaison;verbes;moteur;recherche', '', '0', '2006-07-21 11:56:33', NULL, NULL),
(158, 2, 'Dictionnaire des synonymes ( lexique français)', 'http://www.dictionnaire-synonymes.com/', 'Taper un mot dans la fenêtre du dictionnaire des synonymes. Les élèves trouvent rapidement des synonymes', 'dictionnaire;synonymes', '', '0', '2006-07-21 11:46:06', NULL, NULL),
(157, 2, 'Dictionnaire de conjugaison', 'http://www.capeutservir.com/verbes/', 'Pour connaître toutes les conjugaisons d''un verbe (tous les temps, tous les modes) et imprimer sa fiche, saisissez le verbe recherché dans la fenêtre et l''affaire est jouée ! \r\n\r\n', 'conjugaison;verbes;temps;modes', 'Auteur de &quot;Ca peut servir&quot;', '0', '2006-07-21 11:40:12', NULL, NULL),
(156, 2, 'Bréviare d''orthographe française BOF', 'http://mapage.noos.fr/mp2/', 'Un aide-mémoire sur l''orthographe et la grammaire. \r\n\r\nBOF est un fichier d''aide (graticiel au format HLP) sur les règles et leurs exceptions concernant le langage écrit. Il a été conçu comme un complément au dictionnaire. \r\nQuestion : comment se souvenir \r\n      - que pot-au-feu est invariable ? \r\n      - que l''on écrit un mille-pattes, mais un mille-feuille ? \r\n      - que l''on écrit un portefeuille, mais un porte-monnaie ? \r\n      - que l''on écrit de-ci de-là, mais deçà delà ? \r\n      - que l''on écrit « les grosses gens sont toujours joyeux » ? \r\n\r\n', 'ORL;orthographe;règles orthographe', 'Marc Goldstein', '0', '2006-07-21 11:37:44', NULL, NULL),
(155, 2, 'Dictionnaire des animaux', 'http://tizours.free.fr/dicoanimaux/table.htm', 'Dictionnaire bien adapté pour les élèves de l''école primaire. Les animaux sont présentés simplement avec une entrée &quot;visuelle&quot;, le régime alimentaire ... On peut avoir un lien direct sur un site pour avoir plus de renseignements.Possibilité d''écouter et d''avoir le vocabulaire du bruit de l''animal.\r\nUn jeu sur les animaux est également disponible. &quot;Clique sur la lettre qui correspond au nom de l''animal que tu vois en photo.&quot;', 'dictionnaire;animaux;bruit', '', '0', '2006-07-21 11:31:45', NULL, NULL),
(154, 2, 'Sites des dictionnaires Harry Potter', 'http://harrydico.net/', 'Dictionnaires de l''univers francophone de Harry Potter (noms propres, noms communs, français-anglais, Potter pour tous, personnages, plantes-potions, formules-sorts, livres magiques) en forme de dictionnaire papier. \r\n', 'dictionnaire;noms propres;noms communs', '', '0', '2006-07-21 11:24:58', NULL, NULL),
(153, 2, 'Chasse aux trésors pour les tables de multiplication', 'http://olivnath.free.fr/utilitaires/utilitaires%20maths/multi10.swf', 'Logiciel en ligne pour réviser les tables de multiplication', 'Tables;multiplication', 'Olivnat', '0', '2006-07-20 23:58:34', NULL, NULL),
(151, 2, 'Utilitaires en numération', 'http://olivnath.free.fr/utilitaires/utilitaires%20maths/utilitaires%20maths%20cp/listfich2.php', 'achats 12345 euros.zip\r\nadditions picbille boite 5.zip\r\nadditions picbille boite 10.zip\r\naffiche brissiaud boites + domino.zip\r\naffiche famille 30.zip\r\naffiche famille 40.zip\r\naffiche famille 50.zip\r\naffiche famille 60.zip\r\naffiche famille 70.zip\r\ncalcule la somme euros1.zip\r\nComplément brissiaud 2.zip\r\nComplément brissiaud début CP.zip\r\nfrise Brissiaud jusqu''à 10.pdf\r\nfrise Brissiaud jusqu''à 10.zip\r\nfrise Brissiaud jusqu''à 19.zip\r\nloterie1.zip\r\npolice mains pour frise brissiaud.zip\r\nsomme euros modèle.zip\r\n', '', '', '0', '2006-07-20 23:54:40', NULL, NULL),
(150, 2, 'Utilitaires en Français', 'http://olivnath.free.fr/utilitaires/utilitaires%20fran%e7ais/', 'é et è.zip\r\n/cp\r\n/tableaux de conjugaison\r\nFaçons de parler registres de langue.zip\r\ngroupe nominal.zip\r\nhomophones lexicaux.PDF\r\nIMPERATIF.zip\r\nles homonymes gramm.zip\r\nles mots en é, té, tié.zip\r\nLe verbe et les pronoms de conj.zip\r\nmots inv grand format.zip\r\npassé composé-des-12-verbes-les-plus-frequents.zip\r\nquelques homophones courants.zip\r\nS’EST - C’ EST - CES - SES -SAIT - SAIS.zip\r\ntableau p personnels.zip\r\nVocabulaire autour de la poésie.zip\r\nvocabulaire poésie.PDF\r\n\r\n', 'Utilitaires', '', '0', '2006-07-20 23:53:31', NULL, NULL),
(149, 2, 'Utilitaires en mathématiques', 'http://olivnath.free.fr/utilitaires/utilitaires%20maths/listfich2.php', '/utilitaires maths cp\r\ndécouverte fractions.zip\r\necrire-les-nombres-en-lettres.zip\r\nfiche tables brissiaud.zip\r\nmulti10.swf\r\npetits quadrillages multi plication.zip\r\nquadrillages découverte de la multiplication.zip\r\nquadrillages multiplication.zip\r\ntableau affiche numération unités milliers millions milliards.zip\r\ntableaux pour passer du quadrillage à la multiplication.zip\r\ntables pythagore addition et les doubles jusqu''à 20.zip\r\ntables pythagore multiplication.zip\r\ntechnique opératoire de l''addition.zip', 'Trucs et astuces;outils', '', '0', '2006-07-20 23:52:13', NULL, NULL),
(148, 2, 'Production d''écrits', 'http://olivnath.free.fr/prodecri.htm', 'fiche méthodologique pour rédiger un compte-rendu \r\n        \r\nle portrait liste de vocabulaire autour du portrait \r\n&quot;C''est bien juste avant la rentrée&quot;  &quot;C''est bien juste avant la rentrée&quot; extrait de &quot;c''est bien&quot; (Philippe Delerme) \r\n&quot;C''est bien juste avant la rentrée&quot;  même texte à compléter par les élèves \r\n', 'Compte-rendu:le portrait', '', '0', '2006-07-20 23:48:38', NULL, NULL),
(147, 2, 'Lecture de romans', 'http://olivnath.free.fr/lectroman.htm', 'Textes de romans téléchargeables .. à lire au cycle 3. Questionnaires\r\nLes deux gredins, Les joues roses ,\r\nOn avolé le N''koro N''koro Peur sur la ferme Le chameau qui n''avait pas de bosse word pdf Les derniers géants Crime caramel Les massashussets prennent la plume : présentation des personnages (travail possible sur le texte descriptif et sur l''adjectif)  Mister Bonflair et le voleur masqué : présentation de la structure d''un polar \r\n', 'Romans;textes', '', '0', '2006-07-20 23:45:46', NULL, NULL),
(145, 2, 'Séquane .. un site pour produire des exercices interactifs', 'http://www.sequane.com', 'Ce site est consacré aux systèmes-auteurs permettant de produire des \r\nexercices interactifs sur le Web et, notamment, à Hot Potatoes et Netquiz, JClic\r\n Vous trouverez ici entre autres la traduction des tutoriels, des articles, \r\ndes manuels, des forums et  des liens vers d''autres ressources concernant \r\nles générateurs d''exercices pour le Web et les TICE.\r\n\r\n\r\n', 'système auteur;exerciseur;générateur d''exercices', '', '0', '2006-07-20 23:41:42', NULL, NULL),
(144, 2, 'Dictionnaire illustré', 'http://www.pdictionary.com/french/', 'Association &quot;images&quot; et &quot;mots&quot;\r\nExiste en version &quot;Italien&quot;, Anglais, espagnol,français,allemand\r\nExercices sur le mot : reconstituer un mot ...', 'Dictionnaire;anglais:espagnol;italien;allemand', '', '0', '2006-07-20 23:34:33', NULL, NULL),
(141, 2, 'Cent références sur le portfolio numérique', 'http://www.robertbibeau.ca/portfolio.html', '\r\n\r\n', 'Portfolio numérique', 'Robert Bibeau', '0', '2006-07-20 23:19:45', NULL, NULL),
(142, 2, 'Emissions radios en espagnol', 'http://www.rtve.es/radio/radio-exterior/', 'Emissions radio en espagnol', 'Espagnol;radio', '', '0', '2006-07-20 23:22:48', NULL, NULL),
(139, 2, 'Jeu du Tangram', 'http://www.clubic.com/telecharger-fiche10740-tangram.html', 'Jeu du Tangram à télécharger', 'Tangram;géométrie;logiciel', '', '0', '2006-07-20 23:13:35', NULL, NULL),
(140, 2, 'CDex pour extraire les pistes d''un CD en mp3', ' http://sourceforge.net/projects/cdexos', '\r\nCDex, en anglais, license GPL : permet d''extraire les pistes d''un CD en mp3\r\nou wav en un minimum de temps (conversion d''un titre .cda en mp3 en moins de 20s\r\n\r\n', 'Logiciel;mp3;CD-Rom', '', '0', '2006-07-20 23:17:00', NULL, NULL),
(138, 2, 'Puzzmat', 'http://web-ia.ac-poitiers.fr/web17/LeChapus/logitheque/afficher.php?fiche=2', 'Logiciel pour les élèves de maternelle.\r\nCompétences: Orientation, repérage dans le plan.\r\nAdaptabilité: Les différentes options disponibles (modèle visible, nombre de pièces, rotation ou pas) permettent d''adapter la difficulté des puzzles à l''age des enfants.\r\n\r\nPar exemple une carte de géographie pour le cycle 3.\r\n Description: PUZ-MAT est un générateur de puzzles pour la maternelle et le cycle 2. A partir de n''importe quelle image ou photo scannée réalisez facilement un puzzle de 4 à 36 pièces, avec ou sans modèle, avec ou sans rotation des pièces. Jouez à l''écran, ou bien imprimez-le à la taille de votre choix pour en faire un puzzle carton.\r\n\r\nUtilisation: A l''aide d''un appareil photo numérique et avec l''aide de l''enseignant, les enfants peuvent facilement réaliser leurs propres puzzles.', 'puzzles', ' C. Vinent et P. thiollière', '0', '2006-07-20 23:09:39', NULL, NULL),
(181, 2, 'Encyclopédie de Cartable/net', 'http://cartables.net/links/Dictionnaires/Encyclopedies_atlas/', 'Différents liens vers des encyclopédies', 'encyclopédie;recherche', '', '0', '2006-07-21 15:18:09', NULL, NULL),
(137, 2, 'Un logiciel de géométrie GEOGEBRA', 'http://ww2.ac-poitiers.fr/math/spip.php?rubrique18', 'GeoGebra est un logiciel de géométrie dynamique.\r\nIl permet de construire des objets géométriques de deux façons différentes : par le biais de menus déroulants, ou par lignes de commandes à entrer dans une fenêtre de saisie. Tous les objets construits apparaissent de deux façons ce qui constitue la caractéristique principale du logiciel GeoGebra : à chaque expression de la &quot;fenêtre algébrique&quot; correspond un objet de la &quot;fenêtre géométrique&quot; et vice versa.\r\nOn peut ainsi très facilement à la souris ou au clavier animer ou modifier les différents objets construits : points, vecteurs, segments, droites, coniques, courbes de fonctions....\r\n', 'géométrie;logiciel:géométrie dynamique', 'Markus Hohenwarter', '0', '2006-07-20 23:06:53', NULL, NULL),
(131, 2, 'Programmations et progressions pour le CM2', 'http://www.scalpa.info/cm2.php', 'Programmations pour le CM2 avec des évaluations périodiques des compétences', '', '', '0', '2006-07-20 22:38:57', NULL, NULL),
(135, 2, 'Les difficultés en conjugaison', 'http://www.scalpa.info/orl_conj.php', 'Des mots croisés et des situations pour s''approprier la conjugaison des verbes.\r\nL''imparfait\r\nLes verbes en CER\r\n\r\nLes verbes en GER\r\n\r\n\r\nLes verbes en YER\r\n\r\n\r\nLes verbes en IER\r\n\r\nLe présent\r\nLes verbes en DRE\r\n\r\nLes verbes en NDRE\r\n\r\n\r\nLes verbes en IR\r\n\r\n\r\nLes verbes en OUDRE\r\n\r\nLe futur\r\nDes verbes de tous les groupes\r\n\r\n\r\n\r\nL''impératif présent\r\nDes verbes de tous les groupes\r\n\r\n\r\nLe conditionnel présent\r\nDes verbes de tous les groupes', 'conjugaison;présent:futur:imparfait;conditionnel;impératif', '', '0', '2006-07-20 22:50:40', NULL, NULL),
(129, 2, 'Outils pour la conjugaison', 'http://www.scalpa.info/orl_conj.php', 'Des outils en ligne dans la rubrique ORL, notamment des mots-croisés pour s''entraîner ou évaluer les connaissances en conjugaison. Utilisable au cycle 3\r\n\r\n\r\n', 'ORL;exercices,mots croisé, conjugaison', '', '0', '2006-07-20 20:27:39', NULL, NULL),
(130, 2, 'Programmations pour le CE1', 'http://www.scalpa.info/prog_ce1.php', 'Exemples de programmations au CE1 . Site SCALPA', 'programmation;CE1', '', '0', '2006-07-20 20:30:06', NULL, NULL),
(128, 2, 'Le système éducatif suisse', 'http://www.educa.ch/dyn/9.asp?url=73034%2Ehtm', '\r\n\r\nLa présentation sur educa.ch du système éducatif suisse, qui couvre toutes les étapes du jardin d''enfants à la formation spécialisée, a été actualisée par la Conférence des directeurs cantonaux de l''instruction publique (CDIP).\r\n\r\n\r\n', 'système éducatif;Suisse', '', '0', '2006-07-20 20:25:12', NULL, NULL),
(126, 2, 'Logiciels sur le vocabulaire', 'http://www.neroucheffmichel.be/html/vocabulaire.htm', 'Différents exercices en vocabulaire, le site propose même des activités dans beaucoup de discipline', 'Vocabulaires français sciences ', 'Michel Neroucheff', '0', '2006-07-20 20:10:04', NULL, NULL),
(120, 2, 'Histoire du cirque', 'http://perso.orange.fr/pg/cirque/histoire.htm', 'Texte informatif sur le cirque, son histoire au 18 ème et 19 ème siècle.', 'cirque; 18 ème siècle, 19 ème siècle ;lecture', '', '0', '2006-07-18 14:43:51', NULL, NULL),
(119, 2, 'Les arts du cirque en maternelle', 'http://ecoles.ac-rouen.fr/villages/pagecirq/somcirqu.htm', 'Un site pour les enseignants de l''école maternelle. Des pistes &quot;Des artistes à l''école: Marie et Isabelle&quot; avec des exemples de séance, le  cirque dans  l''art, l''art du maquillage , exemples de jeux de rôle,  exemple de spectacle en fin d''année\r\n	\r\n\r\n	\r\n\r\n	\r\n\r\n \r\n\r\n \r\n	\r\n\r\nSpectacle au gymnase', 'cirque;art;jeux de rôle;spectacle', '', '0', '2006-07-18 14:36:16', NULL, NULL),
(269, 2, 'Télé-formation en lecture', 'http://www.uvp5.univ-paris5.fr/TFL/TFL.asp', ' TFL » est un dispositif en ligne qui est conçu pour les professeurs des écoles, les étudiants d''IUFM, les éducateurs et parents, sur le thème de la lecture', 'lecture;télé-formation;TFL;Bentolila', 'Bentolila', '0', '2006-07-23 08:02:34', NULL, NULL),
(116, 2, 'Les jeux de Lulu-mathématiques', 'http://perso.wanadoo.fr/jeux.lulu/#outils', 'Autour des math...\r\n\r\n@ Le nombre mystérieux\r\n@ Le nombre mystérieux\r\n@ Même quantité *\r\n@ Les jetons\r\n@ La promenade des nombres * \r\n@ Où se cache Minou ?\r\n@ Tables de multiplication * *\r\n@ La pièce d''or\r\n@ Les quatre nombres *\r\n@ Le Taxateur \r\n', 'Tables;problèmes', '', '0', '2006-04-30 16:20:59', NULL, NULL),
(117, 2, 'Le cercle enchanté', 'http://station05.qc.ca/css/cercle/accueil.html', 'Le Cercle enchanté s''adresse à l''enfant de quatre et de cinq ans pour construire le  concept du nombre. \r\nComplice de deux personnages, Mélisse et Serpolet, qui vivent l''âge de l''imaginaire et du merveilleux, l''enfant passera naturellement de l''univers symbolique à celui des signes propres aux différents langages.\r\n\r\n', 'Contruction du nombres:numération', '', '0', '2006-04-30 16:27:54', NULL, NULL),
(114, 2, 'Tralalere le site musical des 3-10 ans', 'http://www.tralalere.com/', 'le site musical des 3-10 ans\r\n\r\ntralalere.com est un site ludo-culturel et musical destiné aux enfants, qui réunit une majorité d''artistes francophones. Adapté aux 3-10 ans par son ergonomie conviviale et animée, le site est personnalisé en fonction du profil de l''enfant.\r\n\r\n', 'musique, solfège,', '', '0', '2006-04-30 16:13:53', NULL, NULL),
(115, 2, 'Les jeux de Lulu', 'http://perso.wanadoo.fr/jeux.lulu/', 'Logique, stratégie;Autour du nombre;Des lettres, des mots...;Orientation, déplacement; \r\n Logique, stratégie;puzzles;mois de l''année;jeux\r\n\r\n@ Où se cache Tobi ? *\r\n@ Où se cache Babou ?\r\n@ Le bon ordre * *\r\n@ La guirlande de fleurs * \r\n@ Le bon rythme * *\r\n@ Qui manque ?\r\n@ Même chapeau, même forme ou même couleur *\r\n@ Et si on rangeait... * * * du nouveau\r\n@ Le mystère des coffres * *\r\n\r\nDes lettres, des mots...\r\n\r\n@ La promenade du prénom *\r\n@ Les abécédaires * * °\r\n@ Alphabet * * \r\n@ Lulu et le loup * \r\n@ Lili fait les courses *\r\n@ Memory * * °\r\n@ Pour qui...? (le jeu des rimes) * * °\r\n@ Quelques mots * * * °\r\n@ Paires : des animaux sauvages (niv. 3) *\r\n@ Le bon choix * * °\r\n@ Classement... * * °\r\n\r\nObservation\r\n \r\n\r\n ', 'Logique, stratégie,Autour du nombre, Des lettres, des mots...,Orientation, déplacement', '', '0', '2006-04-30 16:17:38', NULL, NULL),
(113, 2, 'Le petit chaperon rouge', 'http://divadesiles.free.fr/lePCRWEB.html', 'Histoire du chaperon rouge animée à l''écran', 'histoire;conte;chaperon rouge', '', '0', '2006-04-30 16:10:57', NULL, NULL),
(112, 2, 'Poisson rouge', 'http://www.poissonrouge.com/flash.htm', 'Un site pour aborder l''alphabet, la musique, les couleurs, les chiffres, des jeux en maternelle', 'l''alphabet, la musique, les couleurs, les chiffres, des jeux', '', '0', '2006-04-30 16:08:48', NULL, NULL),
(111, 2, 'Le petit déjeuner d''Ali', 'http://vbelmokhtar.free.fr/ali/page0.htm', 'Pour lire l''histoire d''Ali c''est très simple, dans chaque page qui apparaît à l''écran, clique sur un des objets animés et celui-ci te mènera à la page suivante de l''histoire. Attention, tous les objets ne marchent pas forcement, il faut trouver le bon !Pour commencer clique sur une des animations proposées\r\n\r\n', 'Petit Déjeuner;histoire animée', '', '0', '2006-04-30 16:04:01', NULL, NULL),
(109, 2, 'Tout un monde de gourmandises pour goûter les images', 'http://www.monde-gourmandises.net/accueil.htm', 'Image animée aves des objets relatifs à la cuisine', 'cuisine; images', '', '0', '2006-04-30 15:58:50', NULL, NULL),
(110, 2, 'Imagier de Pédagosite', 'http://pedagosite.net/archives/pedago_imagier.htm', 'Mes habits;Dans la salle de bains;Le coin du pâtissier;Les légumes; Instruments de musique à vent et percussions;Qu''est-ce qui roule ?Qu''y a-t-il dans la caisse à outils de papa ?\r\n', 'Imagier;thème; vêtements, musique;cuisine;outils', '', '0', '2006-04-30 16:01:59', NULL, NULL),
(108, 2, 'Tux Paint, un logiciel pour dessiner', 'http://www.logiciels-libres-tice.org/spip.php?article44', 'Tux Paint peut être utilisé pour apprendre aux jeunes enfants à dessiner avec un ordinateur. Une aide contextuelle est apportée par un petit Tux (pingouin mascotte) qui distille (à l’écrit, en bas de la zone de dessin) des explications sur les différentes fonctions, ainsi que des encouragements. La zone de dessin est fixe. On peut faire du dessin libre en variant l’épaisseur du trait, les couleurs.On peut sélectionner différentes formes géométriques prédéfinies, inclure du texte, On peut aussi utiliser des effets spéciaux : mosaïque, miroir (afin de pouvoir introduire la symétrie en mathématiques), négatif, arc-en-ciel, étincelles, ...\r\nTutoriels et exemples de scénarios pédagogiques\r\n\r\n', 'dessiner;Braque;effet miroir', 'Bill Kendrick', '0', '2006-04-26 22:18:29', NULL, NULL),
(106, 2, 'réaliser des animations en pâtes à modeler', 'http://www.logiciels-libres-tice.org/spip.php?article475', 'Présentation d’un projet de réalisation d’animations avec I-Movie au cycle 3. \r\n', 'animations, pâtes à modeler;I-Movie', 'Apple', '0', '2006-04-26 22:10:43', NULL, NULL),
(107, 2, 'The Gimp', 'http://www.logiciels-libres-tice.org/spip.php?article128', 'The Gimp (Gnu Image Manipulation Program) est un logiciel de traitement de l’image (retouche et création) comparable au logiciel commercial Adobe Photoshop. Présentation de tutoriels, de guides, de scénarios pour le cycle 3 et collège.', 'Traitement de l''image;tutoriel;', 'Gimp;espace 1 degré;trairement images', '0', '2006-04-26 22:14:21', NULL, NULL),
(105, 2, 'Paint Net un logiciel  libre pour dessiner', 'http://www.logiciels-libres-tice.org/spip.php?article359', 'Logiciel de retouche d''image gratuit et simple à utiliser . &quot;Il existe l''excellent Gimp mais son interface assez complexe n''est pas forcément indiquée pour un non initié. Paint.NET pourrait bien être la perle rare. Démarré comme un projet universitaire par deux diplomés de l''université de l''Etat de Washington, Paint.NET est en quelque sorte une version (très) améliorée du Paint de Microsoft avec quelques idées empruntées à Photoshop&quot;. Critique de Clubic.', 'dessiner; logiciels', '', '0', '2006-04-26 22:08:29', NULL, NULL),
(103, 2, 'Open Clip Art Library', 'http://www.logiciels-libres-tice.org/spip.php?article304', 'Open Clip Art Library est un projet qui a pour objectif de regrouper des Clip Art librement utilisables par tous et toutes (puisque sous licence Creative Commons Domaine Public). Vous pouvez télécharger 6900 cliparts s’intégrant parfaitement à la suite bureautique Open Office2.0.\r\n\r\n', 'Clip Art;images libres', 'Andreas Nilsson', '0', '2006-04-26 21:59:59', NULL, NULL),
(102, 2, 'figurine -Le logiciel  pour l''initiation au dessin vectoriel', 'http://www.logiciels-libres-tice.org/spip.php?article72', 'Un outil pédagogique à destination des plus jeunes. Ils y apprendront les concepts du dessin vectoriel ', 'dessin; logiciel', 'John Levon', '0', '2006-04-26 21:54:16', NULL, NULL),
(101, 2, 'Créer et projeter des cartoons simples en ligne', 'http://www.logiciels-libres-tice.org/spip.php?article312', 'Description du site de création et de projection de cartoons simples\r\nChaque élève peur accéder à sa cartoonerie.   Un espace &quot;personne&quot; pour les créateurs de la &quot;cartoonerie&quot;. On y accède avec un pseudo et un mot de passe.  les élèves peuvent créer des caartoos, accéder aux ateliers de création et diffuser ses propres créations. Chaque élève peut interagir et se tenir informé,   partager les communications sur les films des autres camarades créateurs.  Chaque élève peut être aidé dans ses manipulations - Messagerie d’aides.\r\n', 'cartoons, dessins animés', 'Auteur Cartoon', '0', '2006-04-26 21:52:48', NULL, NULL),
(99, 2, 'PrimTICE', 'http://bd.educnet.education.fr/urtic/primtice/', 'Base d''usages pédagogiques des TIC dans l''enseignement primaire', 'usages, pédagogiques, primtice, base, TICE, primetic, primetice', 'Ministère de l''Education Nationale', '0', '2006-04-04 14:09:57', NULL, NULL),
(100, 2, 'Cinéma d''animation avec StopMotion', 'http://www.logiciels-libres-tice.org/spip.php?article314', 'Présentation du logiciel libre StopMotion.  Scénarios pédagogiques pour aborder le cinéma d''animation au cycle 3', 'cinéma d''animation;scénarios;logiciel', 'Groupe StopMotion', '0', '2006-04-26 21:49:27', NULL, NULL),
(97, 2, 'Base de livres de littérature Jeunesse 2004 ( complément à la liste de 2002)', 'http://dan.gros.free.fr/litterature/litter01.html', 'Liste des ouvrages à lire à l''école', 'littérature, liste ouvrages, programmes 2002', 'DESCO', '0', '2006-03-29 20:39:42', NULL, NULL),
(98, 2, 'PrimLangues', 'http://www.primlangues.education.fr', 'PrimLangues, un portail et un site de ressources propres pédagogiques pour l''enseignement des langues dans le primaire : des ressources diversifiées, accompagnées de commentaires (textes officiels, ouvrages de références, sitographies ...) et des propositions de séquences pédagogiques.', 'langue, allemand, anglais, arabe, espagnol, russe, portugais, italien', 'Ministère de l''Education Nationale', '0', '2006-04-04 10:23:15', NULL, NULL),
(94, 2, 'Des outils pour mieux relire les énoncés de problèmes', 'http://dan.gros.free.fr/mathalire/lire_relire.html', 'Des outils pour aider à la relecture des problèmes.', 'Problèmes, lecture énoncé, résolution', 'Daniel Gros', '0', '2006-03-29 18:30:20', NULL, NULL),
(95, 2, 'Mathalire, pour des résolutions de problèmes', 'http://dan.gros.free.fr/mathalire/classes/pbeleves.html', 'Des élèves ont rédigé des problèmes et ont préparé des aides intermédiaires', 'Problème, résolution, aides', 'Daniel Gros', '0', '2006-03-29 18:33:20', NULL, NULL),
(96, 2, 'Programmer la littérature Jeunesse du Cycle 1 au cycle 3', 'http://dan.gros.free.fr/litterature/Programr.htm', 'Des &quot;jalons&quot; pour aborder la littérature Jeunesse à l''école', 'progression, littérature Jeunesse', 'Daniel Gros', '0', '2006-03-29 20:36:56', NULL, NULL),
(91, 2, 'Fiches pour le développement durable', 'http://dan.gros.free.fr/ddurable/exposition_eedd_fiches.htm', 'Fiche pour le développement durable à l''école ', 'Ecologie, développement durable, DD', 'DESCO', '0', '2006-03-29 18:10:09', NULL, NULL),
(90, 2, 'Littérature au cycle 3', 'http://eduscol.education.fr/D0102/biblio.htm', 'Liste de référence des ouvrages à lire au cycle 3 ', 'littérature, liste ouvrages', 'DESCO', '0', '2006-03-29 18:06:42', NULL, NULL),
(88, 2, 'Calcul mental pour les nombres décimaux', 'http://dan.gros.free.fr/logiciels/Nb_decim.html', 'Pour s''exercer au calcul mental sur les décimaux au cycle 3. (surtout CM1 et CM2)\r\nBasé sur le principe de &quot;l''excellence&quot; (on ne passe que si on fait un sans-faute) il demande une forte concentration.\r\n\r\n', 'Calcul mental, nombres décimaux', 'Daniel Gros', '0', '2006-03-29 17:49:58', NULL, NULL),
(89, 2, 'Logiciel de logique', 'http://dan.gros.free.fr/logiciels/Enigmes.html', '10 niveaux progressifs d''énigmes &quot;topologiques&quot; qui doivent être résolues de manière logique et déductive. La mémorisation du parcours est parfois nécessaire (intéressant au niveau de &quot;l''imagerie mentale&quot;). L''esthétique est simple et explicite. Tous niveaux à partir de la GS.\r\n', 'Logique, déduction, problèmes, mémorisation', 'Daniel Gros', '0', '2006-03-29 17:54:04', NULL, NULL),
(87, 2, 'Logiciel Calcul Mental au cycle 3', 'http://dan.gros.free.fr/logiciels/Calcul_mental.html', 'Cycle 3, 39 niveaux de calcul mental sur les nombres entiers.\r\n\r\nPour s''exercer au calcul mental au cycle 3. (surtout CM1 et CM2)\r\nBasé sur le principe de &quot;l''excellence&quot; (on ne passe que si on fait un sans-faute) il demande une forte concentration.\r\n\r\n', 'Calcul mental', 'Daniel Gros', '0', '2006-03-29 17:15:28', NULL, NULL),
(86, 2, 'Logiciel pour faire des associations', 'http://dan.gros.free.fr/logiciels/Paires.html', 'Cycle 3, tout ce qui va par 2 se mélange, il faut réorganiser les paires. (Jusqu''à 15 paires).\r\nUn logiciel ouvert qui permet de mettre par deux des étiquettes. (Il ne fait rien sans les exercices que vous y rentrerez ! Un éditeur est fourni dans le logiciel.)\r\nExemples : 2 identiques (lettres, mots, signes...) 2 complémentaires (nombres, objets, sujet + verbe...) 2 contraires, 2 accords, 2 événements (une date et un événement, un pays et sa capitale...), un mot et sa traduction (voir exemple pour collège sur les verbes irréguliers)\r\n\r\nEn verrouillant l''ordre, on peut reconstituer un texte puzzle. En changeant l''ordre des paires, on peut jouer sur l''effet &quot;thème / version&quot;... On peut répondre en cliquant sur la proposition ou en tapant au clavier.\r\n\r\nJusqu''à 15 paires simultanées, les élèves peuvent faire les exercices eux-mêmes pour leurs camarades.\r\n\r\n', 'Association d''idées, exerciseurs', 'Gros', '0', '2006-03-29 17:03:33', NULL, NULL),
(85, 2, 'Logiciel pour réviser les tables', 'http://dan.gros.free.fr/logiciels/Tables.html', 'Pour s''exercer aux tables (ou s''évaluer).Cycles 2-3, entraînement personnel de l''élève sur les tables de son choix.\r\nCe programme permet de choisir le type d''opération voulu, la table à travailler (ou l''ensemble des tables)\r\nIl donne un bilan de travail effectué.\r\nTable d''additions, de multiplications, de soustractions, de divisions\r\n', 'tables, mathématiques, tables d''addition, tables de multiplications, tables de soustraction', '', '0', '2006-03-29 17:00:14', NULL, NULL),
(84, 2, 'Logiciels Puzzles (cycle 2 et 3)', 'http://dan.gros.free.fr/logiciels/Puzzle.html', 'Puzzle (cycles 2 et 3)\r\n\r\nUn logiciel qui permet de faire réaliser des puzzles géométrique progressifs.\r\n\r\nPas d''installation : copier le dossier complet sur le disque dur, et lancer\r\n\r\nSuivi de l''élève (cycles 2 et 3)\r\n\r\n3 formulations de réussite possibles, 4 pages à ne pas donner d''un coup !\r\n', '', '', '0', '2006-03-29 16:38:57', NULL, NULL),
(83, 2, 'Logiciel Association d''idées', 'http://dan.gros.free.fr/logiciels/Paires_CP.html', 'Faire des associations \r\nCycle 2, tout ce qui va par 2 se mélange, il faut réorganiser les paires. (Jusqu''à 9 paires, utilisation possible de police cursive).Un logiciel ouvert qui permet de mettre par deux des étiquettes. (Il ne fait rien sans les exercices que vous y rentrerez ! Un éditeur est fourni dans le logiciel.)\r\nL''écriture est plus grosse que dans &quot;paires&quot;, et un menu permet de changer la graphie (cursive ou scripte) : on peut mettre 2 mots identiques, script à gauche et cursive à droite...\r\nExemples : 2 identiques (lettres, mots, signes...) 2 complémentaires (nombres, objets, déterminant + nom...) 2 contraires, 2 accords, 2 événements (associations d''idées), un titre de livre et le héros principal...\r\nJusqu''à 9 paires simultanées, les élèves peuvent faire les exercices eux-mêmes pour leurs camarades.\r\n\r\n', 'Association, lecture, logique', '', '0', '2006-03-29 16:35:11', NULL, NULL),
(81, 2, 'Logiciel Egal', 'http://dan.gros.free.fr/logiciels/egal.html', 'Logiciel gratuit permettant de comparer des quantités au cycle 1', 'nombres, numération, collection, comparer', '', '0', '2006-03-29 16:27:37', NULL, NULL),
(82, 2, 'Logiciel FicheMot', 'http://dan.gros.free.fr/logiciels/Fichmot.html', 'Cycle 2 rentrez vos phrases, le logiciel fabrique des jeux sur les lettres, mots, phrases. Logiciel ouvert, utilisable de la MS au CE1 (il ne fait rien sans VOS textes) qui permet de faire les 9 &quot;jeux&quot; annoncés (très progressifs, les derniers sont difficiles) à partir des phrases rentrées (au moins 3 phrases de 4 mots, un éditeur de fichiers est intégré)\r\n\r\n', 'Exercices, phrases, lectures, mots', '', '0', '2006-03-29 16:30:17', NULL, NULL),
(78, 2, 'Les mystères du corps humain', 'http://www.corps.dufouraubin.com/home.htm', 'Vous le côtoyez tous les jours, ce corps. Mais, vous êtes-vous déjà demandé les nombreux &quot;comment&quot; et &quot;pourquoi&quot;? Comment la nourriture se transforme dans votre système digestif? Comment pouvez-vous apercevoir ce qui se trouve près de vous? Pourquoi avons-nous besoin de respirer? Comment bébé se transforme dans le ventre de maman?\r\nDocuments  : schéma à compléter, résumé à retenir, évaluation.\r\n', 'Système respiratoire, système digestif,', 'bouche, mastication, aliments, salive,œsophage, estomac, sucs digestifs, intestin', '0', '2006-03-29 00:11:47', NULL, NULL),
(80, 2, 'Utiliser le CLIC  de l''ordinateur', 'http://dan.gros.free.fr/logiciels/Clic.html', 'Cycles 1-2, apprendre le clic, le double clic et le clic-glissé. Savoir les utiliser avec initiative.\r\n', 'souris,clic,ordinateur,logiciel', '', '0', '2006-03-29 16:22:36', NULL, NULL),
(77, 2, 'Dents et caries', 'http://www.dentalespace.com/patient/carie0.htm', 'Documents  : documents sur la carie dentaire, schémas de la mâchoire, fiche d''activité, résumé à retenir, évaluation.\r\n', 'incisives, canines, molaires, dentition, couronne, racine, émail, gencive, nerfs, l''os de la mâchoir', 'Dentalspace', '0', '2006-03-29 00:08:15', NULL, NULL),
(73, 2, 'Banques d''images de la NASA', 'http://photojournal.jpl.nasa.gov/index.html', 'Site - Banques d''image de la Nasa', 'Astronomie, Nasa', 'Nasa', '0', '2006-03-28 23:55:35', NULL, NULL),
(74, 2, 'Animation sur les marées', 'http://www.sciences.univ-nantes.fr/physique/perso/cortial/bibliohtml/phaslu_j.html', 'Documents  : texte avec dessins, schémas, explications, fiche enquête, résumé à retenir.\r\n', 'Terre, Soleil, Lune, marée, astre, rotation, attraction, phases, croissant, pleine lune, nouvelle lu', '', '0', '2006-03-28 23:58:04', NULL, NULL),
(75, 2, 'Cours sur les marées', 'http://www.ifremer.fr/lpo/cours/maree/forces.html', 'Textes sur les marées', 'marées, astronomie', '', '0', '2006-03-28 23:59:55', NULL, NULL),
(76, 2, 'Hygiène alimentaire', 'http://www.hygiene-educ.com/fr/profs/alimentaire/alimentaire.htm', 'Site éducatif sur l''hygiène proposé par l''institut Pasteur \r\nLivret du maître- De nombreuses activités - Fiches d''activités pédagogiques', 'Hygiène,alimentation,jeux, fiches pédagogiques', 'Institut Pasteur', '0', '2006-03-29 00:04:10', NULL, NULL),
(71, 2, 'Logiciels et  traitement de textes pour les 5 à 8 ans', 'http://pnoguer.free.fr/', 'Logiciels pour les écoles maternelle', 'logiciel, maternelle, cycle2', '', '0', '2006-03-28 23:44:23', NULL, NULL),
(72, 2, 'Le système solaire', 'http://membres.lycos.fr/stefg1971/systeme/systeme.htm', 'Documents \r\nComposition du système solaire - Soleil - Planètes\r\nDonnées sur planètes - Comparons les planètes - Lune La Voie Lactée \r\nTour interactif du système solaire ', 'Composition du système solaire - Soleil - Planètes', '', '0', '2006-03-28 23:53:03', NULL, NULL),
(66, 2, 'Documents sur le moyen âge', 'http://adminet.com/moyenage.html#autres', 'Textes et documents sur le moyen âge', 'moyen âge', '', '0', '2006-03-28 23:15:44', NULL, NULL),
(67, 2, 'Logiciel d''apprentissage de la musique', 'http://www.musimos.com', 'Logiciel payant pour apprendre la musique', 'logiciel, musique, solfège', '', '0', '2006-03-28 23:23:10', NULL, NULL),
(68, 2, 'Happy note', 'http://www.happynote.com', 'En téléchargeant un jeu video educatif Happy Note! vous ou votre enfant allez  apprendre le solfège ', 'musique, solfège, jeu vidéo', '', '0', '2006-03-28 23:25:33', NULL, NULL),
(62, 2, 'Jeux pédagogiques', 'http://www.ccdmd.qc.ca/fr/jeux_pedagogiques/?id=83', 'Site canadien avec de nombreux jeux en ligne', 'Français, jeux, compréhension, orthographe', '', '0', '2006-03-28 22:55:53', NULL, NULL),
(56, 2, 'Coopés  copains - Une action citoyenne autour de la sécurité routière', 'http://www.occe.coop/occemod/copcop/cc42/index.htm', 'Projet ', '', '', '0', '2006-03-18 19:27:46', NULL, NULL),
(267, 2, 'Programmes de langues vivantes', 'http://www.education.gouv.fr/bo/2002/hs4/default.htm', 'BO de 2002 LANGUES ÉTRANGÈRES OU RÉGIONALES À L''ÉCOLE PRIMAIRE', 'langues vivantes;textes', 'Education nationale', '0', '2006-07-22 23:30:10', NULL, NULL),
(55, 2, 'Site de l''office central de la coopérative de l''école', 'http://www.occe.coop/federation/index.htm', 'L’Office Central de la Coopération à l’Ecole pour enseigner  dès l’école, les principes et les vertus de la Coopération. S’appuyant sur un certain nombre de spécificités directement issues de la doctrine coopérative et associative (l’aide, l’entraide, le tutorat, la cotisation volontaire, le projet, le conseil de coopérative, par exemple).', 'OCCE, coopérative, conseils', 'OCCE', '0', '2006-03-18 18:59:54', NULL, NULL),
(54, 2, 'La convention internationale des droits de l''enfant', 'http://www.occe.coop/federation/nos-actions/droits-de-lenfant', 'Parue dans le n°187-188 de la revue Animation &amp; Education, ce document, présente à l''enseignant et à l''élève, les Droits de l''Enfant en s''appuyant sur la CIDE. Cette fiche propose quelques repères et pistes, pour que la classe devienne un lieu où les élèves s''approprient leurs droits.', 'Citoyenneté, droits enfants, OCCE', 'OCCE', '0', '2006-03-18 18:54:59', NULL, NULL),
(51, 2, '1, 2, droits... La Convention Internationale des Droits de l’Enfant entre à l’école...', 'http://www.occe.coop/federation/nos-actions/droits-de-lenfant', 'Parue dans le n°163-164 de la revue Animation &amp; Education, cette fiche reprend point par point les articles de la CIDE en lien avec les Instructions Officielles. A chaque article de la CIDE correspond une liste d''activités ou de dispositifs coopératifs pour la classe. \r\n', 'Droits enfant, citoyenneté, OCCE', 'OCCE', '0', '2010-03-16 18:43:21', NULL, NULL),
(49, 2, 'Charte de la coopération à l''école', 'http://www.occe.coop/federation/nous-connaitre/la-pedagogie-coop/64-lire-la-charte-de-la-cooperation', 'Apprendre et vivre coopérativement. Document élaboré par l''OCCE', 'Charte, coopération, OCCE', 'OCCE', '0', '2010-03-16 18:37:13', NULL, NULL),
(47, 2, 'Jardinons à l''école- Un catalogue de matériel et de fiches', 'http://www.gnis.fr/index/action/page/id/502/title/Les_conseils_pour_reussir_la_culture_des_legumes', 'Des fiches pratiques pour jardiner, pour échanger des expériences sur le thème du &quot;jardin&quot;, pour obtenir des conseils et des astuces autour du jardinage, des dossiers pour développer des projets pédagogiques autour du thème des jardins.', 'Jardin, école, fiche, projet', '', '0', '2006-03-18 18:26:30', NULL, NULL),
(45, 2, 'Histoire de notre jardin', 'http://www.etab.ac-caen.fr/montchamp/jardin/histoire.htm', 'L''école de Montchamps raconte en images et en photos, l''histoire de leur jardin à l''école', 'jardin, école,', 'Ecole de Montchamps', '0', '2006-03-18 18:07:19', NULL, NULL),
(46, 2, 'Jardinons à l''école, un site didactique pour aborder le jardinage à l''école', ' http://www.jardinons-alecole.org/pages/enfants.asp', 'Un site pour aborder le jardinage à l''école. Méthodologie, comment démarrer un jardin à l''école, des actions pédagogiques, un coin pour les enfants. Lancement d''un concours pour les élèves en partenariat avec le ministère de l''éducation nationale. \r\nUn forum de discussion est intégré à ce site : utilisez-le pour échanger avec vos collègues des idées, des experiences, des interrogations. De plus vous pourrez, avec les jardithèques, bénéficier de l''expérience accumulée par de très nombreux enseignants qui décrivent les prolongements pédagogiques qu''ils ont réalisés à partir de l''activité de jardinage\r\nAteliers pédagogiques \r\n\r\nAtelier 1 : Au cœur des fleurs\r\nAtelier 2 : Le cycle de vie d''une plante\r\nAtelier 3 : A la découverte des fruits et légumes\r\nAtelier 4 : La découverte des différents types de sol\r\nAtelier 5 : La découverte des outils pour jardiner\r\nAtelier 6 : La plantation de fleurs\r\nAtelier 7 : Les semis de légumes\r\nAtelier 8 : La réalisation de jardinières fleuries\r\nAtelier 9 : La réalisation de compositions florales\r\nAtelier 10 : Education sensorielle avec les plantes aromatiques \r\n  \r\n  \r\n', 'Jardin, école, fruits, légumes, fleurs', 'Pas défini. Opération soutenue par le Ministère', '0', '2006-03-18 18:21:13', NULL, NULL),
(42, 2, 'Les couleurs de l''orchestre', 'http://www.capcanal.com/couleurs/index.htm', 'Les instruments et leurs épisodes, les choeurs et les épisodes,une encyclopédie musicale, l''opéra et Verdi.\r\nInstruments de musique, violon, flûte, Contrebasse, Violoncelle,Violon Alto, Hautbois,Clarinette, Trompette, Percussions, Cor\r\n\r\nVidéos, Vocabulaire, et jeux pour tous les instruments de musique.', 'Instruments de musique, violon, flûte, Contrebasse, Violoncelle,Violon Alto, Hautbois,Clarinette', 'Eva Martínez i Carrasco (CAP CANAL) http://www.capcanal.com/couleurs/credits.htm', '0', '2006-03-16 14:44:06', NULL, NULL),
(41, 2, 'L''art en s''amusant', 'http://www.bemberg-educatif.org/index.html', 'Les enfants exposent leurs œuvres ou vous présentent leur création \r\n\r\nA travers le parcours jeu « le monde du tableau », les enfants découvrent « la recette » des peintres. Espace, composition, lumière, couleurs, touche… n’ont plus de secrets. En atelier, les ingrédients sont là. La feuille blanche se transforme en une marine vivante et colorée. Bonne activité des élèves.\r\n\r\n ', 'Le portrait, scènes de genre, nature morte, histoire de la peinture', 'Fondation Bemberg', '0', '2006-03-16 14:33:19', NULL, NULL),
(40, 2, 'Club Ludo de France 5', 'http://www.mon-ludo.fr/', 'Jouer avec les couleurs, les techniques, les histoires de tableaux. Découvrez les peintres des musées.\r\nNicolas Poussin, Henri Rousseau, Marc Chagall, Paolo Ucello, Georges de la Tour, Jean Siméon Chardin, Georges Seurat, Claude Monet, Louise Moillon, Henri Matisse, Giuseppe Arcimboldo', 'Couleurs, techniques, histoires arts, tableaux, peintres', 'France 5', '0', '2010-03-16 14:20:21', NULL, NULL),
(39, 2, 'Annuaire de NAVIKID - Un site pour les kids de 8 à 15 ans', 'http://www.navikid.net/index.html', 'L''Annuaire de NAVIKID est réservé aux sites ayant un rapport direct avec les enfants de 8 à 14 ans. Si vous voulez enrichir la liste déjà existante, allez dans [Ajouter Site]. Le Webmaster de Navikid se réserve néanmoins le droit de retenir le site ou les sites que vous proposez.', 'Annuaire sites', '', '0', '2006-03-16 14:04:26', NULL, NULL),
(36, 2, 'Documents en zoologie de Jussieu', 'http://www.snv.jussieu.fr/bmedia/sommaires/zool.htm', 'Petit Buffon électronique -\r\nDu blé au pain - Pollinisation -Les fruits -De l''oeuf à la grenouille-de l''oeuf à la poule -', 'Du blé au pain - Pollinisation -fruits -''oeuf grenouille-oeuf poule', 'Université Jussieu', '0', '2006-03-16 13:37:50', NULL, NULL),
(38, 2, 'Palais de la découverte - Le coin des Juniors', 'http://www.palais-decouverte.fr/menucoin.htm', ' Expériences -  Animations -  Fiches - Ateliers - Exposés &quot;jeunes&quot; - Jeux / énigmes - Portraits de savants -Exposés\r\n      \r\n', 'Expériences, Animations , Jeux, exposés', 'Palais de la découverte', '0', '2006-03-16 13:55:05', NULL, NULL),
(35, 2, ' A la découverte de l''histoire de France', 'http://chrisagde.free.fr/index.htm', 'Informations et documents sur les différentes périodes de l''histoire.\r\nMérovingiens,carolingiens, capétiens, Valois,Bourbons, Restauration, empire, 1870-1914,1914-1936', 'Mérovingiens,carolingiens, capétiens, Valois,Bourbons, Restauration, empire, 1870-1914,1914-1936', '', '0', '2006-03-16 13:31:05', NULL, NULL),
(34, 2, 'Atlas géographique mondial', 'http://www.atlasgeo.net/_index.htm', 'Vous trouverez sur ce site chaque pays classé d''abord par continent,puis par ordre alphabétique. En suivant les différents liens,situez-les à l''aide des cartes et découvrez leurs drapeaux,leurs hymnes, leurs armoiries et leurs fiches descriptives.Une photo de chaque pays ou territoire est également disponible par simple clic sur le nom du pays (entre les deux drapeaux).\r\n\r\n', 'Atlas,géographie, cartes, drapeaux, hymnes, fiches pays,photos pays', 'Pascal Gross-Montreux Switzerland', '0', '2006-03-16 13:23:41', NULL, NULL),
(33, 2, 'le chat bleu', 'http://www.chatbleu.com/', 'CP :  \r\nRepérages-Deplacements-Comparer-Les nombres jusqu''à 10 -Additions -Les formes  \r\n\r\nCE :  \r\nAdditions -Repérages -Lire l''heure -Tables d''addition -Tables de multiplication  \r\n\r\nCM: Les fractions - Lire l''heure  \r\n\r\n', 'Repérages-Deplacements-Comparer-Les nombres jusqu''à 10 -Additions -Les formes -Additions -Repérages', '', '0', '2006-03-16 12:07:24', NULL, NULL),
(31, 2, 'Le jeu de l''oie', 'http://jeudeloie.free.fr/plateau.htm', 'Un jeu de l''oie permettant des révisions par niveau sur différents champs des programmes 2002 ( conjugaison, vocabulaire, grammaire)', 'grammaire,vocabulaire,conjugaison,révision, soutien', 'Perrot Thierry', '0', '2006-03-16 11:53:18', NULL, NULL);
INSERT INTO `module_ressource_ressources` (`id`, `id_annu`, `nom`, `url`, `description`, `mots`, `auteur`, `submit_user`, `submit_date`, `valid_user`, `valid_date`) VALUES
(32, 2, 'Les champions des mathématiques', 'http://championmath.free.fr/', 'S''entraîner pour devenir &quot;champion des maths&quot;. ', 'mathématiques,entraînement, révision,', 'Laurent Monot', '0', '2006-03-16 11:56:28', NULL, NULL),
(29, 2, 'LEXILOGO - Dictionnaire français', 'http://www.lexilogos.com/francais_langue_dictionnaires.htm', 'Ensemble de dictionnaires et de correcteurs ', 'dictionnaires, correcteurs orthographiques', 'Xavier Nègre', '0', '2006-03-16 11:39:56', NULL, NULL),
(28, 2, 'Des sites d''écoles faits par des enfants d''écoles primaires', 'http://cartables.net/ecoles/dept.php', 'Portail de sites d''écoles abordant différents thèmes', 'sites écoles', 'Cartable.net', '0', '2010-03-16 11:33:52', NULL, NULL),
(26, 2, 'B2I - informations officielles', 'http://eduscol.education.fr/cid46073/b2i.html', 'Définition, liste des compétences requises, foire aux questions... Le site Eduscol expose en détails le B2I (Brevet Informatique et Internet)', 'B2I brevet informatique internet compétence', 'Direction de l''enseignement scolaire - ministère de l''éducation nationale', '1', '2010-04-05 13:37:17', NULL, NULL),
(23, 2, 'Portail de la Pédagogie Freinet', 'http://www.icem-pedagogie-freinet.org/', 'L’Institut Coopératif de l’École Moderne – pédagogie Freinet propose un portail complet sur la pédagogie Freinet.', 'freinet pédagogie frénet freynet freynais frénais', 'ICEM', '1', '2005-11-22 17:52:17', NULL, NULL),
(618, 2, 'Site sur l''art roman pour le cycle 3', 'http://www.art-roman.net/', 'Tu peux découvrir sur ce site région par région, toutes les principales églises romanes de France, puis d''Europe, telle est l''ambition du site art-roman.net. ', 'histoire;moyen-âge;églises;art;roman;lecture', 'art-roman.net', '0', '2006-08-03 08:35:44', NULL, NULL),
(19, 2, 'Découvrir le journal par les 5 sens', 'http://gommegribouillages.free.fr/Sens.htm', 'Une fiche pédagogique qui utilise le support du journal papier pour faire découvrir les différents sens des enfants.', 'journal sens toucher ouïe vision', 'LiL''hobs', '1', '2005-11-21 18:56:34', NULL, NULL),
(857, 2, 'Happy Note! pour apprendre le solfège', 'http://www.happynote.com/', 'En téléchargeant un jeu video educatif Happy Note! vous ou votre enfant allez - enfin ! - apprendre le solfège sans devoir appréhender l''heure du cours de musique ! Happy Note! Lecture Musicale Clé de Sol et Clé de Fa. Un jeu video pour apprendre à lire la musique en s''amusant cours de solfege\r\nConçu par des professionnels de l''enseignement musical, chaque logiciel de musique Happy Note! est un vrai jeu vidéo (score, vies, dynamite, cartoon, Hi-Score, etc.), à la fois ludique et pédagogique.\r\nJeu pour les écoles de musique ou des activités après la classe. ( Le solfège ne fait pas partie des programmes 2002)', 'solfège;musique;logiciel', '', '0', '2006-08-27 00:10:37', NULL, NULL),
(859, 2, 'Logiciels pour traiter le MP3', 'http://www.zicweb.com/scripts/get.php?lg=fr&amp;i=29', 'OUTILS MP3\r\nVous trouverez ici tous les outils permettant la création, la manipulation, la conversion et la diffusion de mp3. ', 'MP3;sons;musique', 'zicweb.com', '0', '2006-08-27 00:19:11', NULL, NULL),
(860, 2, 'Du jazz pour les petits', 'http://dujazzpourlespetits.free.fr/', '#\r\nEnregistrer avec des enfants de CM1 non-sélectionnés en fonction de leurs compétences musicales un CD de qualité sur des musiques jazz, blues, swing, et bossa.\r\n# Faire écrire aux 51 enfants (30 garçons et 21 filles) les paroles de plusieurs chansons ( le blues des examens, j''ai pas fait mes devoirs, le blues des sports )\r\n#\r\nRencontrer des musiciens professionnels, les côtoyer, et SURTOUT : prendre du plaisir à jouer et chanter ENSEMBLE.', 'musique;jazz;production', 'charromero&quot;@rogers.com;j.lepeintre@free.fr', '0', '2006-08-27 00:23:19', NULL, NULL),
(861, 2, 'Musenvol un logiciel en ligne pour la musique', 'http://www.musenvol.com/', 'Des activités autour des instruments de musique.\r\nD''amusantes activités musicales pour les élèves du primaire et d''utiles outils pédagogiques pour les pédagogues.', 'musique;instruments', 'Éditions de l''Envolée', '0', '2006-08-27 00:27:09', NULL, NULL),
(863, 2, 'Sites pour l''éducation à l''image', 'http://crdp.ac-besancon.fr/index.php?id=2138', 'Une page du CRDP de Besançon.', 'images;médias', 'images', '0', '2006-08-27 09:32:33', NULL, NULL),
(864, 2, 'Les photos des pages jaunes', 'http://photos.pagesjaunes.fr/', 'Les &quot;pages jaunes&quot; offrent la possibilité de voir la photo de son immeuble, de son école... en se déplaçant sur un plan. Activité possible : refaire virtuellement le trajet de son domicile à l''école. Pour obtenir une photo, choisissez une ville, entrez un numéro et une rue, puis cliquez sur &quot;rechercher&quot;.Ou bien cliquez directement sur une ville de la carte de France\r\n', 'géographie;plan;villes', 'pages jaune', '0', '2006-08-27 09:38:25', NULL, NULL),
(876, 2, 'Le logiciel lectra', 'http://www.lectramini.com/lectra.htm', 'Shareware français.Didacticiel d''entraînement à la lecture basé sur une série d''exercices générés automatiquement par le programme. Logiciel ouvert: les textes utilisés sont saisis par l''enseignant. \r\nLogiciel ouvert : les textes utilisés sont saisis par l’enseignant. Dans la version enregistrée, l’utilisateur peut personnaliser les fichiers des mots Intrus. Suivi personnalisé des résultats de l’élève.Exercices proposés : closure, reconstitution, mots outils, mots éclairs, phrase mélangée, phrase incomplète, phrase sans espaces, lecture rapide, mots identiques, l’intrus, ordre alphabétique, memory (images), memory (mots), texte mélangé, texte à corriger.\r\n', 'lecture;logiciel;cycle2;cycle3', 'Michel Brun', '0', '2006-08-27 10:23:35', NULL, NULL),
(877, 2, 'Le logiciel Lectra-Mini pour le cycle 1 et le cycle 2', 'http://www.lectramini.com/atelier.htm', 'Utilisable à partir de la Grande Section de maternelle et du CP ce didacticiel d’entraînement à la lecture est basé sur une série d’exercices générés automatiquement par le programme. Ce logiciel est ouvert : L’enseignant saisit les textes de son choix et ajoute des images s’il le souhaite. C’est un excellent complément à une lecture d’albums.\r\n', 'logiciel;lecture;maternelle;CP;GS;albums', 'BRUN-VILLANI', '0', '2006-08-27 10:26:23', NULL, NULL),
(878, 2, 'Un logiciel pour le cycle 1 et le cycle 2 : La ligne magique', 'http://www.tomcatsoft.com/products/lignemagique/index.html', 'Ludo-Educatif pour apprendre aux enfants de plus de 5 ans à compter, à colorier et à utiliser la souris.\r\nL''enfant doit relier les points consécutifs pour découvrir une image.Il peut alors la colorier.\r\nIl est possible d''imprimer l''image de points, l''image finale ou l''image finale coloriée.\r\nLes images peuvent être affichées de façon aléatoire ou linéaire.\r\nAide en ligne complète.\r\n', 'logiciel;numération', 'Tom Cat Soft', '0', '2006-08-27 10:28:29', NULL, NULL),
(880, 2, 'Le logiciel Cache-mots pour le cycle 2 et le cycle 1', 'http://jlgrenar.free.fr/', 'Cachemot est un logiciel de lecture créé par Jean-Luc Grenard. Il propose à l''enfant d''identifier les mots masqués par des caches de taille variable selon le niveau de difficulté choisi.\r\nIl propose à l''enfant d''identifier les mots masqués par des caches de taille variable selon le niveau de difficulté choisi.\r\nLe logiciel est ouvert, il permet d''utiliser très facilement ses propres listes de mots (voir aide). Cachemot sauvegarde les résultats de chaque enfant.\r\n\r\n', 'lecture;cycle2;gratuit', 'Jean-Luc GRENARD', '0', '2006-08-27 10:35:24', NULL, NULL),
(885, 2, 'Logiciels RIP', 'http://www.educnet.education.fr/res/rip/prodI.htm', 'Produits multimédias éducatifs autorisés à utiliser la marque semi-figurative RIP\r\n&quot; Reconnu d''intérêt pédagogique par le Ministère de l''Éducation nationale &quot; \r\nListe classée par ordre aphabétique des produits \r\nListe des sociétés ayant présenté au moins un produit au guichet permanent\r\n', 'Logiciels;RIP;mutimédias,CD-Roms', 'Ministère qui a établi la liste', '0', '2006-08-27 12:03:12', NULL, NULL),
(886, 2, 'Logiciel libre &quot;A nous les nombres&quot; pour le cycle 1 et le cycle 2', 'http://www.logiciels-libres-tice.org/spip.php?article134&var_recherche=a%20nous%20les%20nombres', 'Logiciel libre, abordable à partir du cycle 1, qui permet de travailler la construction des nombres.\r\nIl regroupe les activités suivantes :\r\nCalapa : situations d’énumérations\r\nBarques : situations de dénombrement\r\nCalapa : situations de dénombrement et écritures additives\r\nConstellation : activité de systématisation, construction de collections equipotentes\r\nNombre : activité de systématisation, construction de collections equipotentes\r\nOrdinal : travail sur l’ordinal ', 'numération;nombres;Cycle1;cycle2', 'AbulEdu et son', '0', '2006-08-27 12:34:33', NULL, NULL),
(887, 2, 'Logiciel libre &quot;Calcul&quot; pour le cycle 3 et le cycle 2', 'http://www.logiciels-libres-tice.org/spip.php?article135&var_recherche=calcul', 'Logiciel d’entraînement aux mathématiques - Calcul rapide et calcul mental\r\n\r\n\r\n\r\n', 'Calcul;mental;rapide;logiciel;libre;cycle2;cycle3', 'Auteur : l’équipe de développement Le Terrier d’AbulÉdu Version : 1.19', '0', '2006-08-27 12:44:39', NULL, NULL),
(889, 2, 'Logiciel libre &quot;J''ai compris&quot; du cycle 1, au cycle 2; cycle 3', 'http://www.logiciels-libres-tice.org/spip.php?page=recherche&recherche=compris', 'GCompris est un ensemble de logiciels couvrant des domains d’apprentissage variés : maîtrise de la souris et du clavier, entraînement à la lecture, aux langues vivantes, aux mathéma.Le codage par niveau de difficulté (de 1 à 4 étoiles) et le regroupement par champ d’activités participent également à l’autonomie de l’enfant face à GCompris. http://gcompris.net/\r\n', 'mathématiques;sciences;', 'Bruno Coudoin', '0', '2006-08-27 12:49:25', NULL, NULL),
(890, 2, 'Geonext  un logiciel de géométrie dynamique', 'http://www.logiciels-libres-tice.org/spip.php?article132&var_recherche=geonext', 'Geonext est un logiciel de géométrie dynamique permettant un accès expérimental aux concepts de la géométrie et pouvant constituer une alternative à l’utilisation de Cabri-géomètre ', 'gémoétrie;logiciel;cycle3;libre;gratuit', 'Le département de didactique et mathématiques de l’université de Bayreuth', '0', '2006-08-27 12:54:10', NULL, NULL),
(891, 2, 'Logiciel libre JTANS ou tangramm', 'http://www.logiciels-libres-tice.org/spip.php?article136&var_recherche=jtans', 'jTans est un logiciel permettant de s’initier et de pratiquer le tangram. Le tangram est un jeu de réflexion comparable au puzzle : il s’agit de reconstituer une silhouette donnée à partir de 7 formes imposées (2 grands triangles,1 moyen et 2 petits,1 carré et 1 parallélogramme).Toutes les pièces doivent être utilisées pour reproduire le modèle proposé et elles ne doivent pas se chevaucher. ', 'logiciel;libre;JTANS;gratuit;géométrie', 'Philippe Banwarth', '0', '2006-08-27 12:56:35', NULL, NULL),
(892, 2, 'Le logiciel libre &quot;Calcul mental&quot; pour le cycle 2 et le cycle 3', 'http://www.logiciels-libres-tice.org/spip.php?article415&var_recherche=calcul%20mental', 'Ce logiciel est édité par les éditions ACCES. Ce logiciel permet le calcul mental sur les points du programme en mathématiques\r\n\r\n  Additions 0 à 10, 0 à100 \r\n  ajouter 10,100,1000 \r\n  nombres décimaux. \r\n  Soustractions 0 à 10 \r\n  0 à 100, soustraire 10,100,1000, nombres décimaux. \r\n  Multiplications : tables par 25,50,75,100 \r\n  double d’un nombre, nombres décimaux. \r\n  Divisions : tables, quotient et reste, moitié d’un nombre, nombres décimaux\r\n', 'Calcul;mental;rapide;logiciel;libre;cycle2;cycle3;gratuit', 'Editions ACCES', '0', '2006-08-27 12:58:31', NULL, NULL),
(893, 2, 'Logiciel libre &quot;Mesures&quot;', 'http://www.logiciels-libres-tice.org/spip.php?article416&var_recherche=mesures', 'Logiciel libre qui permet d’aborder les points suivants des programmes 2002.\r\n  Mesures de longueur \r\n  mesures d’aires \r\n  volumes \r\n  Lecture de l’heure\r\n\r\n', 'logiciel;libre;mesures;longueur;aires;volumes;temps', 'ACCES', '0', '2006-08-27 13:00:30', NULL, NULL),
(894, 2, 'Projet &quot;mathenpoche&quot;', 'http://www.logiciels-libres-tice.org/spip.php?rubrique125&var_recherche=math%20en%20poche', 'MathEnPoche est un projet soutenu par l’association Sésamath.En accord avec sa charte, les ressources disponibles sur le site de MathenPoche sont gratuitement mises à disposition de la communauté éducative par des enseignants en exercice. Elles ont pour vocation d’être enrichies continuellement par les pratiques des collègues, parents ou élèves qui les utiliseront.\r\n\r\nLe niveau 6ème est sous licence GPL et il en sera de même pour les autres niveaux au fur et à mesure de leur financement. Un niveau Cycle 3 est en préparation.\r\n\r\n', 'mathématiques:outils', 'Association Sésamath', '0', '2006-08-27 13:03:00', NULL, NULL),
(895, 2, 'Logiciel pour réviser les tables', 'http://www.logiciels-libres-tice.org/spip.php?article279&var_recherche=tables', 'Logiciel libre et gratuit permettant la révision des tables de multiplication', 'mathématiques;tables; addition;multiplication', '?', '0', '2006-08-27 13:05:19', NULL, NULL),
(896, 2, 'Logiciel libre &quot;Suites&quot; pour le cycle  2 et le cycle 3', 'http://www.logiciels-libres-tice.org/spip.php?article504&var_recherche=suites', 'Suites est un logiciel destiné au cycle 2 et au cycle 3 pour travailler en numération sur les suites des nombres (entiers, décimaux) arithmétiques et géométriques ou monotones irrégulières.', 'logiciel;libre;cycle2;cycle3', 'AbulEdu et son équipe', '0', '2006-08-27 13:07:06', NULL, NULL),
(897, 2, 'Logiciel libre Symcolor', 'http://www.logiciels-libres-tice.org/spip.php?article505&var_recherche=symcolor', 'Symcolor est un logiciel destiné à la construction du principe de symétrie axiale chez l’enfant à partir de la grande section en maternelle.', 'gémoétrie;mathématiques;logiciel;libre;symétrie', 'l’équipe de développement Le Terrier d’AbulÉdu', '0', '2006-08-27 13:09:36', NULL, NULL),
(898, 2, 'Logiciel libre Tuxmath', 'http://www.logiciels-libres-tice.org/spip.php?article79&var_recherche=tux%20math', 'TuxMath est un logiciel de calcul mental (addition, soustraction, multiplication, division. L’originalité réside dans le scénario qui sous-tend la résolution des opérations par l’utilisateur. Ce dernier est en effet dans la peau de Tux (pingouin mascotte) et a pour objectif de détruire les opérations qui arrivent du ciel et menacent de détruire les villes qu’il doit protéger', 'logiciel;libre;cycle2;cycle3;opérations;calcul;mental', 'Sam &quot;Criswell&quot; Hart et Bill Kendrick', '0', '2006-08-27 13:11:28', NULL, NULL),
(899, 2, 'Tux Maths Scrabble', 'http://www.logiciels-libres-tice.org/spip.php?article385&var_recherche=tux%20math', 'Tux Maths Scrabble est un jeu mathématique où l’enfant joue contre Tux. Ce n’est pas un scrabble avec des lettres mais avec des chiffres. Ici, pas de lettres, mais des chiffres et des opérateurs, le but étant de créer des égalités : 6+4=10 ; mais 6+4=5+5 (plus de nombres donc plus de points gagnés)... au prochain tour, si je le peux, je peux rajouter 9+6+4=5+5+9...\r\n\r\n', 'Calcul;mental;rapide;logiciel;libre;cycle2;cycle3', 'Asymptopia', '0', '2006-08-27 13:13:00', NULL, NULL),
(900, 2, 'Logiciel libre XLOGO pour apprendre à programmer en logo', 'http://www.logiciels-libres-tice.org/spip.php?article160&var_recherche=xlogo', 'L’utilisateur doit déplacer un objet appelé « tortue » sur l’écran à l’aide de commande aussi simples que avance, recule, tournedroite .... A chaque déplacement, la tortue laisse un trait derrière elle et ainsi on peut créer des dessins.', 'logiciel;libre;logo;programmation', 'xlogo@free.fr', '0', '2006-08-27 13:17:02', NULL, NULL),
(901, 2, 'Logiciel libre &quot;comparaison&quot; pour le cycle 1', 'http://www.logiciels-libres-tice.org/spip.php?article211&var_recherche=comparaison', 'Comparaison propose un exercice de discrimination visuelle. Il s’agit de reconnaître et de sélectionner, dans une série de 6, le carré colorié de manière identique au modèle situé à gauche, en début de ligne. La simplicité de l’exercice permet de l’utiliser sans connaissance préalable de l’outil informatique. L’application ne comporte qu’un seul type d’exercice, un seul niveau de jeu.\r\n\r\n', 'logiciel;libre;discrimination;visuelle', 'Project Omega', '0', '2006-08-27 13:19:27', NULL, NULL),
(902, 2, 'Logiciel libre &quot;labyrinth&quot; pour le cycle 1', 'http://www.logiciels-libres-tice.org/spip.php?article145&var_recherche=labyr', 'Labyrinthe est un logiciel ludo-éducatif. Il s’agit de trouver son chemin au travers d’un labyrinthe et de rallier un point déterminé. Les configurations de jeu sont de plus en plus complexes à mesure que le joueur parvient au but et enchaîne les parties.\r\n\r\n', 'mathématiques;chemin;repérage;labyrinthe;cycle1', 'Project Omega', '0', '2006-08-27 13:21:27', NULL, NULL),
(903, 2, 'Logiciel libre &quot;labyrinthe caché&quot; pour le cycle1', 'http://www.logiciels-libres-tice.org/spip.php?article216&var_recherche=labyr', 'Labyrinthe Caché est un logiciel ludo-éducatif. Il s’agit de trouver son chemin au travers d’un labyrinthe et de rallier un point déterminé. Les chemins des labyrinthes ne sont pas visibles si bien que la progression se fait par &quot;essais-erreurs&quot;. Les configurations de jeu sont de plus en plus complexes à mesure que le joueur parvient au but et enchaîne les parties.\r\n\r\n', 'mathématiques;cycle1;maternelle;labyrinthe', 'Project Omega', '0', '2006-08-27 13:23:14', NULL, NULL),
(904, 2, 'Logiciel libre &quot;KDE&quot;', 'http://www.logiciels-libres-tice.org/spip.php?article453&var_recherche=kde', 'Suivre la série de sons et de clignotements aussi longtemps que vous pouvez. Compléter les algorithmes pour gagner.\r\n\r\n', 'logiciel;libre;gratuit;mémoire', 'Albert Astals Cid', '0', '2006-08-27 13:24:34', NULL, NULL),
(905, 2, 'Logiciel libre Mémo Domino pour le cycle 1', 'http://www.logiciels-libres-tice.org/spip.php?article215&var_recherche=memo%20domino', 'Mémo-Dominos est un logiciel ludo-éducatif. Il s’agit d’un jeu de memory à base de carrés où figurent des constellations de couleurs différentes et aux dispositions variables.Il est possible de paramétrer la difficulté des parties en fonction de 2 critères : le nombre d’images à mettre en paires et le temps de visualisation des images une fois qu’elles sont retournées\r\n\r\n', 'mathématiques;mémoire;mémory;logiciel;libre;cycle1', 'Project Omega Janick Cerfontaine Maître formateur La Rochelle pour le scénario pédagogique', '0', '2006-08-27 13:26:37', NULL, NULL),
(906, 2, 'Logiciel libre &quot;Mémo-images&quot; pour le cycle 1', 'http://www.logiciels-libres-tice.org/spip.php?article214&var_recherche=memo%20domino', 'Mémo-Images est un logiciel ludo-éducatif. Il s’agit d’un jeu de memory à base d’images. Il est possible de parmétrer la difficulté des parties en fonction de 2 critères : le nombre d’images à mettre en paires et le temps de visualisation des images une fois qu’elles sont retournées\r\n\r\n', 'logiciel;libre;mémoire;gratuit;maternelle;cycle1', 'Auteur : EPI (portage : Project Omega )', '0', '2006-08-27 13:28:47', NULL, NULL),
(907, 2, 'Logiciel libre - Mon petit Labyrinthe pour le cycle 1', 'http://www.logiciels-libres-tice.org/spip.php?article375&var_recherche=labyr', 'Un logiciel pour agir .. dans des labyrinthes', 'cycle1;mathématiques;géométrie;labyrinthe', 'Pascal Peter', '0', '2006-08-27 13:31:33', NULL, NULL),
(908, 2, 'Logiciel libre &quot;Mulot&quot; pour le cycle 1 et la maternelle', 'http://www.logiciels-libres-tice.org/spip.php?article210&var_recherche=mulot', 'Mulot est un logiciel qui propose des activités de manipulation fine de la souris telles que survoler, cliquer, parcourir un chemin ou glisser/déposer. Il permet de faire la liaison entre le plan horizontal (plan de la souris) et le plan vertical (plan de l’écran d’ordinateur). ', 'logiciel;libre;gratuit;souris;maternelle;cycle1', 'AbulEdu et son équipe', '0', '2006-08-27 13:33:44', NULL, NULL),
(909, 2, 'Logiciel libre &quot;piles&quot; en maternelle', 'http://www.logiciels-libres-tice.org/spip.php?article212&var_recherche=piles', 'Piles est un logiciel ludo-éducatif. Le principe consiste à reproduire à l’identique une pile de 4 disques colorés à partir des disques de 5 autres piles que l’on peut déplacer.\r\n\r\n', 'logiciel;libre;maternelle;gratuit;', 'Project Omega', '0', '2006-08-27 13:35:39', NULL, NULL),
(910, 2, 'Logiciel libre PySyCache pour le cycle 1 et le cycle 2', 'http://www.logiciels-libres-tice.org/spip.php?article354&var_recherche=pysy', 'PySyCache est un logiciel éducatif destiné aux jeunes enfants (4-7 ans) ayant pour objectif de leur apprendre : à déplacer la souris à cliquer avec les boutons de souris\r\n', 'logiciel;libre;gratuit;maternelle;cycle2', 'Vincent DEROO', '0', '2006-08-27 13:38:27', NULL, NULL),
(911, 2, 'Utiliser le logiciel libre OpenOffice à l''école maternelle ou au cycle 2', 'http://www.logiciels-libres-tice.org/spip.php?article181&var_recherche=open', 'Utiliser Open Office au cycle 2 pour réaliser un album de lecture SCHAAF Armands - Ecole de Farébersviller Moselle\r\nUtiliser Open office.org en maternelle\r\n', 'traitement;textes;cycle1;cycle2;logiciel;libre;gratuit', 'Sun Microsystems et la communauté des développeurs  Armands Schaff Di Franco Jeanine', '0', '2006-08-27 13:41:41', NULL, NULL),
(912, 2, 'Xboard un logiciel libre pour jouer aux échecs', 'http://www.logiciels-libres-tice.org/spip.php?article142&var_recherche=xboard', 'Xboard est une interface graphique permettant de jouer aux échecs,', 'logiciel;libre;échecs', 'Tim Mann - Version : 4.2.7', '0', '2006-08-27 13:43:54', NULL, NULL),
(913, 2, 'Utilisation d''OpenOffice pour la lecture de paysages au cycle 3', 'http://www.logiciels-libres-tice.org/spip.php?article227&var_recherche=draw', 'Projet au cycle 3 : activités de lecture de paysages avec Draw\r\nNicolas Durupt Classe CM Ecole du Creutzberg Forbach\r\n\r\n', 'logiciel;libre;openOffice;géographie;lecture;paysage;cycle3', 'Sun Microsystems et la communauté des développeurs  Nicolas Durupt pour le scénario', '0', '2006-08-27 14:02:18', NULL, NULL),
(914, 2, 'Le théâtre à l''école primaire', 'http://perso.wanadoo.fr/jean.mayer/', 'Echanges de pratiques sur le théâtre à l''école. Des ressources et des activités.', 'théâtre;expression;orale;cycle1;cycle2;cycle3', 'Jean Mayer', '0', '2006-08-27 17:36:12', NULL, NULL),
(915, 2, 'Programmation en GS de maternelle', 'http://membres.lycos.fr/jeanmayer/', 'exemples de programmation en GS de maternelle de Jean-Mayer IMF à Toulouse.', 'programmation;GS', '', '0', '2006-08-27 17:38:53', NULL, NULL),
(916, 2, 'Le site Dramaction pour le théâtre', 'http://www.dramaction.qc.ca/index.php', 'Le site de la communautés des enseignants et des animateurs qui pratiquent le théâtre.', 'théatre;animations', '', '0', '2006-08-27 17:43:21', NULL, NULL),
(917, 2, 'Droit et Internet', 'http://www.ac-caen.fr/manche/tice2/tice50/droit%26tice.pdf', 'Un document de l''Inspection académique pour répondre aux problèmes de droit pratiques que l''on peut rencontrer dans une école.', 'droit;internet;images;jurisprudence', 'Aca démie de Caen', '0', '2006-08-27 17:47:16', NULL, NULL),
(919, 2, 'Exercices d''évacuation du département de l''Oise', 'http://www.ia95.ac-versailles.fr/administratif/spip.php?article322', 'des consignes, des textes sur le problème de la sécurité à l''école.', 'sécurité;textes;jurispridence;directeurs;évacuation', 'IA de l''Oise', '0', '2006-08-27 17:53:30', NULL, NULL),
(920, 2, 'A l''école de la forêt - Site national', 'http://www.ecoledelaforet.agriculture.gouv.fr/', 'L''école de la forêt est une opération destinée aux classes primaire.\r\n', 'forêt;environnement;écosystème', 'Ministère de l''agriculture', '0', '2006-08-27 17:56:38', NULL, NULL),
(921, 2, 'Exépériences sur les liquides', 'http://cm1cm2.ceyreste.free.fr/liquides.html', 'expériences sur les liquides. reportage photo', 'sciences;technologie;expériences;liquide', 'Ceyreste et ses élèves', '0', '2006-08-27 18:04:03', NULL, NULL),
(922, 2, 'Le site pour tout savoir sur les phasmes', 'http://www.phasmes.com/', 'Un site dédié aux insectes &quot;phasmes&quot;. A utiliser en cas d''élevage en classe. A utiliser dès le cycle 3.', 'biologie;élevage;phasme;lecture;cycle3', 'phasme.com', '0', '2006-08-27 18:07:29', NULL, NULL),
(923, 2, 'Le site la main à la pâte', 'http://lamap.inrp.fr//', 'Le site La main à la pâte est destiné à aider enseignants, formateurs, scientifiques et institutionnels à mettre en place un enseignement des sciences de qualité à l’école primaire. Vous y trouverez des activités de classe, des documents scientifiques ou pédagogiques, des outils d’échange et de travail collaboratif.', 'sciences;projets', 'INRP + Ministère', '0', '2006-08-27 18:11:11', NULL, NULL),
(924, 2, 'Le monde de Darwin', 'http://darwin.cyberscol.qc.ca/', 'Un site dédié au règne animal', 'biologie;règne;animal;zoologie;lecture', 'Ministère du Québec;cyberscol;', '0', '2006-08-27 18:14:58', NULL, NULL),
(925, 2, 'Sciences et technologie à l''école - Site du CNDP', 'http://www.cndp.fr/ecole/sciences/accueil.htm', 'Ressources et textes de référence pour enseigner les sciences.', 'sciences;astronomie;lune;cyle2;cycle3', 'CNDP', '0', '2006-08-27 18:18:34', NULL, NULL),
(927, 2, 'Site du musée d''histoire naturelle', 'http://www.mnhn.fr/museum/foffice/transverse/transverse/accueil.xsp', 'Pour préparer une visite au musée.\r\n', 'animaux;zoologie;biologie', 'musée histoire naturelle Paris', '0', '2006-08-27 18:23:59', NULL, NULL),
(928, 2, 'Un jeu sur les dangers dans la rue Cycle 2', 'http://cyberechos.creteil.iufm.fr/cyber4/Actualite/rue/rue.htm#jeu', 'Un site pour apprendre à éviter le danger dans la rue.', 'danger;sécurité;citoyenneté', 'cyberechos', '0', '2006-08-27 18:27:03', NULL, NULL),
(929, 2, 'Le journal des enfants pour le cycle 3', 'http://www.jde.fr/', 'Le JDE est un hebdomadaire [un journal qui sort une fois par semaine].Des articles d''actualités à lire dès le cycle 3.\r\nUn dossier par semaine à lire en ligne.', 'presse;médias;actualités;cycle3', 'JDE', '0', '2006-08-27 18:32:10', NULL, NULL),
(930, 2, 'Le journal &quot;les clés de l''actualité Junior&quot;', 'http://www.lesclesjunior.com/', 'Envie de mieux comprendre un événement d''actualité ou besoin de faire des recherches pour réaliser un exposé? Tu entres ton mot clé ou tes mots clés et tu as accès à tous les articles publiés sur le sujet de ton choix. Tu lis, tu sélectionnes, tu imprimes…\r\nEt maintenant tu peux préparer ton exposé.\r\n', 'actualité;presse;lecture;documents;journal', '“Les Clés de l’Actualité Junior” est une revue du Groupe Milan Presse.', '0', '2006-08-27 18:55:02', NULL, NULL),
(931, 2, 'Le journal &quot;le p''tit môme&quot; actu pour le cycle2', 'http://www.ac-nancy-metz.fr/IA55/momes-actu/ptitmomesactu/nouveau/default.html', 'Un journal pour se tenir informé .\r\nP''tits Mômes-Actu est un journal d''actualité créé par des élèves de cycle 2. Il s''inspire dans son organisation de la longue expérience de Mômes-Actu en cycle 3.\r\nLes élèves correspondants de presse envoient leurs articles dans le ferme espoir de les voir édités.\r\nLa classe rédactrice en chef collecte tous ces textes, les lit, les critique, les range suivant leur pertinence et décide de leur publication.\r\n', 'actualités;presse;cycle2;journal', 'Inspection de la Meuse', '0', '2006-08-27 18:59:27', NULL, NULL),
(932, 2, 'Le site France 5', 'http://www.france5.fr/', 'Le site Internet de France 5 permet aux téléspectateurs de retrouver des programmes déjà diffusés et de compléter leurs connaissances dans les domaines les plus divers.\r\nDes émissions et des logiciels en ligne', 'lecture;arts', 'France 5', '0', '2006-08-27 19:05:55', NULL, NULL),
(933, 2, 'Site du Bulletin de la Pmev', 'http://www.lebulletinpmev.com/', 'le site du Bulletin de la Pmev vous propose de nombreuses ressources.\r\nLa Pmev propose une organisation spécifique de la classe répondant à quelques principes précis, avec un objectif très simple : gagner en efficacité et en confort de travail. Elle n''est pas une solution miracle mais un remède réfléchi à un certain nombre de difficultés aujourd''hui rencontrées dans les classes. Ce site vous présente par ses témoignages, mais aussi par la mise à disposition d''outils, comment, chaque jour, des enseignants travaillent dans leur classe avec leurs élèves. \r\nDes outils sur la production d''écrits et l''ORL. Des outils en géométrie', 'organisation;progressions;ORL;expression;mathématiques;géométrie', 'PMEV', '0', '2006-08-27 19:13:37', NULL, NULL),
(936, 2, 'Le site de l''espiègle', 'http://www.espiegle.org/', 'Un centre européen pour de jeunes reporters de 11 ans à 17 ans\r\nClasses-presse : Les élèves vivent une semaine comme de vrais reporters.\r\nClasses-internet : Une semaine pour que les élèves connaissent mieux internet et réalisent un web-magazine\r\nAteliers du journal : Pour apprendre à s’exprimer par l’écrit, pour trouver sa place dans son environnement\r\nSéjours jeunes reporters : Pendant les vacances, les 11-17 ans voient le monde en reporters', 'presse;médias;actualités;cycle3', 'espiègle', '0', '2006-08-27 19:25:41', NULL, NULL),
(937, 2, 'Ecole nomade pour l''avenir .. pour mieux comprendre les Manouches', 'http://mayvon.chez-alice.fr/ecole.html', 'Des ressources pour les gens du voyage. Un glossaire Manouche', 'gens;voyage;manouche', 'Association régionale pour l''information et la promotion', '0', '2006-08-27 19:39:56', NULL, NULL),
(938, 2, 'Texte de la DESCO sur l''assiduité scolaire', 'http://eduscol.education.fr/D0183/accueil.htm', 'Des textes de référence du site pédagogique du ministère.', 'assiduité;absentéisme;directeurs', 'DESCO Ministère', '0', '2006-08-27 20:19:25', NULL, NULL),
(941, 2, 'Actes de la DESCO', 'http://eduscol.education.fr/D0033/accueil_publication.htm', 'Toutes les publications des actes des séminaires et universités d''été de la Desco\r\n\r\n    * par ordre alphabétique\r\n    * par ordre chronologique\r\n    * par thèmes\r\nctes des séminaires et universités d''été\r\n\r\n    * Sommaire\r\n    * Quelles pratiques pour enseigner des questions sensibles dans une société en évolution ?\r\n    * Enseigner le théâtre à l''École\r\n    * Management et gestion des ressources humaines : stratégies, acteurs et pratiques\r\n', 'actes;DESCO;', 'DESCO Ministère', '0', '2006-08-27 20:46:13', NULL, NULL),
(942, 2, 'Les discussions philosophiques pour enfants en ZEP', 'http://gillg14.free.fr/Accueil.htm', 'LA PHILOSOPHIE EST-ELLE UTILE ?\r\nLA PHILOSOPHIE A L''ECOLE\r\n. Distinguer culture et pratiques philosophiques\r\n. La méthode employée\r\n. Objectifs\r\n\r\nUNE EXPÉRIENCE\r\n. Avant la philosophie pour enfants\r\n. Organisation des activités\r\n. Une évaluation', 'philosophie;citoyenneté;débats;ZEP', 'Gilles GENEVIEVE', '0', '2006-08-27 20:51:29', NULL, NULL),
(943, 2, 'L''enfant qui frappe Comment réagir ?', 'http://www.webdlambert.com/enfant-frappe.html', 'Le point de vue d''un psychologue', 'psychologie;troubles;comportement;agressivité', 'Daniel Lambert, psychologue', '0', '2006-08-27 20:54:46', NULL, NULL),
(944, 2, 'Divorce. Que faire si l''un des 2 prépare un rapt d''enfant ?', 'http://www.divorce-famille.net/pages/r6.htm', 'Un texte pour comprendre la législation du divorce et voir comment réagir en cas de &quot;rapt&quot;.', 'règlementation;divorce', '', '0', '2006-08-27 21:06:54', NULL, NULL),
(945, 2, 'Association française pour la lecture', 'http://www.lecture.org/', 'le site de l''association française pour la lecture.\r\nDes outils, des textes,des productions, un catalogue', 'lecture;AFL', 'AFL', '0', '2006-08-30 20:07:44', NULL, NULL),
(946, 2, 'Dossier les parents à l''école du Ministère', 'http://www.education.gouv.fr/pid74/les-parents-a-l-ecole.html', '    * &gt; Inscription des élèves\r\n    * &gt; Suivi de la scolarité des élèves\r\n          o Le suivi de la scolarité par le père et la mère\r\n          o Les relations parents-enseignants\r\n          o Assuidité de l''élève et ses conséquences\r\n          o Les devoirs à la maison\r\n    * &gt; Notes, examens et évaluations\r\n          o Notes et examens\r\n          o Evaluations\r\n    * &gt; Associations de parents d''élèves\r\n          o Missions des associations\r\n          o Liste des principales associations\r\n    * &gt; Elections des représentants des parents d''élèves\r\n          o Déroulement des élections\r\n    * &gt; Représentation parentale aux différents échelons du système éducatif\r\n          o Textes de référence de la représentation parentale\r\n    * &gt; Facilités accordées aux associations de parents d''élèves et aux représentants...\r\n          o Pour les associations\r\n          o Pour les parents d''élèves élus ou désignés\r\n\r\n', 'parents;élections;devoirs;associations;inscriptions;assiduité;représentants', 'Education Nationale', '0', '2006-08-30 20:15:19', NULL, NULL),
(947, 2, 'Le Bulletin officiel BO', 'http://www.education.gouv.fr/pid285/le-bulletin-officiel.html', 'Mentor vous permet de retrouver les références des textes depuis 1987 et l''intégralité des textes depuis janvier 1998.\r\nPour obtenir les textes antérieurs à 1998, contactez l''un des 180 lieux d''accueil du réseau C.N.D.P.', 'BO;bulletin;officiel;règlementation;règlements;textes', 'Ministère', '0', '2006-08-30 20:26:14', NULL, NULL),
(948, 2, 'Le code de l''Education et légifrance', 'http://www.education.gouv.fr/cid2643/le-code-de-l-education.html', 'A Consulter: La partie législative du Code de l''éducation, mise à jour régulièrement sur le site Légifrance.\r\nA Consulter : La partie réglementaire du Code de l''éducation, également sur Légifrance', 'législation ;code;éducation;Légifrance', 'Ministère', '0', '2006-08-30 20:44:57', NULL, NULL),
(949, 2, 'L''école maternelle - Site Education.gouv.fr', 'http://www.education.gouv.fr/pid35/ecole-maternelle.html', '# Inscription\r\n# Horaires et programmes\r\n# Vie scolaire\r\n# Besoins spécifiques ', 'inscription;école;maternelle;horaires;programmes', 'Ministère', '0', '2006-08-30 20:47:19', NULL, NULL),
(950, 2, 'Ecole élémentaire - Site education.gouv.fr', 'http://www.education.gouv.fr/pid34/ecole-elementaire.html', ' L''entrée à l''école\r\n    * Aides financières\r\n    * Horaires et programmes\r\n    * Inscription\r\nLa vie à l''école\r\n    * Assurances scolaires\r\n    * Restauration\r\n    * Santé à l''école\r\n\r\n', 'horaires;programmes;inscription;assurances;restauratrion;santé', 'Gouvernement', '0', '2006-08-30 20:49:18', NULL, NULL),
(952, 2, 'Site sur la protection des mineurs sur Internet', 'http://www.delegation.internet.gouv.fr/mineurs/index.htm', '&quot;A la maison comme à l''école, naviguer sur internet ne va pas sans risques pour les mineurs : sites illégaux, racoleurs, racistes, violents abondent sur le net. La Délégation aux usages de l''internet (DUI) se devait de prendre en compte ce problème. Sa première action a été de créer ce site qui regroupe toutes les initiatives ayant trait à la protection et à la responsabilisation des mineurs sur internet .&quot;', 'protection;mineurs;loi, jurisprudence;sécurité;Internet', 'délégation Internet du gouvernement', '0', '2006-08-30 20:58:04', NULL, NULL),
(953, 2, 'Site &quot;Protège ton ordi&quot; de Microsoft', 'http://www.microsoft.com/france/securite/particuliers/default.aspx', 'Parents et enfants découvriront sur ce site  comment se protéger des virus, des courriels non sollicités, des escroqueries aux données personnelles, etc. ', 'protection;virus;juridique;internet;lecture;citoyenneté', 'Délégation aux usages de l''internet parraine ce site en compagnie de nombreux partenaires publics/pr', '0', '2006-08-30 21:01:59', NULL, NULL),
(954, 2, 'Outils pour Primo-arrivants', 'http://pedagogie.ac-montpellier.fr/Casnav/Atoutcri/Telechargement/Index.htm', 'Le cédérom ATOUTCRI est une compilation de diverses méthodes d''apprentissage à destination d''élèves nouvellement arrivés en France. Ces méthodes sont disponibles sur Internet en libre accès. Les enseignants trouveront via ce cédérom un éventail de méthodes, de documents pédagogiques, d''évaluations... Bref une caisse à outils pour l'' enseignant ayant à travailler avec des élèves nouvellement arrivés. ', 'méthodes;primo-arrivants;étrangers;FLE', 'Casnav de l''académie de Montpelllier', '0', '2006-09-02 13:49:01', NULL, NULL),
(955, 2, 'Site &quot;Primlangues&quot; pour les langues vivantes', 'http://www.primlangues.education.fr/php/', 'Site institutionnel d''accompagnement des enseignants et intervenants chargés des langues vivantes dans le premier degré. Portail ouvert sur l''actualité des langues vivantes, il constitue aussi un centre de ressources et un outil de dialogue.', 'langues;vivantes;allemand;anglais;italien;arabe;turc;espagnol', 'Ministère de l''Education Nationale et CIEP', '0', '2006-09-02 13:51:54', NULL, NULL),
(956, 2, 'Site Casnav de l''académie de Montpellier', 'http://pedagogie.ac-montpellier.fr/casnav/index.htm', 'Des textes et des thèmes sur l''accueil et de la scolarisation des enfants peu ou pas francophones nouvellement arrivés en France, ou encore des enfants du Voyage, enfants de professionnels tinérants. ', 'enfants;voyage;étrangers;CASNAV', 'Académie de Montpellier', '0', '2006-09-02 13:54:53', NULL, NULL),
(957, 2, 'Le site Educnet pour les TIC', 'http://www.educnet.education.fr/', 'Le portail pour les TIC - Site institutionnel', 'TIC;Educnet;EDUCNET;portail', 'Ministère EN', '0', '2006-09-02 13:58:01', NULL, NULL),
(958, 2, 'Moteur de recherche pour les scénarios B2I, Primtice', 'http://primtice.education.fr/search/index.php', 'rechercher des scénarios intégrant les TIC.', 'B2I;TIC;Primtice', 'Ministère EN', '0', '2006-09-02 14:03:20', NULL, NULL),
(959, 2, 'Poly32, un logiciel de géométrie pour le cycle 3', 'http://www.peda.com/poly/', 'Poly32 est un logiciel shareware (programme de démonstration). Une ergonomie très simple qui permet une prise en main rapide par l’élève pour lui permettre de visualiser des solides en 3 dimensions, facilitant ainsi le passage solide/patron. La version shareware est très peu limitée (quelques fonctions d’exportation) et affiche régulièrement des écrans pour proposer de s’enregistrer (la version individuelle coûte quand même 28$ et celle établissement 98$).', 'géométrie;logiciel;shareware;solides;patrons;cube;', 'peda.com/poly', '0', '2006-09-02 14:17:32', NULL, NULL),
(960, 2, 'Logiciels pour les élèves du cycle 2', 'http://www.ac-rouen.fr/premier_degre/iai/feclilyve/cycle2/eleves.htm', 'Une série de logiciels à télécharger pour le cycle 2', 'lecture;écriture;mathématiques;logiciels;traitement;textes', 'académie de Rouen', '0', '2006-09-03 20:35:58', NULL, NULL),
(962, 2, 'Dossier maternelle du CDDP de Haut-Rhin', 'http://www.crdp-strasbourg.fr/cddp68/maternelle/index.htm', 'Le langage au coeur des apprentissages \r\nVivre ensemble \r\nAgir et s''exprimer avec son corps \r\nDécouvrir le monde \r\nLa sensibilité, l''imagination, la création \r\nDocuments pour préparer la classe \r\nLa liaison GS/CP \r\nTICE en maternelle \r\nL''accueil des moins de trois ans \r\nLes relations entre l''école et la famille \r\nTraces d''activité en maternelle \r\nComptines en maternelle \r\nClasses maternelles bilingues \r\n\r\n', 'maternelle;liaison;cycle1;liaison;GS;CP', 'CRDP de Strasbourg', '0', '2006-09-06 22:45:57', NULL, NULL),
(963, 2, 'Base de sons en format Ogg Vorbis', 'http://www.lunerouge.org/spip/rubrique.php3?id_rubrique=29', ' Bruitages, Echantillons, des sons classés en 7 catégories. Ces éléments sonores sont au format Ogg Vorbis.Lle site met à disposition une liste de liens vers des échantillons de musiques et de bruitages. Tous les éléments sonores sont la propriété de leur auteur.Ils sont distribués sous la Licence Art Libre \r\n\r\n\r\n\r\n', 'sons;ogg;Vorbis', 'Lunerouge', '0', '2006-09-06 22:50:08', NULL, NULL),
(964, 2, 'Acoustica... une banque de sons', 'http://www.acoustica.com/sounds.htm', 'Ce site répertorie quelques sons (format wave), classés en 8 catégories', 'sons;wave', 'acoustica', '0', '2006-09-06 22:52:50', NULL, NULL),
(965, 2, 'Dramatic Publishing ... des sons et des effets sonores', 'http://www.dramaticpublishing.com/FreeSoundEffects.cfm', 'Site proposant une petite liste d''effets sonores, bruitages, classés par thème (animaux, voix, téléphone, insectes, temps, etc...). La majorité de ces sons sont au format wave. (Site en anglais).\r\n\r\nVoir page Web : Dramatic Publishing\r\n\r\n\r\n', 'sons;effeit;sonore', 'Dramatic Publishing', '0', '2006-09-06 22:56:28', NULL, NULL),
(966, 2, 'Flash Slide Show Maker pour des sons', 'http://www.flashkit.com/soundfx/', 'Liste de sons, de bruitages classés par thème, allant entre autre de la nature aux bruits domestiques, en passant par les cartoons, les bruits électroniques et les personnes... ', 'sons;cartoons;bruits', 'flashkit', '0', '2006-09-06 22:57:25', NULL, NULL),
(967, 2, 'Absolute effects archive', 'http://www.grsites.com/sounds/', 'des sons d''univers variés (animaux, nature, vent, eau, etc...), classés par rubrique, téléchargeable en fichier wave', '', '', '0', '2006-09-06 23:01:12', NULL, NULL),
(970, 2, 'Des projets de communication  Registre classes @classes', 'http://prof-inet.cslaval.qc.ca/', 'Banques de projets pour l''école élémentaire.\r\nL''inscription donne accès à une &quot;classe virtuelle&quot; avec  un espace sécurisé avec messagerie, chat, forum, espace de stockage, et même espace de publication sur le web, le tout bien fait, convivial, sans spams', 'projets;sciences;français;communication', 'Prof-inet', '0', '2006-09-10 17:52:06', NULL, NULL),
(971, 2, 'Projet Etwinning pour des projets de jumelages en Europe', 'http://www.etwinning.net/ww/fr/pub/etwinning/index2005.htm', 'Un site pour participer à des projets de partenariat en Europe.', 'projets;partenariats;langues;vivantes;Europe', 'Commission européenne', '0', '2006-09-10 17:53:10', NULL, NULL),
(972, 2, 'Logiciel de géographie du monde et de la France pour le cycle 3', 'http://www.wartoft.nu/software/seterra/', 'Seterra est un logiciel de géographie qui propose 70 exercices différents. Repérer et reconnaître les pays, les drapeaux, les villes .... Continents : Europe, Afrique, Asie, USA, France, Mexique ..', 'logiciel;gratuit;pays;continents;', 'Warthof Marianne', '0', '2006-09-10 18:08:51', NULL, NULL),
(973, 2, 'Logiciel Sebra ''s ABC pour le cycle 2', 'http://www.wartoft.nu/software/sebran/', 'Logiciel multi-activités en plusieurs langues pour cycle II\r\nPour l''apprentissage des lettres et des nombres.Les enfants peuvent jouer au ''Pendu'', au ''Mémory'' et à ''Pluie de lettres'' ou apprendre les maths avec ''Addition'', ''Soustraction'' et ''Multiplication''.\r\n&quot;Sebran''s ABC comprend 12 jeux différents. Dans les 6 exercices les plus simples, 4 réponses sont proposées. Choisir la bonne affichera un sourire tandis qu''une erreur se traduira par une grimace et la possibilité de réessayer. Le jeu de comptage ''Combien ?'' familiarise l''enfant avec les chiffres de 1 à 9. Ceux-ci sont utilisés dans les jeux ''Addition'', ''Soustraction'' et ''Multiplication'' avec, pour chacun, deux niveaux de difficulté. Dans le jeu ''Choisis une image'', un des quatre dessins proposés correspond à un mot. Dans le jeu ''Première lettre'', il faut retrouver parmi 4 possibilités la lettre (initiale) qui complète le mot proposé. L''enfant peut réinvestir les compétences acquises pour jouer à ''Mémo'', ''Mémo-lettres'' ou ''Le pendu''. Enfin ''Pluie d''ABC'' et ''Pluie de lettres'' et ''Pluie 1+2'' entraînent les petits doigts à utiliser le clavier.', 'lettres;alphabet;nombres;pendu;mémory;addition;soustraction;multiplication', 'Warthof Marianne', '0', '2006-09-10 18:15:55', NULL, NULL),
(974, 2, 'Minisebran - Freeware pour les tout-petits pour le cycle 1', 'http://www.wartoft.nu/software/minisebran/french.aspx', 'Minisebran est un ensemble gratuit de jeux éducatifs pour des enfants de 2 à 6 ans. Il inclut huit exercices différents : des exercices de dessin, des jeux très simples pour se familiariser avec les chiffres et les lettres et pour connaître le clavier.Pour des enfants un peu plus âgés (4-9 ans), il est  recommandé d''utiliser  Sebran''s ABC.', 'jeux;dessins;chiffres;lettres;cycle1', 'Warthof Marianne', '0', '2006-09-10 18:24:37', NULL, NULL),
(975, 2, 'Logiciel Selingua pour le vocabulaire des langues', 'http://www.wartoft.nu/software/selingua/', 'Selingua est un logiciel qui permet l''entraînement lexical à partir d''un dictionnaire. Il y a plus de 2000 mots dans les langues suivantes ; allemand, anglais, espagnol, suédois. German, Spanish, French and Swedish. Le programme peut être utiliser par des locuteurs natifs.La version  5.2 de Selingua datant d''Avil 2006 permet de d''utiliser des listes de mots préétablies dans l''éditeur du dictionnaire. ', 'langues;vivantes;allemand;anglais;suédois', 'Warthof Marianne', '0', '2006-09-10 18:26:26', NULL, NULL),
(976, 2, 'Les parents d''élèves et l''école - Site de la DESCO', 'http://eduscol.education.fr/D0097/accueil.htm', 'Des textes sur le rôle des parents d''élèves à l''école.', 'parents;écoles;élèves', 'DESCO Ministère', '0', '2006-09-10 20:39:52', NULL, NULL);

-- --------------------------------------------------------

--
-- Structure de la table `module_ressource_tags`
--

CREATE TABLE IF NOT EXISTS `module_ressource_tags` (
  `annu` int(11) NOT NULL DEFAULT '0',
  `res` int(11) NOT NULL DEFAULT '0',
  `tag` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`res`,`tag`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `module_ressource_tags`
--

INSERT INTO `module_ressource_tags` (`annu`, `res`, `tag`) VALUES
(2, 976, 'parents'),
(2, 975, 'suédois'),
(2, 975, 'langues'),
(2, 975, 'vivantes'),
(2, 974, 'cycle1'),
(2, 974, 'jeux'),
(2, 974, 'dessins'),
(2, 973, 'addition'),
(2, 973, 'soustraction'),
(2, 973, 'nombres'),
(2, 973, 'pendu'),
(2, 973, 'mémory'),
(2, 972, 'pays'),
(2, 972, 'logiciel'),
(2, 971, 'partenariats'),
(2, 971, 'langues'),
(2, 971, 'vivantes'),
(2, 970, 'projets'),
(2, 970, 'sciences'),
(2, 969, 'sons'),
(2, 969, 'instruments'),
(2, 968, 'sons'),
(2, 966, 'sons'),
(2, 966, 'cartoons'),
(2, 965, 'sons'),
(2, 964, 'wave'),
(2, 963, 'vorbis'),
(2, 962, 'maternelle'),
(2, 962, 'liaison'),
(2, 961, 'sons'),
(2, 961, 'moteur'),
(2, 960, 'textes'),
(2, 960, 'logiciels'),
(2, 960, 'traitement'),
(2, 959, 'géométrie'),
(2, 959, 'logiciel'),
(2, 959, 'shareware'),
(2, 958, 'b2i'),
(2, 958, 'tic'),
(2, 957, 'tic'),
(2, 956, 'enfants'),
(2, 956, 'voyage'),
(2, 955, 'italien'),
(2, 955, 'langues'),
(2, 955, 'vivantes'),
(2, 955, 'allemand'),
(2, 954, 'méthodes'),
(2, 954, 'primo'),
(2, 953, 'lecture'),
(2, 953, 'protection'),
(2, 953, 'virus'),
(2, 952, 'protection'),
(2, 952, 'mineurs'),
(2, 952, 'loi'),
(2, 952, 'jurisprudence'),
(2, 951, 'état'),
(2, 951, 'associations'),
(2, 951, 'familles'),
(2, 951, 'éducatif'),
(2, 951, 'local'),
(2, 950, 'programmes'),
(2, 950, 'inscription'),
(2, 950, 'assurances'),
(2, 949, 'horaires'),
(2, 949, 'programmes'),
(2, 926, 'lecture'),
(2, 948, 'législation'),
(2, 948, 'code'),
(2, 947, 'textes'),
(2, 947, 'règlements'),
(2, 947, 'officiel'),
(2, 947, 'règlementation'),
(2, 946, 'représentants'),
(2, 946, 'assiduité'),
(2, 946, 'devoirs'),
(2, 946, 'associations'),
(2, 945, 'lecture'),
(2, 944, 'règlementation'),
(2, 943, 'agressivité'),
(2, 943, 'psychologie'),
(2, 943, 'troubles'),
(2, 942, 'citoyenneté'),
(2, 942, 'débats'),
(2, 941, 'desco'),
(2, 940, 'collège'),
(2, 939, 'conseils'),
(2, 938, 'directeurs'),
(2, 938, 'assiduité'),
(2, 937, 'gens'),
(2, 937, 'voyage'),
(2, 936, 'presse'),
(2, 936, 'médias'),
(2, 935, 'napoléon'),
(2, 935, 'histoire'),
(2, 934, 'histoire'),
(2, 934, 'frise'),
(2, 933, 'orl'),
(2, 933, 'organisation'),
(2, 933, 'progressions'),
(2, 932, 'lecture'),
(2, 931, 'cycle2'),
(2, 931, 'journal'),
(2, 930, 'presse'),
(2, 930, 'lecture'),
(2, 929, 'presse'),
(2, 929, 'médias'),
(2, 928, 'danger'),
(2, 928, 'sécurité'),
(2, 927, 'zoologie'),
(2, 927, 'biologie'),
(2, 926, 'eau'),
(2, 926, 'déchets'),
(2, 926, 'cycle3'),
(2, 925, 'sciences'),
(2, 925, 'astronomie'),
(2, 925, 'lune'),
(2, 917, 'droit'),
(2, 924, 'lecture'),
(2, 924, 'biologie'),
(2, 923, 'sciences'),
(2, 922, 'phasme'),
(2, 922, 'lecture'),
(2, 922, 'élevage'),
(2, 921, 'technologie'),
(2, 921, 'sciences'),
(2, 920, 'forêt'),
(2, 920, 'environnement'),
(2, 919, 'directeurs'),
(2, 919, 'sécurité'),
(2, 919, 'textes'),
(2, 918, 'sécurité'),
(2, 918, 'évacuation'),
(2, 917, 'images'),
(2, 916, 'théatre'),
(2, 915, 'programmation'),
(2, 914, 'théâtre'),
(2, 914, 'expression'),
(2, 914, 'orale'),
(2, 913, 'logiciel'),
(2, 913, 'libre'),
(2, 913, 'openoffice'),
(2, 912, 'logiciel'),
(2, 911, 'traitement'),
(2, 911, 'textes'),
(2, 911, 'cycle1'),
(2, 911, 'cycle2'),
(2, 910, 'libre'),
(2, 910, 'gratuit'),
(2, 910, 'maternelle'),
(2, 909, 'maternelle'),
(2, 909, 'logiciel'),
(2, 908, 'logiciel'),
(2, 908, 'libre'),
(2, 908, 'gratuit'),
(2, 907, 'cycle1'),
(2, 907, 'mathématiques'),
(2, 906, 'libre'),
(2, 906, 'mémoire'),
(2, 906, 'logiciel'),
(2, 905, 'mathématiques'),
(2, 905, 'mémoire'),
(2, 905, 'mémory'),
(2, 904, 'libre'),
(2, 904, 'gratuit'),
(2, 903, 'mathématiques'),
(2, 903, 'cycle1'),
(2, 902, 'mathématiques'),
(2, 902, 'chemin'),
(2, 902, 'repérage'),
(2, 898, 'mental'),
(2, 901, 'libre'),
(2, 901, 'discrimination'),
(2, 900, 'logo'),
(2, 900, 'programmation'),
(2, 899, 'cycle2'),
(2, 899, 'calcul'),
(2, 899, 'mental'),
(2, 899, 'rapide'),
(2, 898, 'logiciel'),
(2, 898, 'libre'),
(2, 898, 'cycle2'),
(2, 897, 'libre'),
(2, 897, 'mathématiques'),
(2, 897, 'logiciel'),
(2, 896, 'logiciel'),
(2, 896, 'libre'),
(2, 895, 'addition'),
(2, 895, 'mathématiques'),
(2, 893, 'longueur'),
(2, 893, 'aires'),
(2, 893, 'volumes'),
(2, 893, 'temps'),
(2, 892, 'cycle2'),
(2, 892, 'calcul'),
(2, 892, 'mental'),
(2, 892, 'rapide'),
(2, 891, 'logiciel'),
(2, 891, 'libre'),
(2, 891, 'jtans'),
(2, 890, 'gratuit'),
(2, 890, 'gémoétrie'),
(2, 890, 'logiciel'),
(2, 888, 'cycle3'),
(2, 888, 'géométrie'),
(2, 888, 'logiciel'),
(2, 887, 'cycle2'),
(2, 887, 'calcul'),
(2, 887, 'mental'),
(2, 887, 'rapide'),
(2, 886, 'numération'),
(2, 886, 'nombres'),
(2, 885, 'cd'),
(2, 885, 'rip'),
(2, 884, 'organisation'),
(2, 884, 'pensée'),
(2, 884, 'méthodogie'),
(2, 883, 'méthode'),
(2, 883, 'cartes'),
(2, 883, 'heuristiques'),
(2, 883, 'organisation'),
(2, 882, 'logiciel'),
(2, 881, 'mathématiques'),
(2, 881, 'logiciel'),
(2, 880, 'lecture'),
(2, 879, 'numération'),
(2, 878, 'numération'),
(2, 877, 'maternelle'),
(2, 877, 'logiciel'),
(2, 877, 'lecture'),
(2, 876, 'lecture'),
(2, 876, 'logiciel'),
(2, 875, 'logiciel'),
(2, 875, 'langues'),
(2, 875, 'vivantes'),
(2, 874, 'traitement'),
(2, 874, 'logiciel'),
(2, 873, 'puzzle'),
(2, 873, 'jeux'),
(2, 873, 'logiciel'),
(2, 872, 'multiplication'),
(2, 872, 'lecture'),
(2, 872, 'logiciel'),
(2, 872, 'dénombrement'),
(2, 872, 'addition'),
(2, 871, 'sons'),
(2, 871, 'tutoriels'),
(2, 870, 'mathématiques'),
(2, 869, 'logiciel'),
(2, 869, 'tbi'),
(2, 868, 'utilitaires'),
(2, 868, 'logiciel'),
(2, 867, 'utilitaires'),
(2, 867, 'sons'),
(2, 866, 'vidéoprojecteur'),
(2, 865, 'jeu'),
(2, 864, 'plan'),
(2, 863, 'médias'),
(2, 862, 'jeu'),
(2, 862, 'calcul'),
(2, 861, 'musique'),
(2, 860, 'production'),
(2, 860, 'musique'),
(2, 859, 'mp3'),
(2, 858, 'radio'),
(2, 858, 'expression'),
(2, 857, 'solfège'),
(2, 856, 'vidéos'),
(2, 856, 'partitions'),
(2, 855, 'musique'),
(2, 854, 'histoire'),
(2, 854, 'dictionnaire'),
(2, 853, 'musique'),
(2, 852, 'xylophone'),
(2, 846, 'instruments'),
(2, 851, 'musique'),
(2, 851, 'mémoire'),
(2, 850, 'musique'),
(2, 850, 'jeux'),
(2, 850, 'compositeurs'),
(2, 850, 'instruments'),
(2, 849, 'musique'),
(2, 849, 'jeux'),
(2, 848, 'puzzles'),
(2, 848, 'compositeurs'),
(2, 847, 'compositeurs'),
(2, 847, 'musique'),
(2, 847, 'quiz'),
(2, 846, 'musique'),
(2, 846, 'partition'),
(2, 845, 'quiz'),
(2, 845, 'musique'),
(2, 844, 'musique'),
(2, 844, 'logiciel'),
(2, 843, 'musique'),
(2, 842, 'musique'),
(2, 841, 'musique'),
(2, 840, 'musique'),
(2, 840, 'textes'),
(2, 839, 'radio'),
(2, 838, 'musique'),
(2, 837, 'musique'),
(2, 836, 'musique'),
(2, 835, 'musique'),
(2, 834, 'mutiplications'),
(2, 834, 'mental'),
(2, 833, 'masses'),
(2, 833, 'longueurs'),
(2, 833, 'mathématiques'),
(2, 832, 'musique'),
(2, 832, 'chansons'),
(2, 831, 'musique'),
(2, 830, 'instrument'),
(2, 830, 'baroque'),
(2, 830, 'trombone'),
(2, 829, 'musique'),
(2, 828, 'logiciel'),
(2, 828, 'shareware'),
(2, 828, 'gratuit'),
(2, 827, 'wav'),
(2, 827, 'ogg'),
(2, 827, 'vorbis'),
(2, 827, 'mpc'),
(2, 827, 'son'),
(2, 826, 'musique'),
(2, 825, 'lecture'),
(2, 825, 'géographie'),
(2, 824, 'fle'),
(2, 824, 'communication'),
(2, 823, 'fle'),
(2, 822, 'lecture'),
(2, 822, 'vocabulaire'),
(2, 822, 'exercices'),
(2, 822, 'grammaire'),
(2, 822, 'sciences'),
(2, 821, 'cycle3'),
(2, 821, 'lecture'),
(2, 821, 'citoyenneté'),
(2, 820, 'environnement'),
(2, 819, 'danse'),
(2, 818, 'tic'),
(2, 817, 'compréhension'),
(2, 817, 'langue'),
(2, 816, 'compréhension'),
(2, 816, 'langue'),
(2, 814, 'énergie'),
(2, 813, 'paix'),
(2, 813, 'coopération'),
(2, 812, 'techologie'),
(2, 812, 'sciences'),
(2, 811, 'technologie'),
(2, 811, 'sciences'),
(2, 811, 'mouvement'),
(2, 810, 'recherche'),
(2, 810, 'lecture'),
(2, 810, 'cycle3'),
(2, 809, 'préhistoire'),
(2, 809, 'histoire'),
(2, 808, 'sciences'),
(2, 808, 'lecture'),
(2, 808, 'animaux'),
(2, 807, 'animaux'),
(2, 806, 'biologie'),
(2, 806, 'vivant'),
(2, 806, 'animaux'),
(2, 805, 'enseignement'),
(2, 805, 'spécialisé'),
(2, 805, 'intégration'),
(2, 804, 'jeux'),
(2, 803, 'règlement'),
(2, 802, 'cycle3'),
(2, 802, 'journal'),
(2, 801, 'récit'),
(2, 800, 'cycle2'),
(2, 800, 'journal'),
(2, 799, 'romans'),
(2, 799, 'images'),
(2, 798, 'chants'),
(2, 798, 'langues'),
(2, 798, 'anglais'),
(2, 797, 'orl'),
(2, 797, 'logiciel'),
(2, 797, 'futur'),
(2, 796, 'logiciel'),
(2, 796, 'imparfait'),
(2, 796, 'conjugaison'),
(2, 795, 'conjugaison'),
(2, 795, 'orl'),
(2, 795, 'logiciel'),
(2, 794, 'orl'),
(2, 794, 'déterminants'),
(2, 794, 'grammaire'),
(2, 780, 'géographie'),
(2, 793, 'phrase'),
(2, 793, 'complément'),
(2, 793, 'logiciel'),
(2, 792, 'grammaire'),
(2, 792, 'complément'),
(2, 792, 'logiciel'),
(2, 791, 'grammaire'),
(2, 791, 'logiciel'),
(2, 791, 'verbe'),
(2, 790, 'logiciel'),
(2, 790, 'orl'),
(2, 790, 'grammaire'),
(2, 789, 'cycle3'),
(2, 789, 'compréhension'),
(2, 789, 'lecture'),
(2, 788, 'roman'),
(2, 788, 'littérature'),
(2, 788, 'lecture'),
(2, 787, 'drury'),
(2, 787, 'littérature'),
(2, 787, 'roman'),
(2, 786, 'chocolaterie'),
(2, 786, 'roald'),
(2, 786, 'compréhension'),
(2, 786, 'littérature'),
(2, 785, 'cycle3'),
(2, 785, 'littérature'),
(2, 785, 'compréhension'),
(2, 785, 'lecture'),
(2, 784, 'cycle3'),
(2, 784, 'littérature'),
(2, 783, 'roman'),
(2, 783, 'logiciel'),
(2, 783, 'lecture'),
(2, 782, 'coopérative'),
(2, 782, 'loto'),
(2, 781, 'shareware'),
(2, 781, 'multimédia'),
(2, 780, 'histoire'),
(2, 780, 'logiciel'),
(2, 780, 'shareware'),
(2, 780, 'orl'),
(2, 780, 'lecture'),
(2, 779, 'lecture'),
(2, 779, 'orl'),
(2, 779, 'logiciel'),
(2, 779, 'shareware'),
(2, 778, 'lecture'),
(2, 778, 'orl'),
(2, 778, 'logiciel'),
(2, 778, 'shareware'),
(2, 777, 'orl'),
(2, 777, 'orthographe'),
(2, 777, 'ent'),
(2, 776, 'shareware'),
(2, 776, 'logiciel'),
(2, 775, 'enseignement'),
(2, 775, 'moteur'),
(2, 775, 'didactique'),
(2, 773, 'vocabulaire'),
(2, 772, 'puzzle'),
(2, 771, 'opération'),
(2, 771, 'mathématiques'),
(2, 771, 'cycle2'),
(2, 771, 'cycle3'),
(2, 771, 'division'),
(2, 770, 'langues'),
(2, 770, 'vivantes'),
(2, 769, 'photos'),
(2, 768, 'vivantes'),
(2, 768, 'progression'),
(2, 767, 'jeux'),
(2, 767, 'vivantes'),
(2, 767, 'langues'),
(2, 766, 'langues'),
(2, 766, 'vivantes'),
(2, 765, 'espagnol'),
(2, 765, 'vivantes'),
(2, 765, 'langues'),
(2, 764, 'langues'),
(2, 763, 'logiciel'),
(2, 763, 'payant'),
(2, 762, 'compréhension'),
(2, 762, 'langue'),
(2, 762, 'vivante'),
(2, 761, 'bande'),
(2, 761, 'dessinée'),
(2, 760, 'récits'),
(2, 758, 'dictée'),
(2, 758, 'cycle2'),
(2, 758, 'écriture'),
(2, 758, 'lecture'),
(2, 758, 'mémorisation'),
(2, 757, 'citoyenneté'),
(2, 757, 'solidarité'),
(2, 756, 'maroc'),
(2, 755, 'compréhension'),
(2, 755, 'grammaire'),
(2, 755, 'conjugaison'),
(2, 755, 'fle'),
(2, 754, 'radio'),
(2, 754, 'moteur'),
(2, 754, 'recherche'),
(2, 753, 'langue'),
(2, 753, 'français'),
(2, 753, 'fle'),
(2, 752, 'saisons'),
(2, 752, 'jour'),
(2, 752, 'astronomie'),
(2, 751, 'poésies'),
(2, 750, 'romans'),
(2, 750, 'livres'),
(2, 750, 'littérature'),
(2, 749, 'questionnaires'),
(2, 749, 'écriture'),
(2, 749, 'lecture'),
(2, 748, 'reportage'),
(2, 748, 'lecture'),
(2, 747, 'oral'),
(2, 747, 'marionnettes'),
(2, 747, 'théâtre'),
(2, 746, 'histoire'),
(2, 746, 'écriture'),
(2, 745, 'écriture'),
(2, 745, 'lettres'),
(2, 744, 'lecture'),
(2, 744, 'histoire'),
(2, 743, 'paul'),
(2, 743, 'miro'),
(2, 743, 'arts'),
(2, 742, 'paul'),
(2, 742, 'gaughin'),
(2, 742, 'arts'),
(2, 741, 'lecture'),
(2, 740, 'analyse'),
(2, 740, 'arts'),
(2, 739, 'lettres'),
(2, 739, 'abcdaire'),
(2, 728, 'observations'),
(2, 738, 'abcdaire'),
(2, 738, 'lettres'),
(2, 738, 'enleminures'),
(2, 738, 'moyen'),
(2, 737, 'musique'),
(2, 736, 'musique'),
(2, 735, 'musique'),
(2, 734, 'podcast'),
(2, 734, 'musique'),
(2, 733, 'musique'),
(2, 733, 'instruments'),
(2, 733, 'écouter'),
(2, 732, 'musique'),
(2, 732, 'écoute'),
(2, 732, 'histoire'),
(2, 731, 'musique'),
(2, 731, 'écoute'),
(2, 731, 'histoire'),
(2, 730, 'sciences'),
(2, 730, 'environnement'),
(2, 730, 'citoyenneté'),
(2, 729, 'sciences'),
(2, 729, 'magazines'),
(2, 728, 'sciences'),
(2, 728, 'astronomie'),
(2, 728, 'cycle3'),
(2, 727, 'logique'),
(2, 727, 'bricolage'),
(2, 727, 'informatique'),
(2, 727, 'jeux'),
(2, 727, 'physique'),
(2, 726, 'sciences'),
(2, 726, 'électricité'),
(2, 726, 'musée'),
(2, 725, 'volcans'),
(2, 724, 'lecture'),
(2, 724, 'éruptions'),
(2, 724, 'vulcanologues'),
(2, 724, 'tazieff'),
(2, 723, 'volcans'),
(2, 723, 'sciences'),
(2, 722, 'terre'),
(2, 722, 'environnement'),
(2, 722, 'sciences'),
(2, 721, 'sciences'),
(2, 721, 'encyclopédie'),
(2, 720, 'sciences'),
(2, 720, 'astronomie'),
(2, 719, 'sciences'),
(2, 719, 'bricolage'),
(2, 718, 'lecture'),
(2, 717, 'végétal'),
(2, 716, '3'),
(2, 716, 'eau'),
(2, 716, 'lecture'),
(2, 716, 'sciences'),
(2, 716, 'cycle'),
(2, 715, 'états'),
(2, 715, 'eau'),
(2, 715, 'sciences'),
(2, 714, '3'),
(2, 714, 'glace'),
(2, 714, 'cycle'),
(2, 714, 'lecture'),
(2, 714, 'sciences'),
(2, 713, 'eau'),
(2, 713, 'environnement'),
(2, 712, 'exerciseurs'),
(2, 712, 'industrie'),
(2, 712, 'forêt'),
(2, 711, 'techniques'),
(2, 710, 'grammaire'),
(2, 710, 'exercices'),
(2, 709, 'mathématiques'),
(2, 709, 'géométrie'),
(2, 708, 'calcul'),
(2, 708, 'mental'),
(2, 708, 'addition'),
(2, 708, 'mathématiques'),
(2, 707, 'grammaire'),
(2, 706, 'mathématiques'),
(2, 706, 'exercices'),
(2, 705, 'compas'),
(2, 705, 'figures'),
(2, 705, 'géométrie'),
(2, 705, 'construction'),
(2, 704, 'dynamique'),
(2, 704, 'instrument'),
(2, 704, 'géométrie'),
(2, 703, 'mémoire'),
(2, 703, 'mathématiques'),
(2, 703, 'jeux'),
(2, 702, 'exposition'),
(2, 702, 'durable'),
(2, 702, 'environnement'),
(2, 701, 'mathématiques'),
(2, 701, 'dictionnaire'),
(2, 700, 'échecs'),
(2, 700, 'exercices'),
(2, 699, 'mathématiques'),
(2, 699, 'calcul'),
(2, 699, 'exercices'),
(2, 698, 'lecture'),
(2, 698, 'jeux'),
(2, 698, 'magazine'),
(2, 698, 'europe'),
(2, 698, 'dictionnaire'),
(2, 697, 'ermel'),
(2, 697, 'exercices'),
(2, 696, 'lecture'),
(2, 696, 'jeux'),
(2, 696, 'magazine'),
(2, 696, 'europe'),
(2, 696, 'dictionnaire'),
(2, 695, 'documentaire'),
(2, 695, 'b2i'),
(2, 695, 'recherche'),
(2, 694, 'vélos'),
(2, 694, 'histoire'),
(2, 693, 'noël'),
(2, 692, 'libre'),
(2, 692, 'gratuit'),
(2, 692, 'traitement'),
(2, 691, 'logiciel'),
(2, 691, 'libre'),
(2, 691, 'gratuit'),
(2, 690, 'utilitaire'),
(2, 690, 'traitement'),
(2, 689, 'images'),
(2, 689, 'traitement'),
(2, 688, 'orientation'),
(2, 688, 'labyrinthe'),
(2, 687, 'logiciel'),
(2, 686, 'cycle3'),
(2, 686, 'cycle2'),
(2, 685, 'code'),
(2, 685, 'sécurité'),
(2, 685, 'logiciel'),
(2, 679, 'forum'),
(2, 678, 'drapeau'),
(2, 683, 'histoire'),
(2, 682, 'monuments'),
(2, 681, 'sécurité'),
(2, 681, 'route'),
(2, 680, 'délinquance'),
(2, 680, 'enfants'),
(2, 680, 'maltraitance'),
(2, 680, 'adoption'),
(2, 680, 'droits'),
(2, 679, 'unicef'),
(2, 679, 'droits'),
(2, 679, 'enfants'),
(2, 679, 'pauvreté'),
(2, 679, 'eau'),
(2, 679, 'environnement'),
(2, 678, 'histoire'),
(2, 677, 'sénat'),
(2, 677, 'loi'),
(2, 677, 'démocratie'),
(2, 677, 'palais'),
(2, 677, 'luxembourg'),
(2, 676, 'internet'),
(2, 675, 'géographie'),
(2, 675, 'départements'),
(2, 674, 'géographie'),
(2, 673, 'postales'),
(2, 673, 'vues'),
(2, 673, 'géographie'),
(2, 672, 'géographie'),
(2, 671, 'trajet'),
(2, 660, 'préfecture'),
(2, 669, 'dictionnaire'),
(2, 668, 'grammaire'),
(2, 666, 'dictionnaire'),
(2, 666, 'définitions'),
(2, 665, 'moteur'),
(2, 665, 'synonymes'),
(2, 664, 'population'),
(2, 663, 'logiciel'),
(2, 663, 'géographie'),
(2, 662, 'logiciel'),
(2, 662, 'freeware'),
(2, 662, 'gratuit'),
(2, 662, 'globe'),
(2, 662, 'jour'),
(2, 661, 'logiciel'),
(2, 661, 'freeware'),
(2, 660, 'cartes'),
(2, 660, 'géographie'),
(2, 660, 'départements'),
(2, 659, 'villes'),
(2, 659, 'freeware'),
(2, 659, 'gratuit'),
(2, 654, 'reportages'),
(2, 658, 'pays'),
(2, 658, 'géographie'),
(2, 657, 'gratuit'),
(2, 657, 'freeware'),
(2, 656, 'tableaux'),
(2, 656, 'géographie'),
(2, 656, 'états'),
(2, 655, 'population'),
(2, 655, 'géographie'),
(2, 654, 'articles'),
(2, 654, 'geo'),
(2, 653, 'frise'),
(2, 653, 'histoire'),
(2, 653, 'tutoriel'),
(2, 652, 'événements'),
(2, 652, 'gratuit'),
(2, 652, 'frise'),
(2, 652, 'logiciel'),
(2, 651, 'géographie'),
(2, 651, 'carte'),
(2, 650, 'cartes'),
(2, 649, 'histoire'),
(2, 649, 'géographie'),
(2, 648, 'moteur'),
(2, 648, 'recherche'),
(2, 647, 'plans'),
(2, 642, 'cycle3'),
(2, 646, 'géographie'),
(2, 645, 'vues'),
(2, 645, 'cartes'),
(2, 645, 'satellites'),
(2, 645, 'plans'),
(2, 644, 'topographique'),
(2, 644, 'géographie'),
(2, 643, 'géographie'),
(2, 642, 'géographie'),
(2, 642, 'côtes'),
(2, 642, 'mer'),
(2, 642, 'paysage'),
(2, 641, 'télé'),
(2, 641, 'presse'),
(2, 626, 'lecture'),
(2, 640, 'géographie'),
(2, 639, 'europe'),
(2, 639, 'drapeaux'),
(2, 639, 'hymnes'),
(2, 639, 'atlas'),
(2, 639, 'géographie'),
(2, 639, 'pays'),
(2, 638, 'libre'),
(2, 638, 'continents'),
(2, 638, 'cartes'),
(2, 637, 'géographie'),
(2, 637, 'départements'),
(2, 637, 'régions'),
(2, 636, 'mondiale'),
(2, 636, 'guerre'),
(2, 635, 'lecture'),
(2, 635, 'histoire'),
(2, 635, 'guerre'),
(2, 634, 'nazis'),
(2, 634, 'guerre'),
(2, 634, 'mondiale'),
(2, 634, 'juifs'),
(2, 633, 'histoire'),
(2, 633, 'guerre'),
(2, 633, 'seconde'),
(2, 633, 'mondiale'),
(2, 632, 'écriture'),
(2, 632, 'juifs'),
(2, 632, 'journal'),
(2, 631, 'vidéo'),
(2, 631, 'seconde'),
(2, 631, 'guerre'),
(2, 630, 'mondiale'),
(2, 630, 'histoire'),
(2, 629, 'lecture'),
(2, 629, 'sacre'),
(2, 629, 'histoire'),
(2, 629, 'napoléon'),
(2, 628, 'versailles'),
(2, 628, 'histoire'),
(2, 627, 'divertissement'),
(2, 627, 'repas'),
(2, 627, 'rois'),
(2, 627, 'travail'),
(2, 627, 'religion'),
(2, 626, 'château'),
(2, 626, 'loire'),
(2, 625, 'tableaux'),
(2, 625, 'lecture'),
(2, 625, 'biographie'),
(2, 625, 'arts'),
(2, 625, 'léonard'),
(2, 624, 'inventions'),
(2, 623, 'ville'),
(2, 623, 'recherche'),
(2, 623, 'paris'),
(2, 623, 'philippe'),
(2, 623, 'auguste'),
(2, 623, 'vie'),
(2, 622, 'moyen'),
(2, 622, 'cathédrales'),
(2, 622, 'images'),
(2, 621, 'cd'),
(2, 621, 'rom'),
(2, 621, 'oeuvres'),
(2, 621, 'arts'),
(2, 619, 'cycle3'),
(2, 620, 'antiquité'),
(2, 620, 'peinture'),
(2, 620, 'histoire'),
(2, 620, 'moteur'),
(2, 619, 'histoire'),
(2, 619, 'cathédrales'),
(2, 619, 'arts'),
(2, 618, 'histoire'),
(2, 618, 'moyen'),
(2, 618, 'âge'),
(2, 618, 'églises'),
(2, 617, 'images'),
(2, 617, 'rois'),
(2, 617, 'moyen'),
(2, 617, 'âge'),
(2, 617, 'histoire'),
(2, 617, 'chevaliers'),
(2, 616, 'chevaliers'),
(2, 616, 'paysans'),
(2, 616, 'seigneurs'),
(2, 616, 'moines'),
(2, 616, 'lecture'),
(2, 616, 'cycle3'),
(2, 615, 'jeux'),
(2, 615, 'vie'),
(2, 615, 'vidéo'),
(2, 615, 'seigneurs'),
(2, 615, 'paysans'),
(2, 615, 'histoire'),
(2, 614, 'rechercher'),
(2, 614, 'histoire'),
(2, 614, 'cycle3'),
(2, 614, 'chevaliers'),
(2, 614, 'paysans'),
(2, 613, 'lecture'),
(2, 613, 'histoire'),
(2, 613, 'moyen'),
(2, 612, 'musée'),
(2, 612, 'histoire'),
(2, 612, 'moyen'),
(2, 612, 'âge'),
(2, 612, 'images'),
(2, 611, 'cité'),
(2, 611, 'romains'),
(2, 610, 'romains'),
(2, 609, 'rip'),
(2, 609, 'dvd'),
(2, 609, 'moyen'),
(2, 609, 'âge'),
(2, 608, 'gaule'),
(2, 608, 'romaine'),
(2, 608, 'histoire'),
(2, 607, 'clovis'),
(2, 607, 'empereur'),
(2, 607, 'normands'),
(2, 607, 'guerres'),
(2, 606, 'histoire'),
(2, 606, 'périodes'),
(2, 606, 'personnages'),
(2, 606, 'évènements'),
(2, 606, 'monuments'),
(2, 605, 'histoire'),
(2, 604, 'histoire'),
(2, 604, 'guerre'),
(2, 604, 'lecture'),
(2, 604, 'gaulle'),
(2, 603, 'dates'),
(2, 603, 'personnages'),
(2, 603, 'noms'),
(2, 602, 'histoire'),
(2, 601, 'lecture'),
(2, 601, 'documents'),
(2, 601, 'alésia'),
(2, 601, 'gaule'),
(2, 601, 'histoire'),
(2, 601, 'guerre'),
(2, 600, 'oiseaux'),
(2, 600, 'recherche'),
(2, 599, 'images'),
(2, 599, 'arts'),
(2, 599, 'enluminures'),
(2, 599, 'moyen'),
(2, 598, 'dictionnaires'),
(2, 598, 'cartes'),
(2, 597, 'villes'),
(2, 597, 'france'),
(2, 596, 'départements'),
(2, 596, 'france'),
(2, 596, 'mappy'),
(2, 595, 'gaulois'),
(2, 595, 'histoire'),
(2, 595, 'gaulle'),
(2, 594, 'histoire'),
(2, 594, 'gaulois'),
(2, 594, 'gaulle'),
(2, 592, 'préhisroire'),
(2, 591, 'préhisroire'),
(2, 590, 'préhistoire'),
(2, 589, 'synonymes'),
(2, 589, 'dictionnaires'),
(2, 588, 'sélection'),
(2, 588, 'compréhension'),
(2, 587, 'contes'),
(2, 587, 'littérature'),
(2, 587, 'narration'),
(2, 587, 'mise'),
(2, 587, 'en'),
(2, 587, 'scène'),
(2, 587, 'personnage'),
(2, 586, 'histoire'),
(2, 585, 'contes'),
(2, 584, 'saint'),
(2, 584, 'littérature'),
(2, 584, 'jeunesse'),
(2, 583, 'victor'),
(2, 583, 'hugo'),
(2, 583, 'poésies'),
(2, 582, '3'),
(2, 582, 'verne'),
(2, 582, 'littérature'),
(2, 582, 'jules'),
(2, 581, 'illustration'),
(2, 581, 'la'),
(2, 581, 'fontaine'),
(2, 581, 'répertoire'),
(2, 581, 'fables'),
(2, 581, 'littérature'),
(2, 580, 'littérature'),
(2, 580, 'policier'),
(2, 580, 'enquête'),
(2, 580, 'lecture'),
(2, 580, 'énigmes'),
(2, 579, 'recherche'),
(2, 579, 'moteur'),
(2, 578, 'cycle3'),
(2, 578, 'histoire'),
(2, 578, 'récit'),
(2, 577, 'cycle3'),
(2, 577, 'journal'),
(2, 576, 'journaux'),
(2, 576, 'écrire'),
(2, 576, 'lire'),
(2, 575, 'média'),
(2, 574, 'musique'),
(2, 574, 'instruments'),
(2, 574, 'jeux'),
(2, 573, 'jeux'),
(2, 573, 'musique'),
(2, 573, 'orchestre'),
(2, 572, 'instruments'),
(2, 572, 'classification'),
(2, 571, 'orchestre'),
(2, 570, 'vocabulaire'),
(2, 976, 'élèves'),
(2, 974, 'chiffres'),
(2, 975, 'anglais'),
(2, 974, 'lettres'),
(2, 973, 'lettres'),
(2, 973, 'alphabet'),
(2, 972, 'gratuit'),
(2, 971, 'europe'),
(2, 971, 'projets'),
(2, 970, 'français'),
(2, 969, 'musique'),
(2, 968, 'effets'),
(2, 966, 'bruits'),
(2, 965, 'sonore'),
(2, 963, 'sons'),
(2, 962, 'cycle1'),
(2, 961, 'recherche'),
(2, 960, 'lecture'),
(2, 960, 'écriture'),
(2, 959, 'patrons'),
(2, 958, 'primtice'),
(2, 957, 'portail'),
(2, 956, 'étrangers'),
(2, 955, 'turc'),
(2, 955, 'arabe'),
(2, 953, 'juridique'),
(2, 953, 'internet'),
(2, 952, 'sécurité'),
(2, 952, 'internet'),
(2, 951, 'cel'),
(2, 951, 'contrat'),
(2, 950, 'restauratrion'),
(2, 949, 'école'),
(2, 948, 'légifrance'),
(2, 942, 'zep'),
(2, 945, 'afl'),
(2, 944, 'divorce'),
(2, 943, 'comportement'),
(2, 940, 'liaisoncm2'),
(2, 939, 'enfants'),
(2, 938, 'absentéisme'),
(2, 930, 'journal'),
(2, 935, 'bonaparte'),
(2, 934, 'cycle2'),
(2, 933, 'géométrie'),
(2, 932, 'arts'),
(2, 929, 'cycle3'),
(2, 930, 'documents'),
(2, 930, 'actualité'),
(2, 928, 'citoyenneté'),
(2, 927, 'animaux'),
(2, 925, 'cyle2'),
(2, 924, 'zoologie'),
(2, 923, 'projets'),
(2, 920, 'écosystème'),
(2, 919, 'jurispridence'),
(2, 917, 'jurisprudence'),
(2, 916, 'animations'),
(2, 915, 'gs'),
(2, 914, 'cycle2'),
(2, 913, 'géographie'),
(2, 913, 'lecture'),
(2, 912, 'libre'),
(2, 911, 'libre'),
(2, 911, 'logiciel'),
(2, 910, 'cycle2'),
(2, 909, 'libre'),
(2, 908, 'maternelle'),
(2, 904, 'mémoire'),
(2, 906, 'gratuit'),
(2, 905, 'logiciel'),
(2, 903, 'maternelle'),
(2, 902, 'cycle1'),
(2, 902, 'labyrinthe'),
(2, 888, 'gratuit'),
(2, 900, 'libre'),
(2, 899, 'logiciel'),
(2, 898, 'cycle3'),
(2, 897, 'symétrie'),
(2, 896, 'cycle2'),
(2, 895, 'tables'),
(2, 894, 'outils'),
(2, 893, 'logiciel'),
(2, 892, 'logiciel'),
(2, 892, 'libre'),
(2, 891, 'gratuit'),
(2, 890, 'libre'),
(2, 889, 'sciences'),
(2, 887, 'logiciel'),
(2, 886, 'cycle1'),
(2, 885, 'mutimédias'),
(2, 884, 'payant'),
(2, 883, 'pensée'),
(2, 882, 'dictionnaire'),
(2, 881, 'cycle3'),
(2, 880, 'gratuit'),
(2, 879, 'calcul'),
(2, 877, 'cp'),
(2, 876, 'cycle2'),
(2, 875, 'gratuit'),
(2, 874, 'images'),
(2, 873, 'cycle2'),
(2, 872, 'mémory'),
(2, 871, 'libre'),
(2, 870, 'géométrie'),
(2, 869, 'mathématiques'),
(2, 868, 'images'),
(2, 867, 'logiciel'),
(2, 866, 'tbi'),
(2, 865, 'attention'),
(2, 864, 'villes'),
(2, 861, 'instruments'),
(2, 854, 'musique'),
(2, 859, 'sons'),
(2, 858, 'orale'),
(2, 857, 'musique'),
(2, 856, 'musique'),
(2, 840, 'voisins'),
(2, 853, 'annuaire'),
(2, 852, 'instrument'),
(2, 851, 'logiciel'),
(2, 850, 'danses'),
(2, 849, 'mots'),
(2, 848, 'musique'),
(2, 847, 'instuments'),
(2, 844, 'compositeur'),
(2, 846, 'compositeurs'),
(2, 845, 'compositeurs'),
(2, 844, 'gratuit'),
(2, 842, 'payant'),
(2, 841, 'chorale'),
(2, 840, 'auteurs'),
(2, 839, 'musique'),
(2, 838, 'monde'),
(2, 836, 'culture'),
(2, 835, 'culture'),
(2, 834, 'calcul'),
(2, 833, 'capacité'),
(2, 832, 'compositeurs'),
(2, 831, 'compositeurs'),
(2, 830, 'flûte'),
(2, 671, 'plans'),
(2, 829, 'partition'),
(2, 828, 'musique'),
(2, 827, 'logiciel'),
(2, 827, 'audio'),
(2, 826, 'formation'),
(2, 825, 'cycle3'),
(2, 824, 'français'),
(2, 823, 'français'),
(2, 822, 'anglais'),
(2, 822, 'pays'),
(2, 821, 'pollution'),
(2, 820, 'documentation'),
(2, 819, 'musique'),
(2, 818, 'blogs'),
(2, 817, 'anglais'),
(2, 816, 'anglais'),
(2, 814, 'sciences'),
(2, 813, 'citoyenneté'),
(2, 812, 'air'),
(2, 811, 'cycle3'),
(2, 809, 'dinosaures'),
(2, 808, 'biologie'),
(2, 807, 'lecture'),
(2, 806, 'plantes'),
(2, 805, 'adaptation'),
(2, 804, 'eps'),
(2, 803, 'citoyenneté'),
(2, 802, 'actualités'),
(2, 800, 'actualités'),
(2, 672, 'plan'),
(2, 798, 'chansons'),
(2, 797, 'conjugaison'),
(2, 796, 'orl'),
(2, 795, 'présent'),
(2, 794, 'cycle3'),
(2, 794, 'logiciel'),
(2, 793, 'grammaire'),
(2, 792, 'cycle3'),
(2, 791, 'phrase'),
(2, 790, 'sujet'),
(2, 788, 'narcejac'),
(2, 789, 'littérature'),
(2, 787, 'cycle3'),
(2, 786, 'cycle3'),
(2, 786, 'lecture'),
(2, 785, 'harry'),
(2, 785, 'potter'),
(2, 704, 'libre'),
(2, 783, 'freeware'),
(2, 782, 'logiciel'),
(2, 781, 'logiciel'),
(2, 780, 'cycle2'),
(2, 780, 'cycle3'),
(2, 779, 'cycle2'),
(2, 778, 'ent'),
(2, 777, 'payant'),
(2, 777, 'cycle3'),
(2, 776, 'lecture'),
(2, 771, 'gratuit'),
(2, 775, 'pédagogie'),
(2, 773, 'maison'),
(2, 771, 'soustraction'),
(2, 771, 'addition'),
(2, 770, 'images'),
(2, 769, 'images'),
(2, 768, 'langues'),
(2, 767, 'cycle3'),
(2, 765, 'allemand'),
(2, 764, 'vivantes'),
(2, 763, 'arts'),
(2, 762, 'orale'),
(2, 761, 'lecture'),
(2, 759, 'orl'),
(2, 750, 'albums'),
(2, 758, 'cycle3'),
(2, 757, 'presse'),
(2, 756, 'elco'),
(2, 755, 'vocabulaire'),
(2, 755, 'langue'),
(2, 754, 'dossier'),
(2, 753, 'orale'),
(2, 752, 'nuit'),
(2, 751, 'lecture'),
(2, 750, 'écriture'),
(2, 749, 'romans'),
(2, 748, 'himalaya'),
(2, 747, 'langage'),
(2, 746, 'alphabets'),
(2, 745, 'histoire'),
(2, 743, 'vidéo'),
(2, 742, 'vidéo'),
(2, 740, 'visuels'),
(2, 739, 'anglais'),
(2, 738, 'abécédaire'),
(2, 738, 'cycle1'),
(2, 737, 'monde'),
(2, 736, 'instruments'),
(2, 735, 'compositeurs'),
(2, 734, 'baladodiffusion'),
(2, 733, 'manipuler'),
(2, 732, 'moyen'),
(2, 731, 'enluminures'),
(2, 731, 'moyen'),
(2, 730, 'lecture'),
(2, 729, 'défis'),
(2, 727, 'biologie'),
(2, 727, 'arts'),
(2, 726, 'lecture'),
(2, 725, 'sciences'),
(2, 724, 'volcans'),
(2, 724, 'sciences'),
(2, 723, 'lecture'),
(2, 722, 'lecture'),
(2, 722, 'écologie'),
(2, 720, 'cycle3'),
(2, 721, 'lecture'),
(2, 720, 'lecture'),
(2, 718, 'forêt'),
(2, 719, 'lecture'),
(2, 716, 'évaporation'),
(2, 715, 'changements'),
(2, 714, 'eau'),
(2, 714, 'histoire'),
(2, 713, 'cycle'),
(2, 712, 'environnement'),
(2, 711, 'mathématiques'),
(2, 710, 'orthographe'),
(2, 709, 'construction'),
(2, 708, 'multiplication'),
(2, 706, 'corrections'),
(2, 703, 'problèmes'),
(2, 705, 'tracer'),
(2, 703, 'outils'),
(2, 702, 'développement'),
(2, 701, 'définitions'),
(2, 700, 'calcul'),
(2, 699, 'logiciel'),
(2, 698, 'environnement'),
(2, 698, 'concours'),
(2, 697, 'calcul'),
(2, 696, 'environnement'),
(2, 696, 'concours'),
(2, 695, 'internet'),
(2, 694, 'bicyclette'),
(2, 692, 'images'),
(2, 691, 'diapositives'),
(2, 690, 'sons'),
(2, 689, 'dimension'),
(2, 688, 'logiciel'),
(2, 687, 'écoute'),
(2, 685, 'freeware'),
(2, 684, 'gratuit'),
(2, 683, 'lecture'),
(2, 680, 'violence'),
(2, 680, 'toxicomanie'),
(2, 679, 'sida'),
(2, 679, 'médias'),
(2, 678, 'citoyenneté'),
(2, 677, 'lecture'),
(2, 677, 'racisme'),
(2, 676, 'usages'),
(2, 675, 'cartes'),
(2, 674, 'cartes'),
(2, 673, 'aériennes'),
(2, 672, 'carte'),
(2, 670, 'plans'),
(2, 669, 'vocabulaire'),
(2, 668, 'vocabulaire'),
(2, 667, 'traducteur'),
(2, 666, 'traductions'),
(2, 665, 'expressions'),
(2, 665, 'dictionnaire'),
(2, 663, 'gratuit'),
(2, 662, 'nuit'),
(2, 662, 'rotation'),
(2, 661, 'cartes'),
(2, 660, 'régions'),
(2, 659, 'géographie'),
(2, 658, 'france'),
(2, 657, 'logiciel'),
(2, 655, 'départements'),
(2, 654, 'revue'),
(2, 653, 'gratuit'),
(2, 652, 'freeware'),
(2, 650, 'géographie'),
(2, 649, 'chroniques'),
(2, 648, 'google'),
(2, 646, 'carte'),
(2, 645, 'géographie'),
(2, 645, 'images'),
(2, 644, 'carte'),
(2, 643, 'citoyenneté'),
(2, 642, 'moteur'),
(2, 640, 'monde'),
(2, 639, 'amérique'),
(2, 639, 'antarctique'),
(2, 639, 'afrique'),
(2, 638, 'géographie'),
(2, 621, 'lecture'),
(2, 637, 'libre'),
(2, 636, 'normandie'),
(2, 635, 'seconde'),
(2, 635, 'mondiale'),
(2, 634, 'nazisme'),
(2, 634, 'histoire'),
(2, 633, 'lecture'),
(2, 632, 'frank'),
(2, 631, 'histoire'),
(2, 630, 'guerre'),
(2, 629, 'vidéo'),
(2, 629, 'peinture'),
(2, 628, 'château'),
(2, 627, 'versailles'),
(2, 625, 'vinci'),
(2, 625, 'vie'),
(2, 623, 'quotidienne'),
(2, 624, 'découvertes'),
(2, 623, 'histoire'),
(2, 623, 'moyen'),
(2, 623, 'âge'),
(2, 622, 'lecture'),
(2, 621, 'artistes'),
(2, 621, 'techniques'),
(2, 620, 'contemporaine'),
(2, 620, 'moderne'),
(2, 619, 'lecture'),
(2, 618, 'lecture'),
(2, 618, 'roman'),
(2, 617, 'champs'),
(2, 617, 'paysans'),
(2, 616, 'histoire'),
(2, 616, 'moyen'),
(2, 615, 'chevaliers'),
(2, 615, 'âge'),
(2, 614, 'divertissements'),
(2, 614, 'moyen'),
(2, 613, 'cycle3'),
(2, 612, 'lecture'),
(2, 611, 'histoire'),
(2, 609, 'atlas'),
(2, 609, 'histoire'),
(2, 608, 'animation'),
(2, 607, 'baptême'),
(2, 606, 'politiques'),
(2, 605, 'cartes'),
(2, 604, 'gaulois'),
(2, 603, 'index'),
(2, 602, 'frise'),
(2, 599, 'renard'),
(2, 601, 'gaules'),
(2, 601, 'armées'),
(2, 600, 'document'),
(2, 599, 'âge'),
(2, 599, 'roman'),
(2, 597, 'orthographe'),
(2, 596, 'géoportail'),
(2, 596, 'michelin'),
(2, 594, 'grèce'),
(2, 593, 'menhirs'),
(2, 592, 'histoire'),
(2, 591, 'histoire'),
(2, 590, 'histoire'),
(2, 589, 'conugaison'),
(2, 588, 'lecture'),
(2, 587, 'bulles'),
(2, 587, 'cycle'),
(2, 586, 'frise'),
(2, 585, 'lecture'),
(2, 584, 'exupéry'),
(2, 583, 'cycle3'),
(2, 582, 'cycle'),
(2, 582, 'vidéo'),
(2, 581, 'cucle'),
(2, 581, '3'),
(2, 581, 'ce2'),
(2, 579, 'humour'),
(2, 580, 'écriture'),
(2, 579, 'poésies'),
(2, 578, 'calligraphie'),
(2, 577, 'actualités'),
(2, 576, 'médias'),
(2, 574, 'cycle2'),
(2, 573, 'instruments'),
(2, 572, 'schéma'),
(2, 570, 'définition'),
(2, 976, 'écoles'),
(2, 973, 'multiplication'),
(2, 972, 'continents'),
(2, 970, 'communication'),
(2, 963, 'ogg'),
(2, 965, 'effeit'),
(2, 964, 'sons'),
(2, 962, 'gs'),
(2, 961, 'langue'),
(2, 960, 'mathématiques'),
(2, 959, 'solides'),
(2, 957, 'educnet'),
(2, 956, 'casnav'),
(2, 955, 'espagnol'),
(2, 954, 'étrangers'),
(2, 953, 'citoyenneté'),
(2, 922, 'cycle3'),
(2, 951, 'collectvités'),
(2, 948, 'éducation'),
(2, 946, 'inscriptions'),
(2, 941, 'actes'),
(2, 940, '6ème'),
(2, 939, 'citoyenneté'),
(2, 936, 'actualités'),
(2, 933, 'mathématiques'),
(2, 931, 'actualités'),
(2, 929, 'actualités'),
(2, 926, 'environnement'),
(2, 925, 'cycle3'),
(2, 924, 'règne'),
(2, 922, 'biologie'),
(2, 921, 'expériences'),
(2, 918, 'directeur'),
(2, 917, 'internet'),
(2, 914, 'cycle1'),
(2, 912, 'échecs'),
(2, 911, 'gratuit'),
(2, 910, 'logiciel'),
(2, 909, 'gratuit'),
(2, 908, 'souris'),
(2, 906, 'maternelle'),
(2, 905, 'libre'),
(2, 904, 'logiciel'),
(2, 903, 'labyrinthe'),
(2, 899, 'libre'),
(2, 901, 'visuelle'),
(2, 900, 'logiciel'),
(2, 899, 'cycle3'),
(2, 898, 'calcul'),
(2, 898, 'opérations'),
(2, 897, 'gémoétrie'),
(2, 894, 'mathématiques'),
(2, 893, 'libre'),
(2, 892, 'cycle3'),
(2, 891, 'géométrie'),
(2, 890, 'cycle3'),
(2, 889, 'mathématiques'),
(2, 888, 'dynamique'),
(2, 887, 'cycle3'),
(2, 884, 'rip'),
(2, 885, 'logiciels'),
(2, 884, 'logiciel'),
(2, 883, 'logiciel'),
(2, 881, 'géométrie'),
(2, 880, 'cycle2'),
(2, 878, 'logiciel'),
(2, 877, 'gs'),
(2, 875, 'allemand'),
(2, 872, 'cycle2'),
(2, 871, 'logiciel'),
(2, 866, 'logiciel'),
(2, 865, 'logiciel'),
(2, 864, 'géographie'),
(2, 863, 'images'),
(2, 862, 'mathématiques'),
(2, 859, 'musique'),
(2, 858, 'oral'),
(2, 857, 'logiciel'),
(2, 856, 'guitare'),
(2, 855, 'partitions'),
(2, 851, 'attention'),
(2, 850, 'jazz'),
(2, 849, 'mêlés'),
(2, 847, 'chanteurs'),
(2, 843, 'instrument'),
(2, 842, 'logiciel'),
(2, 841, 'chants'),
(2, 838, 'glossaire'),
(2, 833, 'cycle3'),
(2, 830, 'musique'),
(2, 829, 'encore'),
(2, 828, 'partition'),
(2, 827, 'mp3'),
(2, 825, 'faim'),
(2, 824, 'orale'),
(2, 822, 'arbres'),
(2, 821, 'sciences'),
(2, 819, 'eps'),
(2, 818, 'b2i'),
(2, 817, 'oral'),
(2, 816, 'oral'),
(2, 814, 'cycle3'),
(2, 811, 'air'),
(2, 810, 'biologie'),
(2, 801, 'lecture'),
(2, 807, 'document'),
(2, 806, 'sciences'),
(2, 805, 'ais'),
(2, 804, 'cour'),
(2, 802, 'presse'),
(2, 801, 'oral'),
(2, 800, 'presse'),
(2, 798, 'vivantes'),
(2, 797, 'cycle3'),
(2, 796, 'cycle3'),
(2, 793, 'cycle3'),
(2, 793, 'analyse'),
(2, 793, 'circonstanciel'),
(2, 792, 'orl'),
(2, 791, 'analyse'),
(2, 790, 'analyse'),
(2, 789, 'roman'),
(2, 788, 'compréhension'),
(2, 787, 'compréhension'),
(2, 786, 'charlie'),
(2, 785, 'gratuit'),
(2, 785, 'logiciel'),
(2, 784, 'payant'),
(2, 783, 'cycle3'),
(2, 780, 'gratuit'),
(2, 778, 'cycle3'),
(2, 777, 'logiciel'),
(2, 776, 'cycle2'),
(2, 775, 'recherche'),
(2, 773, 'anglais'),
(2, 772, 'jeux'),
(2, 770, 'anglais'),
(2, 769, 'albums'),
(2, 766, 'évaluations'),
(2, 765, 'anglais'),
(2, 760, 'écriture'),
(2, 759, 'orthographe'),
(2, 758, 'copie'),
(2, 757, 'actualités'),
(2, 756, 'b2i'),
(2, 752, 'étoile'),
(2, 754, 'actualités'),
(2, 753, 'écrite'),
(2, 752, 'lune'),
(2, 751, 'jeux'),
(2, 750, 'lecture'),
(2, 749, 'projets'),
(2, 748, 'géographie'),
(2, 747, 'expression'),
(2, 744, 'géographie'),
(2, 741, 'cirque'),
(2, 739, 'abécédaire'),
(2, 738, 'cycle2'),
(2, 737, 'écoute'),
(2, 736, 'flûte'),
(2, 733, 'cycle2'),
(2, 732, 'âge'),
(2, 731, 'âge'),
(2, 730, 'emballages'),
(2, 729, 'actualités'),
(2, 728, 'lecture'),
(2, 726, 'cycle3'),
(2, 725, 'lecture'),
(2, 724, 'krafft'),
(2, 723, 'cycle3'),
(2, 717, 'biologie'),
(2, 716, 'vapeur'),
(2, 715, 'cycle3'),
(2, 714, 'vapeur'),
(2, 711, 'additions'),
(2, 711, 'opérations'),
(2, 710, 'calcul'),
(2, 708, 'soustraction'),
(2, 707, 'orl'),
(2, 705, 'équerre'),
(2, 704, 'logiciel'),
(2, 703, 'logique'),
(2, 702, 'affiches'),
(2, 700, 'jeux'),
(2, 699, 'gratuit'),
(2, 690, 'logiciel'),
(2, 698, 'citoyenneté'),
(2, 697, 'jeux'),
(2, 684, 'logiciel'),
(2, 696, 'citoyenneté'),
(2, 695, 'cycle3'),
(2, 693, 'contes'),
(2, 692, 'logiciel'),
(2, 691, 'diaporama'),
(2, 688, 'gratuite'),
(2, 687, 'coin'),
(2, 686, 'mathématiques'),
(2, 685, 'danger'),
(2, 683, 'esclavage'),
(2, 682, 'histoire'),
(2, 681, 'prévention'),
(2, 680, 'sectes'),
(2, 679, 'lecture'),
(2, 678, 'république'),
(2, 677, 'discrimination'),
(2, 669, 'conjugaison'),
(2, 674, 'animation'),
(2, 673, 'cartes'),
(2, 671, 'itinéraires'),
(2, 670, 'géographie'),
(2, 669, 'grammaire'),
(2, 668, 'dictionnaire'),
(2, 667, 'dictionnaire'),
(2, 665, 'conjugaison'),
(2, 664, 'insee'),
(2, 663, 'cartes'),
(2, 662, 'terre'),
(2, 659, 'logiciel'),
(2, 658, 'usa'),
(2, 657, 'géographie'),
(2, 656, 'drapeaux'),
(2, 654, 'géographie'),
(2, 652, 'dates'),
(2, 651, 'gratuit'),
(2, 647, 'échelles'),
(2, 645, 'échelle'),
(2, 643, 'europe'),
(2, 642, 'lecture'),
(2, 641, 'journaux'),
(2, 640, 'libre'),
(2, 639, 'cartes'),
(2, 634, 'lecture'),
(2, 638, 'monde'),
(2, 634, 'judaïsme'),
(2, 637, 'cartes'),
(2, 636, '1944'),
(2, 635, 'débarquement'),
(2, 634, 'shoah'),
(2, 633, 'écriture'),
(2, 632, 'lecture'),
(2, 623, 'lecture'),
(2, 630, 'débarquement'),
(2, 629, 'cycle3'),
(2, 627, 'histoire'),
(2, 627, 'lecture'),
(2, 626, 'renaissance'),
(2, 625, 'oeuvre'),
(2, 624, 'lecture'),
(2, 622, 'recherche'),
(2, 622, 'histoire'),
(2, 621, 'visuels'),
(2, 620, 'médiéval'),
(2, 620, 'sculpture'),
(2, 618, 'art'),
(2, 617, 'vie'),
(2, 616, 'âge'),
(2, 616, 'château'),
(2, 615, 'cycle3'),
(2, 614, 'lecture'),
(2, 613, 'château'),
(2, 612, 'cycle3'),
(2, 611, 'bâtiments'),
(2, 610, 'gaulois'),
(2, 609, 'châteaux'),
(2, 606, 'frise'),
(2, 605, 'atlas'),
(2, 604, 'peuple'),
(2, 603, 'histoire'),
(2, 602, 'dossier'),
(2, 601, 'césar'),
(2, 601, 'recherche'),
(2, 599, 'bestiaire'),
(2, 598, 'recherche'),
(2, 597, 'dictionnaire'),
(2, 596, 'cartes'),
(2, 595, 'peuple'),
(2, 593, 'mégalithes'),
(2, 589, 'anglais'),
(2, 587, 'narrateur'),
(2, 586, 'france'),
(2, 583, 'écoute'),
(2, 584, 'cycle3'),
(2, 583, 'littérature'),
(2, 581, 'cm2'),
(2, 580, 'cycle3'),
(2, 577, 'presse'),
(2, 576, 'presse'),
(2, 574, 'cycle1'),
(2, 573, 'écoute'),
(2, 572, 'musique'),
(2, 571, 'instruments'),
(2, 975, 'allemand'),
(2, 962, 'cp'),
(2, 959, 'cube'),
(2, 955, 'anglais'),
(2, 954, 'fle'),
(2, 950, 'santé'),
(2, 949, 'maternelle'),
(2, 946, 'élections'),
(2, 936, 'cycle3'),
(2, 934, 'cycle3'),
(2, 933, 'expression'),
(2, 924, 'animal'),
(2, 921, 'liquide'),
(2, 919, 'évacuation'),
(2, 918, 'écoles'),
(2, 914, 'cycle3'),
(2, 913, 'paysage'),
(2, 907, 'labyrinthe'),
(2, 907, 'géométrie'),
(2, 906, 'cycle1'),
(2, 905, 'cycle1'),
(2, 896, 'cycle3'),
(2, 895, 'multiplication'),
(2, 893, 'mesures'),
(2, 892, 'gratuit'),
(2, 888, 'libre'),
(2, 887, 'libre'),
(2, 886, 'cycle2'),
(2, 883, 'libre'),
(2, 877, 'albums'),
(2, 876, 'cycle3'),
(2, 875, 'anglais'),
(2, 874, 'freeware'),
(2, 872, 'soustraction'),
(2, 860, 'jazz'),
(2, 855, 'chants'),
(2, 850, 'chanson'),
(2, 843, 'jeux'),
(2, 840, 'droits'),
(2, 839, 'écoute'),
(2, 834, 'additions'),
(2, 676, 'charte'),
(2, 825, 'afrique'),
(2, 822, 'fleurs'),
(2, 810, 'animaux'),
(2, 813, 'démocratie'),
(2, 808, 'milieu'),
(2, 800, 'cycle3'),
(2, 799, 'citoyenneté'),
(2, 792, 'analyse'),
(2, 787, 'lecture'),
(2, 786, 'dahl'),
(2, 784, 'roman'),
(2, 782, 'shareware'),
(2, 779, 'gratuit'),
(2, 779, 'cycle3'),
(2, 749, 'contes'),
(2, 761, 'astronomie'),
(2, 759, 'dictée'),
(2, 749, 'albums'),
(2, 740, 'regard'),
(2, 738, 'cycle3'),
(2, 733, 'cycle3'),
(2, 728, 'expériences'),
(2, 727, 'expériences'),
(2, 716, 'jeux'),
(2, 714, 'évaporation'),
(2, 707, 'conjugaison'),
(2, 685, 'gratuit'),
(2, 684, 'qcm'),
(2, 677, 'environnement'),
(2, 675, 'régions'),
(2, 673, 'photos'),
(2, 671, 'géograohie'),
(2, 651, 'logiciel'),
(2, 648, 'livres'),
(2, 639, 'asie'),
(2, 639, 'continent'),
(2, 638, 'pays'),
(2, 633, 'cycle3'),
(2, 632, 'anne'),
(2, 631, 'mondiale'),
(2, 627, 'château'),
(2, 624, 'histoire'),
(2, 622, 'âge'),
(2, 621, 'peinture'),
(2, 620, 'architecture'),
(2, 617, 'lecture'),
(2, 615, 'moyen'),
(2, 614, 'âge'),
(2, 613, 'âge'),
(2, 612, 'définitions'),
(2, 611, 'habitants'),
(2, 608, 'carte'),
(2, 606, 'régimes'),
(2, 594, 'grecs'),
(2, 587, '2'),
(2, 585, 'perrault'),
(2, 572, 'cycle3'),
(2, 574, 'cycle3'),
(2, 913, 'cycle3'),
(2, 954, 'arrivants'),
(2, 950, 'horaires'),
(2, 949, 'inscription'),
(2, 947, 'bulletin'),
(2, 947, 'bo'),
(2, 946, 'parents'),
(2, 942, 'philosophie'),
(2, 937, 'manouche'),
(2, 931, 'presse'),
(2, 901, 'logiciel'),
(2, 883, 'gratuit'),
(2, 873, 'cycle1'),
(2, 852, 'musique'),
(2, 795, 'cycle3'),
(2, 777, 'shareware'),
(2, 771, 'logiciel'),
(2, 767, 'anglais'),
(2, 766, 'cycle3'),
(2, 763, 'visuels'),
(2, 762, 'anglais'),
(2, 760, 'contes'),
(2, 744, 'chine'),
(2, 743, 'visuels'),
(2, 742, 'visuels'),
(2, 738, 'âge'),
(2, 727, 'environnement'),
(2, 717, 'arbres'),
(2, 716, 'glace'),
(2, 705, 'cycle3'),
(2, 712, 'papier'),
(2, 708, 'division'),
(2, 707, 'exercices'),
(2, 686, 'tangram'),
(2, 681, 'danger'),
(2, 664, 'géographie'),
(2, 658, 'états'),
(2, 657, 'europe'),
(2, 656, 'données'),
(2, 653, 'logiciel'),
(2, 647, 'cartes'),
(2, 640, 'cartes'),
(2, 610, 'alésia'),
(2, 607, 'histoire'),
(2, 604, 'carte'),
(2, 595, 'carte'),
(2, 581, 'cm1'),
(2, 580, 'intrigies'),
(2, 570, 'musique'),
(2, 908, 'cycle1'),
(2, 885, 'roms'),
(2, 875, 'freeware'),
(2, 872, 'cycle3'),
(2, 865, 'cycle1'),
(2, 862, 'mental'),
(2, 813, 'lecture'),
(2, 799, 'photos'),
(2, 646, 'plan'),
(2, 643, 'vidéo'),
(2, 642, 'recherche'),
(2, 620, 'période'),
(2, 617, 'quotidienne'),
(2, 615, 'glossaire'),
(2, 611, 'vie'),
(2, 609, 'forts'),
(2, 607, 'religion'),
(2, 599, 'animaux');

-- --------------------------------------------------------

--
-- Structure de la table `module_rightmatrix`
--

CREATE TABLE IF NOT EXISTS `module_rightmatrix` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_type_in` varchar(75) NOT NULL,
  `user_type_out` varchar(75) NOT NULL,
  `right` varchar(5) NOT NULL,
  `node_type` varchar(75) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_type_in` (`user_type_in`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=61 ;

--
-- Contenu de la table `module_rightmatrix`
--

INSERT INTO `module_rightmatrix` (`id`, `user_type_in`, `user_type_out`, `right`, `node_type`) VALUES
(1, 'USER_VIL', 'USER_VIL', 'VOIR', 'BU_VILLE'),
(2, 'USER_VIL', 'USER_VIL', 'COMM', 'BU_VILLE'),
(3, 'USER_VIL', 'USER_DIR', 'VOIR', 'BU_VILLE'),
(4, 'USER_VIL', 'USER_DIR', 'COMM', 'BU_VILLE'),
(5, 'USER_VIL', 'USER_ENS', 'VOIR', 'BU_VILLE'),
(6, 'USER_VIL', 'USER_RES', 'VOIR', 'BU_VILLE'),
(7, 'USER_VIL', 'USER_ELE', 'VOIR', 'BU_VILLE'),
(8, 'USER_VIL', 'USER_EXT', 'VOIR', 'ROOT'),
(9, 'USER_VIL', 'USER_EXT', 'COMM', 'ROOT'),
(10, 'USER_DIR', 'USER_VIL', 'VOIR', 'BU_VILLE'),
(11, 'USER_DIR', 'USER_VIL', 'COMM', 'BU_VILLE'),
(12, 'USER_DIR', 'USER_DIR', 'VOIR', 'BU_VILLE'),
(13, 'USER_DIR', 'USER_DIR', 'COMM', 'BU_VILLE'),
(14, 'USER_DIR', 'USER_ENS', 'VOIR', 'BU_VILLE'),
(15, 'USER_DIR', 'USER_ENS', 'COMM', 'BU_VILLE'),
(16, 'USER_DIR', 'USER_RES', 'VOIR', 'BU_ECOLE'),
(17, 'USER_DIR', 'USER_RES', 'COMM', 'BU_ECOLE'),
(18, 'USER_DIR', 'USER_ELE', 'VOIR', 'BU_ECOLE'),
(19, 'USER_DIR', 'USER_ELE', 'COMM', 'BU_ECOLE'),
(20, 'USER_DIR', 'USER_ATI', 'VOIR', 'ROOT'),
(21, 'USER_DIR', 'USER_ATI', 'COMM', 'ROOT'),
(22, 'USER_DIR', 'USER_EXT', 'VOIR', 'ROOT'),
(23, 'USER_DIR', 'USER_EXT', 'COMM', 'ROOT'),
(24, 'USER_ENS', 'USER_VIL', 'VOIR', 'BU_VILLE'),
(25, 'USER_ENS', 'USER_DIR', 'VOIR', 'BU_VILLE'),
(26, 'USER_ENS', 'USER_DIR', 'COMM', 'BU_VILLE'),
(27, 'USER_ENS', 'USER_ENS', 'VOIR', 'BU_VILLE'),
(28, 'USER_ENS', 'USER_ENS', 'COMM', 'BU_VILLE'),
(29, 'USER_ENS', 'USER_RES', 'VOIR', 'BU_ECOLE'),
(30, 'USER_ENS', 'USER_RES', 'COMM', 'BU_CLASSE'),
(31, 'USER_ENS', 'USER_ELE', 'VOIR', 'BU_ECOLE'),
(32, 'USER_ENS', 'USER_ELE', 'COMM', 'BU_CLASSE'),
(33, 'USER_ENS', 'USER_ATI', 'VOIR', 'ROOT'),
(34, 'USER_ENS', 'USER_ATI', 'COMM', 'ROOT'),
(35, 'USER_ENS', 'USER_EXT', 'VOIR', 'ROOT'),
(36, 'USER_ENS', 'USER_EXT', 'COMM', 'ROOT'),
(37, 'USER_RES', 'USER_DIR', 'VOIR', 'BU_ECOLE'),
(38, 'USER_RES', 'USER_DIR', 'COMM', 'BU_ECOLE'),
(39, 'USER_RES', 'USER_ENS', 'VOIR', 'BU_ECOLE'),
(40, 'USER_RES', 'USER_ENS', 'COMM', 'BU_CLASSE'),
(41, 'USER_RES', 'USER_RES', 'VOIR', 'BU_CLASSE'),
(42, 'USER_RES', 'USER_RES', 'COMM', 'BU_CLASSE'),
(43, 'USER_RES', 'USER_ELE', 'VOIR', 'BU_CLASSE'),
(44, 'USER_ELE', 'USER_DIR', 'VOIR', 'BU_ECOLE'),
(45, 'USER_ELE', 'USER_DIR', 'COMM', 'BU_ECOLE'),
(46, 'USER_ELE', 'USER_ENS', 'VOIR', 'BU_ECOLE'),
(47, 'USER_ELE', 'USER_ENS', 'COMM', 'BU_CLASSE'),
(48, 'USER_ELE', 'USER_RES', 'VOIR', 'BU_CLASSE'),
(49, 'USER_ELE', 'USER_ELE', 'VOIR', 'BU_ECOLE'),
(50, 'USER_ELE', 'USER_ELE', 'COMM', 'BU_CLASSE'),
(51, 'USER_ATI', 'USER_DIR', 'VOIR', 'ROOT'),
(52, 'USER_ATI', 'USER_DIR', 'COMM', 'ROOT'),
(53, 'USER_ATI', 'USER_ENS', 'VOIR', 'ROOT'),
(54, 'USER_ATI', 'USER_ENS', 'COMM', 'ROOT'),
(60, 'USER_ATI', 'USER_ATI', 'VOIR', 'ROOT'),
(55, 'USER_ATI', 'USER_ATI', 'COMM', 'ROOT'),
(56, 'USER_ATI', 'USER_EXT', 'VOIR', 'ROOT'),
(57, 'USER_ATI', 'USER_EXT', 'COMM', 'ROOT'),
(58, 'USER_EXT', 'USER_EXT', 'VOIR', 'ROOT'),
(59, 'USER_EXT', 'USER_EXT', 'COMM', 'ROOT');

-- --------------------------------------------------------

--
-- Structure de la table `module_rssmix`
--

CREATE TABLE IF NOT EXISTS `module_rssmix` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Contenu de la table `module_rssmix`
--

INSERT INTO `module_rssmix` (`id`, `url`, `title`, `image`) VALUES
(1, 'http://iconito.fr/?option=com_content&view=category&id=79&format=feed&type=rss', 'Ecole NumÃ©rique', NULL);

-- --------------------------------------------------------

--
-- Structure de la table `module_stats_logs`
--

CREATE TABLE IF NOT EXISTS `module_stats_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `profil` varchar(10) DEFAULT NULL,
  `date` datetime NOT NULL,
  `module_type` varchar(20) NOT NULL,
  `module_id` int(11) NOT NULL,
  `objet_a` int(11) DEFAULT NULL,
  `objet_b` int(11) DEFAULT NULL,
  `parent_type` varchar(20) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `action` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `module_type` (`module_type`),
  KEY `module_id` (`module_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_stats_logs`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_tags`
--

CREATE TABLE IF NOT EXISTS `module_tags` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_tags`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_tags_groups`
--

CREATE TABLE IF NOT EXISTS `module_tags_groups` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_group` int(11) unsigned NOT NULL,
  `id_tag` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_group` (`id_group`,`id_tag`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_tags_groups`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_teleprocedure`
--

CREATE TABLE IF NOT EXISTS `module_teleprocedure` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `titre` varchar(100) NOT NULL,
  `date_creation` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_teleprocedure`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_teleprocedure_infosupp`
--

CREATE TABLE IF NOT EXISTS `module_teleprocedure_infosupp` (
  `idinfo` int(11) NOT NULL AUTO_INCREMENT,
  `idinter` int(11) NOT NULL DEFAULT '0',
  `iduser` int(11) NOT NULL DEFAULT '0',
  `dateinfo` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `info_message` text,
  `info_commentaire` text,
  PRIMARY KEY (`idinfo`),
  KEY `idinter` (`idinter`),
  KEY `iduser` (`iduser`),
  KEY `dateinfo` (`dateinfo`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_teleprocedure_infosupp`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_teleprocedure_intervention`
--

CREATE TABLE IF NOT EXISTS `module_teleprocedure_intervention` (
  `idinter` int(11) NOT NULL AUTO_INCREMENT,
  `iduser` int(11) NOT NULL DEFAULT '0',
  `dateinter` date NOT NULL DEFAULT '0000-00-00',
  `idetabliss` int(11) NOT NULL DEFAULT '0',
  `objet` text NOT NULL,
  `idtype` int(11) NOT NULL DEFAULT '0',
  `idstatu` int(11) NOT NULL DEFAULT '0',
  `datederniere` datetime NOT NULL,
  `detail` text NOT NULL,
  `responsables` text NOT NULL,
  `lecteurs` text,
  `mail_from` varchar(255) DEFAULT NULL,
  `mail_to` text,
  `mail_cc` text,
  `mail_message` text,
  `infosup` text NOT NULL,
  PRIMARY KEY (`idinter`),
  KEY `datederniere` (`datederniere`),
  KEY `idetabliss` (`idetabliss`),
  KEY `idtype` (`idtype`),
  KEY `idstatu` (`idstatu`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_teleprocedure_intervention`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_teleprocedure_intervention_droit`
--

CREATE TABLE IF NOT EXISTS `module_teleprocedure_intervention_droit` (
  `idinter` int(11) NOT NULL,
  `user_type` varchar(15) NOT NULL,
  `user_id` int(11) NOT NULL,
  `droit` int(11) NOT NULL,
  PRIMARY KEY (`idinter`,`user_type`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `module_teleprocedure_intervention_droit`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_teleprocedure_statu`
--

CREATE TABLE IF NOT EXISTS `module_teleprocedure_statu` (
  `idstat` int(11) NOT NULL AUTO_INCREMENT,
  `nom` text NOT NULL,
  PRIMARY KEY (`idstat`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=4 ;

--
-- Contenu de la table `module_teleprocedure_statu`
--

INSERT INTO `module_teleprocedure_statu` (`idstat`, `nom`) VALUES
(1, 'Nouveau'),
(2, 'En cours'),
(3, 'Clos');

-- --------------------------------------------------------

--
-- Structure de la table `module_teleprocedure_tracking`
--

CREATE TABLE IF NOT EXISTS `module_teleprocedure_tracking` (
  `intervention` int(11) NOT NULL DEFAULT '0',
  `utilisateur` int(11) NOT NULL DEFAULT '0',
  `last_visite` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`intervention`,`utilisateur`),
  KEY `last_visite` (`last_visite`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `module_teleprocedure_tracking`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_teleprocedure_type`
--

CREATE TABLE IF NOT EXISTS `module_teleprocedure_type` (
  `idtype` int(11) NOT NULL AUTO_INCREMENT,
  `nom` text NOT NULL,
  `is_online` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `teleprocedure` int(10) unsigned NOT NULL,
  `format` varchar(10) NOT NULL DEFAULT 'fckeditor',
  `texte_defaut` text NOT NULL,
  `responsables` text NOT NULL,
  `lecteurs` text,
  `mail_from` varchar(255) DEFAULT NULL,
  `mail_to` text,
  `mail_cc` text,
  `mail_message` text,
  PRIMARY KEY (`idtype`),
  KEY `teleprocedure` (`teleprocedure`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_teleprocedure_type`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_teleprocedure_type_droit`
--

CREATE TABLE IF NOT EXISTS `module_teleprocedure_type_droit` (
  `idtype` int(11) NOT NULL,
  `user_type` varchar(15) NOT NULL,
  `user_id` int(11) NOT NULL,
  `droit` int(11) NOT NULL,
  PRIMARY KEY (`idtype`,`user_type`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `module_teleprocedure_type_droit`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_visioscopia`
--

CREATE TABLE IF NOT EXISTS `module_visioscopia` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date_creation` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_visioscopia`
--


-- --------------------------------------------------------

--
-- Structure de la table `module_visioscopia_config`
--

CREATE TABLE IF NOT EXISTS `module_visioscopia_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conf_id` varchar(30) NOT NULL,
  `conf_active` tinyint(4) NOT NULL DEFAULT '0',
  `conf_msg` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `module_visioscopia_config`
--


-- --------------------------------------------------------

--
-- Structure de la table `version`
--

CREATE TABLE IF NOT EXISTS `version` (
  `version` varchar(10) NOT NULL,
  `date` datetime NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Contenu de la table `version`
--

INSERT INTO `version` (`version`, `date`) VALUES
('2011', '2013-11-28 16:07:01');

-- --------------------------------------------------------

--
-- Structure de la vue `kernel_info_users`
--
DROP TABLE IF EXISTS `kernel_info_users`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`127.0.0.1` SQL SECURITY DEFINER VIEW `kernel_info_users` AS (select 'USER_ELE' AS `user_type`,`E`.`idEleve` AS `user_id`,`KLB2U`.`user_id` AS `user_id_copix`,`E`.`nom` AS `nom`,`E`.`prenom1` AS `prenom`,`E`.`id_sexe` AS `id_sexe` from (`kernel_bu_eleve` `E` join `kernel_link_bu2user` `KLB2U` on((`KLB2U`.`bu_id` = `E`.`idEleve`))) where (`KLB2U`.`bu_type` = 'USER_ELE')) union (select 'USER_ENS' AS `user_type`,`P`.`numero` AS `user_id`,`KLB2U`.`user_id` AS `user_id_copix`,`P`.`nom` AS `nom`,`P`.`prenom1` AS `prenom`,`P`.`id_sexe` AS `id_sexe` from ((`kernel_bu_personnel` `P` join `kernel_bu_personnel_entite` `P_ENTITE` on((`P`.`numero` = `P_ENTITE`.`id_per`))) join `kernel_link_bu2user` `KLB2U` on((`KLB2U`.`bu_id` = `P`.`numero`))) where ((`KLB2U`.`bu_type` = 'USER_ENS') and (`P_ENTITE`.`role` <> 4) and (`P_ENTITE`.`role` <> 5))) union (select 'USER_VIL' AS `user_type`,`P`.`numero` AS `user_id`,`KLB2U`.`user_id` AS `user_id_copix`,`P`.`nom` AS `nom`,`P`.`prenom1` AS `prenom`,`P`.`id_sexe` AS `id_sexe` from ((`kernel_bu_personnel` `P` join `kernel_bu_personnel_entite` `P_ENTITE` on((`P`.`numero` = `P_ENTITE`.`id_per`))) join `kernel_link_bu2user` `KLB2U` on((`KLB2U`.`bu_id` = `P`.`numero`))) where ((`KLB2U`.`bu_type` = 'USER_VIL') and ((`P_ENTITE`.`role` = 4) or (`P_ENTITE`.`role` = 5)))) union (select 'USER_RES' AS `user_type`,`R`.`numero` AS `user_id`,`KLB2U`.`user_id` AS `user_id_copix`,`R`.`nom` AS `nom`,`R`.`prenom1` AS `prenom`,`R`.`id_sexe` AS `id_sexe` from (`kernel_bu_responsable` `R` join `kernel_link_bu2user` `KLB2U` on((`KLB2U`.`bu_id` = `R`.`numero`))) where (`KLB2U`.`bu_type` = 'USER_RES')) union (select 'USER_EXT' AS `user_type`,`EXT`.`id` AS `user_id`,`KLB2U`.`user_id` AS `user_id_copix`,`EXT`.`nom` AS `nom`,`EXT`.`prenom` AS `prenom`,NULL AS `id_sexe` from (`kernel_ext_user` `EXT` join `kernel_link_bu2user` `KLB2U` on((`KLB2U`.`bu_id` = `EXT`.`id`))) where (`KLB2U`.`bu_type` = 'USER_EXT'));
