<?php
/**
* @package		copix
* @subpackage	utils
* @author		Croës Gérald, gallynet
* @copyright	CopixTeam
* @link			http://copix.org
* @license		http://www.gnu.org/licenses/lgpl.html GNU Lesser General Public Licence, see LICENCE file
*/

/**
* Classe capable d'indiquer le type MIME à partir d'une extension
* @package copix
* @subpackage utils
*/
class CopixMIMETypes
{
    /**
     * Retourne le bon type MIME en fonction de l'extension d'un fichier
     * @param	string	l'extension du fichier (ext ou .ext)
     * @return string le type MIME associé
     */
    public static function getFromExtension ($pExt)
    {
        $pExt = strtolower ($pExt);
        if (strpos ($pExt, '.') === 0){
            $pExt = substr ($pExt, 1);
        }
        switch ($pExt){
            case 'pdf':
                return 'application/pdf';
            case 'ai':
            case 'eps':
            case 'ps':
                return 'application/postscript';
            case 'rtf':
                return 'application/rtf';
            case 'latex':
                return 'application/x-latex';
            case 'dwg':
                return 'application/x-sh';
            case 'tcl':
                return 'application/x-tcl';
            case 'tex':
                return 'application/x-tex';
            case 'texinfo':
            case 'texi':
                return 'application/x-texinfo';
            case 'gtar':
                return 'application/x-gtar';
            case 'shar':
                return 'application/x-shar';
            case 'tar':
                return 'application/x-tar';
            case 'man':
                return 'application/zip';
            case 'au':
            case 'snd':
                return 'audio/basic';
            case 'aif':
            case 'aiff':
            case 'aifc':
                return 'audio/x-aiff';
            case 'wav':
                return 'audio/x-wav';
            case 'gif':
                return 'image/gif';
            case 'ief':
                return 'image/ief';
            case 'jpg':
            case 'jpeg':
            case 'jpe':
                return 'image/jpeg';
            case 'tiff':
            case 'tif':
                return 'image/tiff';
            case 'cmu':
                return 'image/x-cmu-raster';
            case 'pnm':
                return 'image/x-portable-anymap';
            case 'pbm':
                return 'image/x-portable-bitmap';
            case 'pgm':
                return 'image/x-portable-graymap';
            case 'ppm':
                return 'image/x-portable-pixmap';
            case 'rgb':
                return 'image/x-rgb';
            case 'xbm':
                return 'image/x-xbitmap';
            case 'xpm':
                return 'image/x-xpixmap';
            case 'zip':
                return 'multipart/x-zip';
            case 'gz':
            case 'gzip':
                return 'multipart/x-gzip';
            case 'htm':
            case 'html':
                return 'text/html';
            case 'txt':
                return 'text/plain';
            case 'rtx':
                return 'text/richtext';
            case 'tsv':
                return 'text/tab-separated-value';
            case 'mpeg':
            case 'mpg':
            case 'mpe':
                return 'video/mpeg';
            case 'qt':
            case 'mov':
                return 'video/quicktime';
            case 'avi':
                return 'video/msvideo';
            case 'movie':
                return 'video/x-sgi-movie';
            case 'mdb':
               return 'application/msaccess';
            case 'doc':
            case 'docx':
               return 'application/msword';
            case 'dot':
               return 'application/msword';
            case 'bin':
               return 'application/octet-stream';
            case 'oda':
               return 'application/oda';
            case 'ogg':
               return 'application/ogg';
            case 'prf':
               return 'application/pics-rules';
            case 'key':
               return 'application/pgp-keys';
            case 'pdf':
               return 'application/pdf';
            case 'pgp':
               return 'application/pgp-signature';
            case 'ps':
            case 'ai':
            case 'eps':
               return 'application/postscript';
            case 'rar':
               return 'application/rar';
            case 'rdf':
               return 'application/rdf+xml';
            case 'rss':
               return 'application/rss+xml';
            case 'rtf':
               return 'application/rtf';
            case 'smi':
            case 'smil':
               return 'application/smil';
            case 'wp5':
               return 'application/wordperfect5.1';
            case 'xht':
            case 'xhtml':
               return 'application/xhtml+xml';
            case 'xml':
            case 'xsl':
                return 'application/xml';
            case 'zip':
               return 'application/zip';
            case 'cdy':
               return 'application/vnd.cinderella';
            case 'mif':
               return 'application/vnd.mif';
            case 'xul':
               return 'application/vnd.mozilla.xul+xml';
            case 'xls':
            case 'xlsx':
            case 'xlb':
            case 'xlt':
               return 'application/vnd.ms-excel';
            case 'cat':
               return 'application/vnd.ms-pki.seccat';
            case 'stl':
               return 'application/vnd.ms-pki.stl';
            case 'ppt':
            case 'pptx':
            case 'pps':
               return 'application/vnd.ms-powerpoint';
            case 'mmf':
               return 'application/vnd.smaf';
            case 'sdc':
               return 'application/vnd.stardivision.calc';
            case 'sda':
               return 'application/vnd.stardivision.draw';
            case 'sdd':
            case 'sdp':
               return 'application/vnd.stardivision.impress';
            case 'smf':
               return 'application/vnd.stardivision.math';
            case 'sdw':
            case 'vor':
               return 'application/vnd.stardivision.writer';
            case 'sgl':
               return 'application/vnd.stardivision.writer-global';
            case 'sxc':
               return 'application/vnd.sun.xml.calc';
            case 'stc':
               return 'application/vnd.sun.xml.calc.template';
            case 'sxd':
               return 'application/vnd.sun.xml.draw';
            case 'std':
               return 'application/vnd.sun.xml.draw.template';
            case 'sxi':
               return 'application/vnd.sun.xml.impress';
            case 'sti':
               return 'application/vnd.sun.xml.impress.template';
            case 'sxm':
               return 'application/vnd.sun.xml.math';
            case 'sxw':
               return 'application/vnd.sun.xml.writer';
            case 'sxg':
               return 'application/vnd.sun.xml.writer.global';
            case 'stw':
               return 'application/vnd.sun.xml.writer.template';
            case 'sis':
               return 'application/vnd.symbian.install';
            case 'vsd':
               return 'application/vnd.visio';
            case 'wbxml':
               return 'application/vnd.wap.wbxml';
            case 'wmlc':
               return 'application/vnd.wap.wmlc';
            case 'wmlsc':
               return 'application/vnd.wap.wmlscriptc';
            case 'wk':
               return 'application/x-123';
            case 'dmg':
               return 'application/x-apple-diskimage';
            case 'bcpio':
               return 'application/x-bcpio';
            case 'torrent':
               return 'application/x-bittorrent';
            case 'cdf':
               return 'application/x-cdf';
            case 'vcd':
               return 'application/x-cdlink';
            case 'pgn':
               return 'application/x-chess-pgn';
            case 'chm':
               return 'application/x-chm';
            case 'cpio':
               return 'application/x-cpio';
            case 'csh':
               return 'application/x-csh';
            case 'deb':
               return 'application/x-debian-package';
            case 'dcr':
            case 'dir':
            case 'dxr':
                return 'application/x-director';
            case 'wad':
               return 'application/x-doom';
            case 'dms':
               return 'application/x-dms';
            case 'dvi':
               return 'application/x-dvi';
            case 'flac':
               return 'application/x-flac';
            case 'pfa':
            case 'pfb':
            case 'gsf':
            case 'pcf':
            case 'pcf.Z':
               return 'application/x-font';
            case 'spl':
               return 'application/x-futuresplash';
            case 'gnumeric':
               return 'application/x-gnumeric';
            case 'sgf':
               return 'application/x-go-sgf';
            case 'gcf':
               return 'application/x-graphing-calculator';
            case 'gtar':
            case 'tgz':
            case 'taz':
               return 'application/x-gtar';
            case 'hdf':
               return 'application/x-hdf';
            case 'phtml':
            case 'pht':
            case 'php':
               return 'application/x-httpd-php';
            case 'phps':
               return 'application/x-httpd-php-source';
            case 'php3':
               return 'application/x-httpd-php3';
            case 'php3p':
               return 'application/x-httpd-php3-preprocessed';
            case 'php4':
               return 'application/x-httpd-php4';
            case 'ica':
               return 'application/x-ica';
            case 'ins':
            case 'isp':
               return 'application/x-internet-signup';
            case 'iii':
               return 'application/x-iphone';
            case 'jar':
               return 'application/x-java-archive';
            case 'jnlp':
               return 'application/x-java-jnlp-file';
            case 'ser':
               return 'application/x-java-serialized-object';
            case 'class':
               return 'application/x-java-vm';
            case 'js':
               return 'application/x-javascript';
            case 'chrt':
               return 'application/x-kchart';
            case 'kil':
               return 'application/x-killustrator';
            case 'kpr':
            case 'kpt':
               return 'application/x-kpresenter';
            case 'skp':
            case 'skd':
            case 'skt':
            case 'skm':
               return 'application/x-koan';
            case 'ksp':
               return 'application/x-kspread';
            case 'kwd':
            case 'kwt':
               return 'application/x-kword';
            case 'latex':
               return 'application/x-latex';
            case 'lha':
               return 'application/x-lha';
            case 'lzh':
               return 'application/x-lzh';
            case 'lzx':
               return 'application/x-lzx';
            case 'frm':
            case 'maker':
            case 'frame':
            case 'fm':
            case 'fb':
            case 'book':
            case 'fbdoc':
               return 'application/x-maker';
            case 'mif':
               return 'application/x-mif';
            case 'wmz':
               return 'application/x-ms-wmz';
            case 'wmd':
               return 'application/x-ms-wmd';
            case 'com':
            case 'exe':
            case 'bat':
            case 'dll':
               return 'application/x-msdos-program';
            case 'msi':
               return 'application/x-msi';
            case 'nc':
               return 'application/x-netcdf';
            case 'pac':
               return 'application/x-ns-proxy-autoconfig';
            case 'nwc':
               return 'application/x-nwc';
            case 'o':
               return 'application/x-object';
            case 'oza':
               return 'application/x-oz-application';
            case 'p7r':
               return 'application/x-pkcs7-certreqresp';
            case 'crl':
               return 'application/x-pkcs7-crl';
            case 'pyc':
            case 'pyo':
               return 'application/x-python-code';
            case 'qtl':
               return 'application/x-quicktimeplayer';
            case 'rpm':
               return 'application/x-redhat-package-manager';
            case 'shar':
               return 'application/x-shar';
            case 'swf':
            case 'swfl':
               return 'application/x-shockwave-flash';
            case 'sh':
               return 'application/x-sh';
            case 'sit':
               return 'application/x-stuffit';
            case 'sv4cpio':
               return 'application/x-sv4cpio';
            case 'sv4crc':
               return 'application/x-sv4crc';
            case 'tar':
               return 'application/x-tar';
            case 'tcl':
               return 'application/x-tcl';
            case 'gf':
               return 'application/x-tex-gf';
            case 'pk':
               return 'application/x-tex-pk';
            case 'texinfo':
            case 'texi':
               return 'application/x-texinfo';
            case '~':
            case '%':
            case 'bak':
            case 'old':
            case 'sik':
               return 'application/x-trash';
            case 't':
            case 'tr':
            case 'roff':
               return 'application/x-troff';
            case 'man':
               return 'application/x-troff-man';
            case 'me':
               return 'application/x-troff-me';
            case 'ms':
               return 'application/x-troff-ms';
            case 'ustar':
               return 'application/x-ustar';
            case 'src':
               return 'application/x-wais-source';
            case 'wz':
               return 'application/x-wingz';
            case 'crt':
               return 'application/x-x509-ca-cert';
            case 'xcf':
               return 'application/x-xcf';
            case 'fig':
               return 'application/x-xfig';
            case 'au':
            case 'snd':
               return 'audio/basic';
            case 'mid':
            case 'midi':
            case 'kar':
               return 'audio/midi';
            case 'mpga':
            case 'mpega':
            case 'mp2':
            case 'mp3':
            case 'm4a':
               return 'audio/mpeg';
            case 'm3u':
               return 'audio/mpegurl';
            case 'sid':
               return 'audio/prs.sid';
            case 'aif':
            case 'aiff':
            case 'aifc':
               return 'audio/x-aiff';
            case 'gsm':
               return 'audio/x-gsm';
            case 'm3u':
               return 'audio/x-mpegurl';
            case 'wma':
               return 'audio/x-ms-wma';
            case 'wax':
               return 'audio/x-ms-wax';
            case 'ra':
            case 'ram':
            case 'rm':
               return 'audio/x-pn-realaudio';
            case 'pls':
               return 'audio/x-scpls';
            case 'sd2':
               return 'audio/x-sd2';
            case 'wav':
               return 'audio/x-wav';
            case 'pdb':
               return 'chemical/x-pdb';
            case 'xyz':
               return 'chemical/x-xyz';
            case 'gif':
               return 'image/gif';
            case 'ief':
               return 'image/ief';
            case 'jpeg':
            case 'jpg':
            case 'jpe':
               return 'image/jpeg';
            case 'pcx':
               return 'image/pcx';
            case 'png':
               return 'image/png';
            case 'svg':
            case 'svgz':
               return 'image/svg+xml';
            case 'tiff':
            case 'tif':
               return 'image/tiff';
            case 'djvu':
            case 'djv':
               return 'image/vnd.djvu';
            case 'wbmp':
               return 'image/vnd.wap.wbmp';
            case 'ras':
               return 'image/x-cmu-raster';
            case 'cdr':
               return 'image/x-coreldraw';
            case 'pat':
               return 'image/x-coreldrawpattern';
            case 'cdt':
               return 'image/x-coreldrawtemplate';
            case 'cpt':
               return 'image/x-corelphotopaint';
            case 'ico':
               return 'image/x-icon';
            case 'art':
               return 'image/x-jg';
            case 'jng':
               return 'image/x-jng';
            case 'bmp':
               return 'image/x-ms-bmp';
            case 'psd':
               return 'image/x-photoshop';
            case 'xwd':
               return 'image/x-xwindowdump';
            case 'igs':
            case 'iges':
               return 'model/iges';
            case 'msh':
            case 'mesh':
            case 'silo':
               return 'model/mesh';
            case 'wrl':
            case 'vrml':
               return 'model/vrml';
            case 'ics':
               return 'text/calendar';
            case 'icz':
               return 'text/calendar';
            case 'csv':
               return 'text/comma-separated-values';
            case 'css':
               return 'text/css';
            case '323':
               return 'text/h323';
            case 'htm':
            case 'html':
            case 'shtml':
               return 'text/html';
            case 'uls':
               return 'text/iuls';
            case 'mml':
               return 'text/mathml';
            case 'asc':
            case 'txt':
            case 'text':
            case 'diff':
            case 'pot':
               return 'text/plain';
            case 'rtx':
               return 'text/richtext';
            case 'rtf':
               return 'text/rtf';
            case 'sct':
            case 'wsc':
               return 'text/scriptlet';
            case 'tm':
            case 'ts':
               return 'text/texmacs';
            case 'tsv':
               return 'text/tab-separated-values';
            case 'jad':
               return 'text/vnd.sun.j2me.app-descriptor';
            case 'wml':
               return 'text/vnd.wap.wml';
            case 'wmls':
               return 'text/vnd.wap.wmlscript';
            case 'h++':
            case 'hpp':
            case 'hxx':
            case 'hh':
               return 'text/x-c++hdr';
            case 'c++':
            case 'cpp':
            case 'cxx':
            case 'cc':
               return 'text/x-c++src';
            case 'h':
               return 'text/x-chdr';
            case 'csh':
               return 'text/x-csh';
            case 'c':
               return 'text/x-csrc';
            case 'java':
               return 'text/x-java';
            case 'moc':
               return 'text/x-moc';
            case 'p':
            case 'pas':
               return 'text/x-pascal';
            case 'gcd':
               return 'text/x-pcs-gcd';
            case 'pl':
            case 'pm':
               return 'text/x-perl';
            case 'py':
               return 'text/x-python';
            case 'etx':
               return 'text/x-setext';
            case 'sh':
               return 'text/x-sh';
            case 'tcl':
            case 'tk':
               return 'text/x-tcl';
            case 'tex':
            case 'ltx':
            case 'sty':
            case 'cls':
               return 'text/x-tex';
            case 'vcs':
               return 'text/x-vcalendar';
            case 'vcf':
               return 'text/x-vcard';
            case 'dl':
               return 'video/dl';
            case 'fli':
               return 'video/fli';
            case 'gl':
               return 'video/gl';
            case 'mpeg':
            case 'mpg':
            case 'mpe':
               return 'video/mpeg';
            case 'mp4':
               return 'video/mp4';
            case 'qt':
            case 'mov':
               return 'video/quicktime';
            case 'mxu':
               return 'video/vnd.mpegurl';
            case 'dif':
            case 'dv':
               return 'video/x-dv';
            case 'lsf':
            case 'lsx':
               return 'video/x-la-asf';
            case 'mng':
               return 'video/x-mng';
            case 'asf':
            case 'asx':
               return 'video/x-ms-asf';
            case 'wm':
               return 'video/x-ms-wm';
            case 'wmv':
               return 'video/x-ms-wmv';
            case 'wmx':
               return 'video/x-ms-wmx';
            case 'wvx':
               return 'video/x-ms-wvx';
            case 'avi':
               return 'video/x-msvideo';
            case 'movie':
               return 'video/x-sgi-movie';
            case 'ice':
               return 'x-conference/x-cooltalk';
            case 'vrm':
            case 'vrml':
            case 'wrl':
               return 'x-world/x-vrml';
            case 'flipchart':
            case 'flp':
               return 'application/inspire';
            case 'gallery':
            case 'galleryite':
            case 'gallerycollection':
            case 'nbk':
            case 'notebook':
            case 'xbk':
               return 'application/x-smarttech-notebook';
            default:
               return 'application/octet-stream';
        }

    }

    /**
     * Retourne le bon type MIME en fonction d'un nom de fichier
     * @param	string	$pFileName	le nom du fichier à tester
     * @return string
     */
    public static function getFromFileName ($pFileName)
    {
        return self::getFromExtension (CopixFile::extractFileExt ($pFileName));
    }
}
