<?php
/* vim: set expandtab tabstop=4 shiftwidth=4: */
//
// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2003 The PHP Group                                |
// +----------------------------------------------------------------------+
// | This source file is subject to version 3.0 of the PHP license,       |
// | that is bundled with this package in the file LICENSE, and is        |
// | available at through the world-wide-web at                           |
// | http://www.php.net/license/3_0.txt.                                  |
// | If you did not receive a copy of the PHP license and are unable to   |
// | obtain it through the world-wide-web, please send a note to          |
// | license@php.net so we can mail you a copy immediately.               |
// +----------------------------------------------------------------------+
// | Authors: Piotr Klaban                                                |
// +----------------------------------------------------------------------+
//
// Numbers_Words class extension to spell numbers in Polish.
//

require_once 'Numbers/Words.php';
require_once 'PHPUnit/TestCase.php';

class Numbers_Words_Polish_TestCase extends PHPUnit_TestCase
{
    public $db;
    public $handle;

    public function Numbers_Words_Polish_TestCase($name)
    {
        $this->handle = new Numbers_Words();
        $this->PHPUnit_TestCase($name);
    }

    public function setUp()
    {
    }

    public function tearDown()
    {
    }

    /**
    * Testing numbers between 0 and 9
    */
    public function testDigits()
    {
        $digits = array('zero',
                        'jeden',
                        'dwa',
                        'trzy',
                        'cztery',
                        'pi',
                        'sze',
                        'siedem',
                        'osiem',
                        'dziewi'
                       );
        for ($i = 0; $i < 10; $i++) {
            $number = $this->handle->toWords($i, 'pl');
            $this->assertEquals($digits[$i], $number);
        }
    }

    /**
    * Testing numbers between 10 and 99
    */
    public function testTens()
    {
        $tens = array(11 => 'jedenacie',
                      12 => 'dwanacie',
                      16 => 'szesnacie',
                      19 => 'dziewitnacie',
                      20 => 'dwadziecia',
                      21 => 'dwadziecia jeden',
                      26 => 'dwadziecia sze',
                      30 => 'trzydzieci',
                      31 => 'trzydzieci jeden',
                      40 => 'czterdzieci',
                      43 => 'czterdzieci trzy',
                      50 => 'pidziesit',
                      55 => 'pidziesit pi',
                      60 => 'szedziesit',
                      67 => 'szedziesit siedem',
                      70 => 'siedemdziesit',
                      79 => 'siedemdziesit dziewi'
                     );
        foreach ($tens as $number => $word) {
            $this->assertEquals($word, $this->handle->toWords($number, 'pl'));
        }
    }

    /**
    * Testing numbers between 100 and 999
    */
    public function testHundreds()
    {
        $hundreds = array(100 => 'sto',
                          101 => 'sto jeden',
                          199 => 'sto dziewidziesit dziewi',
                          203 => 'dwiecie trzy',
                          287 => 'dwiecie osiemdziesit siedem',
                          300 => 'trzysta',
                          356 => 'trzysta pidziesit sze',
                          410 => 'czterysta dziesi',
                          434 => 'czterysta trzydzieci cztery',
                          578 => 'piset siedemdziesit osiem',
                          689 => 'szeset osiemdziesit dziewi',
                          729 => 'siedemset dwadziecia dziewi',
                          894 => 'osiemset dziewidziesit cztery',
                          999 => 'dziewiset dziewidziesit dziewi'
                         );
        foreach ($hundreds as $number => $word) {
            $this->assertEquals($word, $this->handle->toWords($number, 'pl'));
        }
    }

    /**
    * Testing numbers between 1000 and 9999
    */
    public function testThousands()
    {
        $thousands = array(1000 => 'jeden tysic',
                           1001 => 'jeden tysic jeden',
                           1097 => 'jeden tysic dziewidziesit siedem',
                           1104 => 'jeden tysic sto cztery',
                           1243 => 'jeden tysic dwiecie czterdzieci trzy',
                           2385 => 'dwa tysice trzysta osiemdziesit pi',
                           3766 => 'trzy tysice siedemset szedziesit sze',
                           4196 => 'cztery tysice sto dziewidziesit sze',
                           5846 => 'pi tysicy osiemset czterdzieci sze',
                           6459 => 'sze tysicy czterysta pidziesit dziewi',
                           7232 => 'siedem tysicy dwiecie trzydzieci dwa',
                           8569 => 'osiem tysicy piset szedziesit dziewi',
                           9539 => 'dziewi tysicy piset trzydzieci dziewi'
                          );
        foreach ($thousands as $number => $word) {
            $this->assertEquals($word, $this->handle->toWords($number, 'pl'));
        }
    }
}

