<?php

namespace App\Command;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\Console\Input\ArrayInput;
use Ramsey\Uuid\Uuid;

use Doctrine\ORM\Mapping\ClassMetadata;
use Doctrine\ORM\Id\AssignedGenerator;

use App\Entity\User;
use App\Entity\Config;


class AppInitCommand extends Command
{

    private $container;
    private $em;
    private $output;
    private $filesystem;
    private $rootlog;
    private $appname;
    private $appmailnoreply;

    public function __construct(ContainerInterface $container,EntityManagerInterface $em)
    {
        parent::__construct();
        $this->container = $container;
        $this->em = $em;
    }


    protected function configure()
    {
        $this
            ->setName('app:AppInit')
            ->setDescription('Init Data for App')
            ->setHelp('This command Init Data App')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->output           = $output;
        $this->filesystem       = new Filesystem();
        $this->rootlog          = $this->container->get('kernel')->getLogDir()."/";
        $this->appname          = $this->container->getParameter('appName');
        $this->appmailnoreply   = $this->container->getParameter('appMailnoreply');

        $output->writeln('APP = Default Data');

        // Création du compte admin si non existant
        $this->insertUser("admin","admin");


        // colorbgbody = Couleur des fonds de page
        $this->insertConfig(
            1,                                                  // order
            "site",                                             // category
            "appname",                                          // id
            "Titre de votre site",                              // title
            "",                                                 // value
            "",                                                 // defalut
            "string",                                           // type,
            true,                                               // visible
            true,                                               // changeable
            false,                                              // required
            "",                                                 // grouped
            "Titre de votre site"
        );

        $this->insertConfig(
            2,                                                  // order
            "site",                                             // category
            "appsubname",                                       // id
            "Sous-titre de votre site",                         // title
            "",                                                 // value
            "",                                                 // defalut
            "string",                                           // type,
            true,                                               // visible
            true,                                               // changeable
            false,                                              // required
            "",                                                 // grouped
            "Sous-titre de votre site"
        );

        $this->insertConfig(
            3,                                                  // order
            "site",                                             // category
            "appdescription",                                   // id
            "Description de votre site",                        // title
            "",                                                 // value
            "",                                                 // defalut
            "editor",                                           // type,
            true,                                               // visible
            true,                                               // changeable
            false,                                              // required
            "",                                                 // grouped
            "Description de votre site"
        );

        $this->insertConfig(
            100,                                                // order
            "site",                                             // category
            "apptheme",                                         // id
            "Thème de votre site",                              // title
            "",                                                 // value
            "",                                                 // defalut
            "string",                                           // type,
            false,                                              // visible
            true,                                               // changeable
            false,                                              // required
            "",                                                 // grouped
            "Thème de votre site"
        );


        // colorbgbody = Couleur des fonds de page
        $this->insertConfig(
            1,                                                  // order
            "colorbgbody",                                      // category
            "colorbgbodydark",                                  // id
            "Couleur de fond fonçée",                           // title
            "",                                                 // value
            "#27848e",                                          // defalut
            "color",                                            // type,
            true,                                               // visible
            true,                                               // changeable
            false,                                              // required
            "",                                                 // grouped
            "La couleur de fond quand le site a besoin d'avoir une couleur de fond foncée"
        );

        $this->insertConfig(
            2,                                                  // order
            "colorbgbody",                                      // category
            "colorbgbodylight",                                 // id
            "Couleur de fond claire",                           // title
            "",                                                 // value
            "#ffffff",                                          // defalut
            "color",                                            // type,
            true,                                               // visible
            true,                                               // changeable
            false,                                              // required
            "",                                                 // grouped
            "La couleur de fond quand le site a besoin d'avoir une couleur de fond claire"
        );

        // colorfttitle = Couleur des fontes titre
        $this->insertConfig(
            1,                                                  // order
            "colorfttitle",                                     // category
            "colorfttitledark",                                 // id
            "Couleur des titres sur fond fonçé",                // title
            "",                                                 // value
            "#ffffff",                                          // defalut
            "color",                                            // type,
            true,                                               // visible
            true,                                               // changeable
            false,                                              // required
            "",                                                 // grouped
            "La couleur des titres sur fond fonçé"
        );

        $this->insertConfig(
            2,                                                  // order
            "colorfttitle",                                     // category
            "colorfttitlelight",                                // id
            "Couleur des titres sur fond claire",               // title
            "",                                                 // value
            "#27848e",                                          // defalut
            "color",                                            // type,
            true,                                               // visible
            true,                                               // changeable
            false,                                              // required
            "",                                                 // grouped
            "La couleur des titres sur fond claire"
        );
        
        // colorftbody = Couleur des fontes titre
        $this->insertConfig(
            1,                                                  // order
            "colorftbody",                                      // category
            "colorftbodydark",                                  // id
            "Couleur de la police sur fond fonçé",              // title
            "",                                                 // value
            "#ffffff",                                          // defalut
            "color",                                            // type,
            true,                                               // visible
            true,                                               // changeable
            false,                                              // required
            "",                                                 // grouped
            "La couleur de la police sur fond fonçé"
        );

        $this->insertConfig(
            2,                                                  // order
            "colorftbody",                                      // category
            "colorftbodylight",                                 // id
            "Couleur de la police sur fond claire",             // title
            "",                                                 // value
            "#343a40",                                          // defalut
            "color",                                            // type,
            true,                                               // visible
            true,                                               // changeable
            false,                                              // required
            "",                                                 // grouped
            "La couleur de la police sur fond claire"
        );

        // font = nom des polices
        $this->insertConfig(
            1,                                                  // order
            "font",                                             // category
            "fonttitle",                                        // id
            "Police pour les titres",                           // title
            "",                                                 // value
            "FredokaOne-Regular",                               // defalut
            "font",                                             // type,
            true,                                               // visible
            true,                                               // changeable
            false,                                              // required
            "",                                                 // grouped
            "La couleur de la police de votre site"
        );        

        $this->insertConfig(
            2,                                                  // order
            "font",                                             // category
            "fontbody",                                         // id
            "Police principale",                                // title
            "",                                                 // value
            "Roboto-Regular",                                   // defalut
            "font",                                             // type,
            true,                                               // visible
            true,                                               // changeable
            false,                                              // required
            "",                                                 // grouped
            "Nom de la police principale"
        );

        $this->insertConfig(
            3,                                                  // order
            "font",                                             // category
            "fontsizeh1",                                       // id
            "Taille des titres h1",                             // title
            "",                                                 // value
            "40",                                               // defalut
            "integer",                                          // type,
            true,                                               // visible
            true,                                               // changeable
            false,                                              // required
            "",                                                 // grouped
            "Taille des titres h1 en px"
        );

        $this->insertConfig(
            4,                                                  // order
            "font",                                             // category
            "fontsizeh2",                                       // id
            "Taille des titres h2",                             // title
            "",                                                 // value
            "32",                                               // defalut
            "integer",                                          // type,
            true,                                               // visible
            true,                                               // changeable
            false,                                              // required
            "",                                                 // grouped
            "Taille des titres h2 en px"
        );

        $this->insertConfig(
            5,                                                  // order
            "font",                                             // category
            "fontsizeh3",                                       // id
            "Taille des titres h3",                             // title
            "",                                                 // value
            "28",                                               // defalut
            "integer",                                          // type,
            true,                                               // visible
            true,                                               // changeable
            false,                                              // required
            "",                                                 // grouped
            "Taille des titres h3 en px"
        );

        $this->insertConfig(
            6,                                                  // order
            "font",                                             // category
            "fontsizeh4",                                       // id
            "Taille des titres h4",                             // title
            "",                                                 // value
            "24",                                               // defalut
            "integer",                                          // type,
            true,                                               // visible
            true,                                               // changeable
            false,                                              // required
            "",                                                 // grouped
            "Taille des titres h4 en px"
        );

        // logo = 
        $this->insertConfig(
            1,                                                  // order
            "logo",                                             // category
            "logodark",                                         // id
            "Logo sur fond fonçé",                              // title
            "",                                                 // value
            "",                                                 // defalut
            "logo",                                             // type,
            true,                                               // visible
            true,                                               // changeable
            false,                                              // required
            "",                                                 // grouped
            "Logo sur fond fonçé"
        );  

        $this->insertConfig(
            2,                                                  // order
            "logo",                                             // category
            "logolight",                                        // id
            "Logo sur fond clair",                              // title
            "",                                                 // value
            "",                                                 // defalut
            "logo",                                             // type,
            true,                                               // visible
            true,                                               // changeable
            false,                                              // required
            "",                                                 // grouped
            "Logo sur fond clair"
        );  

        $output->writeln('');

        return 1;
    }

    protected function insertUser() {
        $metadata =  $this->em->getClassMetaData('App:User');
        $metadata->setIdGeneratorType(ClassMetadata::GENERATOR_TYPE_NONE);
        $metadata->setIdGenerator(new AssignedGenerator());
              


        // Job Récupératoin la table de référence des articles
        // Toute les 1mn
        $entity = $this->em->getRepository('App:User')->findOneBy(["username"=>"admin"]);
        if(!$entity) {
            $this->writelnred('Création du compte admin par défaut avec password admin - Veuillez modifier votre password admin après connexion');
            $entity = new User;
            $key = Uuid::uuid4();

            $entity->setId(0);
            $entity->setUsername("admin");
            $entity->setPassword($key);
            $entity->setRoles(["ROLE_ADMIN"]);
            $entity->setAvatar("admin.jpg");
            $entity->setApiKey($key);
            $this->em->persist($entity);
        }          

        // On flush
        $this->em->flush();

    }

    protected function insertConfig($order,$category,$id,$title,$value,$default,$type,$visible,$changeable,$required,$grouped,$help) {
        $entity=$this->em->getRepository("App:Config")->find($id);
        if(!$entity) {
            $entity= new Config();
            $entity->setId($id);
            $entity->setValue($value);
        }

        $entity->setDefault($default);
        $entity->setCategory($category);
        $entity->setOrder($order);
        $entity->setTitle($title);
        $entity->setType($type);
        $entity->setVisible($visible);
        $entity->setChangeable($changeable);
        $entity->setRequired($required);
        $entity->setGrouped($grouped);
        $entity->setHelp($help);

        $this->em->persist($entity);
        $this->em->flush();
    }

    private function writelnred($string) { 
        $this->output->writeln('<fg=red>'.$string.'</>');
        $this->filesystem->appendToFile($this->rootlog.'cron.log', $string."\n");
    }
    private function writeln($string) { 
        $this->output->writeln($string);
        $this->filesystem->appendToFile($this->rootlog.'cron.log', $string."\n");
    }     
}
