<?php

namespace App\Controller;

use FOS\RestBundle\Controller\AbstractFOSRestController;
use Symfony\Component\HttpFoundation\Request;
use FOS\RestBundle\Controller\Annotations as FOSRest;
use Swagger\Annotations as SWG;

use App\Service\JanusService;


class RestController extends AbstractFOSRestController
{
    private $janus;
    public function __construct(JanusService $janus) { $this->janus = $janus; }

    /**
     * Return the attributes of an user UID
     *
     *
     * @FOSRest\Post("/rest/getUserattributes")   
     * @SWG\Response(
     *     response=200,
     *     description="Returns the attributes of an user"
     *     )
     * )
     * @SWG\Parameter(
     *     name="key",
     *     in="formData",
     *     required=true,
     *     description="APIKey of the customer",
     *     type="string"
     * )
     * @SWG\Parameter(
     *     name="uid",
     *     in="formData",
     *     required=true,
     *     description="UID of the user",
     *     type="string"
     * )
     * @SWG\Parameter(
     *     name="refresh",
     *     in="formData",
     *     required=false,
     *     description="Force to refresh cache",
     *     type="boolean"
     * )
     * @SWG\Parameter(
     *     name="sso",
     *     in="formData",
     *     required=false,
     *     description="json of SSO attributs of the user sous la forme {""rne"":""0000000A"",""key01"":""valkey01"",""user_groups"":[""valarray01"",""valarray02""]}",
     *     type="string"
     * )
     * @SWG\Parameter(
     *     name="test",
     *     in="formData",
     *     required=false,
     *     description="Force to use the test configuration",
     *     type="boolean"
     * )     
     */

    public function getUserattributes(Request $request) {               
        // Initalisation Manager
        $em = $this->getDoctrine()->getManager();

        // Récupération des parametres
        $key=$request->get("key");
        $uid=$request->get("uid");
        $refresh=$request->get("refresh");
        $sso=json_decode($request->get("sso"),true);
        $test=$request->get("test");

        // Rechercher le customer en fonction de sa clé
        $customer = $this->janus->getCustomer($key,$test);
        if(!$customer) {
            $view = $this->view("API Key inconnue", 403);
            return $this->handleView($view);            
        }

        // Calcul des attributs de l'uid
        $userattributes = $this->janus->getUserattributes($customer,$uid,$refresh,$sso,$test);

        $view = $this->view($userattributes, 200);
        return $this->handleView($view);
    }



    /**
     * Return the ressources of an user UID
     *
     *
     * @FOSRest\Post("/rest/getUserressources")   
     * @SWG\Response(
     *     response=200,
     *     description="Returns the ressources of an user"
     *     )
     * )
     * @SWG\Parameter(
     *     name="key",
     *     in="formData",
     *     required=true,
     *     description="APIKey of the customer",
     *     type="string"
     * )
     * @SWG\Parameter(
     *     name="uid",
     *     in="formData",
     *     required=true,
     *     description="UID of the user",
     *     type="string"
     * )
     * @SWG\Parameter(
     *     name="refresh",
     *     in="formData",
     *     required=false,
     *     description="Force to refresh cache",
     *     type="boolean"
     * )
     * @SWG\Parameter(
     *     name="type",
     *     in="formData",
     *     required=false,
     *     description="Type of ressources separed by comma, null for all ressouces. type : items,bookmarks",
     *     type="string"
     * )
     * @SWG\Parameter(
     *     name="sso",
     *     in="formData",
     *     required=false,
     *     description="json of SSO attributs of the user sous la forme {""rne"":""0000000A"",""key01"":""valkey01"",""user_groups"":[""valarray01"",""valarray02""]}",
     *     type="string"
     * )
     * @SWG\Parameter(
     *     name="test",
     *     in="formData",
     *     required=false,
     *     description="Force to use the test configuration",
     *     type="boolean"
     * ) 
     */

    public function getUserressources(Request $request) {
        // Récupération des parametres
        $key=$request->get("key");
        $uid=$request->get("uid");
        $refresh=$request->get("refresh");
        $type=$request->get("type");
        $sso=json_decode($request->get("sso"),true);
        $test=$request->get("test");
        if(is_null($type)) $type="all";

        // Rechercher le customer en fonction de sa clé
        $customer = $this->janus->getCustomer($key,$test);
        if(!$customer) {
            $view = $this->view("API Key inconnue", 403);
            return $this->handleView($view);            
        }
        
        // Calcul des ressources de l'uid
        $userressources = $this->janus->getUserressources($customer,$uid,$refresh,$type,$sso,$test);

        $view = $this->view($userressources, 200);
        return $this->handleView($view);        
    }
   

    /**
     * Return the list of the rendered attributes of a customer
     *
     *
     * @FOSRest\Post("/rest/getJanuscustomers")   
     * @SWG\Response(
     *     response=200,
     *     description="Return the list of all the customers with configuration"
     *     )
     * )
     * @SWG\Parameter(
     *     name="key",
     *     in="formData",
     *     required=true,
     *     description="APIKey of JANUS",
     *     type="string"
     * )
     * @SWG\Parameter(
     *     name="test",
     *     in="formData",
     *     required=false,
     *     description="Force to use the test configuration",
     *     type="boolean"
     * )     
     */

    public function getJanuscustomers(Request $request) {               
        // Initalisation Manager
        $em = $this->getDoctrine()->getManager();

        // Récupération des parametres
        $key=$request->get("key");
        $test=$request->get("test");

        // Rechercher le customer en fonction de sa clé
        if($key!=$this->getParameter("appSecret")) {
            $view = $this->view("API Key inconnue", 403);
            return $this->handleView($view);            
        }

        // Calcul des attributs de l'uid
        $config = $this->janus->getAllcustomers($test);

        $view = $this->view($config, 200);
        return $this->handleView($view);
    }    
}


