<?php

namespace App\Controller;

use App\Entity\User;
use App\Entity\Group;
use App\Service\LdapService;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Security\Http\Authentication\AuthenticationUtils;
use Symfony\Component\Security\Core\Authentication\Token\UsernamePasswordToken;
use Symfony\Component\Security\Http\Event\InteractiveLoginEvent;
use Symfony\Component\EventDispatcher\EventDispatcher;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Ramsey\Uuid\Uuid;

class SecurityController extends AbstractController
{
    private $ldapService;

    public function __construct(LdapService $ldapService)
    {
        $this->ldapService = $ldapService;
    }

    public function login(Request $request, AuthenticationUtils $authenticationUtils)
    {
        $auth_mode=$this->getParameter("appAuth");
        switch($auth_mode) {
            case "SQL":
                return $this->loginMYSQL($request,$authenticationUtils);
            break;

            case "CAS":
                return $this->loginCAS($request,$authenticationUtils);
            break;
        }
    }           

    public function loginMYSQL(Request $request, AuthenticationUtils $authenticationUtils) {
        return $this->render('Home/login.html.twig', array(
            'last_username' =>  $authenticationUtils->getLastUsername(),
            'error' => $authenticationUtils->getLastAuthenticationError(),
        ));

    }

    public function loginCAS(Request $request, AuthenticationUtils $authenticationUtils)
    {
        // Récupération de la cible de navigation        
        $redirect = $this->get('session')->get("_security.main.target_path");

        // Init Client CAS
        $alias=$this->getParameter('appAlias');
        \phpCAS::setDebug('/var/www/html/'.$alias.'/var/log/cas.log');
        \phpCAS::client(CAS_VERSION_2_0, $this->getParameter('casHost'), intval($this->getParameter('casPort')), is_null($this->getParameter('casPath')) ? '' : $this->getParameter('casPath'), false);
        \phpCAS::setNoCasServerValidation();
        

        // Authentification
        \phpCAS::forceAuthentication();

        // Récupération UID
        $username = \phpCAS::getUser();

        // Récupération Attribut
        $attributes = \phpCAS::getAttributes();     

        // Init
        $email = "";
        $lastname = "";
        $firstname = "";

        // Stocker les attributs sso en session
        $this->get('session')->set("sso",$attributes);

        // Rechercher l'utilisateur
        $em = $this->getDoctrine()->getManager();
        if(isset($attributes[$this->getParameter('casUsername')]))
            $username = $attributes[$this->getParameter('casUsername')];
        
        if(isset($attributes[$this->getParameter('casEmail')]))
            $email = $attributes[$this->getParameter('casEmail')];
        
        if(isset($attributes[$this->getParameter('casLastname')]))
            $lastname = $attributes[$this->getParameter('casLastname')];
        
        if(isset($attributes[$this->getParameter('casFirstname')]))
            $firstname = $attributes[$this->getParameter('casFirstname')];

        $user = $em->getRepository('App:User')->findOneBy(array("username"=>$username));
        $exists = $user ? true : false;

        if (!$exists) {
            if(empty($email)) $email = $username."@nomail.com";

            $user = new User();
            $key = Uuid::uuid4();

            $user->setUsername($username);
            $user->setApiKey($key);
            $user->setPassword($key);
            $user->setRoles(["ROLE_USER"]);
                        
            $em->persist($user);
            $em->flush();
        }

        // Sauvegarde des attributes en session
        $this->get('session')->set('attributes', $attributes);

        // Autoconnexion
        // Récupérer le token de l'utilisateur
        $token = new UsernamePasswordToken($user, null, "main", $user->getRoles());
        $this->get("security.token_storage")->setToken($token);

        // Simuler l'evenement de connexion
        $event = new InteractiveLoginEvent($request, $token);
        $dispatcher = new EventDispatcher();
        $dispatcher->dispatch($event);

        // Redirection
        if($redirect)
            return $this->redirect($redirect);
        else
            return $this->redirect($this->generateUrl('app_home'));
    }



    public function logout() {
        $auth_mode=$this->getParameter("appAuth");
        switch($auth_mode) {
            case "SQL":
                return $this->logoutMYSQL();
            break;

            case "CAS":
                return $this->logoutCAS();
            break;
        }

    }

    public function logoutMYSQL() {
        $this->get('security.token_storage')->setToken(null);
        $this->get('session')->invalidate();

        return $this->redirect($this->generateUrl("app_home"));   
    }

    public function logoutcas() {
        $this->get('security.token_storage')->setToken(null);
        $this->get('session')->invalidate();

        // Init Client CAS
        $alias=$this->getParameter('appAlias');
        \phpCAS::setDebug('/var/www/html/'.$alias.'/var/log/cas.log');
        \phpCAS::client(CAS_VERSION_2_0, $this->getParameter('casHost'), intval($this->getParameter('casPort')), is_null($this->getParameter('casPath')) ? '' : $this->getParameter('casPath'), false);
        \phpCAS::setNoCasServerValidation();


        // Logout
        $url=$this->generateUrl('app_home', array(), UrlGeneratorInterface::ABSOLUTE_URL);
        \phpCAS::logout(array("service"=>$url));
        
        return true;
    }

    public function casdebug() {
        $attributes = $this->get('session')->get('attributes');

        return $this->render('Home/casdebug.html.twig',[
            "useheader"     => true,
            "usesidebar"    => false,
            "attributes"    => $attributes,
        ]);        
    }
}
