<?php

namespace App\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\ArrayNodeDefinition;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class JanusConfiguration implements ConfigurationInterface
{
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder('janus');
        
        /** @var ArrayNodeDefinition */
        $root = $treeBuilder->getRootNode();

        $root
            ->children()
                ->variableNode('testuid')->end()
                ->arrayNode('customers')->useAttributeAsKey('customer')->scalarPrototype()->end()->end()            
                ->variableNode('providersorder')->end()
                ->variableNode('rulesorder')->end()
                ->scalarNode('attributescache')->end()
                ->arrayNode('attributesrender')->useAttributeAsKey('customer')->variablePrototype()->end()->end()
                ->scalarNode('ressourcescache')->end()
                ->variableNode('ressourcestype')->end()
                
                ->arrayNode('providers')
                    ->useAttributeAsKey('provider')
                    ->arrayPrototype()
                        ->children()
                            ->scalarNode('type')
                                ->isRequired()
                                ->validate()
                                    ->ifNotInArray(['sso', 'bdd', 'ldap', 'ninegate'])
                                    ->thenInvalid('Invalid type provider %s')
                                ->end()
                            ->end()

                            ->scalarNode('dbname')->end()
                            ->scalarNode('user')->end()
                            ->scalarNode('password')->end()
                            ->scalarNode('host')->end()
                            ->scalarNode('port')->end()
                            ->scalarNode('basedn')->end()
                            ->scalarNode('url')->end()
                            ->scalarNode('key')->end()
                            ->scalarNode('userquery')->end()
                            ->scalarNode('groupquery')->end()
                            ->scalarNode('groupname')->end()
                            ->scalarNode('getuser')->end()
                            ->scalarNode('getgroups')->end()
                            ->variableNode('getressources')->end()
                        ->end()
                    ->end()
                ->end()


                ->arrayNode('attributes')
                    ->useAttributeAsKey('provider')
                    ->arrayPrototype()
                        ->useAttributeAsKey('attribute')
                        ->arrayPrototype()
                            ->children()                            
                                ->scalarNode('from')->end()
                                ->scalarNode('type')->end()
                                ->scalarNode('default')->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()

                ->arrayNode('rules')
                    ->useAttributeAsKey('rule')
                    ->arrayPrototype()
                        ->children()                            
                            ->scalarNode('for')->end()
                            ->scalarNode('to')->end()
                            ->scalarNode('if')->end()
                            ->scalarNode('then')->end()
                            ->scalarNode('else')->end()
                            ->scalarNode('type')->end()
                        ->end()
                    ->end()
                ->end()                

                ->arrayNode('ressources')
                    ->useAttributeAsKey('type')
                    ->arrayPrototype()
                        ->useAttributeAsKey('ressouce')
                        ->arrayPrototype()
                            ->children()                            
                                ->scalarNode('title')->end()
                                ->scalarNode('order')->end()
                                ->scalarNode('color')->end()
                                ->scalarNode('url')->end()
                                ->scalarNode('target')->end()
                                ->scalarNode('icon')->end()
                                ->scalarNode('essential')->end()
                                ->scalarNode('category')->end()
                                ->scalarNode('rule')->end()
                                ->scalarNode('description')->end()
                                ->scalarNode('item')->end()
                                ->scalarNode('fghideable')->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()

            ->end();
        
        return $treeBuilder;
    }
}