<?php

namespace App\DependencyInjection;

use App\Service\JanusService;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;

class JanusExtension extends Extension implements CompilerPassInterface
{
    protected $configjanus;

    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new JanusConfiguration();
        $configjanus = $this->processConfiguration($configuration, $configs);
        
        $this->configjanus = $configjanus;
    }

    public function test(array $configs)
    {
        $configuration = new JanusConfiguration();
        $configjanus = $this->processConfiguration($configuration, $configs);
    }

    public function process(ContainerBuilder $container)
    {
        $definition = $container->getDefinition(JanusService::class);
        $definition->replaceArgument('$configjanus', $this->configjanus);
    }
}