<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Janus
 *
 * @ORM\Table(name="janus")
 * @ORM\Entity(repositoryClass="App\Repository\JanusRepository")
 */
class Janus
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(type="boolean")
     */
    protected $isvalid;

    /**
     * @Assert\Json(
     *     message = "You've entered an invalid Json."
     * )
     * @ORM\Column(type="json", nullable=true)
     */
    private $config;

    /**
     * @Assert\Json(
     *     message = "You've entered an invalid Json."
     * )
     * @ORM\Column(type="json", nullable=true)
     */
    private $configbackup;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getIsvalid(): ?bool
    {
        return $this->isvalid;
    }

    public function setIsvalid(bool $isvalid): self
    {
        $this->isvalid = $isvalid;

        return $this;
    }

    public function getConfig(): ?array
    {
        return $this->config;
    }

    public function setConfig(?array $config): self
    {
        $this->config = $config;

        return $this;
    }

    public function getConfigbackup(): ?array
    {
        return $this->configbackup;
    }

    public function setConfigbackup(?array $configbackup): self
    {
        $this->configbackup = $configbackup;

        return $this;
    }

    
    
    
}
