<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Usercache
 *
 * @ORM\Table(name="usercache")
 * @ORM\Entity(repositoryClass="App\Repository\UsercacheRepository")
 */
class Usercache
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="customer", type="string", nullable=false)
     * @Assert\NotBlank()
     *
     */
    private $customer;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     */
    private $dateattributes;
    
    /**
     * @Assert\Json(
     *     message = "You've entered an invalid Json."
     * )
     * @ORM\Column(type="json", nullable=true)
     */
    private $attributes;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     */
    private $dateressources;
    
    /**
     * @Assert\Json(
     *     message = "You've entered an invalid Json."
     * )
     * @ORM\Column(type="json", nullable=true)
     */
    private $ressources;
    
    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="usercaches")
     */
    private $user;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCustomer(): ?string
    {
        return $this->customer;
    }

    public function setCustomer(string $customer): self
    {
        $this->customer = $customer;

        return $this;
    }

    public function getDateattributes(): ?\DateTimeInterface
    {
        return $this->dateattributes;
    }

    public function setDateattributes(?\DateTimeInterface $dateattributes): self
    {
        $this->dateattributes = $dateattributes;

        return $this;
    }

    public function getAttributes()
    {
        return $this->attributes;
    }

    public function setAttributes($attributes): self
    {
        $this->attributes = $attributes;
        $this->dateattributes = new \DateTime();

        return $this;
    }

    public function getDateressources(): ?\DateTimeInterface
    {
        return $this->dateressources;
    }

    public function setDateressources(?\DateTimeInterface $dateressources): self
    {
        $this->dateressources = $dateressources;

        return $this;
    }

    public function getRessources(): ?array
    {
        return $this->ressources;
    }

    public function setRessources(?array $ressources): self
    {
        $this->ressources = $ressources;
        $this->dateressources = new \DateTime();

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }



}
