<?php
namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use FOS\CKEditorBundle\Form\Type\CKEditorType;
use Burgov\Bundle\KeyValueFormBundle\Form\Type\KeyValueType;

class JanusType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $mode=$options["mode"];
        $type=$options["type"];
        $keys=$options["keys"];
        $config=$options["config"];

        $builder->add('submit',
            SubmitType::class,
            array("label"       => "Valider",
                  "attr"        => array("class" => "btn btn-success mb-3")));

        foreach($keys as $key) {
            switch($key["type"]) {
                case "string":
                    $builder->add($key["id"],
                        TextType::class,[
                            "label"       => $key["id"],
                            "required"    => $key["required"],
                            "disabled"    => ($mode=="update"&&!$key["updatable"]),
                            "label_attr"  => ["class"=>"class-".$key["id"]],
                            "attr"        => ["class"=>"class-".$key["id"]],
                        ]
                    );
                    break;

                case "boolean":
                    $choices=["oui" => "1","non" => "0"];
                    $builder->add($key["id"],
                        ChoiceType::class,[
                            "label"       => $key["id"],
                            "required"    => $key["required"],
                            "choices"     => $choices,
                            "label_attr"  => ["class"=>"class-".$key["id"]],
                            "attr"        => ["class"=>"class-".$key["id"]],                            
                        ]
                    );
                    break;

                case "integer":
                    $builder->add($key["id"],
                        IntegerType::class, [
                            "label"       => $key["id"],
                            "required"    => $key["required"],
                            "label_attr"  => ["class"=>"class-".$key["id"]],
                            "attr"        => ["class"=>"class-".$key["id"],"min" => "0"],                            
                        ]
                    );
                break;

                case "customer":
                    $customers=$config["customers"];
                    $choices=[];
                    foreach($customers as $id=>$name) {
                        $choices[$id]=$id;
                    }

                    $builder->add($key["id"],
                        ChoiceType::class,[
                            "label"       => $key["id"],
                            "required"    => $key["required"],
                            "choices"     => $choices,
                            "label_attr"  => ["class"=>"class-".$key["id"]],
                            "attr"        => ["class"=>"class-".$key["id"]],                            
                        ]
                    );
                break;

                case "ssoattributes":
                    $builder->add($key["id"],
                        KeyValueType::class, [
                            "attr"          => ["class"=>"fieldarray fieldarraydelete"],
                            "allow_add"     => true,
                            "allow_delete"  => true,
                            "required"      => false,
                            "value_type"    =>  TextType::class,
                            "key_options"   => ["attr"=>["class"=>"class-key"]],
                            "value_options" => ["attr"=>["class"=>"class-value"]]
                        ]
                    );
                break;

                case "typeprovider":
                    $choices=[""=>"","bdd"=>"bdd","ldap"=>"ldap","ninegate"=>"ninegate"];
                    $builder->add($key["id"],
                        ChoiceType::class,[
                            "label"       => $key["id"],
                            "required"    => $key["required"],
                            "choices"     => $choices,
                            "label_attr"  => ["class"=>"class-".$key["id"]],
                            "attr"        => ["class"=>"class-".$key["id"]],                            
                        ]
                    );
                break;

                case "getressources":
                    $choices=["items"=>"items","bookmarks"=>"bookmarks","alerts"=>"alerts"];
                    $builder->add($key["id"],
                        ChoiceType::class,[
                            "label"       => $key["id"],
                            "required"    => $key["required"],
                            "choices"     => $choices,
                            "label_attr"  => ["class"=>"class-".$key["id"]],
                            "attr"        => ["class"=>"class-".$key["id"]],    
                            "multiple"    => true,
                        ]
                    );
                break;
            
                case "typeattribute":
                    $choices=["string"=>"string","integer"=>"integer","boolean"=>"boolean","array"=>"array","email"=>"email","avatar"=>"avatar","image"=>"image","url"=>"url"];
                    $builder->add($key["id"],
                        ChoiceType::class,[
                            "label"       => $key["id"],
                            "required"    => $key["required"],
                            "choices"     => $choices,
                            "label_attr"  => ["class"=>"class-".$key["id"]],
                            "attr"        => ["class"=>"class-".$key["id"]],    
                        ]
                    );
                break;                

                case "thengroup":
                    $choices=["add"=>"add","remove"=>"remove"];
                    $builder->add($key["id"],
                        ChoiceType::class,[
                            "label"       => $key["id"],
                            "required"    => $key["required"],
                            "choices"     => $choices,
                            "label_attr"  => ["class"=>"class-".$key["id"]],
                            "attr"        => ["class"=>"class-".$key["id"]],                            
                        ]
                    );
                break;

                case "choice":
                    $choices=[];
                    foreach($key["choice"] as $name) {
                        $choices[$name]=$name;
                    }
                    if(empty($choices)) $choices[""]="";

                    $builder->add($key["id"],
                        ChoiceType::class,[
                            "label"       => $key["id"],
                            "required"    => $key["required"],
                            "choices"     => $choices,
                            "label_attr"  => ["class"=>"class-".$key["id"]],
                            "attr"        => ["class"=>"class-".$key["id"]],                            
                        ]
                    );
                break;

                case "editor":
                    $builder->add($key["id"],
                        CKEditorType::class,[
                            "required" => ($options["required"]==0?false:true),
                            "config" => [
                                'uiColor' => '#ffffff',
                                'height' => 600,
                                'filebrowserUploadRoute' => 'app_ckeditor_upload',
                                'language' => 'fr',
                            ]
                        ]
                    );
                break;


                case "code":
                    $builder->add($key["id"],
                        TextareaType::class, [
                            "required" => ($options["required"]==0?false:true),
                            "attr"        => array("class" => "form-control", "style" => "margin-top:15px; height: 600px;"),
                        ]
                    );
                break;                
            }
        }

        if($type!="function") {
            $builder->add('help',
                TextareaType::class, [
                    "label"       =>"Aide",
                    "attr"        => array("class" => "form-control", "style" => "margin-top:15px; height: 200px;"),
                    "required"    => false,
                    "disabled"    => true
                ]
            );
        }
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'mode'          => "string",
            'type'          => "string",
            'keys'          => "array",
            'config'        => "array",
        ));
    }
}
