<?php

namespace App\Service;

use Symfony\Component\DependencyInjection\ContainerInterface;
use Doctrine\Common\Persistence\ManagerRegistry;
use App\Service\LdapService;

use Symfony\Component\ExpressionLanguage\ExpressionLanguage;
use Ramsey\Uuid\Uuid;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\Finder\Finder;

use App\Entity\User;
use App\Entity\Usercache;
use App\Entity\Janus;

class JanusService
{
    private $container;
    private $doctrine;
    private $em;
    private $ldap;
    private $configjanus;
    private $istest;

    public function __construct(ContainerInterface $container, ManagerRegistry $doctrine, LdapService $ldap, array $configjanus = [] )
    {
        $this->container = $container;
        $this->doctrine = $doctrine;
        $this->em = $doctrine->getManager();
        $this->ldap = $ldap;
        $this->configjanus = $configjanus;
        $this->test = false;
    }

    public function getCustomer($key,$usetest=false) {
        // Initialiser l'utilisation de la configuration de test
        if($usetest)
            $this->initTest();

        $customers=$this->configjanus["customers"];
        return array_search($key,$customers);
    }

    public function getUserattributes($customer,$uid,$refresh=false,$sso=null,$usetest=false) {
        // Initialiser l'utilisation de la configuration de test
        if($usetest) {
            $this->initTest();
            $refresh=true;
        }

        // Récupérer la configuration Janus
        $configjanus = $this->configjanus;

        // Récupération le paramètrage des attributs et trier les attributes par ordre de providers
        $attproviders=$configjanus["attributes"];
        $attproviders = array_merge(array_flip($configjanus["providersorder"]), $attproviders);
        foreach($attproviders as $key => $value) { if(!is_array($value)) unset($attproviders[$key]); }
        
        // Récupération le paramètrage des règles et les trier les ordre de calcul
        $rules=$configjanus["rules"];
        $rules = array_merge(array_flip($configjanus["rulesorder"]), $rules);

        // Initialisation des attributes
        $userattributes=new \stdClass;
        $userattributes->uid=new \stdClass;
        $userattributes->uid->value=$uid;
        $userattributes->uid->type="string";

        // Récupérer le cache
        if(!$refresh&&!$usetest) {           
            // Récupérer le user
            $this->doctrine->getConnection("default");
            $user=$this->em->getRepository("App:User")->findOneBy(["username"=>$uid]);
            
            // S'il n'existe pas forcement on doit le calculer
            if(!$user)
                $refresh=true;
            else {
                $usercache=$this->em->getRepository("App:Usercache")->findOneBy(["user"=>$user,"customer"=>$customer]);

                // S'il n'existe pas forcement on doit le calculer
                if(!$usercache||!$usercache->getDateattributes()) $refresh=true;

                // Sinon
                else {
                    // Si la date du dernier cache plus le délais
                    $lastrefresh=$usercache->getDateattributes();
                    $timerefresh=$configjanus["attributescache"];
                    $now=new \DateTime();
                    $lastrefresh->add(new \DateInterval('PT'.$timerefresh.'S'));

                    // Dépasse alors on refresh
                    if($lastrefresh<$now) $refresh=true;
                    // Sinon on récupèe le cache
                    else $userattributes=(object)$usercache->getAttributes();
                }
            }
        }
        
        // Si refresh
        if($refresh) {
            // On initialise l'ensemble des attributs à null
            foreach($attproviders as $provider => $attributes) {
                foreach($attributes as $name => $attribute) {
                    $userattributes->$name=new \stdClass;
                    if($attribute["type"]=="array")
                        $userattributes->$name->value=[];
                    else 
                        $userattributes->$name->value=null;
                    $userattributes->$name->type=$attribute["type"];
                }

                $userattributes->groups=[];
            }

            // Pour chaque providers d'attributes
            foreach($attproviders as $provider => $attributes) {

                // On récupère la configuration de l'attributes
                $infoprovider=$configjanus["providers"][$provider];

                // En fonction du type de providers
                switch($infoprovider["type"]) {
                    // Si SSO
                    case "sso":
                        // Si présence d'attributs sso en entrée
                        if(!is_null($sso)) {
                            if($attributes) {
                                foreach($attributes as $name => $attribute) {
                                    
                                    // On valorise l'attribues si existe dans les attributs sso en paramétre et si l'attributes n'a pas été valorisé par un autre provider
                                    if(array_key_exists($attribute["from"],$sso)) {
                                        if($name!="groups") {
                                            $userattributes->$name->value=$sso[$attribute["from"]];
                                            if($attribute["type"]=="array"&&!is_array($userattributes->$name->value)) {
                                                $tmp=explode(",",$userattributes->$name->value);
                                                $userattributes->$name->value=$tmp;                                                
                                            }
                                        }
                                        else {
                                            $userattributes->$name=$sso[$attribute["from"]];
                                            if(!is_array($userattributes->$name)) {
                                                $tmp=explode(",",$userattributes->$name);
                                                $userattributes->$name=$tmp;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    break;

                    // Si BDD
                    case "bdd":
                        // Se connecter à la bdd
                        $config = new \Doctrine\DBAL\Configuration();
                        $connectionParams = array(
                            'dbname' => $infoprovider["dbname"],
                            'user' => $infoprovider["user"],
                            'password' => $infoprovider["password"],
                            'host' => $infoprovider["host"],
                            'driver' => 'pdo_mysql',
                        );
                        $bdd = \Doctrine\DBAL\DriverManager::getConnection($connectionParams, $config);
                        try { $bdd->connect(); } catch (\Exception $e) { } 

                        // Si connection ok
                        if($bdd->isConnected()) {
                            // Executer la requete de recherche du uid
                            $userquery=$infoprovider["userquery"];
                            $stmt = $bdd->prepare($userquery);
                            $stmt->bindParam(':uid', $uid);
                            $stmt->execute();
                            $infouser = $stmt->fetchAll();
                            
                            // Si trouvé
                            if($infouser) {
                                // Pour chaque attributes souhaités
                                if(array_key_exists("userquery",$infoprovider)&&$attributes) {
                                    foreach($attributes as $name => $attribute) {
                                        // On valorise l'attribues si existe dans la requete retourné et si l'attributes n'a pas été valorisé par un autre providoer
                                        if(array_key_exists($attribute["from"],$infouser[0])&&$userattributes->$name->value==null) {
                                            $userattributes->$name->value=$infouser[0][$attribute["from"]];
                                        }
                                    }
                                }
                            }

                            // Executer la requete de recherce de groupe
                            if(array_key_exists("groupquery",$infoprovider)&&array_key_exists("groupname",$infoprovider)) {
                                $groupquery=$infoprovider["groupquery"];
                                
                                $groupname=$infoprovider["groupname"];
                                $stmt = $bdd->prepare($groupquery);
                                $stmt->bindParam(':uid', $uid);
                                $stmt->execute();
                                $infogroups = $stmt->fetchAll();

                                // Pour chaque groups
                                foreach($infogroups as $infogroup) {
                                    // Initialiser l'attributes groups
                                    if(!property_exists($userattributes, "groups"))
                                        $userattributes->groups=[];
                                    
                                    // Enregistrer le group dans l'attribut du user
                                    if(!in_array($infogroup[$groupname],$userattributes->groups))
                                        array_push($userattributes->groups,$infogroup[$groupname]);
                                }
                            }
                        }
                    break;


                    // Si LDAP
                    case "ldap":
                        // Deconnecter une potentiel autre connection ldap
                        $this->ldap->disconnect();

                        // Parameter la connection ldap
                        $this->ldap->setHost($infoprovider["host"]);
                        $this->ldap->setPort($infoprovider["port"]);
                        $this->ldap->setUser($infoprovider["user"]);
                        $this->ldap->setPassword($infoprovider["password"]);
                        $this->ldap->setBasedn($infoprovider["basedn"]);

                        // Si connection OK
                        if($this->ldap->connect()) {
                            // Executer la requete de recherche du uid
                            $userquery=$infoprovider["userquery"];
                            $userquery=str_replace(":uid",$uid,$userquery);
                            $infouser = $this->ldap->search($userquery);
                            
                            // Si trouvé
                            if(!empty($infouser)) {
                                // Pour chaque attributes souhaités
                                if(array_key_exists("userquery",$infoprovider)&&$attributes) {
                                    foreach($attributes as $name => $attribute) {
                                        // On valorise l'attribues si existe dans la requete retourné
                                        if(array_key_exists($attribute["from"],$infouser[0])&&$userattributes->$name->value==null) {
                                            $userattributes->$name->value=$infouser[0][$attribute["from"]];
                                        }                                          
                                    }
                                }
                            }

                            // Executer la requete de recherce de groupe
                            if(array_key_exists("groupquery",$infoprovider)&&array_key_exists("groupname",$infoprovider)) {
                                $groupquery=$infoprovider["groupquery"];
                                $groupname=$infoprovider["groupname"];
                                $groupquery=str_replace(":uid",$uid,$groupquery);
                                $infogroups = $this->ldap->search($groupquery);

                                // Pour chaque groups
                                foreach($infogroups as $infogroup) {
                                    // Initialiser l'attributes groups
                                    if(!property_exists($userattributes, "groups"))
                                        $userattributes->groups=[];
                                    
                                    // Enregistrer le group dans l'attribut du user
                                    if(!in_array($infogroup[$groupname],$userattributes->groups))
                                        array_push($userattributes->groups,$infogroup[$groupname]);
                                }                        
                            }
                        }
                    break;


                    // Si Ninegate
                    case "ninegate":
                        // Faire appel à l'API ninegate afin de récupérer attribut et groups
                        $url=$infoprovider["url"]."/rest/user/".$uid;
                        $key=$infoprovider["key"];
                        $only="user";
                        if($infoprovider["getgroups"]) $only.=",groups";
                        $response=$this->apiNinegate($url,$key,["only"=>$only]);

                        // Si OK
                        if($response){
                            // On récupère les attributs ninegate
                            $infouser=$response->body->user;

                            // Pour chaque attributes souhaités
                            if(array_key_exists("getuser",$infoprovider)&&$infoprovider["getuser"]&&$attributes) {
                                foreach($attributes as $name => $attribute) {
                                    // On valorise l'attribues si existe dans la requete retourné
                                    if(property_exists($infouser,$attribute["from"])&&$userattributes->$name->value==null) {
                                        $from=$attribute["from"];
                                        $userattributes->$name->value=$infouser->$from;
                                    }
                                }
                            }
                            
                            if(array_key_exists("getgroups",$infoprovider)&&$infoprovider["getgroups"]) {
                                // On crécupère les groupes ninegate
                                $infogroups = $response->body->groups;

                                // Pour chaque groups
                                foreach($infogroups as $infogroup) {
                                    // Initialiser l'attributes groups
                                    if(!property_exists($userattributes, "groups"))
                                        $userattributes->groups=[];
                                    
                                    // Enregistrer le group dans l'attribut du user
                                    if(!in_array($infogroup->title,$userattributes->groups))
                                        array_push($userattributes->groups,$infogroup->title);
                                }                        
                            }
                        }
                    break;                    
                }
            }

            // On valorise les valeurs par défaut
            foreach($attproviders as $provider => $attributes) {
                foreach($attributes as $name => $attribute) {
                    if($name!="groups"&&$userattributes->$name->value==null)
                        $userattributes->$name->value=$attribute["default"];
                }
            }

            // Initialisation des expressions
            $EL = new ExpressionLanguage();
            $functions=[];

            // Charger l'ensemble des fonctions EOLE
            $dir=$this->container->getParameter('kernel.project_dir');
            $dir.="/config/eole/functions";
            $fs = new Filesystem();
            if($fs->exists($dir)) {
                $finder = new Finder();
                $finder->in($dir)->files()->name('*.php')->depth('== 0');;
                foreach (iterator_to_array($finder) as $file) {
                    $functions[$file->getFilename()]=$file->getPathname();
                }
            }

            // Charger l'ensemble des fonctions JANUS
            $dir=$this->container->getParameter('kernel.project_dir');
            $dir.="/config/janus/functions";
            $fs = new Filesystem();
            if($fs->exists($dir)) {
                $finder = new Finder();
                $finder->in($dir)->files()->name('*.php')->depth('== 0');;
                foreach (iterator_to_array($finder) as $file) {
                    $functions[$file->getFilename()]=$file->getPathname();
                }
            }

            // Si mode test 
            if($this->istest) {
                // Charger l'ensemble des fonctions add si on est en mode test
                $dir=$this->container->getParameter('kernel.project_dir');
                $dir.="/config/janus/functions/add";
                $fs = new Filesystem();
                if($fs->exists($dir)) {
                    $finder = new Finder();
                    $finder->in($dir)->files()->name('*.php')->depth('== 0');;
                    foreach (iterator_to_array($finder) as $file) {
                        $functions[$file->getFilename()]=$file->getPathname();
                    }
                }        
                
                // Décharger l'ensemble des fonctions del si on est en mode test
                $dir=$this->container->getParameter('kernel.project_dir');
                $dir.="/config/janus/functions/del";
                $fs = new Filesystem();
                if($fs->exists($dir)) {
                    $finder = new Finder();
                    $finder->in($dir)->files()->name('*.php')->depth('== 0');;
                    foreach (iterator_to_array($finder) as $file) {
                        $patheole=str_replace("/janus/functions/del/","/eole/functions/",$file->getPathname());
                        if($fs->exists($patheole))
                            $functions[$file->getFilename()]=$patheole;
                        else
                            unset($functions[$file->getFilename()]);
                    }
                }                  
            }

            foreach($functions as $basename => $function) {
                include($function);
            }

            // Sur l'ensemble des rules
            foreach($rules as $name => $rule) {    
                // Si à destination d'un attribut
                if($rule["for"]=="attributes") {
                    // Destinataire de la rule
                    $to=$rule["to"];

                    if($EL->evaluate($rule["if"],['user' => $userattributes,'customer'=>$customer,'configjanus'=>$configjanus])) {
                        // si rule then
                        if(array_key_exists("then",$rule)) {
                            $userattributes->$to=new \stdClass;
                            $userattributes->$to->value=$EL->evaluate($rule["then"],['user' => $userattributes,'customer'=>$customer,'configjanus'=>$configjanus]);
                            $userattributes->$to->type=$rule["type"];
                        }
                    }
                    else {
                        // si rule else
                        if(array_key_exists("else",$rule)) {
                            $userattributes->$to=new \stdClass;
                            $userattributes->$to->value=$EL->evaluate($rule["else"],['user' => $userattributes,'customer'=>$customer,'configjanus'=>$configjanus]);
                            $userattributes->$to->type=$rule["type"];
                        }
                    }
                }

                // Si à destination d'un groupe
                if($rule["for"]=="groups") {
                    if($EL->evaluate($rule["if"],['user' => $userattributes,'customer'=>$customer,'configjanus'=>$configjanus])) {
                        // si rule add
                        if($rule["then"]=="add") {
                            if(!in_array($rule["to"],$userattributes->groups))
                                array_push($userattributes->groups,$rule["to"]);
                        }
                        if($rule["then"]=="remove") {
                            if (($key = array_search($rule["to"], $userattributes->groups)) !== false) {
                                unset($userattributes->groups[$key]);
                            }                            
                        }
                    } 
                }               
            }         
        }
        
        

        if(!empty((array)$userattributes)) {
            // Ordonner le rendu des attributes et s'assurer que les sous elements sont bien des objects et non des array
            $render=$configjanus["attributesrender"][$customer];
            $ordered=new \stdClass;
            foreach($render as $attribut) {
                if(property_exists($userattributes, $attribut)) {
                    if($attribut!="groups") 
                        $ordered->$attribut=(object) $userattributes->$attribut;
                    else 
                        $ordered->$attribut=$userattributes->$attribut;
                }
            }

            // Transformer le array groups en object typé
            if(!is_object($userattributes->groups)) {
                $ordered->groups = new \stdClass;
                if(array_key_exists("value",$userattributes->groups))
                    $ordered->groups->value = $userattributes->groups["value"];
                else
                    $ordered->groups->value = $userattributes->groups;
                $ordered->groups->type = "array";
            }
            $userattributes=$ordered;            
            
            // Génération du cache uniquement si on n'est pas en mode test
            if(!$usetest) {
                // Rechercher l'utilisateur
                $this->doctrine->getConnection("default");
                $user=$this->em->getRepository("App:User")->findOneBy(["username"=>$uid]);

                // S'il n'existe pas on l'initialise
                if(!$user) {
                    $user = new User;
                    $key = Uuid::uuid4();
                    $user->setUsername($uid);
                    $user->setPassword($key);
                    $user->setRoles(["ROLE_USER"]);
                    $user->setApiKey($key);
                    $this->em->persist($user);
                    $this->em->flush();
                }

                $usercache=$this->em->getRepository("App:Usercache")->findOneBy(["user"=>$user,"customer"=>$customer]);
                if(!$usercache) {
                    $usercache = new Usercache;
                    $usercache->setUser($user);
                    $usercache->setCustomer($customer);
                    $usercache->setAttributes((array)$userattributes);
                    $this->em->persist($usercache);
                    $this->em->flush();
                }

                // Mise à jour du cache si refresh demandé
                if($refresh) {
                    $usercache->setAttributes((array)$userattributes);
                    $this->em->persist($usercache);
                    $this->em->flush();
                }
            }
        }
        return (object) $userattributes;
    }

    public function getUserressources($customer,$uid,$refresh=false,$type="all",$sso=null,$usetest=false) {
        // Initialiser l'utilisation de la configuration de test
        if($usetest) {
            $this->initTest();
            $refresh=true;
        }

        // Récupérer la configuration Janus
        $configjanus = $this->configjanus;

        // Récupérer les attributs du user
        $userattributes=$this->getUserattributes($customer,$uid,false,$sso,$usetest);

        // Retransformer les groupes en array pour simplifier les rules
        if(property_exists($userattributes, "groups")) {
            $tbgroups=$userattributes->groups->value;
            $userattributes->groups=$tbgroups;
        }
        else $userattributes->groups=[];
        
        // Récupérer le cache
        if(!$refresh&&!$usetest) {
            $this->doctrine->getConnection("default");
            $user=$this->em->getRepository("App:User")->findOneBy(["username"=>$uid]);

            // S'il n'existe pas forcement on doit le calculer
            if(!$user) 
                $refresh=true;
            else {
                $usercache=$this->em->getRepository("App:Usercache")->findOneBy(["user"=>$user,"customer"=>$customer]);

                // S'il n'existe pas forcement on doit le calculer
                if(!$usercache||!$usercache->getDateressources()) $refresh=true;

                // Sinon
                else {
                    // Si la date du dernier cache plus le délais
                    $lastrefresh=$usercache->getDateressources();
                    $timerefresh=$configjanus["ressourcescache"];
                    $now=new \DateTime();
                    $lastrefresh->add(new \DateInterval('PT'.$timerefresh.'S'));

                    // Dépasse alors on refresh
                    if($lastrefresh<$now) $refresh=true;
                    // Sinon on récupèe le cache
                    else $userressources=(object)$usercache->getRessources();
                }            
            }
        }

        // Si refresh
        if($refresh) {        
            // Initialisation les ressources
            $tbtypes=$configjanus["ressourcestype"];
            $userressources=new \stdClass;
            foreach($tbtypes as $key) {
                $userressources->$key=new \stdClass;
            }


            // Récupérer les ressources associés aux providers s'il y en a
            $providers = $configjanus["providers"];
            foreach($providers as $provider => $infoprovider) {

                if($infoprovider["type"]=="ninegate"){
                    // Si ninegate est providers de ressouces
                    if(!empty($infoprovider["getressources"])) {
                        // Récupérer les ressources
                        $only=implode(",",$infoprovider["getressources"]);
                        $url=$infoprovider["url"]."/rest/user/".$uid;
                        $key=$infoprovider["key"];
                        $response=$this->apiNinegate($url,$key,["only"=>$only]);   
                        if($response) {
                            foreach($tbtypes as $key) {
                                if(property_exists($response->body, $key))  {
                                    foreach($response->body->$key as $ressource) {
                                        $id="ninegate-".$key."-".$ressource->id;
                                        $userressources->$key->$id=new \stdClass;

                                        switch($key) {
                                            case "itemcategorys" :
                                                $userressources->$key->$id->title=$ressource->title;
                                                $userressources->$key->$id->order=$ressource->order;
                                                $userressources->$key->$id->color=$ressource->color;
                                            break;

                                            case "items" :
                                                $userressources->$key->$id->title=$ressource->title;
                                                $userressources->$key->$id->url=$ressource->url;
                                                $userressources->$key->$id->target=$ressource->target;
                                                $userressources->$key->$id->order=$ressource->order;
                                                $userressources->$key->$id->color=$ressource->color;
                                                $userressources->$key->$id->icon=$ressource->icon;
                                                $userressources->$key->$id->essential=$ressource->essential;
                                                $userressources->$key->$id->category="ninegate-itemcategorys-".$ressource->category;
                                            break;

                                            case "bookmarks" :
                                                $userressources->$key->$id->title=$ressource->title;
                                                $userressources->$key->$id->url=$ressource->url;
                                                $userressources->$key->$id->target=$ressource->target;
                                                $userressources->$key->$id->item=$ressource->item;
                                                $userressources->$key->$id->order=$ressource->order;
                                                $userressources->$key->$id->color=$ressource->color;
                                                $userressources->$key->$id->icon=$ressource->icon;
                                            break;  
                                            
                                            case "alertcategorys" :
                                                $userressources->$key->$id->title=$ressource->title;
                                                $userressources->$key->$id->color=$ressource->color;
                                                $userressources->$key->$id->icon=$ressource->icon;
                                            break;

                                            case "alerts" :
                                                $userressources->$key->$id->title=$ressource->title;
                                                $userressources->$key->$id->order=$ressource->order;
                                                $userressources->$key->$id->description=$ressource->description;
                                                $userressources->$key->$id->fghideable=$ressource->fghideable;
                                                $userressources->$key->$id->category="ninegate-alertcategorys-".$ressource->category;
                                            break;                                        
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }

            // Initialisation des expressions
            $EL = new ExpressionLanguage();

            // Charger l'ensemble des fonction EL client
            $dir=$this->container->getParameter('kernel.project_dir');
            $dir.="/config/janus/functions";
            $fs = new Filesystem();
                if($fs->exists($dir)) {
                $finder = new Finder();
                $finder->in($dir)->files()->name('*.php');
                foreach (iterator_to_array($finder) as $file) {
                    include($file->getPathname());
                }
            }

            // Récupérer les ressources janus
            $janusressources=$configjanus["ressources"];

            foreach($tbtypes as $key) {
                if(array_key_exists($key,$janusressources))  {
                    // Pour chaque ressource de ce type
                    foreach($janusressources[$key] as $id => $params)  {
                        $togive=(!array_key_exists("rule",$params)||$EL->evaluate($params["rule"],['user' => $userattributes,'customer'=>$customer,'configjanus'=>$configjanus]));                      
                        if($togive) {
                            $userressources->$key->$id=new \stdClass;
                            foreach($params as $idparam => $param) {
                                $userressources->$key->$id->$idparam=$param;
                            }
                        }
                    }
                }
            }
            
        }

        if(!empty((array)$userressources)&&!$usetest) {
            // Rechercher l'utilisateur
            $this->doctrine->getConnection("default");
            $user=$this->em->getRepository("App:User")->findOneBy(["username"=>$uid]);

            // S'il n'existe pas on l'initialise
            if(!$user) {
                $user = new User;
                $key = Uuid::uuid4();
                $user->setUsername($uid);
                $user->setPassword($key);
                $user->setRoles(["ROLE_USER"]);
                $user->setApiKey($key);
                $this->em->persist($user);
                $this->em->flush();
            }

            $usercache=$this->em->getRepository("App:Usercache")->findOneBy(["user"=>$user,"customer"=>$customer]);
            if(!$usercache) {
                $usercache = new Usercache;
                $usercache->setUser($user);
                $usercache->setCustomer($customer);
                $usercache->setRessources((array)$userressources);
                $this->em->persist($usercache);
                $this->em->flush();
            }
            
            // Mise à jour du cache si refresh demandé
            if($refresh) {
                $usercache->setRessources((array)$userressources);
                $this->em->persist($usercache);
                $this->em->flush();
            }
        }

        // Enlever du résultat les type qui ne sont pas demandé
        if($type!="all") {
            $tbtypes=explode(",",$type);
            foreach($userressources as $key=>$value) {
                if(!in_array($key,$tbtypes))
                    unset($userressources->$key);
            }
        }
        
        return $userressources;
    }
    
    public function getConfig($usetest=false) {
        // Initialiser l'utilisation de la configuration de test
        if($usetest) {
            $this->initTest();
        }

        return $this->configjanus;
    }

    public function getCustomers($usetest=false) {
        // Initialiser l'utilisation de la configuration de test
        if($usetest) {
            $this->initTest();
        }

        $customers = $this->configjanus["customers"];
        return $customers;
    }

    public function getProviders() {
        $providers = $this->configjanus["providers"];
        $providers = array_merge(array_flip($this->configjanus["providersorder"]), $providers);
        foreach($providers as $key => $value) { if(!is_array($value)) unset($providers[$key]); }     
        
        return $providers;
    }

    public function getAttributes() {
        $attributes = $this->configjanus["attributes"];
        return $attributes;
    }

    public function getFunctions() {
        $functions=[];
        $names=[];

        // Charger l'ensemble des fonction EL client
        $dir=$this->container->getParameter('kernel.project_dir');
        $dir.="/config/eole/functions";
        $fs = new Filesystem();
        if($fs->exists($dir)) {
            $finder = new Finder();
            $finder->in($dir)->files()->name('*.php');
            foreach (iterator_to_array($finder) as $file) {
                $functions[$file->getFilename()]=$file->getPathname();
            }
        }

        // Charger l'ensemble des fonction EL client
        $dir=$this->container->getParameter('kernel.project_dir');
        $dir.="/config/janus/functions";
        $fs = new Filesystem();
        if($fs->exists($dir)) {
            $finder = new Finder();
            $finder->in($dir)->files()->name('*.php');
            foreach (iterator_to_array($finder) as $file) {
                // A charger que s'il n'existe pas dans le répertoire del
                if(!$fs->exists($dir."/del/".$file->getFilename()))
                    $functions[$file->getFilename()]=$file->getPathname();
            }
        }

        return $functions;
    }

    public function getRules() {
        $rules = $this->configjanus["rules"];
        $rules = array_merge(array_flip($this->configjanus["rulesorder"]), $rules);
        
        return $rules;
    }

    public function getRessources() {
        $ressources = $this->configjanus["ressources"];
        $ressources = array_merge(array_flip($this->configjanus["ressourcestype"]), $ressources);

        $types=$this->configjanus["ressourcestype"];
        foreach($types as $type) {
            if(array_key_exists($type,$ressources)&&is_array($ressources[$type])) {
                $order=[];
                foreach($ressources[$type] as $key => $ressource) {
                    if(array_key_exists("order",$ressource))
                        $order[$ressource["order"]] = $key;
                }
                ksort($order);
                if(!empty($order))
                    $ressources[$type]=array_merge(array_flip($order), $ressources[$type]);
            }
        }

        return $ressources;
    }

    public function getAllattributes() {
        $attributs=[];

        // L'ensemble des attributs provenant des provinders
        $providerattributs=$this->configjanus["attributes"];
        foreach($providerattributs as $key => $providerattribut) {
            foreach($providerattribut as $key => $attribut) {
                if(!in_array($key,$attributs)) array_push($attributs,$key);    
            }
        }

        // L'ensemble des attributs des rules
        $rules=$this->configjanus["rules"];
        foreach($rules as $key=>$rule) {
            if($rule["for"]=="attributes") {
                if(!in_array($rule["to"],$attributs)) array_push($attributs,$rule["to"]);    
            }
        }

        // On ajoute forcement l'attributs spécial uid et groups
        if(!in_array("uid",$attributs)) array_push($attributs,"uid");
        if(!in_array("groups",$attributs)) array_push($attributs,"groups");

        // Retour
        return $attributs;
    }

    public function getAttributesrender($customer=null,$usetest=false) {
        // Initialiser l'utilisation de la configuration de test
        if($usetest)
            $this->initTest();

        // Récupérer la configuration Janus
        $configjanus = $this->configjanus;
        if(is_null($customer))
            return $configjanus["attributesrender"];
        else
            return $configjanus["attributesrender"][$customer];
    }

    public function getFreeattributes($customer) {
        $all=$this->getAllattributes();
        $have=$this->getAttributesrender($customer);
        return array_diff($all,$have);
    }

    public function getAllcustomers($usetest=false) {
        // Initialiser l'utilisation de la configuration de test
        if($usetest)
            $this->initTest();

        // Récupérer la configuration Janus
        $configjanus = $this->configjanus;

        $tbcustomers=[];        
        if(array_key_exists("customers",$configjanus)) {
            foreach($configjanus["customers"] as $customer => $key) {
                $tbcustomers[$customer]["apikey"]=$key;
                $tbcustomers[$customer]["attributesrender"]=[];
                if(array_key_exists("attributesrender",$configjanus)&&array_key_exists($customer,$configjanus["attributesrender"])) {
                    foreach($configjanus["attributesrender"][$customer] as $attributerender) {
                        array_push($tbcustomers[$customer]["attributesrender"],$attributerender);
                    }
                }
            }
        }

        return $tbcustomers;
    }

    public function testConnexion($provider) {
        switch($provider["type"]) {
            case "bdd":
                // Se connecter à la bdd
                $config = new \Doctrine\DBAL\Configuration();
                $connectionParams = array(
                    'dbname' => $provider["dbname"],
                    'user' => $provider["user"],
                    'password' => $provider["password"],
                    'host' => $provider["host"],
                    'driver' => 'pdo_mysql',
                );
                $bdd = \Doctrine\DBAL\DriverManager::getConnection($connectionParams, $config);
                
                try {
                    $bdd->connect();
                } catch (\Exception $e) {
                }                

                return $bdd->isConnected();
            break;

            case "ldap":
                // Deconnecter une potentiel autre connection ldap
                $this->ldap->disconnect();

                // Parameter la connection ldap
                $this->ldap->setHost($provider["host"]);
                $this->ldap->setPort($provider["port"]);
                $this->ldap->setUser($provider["user"]);
                $this->ldap->setPassword($provider["password"]);
                $this->ldap->setBasedn($provider["basedn"]);

                // Si connection OK
                return($this->ldap->connect());
            break;

            case "ninegate":
                // Faire appel à l'API ninegate
                $url=$provider["url"]."/rest/login";
                $key=$provider["key"];
                $response=$this->apiNinegate($url,$key,null);
                
                // Si connection OK
                if($response) return true; else return false;
            break;            
        }
    }

    public function initTest() {
        $configtest=$this->em->getRepository("App:Janus")->findOneBy([]);
        if(!$configtest) {
            $configtest=new Janus();
            $configtest->setIsvalid(false);
            $configtest->setConfig($this->configjanus);
        }
        $configtest->setConfigbackup($this->configjanus);
        $this->em->persist($configtest);
        $this->em->flush();

        $this->istest=true;
        $this->configjanus=$configtest->getConfig();
    }

    public function endTest() {
        $configtest=$this->em->getRepository("App:Janus")->findOneBy([]);
        if($configtest) {
            $this->em->remove($configtest);
            $this->em->flush();
        }

        // On supprime les répertoires temporaires functions
        $fs = new Filesystem();
        $dir=$this->container->getParameter('kernel.project_dir');
        $diradd=$dir."/config/janus/functions/add";
        $dirdel=$dir."/config/janus/functions/del";
        $fs->remove($diradd);
        $fs->remove($dirdel);

        // On stope le flage test
        $this->istest=false;

        // On repositionne les bonnes valeurs de config
        $this->configjanus=$configtest->getConfig();
    }

    public function isUpdated() {
        // Si présence de fichier fonction test il y a modification de la configuration
        $fs = new Filesystem();
        $dir=$this->container->getParameter('kernel.project_dir');
        $diradd=$dir."/config/janus/functions/add";
        $dirdel=$dir."/config/janus/functions/del";
        if($fs->exists($diradd)||$fs->exists($dirdel)) return true;

        // Sinon on regarde s'il existe une configuration de test
        $configtest=$this->em->getRepository("App:Janus")->findOneBy([]);
        if(!$configtest) {
            return false;

        }

        // La configuration est update s'il y a une différence
        return ($configtest->getConfig() != $configtest->getConfigbackup());
    }

    public function isValid() {
        $configtest=$this->em->getRepository("App:Janus")->findOneBy([]);
        if(!$configtest) {
            return false;

        }

        return $configtest->getIsValid();
    }

    public function updateConfig($config) {
        $configtest=$this->em->getRepository("App:Janus")->findOneBy([]);
        if(!$configtest) {
            $configtest=new Janus();
            $configtest->setIsvalid(false);
            $configtest->setConfigbackup($this->configjanus);
        }
        $configtest->setConfig($config);
        $this->em->persist($configtest);
        $this->em->flush();        

        return ($configtest->getConfig() != $configtest->getConfigbackup());
    }

    public function updateIsvalid($isvalid) {
        $configtest=$this->em->getRepository("App:Janus")->findOneBy([]);
        if(!$configtest) {
            $configtest=new Janus();
            $configtest->setIsvalid(false);
            $configtest->setConfigbackup($this->configjanus);
        }
        else $configtest->setIsvalid($isvalid);
        $this->em->persist($configtest);
        $this->em->flush();        
    }

    private function apiNinegate($url,$key,$query) {
        // Entete
        $headers = ['Accept' => 'application/json', 'key' => $key];
    
        // Paramétrage unirest
        \Unirest\Request::verifyPeer(false);
        \Unirest\Request::verifyHost(false);
        \Unirest\Request::timeout(5);

        // Login sans proxy
        try{
            $response = \Unirest\Request::get($url,$headers,$query);
        }
        catch (\Exception $e) {
            // On tente avec le proxy s'il y en a un
            $proxyUse = $this->container->getParameter("proxyUse");
            if($proxyUse) {
                $proxyHost = $this->getParameter("proxyHost");
                $proxyPort = $this->getParameter("proxyPort");
                \Unirest\Request::proxy($proxyHost, $proxyPort, CURLPROXY_HTTP, true);

                try{
                    $response = \Unirest\Request::get($url,$headers,$query);
                }
                catch (\Exception $e) {
                    return false;
                }
            }
            else {
                return false;
            }            
        }

        if($response->code!="200") 
            return false;

        return $response;
    }
}