<?php
    namespace App\Service;

    use Symfony\Component\DependencyInjection\ContainerInterface;
    use Symfony\Component\HttpKernel\Event\RequestEvent;
    use Symfony\Component\HttpFoundation\Session\Session;
    use Doctrine\ORM\EntityManager;

    class SessionInit {
        private $container;
        protected $em;
        protected $session;

        public function __construct(ContainerInterface $container, EntityManager $em,Session $session)
        {
            $this->container = $container;
            $this->session = $session;
            $this->em = $em;
        }

        public function onDomainParse(RequestEvent $event) {
            $configs = $this->em->getRepository("App:Config")->findAll();
            foreach($configs as $config) {
                $this->session->set($config->getId(), strval($config->getValue()));
            }
            
            // Valeur par défaut appname
            if($this->session->get("appname")=="")
                $this->session->set("appname", $this->container->getParameter('appName'));            

            // Valeur par defaut colorbgbodydark = #343a40
            if($this->session->get("colorbgbodydark")=="")
                $this->session->set("colorbgbodydark", $this->em->getRepository("App:Config")->find("colorbgbodydark")->getDefault());            

            // Valeur par defaut colorbgbodydark = #ffffff
            if($this->session->get("colorbgbodylight")=="")
                $this->session->set("colorbgbodylight",$this->em->getRepository("App:Config")->find("colorbgbodylight")->getDefault());            

            // Valeur par defaut colorfttitledark = #ffffff
            if($this->session->get("colorfttitledark")=="")
                $this->session->set("colorfttitledark", $this->em->getRepository("App:Config")->find("colorfttitledark")->getDefault());            

            // Valeur par defaut colorfttitlelight = #343a40
            if($this->session->get("colorfttitlelight")=="")
                $this->session->set("colorfttitlelight", $this->em->getRepository("App:Config")->find("colorfttitlelight")->getDefault());            

            // Valeur par defaut colorftbodydark = #ffffff
            if($this->session->get("colorftbodydark")=="")
                $this->session->set("colorftbodydark", $this->em->getRepository("App:Config")->find("colorftbodydark")->getDefault());            

            // Valeur par defaut colorftbodylight = #343a40
            if($this->session->get("colorftbodylight")=="")
                $this->session->set("colorftbodylight", $this->em->getRepository("App:Config")->find("colorftbodylight")->getDefault());            

            // Valeur par defaut fonttitle = FredokaOne-Regular
            if($this->session->get("fonttitle")=="")
                $this->session->set("fonttitle", $this->em->getRepository("App:Config")->find("fonttitle")->getDefault());            
                
            // Valeur par defaut fontbody = Roboto-Regular
            if($this->session->get("fontbody")=="")
                $this->session->set("fontbody", $this->em->getRepository("App:Config")->find("fontbody")->getDefault());            

            // Valeur par defaut fontsizeh1 = 40
            if($this->session->get("fontsizeh1")=="")
                $this->session->set("fontsizeh1", $this->em->getRepository("App:Config")->find("fontsizeh1")->getDefault());            

            // Valeur par defaut fontsizeh2 = 32
            if($this->session->get("fontsizeh2")=="")
                $this->session->set("fontsizeh2", $this->em->getRepository("App:Config")->find("fontsizeh2")->getDefault());            

            // Valeur par defaut fontsizeh3 = 28
            if($this->session->get("fontsizeh3")=="")
                $this->session->set("fontsizeh3", $this->em->getRepository("App:Config")->find("fontsizeh3")->getDefault());            

            // Valeur par defaut fontsizeh4 = 24
            if($this->session->get("fontsizeh4")=="")
                $this->session->set("fontsizeh4", $this->em->getRepository("App:Config")->find("fontsizeh4")->getDefault());            


            // Valeur par defaut logo
            if($this->session->get("logodark")==""&&$this->session->get("logolight")=="") {
                $this->session->set("logodark", "logo.png");
                $this->session->set("logolight", "logo.png");
            }
            elseif($this->session->get("logodark")=="")
                $this->session->set("logodark", $this->session->get("logolight"));
            elseif($this->session->get("logolight")=="")
                $this->session->set("logolight", $this->session->get("logodark"));

            // Calcul couleur
            $this->session->set("colorbgbodylight-darker", $this->adjustBrightness($this->session->get("colorbgbodylight"),-10));          
            $this->session->set("colorbgbodydark-darker", $this->adjustBrightness($this->session->get("colorbgbodydark"),-50)); 
            $this->session->set("colorfttitlelight-darker", $this->adjustBrightness($this->session->get("colorfttitlelight"),-50));          
            $this->session->set("colorfttitledark-darker", $this->adjustBrightness($this->session->get("colorfttitledark"),-50));          

        }

        private function adjustBrightness($hex, $steps) {
            // Steps should be between -255 and 255. Negative = darker, positive = lighter
            $steps = max(-255, min(255, $steps));
    
            // Normalize into a six character long hex string
            $hex = str_replace('#', '', $hex);
            if (strlen($hex) == 3) {
                $hex = str_repeat(substr($hex,0,1), 2).str_repeat(substr($hex,1,1), 2).str_repeat(substr($hex,2,1), 2);
            }
    
            // Split into three parts: R, G and B
            $color_parts = str_split($hex, 2);
            $return = '';
    
            foreach ($color_parts as $color) {
                $color   = hexdec($color); // Convert to decimal
                $color   = max(0,min(255,$color + $steps)); // Adjust color
                $return .= str_pad(dechex($color), 2, '0', STR_PAD_LEFT); // Make two char hex code
            }
    
            return '#'.$return;
        }
    }
