<?php

namespace Kanboard\Plugin\PhpcasAuth\Auth;

use LogicException;
use Kanboard\Core\Base;
use Kanboard\Auth\LdapAuth as LdapAuth;
use Kanboard\Core\Ldap\Client as LdapClient;
use Kanboard\Core\Ldap\ClientException as LdapException;
use Kanboard\Core\Ldap\User as LdapUser;
use Kanboard\Model\UserModel;

/**
 * Phpcas Authentication Provider
 *
 * @package  auth
 * @author   Envole
 */

class PhpcasAuthProvider extends LdapAuth
{


    /**
     * Authenticate the user
     *
     * @access public
     * @return boolean
     */
    public function authenticate()
    {
        try {

            $password = $this->getLdapPassword();
            $username = $this->getLdapUsername();
            $login    = $this->getLdapUsername();

            // Si connection non CAS
            if ($this->password != "PASSWORDCAS" && $this->getLdapUsername()!=$this->username) {
                // On se connecte sur l'annuaire en reader et on recherche le DN de l'utilisateur
                $client = LdapClient::connect($username, $password);

                // On recherche l'utilisateur
                $user = LdapUser::getUser($client, $this->username);
                if ($user === null) {
                    $this->logger->info('User ('.$this->username.') not found in LDAP server');
                    return false;
                }
                
                // On récupéure son DN comme username
                $username = $user->getDn();
                $password = $this->password;
            }

            $client = LdapClient::connect($username, $password);
            $client->setLogger($this->logger);

            $user = LdapUser::getUser($client, $this->username);

            if ($user === null) {
                $this->logger->info('User ('.$this->username.') not found in LDAP server');
                return false;
            }

            if ($user->getUsername() === '') {
                throw new LogicException('Username not found in LDAP profile, check the parameter LDAP_USER_ATTRIBUTE_USERNAME');
            }

            $this->logger->info('Authenticate this user: '.$user->getDn());


            // Auto create
            $userbdd=$this->userModel->getByUsername($this->username);
            $param=["id"=>$userbdd["id"],"username"=>$this->username];
            if(is_null($userbdd))  {
                $this->userModel->create($param);
            }
            
            // Get user BDD
            $userbdd=$this->userModel->getByUsername($this->username);
            $param=["id"=>$userbdd["id"],"username"=>$this->username,"role"=>"app-manager"];


            // Force role app-admin
            if($userbdd["role"]!="app-admin"&&in_array($this->username,ENVOLE_ADMINS)) {
                $userbdd=$this->userModel->getByUsername($this->username);
                $param=["id"=>$userbdd["id"],"role"=>"app-admin"];
                $this->userModel->update($param);
                $userbdd=$this->userModel->getByUsername($this->username);
            }

            // Force role app-manager 
            if($userbdd["role"]!="app-admin"&&$userbdd["role"]!="app-manager") {
                $userbdd=$this->userModel->getByUsername($this->username);
                $param=["id"=>$userbdd["id"],"role"=>"app-manager"];
                $this->userModel->update($param);
            }

            $this->userInfo = $user;
            return true;

        } catch (LdapException $e) {
            $this->logger->error($e->getMessage());
        }

        return false;
    }     
}
